<?php
/**
 * ַض
 * 
 * ͨķַԼض,ַַַ:'ض','ضµaction','ͼȾ'.
 * @author Qiong Wu <papa0924@gmail.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindDispatcher.php 3904 2013-01-08 07:01:26Z yishuo $
 * @package web
 */
class WindDispatcher extends WindModule {
	/**
	 * 洢ĶϢ
	 * 
	 * @var array
	 */
	protected $maxForwrd = array();
	protected $display = false;

	/**
	 * @param WindForward $forward
	 * @param WindRouter $router
	 * @param boolean $display
	 * @return void
	 */
	public function dispatch($forward, $router, $display) {
		if ($forward->getIsRedirect())
			$this->dispatchWithRedirect($forward, $router);
		elseif ($forward->getIsReAction()) {
			if (count($this->maxForwrd) > 10) {
				throw new WindFinalException(
					'[web.WindDispatcher.dispatch] more than 10 times forward request. (' . implode(', ', 
						$this->maxForwrd) . ')');
			}
			$token = $router->getModule() . '/' . $router->getController() . '/' . $router->getAction();
			array_push($this->maxForwrd, $token);
			$this->dispatchWithAction($forward, $router, $display);
		} else {
			$view = $forward->getWindView();
			if ($view->templateName) {
				$this->getResponse()->setData($forward->getVars(), $view->templateName);
				$view->render($this->display || $display);
			}
			$this->display = false;
		}
	}

	/**
	 * ضµurlַ
	 * 
	 * ضµurlַͨheadʽ¿һurl.
	 * @param WindForward $forward
	 * @param AbstractWindRouter $router
	 * @return void
	 */
	protected function dispatchWithRedirect($forward, $router) {
		if (!($_url = $forward->getUrl())) {
			$_url = $router->assemble($forward->getAction(), $forward->getArgs());
		}
		$_url = WindUrlHelper::checkUrl($_url, true);
		$this->getResponse()->sendRedirect($_url);
	}

	/**
	 * ضµaction
	 * 
	 * ض,жϵǰִй,action.һڲض,
	 * ֮ǰһЩĽ,ضǻ,ͨforwardзʵ.Ҳǲǹ̵ض,
	 * Ҳ״̬ض.
	 * @param WindForward $forward
	 * @param WindRouter $router
	 * @param boolean $display
	 * @return void
	 */
	protected function dispatchWithAction($forward, $router, $display) {
		if (!$action = $forward->getAction()) {
			throw new WindException('[web.WindDispatcher.dispatchWithAction] forward fail.', 
				WindException::ERROR_PARAMETER_TYPE_ERROR);
		}
		$this->display = $display;
		list($_a, $_c, $_m, $arg) = WindUrlHelper::resolveAction($action);
		foreach ($arg as $key => $value) {
			$_GET[$key] = $value;
		}
		foreach ($forward->getArgs() as $key => $value) {
			$_POST[$key] = $value;
		}
		
		$_a && $router->setAction($_a);
		$_c && $router->setController($_c);
		$_m && $router->setModule($_m);
		Wind::getApp()->run();
	}
}
