<?php
/**
 * ת,Я˲תϢԼϢӦÿ
 * 
 * еĲ,ĬϰһWindForward,󷵻ظöӦÿ.
 * а,Ϣ,ͼϢ,תϢϢ.
 * @author Qiong Wu <papa0924@gmail.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindForward.php 3533 2012-05-08 08:24:20Z yishuo $
 * @package web
 */
class WindForward extends WindModule {
	/**
	 * ͼ
	 * 
	 * @var WindView
	 */
	protected $windView = null;
	/**
	 * @see WindModule::_delayAttributes
	 */
	protected $_delayAttributes = array('windView' => array('ref' => 'windView'));
	/**
	 * 洢
	 * 
	 * @var array
	 */
	private $vars = array();
	/**
	 * ǷΪAction
	 * 
	 * @var boolean
	 */
	private $isReAction = false;
	/**
	 * Ƿض
	 * 
	 * @var boolean
	 */
	private $isRedirect = false;
	/**
	 * ת
	 * 
	 * @var string
	 */
	private $url;
	private $action;
	private $args = array();

	/**
	 * ضһAction
	 * 
	 * ָ֧ʽ:module/controller/action/?a=&b=&c=
	 * @param string $action $action 
	 * @param array $args  ĬΪ
	 * @param boolean $isRedirect Ƿض  ĬΪfalse
	 * @param boolean $immediately Ƿض ĬΪtrue
	 * @return void
	 * @throws WindForwardException
	 */
	public function forwardAction($action, $args = array(), $isRedirect = false, $immediately = true) {
		$this->setIsReAction(true);
		$this->setAction($action);
		$this->setArgs($args);
		$this->setIsRedirect($isRedirect);
		if ($immediately) throw new WindForwardException($this);
	}

	/**
	 * urlض
	 * 
	 * <b>head</b>ʽǰضµurlַ
	 * @param string $url ضurlַ
	 * @return void
	 * @throws WindForwardException
	 */
	public function forwardRedirect($url) {
		$this->setIsRedirect(true);
		$this->setUrl($url);
		throw new WindForwardException($this);
	}

	/**
	 * õǰforwardд洢ı
	 * 
	 * õǰforwardд洢ıõforwardебģҳбֱӷʵ
	 * @param string|array|object $vars
	 * @param string $key ĬΪַ
	 * @return void
	 */
	public function setVars($vars, $key = '', $merge = false) {
		if (!$key) {
			if (is_object($vars)) $vars = get_object_vars($vars);
			if (is_array($vars)) $this->vars = array_merge($this->vars, $vars);
		} elseif ($merge && !empty($this->vars[$key])) {
			$this->vars[$key] = WindUtility::mergeArray((array) $this->vars[$key], (array) $vars);
		} else
			$this->vars[$key] = $vars;
	}

	/**
	 * صǰforwardд洢ıϢ
	 * 
	 * صǰforwardд洢ıϢֶ֧ΪʱȫıϢ
	 * @return mixed
	 */
	public function getVars() {
		$_tmp = $this->vars;
		foreach (func_get_args() as $arg) {
			if (is_array($_tmp) && isset($_tmp[$arg]))
				$_tmp = $_tmp[$arg];
			else
				return '';
		}
		return $_tmp;
	}

	/**
	 * @return WindView
	 */
	public function getWindView() {
		if ($this->windView === null) {
			$this->_getWindView();
			$module = Wind::getApp()->getModules();
			if (isset($module['template-path'])) {
				$this->windView->templateDir = $module['template-path'];
			}
			if (isset($module['compile-path'])) {
				$this->windView->compileDir = $module['compile-path'];
			}
			if (isset($module['theme-path'])) {
				$this->windView->setThemePackage($module['theme-path']);
			}
		}
		return $this->windView;
	}

	/**
	 * @param WindView $windView
	 */
	public function setWindView($windView) {
		$this->windView = $windView;
	}

	/**
	 * @return boolean
	 */
	public function getIsRedirect() {
		return $this->isRedirect;
	}

	/**
	 * @param boolean $isRedirect
	 */
	public function setIsRedirect($isRedirect) {
		$this->isRedirect = $isRedirect;
	}

	/**
	 * @return boolean
	 */
	public function getIsReAction() {
		return $this->isReAction;
	}

	/**
	 * @param boolean $isReAction
	 */
	public function setIsReAction($isReAction) {
		$this->isReAction = $isReAction;
	}

	/**
	 * @return string
	 */
	public function getUrl() {
		return $this->url;
	}

	/**
	 * @param string $url
	 */
	public function setUrl($url) {
		$this->url = $url;
	}

	/**
	 * @return string
	 */
	public function getAction() {
		return $this->action;
	}

	/**
	 * @param string $action
	 */
	public function setAction($action) {
		$this->action = $action;
	}

	/**
	 * @return array
	 */
	public function getArgs() {
		return $this->args;
	}

	/**
	 * @param array
	 */
	public function setArgs($args) {
		$this->args = $args;
	}
}