<?php
/**
 * Request
 *
 * @author Qiong Wu <papa0924@gmail.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindHttpRequest.php 3904 2013-01-08 07:01:26Z yishuo $
 * @package http
 * @subpackage request
 */
class WindHttpRequest implements IWindRequest {
	/**
	 * ʵĶ˿ں
	 *
	 * @var int
	 */
	protected $_port = null;
	/**
	 * ·Ϣ
	 *
	 * @var string
	 */
	protected $_hostInfo = null;
	/**
	 * ͻIP
	 *
	 * @var string
	 */
	protected $_clientIp = null;
	
	/**
	 * 
	 *
	 * @var string
	 */
	protected $_language = null;
	
	/**
	 * ·Ϣ
	 *
	 * @var string
	 */
	protected $_pathInfo = null;
	
	/**
	 * Ϣ
	 *
	 * @var array
	 */
	protected $_attribute = array();
	/**
	 * űurl
	 * 
	 * @var string
	 */
	private $_scriptUrl = null;
	
	/**
	 * uri
	 * 
	 * @var string
	 */
	private $_requestUri = null;
	
	/**
	 * ·Ϣ
	 * 
	 * @var string
	 */
	private $_baseUrl = null;

	/**
	 * ʼRequest
	 *
	 */
	public function __construct() {
		$this->normalizeRequest();
	}

	/**
	 * ʼrequest
	 *
	 * ת崦
	 */
	protected function normalizeRequest() {
		if (function_exists('get_magic_quotes_gpc') && get_magic_quotes_gpc()) {
			if (isset($_GET)) $_GET = $this->_stripSlashes($_GET);
			if (isset($_POST)) $_POST = $this->_stripSlashes($_POST);
			if (isset($_REQUEST)) $_REQUEST = $this->_stripSlashes($_REQUEST);
			if (isset($_COOKIE)) $_COOKIE = $this->_stripSlashes($_COOKIE);
		}
	}
	
	/* (non-PHPdoc)
	 * @see IWindRequest::setAttribute()
	 */
	public function setAttribute($data, $key = '') {
		if ($key) {
			$this->_attribute[$key] = $data;
			return;
		}
		if (is_object($data)) $data = get_object_vars($data);
		if (is_array($data)) $this->_attribute = array_merge($this->_attribute, $data);
	}
	
	/* (non-PHPdoc)
	 * @see IWindRequest::getAttribute()
	 */
	public function getAttribute($key, $defaultValue = '') {
		if (isset($this->_attribute[$key]))
			return $this->_attribute[$key];
		else if (isset($_GET[$key]))
			return $_GET[$key];
		else if (isset($_POST[$key]))
			return $_POST[$key];
		else if (isset($_COOKIE[$key]))
			return $_COOKIE[$key];
		else if (isset($_REQUEST[$key]))
			return $_REQUEST[$key];
		else if (isset($_ENV[$key]))
			return $_ENV[$key];
		else if (isset($_SERVER[$key]))
			return $_SERVER[$key];
		else
			return $defaultValue;
	}

	/**
	 * û
	 * 
	 * $_GET,$_POSTֵ,δ򷵻$defaultValue
	 * @param string $key ȡĲname,ĬΪnull$_GET$_POSTֵ
	 * @param mixed $defaultValue ȡֵʧܵʱ򷵻ȱʡֵ,ĬֵΪnull
	 * @return mixed
	 */
	public function getRequest($key = null, $defaultValue = null) {
		if (!$key) return array_merge($_POST, $_GET);
		if (isset($_GET[$key])) return $_GET[$key];
		if (isset($_POST[$key])) return $_POST[$key];
		return $defaultValue;
	}

	/**
	 * ȡı
	 * 
	 * $_POSTֵ
	 * @param string $name ȡı,ĬΪnull,Ϊnullʱ򷵻$_POST
	 * @param string $defaultValue ȡʧܵʱ򷵻ظֵ,ĬΪnull
	 * @return mixed
	 */
	public function getPost($name = null, $defaultValue = null) {
		if ($name === null) return $_POST;
		return isset($_POST[$name]) ? $_POST[$name] : $defaultValue;
	}

	/**
	 * $_GETֵ
	 * 
	 * @param string $name ȡı,ĬΪִ,ֵΪnullʱ򽫷$_GET
	 * @param string $defaultValue ȡıڵʱ򷵻ظȱʡֵ,ĬֵΪnull
	 * @return mixed
	 */
	public function getGet($name = '', $defaultValue = null) {
		if ($name === null) return $_GET;
		return (isset($_GET[$name])) ? $_GET[$name] : $defaultValue;
	}

	/**
	 * cookieֵ
	 * 
	 * $name=null򷵻Cookieֵ
	 * @param string $name ȡı,ֵΪnull򷵻$_COOKIE,ĬΪnull
	 * @param string $defaultValue ȡʧܵʱ򷵻ظֵ,ĬϸֵΪnull
	 * @return mixed
	 */
	public function getCookie($name = null, $defaultValue = null) {
		if ($name === null) return $_COOKIE;
		return (isset($_COOKIE[$name])) ? $_COOKIE[$name] : $defaultValue;
	}

	/**
	 * sessionֵ
	 * 
	 * $name=null򷵻SESSIONֵ
	 * @param string $name ȡı,ֵΪnull򷵻$_SESSION,ĬΪnull
	 * @param string $defaultValue ȡʧܵʱ򷵻ظֵ,ĬϸֵΪnull
	 * @return mixed
	 */
	public function getSession($name = null, $defaultValue = null) {
		if ($name === null) return $_SESSION;
		return (isset($_SESSION[$name])) ? $_SESSION[$name] : $defaultValue;
	}

	/**
	 * Serverֵ
	 * 
	 * $nameΪ򷵻Serverֵ
	 * @param string $name ȡı,ֵΪnull򷵻$_SERVER,ĬΪnull
	 * @param string $defaultValue ȡʧܵʱ򷵻ظֵ,ĬϸֵΪnull
	 * @return mixed
	 */
	public function getServer($name = null, $defaultValue = null) {
		if ($name === null) return $_SERVER;
		return (isset($_SERVER[$name])) ? $_SERVER[$name] : $defaultValue;
	}

	/**
	 * ENVֵ
	 * 
	 * $nameΪnull򷵻$_ENVֵ
	 * @param string $name ȡı,ֵΪnull򷵻$_ENV,ĬΪnull
	 * @param string $defaultValue ȡʧܵʱ򷵻ظֵ,ĬϸֵΪnull
	 * @return mixed
	 */
	public function getEnv($name = null, $defaultValue = null) {
		if ($name === null) return $_ENV;
		return (isset($_ENV[$name])) ? $_ENV[$name] : $defaultValue;
	}

	/**
	 * ȡЭ
	 * 
	 * ǰȫ򷵻https򷵻http
	 * @return string 
	 */
	public function getScheme() {
		return ($this->getServer('HTTPS') == 'on') ? 'https' : 'http';
	}

	/**
	 * ҳʱͨЭƺͰ汾
	 * @return string
	 */
	public function getProtocol() {
		return $this->getServer('SERVER_PROTOCOL', 'HTTP/1.0');
	}

	/**
	 * طIP
	 * 
	 * ȡIPʧ,򷵻0.0.0.0
	 * @return string 
	 */
	public function getClientIp() {
		if (!$this->_clientIp) $this->_getClientIp();
		return $this->_clientIp;
	}

	/**
	 * ķ
	 * 
	 * POST\GET\DELETEHTTPʽ
	 * @return string 
	 */
	public function getRequestMethod() {
		return strtoupper($this->getServer('REQUEST_METHOD'));
	}

	/**
	 * 
	 * 
	 * web󽫷web
	 * @return string  
	 */
	public function getRequestType() {
		return 'web';
	}

	/**
	 * ظǷΪajax
	 * 
	 * ajax󽫷true,򷵻false
	 * @return boolean 
	 */
	public function getIsAjaxRequest() {
		return !strcasecmp($this->getServer('HTTP_X_REQUESTED_WITH'), 'XMLHttpRequest');
	}

	/**
	 * ǷʹõHTTPSȫ
	 * 
	 * ǰȫ򷵻true򷵻false
	 * @return boolean
	 */
	public function isSecure() {
		return !strcasecmp($this->getServer('HTTPS'), 'on');
	}

	/**
	 * ǷΪGET
	 * 
	 * GETʽ򷵻true򷵻false
	 * @return boolean 
	 */
	public function isGet() {
		return !strcasecmp($this->getRequestMethod(), 'GET');
	}

	/**
	 * ǷΪPOST
	 * 
	 * POSTʽ򷵻true,򷵻false
	 * 
	 * @return boolean
	 */
	public function isPost() {
		return !strcasecmp($this->getRequestMethod(), 'POST');
	}

	/**
	 * ǷΪPUT
	 * 
	 * PUTʽ򷵻true,򷵻false
	 * 
	 * @return boolean
	 */
	public function isPut() {
		return !strcasecmp($this->getRequestMethod(), 'PUT');
	}

	/**
	 * ǷΪDELETE
	 * 
	 * DELETEʽ򷵻true,򷵻false
	 * 
	 * @return boolean
	 */
	public function isDelete() {
		return !strcasecmp($this->getRequestMethod(), 'Delete');
	}

	/**
	 * ʼԴʶ
	 * 
	 * uriȥЭ
	 * <pre>Example:
	 *  http://www.phpwind.net/example/index.php?a=test
	 * 򷵻: /example/index.php?a=test
	 * </pre>
	 * 
	 * @return string 
	 * @throws WindException ȡʧܵʱ׳쳣
	 */
	public function getRequestUri() {
		if (!$this->_requestUri) $this->_initRequestUri();
		return $this->_requestUri;
	}

	/**
	 * صǰִнűľ·
	 * 
	 * <pre>Example:
	 * : http://www.phpwind.net/example/index.php?a=test
	 * : /example/index.php
	 * </pre>
	 * 
	 * @return string
	 * @throws WindException ȡʧܵʱ׳쳣
	 */
	public function getScriptUrl() {
		if (!$this->_scriptUrl) $this->_initScriptUrl();
		return $this->_scriptUrl;
	}

	/**
	 * ִнű
	 * 
	 * <pre>Example:
	 * : http://www.phpwind.net/example/index.php?a=test
	 * : index.php
	 * </pre>
	 * 
	 * @return string
	 * @throws WindException ȡʧܵʱ׳쳣
	 */
	public function getScript() {
		if (($pos = strrpos($this->getScriptUrl(), '/')) === false) $pos = -1;
		return substr($this->getScriptUrl(), $pos + 1);
	}

	/**
	 * ȡHttpͷϢ
	 * 
	 * @param string $header ͷ
	 * @param string $default ȡʧܽظֵ,ĬΪnull
	 * @return string
	 */
	public function getHeader($header, $default = null) {
		$temp = strtoupper(str_replace('-', '_', $header));
		if (substr($temp, 0, 5) != 'HTTP_') $temp = 'HTTP_' . $temp;
		if (($header = $this->getServer($temp)) != null) return $header;
		if (function_exists('apache_request_headers')) {
			$headers = apache_request_headers();
			if ($headers[$header]) return $headers[$header];
		}
		return $default;
	}

	/**
	 * ذɿͻṩġʵű֮ڲѯ䣨query string֮ǰ·Ϣ
	 * 
	 * <pre>Example:
	 * : http://www.phpwind.net/example/index.php?a=test
	 * : a=test
	 * </pre>
	 * 
	 * @see IWindRequest::getPathInfo()
	 * @return string
	 * @throws WindException
	 */
	public function getPathInfo() {
		if (!$this->_pathInfo) $this->_initPathInfo();
		return $this->_pathInfo;
	}

	/**
	 * ȡURL
	 * 
	 * ȥ˽űļԼʲϢURLַϢ:
	 * 
	 * <pre>Example:
	 * : http://www.phpwind.net/example/index.php?a=test 
	 * 1]: $absolute = false
	 * أ example    
	 * 2]: $absolute = true:
	 * أ http://www.phpwind.net/example
	 * </pre>
	 * @param boolean $absolute Ƿ񷵻Ϣ
	 * @return string
	 * @throws WindException Ϣʧܵʱ׳쳣
	 */
	public function getBaseUrl($absolute = false) {
		if ($this->_baseUrl === null) $this->_baseUrl = rtrim(dirname($this->getScriptUrl()), '\\/.');
		return $absolute ? $this->getHostInfo() . $this->_baseUrl : $this->_baseUrl;
	}

	/**
	 * ϢЭϢʶ˿Ϣ
	 * 
	 * <pre>Example:
	 * : http://www.phpwind.net/example/index.php?a=test
	 * أ http://www.phpwind.net/
	 * </pre>
	 * @see IWindRequest::getHostInfo()
	 * @return string
	 * @throws WindException ȡϢʧܵʱ׳쳣
	 */
	public function getHostInfo() {
		if ($this->_hostInfo === null) $this->_initHostInfo();
		return $this->_hostInfo;
	}

	/**
	 * صǰнűڵķ
	 * 
	 * ű
	 * Ǹõֵ
	 * @return string
	 */
	public function getServerName() {
		return $this->getServer('SERVER_NAME', '');
	}
	
	/* (non-PHPdoc)
	 * @see IWindRequest::getServerPort()
	 */
	public function getServerPort() {
		if (!$this->_port) {
			$_default = $this->isSecure() ? 443 : 80;
			$this->setServerPort($this->getServer('SERVER_PORT', $_default));
		}
		return $this->_port;
	}

	/**
	 * ÷˿ں
	 * 
	 * httpsӵĬ϶˿ںΪ443
	 * httpӵĬ϶˿ںΪ80
	 * @param int $port õĶ˿ں
	 */
	public function setServerPort($port) {
		$this->_port = (int) $port;
	}

	/**
	 * ǰҳû
	 * 
	 * DNS û REMOTE_ADDR
	 * 
	 * @return string
	 */
	public function getRemoteHost() {
		return $this->getServer('REMOTE_HOST');
	}

	/**
	 * Refererͷ
	 * 
	 * ÷˽׷ٷԴURLַ
	 * 
	 * @return string
	 */
	public function getUrlReferer() {
		return $this->getServer('HTTP_REFERER');
	}

	/**
	 * ûӵ Web ʹõĶ˿ں
	 * 
	 * @return number
	 */
	public function getRemotePort() {
		return $this->getServer('REMOTE_PORT');
	}

	/**
	 * User-Agentͷֶָͻ˳ͺ
	 * 
	 * ͻһֳնˣͷһWMLļֿͻһͨ
	 * 򷵻ͨHTMLļ
	 * 
	 * @return string
	 */
	public function getUserAgent() {
		return $this->getServer('HTTP_USER_AGENT', '');
	}

	/**
	 * صǰͷ Accept: ݣ
	 * 
	 * Acceptͷֶָͻ˳ܹMIMEͣ text/html,image/*
	 * 
	 * @return string
	 */
	public function getAcceptTypes() {
		return $this->getServer('HTTP_ACCEPT', '');
	}

	/**
	 * ؿͻ˳ܹнݱ뷽ʽ
	 * 
	 * ı뷽ʽָͨĳѹʽ
	 * @return string|''
	 */
	public function getAcceptCharset() {
		return $this->getServer('HTTP_ACCEPT_ENCODING', '');
	}
	
	/* (non-PHPdoc)
	 * @see IWindRequest::getAcceptLanguage()
	 */
	public function getAcceptLanguage() {
		if (!$this->_language) {
			$_language = explode(',', $this->getServer('HTTP_ACCEPT_LANGUAGE', ''));
			$this->_language = $_language[0] ? $_language[0] : 'zh-cn';
		}
		return $this->_language;
	}

	/**
	 * طʵIPַ
	 * 
	 * <pre>Example:
	 * أ127.0.0.1
	 * </pre>
	 * @return string 
	 */
	private function _getClientIp() {
		if (($ip = $this->getServer('HTTP_CLIENT_IP')) != null) {
			$this->_clientIp = $ip;
		} elseif (($_ip = $this->getServer('HTTP_X_FORWARDED_FOR')) != null) {
			$ip = strtok($_ip, ',');
			do {
				$ip = ip2long($ip);
				if (!(($ip == 0) || ($ip == 0xFFFFFFFF) || ($ip == 0x7F000001) || (($ip >= 0x0A000000) && ($ip <= 0x0AFFFFFF)) || (($ip >= 0xC0A8FFFF) && ($ip <= 0xC0A80000)) || (($ip >= 0xAC1FFFFF) && ($ip <= 0xAC100000)))) {
					$this->_clientIp = long2ip($ip);
					return;
				}
			} while (($ip = strtok(',')));
		} elseif (($ip = $this->getServer('HTTP_PROXY_USER')) != null) {
			$this->_clientIp = $ip;
		} elseif (($ip = $this->getServer('REMOTE_ADDR')) != null) {
			$this->_clientIp = $ip;
		} else {
			$this->_clientIp = "0.0.0.0";
		}
	}

	/**
	 * ʼԴʶ
	 * 
	 * <pre>uriȥЭ
	 * Example:
	 *  http://www.phpwind.net/example/index.php?a=test
	 * 򷵻: /example/index.php?a=test
	 * </pre>
	 * @throws WindException ׳쳣
	 */
	private function _initRequestUri() {
		if (($requestUri = $this->getServer('HTTP_X_REWRITE_URL')) != null) {
			$this->_requestUri = $requestUri;
		} elseif (($requestUri = $this->getServer('REQUEST_URI')) != null) {
			$this->_requestUri = $requestUri;
			if (strpos($this->_requestUri, $this->getServer('HTTP_HOST')) !== false) $this->_requestUri = preg_replace(
				'/^\w+:\/\/[^\/]+/', '', $this->_requestUri);
		} elseif (($requestUri = $this->getServer('ORIG_PATH_INFO')) != null) {
			$this->_requestUri = $requestUri;
			if (($query = $this->getServer('QUERY_STRING')) != null) $this->_requestUri .= '?' . $query;
		} else
			throw new WindException('[web.WindHttpRequest._initRequestUri] unable to determine the request URI.');
	}

	/**
	 * صǰִнűľ·
	 * 
	 * <pre>Example:
	 * : http://www.phpwind.net/example/index.php?a=test
	 * : /example/index.php
	 * </pre>
	 * @throws WindException ȡʧܵʱ׳쳣
	 */
	private function _initScriptUrl() {
		if (($scriptName = $this->getServer('SCRIPT_FILENAME')) == null) {
			throw new WindException('[web.WindHttpRequest._initScriptUrl] determine the entry script URL failed!!!');
		}
		$scriptName = basename($scriptName);
		if (($_scriptName = $this->getServer('SCRIPT_NAME')) != null && basename($_scriptName) === $scriptName) {
			$this->_scriptUrl = $_scriptName;
		} elseif (($_scriptName = $this->getServer('PHP_SELF')) != null && basename($_scriptName) === $scriptName) {
			$this->_scriptUrl = $_scriptName;
		} elseif (($_scriptName = $this->getServer('ORIG_SCRIPT_NAME')) != null && basename($_scriptName) === $scriptName) {
			$this->_scriptUrl = $_scriptName;
		} elseif (($pos = strpos($this->getServer('PHP_SELF'), '/' . $scriptName)) !== false) {
			$this->_scriptUrl = substr($this->getServer('SCRIPT_NAME'), 0, $pos) . '/' . $scriptName;
		} elseif (($_documentRoot = $this->getServer('DOCUMENT_ROOT')) != null && ($_scriptName = $this->getServer(
			'SCRIPT_FILENAME')) != null && strpos($_scriptName, $_documentRoot) === 0) {
			$this->_scriptUrl = str_replace('\\', '/', str_replace($_documentRoot, '', $_scriptName));
		} else
			throw new WindException('[web.WindHttpRequest._initScriptUrl] determine the entry script URL failed!!');
	}

	/**
	 * ϢЭϢʶ˿Ϣ
	 * 
	 * <pre>Example:
	 * : http://www.phpwind.net/example/index.php?a=test
	 * أ http://www.phpwind.net/
	 * </pre>
	 * @throws WindException ȡϢʧܵʱ׳쳣
	 */
	private function _initHostInfo() {
		$http = $this->isSecure() ? 'https' : 'http';
		if (($httpHost = $this->getServer('HTTP_HOST')) != null)
			$this->_hostInfo = $http . '://' . $httpHost;
		elseif (($httpHost = $this->getServer('SERVER_NAME')) != null) {
			$this->_hostInfo = $http . '://' . $httpHost;
			if (($port = $this->getServerPort()) != null) $this->_hostInfo .= ':' . $port;
		} else
			throw new WindException('[web.WindHttpRequest._initHostInfo] determine the entry script URL failed!!');
	}

	/**
	 * ذɿͻṩġʵű֮ڲѯ䣨query string֮ǰ·Ϣ
	 * 
	 * <pre>Example:
	 * : http://www.phpwind.net/example/index.php?a=test
	 * : a=test
	 * </pre>
	 * @throws WindException
	 */
	private function _initPathInfo() {
		$requestUri = $this->getRequestUri();
		$scriptUrl = $this->getScriptUrl();
		$baseUrl = $this->getBaseUrl();
		if (strpos($requestUri, $scriptUrl) === 0)
			$pathInfo = substr($requestUri, strlen($scriptUrl));
		elseif ($baseUrl === '' || strpos($requestUri, $baseUrl) === 0)
			$pathInfo = substr($requestUri, strlen($baseUrl));
		elseif (strpos($_SERVER['PHP_SELF'], $scriptUrl) === 0)
			$pathInfo = substr($_SERVER['PHP_SELF'], strlen($scriptUrl));
		else
			throw new WindException('[web.WindHttpRequest._initPathInfo] determine the entry path info failed!!');
		if (($pos = strpos($pathInfo, '?')) !== false) $pathInfo = substr($pathInfo, $pos + 1);
		$this->_pathInfo = trim($pathInfo, '/');
	}

	/**
	 * stripslashesתַ
	 *
	 * @param array|string $data ת
	 * @return array|string ת֮
	 */
	private function _stripSlashes(&$data) {
		return is_array($data) ? array_map(array($this, '_stripSlashes'), $data) : stripslashes($data);
	}
}