<?php
/**
 * ,û.
 * 
 * һ󷽷ΪĬϴûĲʵ'run',ûͨʵָ÷
 * @author Qiong Wu <papa0924@gmail.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindSimpleController.php 3859 2012-12-18 09:25:51Z yishuo $
 * @package web
 */
abstract class WindSimpleController extends WindModule implements IWindController {
	/**
	 *
	 * @var WindForward
	 */
	protected $forward = null;
	/**
	 *
	 * @var WindErrorMessage
	 */
	protected $errorMessage = null;
	/**
	 *
	 * @var WindHttpRequest
	 */
	protected $request = null;
	/**
	 *
	 * @var WindHttpResponse
	 */
	protected $response = null;

	/**
	 * ĬϵĲ
	 * 
	 * @return void
	 */
	abstract public function run();
	
	/*
	 * (non-PHPdoc) @see IWindController::doAction()
	 */
	public function doAction($handlerAdapter) {
		$this->beforeAction($handlerAdapter);
		$this->setDefaultTemplateName($handlerAdapter);
		$method = $this->resolvedActionMethod($handlerAdapter);
		$this->$method();
		if ($this->errorMessage !== null) $this->getErrorMessage()->sendError();
		$this->afterAction($handlerAdapter);
		return $this->forward;
	}

	/**
	 * token
	 * 
	 * @return void
	 */
	protected function saveToken($tokenName = 'token') {
		/* @var $token WindSecurityToken */
		$token = Wind::getComponent('windToken');
		return $token->saveToken($tokenName);
	}

	/**
	 * ֤
	 * 
	 * @param string $tokenValue ǰõtokenֵ
	 * @param string $tokenName token
	 * @return void
	 */
	protected function validateToken($tokenValue, $tokenName = 'token') {
		/* @var $token WindSecurityToken */
		$token = Wind::getComponent('windToken');
		return $token->validateToken($tokenValue, $tokenName);
	}

	/**
	 * actionԲ
	 * 
	 * @example <pre>
	 *          $filters = array(array('expression'=>'', 'class'=>'',
	 *          args=array()));
	 *          </pre>
	 * @param array $filters
	 * @return void
	 */
	protected function resolveActionFilter($filters) {
		if (!$filters) return;
		$chain = WindFactory::createInstance('WindHandlerInterceptorChain');
		$args = array($this->getForward(), $this->getErrorMessage(), null);
		foreach ((array) $filters as $value) {
			$chain->addInterceptors(
				WindFactory::createInstance(Wind::import($value['class']), 
					(empty($value['args']) ? $args : array_merge($args, array($value['args'])))));
		}
		$chain->getHandler()->handle();
	}

	/**
	 * actionʼǰ
	 * 
	 * @param AbstractWindRouter $handlerAdapter
	 */
	protected function beforeAction($handlerAdapter) {}

	/**
	 * action
	 * 
	 * @param AbstractWindRouter $handlerAdapter
	 */
	protected function afterAction($handlerAdapter) {}

	/**
	 * ضһaction
	 * 
	 * @param string $action ָ֧ʽ:module/controller/action/?args
	 * @param array $args Ϣ ĬΪ
	 * @param boolean $isRedirect Ƿض urlضʽת
	 * @param boolean $immediately Ƿforward
	 * @return void
	 */
	protected function forwardAction($action, $args = array(), $isRedirect = false, $immediately = true) {
		$this->getForward()->forwardAction($action, $args, $isRedirect, $immediately);
	}

	/**
	 * ضһURL
	 * 
	 * @param string $url
	 * @return void
	 */
	protected function forwardRedirect($url) {
		$this->getForward()->forwardRedirect($url);
	}
	
	/* ݴ */
	/**
	 * ģ
	 * 
	 * @param string|array|object $data
	 * @param string $key
	 * @return void
	 */
	protected function setOutput($data, $key = '') {
		$this->getForward()->setVars($data, $key);
	}

	/**
	 * 
	 * ˻ص򷵻:һֵvalue;ڶֵ֤
	 * 
	 * @param string $name input name
	 * @param string $type input type (GET POST COOKIE)
	 * @return array string
	 */
	protected function getInput($name, $type = '', $bindKey = false) {
		if (is_array($name)) {
			$result = array();
			foreach ($name as $key => $value) {
				$_k = $bindKey ? $value : $key;
				$result[$_k] = $this->getInput($value, $type);
			}
			return $result;
		} elseif ($name) {
			$value = '';
			switch (strtolower($type)) {
				case 'get':
					$value = $this->getRequest()->getGet($name);
					break;
				case 'post':
					$value = $this->getRequest()->getPost($name);
					break;
				case 'cookie':
					$value = $this->getRequest()->getCookie($name);
					break;
				default:
					$value = $this->getRequest()->getRequest($name);
			}
			return $value;
		}
		return '';
	}
	
	/* ģ崦 */
	/**
	 * ҳģ
	 * 
	 * @param string $template
	 * @return void
	 */
	protected function setTemplate($template) {
		$this->getForward()->getWindView()->templateName = $template;
	}

	/**
	 * ģ·,ģĿ¼ַ,֧ռ䷽ʽ
	 * 
	 * @param string $templatePath
	 * @return void
	 */
	protected function setTemplatePath($templatePath) {
		$this->getForward()->getWindView()->templateDir = $templatePath;
	}

	/**
	 * ģļչ
	 * 
	 * @param string $templateExt
	 * @return void
	 */
	protected function setTemplateExt($templateExt) {
		$this->getForward()->getWindView()->templateExt = $templateExt;
	}

	/**
	 * õǰϢ
	 * 
	 * @param string $theme
	 * @return void
	 */
	protected function setTheme($theme, $package) {
		$this->getForward()->getWindView()->setTheme($theme, $package);
	}

	/**
	 * òҳ
	 * 
	 * @param string $layout
	 * @return void
	 */
	protected function setLayout($layout) {
		$this->getForward()->getWindView()->layout = $layout;
	}
	
	/*  */
	/**
	 * ӴϢ
	 * 
	 * @param string $message
	 * @param string $key ĬΪַ
	 * @return void
	 */
	protected function addMessage($message, $key = '') {
		$this->getErrorMessage()->addError($message, $key);
	}

	/**
	 * һ
	 * 
	 * @param string $message ĬΪַ
	 * @param string $key ĬΪַ
	 * @param string $errorAction ĬΪַ
	 * @return void
	 */
	protected function showMessage($message = '', $key = '', $errorAction = '') {
		$this->addMessage($message, $key);
		$errorAction && $this->getErrorMessage()->setErrorAction($errorAction);
		$this->getErrorMessage()->sendError();
	}

	/**
	 * Ĭϵģ
	 * 
	 * @param WindUrlBasedRouter $handlerAdapter
	 * @return void
	 */
	protected function setDefaultTemplateName($handlerAdapter) {}

	/**
	 * action
	 * ͨǸ÷,ıaction
	 * 
	 * @param WindUrlBasedRouter $handlerAdapter
	 * @return string ؽaction,Ĭֻrun
	 */
	protected function resolvedActionMethod($handlerAdapter) {
		return 'run';
	}

	/**
	 *
	 * @return WindForward
	 */
	public function getForward() {
		return $this->_getForward();
	}

	/**
	 *
	 * @return WindErrorMessage
	 */
	public function getErrorMessage() {
		return $this->_getErrorMessage();
	}

	/**
	 *
	 * @param WindForward $forward
	 */
	public function setForward($forward) {
		$this->forward = $forward;
	}

	/**
	 *
	 * @param WindErrorMessage $errorMessage
	 */
	public function setErrorMessage($errorMessage) {
		$this->errorMessage = $errorMessage;
	}
}
?>