<?php

class Bootstrap extends Zend_Application_Bootstrap_Bootstrap
{
    /**
     *
     * @var Zend_Controller_Front
     */
    private $front;
    
	function _initErrorReport(){
		$this->bootstrap('frontController');
		$frontController = $this->getResource('frontController');
		$this->front = $frontController;
		$showException = false;
		$frontController->throwExceptions($showException);
	}
	
	function _initMyErrorHandler(){
		$this->front->registerPlugin(new My_Controller_Plugin_MyErrorHandler());
	}
	
	function _initSetHtml(){
		$view = new Zend_View();   
		$viewRenderer = Zend_Controller_Action_HelperBroker::getStaticHelper('viewRenderer');   
		$viewRenderer->setView($view)->setViewSuffix('php'); 
	}
	
	function _initHelper(){
		Zend_Controller_Action_HelperBroker::addPath(ROOT_LIB . "/My/Controller/Action/Helper", "My_Controller_Action_Helper");
	}
	
	function _initSession(){
		$sessionHandle = getSysData("session.handle");
		if($sessionHandle == "memcache"){
			$sessionDomain = getSysData("session.domain");
			ini_set("session.cookie_domain", $sessionDomain);
			$options = $this->getOptions();
			$memConfig = array(
			    'memcached'=> getSysData("cache.memcache.server"),
			    'lifetime' => getSysData("cache.memcache.lifetime")
			);
			
			Zend_Session::setSaveHandler(new My_Controller_Plugin_Memcached($memConfig));
	      }elseif($sessionHandle == "db"){
			$session = Home::service()->getSession();
			session_set_save_handler(
			    array(&$session,'open'),
			    array(&$session,'close'),
			    array(&$session,'read'),
			    array(&$session,'write'),
			    array(&$session,'destroy'),
			    array(&$session,'gc')
			);
		 }
		Zend_Session::start();
	}
	
	#app导入
	function _initControllers()
    {
        $obj = Admin::dao()->getAppinfo();
    	$appsInfo = fileCached("data/_apps_/appinfo.php", array($obj, "gets"));
    	if($appsInfo){
    	    $adminCommonService = new Admin_Service_Common();
    		foreach($appsInfo as $v){
    			if($adminCommonService->isCoreApp($v['name'])){
                	continue;
    			}
    			if(!$v['state']){
    			    $this->front->removeControllerDirectory($v['name']);
    			}else{
    			    $this->front->addControllerDirectory(APPLICATION_PATH . DS . "{$v['name']}/controllers", $v['name']);   
    			}
    		}
    	}
    }
    
}

