/*Table structure for table `admin_actions` */

DROP TABLE IF EXISTS `admin_actions`;

CREATE TABLE `admin_actions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `action` varchar(50) NOT NULL DEFAULT '0',
  `controller` varchar(50) NOT NULL DEFAULT '0',
  `app` varchar(50) NOT NULL DEFAULT '0',
  `name` varchar(50) NOT NULL DEFAULT '0',
  `path` varchar(100) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='权限表';

/*Table structure for table `admin_appinfo` */

DROP TABLE IF EXISTS `admin_appinfo`;

CREATE TABLE `admin_appinfo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '0',
  `version` varchar(50) NOT NULL DEFAULT '0',
  `author` varchar(50) NOT NULL DEFAULT '0',
  `view_name` varchar(50) NOT NULL DEFAULT '0',
  `path` varchar(100) NOT NULL DEFAULT '0',
  `state` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

insert  into `admin_appinfo`(`id`,`name`,`version`,`author`,`view_name`,`path`,`state`) values (1,'ask','1.0','半仙','问答','\\apps\\ask\\',1),(2,'group','1.0','半仙','小组','\\apps\\group\\',1),(3,'search','1.0','kaihui','搜索','\\apps\\search\\',1),(4,'site','1.0','kaihui','CMS','\\apps\\site\\',1),(5,'install','1.0','半仙','安装','\\apps\\install\\',0),(6,'admin','1.0','半仙','后台','\\apps\\admin\\',0),(7,'home','1.0','半仙','前台入口','\\apps\\home\\',0),(8,'msg','1.0','半仙','消息','\\apps\\msg\\',0),(9,'user','1.0','半仙','用户','\\apps\\user\\',0),(10,'video','1.0','半仙','视频','\\apps\\video\\',1);

/*Table structure for table `admin_masterrole` */

DROP TABLE IF EXISTS `admin_masterrole`;

CREATE TABLE `admin_masterrole` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `role_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='角色人员映射表';

/*Table structure for table `admin_menu` */

DROP TABLE IF EXISTS `admin_menu`;

CREATE TABLE `admin_menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '0',
  `url` varchar(100) NOT NULL DEFAULT '0',
  `pid` int(11) NOT NULL DEFAULT '0',
  `fsort` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `admin_roleaction` */

DROP TABLE IF EXISTS `admin_roleaction`;

CREATE TABLE `admin_roleaction` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `action_id` int(11) NOT NULL DEFAULT '0',
  `role_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='角色权限映射表';

/*Table structure for table `admin_roles` */

DROP TABLE IF EXISTS `admin_roles`;

CREATE TABLE `admin_roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='角色表';

/*Table structure for table `ask_arc` */

DROP TABLE IF EXISTS `ask_arc`;

CREATE TABLE `ask_arc` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(500) NOT NULL DEFAULT '0',
  `uid` int(11) NOT NULL DEFAULT '0',
  `follow_count` int(11) NOT NULL DEFAULT '0',
  `answer_count` int(11) NOT NULL DEFAULT '0',
  `is_publish` tinyint(1) NOT NULL DEFAULT '0',
  `tag1` int(11) NOT NULL,
  `tag2` int(11) NOT NULL,
  `tag3` int(11) NOT NULL,
  `created_at` datetime NOT NULL,
  `last_action_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `tag_path` varchar(100) NOT NULL DEFAULT '0',
  `tag_name_path` varchar(200) NOT NULL DEFAULT '0',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `ask_follow_log` */

DROP TABLE IF EXISTS `ask_follow_log`;

CREATE TABLE `ask_follow_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT '0',
  `arc_id` int(11) NOT NULL DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

/*Table structure for table `ask_reply_log` */

DROP TABLE IF EXISTS `ask_reply_log`;

CREATE TABLE `ask_reply_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT '0',
  `reply_id` int(11) NOT NULL DEFAULT '0',
  `reply_type` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0踩，1顶',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `ask_tag` */

DROP TABLE IF EXISTS `ask_tag`;

CREATE TABLE `ask_tag` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `ask_count` int(11) NOT NULL DEFAULT '0',
  `follow_count` int(11) NOT NULL DEFAULT '0',
  `tree_id` int(11) NOT NULL DEFAULT '0',
  `uid` int(11) NOT NULL DEFAULT '0',
  `descr` varchar(400) NOT NULL,
  `tag_sort` int(11) NOT NULL DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `uid` (`uid`),
  KEY `tree_id` (`tree_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `ask_tag_follow` */

DROP TABLE IF EXISTS `ask_tag_follow`;

CREATE TABLE `ask_tag_follow` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT '0',
  `tag` varchar(100) NOT NULL DEFAULT '0',
  `tag_id` int(11) NOT NULL DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `tag` (`tag`),
  KEY `tag_id` (`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `ask_tree` */

DROP TABLE IF EXISTS `ask_tree`;

CREATE TABLE `ask_tree` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '0',
  `tag_count` int(11) NOT NULL DEFAULT '0',
  `tree_sort` int(11) NOT NULL DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `group_arc` */

DROP TABLE IF EXISTS `group_arc`;

CREATE TABLE `group_arc` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `group_id` int(11) NOT NULL DEFAULT '0',
  `uid` int(11) NOT NULL DEFAULT '0',
  `reply_count` int(11) NOT NULL DEFAULT '0',
  `view_count` int(11) NOT NULL DEFAULT '0' COMMENT '访问量',
  `recommend_count` int(11) NOT NULL DEFAULT '0' COMMENT '推荐数目',
  `is_publish` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0未发布，草稿，1已发布',
  `position` varchar(10) NOT NULL DEFAULT '0' COMMENT '1首页推荐,2群组推荐,格式类似,1,2,',
  `arc_type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1私密帖子，0普通',
  `created_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_action_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '最后回应，包括修改等',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `group_id` (`group_id`),
  KEY `uid` (`uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `group_info` */

DROP TABLE IF EXISTS `group_info`;

CREATE TABLE `group_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '0',
  `descr` text NOT NULL,
  `apply_result` text NOT NULL COMMENT '申请理由',
  `contact` varchar(300) NOT NULL,
  `uid` int(11) NOT NULL DEFAULT '0',
  `face` varchar(200) NOT NULL DEFAULT '0',
  `tree_id` int(11) NOT NULL DEFAULT '0',
  `user_number` int(11) NOT NULL DEFAULT '0',
  `arc_count` int(11) NOT NULL DEFAULT '0',
  `group_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0,关闭,1,开启',
  `group_type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0公开小组，1私密小组',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `created_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `group_recommend_log` */

DROP TABLE IF EXISTS `group_recommend_log`;

CREATE TABLE `group_recommend_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT '0',
  `arc_id` int(11) NOT NULL DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `group_tree` */

DROP TABLE IF EXISTS `group_tree`;

CREATE TABLE `group_tree` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '0',
  `tree_sort` int(2) NOT NULL DEFAULT '0',
  `group_count` int(11) NOT NULL DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

/*Table structure for table `group_user` */

DROP TABLE IF EXISTS `group_user`;

CREATE TABLE `group_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT '0',
  `group_id` int(11) NOT NULL DEFAULT '0',
  `user_type` int(11) NOT NULL DEFAULT '0' COMMENT '9为管理员,10创始人',
  `post_num` int(11) NOT NULL DEFAULT '0' COMMENT '小组帖子数目',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `is_shutup` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1，屏蔽发言',
  PRIMARY KEY (`id`),
  KEY `group_id` (`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `home_arc` */

DROP TABLE IF EXISTS `home_arc`;

CREATE TABLE `home_arc` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mark` varchar(100) NOT NULL DEFAULT '0',
  `arc_type` varchar(30) NOT NULL DEFAULT '0',
  `ref_id` int(11) NOT NULL DEFAULT '0',
  `content` text NOT NULL,
  `created_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `arc_type` (`arc_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `home_area` */

DROP TABLE IF EXISTS `home_area`;

CREATE TABLE `home_area` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `pid` int(11) NOT NULL DEFAULT '0' COMMENT '地域id－父id',
  `name` varchar(50) NOT NULL DEFAULT '0' COMMENT '地域名称',
  `name_path` varchar(256) NOT NULL DEFAULT '0' COMMENT '地域名字路径',
  `path` varchar(256) NOT NULL DEFAULT '0' COMMENT '地域ID路径',
  `level` tinyint(4) NOT NULL DEFAULT '0' COMMENT '级别标识，暂不用',
  `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT '删除标识，1－正常；0－删除',
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`) ,
  KEY `level` (`level`),
  KEY `name` (`name`) 
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

/*Table structure for table `home_reply` */

DROP TABLE IF EXISTS `home_reply`;

CREATE TABLE `home_reply` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL,
  `mark` varchar(100) NOT NULL DEFAULT '0',
  `arc_type` varchar(30) NOT NULL DEFAULT '0',
  `ref_id` int(11) NOT NULL DEFAULT '0',
  `is_publish` int(11) NOT NULL DEFAULT '2',
  `support_count` int(11) NOT NULL DEFAULT '0',
  `against_count` int(11) NOT NULL DEFAULT '0',
  `content` text NOT NULL,
  `created_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`),
  KEY `arc_type` (`arc_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `home_sessions` */

DROP TABLE IF EXISTS `home_sessions`;

CREATE TABLE `home_sessions` (
  `sessid` char(32) NOT NULL DEFAULT '',
  `expiry` int(10) NOT NULL DEFAULT '0',
  `data` text NOT NULL,
  PRIMARY KEY (`sessid`),
  KEY `sesskid` (`sessid`,`expiry`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `home_sys_data` */

DROP TABLE IF EXISTS `home_sys_data`;

CREATE TABLE `home_sys_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sys_key` varchar(100) NOT NULL,
  `sys_content` text NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `msg_data` */

DROP TABLE IF EXISTS `msg_data`;

CREATE TABLE `msg_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `root_id` int(11) NOT NULL DEFAULT '0' COMMENT '根消息id',
  `sub_count` int(11) NOT NULL DEFAULT '0',
  `uid` int(11) NOT NULL DEFAULT '0',
  `receive_uid` int(11) NOT NULL DEFAULT '0',
  `content` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `is_read` tinyint(4) NOT NULL DEFAULT '0',
  `send_status` tinyint(1) NOT NULL DEFAULT '1',
  `receve_status` tinyint(1) NOT NULL DEFAULT '1',
  `msg_type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1为系统信息，0为普通信息',
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`),
  KEY `receive_uid` (`receive_uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `msg_notice` */

DROP TABLE IF EXISTS `msg_notice`;

CREATE TABLE `msg_notice` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `feed_title` varchar(400) NOT NULL DEFAULT '0',
  `url` varchar(400) NOT NULL DEFAULT '0',
  `url_app` varchar(200) NOT NULL DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `msg_notice_read_log` */

DROP TABLE IF EXISTS `msg_notice_read_log`;

CREATE TABLE `msg_notice_read_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `notice_id` int(11) NOT NULL DEFAULT '0',
  `uid` int(11) NOT NULL DEFAULT '0',
  `is_read` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `site_arc` */

DROP TABLE IF EXISTS `site_arc`;

CREATE TABLE `site_arc` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `descr` text NOT NULL,
  `tree_id` int(11) NOT NULL DEFAULT '0',
  `uid` int(11) NOT NULL DEFAULT '0',
  `face` varchar(100) NOT NULL DEFAULT '0',
  `reply_count` int(11) NOT NULL DEFAULT '0',
  `recommend_count` int(11) NOT NULL DEFAULT '0',
  `view_count` int(11) NOT NULL DEFAULT '0' COMMENT '访问量',
  `is_publish` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0未发布，草稿，1已发布',
  `position` varchar(10) NOT NULL DEFAULT '0' COMMENT '1首页推荐,2栏目推荐,格式类似,1,2,',
  `created_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`),
  KEY `tree_id` (`tree_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `site_recommend_log` */

DROP TABLE IF EXISTS `site_recommend_log`;

CREATE TABLE `site_recommend_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT '0',
  `arc_id` int(11) NOT NULL DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `site_tree` */

DROP TABLE IF EXISTS `site_tree`;

CREATE TABLE `site_tree` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '0',
  `face` varchar(200) NOT NULL DEFAULT '0',
  `descr` varchar(200) NOT NULL DEFAULT '0',
  `pid` int(11) NOT NULL DEFAULT '0',
  `tree_sort` int(11) NOT NULL DEFAULT '0',
  `created_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updateed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

/*Table structure for table `user_coin_logs` */

DROP TABLE IF EXISTS `user_coin_logs`;

CREATE TABLE `user_coin_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT '0',
  `number` int(11) NOT NULL DEFAULT '0',
  `logs` varchar(100) NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `user_email_validate` */

DROP TABLE IF EXISTS `user_email_validate`;

CREATE TABLE `user_email_validate` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(100) NOT NULL,
  `token` varchar(40) NOT NULL,
  `created_time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `user_feed` */

DROP TABLE IF EXISTS `user_feed`;

CREATE TABLE `user_feed` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT '0',
  `feed_type` varchar(400) NOT NULL DEFAULT '0',
  `feed_type_name` varchar(400) NOT NULL DEFAULT '0',
  `feed_title` varchar(400) NOT NULL DEFAULT '0',
  `feed_data` text NOT NULL,
  `url` varchar(400) DEFAULT '0',
  `url_app` varchar(200) DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

/*Table structure for table `user_findpwd_validate` */

DROP TABLE IF EXISTS `user_findpwd_validate`;

CREATE TABLE `user_findpwd_validate` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(100) NOT NULL,
  `token` varchar(40) NOT NULL,
  `created_time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `user_follow` */

DROP TABLE IF EXISTS `user_follow`;

CREATE TABLE `user_follow` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT '0',
  `follow_uid` int(11) NOT NULL DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

/*Table structure for table `user_info` */

DROP TABLE IF EXISTS `user_info`;

CREATE TABLE `user_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL DEFAULT '0',
  `pwd` varchar(50) NOT NULL DEFAULT '0',
  `nickname` varchar(50) NOT NULL DEFAULT '0',
  `sign` varchar(100) DEFAULT NULL COMMENT '签名',
  `face` varchar(100) NOT NULL DEFAULT '0',
  `coin` int(11) NOT NULL DEFAULT '0',
  `sex` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0:保密,1:男，2：女',
  `cur_area` int(11) NOT NULL DEFAULT '0' COMMENT '当前所在地',
  `email_validate` tinyint(4) NOT NULL DEFAULT '0',
  `role` tinyint(1) NOT NULL DEFAULT '0' COMMENT '角色,默认0,9为管理员,10为超级管理员',
  `daren_tree` varchar(100) NOT NULL DEFAULT '-1',
  `mtime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `nickname` (`nickname`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='用户信息表';

/*Table structure for table `user_sign` */

DROP TABLE IF EXISTS `user_sign`;

CREATE TABLE `user_sign` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT '0',
  `created_date` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `user_stat` */

DROP TABLE IF EXISTS `user_stat`;

CREATE TABLE `user_stat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT '0',
  `follow_count` int(11) NOT NULL DEFAULT '0',
  `to_follow_count` int(11) NOT NULL DEFAULT '0',
  `blog_count` int(11) NOT NULL DEFAULT '0',
  `answer_count` int(11) NOT NULL DEFAULT '0',
  `question_count` int(11) NOT NULL DEFAULT '0',
  `group_arc_count` int(11) NOT NULL DEFAULT '0',
  `feed_count` int(11) NOT NULL DEFAULT '0',
  `tag_count` int(11) NOT NULL DEFAULT '0',
  `group_count` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `user_openlogin`;
CREATE TABLE `user_openlogin` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT '0',
  `obj_id` varchar(100) NOT NULL,
  `open_type` varchar(50) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='第三方登录';

DROP TABLE IF EXISTS `video_detail`;
CREATE TABLE `video_detail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `list_id` int(11) DEFAULT '0',
  `list_number` varchar(100) DEFAULT '0',
  `url` varchar(200) DEFAULT NULL,
  `fsort` tinyint(3) DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `video_list`;
CREATE TABLE `video_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(200) DEFAULT NULL,
  `uid` int(11) DEFAULT NULL,
  `tree_id` int(11) DEFAULT '0',
  `content` text,
  `descr` text,
  `role` varchar(500) DEFAULT NULL COMMENT '主演',
  `author` text COMMENT '作者，导演等',
  `publish_date` varchar(100) DEFAULT NULL,
  `position` varchar(100) DEFAULT NULL,
  `view_number` int(11) DEFAULT '0',
  `face` varchar(200) DEFAULT NULL,
  `grade` float DEFAULT '0',
  `fsort` int(4) DEFAULT '0',
  `ftype` varchar(100) DEFAULT NULL,
  `area` varchar(100) DEFAULT NULL,
  `is_publish` tinyint(1) DEFAULT '0',
  `reply_count` int(11) DEFAULT '0',
  `recommend_count` int(11) DEFAULT '0',
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `video_tree`;
CREATE TABLE `video_tree` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '0',
  `face` varchar(200) NOT NULL DEFAULT '0',
  `descr` varchar(200) NOT NULL DEFAULT '0',
  `pid` int(11) NOT NULL DEFAULT '0',
  `tree_sort` int(11) NOT NULL DEFAULT '0',
  `created_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `video_recommend_log`;
CREATE TABLE `video_recommend_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT '0',
  `arc_id` int(11) NOT NULL DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `home_links`;
CREATE TABLE `home_links` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT NULL,
  `url` varchar(100) DEFAULT NULL,
  `fsort` tinyint(1) DEFAULT '0',
  `ctime` timestamp NULL DEFAULT NULL,
  `mtime` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

ALTER TABLE `user_info` 
ADD COLUMN `uc_uid` int(11)   NULL DEFAULT 0 COMMENT 'userceter  uid' after `id` , 
ADD COLUMN `uc_synlogout` tinyint(1)   NULL DEFAULT 0 COMMENT '是否同步退出' after `uc_uid` , 
ADD COLUMN `uc_synlogin` tinyint(1)   NULL DEFAULT 0 COMMENT '是否同步登录' after `uc_synlogout` , 
CHANGE `username` `username` varchar(50)  COLLATE utf8_general_ci NOT NULL DEFAULT '0' after `uc_synlogin` , 
CHANGE `pwd` `pwd` varchar(50)  COLLATE utf8_general_ci NOT NULL DEFAULT '0' after `username` , 
CHANGE `nickname` `nickname` varchar(50)  COLLATE utf8_general_ci NOT NULL DEFAULT '0' after `pwd` , 
CHANGE `sign` `sign` varchar(100)  COLLATE utf8_general_ci NULL COMMENT '签名' after `nickname` , 
CHANGE `face` `face` varchar(100)  COLLATE utf8_general_ci NOT NULL DEFAULT '0' after `sign` , 
CHANGE `coin` `coin` int(11)   NOT NULL DEFAULT 0 after `face` , 
CHANGE `sex` `sex` tinyint(1)   NOT NULL DEFAULT 0 COMMENT '0:保密,1:男，2：女' after `coin` , 
CHANGE `cur_area` `cur_area` int(11)   NOT NULL DEFAULT 0 COMMENT '当前所在地' after `sex` , 
CHANGE `email_validate` `email_validate` tinyint(4)   NOT NULL DEFAULT 0 after `cur_area` , 
CHANGE `role` `role` tinyint(1)   NOT NULL DEFAULT 0 COMMENT '角色,默认0,9为管理员,10为超级管理员' after `email_validate` , 
CHANGE `daren_tree` `daren_tree` varchar(100)  COLLATE utf8_general_ci NOT NULL DEFAULT '-1' after `role` , 
CHANGE `mtime` `mtime` timestamp   NOT NULL DEFAULT CURRENT_TIMESTAMP after `daren_tree` ;

DROP TABLE IF EXISTS `home_logs`;
CREATE TABLE `home_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ip` varchar(20) DEFAULT NULL,
  `content` text,
  `uid` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `home_tag`;
CREATE TABLE `home_tag` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `uid` int(11) NOT NULL DEFAULT '0',
  `descr` varchar(400) NOT NULL,
  `tag_sort` int(11) NOT NULL DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

ALTER TABLE `user_feed` 
	ADD COLUMN `is_public` tinyint(1)   NULL DEFAULT 1 after `url_app` , 
	CHANGE `created_at` `created_at` timestamp   NOT NULL DEFAULT CURRENT_TIMESTAMP after `is_public` ;
ALTER TABLE `user_feed` 
	ADD COLUMN `ref_id` int(11)   NULL DEFAULT 0 after `url` , 
	CHANGE `url_app` `url_app` varchar(200)  COLLATE utf8_general_ci NULL DEFAULT '0' after `ref_id` , 
	CHANGE `is_public` `is_public` tinyint(1)   NULL DEFAULT 1 after `url_app` , 
	CHANGE `created_at` `created_at` timestamp   NOT NULL DEFAULT CURRENT_TIMESTAMP after `is_public` ;
ALTER TABLE `user_info`
	ADD COLUMN `is_del` tinyint(1)   NULL DEFAULT 0 COMMENT '是否删除' after `role` ,
	CHANGE `daren_tree` `daren_tree` varchar(100)  COLLATE utf8_general_ci NOT NULL DEFAULT '-1' after `is_del` ,
	CHANGE `mtime` `mtime` timestamp   NOT NULL DEFAULT CURRENT_TIMESTAMP after `daren_tree` ;


	