<?php
/**
 * 
 * 初始化
 * @author kaihui
 *
 */
include ROOT_LIB . "/My/Tool.php";
set_include_path(implode(PATH_SEPARATOR, array(
    ROOT_LIB,
    get_include_path(),
)));

set_error_handler("myError",E_ALL);
// register_shutdown_function("lastError");
// set_exception_handler("myException");
class My_Init{
	private static $inStance=null;
	private $appNames=array();
	private $configs = array();
	private $libraryFiles = array();
	private $application = null;
	public  $time=0;
	static $isInstall = 0;
	
	static function getInstance(){
		if(!self::$inStance){
			self::$inStance = new self();
			self::$isInstall = isInstall();
			if(self::$isInstall){
				define("IS_DEBUG", 0);
			}else{
				define("IS_DEBUG", 1);
			}
		}
		return self::$inStance;
	}
	
	//获取花费的时间
	function getTime(){
		return number_format(getMicrotime()-$this->time, 4);
	}
	
	//获取调试信息
	function getDebug(){
		$func = get_defined_functions();
		$include = get_included_files();
		$class = get_declared_classes();
		return array(
			'func'=>$func,
			'include_file'=>$include,
			'class'=>$class
		);
	}
	
	//创建site
	function create(){
		$this->time = getMicrotime();
		include 'Zend/Application.php';
		$this->cachePlugin();
		include "My/Tool/File.php";
		$this->siteIni();

		$this->namespaceInit();
		$allConfigs = mergeConfigs($this->configs);
//		print_r($allConfigs);exit;
//		if(!My_Init::$isInstall){
			$allConfigs['bootstrap']['path'] = APPLICATION_PATH . DS."InstallBootstrap.php";
			$allConfigs['bootstrap']['class'] = "InstallBootstrap";
//		}

		// Create application, bootstrap, and run
		$this->application = new Zend_Application(
		    APPLICATION_ENV,
		   	$allConfigs
		);
		$this->openNameSpace();

		if(!defined("RUN_CLI")){
			$this->application->bootstrap()->run();
		}
	}
	
	//plugin缓存
	function cachePlugin(){
		if(!isDebug()) return true;
		require_once 'Zend/Loader/PluginLoader.php';
		$cacheFilePath = CACHE_DIR . '/data';
		$classFileIncCache = $cacheFilePath . '/pluginLoaderCache.php';
		
		if (!is_file($classFileIncCache)) {
			if(!is_dir($cacheFilePath)) mkdir($cacheFilePath, 0777, 1);
			Zend_Loader_PluginLoader::setIncludeFileCache($classFileIncCache);
		}else{
			include_once $classFileIncCache;
		}
	}
	
	//网站配置缓存文件
	function siteIni(){
		$applicationIniPath = ROOT_DIR . '/configs/application.ini.php';
		$applicationIniCachePath = CACHE_DIR . "/ini/application.php";
		
		$appsRouterIniPath = ROOT_DIR . '/configs/router.ini.php';
		$appsRouterIniCachePath = CACHE_DIR . "/ini/router.php";
		
		$configs[] = array("ini"=>$applicationIniPath, "inc"=>$applicationIniCachePath);
		$configs[] = array("ini"=>$appsRouterIniPath, "inc"=>$appsRouterIniCachePath);
		$this->configs = $configs;
		return $configs;
	}
	
	
	
	//namespace初始化
	function namespaceInit(){
		$this->getLibraryFiles();
		$this->getAppNames();
			//app
		 if($this->appNames){
			    foreach($this->appNames as $v){
			    	if(preg_match("/^@.*?@$/", $v)) continue;
					$this->libraryFiles[] = ucfirst($v);
					$appsRouterIniPathTmp = ROOT_DIR . DS.'/configs/'.strtolower($v).'/router.ini.php';
					$appsRouterIniCachePathTmp = CACHE_DIR . "/ini/_app_/".strtolower($v)."/router.php";
					$this->configs[] = array("ini"=>$appsRouterIniPathTmp, "inc"=>$appsRouterIniCachePathTmp);
			    }
		  }
	 	
      }
      
     
      //开启namespance
      function openNameSpace(){
      		$namespaces = array();
      		$this->libraryFiles = array_unique($this->libraryFiles);
//      		print_r($this->libraryFiles);exit;
			if($this->libraryFiles){
				foreach($this->libraryFiles as $file){
					if($file != "Open" && $file != "Zend"){
						$namespaces[] = $file . "_";
						$fileTmp = $file . DS . $file . ".php";
						require_once $fileTmp;
					}
				}
			}
			$this->application = $this->application->setAutoloaderNamespaces($namespaces);
      }
  
	//library namespace
	function getLibraryFiles(){
		$libraryFiles =  fileCached("data/autoloaderNamespaces.php", array("My_Tool_File", "getDirNames"), array(ROOT_LIB));
		$this->libraryFiles = $libraryFiles;
		return $libraryFiles;
	}
	
	//app
	function getAppNames(){
		$appNames = fileCached("data/_app_/apps.php", array("My_Tool_File", "getDirNames"), array(APPLICATION_PATH));
		$this->appNames = $appNames;
		return $appNames;
	}
	
}

//===================================函数===========================================================================
function isInstall(){
      $path = ROOT_DIR . "/data/install.lock";
      return is_file($path) ? true:false;
}
      
function isDebug(){
	return IS_DEBUG ? false:true;
}
#文件缓存
function fileCached($newCacheFilePath, $dataCome, $params=array()){
	if(isDebug()){
		$cacheListPath = CACHE_DIR . "/cacheList.php";
		if(!is_file($cacheListPath)) file_put_contents($cacheListPath, "<?php return array(); ");
		$cacheList = include $cacheListPath;
		$newCacheFilePath = str_replace("\\", "/", $newCacheFilePath);
		//是否全路径
		$tmp = str_replace(CACHE_DIR, "", $newCacheFilePath);
		if($newCacheFilePath != $tmp){
			$cachePath = $newCacheFilePath;
		}else{
			$cachePath = CACHE_DIR . "/" . ltrim($newCacheFilePath, "/");
		}
		if(!in_array($cachePath, $cacheList)){
			$result = call_user_func_array($dataCome, $params);
			$data = $result;
		
			if(!is_dir(dirname($cachePath)))  mkdir(dirname($cachePath), 0755, 1);
			$result = is_array($result) ? var_export($result, true) :  $result;
			$result = is_object($result) ? var_export($result->toArray(), true) : $result; 
			$configs = '<?php' . PHP_EOL . 'return ' . $result .";". PHP_EOL;
         	file_put_contents($cachePath, $configs);
         	//保存cache路径列表
         	$cacheList[] = $cachePath;
         	$cacheListStr = '<?php' . PHP_EOL . 'return ' . var_export($cacheList, true) .";". PHP_EOL;
         	file_put_contents($cacheListPath, $cacheListStr);
         	return $data;
		}else{
			$result = include($cachePath);
			return 	$result;
		}
	}else{
		return call_user_func_array($dataCome, $params);
	}
	
}

//合并配置文件
function mergeConfigs(array $configs){
	if(!$configs) return false;
	$data = array();
	foreach($configs as $v){
		$ini  =  $v['ini'];
		$inc  =  $v['inc'];
		$configData = fileCached($inc, "getIni", array($ini));
		$data = array_merge_recursive($data, $configData);
	}
	return $data;
}

function getIni($ini){
	if(!is_file($ini)) return array();
	require_once 'Zend/Config/Ini.php';
	$config = new Zend_Config_Ini($ini, APPLICATION_ENV, array('allowModifications' => true));
    return $config->toArray();
}
//错误处理
function myError($errno, $errstr, $errfile, $errline){
	if(error_reporting() == 0) return true; 
	$trace = My_Tool::trace(0);
	if(!isDebug()){
		echo "<pre>";
		echo $trace;
	}
}

//时间
function getMicrotime()
{
	list($usec, $sec) = explode(' ', microtime()); 
	return ((float)$usec + (float)$sec); 
}

function getSysData($key){
	return Home::service()->getCommon()->getSysData($key);
}

function saveSysData($k,$v){
	return Home::service()->getCommon()->saveSysData($k, $v);
}

function getInit(){
	return My::config()->getInit();
}
