<?php

//取日期
function get_date($v, $n = 19) {
  return substr(preg_replace('/.*(\d{4})(\d{2})(\d{2})(\d{2})(\d{2})(\d{2}).*/', '$1-$2-$3 $4:$5:$6', $v), 0, $n);
}




$now_time = gmdate('Y-m-d H:i:s', time() + floatval($web['time_pos']) * 3600); //现在
$date_yeday = gmdate('Y-m-d', time() + floatval($web['time_pos']) * 3600 - 24 * 3600); //昨天
$date_beday = gmdate('Y-m-d', time() + floatval($web['time_pos']) * 3600 - 2 * 24 * 3600); //前天


if ($web['time_mode'] == 1) {
  function get_date_c($the_time) {
    global $now_time, $date_yeday, $date_beday;
    $the_time_mark = substr($the_time, 0, 10);
    if ($the_time_mark < $date_beday) {
      return substr($the_time, 0, 16);
    } elseif ($the_time_mark == $date_beday) {
      return '<span title="'.$the_time.'">前天</span>'.substr($the_time, 11, 5).'';
    } elseif ($the_time_mark == $date_yeday) {
      return '<span title="'.$the_time.'">昨天</span>'.substr($the_time, 11, 5).'';
    } else {
      if (strlen($the_time) > 10) {
        $now_time_ = strtotime($now_time);
        $show_time = strtotime($the_time);
        $diff = $now_time_ - $show_time;
        if ($diff < 0) {
          return '<span title="'.$the_time.'" class="red">置顶至'.substr($the_time, 0, 10).'</span>';
        } elseif ($diff < 30) {
          return '<span title="'.$the_time.'" class="green">刚才</span>'; //$diff秒前
        } elseif ($diff < 60) {
          return '<span title="'.$the_time.'">半分钟前</span>';
        } elseif ($diff < 1800) {
          return '<span title="'.$the_time.'">'.floor($diff / 60).'分钟前</span>';
        } elseif ($diff < 2700) {
          return '<span title="'.$the_time.'">半小时前</span>';
        } elseif ($diff < 3600) {
          return '<span title="'.$the_time.'">'.floor($diff / 60).'分钟前</span>';
        } elseif ($diff < 86400) {
          return '<span title="'.$the_time.'">'.floor($diff / 3600).'小时前</span>';
        } else {
          return $the_time;
        }
      } else {
        return '今天';
      }
    }
  }

} else {

  function get_date_c($the_time) {
    global $now_time;
    if ($the_time > $now_time) {
      return '<span class="red">置顶至'.substr($the_time, 0, 16).'</span>';
    } else {
      return substr($the_time, 0, 16);
    }
  }


}

?>