<?php
// REPORT ALL ERRORS
error_reporting(E_ALL);
// DO NOT ALLOW PHP_SESS_ID TO BE PASSED IN THE QUERYSTRING
ini_set('session.use_only_cookies', 1);
// Track errors so explicit error messages can be reported should errors be encountered
ini_set('track_errors', 1);
// Define constant for magic_quotes
define('MAGIC_QUOTES_ON', get_magic_quotes_gpc());

// INCLUDE NECESSARY CLASSES & FUNCTIONS
include('../library/Framework/Framework.Functions.php');
include('../library/Framework/Framework.Class.Select.php');
include('../library/Framework/Framework.Class.SqlBuilder.php');
include('../library/Framework/Framework.Class.MessageCollector.php');
include('../library/Framework/Framework.Class.ErrorManager.php');
include('../library/Framework/Framework.Class.ConfigurationManager.php');

// Include database structure
include('../appg/database.php');

// Set application name and version
include('version.php');

// Set up some configuration defaults to override
$Configuration['DATABASE_HOST'] = 'localhost';
$Configuration['DATABASE_NAME'] = '';
$Configuration['DATABASE_USER'] = '';
$Configuration['DATABASE_PASSWORD'] = '';
$Configuration['DATABASE_CHARACTER_ENCODING'] = '';
$Configuration['APPLICATION_PATH'] = '';
$Configuration['DATABASE_PATH'] = '';
$Configuration['LIBRARY_PATH'] = '';
$Configuration['EXTENSIONS_PATH'] = '';
$Configuration['LANGUAGES_PATH'] = '';
$Configuration['THEME_PATH'] = '';
$Configuration['BASE_URL'] = '';
$Configuration['HTTP_METHOD'] = '';
$Configuration['DEFAULT_STYLE'] = '';
$Configuration['WEB_ROOT'] = '';
$Configuration['COOKIE_DOMAIN'] = '-';
$Configuration['COOKIE_PATH'] = '-';
$Configuration['SUPPORT_EMAIL'] = '';
$Configuration['SUPPORT_NAME'] = '';
$Configuration['FORWARD_VALIDATED_USER_URL'] = '';
$Configuration['CHARSET'] = 'utf-8';
$Configuration['DATABASE_TABLE_PREFIX'] = 'GuaGua_';
$Configuration['APPLICATION_TITLE'] = '';
$Configuration['BANNER_TITLE'] = '';
$Configuration['SETUP_COMPLETE'] = '0';
$Configuration['SETUP_TEST'] = '0';

class FauxContext {
	var $WarningCollector;
	var $ErrorManager;
	var $SqlCollector;
	var $Configuration;
	var $Dictionary;
	var $DatabaseTables;
	var $DatabaseColumns;
	var $Session;
	function GetDefinition($Code) {
		if (array_key_exists($Code, $this->Dictionary)) {
			return $this->Dictionary[$Code];
		} else {
			return $Code;
		}
	}
}

class FauxSession {
	var $User = false;
}

// Create warning & error handlers
$Context = new FauxContext();
$Context->Session = new FauxSession();
$Context->WarningCollector = new MessageCollector();
$Context->ErrorManager = new ErrorManager();
$Context->SqlCollector = new MessageCollector();
$Context->Configuration = $Configuration;
$Context->DatabaseTables = $DatabaseTables;
$Context->DatabaseColumns = $DatabaseColumns;
$Context->Dictionary = array();

// Dictionary Definitions
$Context->Dictionary['ErrReadFileSettings'] = '加载配置文件时发生错误: ';
$Context->Dictionary['ErrOpenFile'] = '无法打开配置文件: //1';
$Context->Dictionary['ErrWriteFile'] = '配置文件不可写.';

// Retrieve all postback parameters
$CurrentStep = ForceIncomingInt('Step', 0);
$PostBackAction = ForceIncomingString('PostBackAction', '');
$DBHost = ForceIncomingString('DBHost', $Configuration['DATABASE_HOST']);
$DBName = ForceIncomingString('DBName', '');
$DBUser = ForceIncomingString('DBUser', '');
$DBPass = ForceIncomingString('DBPass', '');
$DBTablePrefix = ForceIncomingString('DBTablePrefix', $Configuration['DATABASE_TABLE_PREFIX']);
$Username = ForceIncomingString('Username', '');
$Password = ForceIncomingString('Password', '');
$ConfirmPassword = ForceIncomingString('ConfirmPassword', '');
$SupportEmail = ForceIncomingString('SupportEmail', 'admin@yourwebsite.com');
$SupportName = ForceIncomingString('SupportName', 'Admin');
$ApplicationTitle = ForceIncomingString('ApplicationTitle', '呱呱论坛');
$CookieDomain = ForceIncomingString('CookieDomain', '');
$CookieDomain = FormatCookieDomain($CookieDomain);
$CookiePath = ForceIncomingString('CookiePath', '');

// Make the banner title the same as the application title
$WorkingDirectory = str_replace('\\', '/', getcwd()).'/';
$RootDirectory = str_replace('setup/', '', $WorkingDirectory);
$WebRoot = dirname(ForceString(@$_SERVER['PHP_SELF'], ''));
$WebRoot = substr($WebRoot, 0, strlen($WebRoot) - 5); // strips the "setup" off the end of the path.
$HttpMethod = 'http';
$BaseUrl = $HttpMethod . '://' . ForceString(@$_SERVER['HTTP_HOST'], '').$WebRoot;
$ThemeDirectory = $WebRoot . 'themes/';
$AllowNext = 0;

function CreateFile($File, $Contents, &$Context) {
	if (!file_exists($File)) {
		$Handle = @fopen($File, 'wb');
		if (!$Handle) {
			$Error = $php_errormsg;
			if ($Error != '') $Error = '错误报告如下:<code>'.$Error.'</code>';
			$Context->WarningCollector->Add('创建配置文件 \''.$File.'\' 失败. '.$Error);
		} else {
			if (fwrite($Handle, $Contents) === FALSE) {
				$Context->WarningCollector->Add('无法写入配置文件: \''.$File.'\'. 请确保PHP具有写文件权限.');
			}
			fclose($Handle);
		}
	}
}

// Step 1. Check for correct PHP, MySQL, and permissions
if ($PostBackAction == 'Permissions') {

	$FilePermissionIssues = 0;
	// Make sure we are running at least PHP 4.1.0
	if (intval(str_replace('.', '', phpversion())) < 410) $Context->WarningCollector->Add('服务器当前的PHP版本是: '.phpversion().'. GuaGua要求PHP为4.1.0或以上版本.');
	// Make sure MySQL is available
	if (!function_exists('mysql_connect')) $Context->WarningCollector->Add('GuaGua要求服务器配置并运行了MySQL数据库.');

	// Make sure the conf folder is writeable
	if (!is_writable('../conf/')) {
		$Context->WarningCollector->Add('./conf/文件夹不可写, 属性需要改为: 777');
		$FilePermissionIssues = 1;
	}

	// Make sure all folders are readable
	$TestFolder = array(
		'extensions' => '../extensions/',
		'languages' => '../languages/',
		'themes' => '../themes/',
		'setup' => '../setup/'
	);
	foreach ($TestFolder as $FolderName => $Path) {
		if (!is_readable($Path)) {
			$Context->WarningCollector->Add('./'. $FolderName . '/文件夹不可读, 属性需要改为: 755');
			$FilePermissionIssues = 1;
		}
	}

	// Make sure the files don't exist already (ie. the site is already up and running);
	if (file_exists('../conf/settings.php')) $Context->WarningCollector->Add('GuaGua好像已经安装了. 您需要删除以下配置文件才能进行安装:<BR>
	conf/settings.php<BR>
	conf/database.php
    ');


	if ($Context->WarningCollector->Count() == 0) {
		$Contents = '<?php
// Database Configuration Settings
?>';
		CreateFile($RootDirectory.'conf/database.php', $Contents, $Context);
		$Contents = '<?php
// Make sure this file was not accessed directly and prevent register_globals configuration array attack
if (!defined(\'IN_GUAGUA\')) exit();
// Enabled Extensions
?>';
		CreateFile($RootDirectory.'conf/extensions.php', $Contents, $Context);
		$Contents = '<?php
// Custom Language Definitions
?>';
		CreateFile($RootDirectory.'conf/language.php', $Contents, $Context);
		$Contents = '<?php
// Application Settings
?>';
		CreateFile($RootDirectory.'conf/settings.php', $Contents, $Context);
	}

	// Save a test configuration option to the conf/settings.php file (This is inconsequential and is only done to make sure we have read access).
	if ($Context->WarningCollector->Count() == 0) {
		$SettingsFile = $RootDirectory . 'conf/settings.php';
		$SettingsManager = new ConfigurationManager($Context);
		$SettingsManager->DefineSetting('SETUP_TEST', '1', 1);
		if (!$SettingsManager->SaveSettingsToFile($SettingsFile)) {
			$Context->WarningCollector->Clear();
			$Context->WarningCollector->Add('无法保存配置文件: \''.$SettingsFile.'\'');
		}
	}

	if ($Context->WarningCollector->Count() == 0) {
		// Redirect to the next step (this is done so that refreshes don't cause steps to be redone)
		Redirect($WebRoot.'setup/installer.php?Step=2&PostBackAction=None');
	}
} elseif ($PostBackAction == 'Database') {
	$CurrentStep = 2;

	// Make sure the database settings haven't already been committed
	$DBFile = $RootDirectory . 'conf/database.php';
	$DBManager = new ConfigurationManager($Context);
	$DBManager->GetSettingsFromFile($DBFile);
	// Make sure the database file doesn't already contain data
	if ($DBManager->GetSetting('DATABASE_NAME') != '') {
		$Context->WarningCollector->Add('GuaGua好像已经安装了. 您需要删除以下配置文件才能进行安装:<BR>
	conf/settings.php<BR>
	conf/database.php
    ');
	} else {
		// Test the database params provided by the user
		$Connection = @mysql_connect($DBHost, $DBUser, $DBPass);
		$DatabaseCharacterEncoding = '';
		if (!$Connection) {
			$Response = '';
			if ($php_errormsg != '') $Response = ' 数据库连接错误: '.$php_errormsg;
			$Context->WarningCollector->Add('无法连接数据库服务器('.$DBHost.').'.$Response);
		} elseif (!mysql_select_db($DBName, $Connection)) {
			$Context->WarningCollector->Add('已连接到数据库服务器, 但无法进入数据库: \''.$DBName.'\'. 请检查此数据库是否存在或进入权限?');
		}

		// If the database connection worked, attempt to set up the database
		if ($Context->WarningCollector->Count() == 0 && $Connection) {
			// On MySQL 4.1 and later, force UTF-8
			if (version_compare(mysql_get_server_info($Connection), '4.1.0', '>=')) {
				mysql_query('SET NAMES "utf8"', $Connection);
				$DatabaseCharacterEncoding = 'utf8';
			}

			// Make sure there are no conflicting tables in the database
			$TableData = @mysql_query('show tables', $Connection);
			if (!$TableData) {
				$Context->WarningCollector->Add('数据库表已经存在: '. mysql_error($Connection));
			} else {
				$TableConflicts = array();
				$TableToCompare = array();
				while ($Row = mysql_fetch_array($TableData)) {
					$TableToCompare[] = strtolower($Row[0]);
				}
				foreach ($DatabaseTables as $TableKey => $TableName) {
					$TableName = GetTableName($TableKey, $DatabaseTables, $DBTablePrefix);
					$TableName = strtolower(iif($TableKey == 'User', $DBTablePrefix, '') . $TableName);
					if (in_array($TableName, $TableToCompare)) {
						$TableConflicts[] = $TableName;
					}
				}
				if (count($TableConflicts) == count($DatabaseTables)) {
					$Context->WarningCollector->Add('GuaGua已经安装.');
					$AllowNext = 1;
				} elseif (count($TableConflicts) > 0) {
					$Context->WarningCollector->Add('数据库表已经存在: <code>'.implode(', ', $TableConflicts).'</code>');
				} else {
					// Go ahead and install the database tables
					// Open the database file & retrieve sql
					$SqlLines = @file($WorkingDirectory.'mysql.sql');

					if (!$SqlLines) {
						$Context->WarningCollector->Add('无法加载数据文件: \''.$WorkingDirectory.'mysql.sql\'');
					} else {
						$CurrentQuery = '';
						$CurrentLine = '';
						for ($i = 0; $i < count($SqlLines); $i++) {
							$CurrentLine = trim($SqlLines[$i]);
							if ($CurrentLine == '') {
								if ($CurrentQuery != '') {
									// If the current query creates a table, make sure that the proper character encoding is applied.
									if ($DatabaseCharacterEncoding == 'utf8' && strpos($CurrentQuery, 'REATE TABLE') == 1) {
										str_replace(');', ') DEFAULT CHARACTER SET utf8;', $CurrentQuery);
									}
									$CurrentQuery = preg_replace('/((TABLE|INTO) `)GuaGua_/', '${1}' . $DBTablePrefix, $CurrentQuery);
									if (!@mysql_query($CurrentQuery, $Connection)) {
										$Context->WarningCollector->Add('创建数据库表时发生如下错误: <code>'.mysql_error($Connection).'</code><code>QUERY: '.$CurrentQuery.'</code>');
										$i = count($SqlLines)+1;
									}
									$CurrentQuery = '';
								}
							} else {
								$CurrentQuery .= $CurrentLine;
							}
						}
					}
				}
			}
			// Close the database connection
			@mysql_close($Connection);
		}

		// If the database was created successfully, save all parameters to the conf/database.php file
		if ($Context->WarningCollector->Count() == 0) {
			$DBManager->DefineSetting('DATABASE_HOST', $DBHost, 1);
			$DBManager->DefineSetting('DATABASE_NAME', $DBName, 1);
			$DBManager->DefineSetting('DATABASE_USER', $DBUser, 1);
			$DBManager->DefineSetting('DATABASE_PASSWORD', $DBPass, 1);
			$DBManager->DefineSetting('DATABASE_TABLE_PREFIX', $DBTablePrefix, 1);
			$DBManager->DefineSetting('DATABASE_CHARACTER_ENCODING', $DatabaseCharacterEncoding, 1);
			if (!$DBManager->SaveSettingsToFile($DBFile)) {
				// $Context->WarningCollector->Clear();
				// $Context->WarningCollector->Add('For some reason we couldn&#8217;t save your database settings to the '.$DBFile.' file.');
			}

			// Save user table name
			if (!AppendToConfigurationFile($RootDirectory.'conf/database.php',
					'$DatabaseTables[\'User\'] = \''.$DBTablePrefix."User';\n")) {
				// $Context->WarningCollector->Clear();
				// $Context->WarningCollector->Add('For some reason we couldn&#8217;t save your database settings to the '.$DBFile.' file.');
			}

			// Save the general settings as well (now that we know this person is authenticated to
			// a degree - knowing the database access params).
			$SettingsFile = $RootDirectory . 'conf/settings.php';
			$SettingsManager = new ConfigurationManager($Context);
			$SettingsManager->DefineSetting('APPLICATION_PATH', $RootDirectory, 1);
			$SettingsManager->DefineSetting('DATABASE_PATH', $RootDirectory . 'conf/database.php', 1);
			$SettingsManager->DefineSetting('LIBRARY_PATH', $RootDirectory . 'library/', 1);
			$SettingsManager->DefineSetting('EXTENSIONS_PATH', $RootDirectory . 'extensions/', 1);
			$SettingsManager->DefineSetting('LANGUAGES_PATH', $RootDirectory . 'languages/', 1);
			$SettingsManager->DefineSetting('THEME_PATH', $RootDirectory . 'themes/guagua/', 1);
			$SettingsManager->DefineSetting('DEFAULT_STYLE', $ThemeDirectory.'guagua/styles/default/', 1);
			$SettingsManager->DefineSetting('WEB_ROOT', $WebRoot, 1);
			$SettingsManager->DefineSetting('BASE_URL', $BaseUrl, 1);
			$SettingsManager->DefineSetting('HTTP_METHOD', $HttpMethod, 1);
			$SettingsManager->DefineSetting('FORWARD_VALIDATED_USER_URL', $BaseUrl, 1);
			if (!$SettingsManager->SaveSettingsToFile($SettingsFile)) {
				// $Context->WarningCollector->Clear();
				// $Context->WarningCollector->Add('For some reason we couldn&#8217;t save your general settings to the '.$SettingsFile.' file.');
			}
		}
	}

	if ($Context->WarningCollector->Count() == 0) {
		If ($DBPass == '') {
			$Context->WarningCollector->Add('GuaGua不支持空的数据库连接密码为, 安装后您需要在配置文件conf/settings.php中添加密码: <code>$Configuration[\'DATABASE_PASSWORD\'] = \'xxxxxxx\';</code><p /><a href="'.$WebRoot.'setup/installer.php?Step=3&PostBackAction=None">继续安装</a>.');
		} else {
			// Redirect to the next step (this is done so that refreshes don't cause steps to be redone)
			Redirect($WebRoot.'setup/installer.php?Step=3&PostBackAction=None');
		}
	}
} elseif ($PostBackAction == 'User') {
	$CurrentStep = 3;

	$SettingsFile = $RootDirectory . 'conf/settings.php';
	$SettingsManager = new ConfigurationManager($Context);
	$SettingsManager->GetSettingsFromFile($SettingsFile);
	if ($SettingsManager->GetSetting('SETUP_COMPLETE') != '0') {
		$Context->WarningCollector->Add('GuaGua好像已经安装了. 您需要删除以下配置文件才能进行安装:<BR>
	conf/settings.php<BR>
	conf/database.php
    ');
	} else {

		// Validate user inputs
		if (strip_tags($Username) != $Username) $Context->WarningCollector->Add('用户名中不能添加html代码.');
		if (strlen($Username) > 20) $Context->WarningCollector->Add('用户名太长.');
		if ($Password != $ConfirmPassword) $Context->WarningCollector->Add('密码与重复密码不匹配.');
		if (strip_tags($ApplicationTitle) != $ApplicationTitle) $Context->WarningCollector->Add('论坛名称中不能添加html代码.');
		if ($Username == '') $Context->WarningCollector->Add('请输入管理员用户名.');
		if ($Password == '') $Context->WarningCollector->Add('请输入管理员密码.');
		if ($SupportName == '') $Context->WarningCollector->Add('必须输入技术支持人员的姓名.');
		if (!preg_match('/(.+)@(.+)\.(.+)/i', $SupportEmail)) $Context->WarningCollector->Add('Email地址无效.');
		if ($ApplicationTitle == '') $Context->WarningCollector->Add('必须输入论坛名称.');

		// Include the db settings defined in the previous step
		include($RootDirectory.'conf/database.php');
		$Context->Configuration = $Configuration;
		$Context->DatabaseTables = $DatabaseTables;

		// Open the database connection
		$Connection = false;
		if ($Context->WarningCollector->Count() == 0) {
			$DBHost = $Configuration['DATABASE_HOST'];
			$DBName = $Configuration['DATABASE_NAME'];
			$DBUser = $Configuration['DATABASE_USER'];
			$DBPass = $Configuration['DATABASE_PASSWORD'];
			$Connection = @mysql_connect($DBHost, $DBUser, $DBPass);
			if (!$Connection) {
				$Context->WarningCollector->Add('无法连接数据库服务器('.$DBHost.'). 请检查数据库地址, 用户名或密码是否正确?');
			} elseif (!mysql_select_db($DBName, $Connection)) {
				$Context->WarningCollector->Add('已连接到数据库服务器, 但无法进入数据库: \''.$DBName.'\'. 请检查此数据库是否存在或进入权限?');
			} elseif (version_compare(mysql_get_server_info($Connection), '4.1.0', '>=')) {
				/* On MySQL 4.1 and later, force UTF-8 */
				mysql_query('SET NAMES "utf8"', $Connection);
			}
		}

		// Create the administrative user
		if ($Context->WarningCollector->Count() == 0 && $Connection) {
			$Username = FormatStringForDatabaseInput($Username);
			$Password = FormatStringForDatabaseInput($Password);

			$s = new SqlBuilder($Context);
			$s->SetMainTable('User', 'u');
			$s->AddFieldNameValue('FirstName', 'Administrative');
			$s->AddFieldNameValue('LastName', 'User');
			$s->AddFieldNameValue('Email', FormatStringForDatabaseInput($SupportEmail));
			$s->AddFieldNameValue('Name', $Username);
			$s->AddFieldNameValue('Password', $Password, 1, 'md5');
			$s->AddFieldNameValue('DateFirstVisit', MysqlDateTime());
			$s->AddFieldNameValue('DateLastActive', MysqlDateTime());
			$s->AddFieldNameValue('CountVisit', 0);
			$s->AddFieldNameValue('CountDiscussions', 0);
			$s->AddFieldNameValue('CountComments', 0);
			$s->AddFieldNameValue('RoleID', 4);
			$s->AddFieldNameValue('StyleID', 1);
			$s->AddFieldNameValue('UtilizeEmail', 0);
			$s->AddFieldNameValue('RemoteIp', GetRemoteIp(1));
			if (!@mysql_query($s->GetInsert(), $Connection)) {
				$Context->WarningCollector->Add('创建管理帐号时发生如下错误: '.mysql_error($Connection));
			} else {
				// Now insert the role history assignment
				$NewUserID = mysql_insert_id($Connection);
				$s->Clear();
				$s->SetMainTable('UserRoleHistory', 'h');
				$s->AddFieldNameValue('UserID', $NewUserID);
				$s->AddFieldNameValue('RoleID', 4);
				$s->AddFieldNameValue('Date', MysqlDateTime());
				$s->AddFieldNameValue('AdminUserID', $NewUserID);
				$s->AddFieldNameValue('Notes', 'Initial administrative account created');
				$s->AddFieldNameValue('RemoteIp', GetRemoteIp(1));
				// Fail silently on this one
				@mysql_query($s->GetInsert(), $Connection);
			}
			// Create the default GuaGua style entry in the db
			$s->Clear();
			$s->SetMainTable('Style', 's');
			$s->AddFieldNameValue('Name', 'GuaGua');
			$s->AddFieldNameValue('Url', $ThemeDirectory.'guagua/styles/default/');
			$s->AddFieldNameValue('PreviewImage', 'preview.gif');
			@mysql_query($s->GetInsert(), $Connection);
		}

		// Close the database connection
		@mysql_close($Connection);

		// Save the application constants
		if ($Context->WarningCollector->Count() == 0) {
			$SettingsManager->DefineSetting('SUPPORT_EMAIL', $SupportEmail, 1);
			$SettingsManager->DefineSetting('SUPPORT_NAME', $SupportName, 1);
			$SettingsManager->DefineSetting('APPLICATION_TITLE', $ApplicationTitle, 1);
			$SettingsManager->DefineSetting('BANNER_TITLE', $ApplicationTitle, 1);
			$SettingsManager->DefineSetting('COOKIE_DOMAIN', $CookieDomain, 1);
			$SettingsManager->DefineSetting('COOKIE_PATH', $CookiePath, 1);
			$SettingsManager->DefineSetting('SETUP_COMPLETE', '1', 1);
			$SettingsManager->SaveSettingsToFile($SettingsFile);
		}
	}

	if ($Context->WarningCollector->Count() == 0) {
		// Redirect to the next step (this is done so that refreshes don't cause steps to be redone)
		Redirect($WebRoot.'setup/installer.php?Step=4&PostBackAction=None');
	}
}

// Write the page
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
		<title><?php echo APPLICATION . ' ' . APPLICATION_VERSION . ' ' . APPLICATION_CHARSET; ?> 安装程序</title>
		<link rel="stylesheet" type="text/css" href="./style.css" />
	</head>
	<body>
		<h1>
			<span><strong><?php echo APPLICATION . APPLICATION_VERSION. APPLICATION_CHARSET; ?> 安装程序</span>
		</h1>
		<div class="Container">
			<div class="Content">
			<?php
			if ($CurrentStep < 2 || $CurrentStep > 4) {
				echo  '<h2>GuaGua安装向导 (第1步)</h2>';
				if ($Context->WarningCollector->Count() > 0) {
					// display error message and some help messages.
					echo '<div class="Warnings">
						<strong>环境测试过程中发现以下问题:</strong>
						'.$Context->WarningCollector->GetMessages().'
					</div>';
				} else {
					echo '<p>第1步进行环境测试, 检测是否已经安装或是否满足安装要求.</p>';
				}


				echo '<form id="frmPermissions" method="post" action="installer.php">
				<input type="hidden" name="PostBackAction" value="Permissions" />
				<div class="Button"><input type="submit" value="&raquo; 下一步: 开始进行环境测试" /></div>
				</form>';
			} elseif ($CurrentStep == 2) {
					echo '<h2>GuaGua安装向导 (第2步)</h2>';
					if ($Context->WarningCollector->Count() > 0) {
						echo '<div class="Warnings">
							<strong>安装论坛数据时发生如下问题:</strong>
							'.$Context->WarningCollector->GetMessages().'
						</div>';
					}
					echo '<p>安装论坛数据, 请输入以下数据库连接信息:</p>
					<fieldset>
						<form id="frmDatabase" method="post" action="installer.php">
						<input type="hidden" name="PostBackAction" value="Database" />
							<ul>
								<li>
									<label for="tDBHost">MySQL 服务器地址:</label>
									<input type="text" id="tDBHost" name="DBHost" value="'.FormatStringForDisplay($DBHost, 1).'" />
								</li>
								<li>
									<label for="tDBName">MySQL 数据库名:</label>
									<input type="text" id="tDBName" name="DBName" value="'.FormatStringForDisplay($DBName, 1).'" />
								</li>
								<li>
									<label for="tDBUser">MySQL 数据库用户名:</label>
									<input type="text" id="tDBUser" name="DBUser" value="'.FormatStringForDisplay($DBUser, 1).'" />
								</li>
								<li>
									<label for="tDBPass">MySQL 数据库密码:</label>
									<input type="password" id="tDBPass" name="DBPass" value="'.FormatStringForDisplay($DBPass, 1).'" />
								</li>
								<li>
									<label for="tDBTablePrefix">MySQL 数据库表前缀:</label>
									<input type="text" id="tDBTablePrefix" name="DBTablePrefix" value="'.FormatStringForDisplay($DBTablePrefix, 1).'" />
								</li>
							</ul>
							<div class="Button"><input type="submit" value="&raquo; 下一步: 安装论坛数据" /></div>
						</form>
					</fieldset>';
				} elseif ($CurrentStep == 3) {
					if ($PostBackAction != 'User') {
						$CookieDomain = ForceString(@$_SERVER['HTTP_HOST'], '');
						$CookieDomain = FormatCookieDomain($CookieDomain);
						$CookiePath = $WebRoot;
					}
					echo '<h2>GuaGua安装向导 (第3步)</h2>';
					if ($Context->WarningCollector->Count() > 0) {
						echo '<div class="Warnings">
							<strong>配置论坛及管理员信息时发生如下问题:</strong>
							'.$Context->WarningCollector->GetMessages().'
						</div>';
					}
					echo '<p>GuaGua论坛系统管理员信息:</p>
						<fieldset>'
						.'<form name="frmUser" method="post" action="installer.php">
						<input type="hidden" name="PostBackAction" value="User" />
						<ul>
							<li>
								<label for="tUsername">用户名:</label>
								<input id="tUsername" type="text" name="Username" value="'.FormatStringForDisplay($Username, 1).'" />
							</li>
							<li>
								<label for="tPassword">密码:</label>
								<input id="tPassword" type="password" name="Password" value="'.FormatStringForDisplay($Password, 1).'" />
							</li>
							<li>
								<label for="tConfirmPassword">重复密码:</label>
								<input id="tConfirmPassword" type="password" name="ConfirmPassword" value="'.FormatStringForDisplay($ConfirmPassword, 1).'" />
							</li>
						</ul><p>论坛技术支持姓名与Email地址:</p>
						<ul>
							<li>
								<label for="tSupportName">技术支持姓名:</label>
								<input id="tSupportName" type="text" name="SupportName" value="'.FormatStringForDisplay($SupportName, 1).'" />
							</li>
							<li>
								<label for="tSupportEmail">Email地址:</label>
								<input id="tSupportEmail" type="text" name="SupportEmail" value="'.FormatStringForDisplay($SupportEmail, 1).'" />
							</li>
						</ul>
						<p>您的GuaGua论坛名称:</p>
						<ul>
							<li>
								<label for="tApplicationTitle">论坛名称:</label>
								<input id="tApplicationTitle" type="text" name="ApplicationTitle" value="'.FormatStringForDisplay($ApplicationTitle, 1).'" />
							</li>
						</ul>
						<p>Cookie有效属性(自动生成):</p>
						<ul>
							<li>
								<label for="tCookieDomain">Cookie所属域名:</label>
								<input id="tCookieDomain" type="text" name="CookieDomain" value="'.FormatStringForDisplay($CookieDomain, 1).'" />
							</li>
							<li>
								<label for="tCookiePath">Cookie有效路径:</label>
								<input id="tCookiePath" type="text" name="CookiePath" value="'.FormatStringForDisplay($CookiePath, 1).'" />
							</li>
						</ul>
						<div class="Button"><input type="submit" value="&raquo; 下一步: 配置论坛及管理员信息" /></div>
						</form>
					</fieldset>';
				} else {
					echo '<h2>恭喜! 您已成功安装了GuaGua论坛.</h2>
					<p>为了确保系统安全, 建议删除安装目录: ./setup/<BR><BR></p>
					<div class="Button"><a href="../index.php">开始您的GuaGua之旅!</a></div>';
				}
				?>
			</div>
		</div>
	</body>
</html>
