<?php
!defined('PW_UPLOAD') && exit('Forbidden');

$topicdata = array(
	array(
		'name' => '房屋交易',
		'ifable' => '1',
		'vieworder' => '4',
		'ifdel' => '1',
		'topicmodel' => array(
			array(
				'name' => '出租',
				'ifable' => '1',
				'vieworder' => '1',
				'topicfield' => array(
					array(
						'name' => '楼盘名称',
						'vieworder' => '1',
						'type' => 'text',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '1',
						'ifasearch' => '1',
						'threadshow' => '1',
						'ifmust' => '1',
						'textsize' => '50',
						'descrip' => '',
					),
					array(
						'name' => '区域',
						'vieworder' => '4',
						'type' => 'select',
						'rules' => array(
							'0' => '1=杭州',
							'1' => '2=西湖区',
							'2' => '3=拱墅区',
							'3' => '4=下城区',
							'4' => '5=上城区',
							'5' => '6=下沙区',
							'6' => '7=滨江区',
						),
						'ifable' => '1',
						'ifsearch' => '1',
						'ifasearch' => '1',
						'threadshow' => '1',
						'ifmust' => '1',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '价格',
						'vieworder' => '3',
						'type' => 'text',
						'rules' => array(
							'minnum' => '1',
							'maxnum' => '100000000',
						),
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '1',
						'ifmust' => '1',
						'textsize' => '10',
						'descrip' => '元（人民币）',
					),
					array(
						'name' => '房屋类型',
						'vieworder' => '2',
						'type' => 'radio',
						'rules' => array(
							'0' => '1=住宅',
							'1' => '2=民房',
							'2' => '3=别墅',
							'3' => '4=商铺',
							'4' => '5=经济适用房',
						),
						'ifable' => '1',
						'ifsearch' => '1',
						'ifasearch' => '1',
						'threadshow' => '1',
						'ifmust' => '1',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '租赁类型',
						'vieworder' => '5',
						'type' => 'select',
						'rules' => array(
							'0' => '1=全部',
							'1' => '2=整租',
							'2' => '3=合租',
							'3' => '4=短租',
						),
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '1',
						'threadshow' => '1',
						'ifmust' => '1',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '来源',
						'vieworder' => '6',
						'type' => 'radio',
						'rules' => array(
							'0' => '1=个人',
							'1' => '2=中介',
						),
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '1',
						'threadshow' => '0',
						'ifmust' => '1',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '楼层',
						'vieworder' => '7',
						'type' => 'number',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '/',
						'vieworder' => '7',
						'type' => 'number',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '例如：2/6，表示第2层，总共6层。',
					),

					array(
						'name' => '建筑面积',
						'vieworder' => '8',
						'type' => 'number',
						'rules' => array(
							'minnum' => '1',
							'maxnum' => '10000',
						),
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '平方米',
					),
					array(
						'name' => '建筑年代',
						'vieworder' => '9',
						'type' => 'select',
						'rules' => array(
							'0' => '1=1991',
							'1' => '2=1992',
							'2' => '3=1993',
							'3' => '4=1994',
							'4' => '5=1995',
							'5' => '6=1996',
							'6' => '7=1997',
							'7' => '8=1998',
							'8' => '9=1999',
							'9' => '10=2000',
							'10' => '11=2001',
							'11' => '12=2002',
							'12' => '13=2003',
							'13' => '14=2004',
							'14' => '15=2005',
							'15' => '16=2006',
							'16' => '17=2007',
							'17' => '18=2008',
							'18' => '19=2009',
						),
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '1',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '年',
					),
					array(
						'name' => '特色房屋',
						'vieworder' => '11',
						'type' => 'radio',
						'rules' => array(
							'0' => '1=地铁房',
							'1' => '2=学区房',
							'2' => '3=婚房',
							'3' => '4=海景房',
							'4' => '5=湖景房',
							'5' => '6=江景房',
							'6' => '7=赡老房',
							'7' => '8=其他',
						),
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '1',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '装修情况',
						'vieworder' => '12',
						'type' => 'radio',
						'rules' => array(
							'0' => '1=全部',
							'1' => '2=毛坯',
							'2' => '3=简装',
							'3' => '4=中装',
							'4' => '5=精装',
						),
						'ifable' => '1',
						'ifsearch' => '1',
						'ifasearch' => '1',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '电话',
						'vieworder' => '14',
						'type' => 'text',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '10',
						'descrip' => '',
					),
					array(
						'name' => '-',
						'vieworder' => '14',
						'type' => 'text',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '20',
						'descrip' => '例如：0571-12345678',
					),
					array(
						'name' => '手机',
						'vieworder' => '15',
						'type' => 'text',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '例如：13812345678',
					),
					array(
						'name' => '地址',
						'vieworder' => '16',
						'type' => 'text',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '50',
						'descrip' => '',
					),
					array(
						'name' => '有效期',
						'vieworder' => '17',
						'type' => 'select',
						'rules' => array(
							'0' => '1=一星期',
							'1' => '2=半个月',
							'2' => '3=一个月',
							'3' => '4=三个月',
							'4' => '5=半年',
							'5' => '6=一年',
							'6' => '7=长期',
						),
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '房屋图片',
						'vieworder' => '18',
						'type' => 'upload',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '最短租期',
						'vieworder' => '10',
						'type' => 'select',
						'rules' => array(
							'0' => '1=一月',
							'1' => '2=二月',
							'2' => '3=三月',
							'3' => '4=半年',
							'4' => '5=一年',
						),
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '户型{#}室',
						'vieworder' => '13',
						'type' => 'select',
						'rules' => array(
							'0' => '1=0',
							'1' => '2=1',
							'2' => '3=2',
							'3' => '4=3',
							'4' => '5=4',
							'5' => '6=5',
							'6' => '7=6',
						),
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '{#}厅',
						'vieworder' => '13',
						'type' => 'select',
						'rules' => array(
							'0' => '1=0',
							'1' => '2=1',
							'2' => '3=2',
							'3' => '4=3',
							'4' => '5=4',
							'5' => '6=5',
							'6' => '7=6',
						),
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '{#}卫',
						'vieworder' => '13',
						'type' => 'select',
						'rules' => array(
							'0' => '1=0',
							'1' => '2=1',
							'2' => '3=2',
							'3' => '4=3',
							'4' => '5=4',
							'5' => '6=5',
							'6' => '7=6',
						),
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '{#}阳台',
						'vieworder' => '13',
						'type' => 'select',
						'rules' => array(
							'0' => '1=0',
							'1' => '2=1',
							'2' => '3=2',
							'3' => '4=3',
							'4' => '5=4',
							'5' => '6=5',
							'6' => '7=6',
						),
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '',
					),
				),
			),
			array(
				'name' => '出售',
				'ifable' => '1',
				'vieworder' => '2',
				'topicfield' => array(
					array(
						'name' => '区域',
						'vieworder' => '2',
						'type' => 'select',
						'rules' => array(
							'0' => '1=杭州',
							'1' => '2=西湖区',
							'2' => '3=拱墅区',
							'3' => '4=下城区',
							'4' => '5=上城区',
							'5' => '6=下沙区',
							'6' => '7=滨江区',
						),
						'ifable' => '1',
						'ifsearch' => '1',
						'ifasearch' => '1',
						'threadshow' => '1',
						'ifmust' => '1',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '楼盘名称',
						'vieworder' => '1',
						'type' => 'text',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '1',
						'threadshow' => '1',
						'ifmust' => '1',
						'textsize' => '50',
						'descrip' => '',
					),
					array(
						'name' => '价格',
						'vieworder' => '3',
						'type' => 'text',
						'rules' => array(
							'minnum' => '1',
							'maxnum' => '100000000',
						),
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '1',
						'ifmust' => '1',
						'textsize' => '0',
						'descrip' => '元（人民币）',
					),
					array(
						'name' => '房屋类型',
						'vieworder' => '4',
						'type' => 'radio',
						'rules' => array(
							'0' => '1=住宅',
							'1' => '2=民房',
							'2' => '3=别墅',
							'3' => '4=商铺',
							'4' => '5=经济适用房',
						),
						'ifable' => '1',
						'ifsearch' => '1',
						'ifasearch' => '1',
						'threadshow' => '1',
						'ifmust' => '1',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '来源',
						'vieworder' => '6',
						'type' => 'radio',
						'rules' => array(
							'0' => '1=个人',
							'1' => '2=中介',
						),
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '1',
						'threadshow' => '0',
						'ifmust' => '1',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '楼层',
						'vieworder' => '7',
						'type' => 'number',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '/',
						'vieworder' => '7',
						'type' => 'number',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '例如：2/6，表示第2层，总共6层。',
					),
					array(
						'name' => '房屋状态',
						'vieworder' => '5',
						'type' => 'select',
						'rules' => array(
							'0' => '1=现房',
							'1' => '2=期房',
							'2' => '3=尾房',
						),
						'ifable' => '1',
						'ifsearch' => '1',
						'ifasearch' => '1',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '建筑面积',
						'vieworder' => '8',
						'type' => 'number',
						'rules' => array(
							'minnum' => '1',
							'maxnum' => '10000',
						),
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '1',
						'textsize' => '0',
						'descrip' => '平方米',
					),
					array(
						'name' => '建筑年代',
						'vieworder' => '9',
						'type' => 'select',
						'rules' => array(
							'0' => '1=1991',
							'1' => '2=1992',
							'2' => '3=1993',
							'3' => '4=1994',
							'4' => '5=1995',
							'5' => '6=1996',
							'6' => '7=1997',
							'7' => '8=1998',
							'8' => '9=1999',
							'9' => '10=2000',
							'10' => '11=2001',
							'11' => '12=2002',
							'12' => '13=2003',
							'13' => '14=2004',
							'14' => '15=2005',
							'15' => '16=2006',
							'16' => '17=2007',
							'17' => '18=2008',
							'18' => '19=2009',
						),
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '年',
					),
					array(
						'name' => '特色房屋',
						'vieworder' => '10',
						'type' => 'radio',
						'rules' => array(
							'0' => '1=地铁房',
							'1' => '2=学区房',
							'2' => '3=婚房',
							'3' => '4=海景房',
							'4' => '5=湖景房',
							'5' => '6=江景房',
							'6' => '7=赡老房',
							'7' => '8=其他',
						),
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '1',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '装修情况',
						'vieworder' => '11',
						'type' => 'radio',
						'rules' => array(
							'0' => '1=全部',
							'1' => '2=毛坯',
							'2' => '3=简装',
							'3' => '4=中装',
							'4' => '5=精装',
						),
						'ifable' => '1',
						'ifsearch' => '1',
						'ifasearch' => '1',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '电话',
						'vieworder' => '13',
						'type' => 'number',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '10',
						'descrip' => '',
					),
					array(
						'name' => '-',
						'vieworder' => '13',
						'type' => 'number',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '20',
						'descrip' => '例如：0571-12345678',
					),
					array(
						'name' => '手机',
						'vieworder' => '14',
						'type' => 'text',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '地址',
						'vieworder' => '15',
						'type' => 'text',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '50',
						'descrip' => '',
					),
					array(
						'name' => '有效期',
						'vieworder' => '16',
						'type' => 'select',
						'rules' => array(
							'0' => '1=一星期',
							'1' => '2=半个月',
							'2' => '3=一个月',
							'3' => '4=三个月',
							'4' => '5=半年',
							'5' => '6=一年',
							'6' => '7=长期',
						),
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '1',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '房屋图片',
						'vieworder' => '17',
						'type' => 'upload',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '',
					),

					array(
						'name' => '户型{#}室',
						'vieworder' => '12',
						'type' => 'select',
						'rules' => array(
							'0' => '1=0',
							'1' => '2=1',
							'2' => '3=2',
							'3' => '4=3',
							'4' => '5=4',
							'5' => '6=5',
							'6' => '7=6',
						),
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '{#}厅',
						'vieworder' => '12',
						'type' => 'select',
						'rules' => array(
							'0' => '1=0',
							'1' => '2=1',
							'2' => '3=2',
							'3' => '4=3',
							'4' => '5=4',
							'5' => '6=5',
							'6' => '7=6',
						),
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '{#}卫',
						'vieworder' => '12',
						'type' => 'select',
						'rules' => array(
							'0' => '1=0',
							'1' => '2=1',
							'2' => '3=2',
							'3' => '4=3',
							'4' => '5=4',
							'5' => '6=5',
							'6' => '7=6',
						),
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '{#}阳台',
						'vieworder' => '12',
						'type' => 'select',
						'rules' => array(
							'0' => '1=0',
							'1' => '2=1',
							'2' => '3=2',
							'3' => '4=3',
							'4' => '5=4',
							'5' => '6=5',
							'6' => '7=6',
						),
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '',
					),
				),
			),
			array(
				'name' => '求购',
				'ifable' => '1',
				'vieworder' => '4',
				'topicfield' => array(
					array(
						'name' => '区域',
						'vieworder' => '2',
						'type' => 'select',
						'rules' => array(
							'0' => '1=杭州',
							'1' => '2=西湖区',
							'2' => '3=拱墅区',
							'3' => '4=下城区',
							'4' => '5=上城区',
							'5' => '6=下沙区',
							'6' => '7=滨江区',
						),
						'ifable' => '1',
						'ifsearch' => '1',
						'ifasearch' => '1',
						'threadshow' => '1',
						'ifmust' => '1',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '楼盘名称',
						'vieworder' => '1',
						'type' => 'text',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '1',
						'ifasearch' => '1',
						'threadshow' => '1',
						'ifmust' => '1',
						'textsize' => '50',
						'descrip' => '',
					),
					array(
						'name' => '价格',
						'vieworder' => '3',
						'type' => 'text',
						'rules' => array(
							'minnum' => '1',
							'maxnum' => '100000000',
						),
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '1',
						'ifmust' => '1',
						'textsize' => '0',
						'descrip' => '元（人民币）',
					),
					array(
						'name' => '房屋类型',
						'vieworder' => '4',
						'type' => 'radio',
						'rules' => array(
							'0' => '1=住宅',
							'1' => '2=民房',
							'2' => '3=别墅',
							'3' => '4=商铺',
							'4' => '5=经济适用房',
						),
						'ifable' => '1',
						'ifsearch' => '1',
						'ifasearch' => '1',
						'threadshow' => '0',
						'ifmust' => '1',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '来源',
						'vieworder' => '6',
						'type' => 'radio',
						'rules' => array(
							'0' => '1=个人',
							'1' => '2=中介',
						),
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '1',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '楼层',
						'vieworder' => '7',
						'type' => 'number',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '/',
						'vieworder' => '7',
						'type' => 'number',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '例如：2/6，表示第2层，总共6层。',
					),
					array(
						'name' => '房屋状态',
						'vieworder' => '5',
						'type' => 'select',
						'rules' => array(
							'0' => '1=现房',
							'1' => '2=期房',
							'2' => '3=尾房',
						),
						'ifable' => '1',
						'ifsearch' => '1',
						'ifasearch' => '1',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '建筑面积',
						'vieworder' => '8',
						'type' => 'number',
						'rules' => array(
							'minnum' => '1',
							'maxnum' => '10000',
						),
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '1',
						'ifmust' => '1',
						'textsize' => '0',
						'descrip' => '平方米',
					),
					array(
						'name' => '建筑年代',
						'vieworder' => '9',
						'type' => 'select',
						'rules' => array(
							'0' => '1=1991',
							'1' => '2=1992',
							'2' => '3=1993',
							'3' => '4=1994',
							'4' => '5=1995',
							'5' => '6=1996',
							'6' => '7=1997',
							'7' => '8=1998',
							'8' => '9=1999',
							'9' => '10=2000',
							'10' => '11=2001',
							'11' => '12=2002',
							'12' => '13=2003',
							'13' => '14=2004',
							'14' => '15=2005',
							'15' => '16=2006',
							'16' => '17=2007',
							'17' => '18=2008',
							'18' => '19=2009',
						),
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '1',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '年',
					),
					array(
						'name' => '特色房屋',
						'vieworder' => '10',
						'type' => 'radio',
						'rules' => array(
							'0' => '1=地铁房',
							'1' => '2=学区房',
							'2' => '3=婚房',
							'3' => '4=海景房',
							'4' => '5=湖景房',
							'5' => '6=江景房',
							'6' => '7=赡老房',
							'7' => '8=其他',
						),
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '1',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '装修情况',
						'vieworder' => '11',
						'type' => 'radio',
						'rules' => array(
							'0' => '1=全部',
							'1' => '2=毛坯',
							'2' => '3=简装',
							'3' => '4=中装',
							'4' => '5=精装',
						),
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '1',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '户型{#}室',
						'vieworder' => '12',
						'type' => 'select',
						'rules' => array(
							'0' => '1=0',
							'1' => '2=1',
							'2' => '3=2',
							'3' => '4=3',
							'4' => '5=4',
							'5' => '6=5',
							'6' => '7=6',
						),
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '{#}厅',
						'vieworder' => '12',
						'type' => 'select',
						'rules' => array(
							'0' => '1=0',
							'1' => '2=1',
							'2' => '3=2',
							'3' => '4=3',
							'4' => '5=4',
							'5' => '6=5',
							'6' => '7=6',
						),
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '{#}卫',
						'vieworder' => '12',
						'type' => 'select',
						'rules' => array(
							'0' => '1=0',
							'1' => '2=1',
							'2' => '3=2',
							'3' => '4=3',
							'4' => '5=4',
							'5' => '6=5',
							'6' => '7=6',
						),
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '{#}阳台',
						'vieworder' => '12',
						'type' => 'select',
						'rules' => array(
							'0' => '1=0',
							'1' => '2=1',
							'2' => '3=2',
							'3' => '4=3',
							'4' => '5=4',
							'5' => '6=5',
							'6' => '7=6',
						),
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '',
					),

					array(
						'name' => '电话',
						'vieworder' => '13',
						'type' => 'number',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '10',
						'descrip' => '',
					),
					array(
						'name' => '-',
						'vieworder' => '13',
						'type' => 'number',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '20',
						'descrip' => '例如：0571-12345678',
					),
					array(
						'name' => '手机',
						'vieworder' => '14',
						'type' => 'text',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '地址',
						'vieworder' => '15',
						'type' => 'text',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '50',
						'descrip' => '',
					),
					array(
						'name' => '有效期',
						'vieworder' => '16',
						'type' => 'select',
						'rules' => array(
							'0' => '1=一星期',
							'1' => '2=半个月',
							'2' => '3=一个月',
							'3' => '4=三个月',
							'4' => '5=半年',
							'5' => '6=一年',
							'6' => '7=长期',
						),
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '房屋图片',
						'vieworder' => '17',
						'type' => 'upload',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '',
					),
				),
			),
		),
	),
	array(
		'name' => '美食分类',
		'ifable' => '1',
		'vieworder' => '2',
		'ifdel' => '1',
		'topicmodel' => array(
			array(
				'name' => '美食',
				'ifable' => '1',
				'vieworder' => '0',
				'topicfield' => array(
					array(
						'name' => '店名',
						'vieworder' => '1',
						'type' => 'text',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '1',
						'ifasearch' => '1',
						'threadshow' => '1',
						'ifmust' => '1',
						'textsize' => '50',
						'descrip' => '',
					),
					array(
						'name' => '经营性质',
						'vieworder' => '2',
						'type' => 'radio',
						'rules' => array(
							'0' => '1=中餐 ',
							'1' => '2=西餐 ',
							'2' => '3=快餐 ',
							'3' => '4=小吃 ',
							'4' => '5=其它 ',
						),
						'ifable' => '1',
						'ifsearch' => '1',
						'ifasearch' => '1',
						'threadshow' => '1',
						'ifmust' => '1',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '美食分类',
						'vieworder' => '3',
						'type' => 'radio',
						'rules' => array(
							'0' => '1=江浙菜 ',
							'1' => '2=川菜 ',
							'2' => '3=湘菜 ',
							'3' => '4=粤菜 ',
							'4' => '5=东北菜 ',
							'5' => '6=日韩菜 ',
							'6' => '7=特色菜 ',
							'7' => '8=西餐 ',
							'8' => '9=快餐 ',
							'9' => '10=海鲜 ',
							'10' => '11=烧烤 ',
							'11' => '12=火锅 ',
							'12' => '13=清真 ',
							'13' => '14=小吃 ',
							'14' => '15=蛋糕面包 ',
							'15' => '16=甜点饮料 ',
						),
						'ifable' => '1',
						'ifsearch' => '1',
						'ifasearch' => '1',
						'threadshow' => '1',
						'ifmust' => '1',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '区域',
						'vieworder' => '4',
						'type' => 'select',
						'rules' => array(
							'0' => '1=杭州',
							'1' => '2=西湖区',
							'2' => '3=拱墅区',
							'3' => '4=下城区',
							'4' => '5=上城区',
							'5' => '6=下沙区',
							'6' => '7=滨江区',
						),
						'ifable' => '1',
						'ifsearch' => '1',
						'ifasearch' => '1',
						'threadshow' => '1',
						'ifmust' => '1',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '电话',
						'vieworder' => '5',
						'type' => 'text',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '10',
						'descrip' => '',
					),
					array(
						'name' => '-',
						'vieworder' => '5',
						'type' => 'text',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '20',
						'descrip' => '例如：0571-12345678',
					),
					array(
						'name' => '地址',
						'vieworder' => '7',
						'type' => 'text',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '1',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '50',
						'descrip' => '',
					),
					array(
						'name' => '公交',
						'vieworder' => '8',
						'type' => 'text',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '50',
						'descrip' => '',
					),
					array(
						'name' => '车位',
						'vieworder' => '9',
						'type' => 'text',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '50',
						'descrip' => '',
					),
					array(
						'name' => '营业时间',
						'vieworder' => '10',
						'type' => 'text',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '-',
						'vieworder' => '10',
						'type' => 'text',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '例如：上午9点-晚上10点',
					),
					array(
						'name' => '营业状态',
						'vieworder' => '12',
						'type' => 'radio',
						'rules' => array(
							'0' => '1=营业中',
							'1' => '2=已歇业',
						),
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '1',
						'threadshow' => '0',
						'ifmust' => '1',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '图片上传',
						'vieworder' => '13',
						'type' => 'upload',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '',
					),
				),
			),
		),
	),
	array(
		'name' => '婚庆婚介',
		'ifable' => '1',
		'vieworder' => '3',
		'ifdel' => '1',
		'topicmodel' => array(
			array(
				'name' => '婚庆婚介',
				'ifable' => '1',
				'vieworder' => '0',
				'topicfield' => array(
					array(
						'name' => '店名',
						'vieworder' => '1',
						'type' => 'text',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '1',
						'ifasearch' => '1',
						'threadshow' => '1',
						'ifmust' => '1',
						'textsize' => '50',
						'descrip' => '',
					),
					array(
						'name' => '经营性质',
						'vieworder' => '2',
						'type' => 'radio',
						'rules' => array(
							'0' => '1=婚介交友',
							'1' => '2=婚庆服务',
						),
						'ifable' => '1',
						'ifsearch' => '1',
						'ifasearch' => '1',
						'threadshow' => '1',
						'ifmust' => '1',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '区域',
						'vieworder' => '3',
						'type' => 'select',
						'rules' => array(
							'0' => '1=杭州',
							'1' => '2=西湖区',
							'2' => '3=拱墅区',
							'3' => '4=下城区',
							'4' => '5=上城区',
							'5' => '6=下沙区',
							'6' => '7=滨江区',
						),
						'ifable' => '1',
						'ifsearch' => '1',
						'ifasearch' => '1',
						'threadshow' => '1',
						'ifmust' => '1',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '电话',
						'vieworder' => '4',
						'type' => 'text',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '10',
						'descrip' => '',
					),
					array(
						'name' => '-',
						'vieworder' => '4',
						'type' => 'text',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '20',
						'descrip' => '例如，0571-12345678',
					),
					array(
						'name' => '地址',
						'vieworder' => '6',
						'type' => 'text',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '1',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '50',
						'descrip' => '',
					),
					array(
						'name' => '公交',
						'vieworder' => '7',
						'type' => 'text',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '50',
						'descrip' => '',
					),
					array(
						'name' => '车位',
						'vieworder' => '8',
						'type' => 'text',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '50',
						'descrip' => '',
					),
					array(
						'name' => '营业时间',
						'vieworder' => '9',
						'type' => 'text',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '-',
						'vieworder' => '9',
						'type' => 'text',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '例如：上午9点-晚上10点',
					),
					array(
						'name' => '营业状态',
						'vieworder' => '11',
						'type' => 'radio',
						'rules' => array(
							'0' => '1=营业中',
							'1' => '2=已歇业',
						),
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '1',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '图片上传',
						'vieworder' => '12',
						'type' => 'upload',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '',
					),
				),
			),
		),
	),
	array(
		'name' => '母婴分类',
		'ifable' => '1',
		'vieworder' => '1',
		'ifdel' => '1',
		'topicmodel' => array(
			array(
				'name' => '母婴',
				'ifable' => '1',
				'vieworder' => '0',
				'topicfield' => array(
					array(
						'name' => '店名',
						'vieworder' => '1',
						'type' => 'text',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '1',
						'ifasearch' => '1',
						'threadshow' => '1',
						'ifmust' => '1',
						'textsize' => '50',
						'descrip' => '',
					),
					array(
						'name' => '经营性质',
						'vieworder' => '2',
						'type' => 'radio',
						'rules' => array(
							'0' => '1=母婴产品',
							'1' => '2=儿童服装',
							'2' => '3=美容美体',
							'3' => '4=早教机构',
							'4' => '5=出行游乐',
							'5' => '6=婴儿摄影',
							'6' => '7=家政月嫂',
						),
						'ifable' => '1',
						'ifsearch' => '1',
						'ifasearch' => '1',
						'threadshow' => '1',
						'ifmust' => '1',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '区域',
						'vieworder' => '3',
						'type' => 'select',
						'rules' => array(
							'0' => '1=杭州',
							'1' => '2=西湖区',
							'2' => '3=拱墅区',
							'3' => '4=下城区',
							'4' => '5=上城区',
							'5' => '6=下沙区',
							'6' => '7=滨江区',
						),
						'ifable' => '1',
						'ifsearch' => '1',
						'ifasearch' => '1',
						'threadshow' => '1',
						'ifmust' => '1',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '电话',
						'vieworder' => '4',
						'type' => 'text',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '10',
						'descrip' => '',
					),
					array(
						'name' => '-',
						'vieworder' => '4',
						'type' => 'text',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '20',
						'descrip' => '例如，0571-12345678',
					),
					array(
						'name' => '地址',
						'vieworder' => '6',
						'type' => 'text',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '1',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '50',
						'descrip' => '',
					),
					array(
						'name' => '公交',
						'vieworder' => '7',
						'type' => 'text',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '50',
						'descrip' => '',
					),
					array(
						'name' => '车位',
						'vieworder' => '8',
						'type' => 'text',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '50',
						'descrip' => '',
					),
					array(
						'name' => '营业时间',
						'vieworder' => '9',
						'type' => 'text',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '-',
						'vieworder' => '9',
						'type' => 'text',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '例如：上午9点-晚上10点',
					),
					array(
						'name' => '营业状态',
						'vieworder' => '11',
						'type' => 'radio',
						'rules' => array(
							'0' => '1=营业中',
							'1' => '2=已歇业',
						),
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '1',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '图片上传',
						'vieworder' => '12',
						'type' => 'upload',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '',
					),
				),
			),
		),
	),
	array(
		'name' => '汽车交易',
		'ifable' => '1',
		'vieworder' => '5',
		'ifdel' => '1',
		'topicmodel' => array(
			array(
				'name' => '出售',
				'ifable' => '1',
				'vieworder' => '0',
				'topicfield' => array(
					array(
						'name' => '卖家身份',
						'vieworder' => '1',
						'type' => 'radio',
						'rules' => array(
							'0' => '1=个人',
							'1' => '2=出租公司',
						),
						'ifable' => '1',
						'ifsearch' => '1',
						'ifasearch' => '1',
						'threadshow' => '0',
						'ifmust' => '1',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '车辆类型',
						'vieworder' => '2',
						'type' => 'checkbox',
						'rules' => array(
							'0' => '1=微型车',
							'1' => '2=小型轿车',
							'2' => '3=紧凑型轿车',
							'3' => '4=中型轿车',
							'4' => '5=豪华型轿车',
							'5' => '6=面包车',
							'6' => '7=越野车',
							'7' => '8=跑车',
							'8' => '9=SUV/SRV',
							'9' => '10=MPV',
							'10' => '11=客车/中巴',
							'11' => '12=货车/皮卡',
							'12' => '13=厢式货车',
							'13' => '14=工程车辆',
							'14' => '15=其他',
						),
						'ifable' => '1',
						'ifsearch' => '1',
						'ifasearch' => '1',
						'threadshow' => '1',
						'ifmust' => '1',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '车辆型号',
						'vieworder' => '3',
						'type' => 'text',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '1',
						'ifasearch' => '1',
						'threadshow' => '1',
						'ifmust' => '1',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '新旧程度',
						'vieworder' => '4',
						'type' => 'select',
						'rules' => array(
							'0' => '1=全新',
							'1' => '2=9成',
							'2' => '3=8成',
							'3' => '4=7成',
							'4' => '5=6成',
							'5' => '6=5成',
							'6' => '7=5成以下',
						),
						'ifable' => '1',
						'ifsearch' => '1',
						'ifasearch' => '1',
						'threadshow' => '1',
						'ifmust' => '1',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '预售价位',
						'vieworder' => '5',
						'type' => 'number',
						'rules' => array(
							'minnum' => '1',
							'maxnum' => '10000000',
						),
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '1',
						'textsize' => '0',
						'descrip' => '元',
					),
					array(
						'name' => '电话',
						'vieworder' => '6',
						'type' => 'text',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '10',
						'descrip' => '',
					),
					array(
						'name' => '-',
						'vieworder' => '6',
						'type' => 'text',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '20',
						'descrip' => '例如：0571-12345678',
					),
					array(
						'name' => '手机',
						'vieworder' => '7',
						'type' => 'text',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '地址',
						'vieworder' => '8',
						'type' => 'text',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '50',
						'descrip' => '',
					),
					array(
						'name' => '联系人',
						'vieworder' => '9',
						'type' => 'text',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '车辆图片',
						'vieworder' => '10',
						'type' => 'upload',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '',
					),
				),
			),
			array(
				'name' => '出租',
				'ifable' => '1',
				'vieworder' => '0',
				'topicfield' => array(
					array(
						'name' => '出租者身份',
						'vieworder' => '1',
						'type' => 'radio',
						'rules' => array(
							'0' => '1=个人',
							'1' => '2=出租公司',
						),
						'ifable' => '1',
						'ifsearch' => '1',
						'ifasearch' => '1',
						'threadshow' => '0',
						'ifmust' => '1',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '车辆类型',
						'vieworder' => '2',
						'type' => 'checkbox',
						'rules' => array(
							'0' => '1=微型车',
							'1' => '2=小型轿车',
							'2' => '3=紧凑型轿车',
							'3' => '4=中型轿车',
							'4' => '5=豪华型轿车',
							'5' => '6=面包车',
							'6' => '7=越野车',
							'7' => '8=跑车',
							'8' => '9=SUV/SRV',
							'9' => '10=MPV',
							'10' => '11=客车/中巴',
							'11' => '12=货车/皮卡',
							'12' => '13=厢式货车',
							'13' => '14=工程车辆',
							'14' => '15=其他',
						),
						'ifable' => '1',
						'ifsearch' => '1',
						'ifasearch' => '1',
						'threadshow' => '0',
						'ifmust' => '1',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '车辆型号',
						'vieworder' => '3',
						'type' => 'text',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '1',
						'ifasearch' => '1',
						'threadshow' => '1',
						'ifmust' => '1',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '出租价格',
						'vieworder' => '5',
						'type' => 'text',
						'rules' => array(
							'minnum' => '1',
							'maxnum' => '10000000',
						),
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '1',
						'ifmust' => '1',
						'textsize' => '0',
						'descrip' => '元/天',
					),
					array(
						'name' => '电话',
						'vieworder' => '8',
						'type' => 'text',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '10',
						'descrip' => '',
					),
					array(
						'name' => '-',
						'vieworder' => '8',
						'type' => 'text',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '20',
						'descrip' => '例如，0571-12345678',
					),
					array(
						'name' => '手机',
						'vieworder' => '9',
						'type' => 'text',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '地址',
						'vieworder' => '10',
						'type' => 'text',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '50',
						'descrip' => '',
					),
					array(
						'name' => '联系人',
						'vieworder' => '11',
						'type' => 'text',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '车辆图片',
						'vieworder' => '12',
						'type' => 'upload',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '服务内容',
						'vieworder' => '4',
						'type' => 'checkbox',
						'rules' => array(
							'0' => '1=班车接送',
							'1' => '2=个人单位长租短包',
							'2' => '3=会展服务',
							'3' => '4=婚庆服务',
							'4' => '5=机场接送',
							'5' => '6=商务旅游',
							'6' => '7=其他',
						),
						'ifable' => '1',
						'ifsearch' => '1',
						'ifasearch' => '1',
						'threadshow' => '1',
						'ifmust' => '1',
						'textsize' => '0',
						'descrip' => '',
					),
					array(
						'name' => '押金',
						'vieworder' => '6',
						'type' => 'text',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '元',
					),
					array(
						'name' => '里程限制',
						'vieworder' => '7',
						'type' => 'text',
						'rules' => false,
						'ifable' => '1',
						'ifsearch' => '0',
						'ifasearch' => '0',
						'threadshow' => '0',
						'ifmust' => '0',
						'textsize' => '0',
						'descrip' => '公里',
					),
				),
			),
		),
	),
);

$fieldid = $cateid = $modelid = 0;
foreach ($topicdata as $cate) {
	$cate['cateid'] = ++$cateid;
	$models = $cate['topicmodel'];
	unset($cate['topicmodel']);
	$db->update("REPLACE INTO pw_topiccate SET " . pwSqlSingle($cate));

	foreach ($models as $model) {
		$model['cateid'] = $cateid;
		$model['modelid'] = ++$modelid;
		$fields = $model['topicfield'];
		unset($model['topicfield']);
		$db->update("REPLACE INTO pw_topicmodel SET " . pwSqlSingle($model));
		$tablename = 'pw_topicvalue'.intval($modelid);
		$fieldsql = 'tid mediumint(8) unsigned NOT NULL,fid smallint(6) unsigned NOT NULL,ifrecycle TINYINT(1) NOT NULL default 0';
		$indexsql = 'PRIMARY KEY (tid)';
		foreach ($fields as $field) {
			$field['fieldid'] = ++$fieldid;
			$field['modelid'] = $modelid;
			$fieldname = $field['fieldname'] = 'field'.$fieldid;
			$field['rules'] = serialize($field['rules']);
			$db->update("REPLACE INTO pw_topicfield SET ".pwSqlSingle($field,false));

			if (in_array($field['type'],array('number','calendar'))) {
				$sql = "INT(10) UNSIGNED NOT NULL default '0'";
			} elseif (in_array($field['type'],array('radio','select'))){
				$sql = "TINYINT(3) UNSIGNED NOT NULL default '0'";
			} elseif ($field['type'] == 'textarea') {
				$sql = "TEXT NOT NULL";
			} else {
				$sql = "VARCHAR(255) NOT NULL";
			}
			$fieldsql .= ",$fieldname $sql";
			$field['ifindex'] && $indexsql .= ",KEY $fieldname ($fieldname)";
		}
		$fieldsql = trim($fieldsql,',');
		$indexsql = trim($indexsql,',');
		$db->query("DROP TABLE IF EXISTS $tablename");
		$createsql = 'CREATE TABLE '.$tablename.' ('.$fieldsql.($indexsql ? ','.$indexsql : '').')';
		if ($db->server_info() >= '4.1') {
			$extra = " ENGINE=MyISAM".($charset ? " DEFAULT CHARSET=$charset" : '');
		} else {
			$extra = " TYPE=MyISAM";
		}
		$createsql = $createsql.$extra;
		$db->query($createsql);
	}
}
require_once (R_P.'admin/cache.php');
updatecache_topic();
?>