<?php

/*
	[Discuz!] (C)2001-2007 Comsenz Inc.
	This is NOT a freeware, use is subject to license terms

	$Id: logs.inc.php 13402 2008-04-14 02:00:24Z liuqiang $
*/

if(!defined('IN_DISCUZ') || !defined('IN_ADMINCP')) {
        exit('Access Denied');
}

cpheader();

$lpp = empty($lpp) ? 20 : $lpp;
$checklpp = array();
$checklpp[$lpp] = 'selected="selected"';

if(!in_array($operation, array('illegal', 'rate', 'credits', 'mods', 'medals', 'ban', 'cp', 'magic', 'error', 'invite'))) {
	cpmsg('undefined_action', '', 'error');
}
$logdir = DISCUZ_ROOT.'./forumdata/logs/';
$logfiles = get_log_files($logdir, $operation.'log');
$logs = array();
foreach($logfiles as $logfile) {
	$logs = array_merge($logs, file($logdir.$logfile));
}


$page = max(1, intval($page));
$start = ($page - 1) * $lpp;
$logs = array_reverse($logs);

if(empty($keyword)) {
	$num = count($logs);
	$multipage = multi($num, $lpp, $page, "admincp.php?action=logs&operation=$operation&lpp=$lpp", 0, 3);
	$logs = array_slice($logs, $start, $lpp);

} else {
	foreach($logs as $key => $value) {
		if(strpos($value, $keyword) === FALSE) {
			unset($logs[$key]);
		}
	}
	$multipage = '';
}

$usergroup = array();
if(in_array($operation, array('rate', 'mods', 'ban', 'cp'))) {
	$query = $db->query("SELECT groupid, grouptitle FROM {$tablepre}usergroups");
	while($group = $db->fetch_array($query)) {
		$usergroup[$group['groupid']] = $group['grouptitle'];
	}
}

shownav('tools', 'nav_logs', 'nav_logs_'.$operation);
showsubmenu('nav_logs', array(
	array('nav_logs_illegal', 'logs&operation=illegal', $operation == 'illegal'),
	array('nav_logs_rate', 'logs&operation=rate', $operation == 'rate'),
	array('nav_logs_credits', 'logs&operation=credits', $operation == 'credits'),
	array('nav_logs_mods', 'logs&operation=mods', $operation == 'mods'),
	array('nav_logs_medals', 'logs&operation=medals', $operation == 'medals'),
	array('nav_logs_ban', 'logs&operation=ban', $operation == 'ban'),
	array('nav_logs_cp', 'logs&operation=cp', $operation == 'cp'),
	array('nav_logs_magic', 'logs&operation=magic', $operation == 'magic'),
	array('nav_logs_invite', 'logs&operation=invite', $operation == 'invite'),
	array('nav_logs_error', 'logs&operation=error', $operation == 'error')
));
showformheader("logs&operation=$operation");
showtableheader('', 'fixpadding');
$filters = '';
if($operation == 'illegal') {

	showtablerow('', array('class="td23"','class="td23"','class="td23"','class="td23"','class="td23"'), array(
		lang('logs_passwd_username'),
		lang('logs_passwd_password'),
		lang('logs_passwd_security'),
		lang('ip'),
		lang('time'),
	));

	foreach($logs as $logrow) {
		$log = explode("\t", $logrow);
		if(empty($log[1])) {
			continue;
		}
		$log[1] = gmdate('y-n-j H:i', $log[1] + $timeoffset * 3600);
		if(strtolower($log[2]) == strtolower($discuz_userss)) {
			$log[2] = "<b>$log[2]</b>";
		}
		$log[5] = $allowviewip ? $log[5] : '-';

		showtablerow('', array('class="bold"'), array(
			$log[2],
			$log[3],
			$log[4],
			$log[5],
			$log[1]
		));

	}

} elseif($operation == 'rate') {

	showtablerow('', array('class="td23"','class="td23"','class="td23"','class="td23"','class="td23"','class="td24"'), array(
		lang('username'),
		lang('usergroup'),
		lang('time'),
		lang('logs_rating_username'),
		lang('logs_rating_rating'),
		lang('subject'),
		lang('reason'),
	));

	foreach($logs as $logrow) {
		$log = explode("\t", $logrow);
		if(empty($log[1])) {
			continue;
		}
		$log[1] = gmdate('y-n-j H:i', $log[1] + $timeoffset * 3600);
		$log[2] = "<a href=\"space.php?username=".rawurlencode($log[2])."\" target=\"_blank\">$log[2]</a>";
		$log[3] = $usergroup[$log[3]];
		if($log[4] == $discuz_userss) {
			$log[4] = "<b>$log[4]</b>";
		}
		$log[4] = "<a href=\"space.php?username=".rawurlencode($log[4])."\" target=\"_blank\">$log[4]</a>";
		$log[6] = $extcredits[$log[5]]['title'].' '.($log[6] < 0 ? "<b>$log[6]</b>" : "+$log[6]").' '.$extcredits[$log[5]]['unit'];
		$log[7] = $log[7] ? "<a href=\"./viewthread.php?tid=$log[7]\" target=\"_blank\" title=\"$log[8]\">".cutstr($log[8], 20)."</a>" : "<i>$lang[logs_rating_manual]</i>";

		showtablerow('', array('class="bold"'), array(
			$log[2],
			$log[3],
			$log[1],
			$log[4],
			(trim($log[10]) == 'D' ? $lang['logs_rating_delete'] : '').$log[6],
			$log[7],
			$log[9]
		));
	}

} elseif($operation == 'credits') {

	showtablerow('', array('class="td23"','class="td23"','class="td23"','class="td24"','class="td24"'), array(
		lang('username'),
		lang('logs_credit_fromto'),
		lang('time'),
		lang('logs_credit_send'),
		lang('logs_credit_receive'),
		lang('action'),
	));

	$lpp = max(5, empty($lpp) ? 50 : intval($lpp));
	$page = max(1, intval($page));
	$start_limit = ($page - 1) * $lpp;

	$keywordadd = !empty($keyword) ? "AND c.fromto LIKE '%$keyword%'" : '';

	$mpurl = "admincp.php?action=logs&operation=$operation&keyword=".rawurlencode($keyword)."&lpp=$lpp";
	if(in_array($opt, array('TFR', 'RCV', 'EXC', 'UGP', 'AFD'))) {
		$optadd = "AND c.operation='$opt'";
		$mpurl .= '&opt='.$opt;
	} else {
		$optadd = '';
	}

	$num = $db->result_first("SELECT COUNT(*) FROM {$tablepre}creditslog c WHERE 1 $keywordadd $optadd");

	$multipage = multi($num, $lpp, $page, $mpurl, 0, 3);

	$filters .= '<select onchange="window.location=(\'admincp.php?action=logs&operation=credits&opt=\'+this.options[this.selectedIndex].value)"><option value="">'.$lang['action'].'</option><option value="">'.$lang['all'].'</option>';
	foreach(array('TFR', 'RCV', 'EXC', 'UGP', 'AFD') as $o) {
		$filters .= '<option value="'.$o.'" '.(!empty($opt) && $o == $opt ? 'selected="selected"' : '').'>'.$lang['logs_credit_operation_'.strtolower($o)].'</option>';
	}
	$filters .= '</select>';

	$total['send'] = $total['receive'] = array();
	$query = $db->query("SELECT c.*, m.username FROM {$tablepre}creditslog c
		LEFT JOIN {$tablepre}members m USING (uid)
		WHERE 1 $keywordadd $optadd ORDER BY dateline DESC LIMIT $start_limit, $lpp");

	while($log = $db->fetch_array($query)) {
		$total['send'][$log['sendcredits']] += $log['send'];
		$total['receive'][$log['receivecredits']] += $log['receive'];
		$log['dateline'] = gmdate('y-n-j H:i', $log['dateline'] + $timeoffset * 3600);
		$log['operation'] = $lang['logs_credit_operation_'.strtolower($log['operation'])];
		showtablerow('', array('class="bold"'), array(
			"<a href=\"space.php?username=".rawurlencode($log['username'])."\" target=\"_blank\">$log[username]",
			$log[fromto],
			$log[dateline],
			isset($extcredits[$log['sendcredits']]) ? $extcredits[$log['sendcredits']]['title'].' '.$log['send'].' '.$extcredits[$log['sendcredits']]['unit'] : $log['send'],
			isset($extcredits[$log['receivecredits']]) ? $extcredits[$log['receivecredits']]['title'].' '.$log['receive'].' '.$extcredits[$log['receivecredits']]['unit'] : $log['receive'],
			$log[operation],
		));
	}

	$result = array('send' => array(), 'receive' => array());
	foreach(array('send', 'receive') as $key) {
		foreach($total[$key] as $id => $amount) {
			if(isset($extcredits[$id])) {
				$result[$key][] = $extcredits[$id]['title'].' '.$amount.' '.$extcredits[$id]['unit'];
			}
		}
	}

	showtablerow('', '', array(
		'',
		'',
		'',
		$lang['logs_credit_total'].implode('; ', $result['send']),
		$lang['logs_credit_total'].implode(', ', $result['receive']),
		''
	));

} elseif($operation == 'mods') {

	include language('modactions');

	showtablerow('', array('class="td23"','class="td23"','class="td23"','class="td23"','class="td24"','class="td24"','class="td23"'), array(
		lang('operator'),
		lang('usergroup'),
		lang('ip'),
		lang('time'),
		lang('forum'),
		lang('thread'),
		lang('action'),
		lang('reason'),
	));

	foreach($logs as $logrow) {
		$log = explode("\t", $logrow);
		if(empty($log[1])) {
			continue;
		}
		$log[1] = gmdate('y-n-j H:i', $log[1] + $timeoffset * 3600);
		$log[2] = stripslashes($log[2]);
		$log[3] = $usergroup[$log[3]];
		$log[4] = $allowviewip ? $log[4] : '-';
		$log[6] = "<a href=\"./forumdisplay.php?fid=$log[5]\" target=\"_blank\">$log[6]</a>";
		$log[8] = "<a href=\"./viewthread.php?tid=$log[7]\" target=\"_blank\" title=\"$log[8]\">".cutstr($log[8], 15)."</a>";
		$log[9] = $modactioncode[trim($log[9])];
		showtablerow('', array('class="bold"'), array(
			"<a href=\"space.php?username=".rawurlencode($log[2])."\" target=\"_blank\">".($log[2] != $discuz_userss ? "<b>$log[2]</b>" : $log[2]),
			$log[3],
			$log[4],
			$log[1],
			$log[6],
			$log[8],
			$log[9],
			$log[10],
		));
	}

} elseif($operation == 'ban') {

	showtablerow('', array('class="td23"', 'class="td23"', 'class="td23"', 'class="td23"', 'class="td23"', 'class="td23"', 'class="td24"', 'class="td23"'), array(
		lang('operator'),
		lang('usergroup'),
		lang('ip'),
		lang('time'),
		lang('username'),
		lang('operation'),
		lang('logs_banned_group'),
		lang('validity'),
		lang('reason'),
	));

	foreach($logs as $logrow) {
		$log = explode("\t", $logrow);
		if(empty($log[1])) {
			continue;
		}
		$log[1] = gmdate('y-n-j H:i', $log[1] + $timeoffset * 3600);
		$log[2] = "<a href=\"space.php?username=".rawurlencode($log[2])."\" target=\"_blank\">$log[2]";
		$log[3] = $usergroup[$log[3]];
		$log[4] = $allowviewip ? $log[4] : '-';
		$log[5] = "<a href=\"space.php?username=".rawurlencode($log[5])."\" target=\"_blank\">$log[5]</a>";
		$log[8] = trim($log[8]) ? gmdate('y-n-j', $log[8] + $timeoffset * 3600) : '';
		showtablerow('', array('class="bold"'), array(
			$log[2],
			$log[3],
			$log[4],
			$log[1],
			$log[5],
			(in_array($log[6], array(4, 5)) && !in_array($log[7], array(4, 5)) ? '<i>'.$lang['logs_banned_unban'].'</i>' : '<b>'.$lang['logs_banned_ban'].'</b>'),
			"{$usergroup[$log[6]]} / {$usergroup[$log[7]]}",
			$log[8],
			$log[9]
		));
	}

} elseif($operation == 'cp') {

	showtablerow('', array('class="td23"','class="td23"','class="td23"','class="td24"','class="td24"', ''), array(
		lang('operator'),
		lang('usergroup'),
		lang('ip'),
		lang('time'),
		lang('action'),
		lang('other')
	));

	foreach($logs as $logrow) {
		$log = explode("\t", $logrow);
		if(empty($log[1])) {
			continue;
		}
		$log[1] = gmdate('y-n-j H:i', $log[1] + $timeoffset * 3600);
		$log[2] = stripslashes($log[2]);
		$log[2] = "<a href=\"space.php?username=".rawurlencode($log[2])."\" target=\"_blank\">".($log[2] != $discuz_userss ? "<b>$log[2]</b>" : $log[2])."</a>";
		$log[3] = $usergroup[$log[3]];
		$log[4] = $allowviewip ? $log[4] : '-';
		$log[5] = $lang['cplog_'.rtrim($log[5])];
		$log[6] = cutstr($log[6], 200);
 		showtablerow('', array('class="bold"'), array($log[2], $log[3], $log[4], $log[1], $log[5], $log[6]));
	}

} elseif($operation == 'error') {

	showtablerow('', array('class="td23"', 'class="td24"', 'class="td24"'), array(
		lang('type'),
		lang('username'),
		lang('time'),
		lang('message'),
	));

	foreach($logs as $logrow) {
		$log = explode("\t", $logrow);
		if(empty($log[1])) {
			continue;
		}
		$log[1] = gmdate('y-n-j H:i', $log[1] + $timeoffset * 3600);
		$tmp = explode('&lt;br /&gt;', $log[3]);
		$username = $tmp[1] ? "<a href=\"space.php?username=".rawurlencode($tmp[0])."\" target=\"_blank\">$tmp[0]</a>" : '';
		$ip = $tmp[1] ? $tmp[1] : $tmp[0];

		showtablerow('', array('class="bold"'), array(
			$log[2],
			($username ? $username."<br />" : '').$ip,
			$log[1],
			$log[4]
		));

	}

} elseif($operation == 'invite') {

	if(!submitcheck('invitesubmit')) {
		showtablerow('', array('width="35"','class="td23"','class="td24"','class="td24"','class="td23"','class="td24"','class="td24"'), array(
			'',
			lang('logs_invite_buyer'),
			lang('logs_invite_buydate'),
			lang('logs_invite_expiration'),
			lang('logs_invite_ip'),
			lang('logs_invite_code'),
			lang('logs_invite_status'),
		));

		$tpp = $lpp ? intval($lpp) : $tpp;
		$page = max(1, intval($page));
		$start_limit = ($page - 1) * $tpp;

		$addstatus = '';
		if(in_array($status, array(1,2,3,4))) {
			$statusurl .= '&status='.$status;
			$addstatus = "AND status='$status'";
		}

		$invitecount = $db->result_first("SELECT COUNT(*) FROM {$tablepre}invites WHERE 1 $addstatus");
		$multipage = multi($invitecount, $tpp, $page, "admincp.php?action=logs&operation=invite&lpp=$lpp$statusurl", 0, 3);

		$filters .= '<select onchange="window.location=(\'admincp.php?action=logs&operation=invite&status=\'+this.options[this.selectedIndex].value)"><option value="">'.$lang['action'].'</option><option value="">'.$lang['all'].'</option>';
		foreach(array(1,2,3,4) as $s) {
			$filters .= '<option value="'.$s.'" '.(!empty($status) && $s == $status ? 'selected="selected"' : '').'>'.lang('logs_invite_status_'.$s).'</option>';
		}
		$filters .= '</select>';

		$query = $db->query("SELECT i.*, m.username FROM {$tablepre}invites i, {$tablepre}members m
				WHERE i.uid=m.uid $addstatus
				ORDER BY i.dateline LIMIT $start_limit,$tpp");
		while($invite = $db->fetch_array($query)) {

			$invite['status'] = $lang['invite_status_'.$invite['status']];
			$username = "<a href=\"space.php?uid=$invite[uid]\">$invite[username]</a>";
			$invite['dateline'] = gmdate('Y-n-j H:i', $invite['dateline'] + $timeoffset * 3600);
			$invite['expiration'] = gmdate('Y-n-j H:i', $invite['expiration'] + $timeoffset * 3600);
			$stats = $invite[status].($invite['status'] == 2 ? '&nbsp;[<a href="space.php?uid='.$invite['reguid'].'">'.$lang['logs_invite_target'].'</a>]' : '');

			showtablerow('', array('', 'class="bold"'), array(
				'<input type="checkbox" class="checkbox" name="delete[]" value="'.$invite[invitecode].'" />',
				$username,
				$invite['dateline'],
				$invite['expiration'],
				$invite['inviteip'],
				$invite['invitecode'],
				$stats
			));
		}
	} else {

		if($deletelist = implodeids($delete)) {
			$db->query("DELETE FROM {$tablepre}invites WHERE invitecode IN ($deletelist)");
		}

		header("Location: {$boardurl}admincp.php?action=logs&operation=invite");
	}

} elseif($operation == 'magic') {
	require_once DISCUZ_ROOT.'./forumdata/cache/cache_magics.php';

	$lpp = empty($lpp) ? 50 : $lpp;
	$page = max(1, intval($page));
	$start_limit = ($page - 1) * $lpp;

	$mpurl = "admincp.php?action=logs&operation=magic&lpp=$lpp";

	if(in_array($opt, array('1', '2', '3', '4', '5'))) {
		$optadd = "AND ma.action='$opt'";
		$mpurl .= '&opt='.$opt;
	} else {
		$optadd = '';
	}

	if(!empty($magicid)) {
		$magicidadd = "AND ma.magicid='$magicid'";
	} else {
		$magicidadd = '';
	}

	$num = $db->result_first("SELECT COUNT(*) FROM {$tablepre}magiclog ma WHERE 1 $magicidadd $optadd");

	$multipage = multi($num, $lpp, $page, $mpurl, 0, 3);

	$check1 = $check2 = array();
	$check1[$magicid] = 'selected="selected"';
	$check2[$opt] = 'selected="selected"';

	$filters .= '<select onchange="window.location=(\'admincp.php?action=logs&operation=magic&magicid=\'+this.options[this.selectedIndex].value)"><option value="">'.$lang['magics_type'].'</option><option value="">'.$lang['magics_type_all'].'</option>';
	foreach($_DCACHE['magics'] as $id => $magic) {
		$filters .= '<option value="'.$id.'" '.$check1[$id].'>'.$magic['name'].'</option>';
	}
	$filters .= '</select>';

	$filters .= '<select onchange="window.location=(\'admincp.php?action=logs&operation=magic&opt=\'+this.options[this.selectedIndex].value)"><option value="">'.$lang['action'].'</option><option value="">'.$lang['all'].'</option>';
	foreach(array('1', '2', '3', '4', '5') as $o) {
		$filters .= '<option value="'.$o.'" '.$check2[$o].'>'.$lang['logs_magic_operation_'.$o].'</option>';
	}
	$filters .= '</select>';

	showtablerow('', array('class="td23"', 'class="td23"', 'class="td24"', 'class="td23"', 'class="td23"', 'class="td24"'), array(
		lang('username'),
		lang('name'),
		lang('time'),
		lang('num'),
		lang('price'),
		lang('action')
	));

	$query = $db->query("SELECT ma.*, m.username FROM {$tablepre}magiclog ma
		LEFT JOIN {$tablepre}members m USING (uid)
		WHERE 1 $magicidadd $optadd ORDER BY dateline DESC LIMIT $start_limit, $lpp");

	while($log = $db->fetch_array($query)) {
		$log['name'] = $_DCACHE['magics'][$log['magicid']]['name'];
		$log['dateline'] = gmdate('Y-n-j H:i', $log['dateline'] + $timeoffset * 3600);
		$log['action'] = $lang['logs_magic_operation_'.$log['action']];
		showtablerow('', array('class="bold"'), array(
			"<a href=\"space.php?username=".rawurlencode($log['username'])."\" target=\"_blank\">$log[username]",
			$log[name],
			$log[dateline],
			$log[amount],
			$log[price],
			$log[action]
		));
	}

} elseif($operation == 'medals') {

	require_once DISCUZ_ROOT.'./forumdata/cache/cache_medals.php';

	$lpp = empty($lpp) ? 50 : $lpp;
	$page = max(1, intval($page));
	$start_limit = ($page - 1) * $lpp;

	$mpurl = "admincp.php?action=logs&operation=medals&lpp=$lpp";

	if(in_array($opt, array('0', '1', '2', '3'))) {
		$optadd = "AND me.type='$opt'";
		$mpurl .= '&opt='.$opt;
	} else {
		$optadd = '';
	}

	if(!empty($medalid)) {
		$medalidadd = "AND me.medalid='$medalid'";
	} else {
		$medalidadd = '';
	}

	$num = $db->result_first("SELECT COUNT(*) FROM {$tablepre}medallog me WHERE 1 $medalidadd $optadd");

	$multipage = multi($num, $lpp, $page, $mpurl, 0, 3);

	$check1 = $check2 = array();
	$check1[$medalid] = 'selected="selected"';
	$check2[$opt] = 'selected="selected"';

	$filters .= '<select onchange="window.location=(\'admincp.php?action=logs&operation=medals&medalid=\'+this.options[this.selectedIndex].value)"><option value="">'.$lang['medals'].'</option><option value="">'.$lang['all'].'</option>';
	foreach($_DCACHE['medals'] as $id => $medal) {
		$filters .= '<option value="'.$id.'" '.$check1[$id].'>'.$medal['name'].'</option>';
	}
	$filters .= '</select>';

	$filters .= '<select onchange="window.location=(\'admincp.php?action=logs&operation=medals&opt=\'+this.options[this.selectedIndex].value)"><option value="">'.$lang['action'].'</option><option value="">'.$lang['all'].'</option>';
	foreach(array('0', '1', '2', '3') as $o) {
		$filters .= '<option value="'.$o.'" '.$check2[$o].'>'.$lang['logs_medal_operation_'.$o].'</option>';
	}
	$filters .= '</select>';

	showtablerow('', array('class="td23"', 'class="td24"', 'class="td23"', 'class="td23"'), array(
		lang('username'),
		lang('logs_medal_name'),
		lang('type'),
		lang('time'),
		lang('logs_medal_expiration')
	));

	$query = $db->query("SELECT me.*, m.username FROM {$tablepre}medallog me
		LEFT JOIN {$tablepre}members m USING (uid)
		WHERE 1 $medalidadd $optadd ORDER BY dateline DESC LIMIT $start_limit, $lpp");

	while($log = $db->fetch_array($query)) {
		$log['name'] = $_DCACHE['medals'][$log['medalid']]['name'];
		$log['dateline'] = gmdate('Y-n-j H:i', $log['dateline'] + $timeoffset * 3600);
		$log['expiration'] = empty($log['expiration']) ? lang('logs_noexpire') : gmdate('Y-n-j H:i', $log['expiration'] + $timeoffset * 3600);
		showtablerow('', array('class="td23"', 'class="td24"', 'class="td23"', 'class="td24"'), array(
			"<a href=\"space.php?username=".rawurlencode($log['username'])."\" target=\"_blank\">$log[username]",
			$log['name'],
			$lang['logs_medal_operation_'.$log['type']],
			$log['dateline'],
			$log['expiration']
		));
	}

}

function get_log_files($logdir='', $action='action') {
	$dir = opendir($logdir);
	$files = array();
	while($entry = readdir($dir)) {
		$files[] = $entry;
	}
	closedir($dir);

	sort($files);
	$logfile = $action;
	$logfiles = array();
	foreach($files as $file) {
		if(strpos($file, $logfile) !== FALSE) {
			$logfiles[] = $file;
		}
	}
	$logfiles = array_slice($logfiles, -2, 2);
	return $logfiles;
}

showsubmit($operation == 'invite' ? 'invitesubmit' : '', 'submit', 'del', $filters, $multipage.lang('logs_lpp').':<select onchange="if(this.options[this.selectedIndex].value != \'\') {window.location=(\'admincp.php?action=logs&operation='.$operation.'&lpp=\'+this.options[this.selectedIndex].value+\'&sid='.$sid.'\') }"><option value="20" '.$checklpp[20].'> 20 </option><option value="40" '.$checklpp[40].'> 40 </option><option value="80" '.$checklpp[80].'> 80 </option></select> &nbsp;<input type="text" class="txt" name="keyword" value="'.$keyword.'" /><input type="submit" class="btn" value="'.$lang['search'].'"  />');
showtablefooter();
showformfooter();

?>