<?php

/*
	[ICenter API] (C)2007-2008 2S7 Inc.

*/

if(file_exists('./ic_client/config.inc.php'))
{
 	require_once './ic_client/config.inc.php';
 
}
	define('IN_ICenter', TRUE);
	define('ic_VERSION', '1.0.0');
	define('ic_RELEASE', '20080429');
	define('IC_API_FUNC','IC_API_post');
	define('IC_RT',substr(__FILE__, 0, -11));
	$GLOBALS['ic_controls'] = array();
	include_once 'lib/xml.class.php';
	include_once 'lib/base.php';
		

	function ic_user_install($username, $password,$host='') 
	{
		$return = call_user_func(IC_API_FUNC, 'user', 'install', array('username'=>$username, 'password'=>$password, 'host'=>$host));
		return api_xml_unserialize($return);
	}
	
	function ic_word_segmentation($word) 
	{
		$return = call_user_func(IC_API_FUNC, 'word', 'segmentation', array('apikey'=>IC_APPKEY, 'appid'=>IC_APPID, 'word'=>$word));
		return api_xml_unserialize($return);
	}
	
	function ic_content_question($qid,$type=1) 
	{
		$return = call_user_func(IC_API_FUNC, 'content', 'question', array('apikey'=>IC_APPKEY, 'appid'=>IC_APPID, 'qid'=>$qid, 'type'=>$type));
		return api_xml_unserialize($return);
	}
	
	function ic_content_list($type=0) 
	{
		$return = call_user_func(IC_API_FUNC, 'content', 'list', array('apikey'=>IC_APPKEY, 'appid'=>IC_APPID, 'type'=>$type));
		return api_xml_unserialize($return);
	}
	
	function ic_synchronous_question($title,$content,$tid=0) 
	{
		if(file_exists('ic_client/config.inc.php'))
		{
		if(check_config())//config
	  {
	  	$chkwords = $title.$content;
	  	$keyword=iconv("utf-8","gbk",IC_KEYWORD);
	    $blockword=iconv("utf-8","gbk",IC_BADWORD);
	    //ӱصжϣֹķʷ;
	    if(!CHCEK_API_KeyWord($chkwords,$keyword))
	    {
	    	return array("-19");
	    	exit;
	    }
			if(CHCEK_API_KeyWord($chkwords,$blockword))
	    {
	    	return array("-4");
	    	exit;
	    }
	    if(API_SYN=='1')
	    {
	     $return = call_user_func(IC_API_FUNC, 'synchronous', 'question', array('apikey'=>IC_APPKEY, 'appid'=>IC_APPID, 'tid'=>$tid, 'title'=>$title, 'content'=>$content));
	     $return=api_xml_unserialize($return);
	     if($return[0]==-22)
	     {
	     	 //API_SYN=0
	 	     up_config();
	     }
	    }
	    else
	    {
	    	$return[0] = "-23";
	    }
	    //ûз͵дļ
	    if($return[0]!="0")
		  {
		  	//д־
		  	syn_err($tid,'synchronous question');
	   		write_synfile('1',$tid,$title,$content);
	   	}
		  MakeFile('./ic_client/data','syn_tid_list.txt','|'.$tid.'|');
		  return array($return[0]);
	   	exit;
		}
	 }
		else
		{
		 return array("-8");
	   exit;
		}
	}
	
	function ic_synchronous_answer($tid,$answer) 
	{
		if(file_exists('./ic_client/config.inc.php'))
		{
		$str = file_get_contents('./ic_client/data/syn_tid_list.txt');
	  $newstr=str_replace('|'.$tid.'|',"",$str);
	  if($str!=$newstr)
	  {
	  	if(API_SYN=='1')
		  {
		     $return = call_user_func(IC_API_FUNC, 'synchronous', 'answer', array('apikey'=>IC_APPKEY, 'appid'=>IC_APPID, 'tid'=>$tid, 'answer'=>$answer));
		     $return=api_xml_unserialize($return);
		      if($return[0]==-22)
		      {
		     	  //API_SYN=0
		 	      up_config();
		      }
		  }
		  else
		  {
		  	$return[0] = "-23";
		  }
		  if($return[0]!="0")
		  {
		  	//ûз͵дļ
		 	 syn_err($tid,'synchronous answer');
		  	write_synfile('2',$tid,'',$answer);
		  }
		  return array($return[0]);
	   	exit;
		}
	 }
	}
	
	function ic_asynchronous_main($times) 
	{
		$return = call_user_func(IC_API_FUNC, 'asynchronous', 'main', array('apikey'=>IC_APPKEY, 'appid'=>IC_APPID, 'times'=>$times));
		return api_xml_unserialize($return);
	}
	
	function ic_search_main($word,$type,$page) 
	{
		$return = call_user_func(IC_API_FUNC, 'search', 'main', array('apikey'=>IC_APPKEY, 'appid'=>IC_APPID, 'word'=>$word, 'type'=>$type, 'page'=>$page));
		return api_xml_unserialize($return);
	}
	
	function ic_search_related($word) 
	{
		$return = call_user_func(IC_API_FUNC, 'search', 'related', array('apikey'=>IC_APPKEY, 'appid'=>IC_APPID, 'word'=>$word));
		return api_xml_unserialize($return);
	}
	
	function ic_statistics_main() 
	{
		$return = call_user_func(IC_API_FUNC, 'statistics', 'main', array('apikey'=>IC_APPKEY, 'appid'=>IC_APPID));
		return api_xml_unserialize($return);
	}
	function ic_notice_read() 
	{
		$return = call_user_func(IC_API_FUNC, 'notice', 'read', array('apikey'=>IC_APPKEY, 'appid'=>IC_APPID));
		return api_xml_unserialize($return);
	}
?>