<?php
/*============================*\
|| ###########################||
|| # vBulletin PHPFORCEǿ#||
|| # -------------------------||
|| # http://www.phpforce.cn  #||
|| ###########################||
\*============================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS #######################
define('CVS_REVISION', '$RCSfile: threadcat.php,v $ - $Revision: 1.74 $');

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array();
$specialtemplates = array();

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');

// ############################# LOG ACTION ###############################

$vbulletin->input->clean_array_gpc('r', array(
	'threadcatid' => TYPE_INT
));
log_admin_action(iif($vbulletin->GPC['threadcatid'] != 0, "threadcat id = " . $vbulletin->GPC['threadcatid']));

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

print_cp_header($vbphrase['threadcat_manager']);

if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'modify';
}

// ###################### Start add / edit #######################
if ($_REQUEST['do'] == 'add' OR $_REQUEST['do'] == 'edit')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'forumid' 			=> TYPE_INT,
		'newforumid'		=> TYPE_ARRAY,
		'threadcatid'		=> TYPE_INT
	));

	print_form_header('threadcat', 'update');

	if ($_REQUEST['do'] == 'add')
	{
		if (is_array($vbulletin->GPC['newforumid']))
		{
			foreach($vbulletin->GPC['newforumid'] AS $key => $val)
			{
				$vbulletin->GPC['forumid'] = intval($key);
			}
		}
		$threadcat = array('forumid' => $vbulletin->GPC['forumid'], 'displayorder' => 0);
		print_table_header($vbphrase['add_new_threadcat']);
	}
	else
	{
		$threadcat = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "threadcat WHERE threadcatid = " . $vbulletin->GPC['threadcatid']);

		if (!($permissions['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel']))
		{
			if ($threadcat['forumid'] == -1 AND !($permissions['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['ismoderator']))
			{
				print_stop_message('no_permission');
			}
		}
		if (!can_moderate($threadcat['forumid'], 'candminthreadcat'))
		{
			print_stop_message('no_permission');
		}
		construct_hidden_code('threadcatid', $vbulletin->GPC['threadcatid']);
		print_table_header(construct_phrase($vbphrase['x_y_id_z'], $vbphrase['threadcat'], htmlspecialchars_uni($threadcat['title']), $threadcat['threadcatid']));

	}
	if (can_administer('canadminforums'))
		{
			print_forum_chooser($vbphrase['forum'], 'threadcat[forumid]', $threadcat['forumid'], $vbphrase['all_forums']);
		}
	else
		{
			print_moderator_forum_chooser('threadcat[forumid]', $threadcat['forumid'], $vbphrase['all_forums'], $vbphrase['forum'], iif($issupermod, true, false), false, false,'candminthreadcat');
		}
	print_input_row($vbphrase['title'], 'threadcat[title]', $threadcat['title']);
	print_input_row($vbphrase['titlecolor'], 'threadcat[titlecolor]', $threadcat['titlecolor']);
	print_input_row($vbphrase['threadcaturl'], 'threadcat[url]', $threadcat['url']);
	print_yes_no_row($vbphrase['nodisplaycat'], 'threadcat[nodisplay]', $threadcat['nodisplay']);
	print_input_row($vbphrase['display_order'], 'threadcat[displayorder]', $threadcat['displayorder']);

	print_submit_row($vbphrase['save']);
}

// ###################### Start insert #######################
if ($_POST['do'] == 'update')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'threadcat'			=> TYPE_ARRAY,
		'threadcatid'	 	=> TYPE_INT,
	));

	if (!($permissions['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel']))
	{
		if ($vbulletin->GPC['threadcat']['forumid']== -1 AND !($permissions['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['ismoderator']))
		{
			print_stop_message('no_permission');
		}
	}

	if (!trim($vbulletin->GPC['threadcat']['title']))
	{
		$vbulletin->GPC['threadcat']['title'] = $vbphrase['threadcat'];
	}

	if ($vbulletin->GPC['threadcatid'])
	{
		$db->query_write(fetch_query_sql($vbulletin->GPC['threadcat'], 'threadcat', "WHERE threadcatid = " . $vbulletin->GPC['threadcatid']));
	}
	else
	{
		$db->query_write(fetch_query_sql($vbulletin->GPC['threadcat'], 'threadcat'));
	}

	$threadcats = $db->query_read_slave("
		SELECT *
		FROM " . TABLE_PREFIX . "threadcat AS threadcat
		WHERE forumid = " . $vbulletin->GPC['threadcat']['forumid'] . "
		ORDER BY forumid, url, nodisplay, displayorder
	");

	while ($threadcat = $db->fetch_array($threadcats))
	{
		$threadcatcache[$threadcat['threadcatid']]['title'] = $threadcat['title'];
		$threadcatcache[$threadcat['threadcatid']]['titlecolor'] = $threadcat['titlecolor'];
		$threadcatcache[$threadcat['threadcatid']]['nodisplay'] = $threadcat['nodisplay'];
		$threadcatcache[$threadcat['threadcatid']]['url'] = $threadcat['url'];

	}

	if ($vbulletin->GPC['threadcat']['forumid'] != -1)
	{
		$db->query_write("UPDATE " . TABLE_PREFIX . "forum
			SET threadcatcache = '" . $vbulletin->db->escape_string(trim(serialize($threadcatcache))) . "'
			WHERE forumid = " . $vbulletin->GPC['threadcat']['forumid'] . "
		");
		build_forum_permissions();
	}
	else
	{
		build_datastore('gtcatcache', serialize($threadcatcache));
	}

	define('CP_REDIRECT', 'threadcat.php');
	print_stop_message('saved_threadcat_x_successfully', htmlspecialchars_uni($vbulletin->GPC['threadcat']['title']));

}

// ###################### Start Remove #######################

if ($_REQUEST['do'] == 'remove')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'threadcatid' 	=> TYPE_INT
	));

	print_delete_confirmation('threadcat', $vbulletin->GPC['threadcatid'], 'threadcat', 'kill', 'threadcat');
}

// ###################### Start Kill #######################

if ($_POST['do'] == 'kill')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'threadcatid' 	=> TYPE_INT
	));

	$forum = $db->query_first("SELECT forumid FROM " . TABLE_PREFIX . "threadcat WHERE threadcatid = " . $vbulletin->GPC['threadcatid']);

	$forumid = intval($forum['forumid']);

	$db->query_write("DELETE FROM " . TABLE_PREFIX . "threadcat WHERE threadcatid = " . $vbulletin->GPC['threadcatid']);

	$threadcats = $db->query_read_slave("
		SELECT *
		FROM " . TABLE_PREFIX . "threadcat AS threadcat
		WHERE forumid = " . $forumid . "
		ORDER BY forumid, url, nodisplay, displayorder
	");

	while ($threadcat = $db->fetch_array($threadcats))
	{
		$threadcatcache[$threadcat['threadcatid']]['title'] = $threadcat['title'];
		$threadcatcache[$threadcat['threadcatid']]['titlecolor'] = $threadcat['titlecolor'];
		$threadcatcache[$threadcat['threadcatid']]['nodisplay'] = $threadcat['nodisplay'];
		$threadcatcache[$threadcat['threadcatid']]['url'] = $threadcat['url'];
	}

	if ($forumid != -1)
	{
		$db->query_write("UPDATE " . TABLE_PREFIX . "forum
			SET threadcatcache = '" . $vbulletin->db->escape_string(trim(serialize($threadcatcache))) . "'
			WHERE forumid = " . $forumid . "
		");
		build_forum_permissions();
	}
	else
	{
		build_datastore('gtcatcache', serialize($threadcatcache));
	}

	define('CP_REDIRECT', 'threadcat.php?do=modify');
	print_stop_message('deleted_threadcat_successfully');
}

// ###################### Start modify #######################
if ($_REQUEST['do'] == 'modify')
{
	$tcats = $db->query_read_slave("
		SELECT *
		FROM " . TABLE_PREFIX . "threadcat AS threadcat
		ORDER BY url, nodisplay, displayorder
	");
	while ($tcat = $db->fetch_array($tcats))
	{
		if ($tcat['forumid'] == -1)
		{
			$globaltcat[] = $tcat;
		}
		else
		{
			$tcatcache[$tcat['forumid']][$tcat['threadcatid']] = $tcat;
		}
	}

	print_form_header('threadcat', 'add');
	print_table_header($vbphrase['threadcat_manager'], 3);

	if (is_array($globaltcat) && can_administer('canadminforums'))
	{
		$cell = array();
		$cell[] = '<b>' . $vbphrase['global_threadcat'] . '</b>';
		$threadcats = '';
		foreach($globaltcat AS $threadcatid => $threadcat)
		{
			$threadcatfix = $threadcat['nodisplay'] ? $vbphrase['fix'].'--' : '<strong>'.$vbphrase['tclass_name'].'</strong>--';
			$threadcatfix = $threadcat['url'] ? $vbphrase['url'].'--' : $threadcatfix;
			$threadcats .=	"\t\t<li><i>".$threadcatfix."></i>  <b>" . htmlspecialchars_uni($threadcat['title']) . "</b> ".
			construct_link_code($vbphrase['edit'], "threadcat.php?" . $vbulletin->session->vars['sessionurl'] . "do=edit&threadcatid=$threadcat[threadcatid]").
			construct_link_code($vbphrase['delete'], "threadcat.php?" . $vbulletin->session->vars['sessionurl'] . "do=remove&threadcatid=$threadcat[threadcatid]").
			"</li>\n";
		}

		$cell[] = iif(can_moderate($forum['forumid'], 'candminthreadcat'),$threadcats);
		$newss = '<input type="submit" class="button" value="' . $vbphrase['new'] . '" title="' . $vbphrase['add_new_threadcat'] . '" />';
		$cell[] = iif(can_moderate($forum['forumid'], 'candminthreadcat'),$newss);
		print_cells_row($cell, 0, '', -1);
		print_table_break();
	}

	foreach($vbulletin->forumcache AS $key => $forum)
	{
		if ($forum['parentid'] == -1)
		{
			print_cells_row(array($vbphrase['forum'], $vbphrase['threadcats'], ''), 1, 'tcat', 1);
		}
		$cell = array();
		$cell[] = "<b>" . construct_depth_mark($forum['depth'], '- - ', '- - ') . "$forum[title]</b>";
		$threadcats = '';
		if (is_array($tcatcache[$forum['forumid']]))
		{
			foreach($tcatcache[$forum['forumid']] AS $threadcatid => $threadcat)
			{
			$threadcatfix = $threadcat['nodisplay'] ? $vbphrase['fix'].'--' : '<strong>'.$vbphrase['tclass_name'].'</strong>--';
			$threadcatfix = $threadcat['url'] ? $vbphrase['url'].'--' : $threadcatfix;
				$threadcats .=
				"\t\t<li><i>".$threadcatfix."></i>  <b>" . htmlspecialchars_uni($threadcat['title']) . "</b> ".
				construct_link_code($vbphrase['edit'], "threadcat.php?" . $vbulletin->session->vars['sessionurl'] . "do=edit&threadcatid=$threadcat[threadcatid]").
				construct_link_code($vbphrase['delete'], "threadcat.php?" . $vbulletin->session->vars['sessionurl'] . "do=remove&threadcatid=$threadcat[threadcatid]").
				"</li>\n";
			}
		}
		$cell[] = iif(can_moderate($forum['forumid'], 'candminthreadcat'),$threadcats);
		$newss = '<input type="submit" class="button" value="' . $vbphrase['new'] . '" name="newforumid[' . $forum['forumid'] . ']" title="' . $vbphrase['add_new_threadcat'] . '" />';
		$cell[] = iif(can_moderate($forum['forumid'], 'candminthreadcat'),$newss);
		print_cells_row($cell, 0, '', -1);
	}

	print_table_footer();

	echo '<p align="center" class="smallfont">' .
		construct_link_code($vbphrase['add_new_threadcat'], "threadcat.php?" . $vbulletin->session->vars['sessionurl'] . "do=add").
		"</p>\n";

}

print_cp_footer();

/*========================================*\
|| ########################################
|| ########################################
\*========================================*/
?>
