CREATE TABLE IF NOT EXISTS `phpsay_apply` (
  `aid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) NOT NULL,
  `uname` char(15) NOT NULL,
  `uid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `fname` char(15) NOT NULL,
  `fid` smallint(6) unsigned NOT NULL DEFAULT '0',
  `message` char(95) NOT NULL,
  `dateline` int(10) unsigned NOT NULL DEFAULT '0',
  `dispose` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`aid`),
  KEY `check_dispose` (`type`,`uid`,`fid`),
  KEY `user_manage` (`type`,`uid`,`dispose`),
  KEY `type` (`type`,`dispose`,`aid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `phpsay_blacklist` (
  `bid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fid` smallint(6) unsigned NOT NULL DEFAULT '0',
  `uid` mediumint(8) NOT NULL,
  `uname` char(15) NOT NULL,
  `dateline` int(10) unsigned NOT NULL DEFAULT '0',
  `adminid` mediumint(8) NOT NULL,
  `adminname` char(15) NOT NULL,
  PRIMARY KEY (`bid`),
  KEY `uid` (`uid`,`fid`,`bid`),
  KEY `uname` (`uname`,`fid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `phpsay_catalog` (
  `cid` smallint(6) NOT NULL AUTO_INCREMENT,
  `fatherid` smallint(6) NOT NULL DEFAULT '0',
  `name` char(15) NOT NULL,
  PRIMARY KEY (`cid`),
  KEY `fatherid` (`fatherid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `phpsay_forum` (
  `fid` smallint(6) NOT NULL AUTO_INCREMENT,
  `cid` smallint(6) NOT NULL DEFAULT '0',
  `name` char(15) NOT NULL,
  `synopsis` char(95) NOT NULL,
  `moderator` text NOT NULL,
  `friend` text NOT NULL,
  `commend` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`fid`),
  UNIQUE KEY `name` (`name`),
  KEY `cid` (`cid`),
  KEY `commend` (`commend`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `phpsay_forum_catalog` (
  `fid` smallint(6) NOT NULL,
  `fname` char(15) NOT NULL,
  `cid` smallint(6) NOT NULL,
  PRIMARY KEY (`fid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `phpsay_forum_temp` (
  `fid` mediumint(8) NOT NULL AUTO_INCREMENT,
  `name` char(15) NOT NULL,
  `synopsis` char(95) NOT NULL,
  `founder` char(15) NOT NULL,
  `dateline` int(10) NOT NULL,
  `ipaddress` char(15) NOT NULL,
  PRIMARY KEY (`fid`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `phpsay_member` (
  `uid` mediumint(8) NOT NULL AUTO_INCREMENT,
  `name` char(15) NOT NULL,
  `email` char(45) NOT NULL,
  `password` char(32) NOT NULL,
  `securekey` char(10) NOT NULL,
  `regdate` int(10) NOT NULL,
  `regip` char(15) NOT NULL,
  `lastdate` int(10) NOT NULL,
  `lastip` char(15) NOT NULL,
  `integral` int(10) NOT NULL DEFAULT '0',
  `groupid` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`uid`),
  UNIQUE KEY `email` (`email`),
  UNIQUE KEY `name` (`name`),
  KEY `integral` (`integral`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `phpsay_post` (
  `pid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fid` smallint(6) unsigned NOT NULL DEFAULT '0',
  `tid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `replyfloor` smallint(6) NOT NULL DEFAULT '1',
  `author` char(15) NOT NULL,
  `authorid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `authorico` tinyint(1) NOT NULL,
  `guestname` tinyint(1) NOT NULL,
  `subject` char(60) NOT NULL,
  `dateline` int(10) unsigned NOT NULL DEFAULT '0',
  `postip` char(15) NOT NULL DEFAULT '',
  `up` mediumint(8) NOT NULL DEFAULT '0',
  `down` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `wave` mediumint(8) NOT NULL DEFAULT '0',
  PRIMARY KEY (`pid`),
  KEY `fid` (`fid`,`replyfloor`,`pid`),
  KEY `tid` (`tid`,`pid`,`replyfloor`),
  KEY `authorid` (`authorid`,`replyfloor`,`pid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `phpsay_post_content` (
  `pid` int(10) NOT NULL,
  `tid` mediumint(8) NOT NULL,
  `message` mediumtext NOT NULL,
  PRIMARY KEY (`pid`),
  KEY `tid` (`tid`,`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `phpsay_report` (
  `rid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uname` char(15) NOT NULL,
  `uid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `fid` smallint(6) unsigned NOT NULL DEFAULT '0',
  `tid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `pid` int(10) unsigned NOT NULL DEFAULT '0',
  `author` char(15) NOT NULL,
  `authorid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `message` char(90) NOT NULL,
  `dateline` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`rid`),
  KEY `fid` (`fid`,`rid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `phpsay_topic` (
  `tid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `fid` smallint(6) unsigned NOT NULL DEFAULT '0',
  `author` char(15) NOT NULL DEFAULT '',
  `authorid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `authorico` tinyint(1) NOT NULL,
  `subject` char(60) NOT NULL DEFAULT '',
  `dateline` int(10) NOT NULL,
  `lasttime` int(10) unsigned NOT NULL DEFAULT '0',
  `lastauthor` char(15) NOT NULL DEFAULT '',
  `lastauthorid` mediumint(8) NOT NULL,
  `lastauthorico` tinyint(1) NOT NULL,
  `views` int(10) unsigned NOT NULL DEFAULT '0',
  `replies` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `stick` tinyint(1) NOT NULL DEFAULT '0',
  `digest` tinyint(1) NOT NULL DEFAULT '0',
  `lockout` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`tid`),
  KEY `authorid` (`authorid`,`tid`),
  KEY `replies` (`dateline`,`replies`),
  KEY `dateline` (`dateline`,`tid`),
  KEY `stick` (`fid`,`stick`,`lasttime`),
  KEY `fid` (`fid`,`digest`,`tid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;