<?php 
/**
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Site: http://www.phpdisk.com
#
#	$Id: posts.inc.php 17 2014-06-26 03:29:37Z along $
#
#	Copyright (C) 2008-2014 PHPDisk Team. All Rights Reserved.
#
*/

if(!defined('IN_PHPDISK') || !defined('IN_ADMINCP')) {
	exit('[PHPDisk] Access Denied');
}

switch($action){

	case 'index':
		$view = trim(gpc('view','GP',''));
		$uid = (int)gpc('uid','GP',0);

		if(in_array($task,array('checked_file','unchecked_file','delete_recycle','move_to','set_credit','set_ext','commend_file','uncommend_file'))){
			form_auth(gpc('formhash','P',''),formhash());

			$file_ids = gpc('file_ids','P',array(''));
			$back_reason = trim(gpc('back_reason','P',''));
			$p_cate1 = (int)gpc('p_cate1','P',0);
			$p_cate2 = (int)gpc('p_cate2','P',0);
			$p_cate3 = (int)gpc('p_cate3','P',0);
			$p_cate4 = (int)gpc('p_cate4','P',0);
			$p_credit = (int)gpc('p_credit','P',0);
			$credit = (int)gpc('credit','P',0);
			$p_lang = (int)gpc('p_lang','P',0);
			$p_type = (int)gpc('p_type','P',0);
			$p_auth = (int)gpc('p_auth','P',0);

			if($settings['online_demo']){
				$error = true;
				$sysmsg[] = __('online_demo_deny');
			}
			$ids_arr = get_ids_arr($file_ids,'请选择需要操作的'.$settings[pd_post_name]);
			if($ids_arr[0]){
				$error = true;
				$sysmsg[] = $ids_arr[1];
			}else{
				$file_str = $ids_arr[1];
			}
			if($p_cate4>0){
				$cate_id=$p_cate4;
			}elseif($p_cate3>0){
				$cate_id=$p_cate3;
			}elseif($p_cate2>0){
				$cate_id=$p_cate2;
			}elseif($p_cate1>0){
				$cate_id=$p_cate1;
			}
			if(!$error){
				switch($task){
					case 'commend_file':
						$ins = array(
						'is_commend'=>1,
						'is_checked'=>1,
						'check_uid'=>$pd_uid,
						);
						$db->query_unbuffered("update {$tpf}posts set ".$db->sql_array($ins)." where pid in ($file_str)");
						do_cache('index_commend_file',1);
						$sysmsg[] = '首页推荐'.$settings[pd_post_name].'操作成功';
						break;
					case 'uncommend_file':
						$ins = array(
						'is_commend'=>0,
						'is_checked'=>1,
						);
						$db->query_unbuffered("update {$tpf}posts set ".$db->sql_array($ins)." where pid in ($file_str)");
						do_cache('index_commend_file',1);
						$sysmsg[] = '取消首页推荐'.$settings[pd_post_name].'操作成功';
						break;
					case 'checked_file':
						$ins = array(
						'is_checked'=>1,
						'check_uid'=>$pd_uid,
						);
						$db->query_unbuffered("update {$tpf}posts set ".$db->sql_array($ins)." where pid in ($file_str)");
						$q = $db->query("select userid from {$tpf}posts where pid in ($file_str)");
						$str = '';
						while ($rs = $db->fetch_array($q)) {
							$db->query_unbuffered("update {$tpf}users set credit=credit+$credit where userid='{$rs[userid]}'");
						}
						$db->free($q);
						unset($rs);
						$sysmsg[] = '审核'.$settings[pd_post_name].'发布操作成功';
						break;
					case 'unchecked_file':
						$ins = array(
						'is_checked'=>2,
						'back_reason'=>$db->escape($back_reason),
						'check_uid'=>$pd_uid,
						);
						$db->query_unbuffered("update {$tpf}posts set ".$db->sql_array($ins)." where pid in ($file_str)");
						$sysmsg[] = '退回审核'.$settings[pd_post_name].'操作成功';
						break;
					case 'delete_recycle':
						$ins = array(
						'is_del'=>1,
						'check_uid'=>$pd_uid,
						);
						$db->query_unbuffered("update {$tpf}posts set ".$db->sql_array($ins)." where pid in ($file_str)");
						$sysmsg[] = '删除'.$settings[pd_post_name].'到回收站操作成功';
						break;
					case 'set_credit':
						$ins = array(
						'p_credit'=>$p_credit,
						'check_uid'=>$pd_uid,
						);
						$db->query_unbuffered("update {$tpf}posts set ".$db->sql_array($ins)." where pid in ($file_str)");
						$sysmsg[] = '批量设置'.$settings[pd_post_name].'积分成功';
						break;
					case 'set_ext':
						$ins = array(
						'p_lang'=>$p_lang,
						'p_type'=>$p_type,
						'p_auth'=>$p_auth,
						'check_uid'=>$pd_uid,
						);
						$db->query_unbuffered("update {$tpf}posts set ".$db->sql_array($ins)." where pid in ($file_str)");
						$sysmsg[] = '设置'.$settings[pd_post_name].'属性成功';
						break;
					case 'move_to':
						$ins = array(
						'p_cate1'=>$p_cate1,
						'p_cate2'=>$p_cate2,
						'p_cate3'=>$p_cate3,
						'p_cate4'=>$p_cate4,
						'cate_id'=>$cate_id,
						'check_uid'=>$pd_uid,
						);
						$db->query_unbuffered("update {$tpf}posts set ".$db->sql_array($ins)." where pid in ($file_str)");
						$sysmsg[] = $settings[pd_post_name].'分类操作成功';
						break;
				}
				redirect(urr(ADMINCP,"item=$item&menu=$menu&action=index&view=$view"),$sysmsg);
			}else{
				redirect('back',$sysmsg);
			}

		}else{
			$perpage = 100;
			$sql_ext = '';
			switch($view){
				case 'user':
					$sql_ext = " where f.is_del=0 and f.userid='$uid'";
					break;
				case 'user_del':
					$sql_ext = " where f.is_del=1";
					break;
				case 'checking_file':
					$sql_ext = " where f.is_checked=0 and f.is_del=0";
					break;
				case 'checked_file':
					$sql_ext = " where f.is_checked=1 and f.is_del=0";
					break;
				case 'unchecked_file':
					$sql_ext = " where f.is_checked=2 and f.is_del=0";
					break;
				case 'commend_file':
					$sql_ext = " where f.is_commend=1 and f.is_checked=1 and f.is_del=0";
					break;
				default:
					$sql_ext = " where f.is_del=0";
			}

			$rs = $db->fetch_one_array("select count(*) as total_num from {$tpf}posts f {$sql_ext}");
			$total_num = $rs['total_num'];
			$start_num = ($pg-1) * $perpage;

			$q = $db->query("select f.*,u.username from {$tpf}posts f,{$tpf}users u {$sql_ext} and f.userid=u.userid order by pid desc limit $start_num,$perpage");
			$files_array = array();
			while($rs = $db->fetch_array($q)){
				$rs['a_user_view'] = urr(ADMINCP,"item=$item&menu=file&action=$action&view=user&uid=".$rs['userid']);
				$rs['a_editpost'] = urr(ADMINCP,"item=$item&menu=file&action=edit&pid=".$rs['pid']);
				$rs['intime'] = date("Y-m-d H:i:s",$rs['intime']);
				$rs['a_viewpost'] = urr("viewpost","pid={$rs['pid']}&seo={$rs[seo]}");
				$rs[checked_txt] = $rs[is_commend] ? '<span class="txtred">首页推荐</span>' : $soft_checked_arr[$rs[is_checked]];
				$files_array[] = $rs;
			}
			$db->free($q);
			unset($rs);
			$page_nav = multi($total_num, $perpage, $pg, urr(ADMINCP,"item=$item&menu=file&action=$action&view=$view&uid=$uid"));
			$dd = date('Y-m-d');
			require_once template_echo($item,$admin_tpl_dir,'',1);
		}
		break;

	case 'search':
		$view = trim(gpc('view','GP',''));
		if(in_array($task,array('checked_file','unchecked_file','delete_recycle','move_to','set_credit','set_ext','commend_file','uncommend_file'))){
			form_auth(gpc('formhash','P',''),formhash());

			$file_ids = gpc('file_ids','P',array(''));
			$back_reason = trim(gpc('back_reason','P',''));
			$p_cate1 = (int)gpc('p_cate1','P',0);
			$p_cate2 = (int)gpc('p_cate2','P',0);
			$p_cate3 = (int)gpc('p_cate3','P',0);
			$p_cate4 = (int)gpc('p_cate4','P',0);
			$p_credit = (int)gpc('p_credit','P',0);
			$credit = (int)gpc('credit','P',0);
			$p_lang = (int)gpc('p_lang','P',0);
			$p_type = (int)gpc('p_type','P',0);
			$p_auth = (int)gpc('p_auth','P',0);

			if($settings['online_demo']){
				$error = true;
				$sysmsg[] = __('online_demo_deny');
			}
			$ids_arr = get_ids_arr($file_ids,'请选择需要操作的'.$settings[pd_post_name]);
			if($ids_arr[0]){
				$error = true;
				$sysmsg[] = $ids_arr[1];
			}else{
				$file_str = $ids_arr[1];
			}
			if($p_cate4>0){
				$cate_id=$p_cate4;
			}elseif($p_cate3>0){
				$cate_id=$p_cate3;
			}elseif($p_cate2>0){
				$cate_id=$p_cate2;
			}elseif($p_cate1>0){
				$cate_id=$p_cate1;
			}
			if(!$error){
				switch($task){
					case 'commend_file':
						$ins = array(
						'is_commend'=>1,
						'is_checked'=>1,
						'check_uid'=>$pd_uid,
						);
						$db->query_unbuffered("update {$tpf}posts set ".$db->sql_array($ins)." where pid in ($file_str)");
						do_cache('index_commend_file',1);
						$sysmsg[] = '首页推荐'.$settings[pd_post_name].'操作成功';
						break;
					case 'uncommend_file':
						$ins = array(
						'is_commend'=>0,
						'is_checked'=>1,
						);
						$db->query_unbuffered("update {$tpf}posts set ".$db->sql_array($ins)." where pid in ($file_str)");
						do_cache('index_commend_file',1);
						$sysmsg[] = '取消首页推荐'.$settings[pd_post_name].'操作成功';
						break;
					case 'checked_file':
						$ins = array(
						'is_checked'=>1,
						'check_uid'=>$pd_uid,
						);
						$db->query_unbuffered("update {$tpf}posts set ".$db->sql_array($ins)." where pid in ($file_str)");
						$q = $db->query("select userid from {$tpf}posts where pid in ($file_str)");
						$str = '';
						while ($rs = $db->fetch_array($q)) {
							$db->query_unbuffered("update {$tpf}users set credit=credit+$credit where userid='{$rs[userid]}'");
						}
						$db->free($q);
						unset($rs);
						$sysmsg[] = '审核'.$settings[pd_post_name].'发布操作成功';
						break;
					case 'unchecked_file':
						$ins = array(
						'is_checked'=>2,
						'back_reason'=>$db->escape($back_reason),
						'check_uid'=>$pd_uid,
						);
						$db->query_unbuffered("update {$tpf}posts set ".$db->sql_array($ins)." where pid in ($file_str)");
						$sysmsg[] = '退回审核'.$settings[pd_post_name].'操作成功';
						break;
					case 'delete_recycle':
						$ins = array(
						'is_del'=>1,
						'check_uid'=>$pd_uid,
						);
						$db->query_unbuffered("update {$tpf}posts set ".$db->sql_array($ins)." where pid in ($file_str)");
						$sysmsg[] = '删除'.$settings[pd_post_name].'到回收站操作成功';
						break;
					case 'set_credit':
						$ins = array(
						'p_credit'=>$p_credit,
						'check_uid'=>$pd_uid,
						);
						$db->query_unbuffered("update {$tpf}posts set ".$db->sql_array($ins)." where pid in ($file_str)");
						$sysmsg[] = '批量设置'.$settings[pd_post_name].'积分成功';
						break;
					case 'set_ext':
						$ins = array(
						'p_lang'=>$p_lang,
						'p_type'=>$p_type,
						'p_auth'=>$p_auth,
						'check_uid'=>$pd_uid,
						);
						$db->query_unbuffered("update {$tpf}posts set ".$db->sql_array($ins)." where pid in ($file_str)");
						$sysmsg[] = '设置'.$settings[pd_post_name].'属性成功';
						break;
					case 'move_to':
						$ins = array(
						'p_cate1'=>$p_cate1,
						'p_cate2'=>$p_cate2,
						'p_cate3'=>$p_cate3,
						'p_cate4'=>$p_cate4,
						'cate_id'=>$cate_id,
						'check_uid'=>$pd_uid,
						);
						$db->query_unbuffered("update {$tpf}posts set ".$db->sql_array($ins)." where pid in ($file_str)");
						$sysmsg[] = $settings[pd_post_name].'分类操作成功';
						break;
				}
				redirect(urr(ADMINCP,"item=$item&menu=$menu&action=$action&view=$view"),$sysmsg);
			}else{
				redirect('back',$sysmsg);
			}

		}else{
			$dd = gpc('dd','G','');
			$user = gpc('user','G','');
			$sel_type = (int)gpc('sel_type','G',0);
			$word = trim(gpc('word','G',''));
			$word_str = str_replace('　',' ',replace_inject_str($word));
			$dd_sql = $dd ? " and (intime between ".strtotime($dd)." and ".strtotime($dd.' 23:59:59').")" : '';
			$u_sql = '';
			if($user){
				$uid = @$db->result_first("select userid from {$tpf}users where username='$user'");
				if(!$uid){
					echo '<script>alert("用户名不存在");window.history.back();</script>';
					exit;
				}else{
					$u_sql = $uid ? " and u.userid='$uid'" : '';
				}
			}
			if($sel_type){
				if(!is_numeric($word_str)){
					echo '<script>alert("文件ID只能为整数");window.history.back();</script>';
					exit;
				}else{
					$word_str = (int)$word_str;
					$sql_keyword = " and pid='$word_str'";
				}
			}else{
				$arr = explode(' ',$word_str);
				if(count($arr)>1){
					for($i=0;$i<count($arr);$i++){
						if(trim($arr[$i]) <> ''){
							$str .= " p_name like '%{$arr[$i]}%' and";
						}
					}
					$str = substr($str,0,-3);
					$sql_keyword = " and (".$str.")";

				}else{
					$sql_keyword = " and p_name like '%{$word_str}%'";
				}
			}
			$is_del = $view=='user_del' ? 1 : 0;
			$sql_do = " {$tpf}posts fl,{$tpf}users u where fl.userid=u.userid and is_del=$is_del $sql_keyword $dd_sql $u_sql";

			$rs = $db->fetch_one_array("select count(*) as total_num from {$sql_do}");
			$total_num = $rs['total_num'];
			$start_num = ($pg-1) * $perpage;

			$q = $db->query("select fl.*,u.username from {$sql_do} order by intime desc,pid desc limit $start_num,$perpage");
			$files_array = array();
			while($rs = $db->fetch_array($q)){
				$rs['a_user_view'] = urr(ADMINCP,"item=$item&menu=file&action=$action&view=user&uid=".$rs['userid']);
				$rs['a_editpost'] = urr(ADMINCP,"item=$item&menu=file&action=edit&pid=".$rs['pid']);
				$rs['intime'] = date("Y-m-d H:i:s",$rs['intime']);
				$rs['a_viewpost'] = urr("viewpost","pid={$rs['pid']}&seo={$rs[seo]}");
				$rs[checked_txt] = $rs[is_commend] ? '<span class="txtred">首页推荐</span>' : $soft_checked_arr[$rs[is_checked]];
				$files_array[] = $rs;
			}
			$db->free($q);
			unset($rs);
			$page_nav = multi($total_num, $perpage, $pg, urr(ADMINCP,"item=$item&menu=file&action=search&view=$view&dd=$dd&user=".rawurlencode($user)."&word=".rawurlencode($word)."&sel_type=$sel_type"));

			require_once template_echo($item,$admin_tpl_dir,'',1);
		}
		break;

	case 'recycle_delete':
		if($settings['online_demo']){
			$error = true;
			$sysmsg[] = __('online_demo_deny');
		}
		if(!$error){
			$file_id = (int)gpc('file_id','G',0);
			$db->query_unbuffered("update {$tpf}files set is_del=1 where file_id='$file_id'");
			//syn_folder_size();

			$sysmsg[] = __('file_delete_success');
			redirect('back',$sysmsg);
		}else{
			redirect('back',$sysmsg);
		}
		break;
	case 'edit':
		$pid = (int)gpc('pid','GP',0);
		if(!$pid){
			header('Location:'.urr(ADMINCP,"item=posts&menu=file&action=index"));
			exit;
		}
		if($task=='edit'){
			form_auth(gpc('formhash','P',''),formhash());
			$meta_title = trim(gpc('meta_title','P',''));
			$meta_keywords = trim(gpc('meta_keywords','P',''));
			$meta_description = trim(gpc('meta_description','P',''));
			$p_name = trim(gpc('p_name','P',''));
			$p_size = trim(gpc('p_size','P',''));
			$p_cate1 = (int)gpc('p_cate1','P','');
			$p_cate2 = (int)gpc('p_cate2','P','');
			$p_cate3 = (int)gpc('p_cate3','P','');
			$p_cate4 = (int)gpc('p_cate4','P','');
			$p_lang = (int)gpc('p_lang','P','');
			$p_type = (int)gpc('p_type','P','');
			$p_auth = (int)gpc('p_auth','P','');
			$p_credit = (int)gpc('p_credit','P','');
			$file_addr = gpc('file_addr','P',array());
			$file_text = gpc('file_text','P',array());
			$p_site = trim(gpc('p_site','P',''));
			$p_demo = trim(gpc('p_demo','P',''));
			$p_desc = trim(gpc('p_desc','P','',0));
			$seo = trim(gpc('seo','P',''));

			if(!$p_name){
				$error = true;
				$sysmsg[] = $settings[pd_post_name].'名称不能为空';
			}else{
				$num = @$db->result_first("select count(*) from {$tpf}posts where p_name='$p_name' and pid<>$pid");
				if($num){
					$error = true;
					$sysmsg[] = $settings[pd_post_name].'名称已存在，请返回修改';
				}
			}
			if(!$p_size){
				$error = true;
				$sysmsg[] = $settings[pd_post_name].'大小不能为空';
			}
			if($p_cate1==-1){
				$error = true;
				$sysmsg[] = '请选择'.$settings[pd_post_name].'类别';
			}
			if(!$p_desc){
				$error = true;
				$sysmsg[] = '请填写'.$settings[pd_post_name].'介绍';
			}else{
				$p_desc = preg_replace("/<(\/?i?frame.*?)>/si","",$p_desc);
				$p_desc = preg_replace("/<(\/?script.*?)>/si","",$p_desc);
			}
			if(!empty($file_addr) && !empty($file_text)){
				foreach($file_addr as $k=>$v){
					$file_addr[$k] = htmlspecialchars(str_replace(array('\\'),'',$v));
				}
				foreach($file_text as $k=>$v){
					$file_text[$k] = htmlspecialchars(str_replace(array('\\'),'',$v));
				}
			}else{
				$error = true;
				$sysmsg[] = '请填写'.$settings[pd_post_name].'下载地址';
			}
			if($settings['online_demo']){
				$error = true;
				$sysmsg[] = __('online_demo_deny');
			}
			if($seo){
				if(!preg_match('/^\w+$/',$seo)){
					$error = true;
					$sysmsg[] = 'SEO URL优化只能填写英文和数字';
				}
			}else{
				$seo = '';
			}
			if($p_cate4>0){
				$cate_id=$p_cate4;
			}elseif($p_cate3>0){
				$cate_id=$p_cate3;
			}elseif($p_cate2>0){
				$cate_id=$p_cate2;
			}elseif($p_cate1>0){
				$cate_id=$p_cate1;
			}
			if(!$error){
				update_seo('viewpost',$pid,$meta_title,$meta_keywords,$meta_description);
				$ins = array(
				'p_name'=>$p_name,
				'seo'=>$seo,
				'p_size'=>strtoupper($p_size),
				'p_cate1'=>$p_cate1,
				'p_cate2'=>$p_cate2,
				'p_cate3'=>$p_cate3,
				'p_cate4'=>$p_cate4,
				'cate_id'=>$cate_id,
				'p_lang'=>$p_lang,
				'p_type'=>$p_type,
				'p_auth'=>$p_auth,
				'p_credit'=>$p_credit,
				'file_param'=>addslashes(serialize(array($file_addr,$file_text))),
				'p_site'=>$p_site,
				'p_demo'=>$p_demo,
				'p_desc'=>$p_desc,
				);
				$db->query_unbuffered("update {$tpf}posts set ".$db->sql_array($ins)." where pid='$pid' and userid='$pd_uid'");
				$sysmsg[] = $settings[pd_post_name].'编辑成功';
				redirect(urr(ADMINCP,"item=posts&menu=file&action=index"),$sysmsg);
			}else{
				redirect('back',$sysmsg);
			}
		}else{
			$ps = $db->fetch_one_array("select * from {$tpf}posts where pid='$pid' and userid='$pd_uid'");

			$f_arr = unserialize($ps[file_param]);
			//print_r($f_arr);exit;
			$ps[file_list] = '';
			for($i=0;$i<count($f_arr[1]);$i++){
				$ps[file_list] .= '<li class="txtgray">链接：<input type="text" name="file_addr[]" size="30" value="'.$f_arr[0][$i].'" />&nbsp;&nbsp;文字：<input type="text" name="file_text[]" size="30" value="'.$f_arr[1][$i].'" />&nbsp;<a href="javascript:;" onclick="$(this).parent().remove();" title="删除"><img src="images/delete_icon.gif" align="absmiddle" border="0" /></a></li>';
			}
			$ref = $_SERVER['HTTP_REFERER'];
			$s = get_seo('viewpost',$pid);
			require_once template_echo($item,$admin_tpl_dir,'',1);
		}
		break;
	case 'add_cate':

		if($task =='add_cate'){
			form_auth(gpc('formhash','P',''),formhash());

			$cate_name = trim(gpc('cate_name','P',''));
			$pid = (int)gpc('pid','P',0);
			$main_nav = (int)gpc('main_nav','P',0);
			$sub_nav = (int)gpc('sub_nav','P',0);

			if($settings['online_demo']){
				$error = true;
				$sysmsg[] = __('online_demo_deny');
			}
			if(checklength($cate_name,1,60)){
				$error = true;
				$sysmsg[] = __('cate_name_error');
			}
			$rs = $db->fetch_one_array("select count(*) as total from {$tpf}categories where cate_name='$cate_name'");
			if($rs['total']){
				$error = true;
				$sysmsg[] = __('cate_name_exists');
			}
			if(!$error){
				$ins = array(
				'cate_name' => $cate_name,
				'pid' => $pid,
				'main_nav' => $main_nav,
				'sub_nav' => $sub_nav,
				);
				$db->query("insert into {$tpf}categories set ".$db->sql_array($ins).";");
				global_cache('main_nav');
				global_cache('sub_nav');
				$sysmsg[] = __('cate_add_success');
				redirect(urr(ADMINCP,"item=$item&menu=file&action=category"),$sysmsg);

			}else{
				redirect('back',$sysmsg);
			}
		}else{

			require_once template_echo($item,$admin_tpl_dir,'',1);
		}
		break;

	case 'modify_cate':
		$cate_id = (int)gpc('cate_id','GP',0);

		if($task =='modify_cate'){
			form_auth(gpc('formhash','P',''),formhash());

			$cate_name = trim(gpc('cate_name','P',''));
			$pid = (int)gpc('pid','P',0);
			$main_nav = (int)gpc('main_nav','P',0);
			$sub_nav = (int)gpc('sub_nav','P',0);

			if($settings['online_demo']){
				$error = true;
				$sysmsg[] = __('online_demo_deny');
			}
			if(checklength($cate_name,1,60)){
				$error = true;
				$sysmsg[] = __('cate_name_error');
			}
			$rs = $db->fetch_one_array("select count(*) as total from {$tpf}categories where cate_name='$cate_name' and pid='$pid' and cate_id<>'$cate_id'");
			if($rs['total']){
				$error = true;
				$sysmsg[] = __('cate_name_exists');
			}
			if($cate_id==$pid){
				$error = true;
				$sysmsg[] = __('cateid_pid_cannot_same');
			}
			if(!$error){
				$ins = array(
				'cate_name' => $cate_name,
				'pid' => $pid,
				'main_nav' => $main_nav,
				'sub_nav' => $sub_nav,
				);
				$db->query_unbuffered("update {$tpf}categories set ".$db->sql_array($ins)." where cate_id='$cate_id';");
				global_cache('main_nav');
				global_cache('sub_nav');
				$sysmsg[] = __('cate_modify_success');
				redirect(urr(ADMINCP,"item=$item&menu=file&action=category"),$sysmsg);

			}else{
				redirect('back',$sysmsg);
			}
		}else{
			$aa = $db->fetch_one_array("select * from {$tpf}categories where cate_id='$cate_id'");
			require_once template_echo($item,$admin_tpl_dir,'',1);
		}
		break;

	case 'category':

		if($task =='update'){
			form_auth(gpc('formhash','P',''),formhash());

			$show_order = gpc('show_order','P',array());
			$cate_ids = gpc('cate_ids','P',array());
			$cate_names = gpc('cate_names','P',array());

			if($settings['online_demo']){
				$error = true;
				$sysmsg[] = __('online_demo_deny');
			}
			if(!$error){
				for($i =0;$i<count($cate_ids);$i++){
					$title = trim(replace_js($cate_names[$i]));
					if($title){
						$db->query_unbuffered("update {$tpf}categories set show_order='".(int)$show_order[$i]."',cate_name='$title' where cate_id='".(int)$cate_ids[$i]."'");
					}
				}
				redirect(urr(ADMINCP,"item=$item&menu=file&action=category"),'',0);
			}else{
				redirect('back',$sysmsg);
			}

		}else{
			$q = $db->query("select * from {$tpf}categories order by show_order asc, cate_id asc");
			$cates = array();
			while($rs = $db->fetch_array($q)){
				$cates[] = $rs;
			}
			$db->free($q);
			unset($rs);

			require_once template_echo($item,$admin_tpl_dir,'',1);
		}

		break;

	case 'del_cate':
		if($settings['online_demo']){
			$error = true;
			$sysmsg[] = __('online_demo_deny');
		}
		if(!$error){
			$cate_id = (int)gpc('cate_id','G',0);
			if($cate_id){
				$db->query_unbuffered("update {$tpf}files set is_del=1 where cate_id='$cate_id'");
				$db->query_unbuffered("delete from {$tpf}categories where cate_id='$cate_id'");
				global_cache('main_nav');
				global_cache('sub_nav');
			}
			$sysmsg[] = __('del_cate_success');
			redirect(urr(ADMINCP,"item=$item&menu=file&action=category"),$sysmsg);
		}else{
			redirect('back',$sysmsg);
		}
		break;

	default:
		require_once template_echo($item,$admin_tpl_dir,'',1);

}

function get_cate_tree($pid=0,$lv=0){
	global $db,$tpf;
	$nav_arr = array('<span class="txtred">隐藏</span>','<span class="txtblue">显示</span>');
	$q = $db->query("select * from {$tpf}categories order by show_order asc");
	while ($rs = $db->fetch_array($q)) {
		$data[] = $rs;
	}
	$db->free($q);
	unset($rs);
	if(count($data)){
		$html = '<tr>'.LF;
		foreach($data as $v){
			if($v['pid'] == $pid){
				$a_modify = urr(ADMINCP,"item=posts&menu=file&action=modify_cate&cate_id={$v['cate_id']}");
				$a_cate_href = urr("cate","cate_id={$v['cate_id']}");
				$a_del_cate = urr(ADMINCP,"item=posts&menu=file&action=del_cate&cate_id={$v['cate_id']}");

				$html .= "<td>".LF;
				$html .= '<input type="text" name="show_order[]" value="'.$v['show_order'].'" style="width:20px; text-align:center" maxlength="2" />'.LF;
				$html .= '<input type="hidden" name="cate_ids[]" value="'.$v['cate_id'].'" />'.LF;
				$html .= str_repeat('&nbsp;',$lv*2).'<input type="text" name="cate_names[]" size="30" value="'.$v['cate_name'].'" /></td>'.LF;
				$html .= '	<td align="center">'.$nav_arr[(int)$v[main_nav]].'|'.$nav_arr[(int)$v[sub_nav]].'</td>'.LF;
				$html .= '	<td align="center">';
				$html .= '	<a href="'.$a_cate_href.'" target="_blank">'.$v[cate_num].'</a>';
				$html .= '	</td>'.LF;
				$html .= '	<td align="right">';
				$html .= '	<a href="'.$a_modify.'">'.__('modify').'</a>&nbsp;';
				$html .= '	<a href="'.$a_del_cate.'" onclick="return confirm(\''.__('del_category_confirm').'\');">'.__('delete').'</a></td>'.LF;
				$lv++;
				$html .= get_cate_tree($v['cate_id'],$lv);
				$lv--;
			}
		}
		$html .= '</tr>'.LF;
		return $html;
	}else{
		return '';
	}
}


?>