<?php 
/**
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Site: http://www.phpdisk.com
#
#	$Id: post.inc.php 17 2014-06-26 03:29:37Z along $
#
#	Copyright (C) 2008-2014 PHPDisk Team. All Rights Reserved.
#
*/

if(!defined('IN_PHPDISK') || !defined('IN_MYDISK')) {
	exit('[PHPDisk] Access Denied');
}

switch ($action){
	case 'add_post':
		if($task=='add_post'){
			form_auth(gpc('formhash','P',''),formhash());
			$p_name = trim(gpc('p_name','P',''));
			$p_size = trim(gpc('p_size','P',''));
			$p_cate1 = (int)gpc('p_cate1','P','');
			$p_cate2 = (int)gpc('p_cate2','P','');
			$p_cate3 = (int)gpc('p_cate3','P','');
			$p_cate4 = (int)gpc('p_cate4','P','');
			$p_lang = (int)gpc('p_lang','P','');
			$p_type = (int)gpc('p_type','P','');
			$p_auth = (int)gpc('p_auth','P','');
			$p_credit = (int)gpc('p_credit','P','');
			$file_addr = gpc('file_addr','P',array());
			$file_text = gpc('file_text','P',array());
			$p_site = trim(gpc('p_site','P',''));
			$p_demo = trim(gpc('p_demo','P',''));
			$p_desc = trim(gpc('p_desc','P','',0));
			$tags = trim(gpc('post_tag','P',''));
			if($tags){
				$tags = str_replace('，',',',$tags);
				$tags = str_replace(',,',',',$tags);
				$tags = (substr($tags,-1) ==',') ? substr($tags,0,-1) : $tags;

				$tag_arr = explode(',',$tags);
				if(count($tag_arr) >5){
					$error = true;
					$sysmsg[] = '最多只能填写五个标签';
				}
			}

			if($group_set[day_post_num]){
				$num = $db->result_first("select count(*) from {$tpf}posts where intime between ".strtotime(date('Y-m-d').'0:0:0')." and $timestamp");
				if($num>=$group_set[day_post_num]){
					$error = true;
					$sysmsg[] = '抱歉，您所在用户组每日发布'.$settings[pd_post_name].'为'.$group_set[day_post_num].'个。';
				}
			}
			if(!$p_name){
				$error = true;
				$sysmsg[] = $settings[pd_post_name].'标题不能为空';
			}else{
				$num = @$db->result_first("select count(*) from {$tpf}posts where p_name='$p_name' and userid='$pd_uid'");
				if($num){
					$error = true;
					$sysmsg[] = $settings[pd_post_name].'标题已存在，请返回修改';
				}
			}
			if(!$p_size){
				$error = true;
				$sysmsg[] = $settings[pd_post_name].'大小不能为空';
			}
			if($p_cate1==-1){
				$error = true;
				$sysmsg[] = '请选择'.$settings[pd_post_name].'类别';
			}
			if(!$p_desc){
				$error = true;
				$sysmsg[] = '请填写'.$settings[pd_post_name].'介绍';
			}else{
				$p_desc = preg_replace("/<(\/?i?frame.*?)>/si","",$p_desc);
				$p_desc = preg_replace("/<(\/?script.*?)>/si","",$p_desc);
			}
			if(!empty($file_addr) && !empty($file_text)){
				foreach($file_addr as $k=>$v){
					$file_addr[$k] = htmlspecialchars(str_replace(array('\\'),'',$v));
				}
				foreach($file_text as $k=>$v){
					$file_text[$k] = htmlspecialchars(str_replace(array('\\'),'',$v));
				}
			}else{
				$error = true;
				$sysmsg[] = '请填写'.$settings[pd_post_name].'下载地址';
			}
			if($p_cate4>0){
				$cate_id=$p_cate4;
			}elseif($p_cate3>0){
				$cate_id=$p_cate3;
			}elseif($p_cate2>0){
				$cate_id=$p_cate2;
			}elseif($p_cate1>0){
				$cate_id=$p_cate1;
			}
			if(!$error){
				$ins = array(
				'userid'=>$pd_uid,
				'p_name'=>$p_name,
				'p_size'=>strtoupper($p_size),
				'p_cate1'=>$p_cate1,
				'p_cate2'=>$p_cate2,
				'p_cate3'=>$p_cate3,
				'p_cate4'=>$p_cate4,
				'cate_id'=>$cate_id,
				'p_lang'=>$p_lang,
				'p_type'=>$p_type,
				'p_auth'=>$p_auth,
				'p_credit'=>$p_credit,
				'file_param'=>addslashes(serialize(array($file_addr,$file_text))),
				'p_site'=>$p_site,
				'p_demo'=>$p_demo,
				'p_desc'=>$p_desc,
				'ip'=>$onlineip,
				'intime'=>$timestamp,
				'is_checked'=>$group_set['check_post'] ? 0 : 1,
				);
				$db->query_unbuffered("insert into {$tpf}posts set ".$db->sql_array($ins)."");
				$pid = $db->insert_id();
				make_tags($tags,$tag_arr,$pid);
				$db->query_unbuffered("update {$tpf}categories set cate_num=cate_num+1 where cate_id='$cate_id'");
				$sysmsg[] = $settings[pd_post_name].'发布成功';
				redirect(urr("mydisk","item=post&action=post_list"),$sysmsg);
			}else{
				redirect('back',$sysmsg);
			}

		}else{
			$ps[p_credit] = 0;
			for($i=0;$i<=4;$i++){
				$ps['p_cate'.$i] = -1;
			}
			$file_id = (int)gpc('file_id','G','');
			if($file_id){
				$rs = $db->fetch_one_array("select file_name,file_size,file_description,yun_fid from {$tpf}files where file_id='$file_id' and userid='$pd_uid'");
				$ps[p_name] = $rs[file_name];
				$ps[p_desc] = $rs[file_description] ? $rs[file_description] : $rs[file_name];
				$ps[p_size] = str_replace(' ','',get_size($rs[file_size]));
				$ps[file_list] .= '<li class="txtgray">链接：<input type="text" name="file_addr[]" size="30" value="'.urr("dfile","file_id=$file_id&yun_fid={$rs[yun_fid]}").'" />&nbsp;&nbsp;文字：<input type="text" name="file_text[]" size="30" value="[下载]'.$rs[file_name].' '.$ps[p_size].'" />&nbsp;<a href="javascript:;" onclick="$(this).parent().remove();" title="删除"><img src="images/delete_icon.gif" align="absmiddle" border="0" /></a></li>';
			}
			require_once template_echo($item,$user_tpl_dir);
		}
		break;
	case 'edit_post':
		$pid = (int)gpc('pid','GP',0);
		if($task=='edit_post'){
			form_auth(gpc('formhash','P',''),formhash());
			$p_name = trim(gpc('p_name','P',''));
			$p_size = trim(gpc('p_size','P',''));
			$p_cate1 = (int)gpc('p_cate1','P','');
			$p_cate2 = (int)gpc('p_cate2','P','');
			$p_cate3 = (int)gpc('p_cate3','P','');
			$p_cate4 = (int)gpc('p_cate4','P','');
			$p_lang = (int)gpc('p_lang','P','');
			$p_type = (int)gpc('p_type','P','');
			$p_auth = (int)gpc('p_auth','P','');
			$p_credit = (int)gpc('p_credit','P','');
			$file_addr = gpc('file_addr','P',array());
			$file_text = gpc('file_text','P',array());
			$p_site = trim(gpc('p_site','P',''));
			$p_demo = trim(gpc('p_demo','P',''));
			$p_desc = trim(gpc('p_desc','P','',0));
			$tags = trim(gpc('post_tag','P',''));
			if($tags){
				$tags = str_replace('，',',',$tags);
				$tags = str_replace(',,',',',$tags);
				$tags = (substr($tags,-1) ==',') ? substr($tags,0,-1) : $tags;

				$tag_arr = explode(',',$tags);
				if(count($tag_arr) >5){
					$error = true;
					$sysmsg[] = '最多只能填写五个标签';
				}
			}

			if(!$p_name){
				$error = true;
				$sysmsg[] = $settings[pd_post_name].'名称不能为空';
			}else{
				$num = @$db->result_first("select count(*) from {$tpf}posts where p_name='$p_name' and userid='$pd_uid' and pid<>$pid");
				if($num){
					$error = true;
					$sysmsg[] = $settings[pd_post_name].'名称已存在，请返回修改';
				}
			}
			if(!$p_size){
				$error = true;
				$sysmsg[] = $settings[pd_post_name].'大小不能为空';
			}
			if($p_cate1==-1){
				$error = true;
				$sysmsg[] = '请选择'.$settings[pd_post_name].'类别';
			}
			if(!$p_desc){
				$error = true;
				$sysmsg[] = '请填写'.$settings[pd_post_name].'介绍';
			}else{
				$p_desc = preg_replace("/<(\/?i?frame.*?)>/si","",$p_desc);
				$p_desc = preg_replace("/<(\/?script.*?)>/si","",$p_desc);
			}
			if(!empty($file_addr) && !empty($file_text)){
				foreach($file_addr as $k=>$v){
					$file_addr[$k] = htmlspecialchars(str_replace(array('\\'),'',$v));
				}
				foreach($file_text as $k=>$v){
					$file_text[$k] = htmlspecialchars(str_replace(array('\\'),'',$v));
				}
			}else{
				$error = true;
				$sysmsg[] = '请填写'.$settings[pd_post_name].'下载地址';
			}
			if($p_cate4>0){
				$cate_id=$p_cate4;
			}elseif($p_cate3>0){
				$cate_id=$p_cate3;
			}elseif($p_cate2>0){
				$cate_id=$p_cate2;
			}elseif($p_cate1>0){
				$cate_id=$p_cate1;
			}
			if(!$error){
				$cate_id2 = @$db->result_first("select cate_id from {$tpf}posts where cate_id='$pid'");
				$cate_id2 && $db->query_unbuffered("update {$tpf}categories set cate_num=cate_num-1 where cate_id='$cate_id2'");
				$ins = array(
				'p_name'=>$p_name,
				'p_size'=>strtoupper($p_size),
				'p_cate1'=>$p_cate1,
				'p_cate2'=>$p_cate2,
				'p_cate3'=>$p_cate3,
				'p_cate4'=>$p_cate4,
				'cate_id'=>$cate_id,
				'p_lang'=>$p_lang,
				'p_type'=>$p_type,
				'p_auth'=>$p_auth,
				'p_credit'=>$p_credit,
				'file_param'=>addslashes(serialize(array($file_addr,$file_text))),
				'p_site'=>$p_site,
				'p_demo'=>$p_demo,
				'p_desc'=>$p_desc,
				'ip'=>$onlineip,
				'intime'=>$timestamp,
				'is_checked'=>$group_set['check_post'] ? 0 : 1,
				);
				$db->query_unbuffered("update {$tpf}posts set ".$db->sql_array($ins)." where pid='$pid' and userid='$pd_uid'");
				make_tags($tags,$tag_arr,$pid);
				$db->query_unbuffered("update {$tpf}categories set cate_num=cate_num+1 where cate_id='$cate_id'");
				$sysmsg[] = $settings[pd_post_name].'编辑成功';
				redirect(urr("mydisk","item=post&action=post_list"),$sysmsg);
			}else{
				redirect('back',$sysmsg);
			}
		}else{
			$ps = $db->fetch_one_array("select * from {$tpf}posts where pid='$pid' and userid='$pd_uid'");
			$f_arr = unserialize($ps[file_param]);
			//print_r($f_arr);exit;
			$ps[file_list] = '';
			for($i=0;$i<count($f_arr[1]);$i++){
				$ps[file_list] .= '<li class="txtgray">链接：<input type="text" name="file_addr[]" size="30" value="'.$f_arr[0][$i].'" />&nbsp;&nbsp;文字：<input type="text" name="file_text[]" size="30" value="'.$f_arr[1][$i].'" />&nbsp;<a href="javascript:;" onclick="$(this).parent().remove();" title="删除"><img src="images/delete_icon.gif" align="absmiddle" border="0" /></a></li>';
			}
			require_once template_echo($item,$user_tpl_dir);
		}
		break;
	case 'post_list':
	default:
		if($task=='del_file'){
			form_auth(gpc('formhash','P',''),formhash());
			$pids = gpc('pids','P',array());

			$ids_arr = get_ids_arr($pids,'请选择需要操作的记录');
			if($ids_arr[0]){
				$error = true;
				$sysmsg[] = $ids_arr[1];
			}else{
				$file_str = $ids_arr[1];
			}
			if(!$error){
				$db->query_unbuffered("delete {$tpf}posts where pid in ($file_str) and userid='$pd_uid'");
				$sysmsg[] = '删除'.$settings[pd_post_name].'成功';
				redirect('back',$sysmsg);
			}else{
				redirect('back',$sysmsg);
			}

		}else{
			$is_checked = (int)gpc('is_checked','G',-1);
			$sql_add = $is_checked<>-1 ? " is_checked=$is_checked and " : '';
			$sql_do = " {$tpf}posts where $sql_add userid='$pd_uid'";
			$perpage = 20;
			$rs = $db->fetch_one_array("select count(*) as total_num from {$sql_do}");
			$total_num = $rs['total_num'];
			$start_num = ($pg-1) * $perpage;

			$q = $db->query("select * from $sql_do order by pid desc limit $start_num,$perpage");
			$ps = array();
			while ($rs = $db->fetch_array($q)) {
				$rs[intime] = date('Y-m-d',$rs[intime]);
				$rs[a_view] = urr("viewpost","pid=".$rs[pid]."&seo=".$rs[seo]);
				$rs[a_edit] = urr("mydisk","item=post&action=edit_post&pid=".$rs[pid]);
				$rs[is_checked] = $soft_checked_arr[$rs[is_checked]];
				$ps[] = $rs;
			}
			$db->free($q);
			unset($rs);

			$page_nav = multi($total_num, $perpage, $pg, urr("mydisk","item=$item&action=$action"));

			require_once template_echo($item,$user_tpl_dir);
		}
}

?>