<?php 
/**
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Site: http://www.phpdisk.com
#
#	$Id: pay_result.php 17 2014-06-26 03:29:37Z along $
#
#	Copyright (C) 2008-2014 PHPDisk Team. All Rights Reserved.
#
*/

include "includes/commons.inc.php";

$in_front = true;

phpdisk_core::user_login();

$title = __('pay_result').' - '.$settings[site_title];
include PHPDISK_ROOT."./includes/header.inc.php";
$settings['site_alipay_type'] = 'onlinepay';
switch($action){
	case 'alipay':
		if($settings[alipay_double]){
			$out_trade_no = trim(gpc('out_trade_no','G',''));

			$rs = $db->fetch_one_array("select order_id,cp_id,pay_status,total_fee from {$tpf}credit_plans_orders where order_number='$out_trade_no' and pay_method='alipay' and userid='$pd_uid'");
			if($rs){
				$cp_id = $rs[cp_id];
				$total_fee = $rs[total_fee];
				$order_id = (int)$rs['order_id'];
				$pay_status = $rs[pay_status];
			}
			unset($rs);
			if($pay_status=='pendding'){
				if($pay_action=='success'){

					$db->query_unbuffered("update {$tpf}users set credit=credit+$total_fee where userid='$pd_uid'");
					$db->query_unbuffered("update {$tpf}credit_plans_orders set pay_status='success' where order_id='$order_id'");

					add_credit_log(0,$total_fee,'online_pay',$pd_uid);

					$s_title = __('pay_success');
					$msg = __('your_order').': '.$out_trade_no.','.__('pay_success');

				}else{
					$db->query_unbuffered("update {$tpf}credit_plans_orders set pay_status='fail' where order_id='$order_id'");

					$s_title = __('pay_fail');
					$msg = __('your_order').': '.$out_trade_no.','.__('pay_fail');
				}
			}else{
				$s_title = '订单支付重复提示';
				$msg = '您的订单已完成，请勿重复刷新页面。';
			}
			require_once template_echo('pd_pay_result',$user_tpl_dir);

		}else{ // direct

			require_once PD_PLUGINS_DIR."payment/alipay/alipay_config.php";
			require_once PD_PLUGINS_DIR."payment/alipay/class/alipay_notify.php";

			$alipay = new alipay_notify($partner,$key,$sign_type,$_input_charset,$transport);
			$verify_result = $alipay->return_verify();

			$out_trade_no = trim(gpc('out_trade_no','G',''));
			$total_fee = (float)gpc('total_fee','G','');
			$trade_status = gpc('trade_status','G','');

			$rs = $db->fetch_one_array("select order_id,cp_id,pay_status,total_fee from {$tpf}credit_plans_orders where order_number='$out_trade_no' and pay_method='$action' and userid='$pd_uid'");
			if($rs){
				$cp_id = $rs[cp_id];
				$order_id = (int)$rs['order_id'];
				$total_fee = (int)$rs['total_fee'];
				$pay_status = $rs[pay_status];
			}
			unset($rs);
			if($pay_status=='pendding'){
				if($verify_result && ($trade_status == 'TRADE_FINISHED' || $trade_status == 'TRADE_SUCCESS')) {

					$db->query_unbuffered("update {$tpf}users set credit=credit+$total_fee where userid='$pd_uid'");
					$db->query_unbuffered("update {$tpf}credit_plans_orders set pay_status='success' where order_id='$order_id'");

					add_credit_log(0,$total_fee,'online_pay',$pd_uid);

					$s_title = __('pay_success');
					$msg = __('your_order').': '.$out_trade_no.','.__('pay_success');

				}else{					
					$db->query_unbuffered("update {$tpf}credit_plans_orders set pay_status='fail' where order_id='$order_id'");

					$s_title = __('pay_fail');
					$msg = __('your_order').': '.$out_trade_no.','.__('pay_fail');
				}
			}else{
				$s_title = __('repay_title');
				$msg = __('repay_tips');
			}
			require_once template_echo('pd_pay_result',$user_tpl_dir);
		}
		break;

	case 'tenpay':
		include_once PD_PLUGINS_DIR."payment/tenpay/PayResponseHandler.class.php";

		$key = $settings['ten_key'];
		$resHandler = new PayResponseHandler();
		$resHandler->setKey($key);

		if($resHandler->isTenpaySign()) {
			$transaction_id = $resHandler->getParameter("transaction_id");
			$total_fee = $resHandler->getParameter("total_fee");
			$total_fee = round($total_fee/100,2);
			$pay_result = $resHandler->getParameter("pay_result");

			$rs = $db->fetch_one_array("select order_id,cp_id,pay_status,total_fee from {$tpf}credit_plans_orders where order_number='$transaction_id' and pay_method='$action' and userid='$pd_uid'");
			if($rs){
				$cp_id = $rs[cp_id];
				$order_id = (int)$rs['order_id'];
				$total_fee = (int)$rs['total_fee'];
				$pay_status = $rs[pay_status];
			}
			unset($rs);
			if($pay_status=='pendding'){
				if( "0" == $pay_result ) {

					$db->query_unbuffered("update {$tpf}users set credit=credit+$total_fee where userid='$pd_uid'");
					$db->query_unbuffered("update {$tpf}credit_plans_orders set pay_status='success' where order_id='$order_id'");

					add_credit_log(0,$total_fee,'online_pay',$pd_uid);

					$s_title = __('pay_success');
					$msg = __('your_order').': '.$transaction_id.','.__('pay_success');
				}else{
					//$db->query_unbuffered("update {$tpf}users set credit=credit+$total_fee where userid='$pd_uid' limit 1");
					$db->query_unbuffered("update {$tpf}credit_plans_orders set pay_status='fail' where order_id='$order_id'");

					$s_title = __('pay_fail');
					$msg = __('your_order').': '.$transaction_id.','.__('pay_fail');
				}
			} else {
				$msg = '<span class="txtred">'.__('sign_pay_error').'</span>';
			}
		}else{
			$s_title = __('repay_title');
			$msg = __('repay_tips');
		}
		require_once template_echo('pd_pay_result',$user_tpl_dir);
		break;	
	default:
		redirect('./','');
}
include PHPDISK_ROOT."./includes/footer.inc.php";

?>