<?php 
/**
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Site: http://www.phpdisk.com
#
#	$Id: rss.php 17 2014-06-26 03:29:37Z along $
#
#	Copyright (C) 2008-2014 PHPDisk Team. All Rights Reserved.
#
*/
error_reporting(0);
define('PHPDISK_ROOT', dirname(__FILE__).'/');
define('IN_PHPDISK',TRUE);
if(strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
	define('OS_WIN',true);
	define('LF',"\r\n");
}else{
	define('OS_WIN',false);
	define('LF',"\n");
}
$arr = array('global');
for ($i=0;$i<count($arr);$i++){
	require(PHPDISK_ROOT.'includes/function/'.$arr[$i].'.func.php');
}
$arr = array('core','mysql');
for ($i=0;$i<count($arr);$i++){
	require(PHPDISK_ROOT.'includes/class/'.$arr[$i].'.class.php');
}
require_once(PHPDISK_ROOT.'system/configs.inc.php');
require_once(PHPDISK_ROOT.'system/settings.inc.php');

phpdisk_core::init_core();
$db = phpdisk_core::init_db_connect();
$charset = $configs['charset'];
$tpf = $configs[tpf];

$arr = array();
$q = $db->query("select p.pid,p_name,seo,intime,u.username,cate_name from {$tpf}posts p,{$tpf}users u,{$tpf}categories c where p.userid=u.userid and p.cate_id=c.cate_id and is_checked=1 order by p.pid desc limit 30");
while ($rs = $db->fetch_array($q)) {
	$rs[title] = $rs['p_name'];
	$rs[link] = $settings[phpdisk_url].urr("viewpost","pid=$rs[pid]&seo=$rs[seo]");
	$rs[file_description] = $rs[p_desc] ? cutstr($rs[p_desc],150) : $rs[title];
	$rs[pubDate] = date('Y-m-d H:i:s',$rs[intime]);
	$arr[] = $rs;
}
$db->free($q);
unset($rs);
//	ob_end_clean();
/*		header( "Content-type: application/xml; charset=\"".$charset . "\"", true );
header( 'Pragma: no-cache' );*/
@ob_end_clean();
header("Content-type:application/xml");

$str = '<?xml version="1.0" encoding="'.$charset.'" ?>'.LF;
$str .= '<rss version="2.0">'.LF;
$str .= '<channel>'.LF;
$str .= "\t<title>最近30个更新的".$settings[pd_post_name]."</title>".LF;
$str .= "\t<link>{$settings[phpdisk_url]}</link>".LF;
$str .= "\t<description><![CDATA[last 30's file of {$settings[site_title]}]]></description>".LF;
$str .= "\t<pubDate>". date('Y-m-d H:i:s')."</pubDate>".LF;
$str .= '<copyright>(C)'.date('Y').'. All rights reserved.</copyright>'.LF;
$str .= '<generator> RSS Source</generator>'.LF;
$str .= '<ttl>60</ttl>'.LF;
foreach($arr as $v){
	$str .= "\t<item>".LF;
	$str .= "\t\t<title>{$v[title]}</title>".LF;
	$str .= "\t\t<author>{$v[username]}</author>".LF;
	$str .= "\t\t<link>{$v[link]}</link>".LF;
	$str .= "\t\t<category>{$v[cate_name]}</category>".LF;
	$str .= "\t\t<description><![CDATA[{$v[file_description]}]]></description>".LF;
	$str .= "\t\t<pubDate>". $v[pubDate]."</pubDate>".LF;
	$str .= "\t</item>".LF;
}
$str .= '</channel>'.LF;
$str .= '</rss>'.LF;
//write_file($rss_file,$str,'wb+');
echo $str;


?>
