<?php 
/**
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Site: http://www.phpdisk.com
#
#	$Id: vip_result.php 17 2014-06-26 03:29:37Z along $
#
#	Copyright (C) 2008-2014 PHPDisk Team. All Rights Reserved.
#
*/

include "includes/commons.inc.php";

$in_front = true;

if(!display_plugin('payment','open_payment_plugin',$settings['open_payment'],0)){
	exit('ERROR: payment '.__('plugin_not_install'));
}
phpdisk_core::user_login();
$settings['site_alipay_type'] = 'vip';
$title = __('pay_result').' - '.$settings[site_title];
include PHPDISK_ROOT."./includes/header.inc.php";
$back_money=0;
switch($action){
	case 'mywealth':
		$order_number = trim(gpc('order_number','G',''));
		$sign = trim(gpc('sign','G',''));

		$rs = $db->fetch_one_array("select order_id,total_fee,vip_id,pay_status from {$tpf}vip_orders where order_number='$order_number' and pay_method='$action' and userid='$pd_uid'");
		if($rs){
			$total_fee = $rs[total_fee];
			$vip_id = $rs[vip_id];
			$order_id = (int)$rs['order_id'];
			$pay_status = $rs[pay_status];
		}
		unset($rs);
		$md5_sign = md5($order_number.$total_fee.$pd_uid.$action);
		if($pay_status=='pendding'){
			if($sign==$md5_sign){
				if(get_profile($pd_uid,'vip_end_time')>$timestamp && get_profile($pd_uid,'vip_id')){
					$back_money = @round((get_vip(get_profile($pd_uid,'vip_id'),'price')/get_vip(get_profile($pd_uid,'vip_id'),'days'))*((get_profile($pd_uid,'vip_end_time')-$timestamp)/86400),4);
				}
				$db->query_unbuffered("update {$tpf}users set wealth=wealth+$back_money,vip_id=0,vip_end_time=0 where userid='$pd_uid'");
				$ins = array(
				'vip_id'=>$vip_id,
				'vip_end_time'=>$timestamp+get_vip($vip_id,'days')*86400,
				);
				$db->query_unbuffered("update {$tpf}users set ".$db->sql_array($ins)." where userid='$pd_uid'");
				$db->query_unbuffered("update {$tpf}vip_orders set pay_status='success' where order_id='$order_id'");
				$s_title = __('pay_success');
				$msg = __('your_order').': '.$order_number.','.__('pay_success');

			}else{
				$db->query_unbuffered("update {$tpf}users set wealth=wealth+$total_fee where userid='$pd_uid' limit 1");
				$db->query_unbuffered("update {$tpf}vip_orders set pay_status='fail' where order_id='$order_id'");
				$s_title = __('pay_fail');
				$msg = __('your_order').': '.$order_number.','.__('pay_fail');
			}
		}else{
			$s_title = __('repay_title');
			$msg = __('repay_tips');
		}
		require_once template_echo('pd_vip_result',$user_tpl_dir);
		break;

	case 'alipay':
		require_once PD_PLUGINS_DIR."payment/alipay/alipay_config.php";
		require_once PD_PLUGINS_DIR."payment/alipay/class/alipay_notify.php";

		$alipay = new alipay_notify($partner,$key,$sign_type,$_input_charset,$transport);
		$verify_result = $alipay->return_verify();

		$out_trade_no = trim(gpc('out_trade_no','G',''));
		$total_fee = (float)gpc('total_fee','G','');
		$trade_status = gpc('trade_status','G','');

		$rs = $db->fetch_one_array("select order_id,vip_id,pay_status from {$tpf}vip_orders where order_number='$out_trade_no' and pay_method='$action' and userid='$pd_uid'");
		if($rs){
			$vip_id = $rs[vip_id];
			$order_id = (int)$rs['order_id'];
			$pay_status = $rs[pay_status];
		}
		unset($rs);
		if($pay_status=='pendding'){
			if($verify_result && ($trade_status == 'TRADE_FINISHED' || $trade_status == 'TRADE_SUCCESS')) {
				if(get_profile($pd_uid,'vip_end_time')>$timestamp && get_profile($pd_uid,'vip_id')){
					$back_money = @round((get_vip(get_profile($pd_uid,'vip_id'),'price')/get_vip(get_profile($pd_uid,'vip_id'),'days'))*((get_profile($pd_uid,'vip_end_time')-$timestamp)/86400),4);
				}
				$db->query_unbuffered("update {$tpf}users set wealth=wealth+$back_money,vip_id=0,vip_end_time=0 where userid='$pd_uid'");
				$ins = array(
				'vip_id'=>$vip_id,
				'vip_end_time'=>$timestamp+get_vip($vip_id,'days')*86400,
				);
				$db->query_unbuffered("update {$tpf}users set ".$db->sql_array($ins)." where userid='$pd_uid'");
				$db->query_unbuffered("update {$tpf}vip_orders set pay_status='success' where order_id='$order_id'");

				$s_title = __('pay_success');
				$msg = __('your_order').': '.$out_trade_no.','.__('pay_success');

			}else{
				$db->query_unbuffered("update {$tpf}users set wealth=wealth+$total_fee where userid='$pd_uid' limit 1");
				$db->query_unbuffered("update {$tpf}vip_orders set pay_status='fail' where order_id='$order_id'");

				$s_title = __('pay_fail');
				$msg = __('your_order').': '.$out_trade_no.','.__('pay_fail');
			}
		}else{
			$s_title = __('repay_title');
			$msg = __('repay_tips');
		}
		require_once template_echo('pd_vip_result',$user_tpl_dir);
		break;

	case 'tenpay':
		include_once PD_PLUGINS_DIR."payment/tenpay/PayResponseHandler.class.php";

		$key = $settings['ten_key'];
		$resHandler = new PayResponseHandler();
		$resHandler->setKey($key);

		if($resHandler->isTenpaySign()) {
			$transaction_id = $resHandler->getParameter("transaction_id");
			$total_fee = $resHandler->getParameter("total_fee");
			$total_fee = round($total_fee/100,2);
			$pay_result = $resHandler->getParameter("pay_result");

			$rs = $db->fetch_one_array("select order_id,vip_id,pay_status from {$tpf}vip_orders where order_number='$transaction_id' and pay_method='$action' and userid='$pd_uid'");
			if($rs){
				$vip_id = $rs[vip_id];
				$order_id = (int)$rs['order_id'];
				$pay_status = $rs[pay_status];
			}
			unset($rs);
			if($pay_status=='pendding'){
				if( "0" == $pay_result ) {
					if(get_profile($pd_uid,'vip_end_time')>$timestamp && get_profile($pd_uid,'vip_id')){
						$back_money = @round((get_vip(get_profile($pd_uid,'vip_id'),'price')/get_vip(get_profile($pd_uid,'vip_id'),'days'))*((get_profile($pd_uid,'vip_end_time')-$timestamp)/86400),4);
					}
					$db->query_unbuffered("update {$tpf}users set wealth=wealth+$back_money,vip_id=0,vip_end_time=0 where userid='$pd_uid'");
					$ins = array(
					'vip_id'=>$vip_id,
					'vip_end_time'=>$timestamp+get_vip($vip_id,'days')*86400,
					);
					$db->query_unbuffered("update {$tpf}users set ".$db->sql_array($ins)." where userid='$pd_uid'");
					$db->query_unbuffered("update {$tpf}vip_orders set pay_status='success' where order_id='$order_id'");

					$s_title = __('pay_success');
					$msg = __('your_order').': '.$transaction_id.','.__('pay_success');
				}else{
					$db->query_unbuffered("update {$tpf}users set wealth=wealth+$total_fee where userid='$pd_uid' limit 1");
					$db->query_unbuffered("update {$tpf}vip_orders set pay_status='fail' where order_id='$order_id'");

					$s_title = __('pay_fail');
					$msg = __('your_order').': '.$transaction_id.','.__('pay_fail');
				}
			} else {
				$msg = '<span class="txtred">'.__('sign_pay_error').'</span>';
			}
		}else{
			$s_title = __('repay_title');
			$msg = __('repay_tips');
		}
		require_once template_echo('pd_vip_result',$user_tpl_dir);
		break;
	
	default:
		redirect('./','');
}
include PHPDISK_ROOT."./includes/footer.inc.php";

?>