<?php 
##
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Site: http://www.phpdisk.com
#
#	$Id: install.php 21 2013-02-19 02:13:04Z along $
#
#	Copyright (C) 2008-2013 PHPDisk Team. All Rights Reserved.
#
##
if(!defined('IN_DISCUZ')) {
	exit('[PHPDISK] Access Denied');
}
$sql = <<<EOF
CREATE TABLE IF NOT EXISTS `pre_phpdisk_downlog` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `hash` char(32) NOT NULL,
  `ip` varchar(15) NOT NULL,
  `downcount` int(10) unsigned NOT NULL default '0',
  `intime` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `hash` (`hash`),
  KEY `ip` (`ip`)
) ENGINE=MyISAM;

CREATE TABLE IF NOT EXISTS `pre_phpdisk_files` (
  `file_id` bigint(20) unsigned NOT NULL auto_increment,
  `file_name` varchar(100) NOT NULL,
  `file_key` char(8) NOT NULL,
  `file_extension` varchar(10) NOT NULL,
  `is_image` tinyint(1) unsigned NOT NULL default '0',
  `file_description` text NOT NULL,
  `file_store_path` varchar(255) NOT NULL,
  `file_real_name` varchar(100) NOT NULL,
  `file_md5` char(32) NOT NULL,
  `file_size` int(10) unsigned NOT NULL default '0',
  `file_time` int(10) unsigned NOT NULL default '0',
  `server_oid` smallint(5) unsigned NOT NULL default '0',
  `file_views` int(10) unsigned default '0',
  `file_downs` int(10) unsigned NOT NULL default '0',
  `file_remote_url` varchar(255) NOT NULL,
  `file_last_view` int(10) unsigned default '0',
  `file_credit` tinyint(2) unsigned NOT NULL default '0',
  `report_status` tinyint(1) unsigned NOT NULL default '0',
  `in_share` tinyint(1) unsigned NOT NULL default '0',
  `good_count` mediumint(8) unsigned NOT NULL default '0',
  `bad_count` mediumint(8) unsigned NOT NULL default '0',
  `is_locked` tinyint(1) unsigned NOT NULL default '0',
  `is_checked` tinyint(1) unsigned NOT NULL default '0',
  `is_public` tinyint(1) unsigned NOT NULL default '0',
  `userid` int(10) unsigned NOT NULL default '0',
  `folder_id` bigint(20) NOT NULL default '0',
  `ip` varchar(15) NOT NULL,
  `is_del` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`file_id`),
  KEY `userid` (`userid`),
  KEY `folder_id` (`folder_id`),
  KEY `server_oid` (`server_oid`)
) ENGINE=MyISAM ;

CREATE TABLE IF NOT EXISTS `pre_phpdisk_folders` (
  `folder_id` bigint(20) unsigned NOT NULL auto_increment,
  `parent_id` bigint(20) NOT NULL default '0',
  `folder_name` varchar(50) NOT NULL,
  `folder_description` varchar(255) NOT NULL,
  `in_recycle` tinyint(1) unsigned NOT NULL default '0',
  `in_share` tinyint(1) unsigned NOT NULL default '0',
  `folder_order` smallint(5) unsigned NOT NULL default '0',
  `folder_size` int(10) unsigned NOT NULL default '0',
  `userid` int(10) unsigned NOT NULL default '0',
  `in_time` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`folder_id`),
  KEY `userid` (`userid`),
  KEY `parent_id` (`parent_id`),
  KEY `folder_order` (`folder_order`)
) ENGINE=MyISAM;

CREATE TABLE IF NOT EXISTS `pre_phpdisk_myset` (
  `userid` mediumint(8) unsigned NOT NULL default '0',
  `frame_mode` tinyint(1) NOT NULL default '0',
  `show_subfolder` tinyint(1) NOT NULL default '0',
  `upload_in_share` tinyint(1) NOT NULL default '0',
  `ip` varchar(15) NOT NULL,
  `active_time` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`userid`)
) ENGINE=MyISAM;

CREATE TABLE IF NOT EXISTS `pre_phpdisk_nodes` (
  `node_id` int(10) unsigned NOT NULL auto_increment,
  `subject` varchar(200) NOT NULL,
  `parent_id` int(10) unsigned NOT NULL default '0',
  `server_oid` smallint(5) unsigned NOT NULL default '0',
  `host` varchar(150) NOT NULL,
  `icon` varchar(255) NOT NULL,
  `down_type` tinyint(1) unsigned NOT NULL default '0',
  `show_order` tinyint(2) unsigned NOT NULL default '0',
  `is_hidden` tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (`node_id`),
  KEY `parent_id` (`parent_id`)
) ENGINE=MyISAM;

CREATE TABLE IF NOT EXISTS `pre_phpdisk_servers` (
  `server_id` smallint(5) unsigned NOT NULL auto_increment,
  `server_oid` smallint(5) unsigned NOT NULL default '0',
  `server_name` varchar(50) NOT NULL,
  `server_host` varchar(100) NOT NULL,
  `server_dl_host` text NOT NULL,
  `server_closed` tinyint(1) unsigned NOT NULL default '0',
  `server_store_path` varchar(50) NOT NULL,
  `server_key` varchar(50) NOT NULL,
  `is_default` tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (`server_id`),
  KEY `server_oid` (`server_oid`)
) ENGINE=MyISAM;

CREATE TABLE IF NOT EXISTS `pre_phpdisk_settings` (
  `vars` varchar(50) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY  (`vars`)
) ENGINE=MyISAM;

INSERT INTO `pre_phpdisk_settings` (`vars`, `value`) VALUES
('phpdisk_upload_title', 'PHPDisk Mini Upload'),
('store_path', 'filestores'),
('site_title','PHPDisk Mini');

INSERT INTO `pre_phpdisk_nodes` (`node_id`, `subject`, `parent_id`, `server_oid`, `host`, `icon`, `down_type`, `show_order`, `is_hidden`) VALUES
(1, 'ص', 0, 2, '', 'source/plugin/phpdisk/images/d_dx.jpg', 0, 0, 0),
(2, 'һ', 1, 2, 'http://localhost/bbs/dx2/source/plugin/phpdisk/sub/', 'source/plugin/phpdisk/images/d_dx.jpg', 0, 0, 1),
(3, 'ض', 1, 2, 'http://localhost/bbs/dx2/source/plugin/phpdisk/sub/', 'source/plugin/phpdisk/images/d_dx.jpg', 0, 0, 0),
(4, 'ͨͨص', 0, 2, '', '', 0, 0, 0),
(5, 'ͨһ', 4, 2, 'http://localhost/bbs/dx2/source/plugin/phpdisk/sub/', 'source/plugin/phpdisk/images/d_wt.jpg', 0, 0, 0),
(6, 'ͨض', 4, 2, 'http://localhost/bbs/dx2/source/plugin/phpdisk/sub/', 'source/plugin/phpdisk/images/d_wt.jpg', 0, 0, 0);

INSERT INTO `pre_phpdisk_servers` (`server_id`, `server_oid`, `server_name`, `server_host`, `server_dl_host`, `server_closed`, `server_store_path`, `server_key`, `is_default`) VALUES
(1, 0, 'Local Server', '-', '', 0, '-', '', 9),
(2, 2, 'Upload Server', 'http://localhost/bbs/dx2/source/plugin/phpdisk/sub/', '', 0, 'filestores', 'Evn9XztDLSlo', 1);

EOF;

runquery($sql);

$finish = TRUE;

?>