<?php get_header(); ?>

<!-- BEGIN container -->
<div class="inner" id="container">
<!-- BEGIN content -->
<div id="content">

	<!-- begin lifestyle -->
	<?php 
	if (have_posts()) :
	?>
	<div class="box">
		<div class="horizontal one">
			<?php $post = $posts[0]; // Hack. Set $post so that the_date() works. ?>
			<?php /* If this is a category archive */ if (is_category()) { ?>
			<h2 class="title">Archive for the <strong><?php single_cat_title(); ?></strong> Category</h2>
			<?php /* If this is a tag archive */ } elseif( is_tag() ) { ?>
			<h2 class="title">Posts Tagged <strong><?php single_tag_title(); ?></strong></h2>
			<?php /* If this is a daily archive */ } elseif (is_day()) { ?>
			<h2 class="title">Archive for <?php the_time('F jS, Y'); ?></h2>
			<?php /* If this is a monthly archive */ } elseif (is_month()) { ?>
			<h2 class="title">Archive for <?php the_time('F, Y'); ?></h2>
			<?php /* If this is a yearly archive */ } elseif (is_year()) { ?>
			<h2 class="title">Archive for <?php the_time('Y'); ?></h2>
			<?php /* If this is an author archive */ } elseif (is_author()) { ?>
			<h2 class="title">Author Archive</h2>
			<?php /* If this is a paged archive */ } elseif (isset($_GET['paged']) && !empty($_GET['paged'])) { ?>
			<h2 class="title">Blog Archives</h2>
			<?php } ?>
		</div>
		<div class="full right">
		<ul>
		<?php while (have_posts()) : the_post(); ?>
		<li>
			<a href="<?php the_permalink(); ?>"><?php dp_attachment_image($post->ID, 'thumbnail', 'alt="' . $post->post_title . '"'); ?></a>
			<a class="title" href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
			<p><?php echo dp_clean($post->post_content, 80); ?></p>
		</li>
		<?php endwhile; ?>
		</ul>
		</div>
		<div class="break"></div>
	</div>
	<?php endif; ?>
	<!-- end lifestyle -->
	
</div>
<!-- END content -->

<?php include('sidebar.php'); ?>
<div class="break"></div>
</div>
<!-- END container -->

<?php include('footer1.php'); ?>
<?php get_footer(); ?>
