<?php

// Do not delete these lines
if (!empty($_SERVER['SCRIPT_FILENAME']) && 'comments.php' == basename($_SERVER['SCRIPT_FILENAME']))
	die ('Please do not load this page directly. Thanks!');
if ( post_password_required() ) { ?>
	<p class="nocomments">This post is password protected. Enter the password to view comments.</p>
	<?php
	return;
}

?>

<!-- BEGIN comments  -->
<div class="comments">

	<?php if ( have_comments() ) : ?>
	<!-- begin comments -->
	<h2><?php comments_number('No Responses', 'One Response', '% Responses' );?> to &#8220;<?php the_title(); ?>&#8221;</h2>
	<ol class="responses">
	<?php wp_list_comments('type=comment&callback=mytheme_comment'); ?>
	</ol>	
	<div class="navigation">
		<p class="alignleft"><?php previous_comments_link() ?></p>
		<p class="alignright"><?php next_comments_link() ?></p>
	</div>
	<!-- end comments -->
	<?php endif; ?>

</div>
<!-- END comments -->
	
	<?php if ('open' == $post->comment_status) : ?>
		<?php 
		if ( get_option('comment_registration') && !$user_ID ) : 
			// Do nothing...
		else :
		?>
			<!-- begin comment form -->
			<div id="respond" class="submit">
			<h2>Leave Reply</h2>
			<?php if ($user_ID) : ?>
				<p class="user">You are logged in as <strong><a href="<?php echo get_option('siteurl'); ?>/wp-admin/profile.php"><?php echo $user_identity; ?></a></strong>. <a href="<?php echo wp_logout_url(get_permalink()); ?>">Click here to logout</a>.</p>
				<form id="commentform" action="<?php echo get_option('siteurl'); ?>/wp-comments-post.php" method="post">
			<?php else : ?>
				<form id="commentform" action="<?php echo get_option('siteurl'); ?>/wp-comments-post.php" method="post">
				<input id="name" class="text" type="text" name="author" value="<?php echo $comment_author; ?>" />
				<input id="email" class="text" type="text" name="email" value="<?php echo $comment_author_email; ?>"  />
				<input id="url" class="text" type="text" name="url" value="<?php echo $comment_author_url; ?>" />
			<?php endif; ?>
			<textarea rows="4" cols="60" name="comment"></textarea>
				<button name="submit" type="submit">Submit</button>
			<?php comment_id_fields(); ?>
			<p class="cancel"><?php cancel_comment_reply_link(); ?></p>
			</form>
			</div>
		<?php endif; ?>
	<?php endif; ?>
