<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" dir="ltr" lang="en-US">

<!-- BEGIN html head -->
<head>
<meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />
<title><?php bloginfo('name'); ?> <?php wp_title(); ?></title>
<link rel="stylesheet" type="text/css" href="<?php bloginfo('stylesheet_url'); ?>" />
<!--[if IE 6]>
	<link rel="stylesheet" type="text/css" href="<?php bloginfo('template_url'); ?>/ie6.css" />
<![endif]-->
<?php if (function_exists('wp_enqueue_script') && function_exists('is_singular')) : ?>
<?php if ( is_singular() ) wp_enqueue_script( 'comment-reply' ); ?>
<?php endif; ?>
<?php wp_head(); ?>
<script type="text/javascript" src="<?php bloginfo('template_url'); ?>/js/jquery-1.6.1.min.js"></script>
<script type="text/javascript" src="<?php bloginfo('template_url'); ?>/js/jquery.cycle.all.min.js"></script>
<script type="text/javascript" src="<?php bloginfo('template_url'); ?>/js/main.js"></script>
</head>
<!-- END html head -->

<body>

<!-- BEGIN wrapper -->
<div id="wrapper">

	<!-- BEGIN header -->
	<div id="header">
		<div class="top">
			<ul>
				<li><a href="<?php echo get_option('home'); ?>">Home</a></li>
				<?php dp_list_pages(); ?>
			</ul>
			<p>Subscribe: <a href="<?php echo dp_settings('rss_url') ?>">RSS</a> | <a href="<?php echo dp_settings('newsletter_url') ?>">Email</a></p>
		</div>
		<?php if (dp_settings('logotext')=='enable') { ?>
			<div class="logo2">
			<h1><a href="<?php echo get_option('home'); ?>"><?php bloginfo('name'); ?></a></h1>
			<p><?php bloginfo('description'); ?></p>
			</div>
		<?php } elseif (strlen(dp_settings('logo'))>0) { ?>
			<div class="logo"><a href="<?php echo get_option('home'); ?>"><img src="<?php echo dp_settings('logo'); ?>" alt="<?php bloginfo('name'); ?>" /></a></div>
		<?php } else { ?>
			<h1 class="logo3"><a href="<?php echo get_option('home'); ?>"><?php bloginfo('name'); ?></a></h1>
		<?php } ?>
		<div class="search">
			<p><?php echo date('l, F j, Y'); ?></p>
			<form method="get" action="<?php echo get_option('home'); ?>/">
				<input class="text" type="text" value="" name="s" id="s" />
				<input class="submit" type="submit" value="Go" name="Go" />
			</form>
		</div>
		<ul class="categories">
			<?php wp_list_categories('title_li='); ?>
		</ul>
	</div>
	<!-- END header -->
