<?php

$themename = "Colossus";
$shortname = "colossus";

$settings = array();
$options = array (
	
	/** BEGIN General Settings **/
	array(
		"name"=>"General Settings",
		"id"=>$shortname."_general_settings",
		"type"=>"open",
		),
	array(
		"name"=>"Use Text as Logo",
		"id"=>$shortname."_logotext",
		"std"=>"disable",
		"type"=>"select",
		"options"=>array('disable', 'enable'),
		"note"=>""
		),
	array(
		"name"=>"Logo URL",
		"id"=>$shortname."_logo",
		"std"=>"",
		"upload"=>true,
		"type"=>"text",
		"note"=>""
		),
	array(
		"name"=>"Contact Email",
		"id"=>$shortname."_contact_email",
		"std"=>"admin@wpbliss.com",
		"type"=>"text",
		"note"=>""
		),
	array(  
		"name"=>"Google Analytics Code",
		"id"=>$shortname."_analytics",
		"std"=>"<!-- Google Analytics code goes here -->",
		"type"=>"textarea"
		),
	array(  
		"name"=>"RSS URL",
		"id"=>$shortname."_rss_url",
		"std"=>"#rss",
		"type"=>"text"
		),
	array(  
		"name"=>"Newsletter Subscription Page",
		"id"=>$shortname."_newsletter_url",
		"std"=>"#newsletter",
		"type"=>"text"
		),
	array("type"=>"close"),
	/** END General Settings **/
	
	/** BEGIN Homepage Settings **/
	array(
		"name"=>"Homepage Settings",
		"id"=>$shortname."_homepage_settings",
		"type"=>"open",
		),
	array(  
		"name"=>"Show Featured Content",
		"id"=>$shortname."_show_featured",
		"std"=>"enable",
		"type"=>"select",
		"options"=>array('enable', 'disable')),
	array(  
		"name"=>"Featured Content Category Name",
		"id"=>$shortname."_featured",
		"std"=>"Uncategorized",
		"type"=>"text"
		),
	array(  
		"name"=>"Categories to Display",
		"id"=>$shortname."_categories",
		"std"=>"Uncategorized",
		"type"=>"text",
		"note"=>"Comma-separated list of category names."
		),
	array(  
		"name"=>"News in Pictures Category Name",
		"id"=>$shortname."_news_in_pictures",
		"std"=>"Uncategorized",
		"type"=>"text"
		),
	array(  
		"name"=>"News in Pictures Category Name",
		"id"=>$shortname."_news_in_pictures",
		"std"=>"Uncategorized",
		"type"=>"text"
		),
	array(  
		"name"=>"News in Links Category Name",
		"id"=>$shortname."_news_in_links",
		"std"=>"Uncategorized",
		"type"=>"text"
		),
	array("type"=>"close"),
	/** END Homepage Settings **/
	
	/** BEGIN Sidebar Settings **/
	array(
		"name"=>"Sidebar Settings",
		"id"=>$shortname."_sidebar_settings",
		"type"=>"open",
		),
	array(  
		"name"=>"Show Popular Posts",
		"id"=>$shortname."_show_popular",
		"std"=>"enable",
		"type"=>"select",
		"options"=>array('enable', 'disable')
		),
	array(  
		"name"=>"Popular Posts Title",
		"id"=>$shortname."_popular_title",
		"std"=>"Popular",
		"type"=>"text"
		),
	array(  
		"name"=>"Show Popular Post Thumbnails",
		"id"=>$shortname."_show_popular_thumbnails",
		"std"=>"enable",
		"type"=>"select",
		"options"=>array('enable', 'disable')
		),
	array(  
		"name"=>"Show Popular Post Details",
		"id"=>$shortname."_show_popular_details",
		"std"=>"enable",
		"type"=>"select",
		"options"=>array('enable', 'disable')
		),
	array(  
		"name"=>"Number of Popular Posts",
		"id"=>$shortname."_popular_count",
		"std"=>"5",
		"type"=>"text"
		),
	array(  
		"name"=>"Show Latest Posts",
		"id"=>$shortname."_show_latest",
		"std"=>"enable",
		"type"=>"select",
		"options"=>array('enable', 'disable')
		),
	array(  
		"name"=>"Latest Posts Title",
		"id"=>$shortname."_latest_title",
		"std"=>"Latest",
		"type"=>"text"
		),
	array(  
		"name"=>"Show Latest Post Thumbnails",
		"id"=>$shortname."_show_latest_thumbnails",
		"std"=>"enable",
		"type"=>"select",
		"options"=>array('enable', 'disable')
		),
	array(  
		"name"=>"Show Recent Post Details",
		"id"=>$shortname."_show_latest_details",
		"std"=>"enable",
		"type"=>"select",
		"options"=>array('enable', 'disable')
		),
	array(  
		"name"=>"Number of Latest Posts",
		"id"=>$shortname."_latest_count",
		"std"=>"5",
		"type"=>"text"
		),
	array(  
		"name"=>"Show Comments",
		"id"=>$shortname."_show_comments",
		"std"=>"enable",
		"type"=>"select",
		"options"=>array('enable', 'disable')
		),
	array(  
		"name"=>"Comments Title",
		"id"=>$shortname."_comments_title",
		"std"=>"Comments",
		"type"=>"text"
		),
	array(  
		"name"=>"Number of Comments",
		"id"=>$shortname."_comments_count",
		"std"=>"8",
		"type"=>"text"
		),
	array(  
		"name"=>"Show Tags",
		"id"=>$shortname."_show_tags",
		"std"=>"enable",
		"type"=>"select",
		"options"=>array('enable', 'disable')
		),
	array(  
		"name"=>"Tags Title",
		"id"=>$shortname."_tags_title",
		"std"=>"Tags",
		"type"=>"text"
		),
	array(  
		"name"=>"Show Ad Widget",
		"id"=>$shortname."_show_ad_widget",
		"std"=>"enable",
		"type"=>"select",
		"options"=>array('enable', 'disable')
		),
	array(  
		"name"=>"Ad Widget Title",
		"id"=>$shortname."_ad_widget_title",
		"std"=>"Ad Widget",
		"type"=>"text"
		),
	array(  
		"name"=>"Ad Widget Code",
		"id"=>$shortname."_ad_widget_code",
		"std"=>'<a href="#"><img src="' . get_bloginfo('template_url'). '/images/ad123x1231.gif" alt="Advertisement" /></a><a href="#"><img src="' . get_bloginfo('template_url'). '/images/ad123x1232.gif" alt="Advertisement" /></a><a href="#"><img src="' . get_bloginfo('template_url'). '/images/ad123x1233.gif" alt="Advertisement" /></a><a href="#"><img src="' . get_bloginfo('template_url'). '/images/ad123x1234.gif" alt="Advertisement" /></a>',
		"type"=>"textarea"
		),
	array(  
		"name"=>"Show Video Widget",
		"id"=>$shortname."_show_video_widget",
		"std"=>"enable",
		"type"=>"select",
		"options"=>array('enable', 'disable')
		),
	array(  
		"name"=>"Video Widget Title",
		"id"=>$shortname."_video_widget_title",
		"std"=>"Video Widget",
		"type"=>"text"
		),
	array(  
		"name"=>"Video Widget Code",
		"id"=>$shortname."_video_widget_code",
		"std"=>'<iframe src="http://player.vimeo.com/video/9173975?title=0&amp;byline=0&amp;portrait=0" width="261" height="195" frameborder="0" webkitAllowFullScreen allowFullScreen></iframe>',
		"type"=>"textarea"
		),
	array(  
		"name"=>"Show Archives",
		"id"=>$shortname."_show_archives",
		"std"=>"enable",
		"type"=>"select",
		"options"=>array('enable', 'disable')
		),
	array(  
		"name"=>"Archives Title",
		"id"=>$shortname."_archives_title",
		"std"=>"Archives",
		"type"=>"text"
		),
	array(  
		"name"=>"Show Links",
		"id"=>$shortname."_show_links",
		"std"=>"enable",
		"type"=>"select",
		"options"=>array('enable', 'disable')
		),
	array(  
		"name"=>"Links Title",
		"id"=>$shortname."_links_title",
		"std"=>"Links",
		"type"=>"text"
		),
	array("type"=>"close"),
	/** END Sidebar Settings **/

);

function mytheme_add_admin() {
    global $themename, $shortname, $options;
    if ( $_GET['page'] == basename(__FILE__) ) {
		if ( 'save' == $_REQUEST['action'] ) {
			foreach ($options as $value) if ($value['type']!='header') update_option( $value['id'], $_REQUEST[ $value['id'] ] );
			foreach ($options as $value) {
			if( isset( $_REQUEST[ $value['id'] ] ) ) { update_option( $value['id'], $_REQUEST[ $value['id'] ]  ); } else { delete_option( $value['id'] ); } }
			header("Location: themes.php?page=settings.php&saved=true");
			die;
		} else if( 'reset' == $_REQUEST['action'] ) {
			foreach ($options as $value) delete_option( $value['id'] );
			header("Location: themes.php?page=settings.php&reset=true");
			die;
		}
    }
	add_theme_page($themename." Settings", "Theme Options", 'edit_themes', basename(__FILE__), 'mytheme_admin');
}

function mytheme_admin() {

    global $themename, $shortname, $options;

    if ($_REQUEST['saved']) echo '<div id="message" class="updated fade"><p><strong>'.$themename.' settings saved.</strong></p></div>';
    if ($_REQUEST['reset']) echo '<div id="message" class="updated fade"><p><strong>'.$themename.' settings reset.</strong></p></div>';
    
    ?>

	<link rel="stylesheet" type="text/css" href="<?php bloginfo('template_url'); ?>/admin/style.css" />
	<link rel="stylesheet" type="text/css" href="<?php bloginfo('template_url'); ?>/admin/fu/fileuploader.css">
	<script type="text/javascript">var tplURL = '<?php bloginfo('template_url'); ?>';</script>
	<script src="<?php bloginfo('template_url'); ?>/admin/fu/fileuploader.js" type="text/javascript"></script>
	<script src="<?php bloginfo('template_url'); ?>/js/jquery-1.6.1.min.js" type="text/javascript"></script>
	<script type="text/javascript" src="<?php bloginfo('template_url'); ?>/admin/main.js"></script>
	
	<form method="post">
	
	<!-- BEGIN wrapper -->
	<div id="to_wrapper"><div class="b1"><div class="b2">
	
	<div id="to_header">
		<h2><?php echo $themename; ?></h2>
	</div>
	
	<!-- BEGIN sidebar -->
	<div id="to_sidebar">
	<ul>
	<?php 
	foreach ($options as $value): 
	if ($value['type']=='open'):
		?><li><a class="<?php echo $value['id']; ?>" href="#"><?php echo $value['name']; ?></a></li><?php 
	endif;
	endforeach;
	?>
	</ul>
	</div>
	<!-- END sidebar -->
	
	<!-- BEGIN content -->
	<div id="to_content">
		
		<?php foreach ($options as $value) { 
			if ($value['type']=="open") { 
				$first = true;
				?><div id="<?php echo $value['id']; ?>" class="itemset">
			<?php } elseif ($value['type'] == "text") { ?>
			
				<h3<?php if ($first) { $first=false; echo ' class="f"'; } ?>><?php echo $value['name']; ?></h3>
				<div class="field">
					<input name="<?php echo $value['id']; ?>" class="text<?php if ($value['upload']) echo ' logo-input'; ?>" id="<?php echo $value['id']; ?>" type="<?php echo $value['type']; ?>" value="<?php if ( get_settings( $value['id'] ) != "") { echo get_settings($value['id']); } else { echo $value['std']; } ?>" />
				<?php 
				if ($value['upload']) {
					?>
					<div class="upload-button" id="logo"></div>
					<a href class="upload-remove" id="logo-remove">Remove</a>
					<div id="reminder">REMINDER: You have to click "Save Changes" below for this change to take effect.</div>
					<div id="logo-preview"></div>
					<?php
				}
				?>
				</div>
				<div class="note">
					<?php echo $value['note']; ?>
				</div>
			<?php } elseif ($value['type'] == "textarea") { ?>
				<h3<?php if ($first) { $first=false; echo ' class="f"'; } ?>><?php echo $value['name']; ?></h3>
				<div class="field">
					<textarea name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>"><?php if ( get_settings( $value['id'] ) != "") { echo htmlentities(stripslashes(get_settings( $value['id'] ))); } else { echo stripslashes($value['std']); } ?></textarea>
				</div>
				<div class="note">
					<?php echo $value['note']; ?>
				</div>
			<?php } elseif ($value['type'] == "select") { ?>
				<h3<?php if ($first) { $first=false; echo ' class="f"'; } ?>><?php echo $value['name']; ?></h3>
				<div class="field">
					<select name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>">
					<?php foreach ($value['options'] as $option) { ?>
						<option value="<?php echo $option; ?>" <?php if ( get_settings( $value['id'] ) == $option) { echo ' selected="selected"'; } elseif ($option == $value['std']) { echo ' selected="selected"'; } ?>><?php echo $option; ?></option>
					<?php } ?>
					</select>
				</div>
				<div class="note">
					<?php echo $value['note']; ?>
				</div>
			<?php 
			} elseif ($value['type']=='close') { ?>
				</div>
			<?php }
		}
		?>
		
	</div>
	<!-- END content -->
	
	<div id="to_footer">
		<p class="submit">
		<input id="save" name="save" type="submit" value="Save changes" />    
		<input type="hidden" name="action" value="save" />
		</p>
	</div>
	
	</div></div></div>
	<!-- END wrapper -->
	
	</form>

<?php
}

add_action('admin_menu', 'mytheme_add_admin');

foreach ($options as $value)
	if (get_settings($value['id'])===FALSE)
		$settings[$value['id']]=stripslashes($value['std']); 
	else 
		$settings[$value['id']]=stripslashes(get_settings($value['id']));
	
?>
