/* manyou_dialog version: 090224-03*/

/**
 *  @provides manyou_dialog
 *  @author luanluan
 *  @sample
 *  	实例化
 *  	var dlg = new manyou_dialog();
 *  	设置点击黑幕时是否关闭dialog -- true|false
 *  	dlg.enableCloseByOverlay(false);
 *       设置是否显示关闭等按钮
 *	dlg.enableShowButton(false);
 *  	设置宽度 默认500px -- auto|%|px
 *  	dlg.setWidth('600px');
 *  	设置高度 默认auto -- auto|%|px 
 *		如果设置的是 'auto' 会根据内容自适应高度
 *  	dlg.setHeight('50%');
 *	设置内容区域背景色 -- String( 'blue' | '#fff' | 'rgb(200,100,100)')
 *	dlg.setBGColor('#ff0000');
 *	设置边框的颜色和透明度 -- String( 'blue' | '#fff' | 'rgb(200,100,100)' ), int (0~1)
 *	lg.setBorderColor('red', 0.5);
 *	设置背景遮罩的颜色和透明度
 *	dlg.setOverlayColor('green', 0.1);
 *  	设置内容
 *  	dlg.setContent(testdata);
 *	重新设置窗口内容, 各种属性保持不变	
 *	dlg.resetContent('new content').setHeight('auto')
 *	通过页面上dom元素的id设置内容
 *	dlg.setContentElement('domID')
 *	重建窗口, 且所有属性归于默认
 *	dlg.reBuilt()
 *  	自定义显示时的事件
 *  	dlg.onShow = onDlgShow;
 *  	自定义关闭时的事件
 *  	dlg.onHide = onDlgHide;
 *  	显示
 *  	dlg.show();
 *  	关闭
 *  	dlg.hide();
 *	取得全局引用
 *	var myDlg = dlg.getRef()
 */manyou_dialog = function(id){this._init(id);};
_manyou_dialog_instance = null;
_manyou_dialog_loaditv = null;
_manyou_dialog_ua = navigator.userAgent.toLowerCase();
_manyou_dialog_conf =
{
		b_version: (_manyou_dialog_ua.match( /.+(?:rv|it|ra|ie)[\/: ]([\d.]+)/ ) || [])[1],
		b_msie: /msie/.test(_manyou_dialog_ua) && !/opera/.test(_manyou_dialog_ua),
		b_webkit: /webkit/.test(_manyou_dialog_ua),
		b_opera: /opera/.test(_manyou_dialog_ua),
		dialogID: 'manyou_dialog_obj_',
		overlayID: 'manyou_dialog_overlay_',
		containerID: 'manyou_dialog_container_',
		wrapperID: 'manyou_dialog_wrapper_',
		canvasID: 'manyou_dialog_canvas_',
		loaderID: 'manyou_dialog_loader_dom',
		label_close: '[x]',
		msg_invalid_meas: '\u53ea\u80fd\u4ee5px|auto|%\u6307\u5b9a\u5c3a\u5bf8',
		borderCls: 'manyou_dialog_lr_cls',
		default_w: '500px',
		default_h: 'auto',
		re_unit: /^\d+(px|pt|em|ex|in|cm|mm|pc)$/,
		re_perc: /^\d+%$/,
		css1Compat: (document.compatMode == "CSS1Compat")
};
manyou_dialog.warn = function(msg)
{
	if(typeof console!='undefined') console.warn(msg);
};
manyou_dialog.prototype =
{
	_$: function(x){return document.getElementById(x);},
	_$t: function(x){return document.getElementsByTagName(x);},
	_$c: function(x){return document.createElement(x);},
	getRef: function() {return _manyou_dialog_instance;},
	show: function(handler) {this._create(handler);return this;},
	hide: function(handler) {this._destroy(handler);return this;},
	reBuilt: function()	{this.hide();return (new manyou_dialog());},
	enableCloseByOverlay: function(bool) {this.closebyoverlay = bool;return this;},
	enableShowButton: function(bool) {this.showButton = bool;return this;},
	setWidth: function(x)
	{
		if (this._isValidSize(x)) {
			if (this._isAutoSize(x)) {
				this._width = _manyou_dialog_conf.default_w;
				return this;
			}
			this._width = x;
		}
		else {
			manyou_dialog.warn(_manyou_dialog_conf.msg_invalid_meas);
		}
		return this;
	},
	setHeight: function(x) {
		if (this._isValidSize(x)) {
			this._height = x;
		}
		else {
			manyou_dialog.warn(_manyou_dialog_conf.msg_invalid_meas);
		}
		return this;
	},
	setContent: function(x)
	{
		if (this.container) {
			var $tmp = this._$c('div');
			this._$t('body')[0].appendChild($tmp);
			$tmp.id = _manyou_dialog_conf.loaderID;
			$tmp.style.visibility = 'hidden';
			$tmp.style.position = 'absolute';
			$tmp.style.top = '-10000px';
			$tmp.style.left = '-10000px';
			$tmp.style.zIndex = '7776';
			$tmp.innerHTML = x + '<span id="manyou_dialog_tmpContentLoaded_dom" style="display:none"></span>';
			_manyou_dialog_loaditv = window.setInterval(function(){
				if(document.getElementById('manyou_dialog_tmpContentLoaded_dom')) {
					window.clearInterval(_manyou_dialog_loaditv);
					_manyou_dialog_instance._setContent(x+'');
				}
			},20);
		} else {
			window.setTimeout(function() {
				if (_manyou_dialog_instance) {
					_manyou_dialog_instance.setContent(x+'');
				}
			}, 20);
		}
		return this;
	},
	resetContent: function(content)
	{
		var oldDlg = this;
		var newDlg = new manyou_dialog();
		with (newDlg) {
			enableCloseByOverlay(this.closebyoverlay);
			enableShowButton(this.showButton);
			setWidth(this._width);
			setHeight(this._height);
			setBGColor(this.bgColor);
			setBorderColor(this.borderColor, this.borderOpacity);
			setOverlayColor(this.overlayColor, this.overlayOpacity);
			onShow = this.onShow;
			onHide = this.onHide;
		}
		oldDlg._destroy();
		newDlg.setContent(content);
		newDlg.show();
		return newDlg;
	},
	setContentElement: function(id)
	{
		var obj = this._$(id);
		if (!obj) {
			manyou_dialog.warn("Error: can't find element " + id);
			this._distroy();
			return false;
		}
		this.tempElemSrc = obj.outerHTML;
		this.tempElemLoc = obj.parentNode;		var src = this.tempElemSrc;
		var re = /^\s*<([a-zA-Z1-6\-]+)\s[^>]*style\s*\=\s*\"[^>]*([DISPLAY|display|Display]\s*:\s*none\s*;?)/;
		var mth = src.match(re,'img');		
		if (mth!=null) {
			src = src.replace(mth[2],'display:;');
		}		
		this.setContent(src);
		obj.parentNode.removeChild(obj);
		return this;
	},
	setBGColor: function(color)
	{
		this.bgColor = color;
		return this;
	},
	setBorderColor: function(color, opacity)
	{
		this.borderColor  = color;
		this.borderOpacity = opacity;
		return this;
	},
	setOverlayColor: function(color, opacity)
	{
		this.overlayColor  = color;
		this.overlayOpacity = opacity;
		return this;
	},
	_init: function(id)
	{
		this.version = '0.0.1';
		this.uniqueID = id||Math.ceil(Math.random()*999);
		this._width = _manyou_dialog_conf.default_w;
		this._height = _manyou_dialog_conf.default_h;
		this._opacity = _manyou_dialog_conf.default_o;
		this.iframe = null;
		this.overlay = null;
		this.dialog = null;
		this.container = null;
		this.canvas = null;
		this.evts = [];
		this.closebyoverlay = false;
		this.showButton = true;
		this.onShow = null;
		this.onHide = null;
		this.bgColor = '#fff';
		this.borderColor  = '#003366';
		this.borderOpacity = 0.618;
		this.overlayColor  = '#000';
		this.overlayOpacity = 0.618;
		this.heightTimer = null;
		this.tempElemSrc = null;
		this.tempElemLoc = null;
		_manyou_dialog_instance = this;
	},
	_create: function()
	{
		this._buildOverlay();
		this._buildDialog();		if (typeof(this.onShow) == 'function') {
			this.onShow();
		}
	},
	_destroy: function()
	{
		try {
			if (window.detachEvent) {
				if (_manyou_dialog_conf.b_msie&&_manyou_dialog_conf.b_version<7) {
					window.detachEvent('onresize', this.evts['fixWFunc']);
					window.detachEvent('onresize', this.evts['fixHFunc']);
					window.detachEvent('onscroll', this.evts['fixWFunc']);
					window.detachEvent('onscroll', this.evts['fixHFunc']);
				}
				window.detachEvent('onresize', this.evts['keepCFunc']);
				window.detachEvent('onscroll', this.evts['keepCFunc']);
			}
			if (window.removeEventListener) {
				window.removeEventListener('resize', this.evts['keepCFunc'], false);
				window.removeEventListener('scroll', this.evts['keepCFunc'], false);
			}
			window.clearInterval(this.heightTimer);
			this._$t('body')[0].removeChild(this.overlay);
			this._$t('body')[0].removeChild(this.dialog);
			if (this.tempElemSrc != null && this.tempElemLoc != null) {
				this.tempElemLoc.innerHTML = this.tempElemLoc.innerHTML + this.tempElemSrc;
			}
			this.evts = [];
			this.iframe = null;
			this.overlay = null;
			this.dialog = null;
			this.container = null;		} catch(ex) {}		if ( typeof(this.onHide) == 'function') {
			this.onHide();
		}
	},
	_setVisible: function(bool)
	{
		if (!this.dialog) return;		var $wrapper = this._$(_manyou_dialog_conf.wrapperID + this.uniqueID);		if (bool && $wrapper) {
			this.dialog.style.visibility = "visible";
		} else {
			this.dialog.style.visibility = "hidden";
		}
	},
	_buildDialog: function()
	{
		var id = _manyou_dialog_conf.dialogID + this.uniqueID;
		var $dialog = this._$(id);
		if ($dialog) return;
		var $root = this._$t('body')[0];		$dialog = this._$c('div');
		$root.appendChild($dialog);
		this.dialog = $dialog;
		$dialog.id = id;
		$dialog.innerHTML = '';
		this._setVisible(false);
		var sty1 = 'border:0;margin:0;padding:0;clear:both;overflow:hidden;left:0;top:0;position:fixed;left:0;top:0;z-index:7778;width:'+this._width;
		this._fillStyles(id, sty1);		var $borderT = this._$c('div');
		$dialog.appendChild($borderT);
		var sty_tb = 'background:'+this.borderColor+';opacity:'+this.borderOpacity+';font-size:1px;line-height:1px;height:6px;';
		this._fillStyles($borderT, sty_tb);		var $bCanves = this._$c('div');
		$dialog.appendChild($bCanves);
		this.canvas = $bCanves;
		$bCanves.id = _manyou_dialog_conf.canvasID + this.uniqueID;
		var sty_cvs = 'margin:0;clear:both;overflow:hidden;';
		if (this._height && this._height!='auto' && this._height!='' && this._height.indexOf('%')==-1) {
			sty_cvs += 'height:' + (parseInt(this._height.replace('px',''))-6*2) + 'px;';
		}
		this._fillStyles($bCanves, sty_cvs);		var $borderL = this._$c('div');
		$bCanves.appendChild($borderL);
		$borderL.innerHTML = '&nbsp;';
		$borderL.id = _manyou_dialog_conf.borderCls+'L';
		var sty_lr = 'background:'+this.borderColor+';opacity:'+this.borderOpacity+';font-size:1px;line-height:1px;width:6px;display:inline;';
		this._fillStyles($borderL, sty_lr+'float:left;');		var $body = this._$c('div');
		$bCanves.appendChild($body);
		var sty2 = 'margin:0;/*margin-top:1px;margin-left:1px;*/padding:0;background-color:'+ this.bgColor +';float:left:display:inline;';		this._fillStyles($body, sty2);			var $container = this._$c('div');
			$body.appendChild($container);
			this.container = $container;
			$container.id = _manyou_dialog_conf.containerID + this.uniqueID;
			var sty5 = 'padding:0;font-size:12px;overflow:hidden;clear:both;';
			this._fillStyles($container, sty5);				if (this.showButton) {					var $closed = this._$c('div');
					$container.appendChild($closed);
					var sty3 = 'height:25px;margin:0;padding:0;clear:both;width:99%;/*position:relative;*/';
					this._fillStyles($closed, sty3);					var $closea = this._$c('a');
					$closed.appendChild($closea);
					$closea.href = 'javascript:void(0)';
					$closea.onclick = function(){_manyou_dialog_instance.hide();};
					var sty4 = 'font-size:12px !important;text-decoration:none;font-size:14px;font-family:Arial;line-height:20px;width:15px;height:20px;font-weight:normal;color:#1D548B;float:right;display:block;/*position:absolute;right:0;*/padding:0;margin:0;margin-right:5px;margin-top:2px;';
					$closea.innerHTML = _manyou_dialog_conf.label_close;
					this._fillStyles($closea, sty4);				}		var $borderR = this._$c('div');
		$bCanves.appendChild($borderR);
		$borderR.innerHTML = '&nbsp;';
		$borderR.id = _manyou_dialog_conf.borderCls+'R';
		this._fillStyles($borderR, sty_lr+'float:right;');		var $borderB = this._$c('div');
		$dialog.appendChild($borderB);
		this._fillStyles($borderB, sty_tb);		this._keepCenter($dialog);
		this.evts['keepCFunc'] = function(){if(_manyou_dialog_instance) _manyou_dialog_instance._keepCenter(_manyou_dialog_instance.dialog);};
		if (window.attachEvent) {
			window.attachEvent('onresize', this.evts['keepCFunc']);
			window.attachEvent('onscroll', this.evts['keepCFunc']);		} else if (window.addEventListener) {
			window.addEventListener('resize', this.evts['keepCFunc'], false);
			window.addEventListener('scroll', this.evts['keepCFunc'], false);
		}		$closea = null;
		$closed = null;
		$body = null;
		$dialog=null;
		$root = null;
	},
	_buildOverlay: function()
	{
		var id = _manyou_dialog_conf.overlayID + this.uniqueID;
		var $overlay = this._$(id);
		if ($overlay) return;
		var $root = this._$t('body')[0];
		$overlay = this._$c('div');
		$root.appendChild($overlay);
		this.overlay = $overlay;
		$overlay.id = id;
		$overlay.innerHTML = '';
		var sty1 = 'margin:0;padding:0;position:fixed;left:0;top:0;width:100%;height:100%;background:'+this.overlayColor+';overflow:hidden;opacity:'+this.overlayOpacity+';z-index:7777;';
		this._fillStyles(id, sty1);
		var fid = id + '_ifm';
		var $fix = this._$c('iframe');
		$overlay.appendChild($fix);
		$fix.style.visibility = 'hidden';
		this.iframe = $fix;		$fix.src = 'javascript:void(0)';		if (this.closebyoverlay) {
			var closeFunc = function(){_manyou_dialog_instance.hide()};
			if (_manyou_dialog_conf.b_msie) {
				$fix.onfocus = closeFunc;
			} else if (_manyou_dialog_conf.b_webkit) {
				$fix.src = 'javascript:document.write("<a style=cursor:default href=javascript:parent._manyou_dialog_instance.hide()><div style=position:fixed;width:100%;height:100%;></div></a>")';
			} else {
				$fix.contentWindow.onclick = closeFunc;
			}
		}		var sty2 = 'visibility:visible;margin:0;width:100%;height:100%;border:0;opacity:0.01;';
		var att2 = 'id='+fid+',frameborder=no,scrolling=no';
		this._fillAttrs($fix, att2);
		this._fillStyles(fid, sty2);
		$overlay = null;
		$fix = null;
		$root = null;
	},
	_fillStyles: function(obj, stys)
	{		if (typeof obj == 'string') obj = this._$(obj);
		var sArr = stys.replace(/\/\*.+\*\//g, '').split(';');
		var ie6 = _manyou_dialog_conf.b_msie&&_manyou_dialog_conf.b_version<7;
		for (var i=0;i<sArr.length;i++)
		{
			var it = sArr[i].split(':');
			var k = this._processStyleKey(it[0].replace(/\s/g,'')), v = it[1];
			switch(k)
			{
				case 'opacity':
					obj.style.filter = 'alpha(opacity='+v*100+')';
					obj.style['-moz-opacity'] = v+'';
				break;
				case 'position':
					if (ie6&&v=='fixed') {
						v='absolute';
						this.fixed = true;
					}
				break;
				case 'width':
					if (this._shouldST(ie6,obj.id))
					{
						var id = obj.id + '';
						var vlu = v + '';
						this._fixW(id, vlu);
						if (v.indexOf('%')>-1) {
							this.evts['fixWFunc'] = function(){if(_manyou_dialog_instance) _manyou_dialog_instance._fixW(id,vlu);};
							window.attachEvent('onresize', _manyou_dialog_instance.evts['fixWFunc']);
							window.attachEvent('onscroll', _manyou_dialog_instance.evts['fixWFunc']);
						}
						continue;
					}
				break;
				case 'height':
					if (this._shouldST(ie6,obj.id))
					{
						var id = obj.id + '';
						var vlu = v + '';
						this._fixH(id, vlu);
						if (v.indexOf('%')>-1) {
							this.evts['fixHFunc'] = function(){if(_manyou_dialog_instance) _manyou_dialog_instance._fixH(id,vlu);};
							window.attachEvent('onresize', _manyou_dialog_instance.evts['fixHFunc']);
							window.attachEvent('onscroll', _manyou_dialog_instance.evts['fixHFunc']);
						}
						continue;
					}
				break;
				case 'float':
					obj.style.styleFloat = v+'';
					obj.style.cssFloat = v+'';
					continue;
				break;
			} //end of switch
			try{
				obj.style[k]=v+'';
			}catch(ex){}
		}
		obj = null;	},
	_fillAttrs: function(obj, attrs)
	{
		if (typeof obj == 'string') obj = this._$(obj);
		var aArr = attrs.split(',');
		for (var i=0;i<aArr.length;i++)
		{
			var it = aArr[i].split('=');
			obj.setAttribute(it[0].replace(/\s/g,''),it[1]);
		}
		obj = null;
	},
	_shouldST: function(ie6,id)
	{
		return ie6&&(this.fixed==true)&&id&&(new RegExp('^'+_manyou_dialog_conf.dialogID+'|^'+_manyou_dialog_conf.overlayID).test(id));
	},
	_fixW: function(id, v)
	{
		var obj = document.getElementById(id);
		if(!obj) return;
		v = v.replace('px','');
		var vlu = v.indexOf('%')>-1
			?( Math.min(document.documentElement.scrollWidth,document.documentElement.clientWidth)*parseInt(v.replace('%',''))/100 )
			:v;
		obj.style.left = document.documentElement.scrollLeft;
		try {
			obj.style.width = vlu+'px';
		} catch(ex){}
	},
	_fixH: function(id, v)
	{
		var obj = document.getElementById(id);
		if(!obj) return;
		v = v.replace('px','');
		var vlu = v.indexOf('%')>-1
			?( Math.min(document.documentElement.scrollHeight,document.documentElement.clientHeight)*parseInt(v.replace('%',''))/100 )
			:v;
		obj.style.top = document.documentElement.scrollTop;
		try {
			obj.style.height = vlu+'px';
		} catch(ex){}
	},
	_keepCenter: function(obj)
	{
		if (!obj || !_manyou_dialog_instance) return;
		window.setTimeout(function(){
			var ie6 = _manyou_dialog_conf.b_msie&&_manyou_dialog_conf.b_version<7;
			var $base = _manyou_dialog_instance.overlay;
			var winW = Math.min($base.scrollWidth, $base.clientWidth);
			if (_manyou_dialog_conf.b_opera) {
				winW = $base.clientWidth;
			}
			var divW = obj.clientWidth;
			try{
				var vl = (0.5*(winW-divW) + parseInt(ie6?document.documentElement.scrollLeft:0));
				vl = vl<0?0:vl;
				obj.style.left = vl + 'px';
			}catch(ex){}
			var winH = Math.min($base.scrollHeight, $base.clientHeight);
			var divH = obj.clientHeight;
			try{
				var vt = (0.5*(winH-divH) + parseInt(ie6?document.documentElement.scrollTop:0));
				vt = vt<0?0:vt;
				obj.style.top = vt + 'px';
			}catch(ex){}			var $cav = document.getElementById(_manyou_dialog_conf.canvasID+_manyou_dialog_instance.uniqueID);
			document.getElementById(_manyou_dialog_conf.borderCls+'L').style.height = $cav.clientHeight + 'px';
			document.getElementById(_manyou_dialog_conf.borderCls+'R').style.height = $cav.clientHeight + 'px';			$base = null;
			$cav = null;
		}, 10);
	},
	_processStyleKey: function(propKey)
	{
		if (/-/.test(propKey)) {
			var mArr = propKey.match(/-(.)/g);
			var uArr = [];
			for (var ii=0; ii<mArr.length; ii++) {
				uArr.push(mArr[ii].replace("-","").toUpperCase());
				propKey = propKey.replace(mArr[ii], "###");
			}
			var sArr = propKey.split("###");
			for (var jj=1; jj<sArr.length; jj++) {
				sArr[jj] = uArr[jj-1] + sArr[jj];
			}
			propKey = sArr.join('') + "";
			delete mArr;
			delete uArr;
		}
		return propKey;
	},
	_isValidSize: function(s)
	{		return /^(\d+(px|%)|auto)$/.test(s);
	},
	_isAutoSize: function(s)
	{
		return /^(auto)?$/.test(s);
	},
	_getSizeUnit: function(s)
	{
		var l = s.length;
		return s.substring(l-2,l);
	},
	_setContent: function(x)
	{		var $tmp = document.getElementById(_manyou_dialog_conf.loaderID);
		var $wrapper = this._$c('div');
		this.container.appendChild($wrapper);	
		$wrapper.id = _manyou_dialog_conf.wrapperID + this.uniqueID;
		var $base = this.overlay;
		var winW = Math.min($base.scrollWidth, $base.clientWidth);
		if (_manyou_dialog_conf.b_opera) {
			winW = $base.clientWidth;
		}
		var winH = Math.min($base.scrollHeight, $base.clientHeight);
		var sty = 'overflow:auto;margin:0;margin-left:0;margin-right:0;padding:0;text-align:left;';
		var wrapW = 0, wrapH = 0;		sty += 'width:';
		if ( _manyou_dialog_conf.re_unit.test(this._width) ) {
			wrapW = this._width.replace('px','')*1;
			var baseW = Math.min(winW, wrapW);
			wrapW = (baseW - 2 - 5*2) + 'px';
		} else if ( _manyou_dialog_conf.re_perc.test(this._width) ) {
			var percW = this._width.replace('%','');
			percW = percW>100?100:percW;
			percW /= 100;
			wrapW = ( Math.floor(percW*winW) - 5*2 - 2) + 'px';
		}		sty += wrapW + ';height:';
		var closeH = this.container.getElementsByTagName('div')[0].style.height.replace('px','')*1;
		var restH = 5*2 + closeH + 10;
		if ( this._isAutoSize(this._height)) {
			var baseH = 0;
			if ($tmp.clientHeight > winH) {
				baseH = winH;
			} else {
				baseH = _manyou_dialog_conf.default_h;
			}
			wrapH = (baseH - restH) + 'px';			this.heightTimer = window.setInterval(function(){
				if (_manyou_dialog_instance.container) {
					var containerH = _manyou_dialog_instance.container.clientHeight;
					var canvasH = _manyou_dialog_instance.canvas.clientHeight;					if (_manyou_dialog_conf.b_msie && containerH != canvasH) {
						_manyou_dialog_instance.container.parentNode.style.height = (containerH) + 'px';
						_manyou_dialog_instance.canvas.style.height = (containerH) + 'px';
						_manyou_dialog_instance._keepCenter(_manyou_dialog_instance.dialog);
					}					if (!_manyou_dialog_conf.b_msie) {
						var $l = _manyou_dialog_instance._$(_manyou_dialog_conf.borderCls+"L");
						var $r = _manyou_dialog_instance._$(_manyou_dialog_conf.borderCls+"R");
						var bh = $l.clientHeight;
						if (bh != containerH) {
							$l.style.height = (containerH) + 'px';
							$r.style.height = (containerH) + 'px';
							_manyou_dialog_instance._keepCenter(_manyou_dialog_instance.dialog);
						}
					}										containerH = null;
					delete containerH;
					canvasH = null;
					delete canvasH;
				}
			},200);		}
		if ( _manyou_dialog_conf.re_unit.test(this._height) ) {
			wrapH = this._height.replace('px','')*1;
			var baseH = Math.min(winH, wrapH);
			wrapH = (baseH - restH) + 'px';
		}
		if ( _manyou_dialog_conf.re_perc.test(this._height) ) {
			var percH = this._height.replace('%','');
			percH = percH>100?100:percH;
			percH /= 100;
			wrapH = ( Math.floor(percH*winH) - restH) + 'px';
		}		sty += wrapH;
		this._fillStyles($wrapper, sty);		$wrapper.innerHTML = x;		var wrapWNum = wrapW.replace('px','')*1;
		this.container.style.width = wrapWNum + 'px';
		this.dialog.style.width = (wrapWNum + 10 + 2) + 'px';		try{
			this.canvas.style.height = (wrapH.replace('px','')*1+ restH - 10)+'px';
		}catch(ex){
			this.canvas.style.height = ($wrapper.clientHeight + restH - 10)+'px';
		}
		this.canvas.getElementsByTagName('div')[1].style.height = this.canvas.style.height;		this._$t('body')[0].removeChild($tmp);
		$tmp = null;
		$wrapper = null;
		$base = null;
		this._keepCenter(this.dialog);		window.setTimeout(function(){
			_manyou_dialog_instance._setVisible(true);
		},233);
	}
};if (window.HTMLElement) {
    HTMLElement.prototype.__defineSetter__("outerHTML",function(sHTML){
        var r=this.ownerDocument.createRange();
        r.setStartBefore(this);
        var df=r.createContextualFragment(sHTML);
        this.parentNode.replaceChild(df,this);
        return sHTML;
    });
    HTMLElement.prototype.__defineGetter__("outerHTML",function(){
		var attr;
        var attrs=this.attributes;
        var str="<"+this.tagName.toLowerCase();
        for(var i=0;i<attrs.length;i++){
            attr=attrs[i];
            if(attr.specified)
                str+=" "+attr.name+'="'+attr.value+'"';
            }
        if(!this.canHaveChildren)
            return str+" />";
        return str+">"+this.innerHTML+"</"+this.tagName.toLowerCase()+">";
    });
	HTMLElement.prototype.__defineGetter__("canHaveChildren",function(){
		switch(this.tagName.toLowerCase()){
            case "area":
            case "base":
         	case "basefont":
            case "col":
            case "frame":
            case "hr":
            case "img":
            case "br":
            case "input":
            case "isindex":
            case "link":
            case "meta":
            case "param":
            return false;
        }
        return true;
	});
}