<?php
if(!defined('CORE_ROOT')) exit();
require CORE_ROOT.'include/admin.inc.php';
require CORE_ROOT.'include/install.func.php';
if(isset($_GET['action']) && $_GET['action'] == 'reinstall') {
	createconfig(array('charset' => 'gbk'));
	downloadtheme($get_theme);
	createakcmstables($dbname);
	installinitialdata();
	clearfiles();
	akheader('location:index.php?file=theme');
}
if(!file_exists(AK_ROOT.'install/custom.config.php')) {
	akheader('location:index.php?new=1');
}
require_once(AK_ROOT.'install/custom.config.php');

if(empty($_GET['action'])) {
	$template_path = $themekey;
	createconfig(array('template_path' => $themekey));
	ak_copy(AK_ROOT.'install/trunk', FORE_ROOT);
	ak_copy(AK_ROOT.'install/templates', AK_ROOT.'configs/templates/'.$themekey);
	ak_copy(AK_ROOT.'install/systemplates', AK_ROOT.'configs/templates');
	ak_copy(AK_ROOT.'install/configs', AK_ROOT.'configs');
	if(file_exists(AK_ROOT.'install/apps')) ak_copy(AK_ROOT.'install/apps', AK_ROOT.'apps');
	$dbsize = filesize(AK_ROOT.'install/db/db.ak');
	setcache('_themedbsize', $dbsize);
	setcache('_themedboffset', 0);
	setcache('_themedbbatch', 0);
	deletecache('categoryselect');
	header('location:index.php?file=theme&action=frame');
} elseif($get_action == 'frame') {
	showprocess($lan['importing'], 'index.php?file=theme&action=importdb', 'index.php?file=theme&action=finish', 100, array($lan['finished']));
} elseif($get_action == 'importdb') {
	$dbsize = getcache('_themedbsize');
	$dboffset = getcache('_themedboffset');
	$dbbatch = getcache('_themedbbatch');
	$fp = fopen(AK_ROOT.'install/db/db.ak', 'r');
	fseek($fp, $dboffset);
	while(!feof($fp)) {
		$row = fgets($fp, 1024000);
		$dboffset = ftell($fp);
		setcache('_themedboffset', $dboffset);
		if($row == '') continue;
		$value = unserialize(base64_decode($row));
		if(empty($value)) continue;
		if($value['table'] == 'categories' || $value['table'] == 'modules') {
			$db->replaceinto($value['table'], $value['value'], 'id');
		} elseif($value['table'] == 'settings') {
			$db->replaceinto('settings', $value['value'], 'variable');
		} else {
			$db->insert($value['table'], $value['value']);
		}
		
		if($dboffset >= $dbbatch) {
			if($dboffset >= $dbsize) break;
			setcache('_themedbbatch', $dbbatch + 10000);
			$percent = number_format($dboffset * 100/ $dbsize, 2);
			fclose($fp);
			aexit($percent."\t0\t".number_format($dboffset / 1024, 2).'KB');
		}
	}
	fclose($fp);
	setsetting('theme', $template_path);
	deletecache('_themedbbatch');
	deletecache('_themedboffset');
	updatecache();
	aexit('100');
} elseif($get_action == 'finish') {
	updatecache();
	if(file_exists(AK_ROOT.'install/install.php')) require_once(AK_ROOT.'install/install.php');
	finishtheme();
	setcache('installtemplate', 1);
	adminmsg($lan['importsuccess'], 'index.php?file=admincp&action=custom&new=1&theme='.$themekey);
}

function downloadtheme($theme) {
	$themefile = $theme.'.akp';
	$themepath = CORE_ROOT.'install/';
	$url = 'http://app.akcms.com/download.php?app='.$theme;
	$result = readfromurl($url);
	if($result == '') return false;
	if(!is_dir($themepath)) ak_mkdir($themepath);
	writetofile($result, $themepath.$themefile);
	if(!is_dir($themepath.$theme)) ak_mkdir($themepath.$theme);
	unzip($themepath.$themefile, $themepath);
	akunlink($themepath.$themefile);
}

function clearfiles() {
	akunlink(AK_ROOT.'configs/cphook.php');
	akunlink(AK_ROOT.'configs/forehook.php');
	akunlink(AK_ROOT.'configs/appmenu.php');
	akunlink(AK_ROOT.'configs/custom.menu.xml');
	ak_rmdir(AK_ROOT.'configs/apps/_dependhook/');
	ak_rmdir(AK_ROOT.'configs/hooks');
	ak_rmdir(AK_ROOT.'cache/');
	ak_rmdir(AK_ROOT.'configs/apps/');
	ak_rmdir(AK_ROOT.'configs/images');
	ak_rmdir(AK_ROOT.'configs/language');
	emptyfileindir(AK_ROOT.'configs/templates/ak/');
}
?>