<?php if(!defined('cfih') or !cfih or cfih!='admin') die('This file cannot be directly accessed.');
/**************************************************************************************************************
 *
 *   CF Image Hosting Script
 *   ---------------------------------
 *
 *   Author:    codefuture.co.uk
 *   Version:   1.6.5
 *
 *   You can download the latest version from: http://codefuture.co.uk/projects/imagehost/
 *
 *   Copyright (c) 2010-2013 CodeFuture.co.uk
 *   This file is part of the CF Image Hosting Script.
 *
 *   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 *   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 *   COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 *   WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
 *   OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 *
 *   You may not modify and/or remove any copyright notices or labels on the software on each
 *   page (unless full license is purchase) and in the header of each script source file.
 *
 *   You should have received a full copy of the LICENSE AGREEMENT along with
 *   Codefuture Image Hosting Script. If not, see http://codefuture.co.uk/projects/imagehost/license/.
 *
 *
 *   ABOUT THIS PAGE -----
 *   Used For:     Admin Bulk image uploader
 *   Last edited:  19/12/2012
 *
 *************************************************************************************************************/

// check for errors coming from other pages
	if(isset($_SESSION['err'])){
		$Err = $_SESSION['err'];
		unset($_SESSION['err']);
	}

// check for uploaded image to show
	if(isset($_SESSION['upload']) && isset($_SESSION['show_image'])){

		$countThumb	= 0; // count number of thumb's on page
		$thumbHtml	= ''; // hold thumbnail page html

	// image loop
		foreach($_SESSION['upload'] as $k=>$uploadimage){
			if(isset($uploadimage['id']))$img_id =$uploadimage['id'];
			//unset($_SESSION['upload'][$k]);

			if(isset($img_id) && preg_replace("/[^0-9A-Za-z]/","",$img_id) == $img_id){
			//see if image exists
				if ($image = db_get_image($img_id)){

				// Thumbnail page variables
					$thumb_link		= imageAddress(3,$image,'pt');
					$thumb_url		= imageAddress(3,$image,'dt');
					$thumb_mid_link	= imageAddress(2,$image,'pm');
					$thumb_mid_url	= imageAddress(2,$image,'dm');
					$imgurl			= imageAddress(1,$image,'di');
					$alt			= $image['alt'];
					$shorturl		= $image['shorturl'];
					$bookmarking	= bookmarking(($shorturl ==null?$thumb_mid_link:$shorturl),$alt);

				// make image links
					$links[$countThumb] = array(
										'thumb_bbcode'		=> imageLinkCode('bbcode',$thumb_url,$thumb_link),
										'thumb_html'		=> imageLinkCode('html',$thumb_url,$thumb_link,$alt),
										'thumb_mid_bbcode'	=> imageLinkCode('bbcode',$thumb_mid_url,$thumb_mid_link),
										'thumb_mid_html'	=> imageLinkCode('html',$thumb_mid_url,$thumb_mid_link,$alt),
										'image_bbcode'		=> imageLinkCode('bbcode',$imgurl),
										'image_direct'		=> $imgurl,
										'delete_url'		=> (isset($delete_id)?$settings['SET_SITEURL'].'?d='.$delete_id:'')
										);

				//image box
					$thumbHtml .= '<div class="ibox imgedit_img"><h2 class="boxtitle">'.$alt.'</h2><a href="'.imageAddress(1,$image).'" title="'.$alt.'" class="lightbox" ><img src="'.imageAddress(3,$image).'" alt="'.$alt.'" /></a>';
				//image links
					$thumbHtml .= '<div class="code_box">'.$bookmarking.'</div>';
				// end
					$thumbHtml .= '</div>';
				// links title
					$thumbHtml .= '<div class="ibox imgedit_form"><h2 class="boxtitle">'._T("site_index_hide_link").'</h2>';
				// Short URL
					if ($shorturl != null && !empty($shorturl))	$thumbHtml .= '
										<div class="code_box"><label for="shorturl">'._T("site_index_short_url_link").':</label> <input type="text" id="codehtml" value="'.$shorturl.'" onclick="javascript:this.focus();this.select();" readonly="true" class="text_input long" /></div>';

				// Image Links
					$thumbHtml .= '
							<h3>'._T("site_index_small_thumbnail_link").'</h3>
								<div class="code_box"><label for="codelbb">'._T("site_index_bbcode").':</label> <input type="text" id="codelbb" value="'.$links[$countThumb]['thumb_bbcode'].'" onclick="javascript:this.focus();this.select();" readonly="true" class="text_input long" /></div>
								<div class="code_box"><label for="codehtml"><a href="'.$thumb_link.'" title="'.$alt.'" >'._T("site_index_html_code").'</a> :</label> <input type="text" id="codehtml" value="'.$links[$countThumb]['thumb_html'].'" onclick="javascript:this.focus();this.select();" readonly="true" class="text_input long" /></div>
							<h3>'._T("site_index_thumbnail_link").'</h3>
								<div class="code_box"><label for="codelbb">'._T("site_index_bbcode").':</label> <input type="text" id="codelbb" value="'.$links[$countThumb]['thumb_mid_bbcode'].'" onclick="javascript:this.focus();this.select();" readonly="true" class="text_input long" /></div>
								<div class="code_box"><label for="codehtml"><a href="'.$thumb_mid_link.'" title="'.$alt.'" >'._T("site_index_html_code").'</a> :</label> <input type="text" id="codehtml" value="'.$links[$countThumb]['thumb_mid_html'].'" onclick="javascript:this.focus();this.select();" readonly="true" class="text_input long" /></div>
							<h3>'._T("site_index_image_link").'</h3>
							<div class="code_box"><label for="codebb">'._T("site_index_bbcode").':</label> <input type="text" id="codebb" value="'.$links[$countThumb]['image_bbcode'].'" onclick="javascript:this.focus();this.select();" readonly="true" class="text_input long" /></div>
							<div class="code_box"><label for="codedirect">'._T("site_index_direct_link").'</label> <input type="text" id="codedirect" value="'.$links[$countThumb]['image_direct'].'" onclick="javascript:this.focus();this.select();" readonly="true" class="text_input long" /></div>';

					$thumbHtml .= '</div>';
					$thumbHtml .= '<div style="clear: both;"></div>';
				}else{
					user_feedback('error',_T("site_index_thumbs_page_err"),'admin_bulkupload_thumbs');
				}
			}
			$countThumb++;
		}// end uploaded loop
	} // end show uploaded images

	if(isset($_SESSION['upload'])){
		user_feedback('success',_T('admin_bulk_upload_success',count($_SESSION['upload'])),'upload_images');
		unset($_SESSION['upload']);
		if(isset($_SESSION['show_image'])) unset($_SESSION['show_image']);
	}

// make image list to upload
	if(isset($_POST['bupload'])){
		if($handle = opendir(CFBULKUPLOADPATH)){
			$i = 0;
			while (false !== ($file = readdir($handle))){
				if ($file != "." && $file != ".."){
					$path = CFBULKUPLOADPATH.$file;
					if(is_file($path)){
						$info = pathinfo($path);
						if(in_array(strtolower($info['extension']),$imgFormats)){
							$_FILES['file']['tmp_name'][$i] = $path;
							$_FILES['file']['name'][$i] = $file;
							$_FILES['file']['size'][$i] = 0;
							$_FILES['file']['type'][$i] = '';
							$_FILES['file']['error'][$i] = null;
						//	$_POST['album_id'][$i] = (int)(isset($_POST['album_id'])?$_POST['album_id']:0);
							$i++;
						}
					}
				}
				if($i >= $bulk_upload_max) break;
			}
		}

		if ($i > 0){
		// upload images
			if(isset($_POST['show_image']) AND $_POST['show_image']) $_SESSION['show_image'] = true;
			$admin_upload = true;
			require('upload.php');
		}else{
			user_feedback('error',_T("admin_bulk_no_image_err",CFBULKUPLOADPATH),'admin_bulkupload_img_upload');
		}
	}


// page settings
	$page['id']				= 'bulkupload';
	$page['title']			= _T("admin_bulk_title");
	$page['description']	= '';
	$page['tipsy'] 			= true;
	$page['lightbox']		= isset($thumbHtml)?true:null;

	require CFADMINPATH.'admin_page_header.php';
?>
<!-- admin Bulk Upload -->
			<div class="ibox full">
				<h2><?php echo _T("admin_bulk_title");?></h2>
				<p><?php echo _T("admin_bulk_des",CFBULKUPLOADPATH,$bulk_upload_max);?></p>
				<p><?php echo _T("admin_bulk_list",CFBULKUPLOADPATH,$bulk_upload_max);?></p>
				<form method="POST" action="admin.php?act=bulk" id="bulk_form">
					<?php optionOnOff(_T("admin_bulk_list_show"),'show_image',0);?>
					<div class="code_box"><input class="button button_cen" onclick="" type="submit" value="<?php echo _T("admin_bulk_form_button");?>" name="bupload" /></div>
				</form>
			</div>
			<div class="clear"></div>
			<?php echo (isset($thumbHtml)?$thumbHtml:'');?>
		</div>
<?php
	require CFADMINPATH.'admin_page_footer.php';
	die();
	exit;

	function optionOnOff($label,$name,$setting,$info = null,$return=0){
		$html = '
		<div class="code_box"><label>'.$label.' :</label>
		<select name="'.$name.'" class="text_input">
			<option value="0" '.(!$setting?'selected="selected"':'').'>'._T("admin_set_option_off").'</option>
			<option value="1" '.($setting?'selected="selected"':'').'>'._T("admin_set_option_on").'</option>
		</select>'.(!is_null($info)?'<span>'.$info.'</span>':'').'</div>';
		if($return) return $html;
		echo $html;
	}