﻿<?php
/**************************************************************************************************************
 *
 *   CF Image Hosting Script
 *   ---------------------------------
 *
 *   Author:    codefuture.co.uk
 *   Version:   1.6.5
 *
 *   You can download the latest version from: http://codefuture.co.uk/projects/imagehost/
 *
 *   Copyright (c) 2010-2013 CodeFuture.co.uk
 *   This file is part of the CF Image Hosting Script.
 *
 *   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 *   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 *   COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 *   WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
 *   OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 *
 *   You may not modify and/or remove any copyright notices or labels on the software on each
 *   page (unless full license is purchase) and in the header of each script source file.
 *
 *   You should have received a full copy of the LICENSE AGREEMENT along with
 *   Codefuture Image Hosting Script. If not, see http://codefuture.co.uk/projects/imagehost/license/.
 *
 *
 *   ABOUT THIS PAGE -----
 *   Used For:     English translation
 *   Last edited:  19/12/12
 *
 *************************************************************************************************************
 *
 *   If you have translated this file into another
 *   language or have corrected typos, we would
 *   appreciate it if you would send us the
 *   translated file.
 *
 *************************************************************************************************************/

	$lang = array();
	$lang["site_charset"] = 'UTF-8';
	$lang["site_lang_code"] = 'cn';

/*****************************************************************************
 *
 * Admin Language
 *
 *****************************************************************************/

/*
 * Admin Sitewide
 */
	$lang["admin_footer_powered_by"]	= '技术支持';
	$lang["admin_footer_version"]		= '版本';

/*
 * config
 */
	$lang["admin_session_error"]	= '不能启动一个新的PHP会话，请联系服务器管理员或网络管理员!';
	$lang["error_500"]				= '500 内部服务器错误 - 您请求的页面的内部服务器错误.';
	$lang["error_404"]				= '404 找不到此页 - 您请求的网页或文件不存在.';
	$lang["error_403"]				= '403 禁止的动作 - 您没有权限访问该区域.';
	$lang["error_401"]				= '401 未授权的动作 - 您没有权限访问该区域.';
	$lang["error_400"]				= '400 错误的要求 - 您的浏览器发送了一个无法被此服务器识别的请求.';


/*
 * Login Page (log)
 */
 	$lang["admin_log_title"]	= '登录';
 	$lang["admin_log_out_suc"]	= '您已成功退出系统.';
	$lang["admin_log_err"]		= '您输入了错误的用户名或密码!';
	// forgot your password - send link
	$lang["admin_log_forgot_password_email_subject"]	= '密码重置链接';//SET_TITLE - Password Reset Link  (SET_TITLE is auto set)
	//{user_name} replace with the admin username
	//{reset_url} replace with a link to reset the admin password
	$lang["admin_log_forgot_password_email_body"]		= '
	<div style="width:700px; margin:0 auto;">
		你好, {user_name}<br/>
		不能记住您的密码，这种事是难免的. <br/><br/>
		请点击下面的链接或手动复制后粘贴到您的浏览器地址框: <br/>
		{reset_url}<br/><br/>

		这将重置你的密码，然后你登录并修改后一定要记住此密码. <br/>
		这是一个系统自动发送的信息，请不要回复!
	</div>';
	$lang["admin_log_forgot_password_suc"]			= '你已发送电子邮件...';
	$lang["admin_log_forgot_password_email_err"]	= '电子邮件地址是无效的!';
	$lang["admin_log_forgot_password_err"]			= '重置你的密码错误......';
	$lang["admin_log_forgot_password"]				= '忘记密码';
	$lang["admin_log_username"]						= '用户名称';
	$lang["admin_log_password"]						= '用户密码';
	$lang["admin_log_remember_me"]					= '记住我的登录状态';
	$lang["admin_log_button"]						= '登录';
	$lang["admin_log_your_email"]					= '你的电子邮件';
	$lang["admin_log_button_submit"]				= '提交';
 	$lang["admin_log_forgot_password_title"]		= '重设密码';
	$lang["admin_log_forgot_password_update"]		= '保存新的密码';


/*
 * Admin Menu
 */
	$lang["admin_menu_visitsite"]	= '网页主页';
 	$lang["admin_menu_logout"]		= '退出';
	$lang["admin_menu_image_list"]	= '图片';
	$lang["admin_menu_settings"]	= '设置';
	$lang["admin_menu_banned"]		= '禁止用户';
	$lang["admin_menu_bulk"]		= '批量上传';
	$lang["admin_menu_home"]		= '管理主页';
	$lang["admin_menu_ads"]			= '广告';
// not in pro
	$lang["admin_menu_database"]	= '数据库';


/*
 * admin Dashboard/home page
 */
	$lang["admin_home_dashboard_loading"]		= '如果加载过关请切换至基本页面，可修改 CONFIG.php 中的"$ADMIN_DASHBOARD_FULL  = turn;" 改为 false.';
	$lang["admin_home_overview"]				= '概况';
	$lang["admin_home_total_images"]			= '图片总数';
	$lang["admin_home_private_images"]			= '私人图片';
	$lang["admin_home_filespace_used"]			= '总空间已使用大小';
	$lang["admin_home_total_bandwidth"]			= '总带已使用流量';
 	$lang["admin_home_last_backup"]				= '最后的备份';
	$lang["admin_home_top_image"]				= '图片消耗';
	$lang["admin_home_by_bandwidth"]			= '消耗最大流量';
	$lang["admin_home_id"]						= 'ID';
	$lang["admin_home_name"]					= '图片名称';
	$lang["admin_home_bandwidth"]				= '使用流量';
	$lang["admin_home_hotlink_views"]			= '浏览次数';
	$lang["admin_home_by_hotlink_views"]		= '使用最多浏览量';
	$lang["admin_home_uploaded_date"]			= '上传日期';
	$lang["admin_home_total_since_last_reset"]	= '总计自复位';
	$lang["admin_home_last_reset_date"]			= '最后复位';
	$lang["admin_home_next_reset_date"] 		= '下一次复位';
	// Reported images / some used on image list page to
	$lang["admin_home_reported_images"]		= '被举报的图片';
	$lang["admin_home_tooltip_image_name"]	= '图片描述/名称';
	$lang["admin_home_image_name"]			= '图片描述/名称';
	$lang["admin_home_noreported"]			= '尚未有图片被举报';
	$lang["admin_home_report_remove_suc"]	= '被举报图片已删除.';
	$lang["admin_home_report_remove_err"]	= '删除图片出错.';
	$lang["admin_home_report_alt_remove"]	= '从举报列表中删除图片';
	$lang["admin_home_report_alt_delete"]	= '删除图片';
	$lang["admin_home_report_delete"]		= '您确认要删除图片 ID "%s"? 此操作将不可恢复!'; // %s = image id
	$lang["admin_home_report_alt_ban"]		= '禁止用户上传任何图片';


/*
 * admin ads
 */
	$lang["admin_ad_page_title"]	= '广告位置设置';
	$lang["admin_ad_page_des"]		= '在此页面您可以为您的网站添加HTML广告代码。头部和底部都是全站通用广告，将显示所有被运用的页面。请注意：如果你已设置AdSense代码将用于AdSense广告.';
	$lang["admin_ad_title_header"]	= '头部';
	$lang["admin_ad_title_index"]	= '首页';
	$lang["admin_ad_title_thumb"]	= '缩略图';
	$lang["admin_ad_title_gallery"]	= '图库';
	$lang["admin_ad_title_footer"]	= '底部';
	$lang["admin_ad_label_header"]	= '头部广告将会对所有网页显示';
	$lang["admin_ad_label_index"]	= '该指数的广告将只出现首页旁边的上传按钮';
	$lang["admin_ad_label_thumb"]	= '缩略图广告将只显示缩略图页旁边.';
	$lang["admin_ad_label_gallery"]	= '图库的广告将被搜索结果页面上方到下面图片的第一行';
	$lang["admin_ad_label_footer"]	= '底部广告将会对所有网页显示';


/*
 * admin Database page (not used in pro)
 */
	$lang["admin_db_title_database_setting"]			= '数据库工具';
	$lang["admin_db_menu_auto"]							= '自动数据库';
	$lang["admin_db_menu_image"]						= '图片数据库备份';
	$lang["admin_db_menu_bandwidth"]					= '带宽备份数据库';
	$lang["admin_db_menu_rebuild"]						= '重建图片数据库';
	// Auto Database Setting
	$lang["admin_db_auto_title"]						= '自动数据库设置';
	$lang["admin_db_auto_backup"]						= '自动数据库备份';
	$lang["admin_db_auto_every"]						= '自动备份全部';
	$lang["admin_db_auto_error"]						= '如果发现数据库错误使用上次备份的数据库';
	$lang["admin_db_auto_rebuild"]						= '运行数据库重建工具，如果要备份数据库请使用这个工具 ';
	$lang["admin_db_auto_every_6hours"]					= '6 小时';
	$lang["admin_db_auto_every_12hours"]				= '12 小时';
	$lang["admin_db_auto_every_day"]					= '1天';
	$lang["admin_db_auto_every_week"]					= '7天';
	// Image Database Setting
	$lang["admin_db_database_now"]						= '立即开始'; // Image and Bandwidth Database Settings
	$lang["admin_db_database_image_title"]				= '图片数据库备份';
	$lang["admin_db_database_image_replace"]			= '替换当前的图片数据库备份文件 (%1$s)?&#x0a;(请注意此操作不能恢复) ';// %1$s - file name
	$lang["admin_db_database_image_backup"]		 		= '备份这些图片数据库 ';
	// Bandwidth Database Settings
	$lang["admin_db_database_bandwidth_title"]		 	= '带宽数据库备份 ';
	$lang["admin_db_database_bandwidth_replace"]		= '取代目前的宽带数据库备份文件 (%1$s)?&#x0a;(请注意此操作不能恢复) ';// %1$s - file name
	$lang["admin_db_database_bandwidth_backup"]			= '备份带宽据库 ';
	// Image & Bandwidth Database Settings
	$lang["admin_db_database_delete_backup"]			= '删除这个备份文件 (%1$s)?&#x0a;(请注意此操作不能恢复) ';// %1$s - file name
	$lang["admin_db_database_delete_backup_tip"]		= '删除这个备份文件';
	$lang["admin_db_database_download_backup"]			= '下载这个备份 ';
	$lang["admin_db_database_image_replace_tip"]		= '使用这个备份文件 ';
	$lang["admin_db_database_backup_table_date"]		= '备份日期 ';
	$lang["admin_db_database_backup_table_date_tip"]	= '备份的日期 ';
	$lang["admin_db_database_backup_table_name"]		= '备份文件 ';
	$lang["admin_db_database_backup_table_name_tip"]	= '备份文件的名称 ';
	// Rebuild Image Database
	$lang["admin_db_rebuild_title"]						= '重建图片数据库 ';
	$lang["admin_db_rebuild_description"]				= '这个工具将检查图片上传文件夹中的所有图片，如发现任何不在数据库将增加这些图片。如果你有成千上万的图片数据库中没有的你可能需要在运行一次，为什么需要在运行一次？答：数据太大，所以需要在运行一次.';
	$lang["admin_db_image_description"]					= '图片检查工具将检查您的图像上传的文件夹，所有不存在的图片（缩略图或小简图）.
															如发现任何不具备（比如一个图片，缩略图 & 小缩略图）他们将被从服务器销毁（删除）
															最好运行前检查运行数据库查询.';
	$lang["admin_db_rebuild_check"]						= '运行数据库检查';
	$lang["admin_db_image_check"]						= '运行图片检测';
	// backup.class.php
	$lang["admin_db_backup_not_found"]					= '无法找到备份文件!';
	$lang["admin_db_backup_deleted"]					= '备份文件被成功删除!';
	$lang["admin_db_backup_delete_error"]				= '不能删除备份文件!';


/*
 * Admin Settings Page
 */
 	$lang["admin_set_save_button"]					= '保存更改';
	$lang["admin_set_option_on"]					= '开启';
	$lang["admin_set_option_off"]					= '关闭';
	$lang["admin_set_option_yes"]					= '是';
	$lang["admin_set_option_no"]					= '否';
	// settings menu
 	$lang["admin_set_title_admin_setting"]			= '管理员';
	$lang["admin_set_title_site_setting"]			= '概况';
	$lang["admin_set_title_gallery_setting"]		= '图库';
	$lang["admin_set_title_hide_page"]				= '显示/隐藏';
	$lang["admin_set_title_auto_deleted"]			= '自动删除';
	$lang["admin_set_title_upload_setting"]			= '上传';
	$lang["admin_set_watermark_title"]				= '水印';
	$lang["admin_set_title_url_shortener"]			= '缩短地址';
	$lang["admin_set_title_google_setting"]			= 'Google广告';
	$lang["admin_set_title_comment"]				= '评论'; // pro only
	// admin setting
	$lang["admin_set_old_password"]					= '旧密码';
	$lang["admin_set_new_password"]					= '新密码';
	$lang["admin_set_confirm_new_password"]			= '确认密码';
	$lang["admin_set_admin_username"]				= '管理员名称';
	$lang["admin_set_email_address"]				= '邮箱地址';
	// site setting
	$lang["admin_set_script_url"]					= '系统网址';
	$lang["admin_set_site_title"]					= '网站名称';
	$lang["admin_set_site_slogan"]					= '网站描述';
	$lang["admin_set_footer_copyright"]				= '底部版权';
	$lang["admin_set_site_theme"]					= '网站风格';
	$lang["admin_set_mod_rewrite"]					= '伪静态';
	$lang["admin_set_addthis"]						= '你的 AddThis pubid';
	$lang["admin_set_language"]						= '设置网站语言';
	// Gallery Settings
	$lang["admin_set_images_gallery_rows"]		= '行数';
	$lang["admin_set_images_gallery_rows_no"]	= '每行的图片';
	$lang["admin_set_report_allow"]				= '允许举报图片';
	$lang["admin_set_report_Send_email"]		= '举报时电子邮件通知';
	// Hide/show Pages
	$lang["admin_set_hide_gallery"]				= '图库';
	$lang["admin_set_hide_contact"]				= '联系我们';
	$lang["admin_set_hide_tos"]					= '服务条款';
	$lang["admin_set_hide_search"]				= '搜索栏';
	$lang["admin_set_hide_faq"]					= '常见问题';
	$lang["admin_set_image_widgit"]				= '显示随机图片';
	$lang["admin_set_hide_feed"]				= 'Rss订阅';
	$lang["admin_set_hide_sitemap"]				= '地图';
	// Auto Remove images (auto deleted)
	$lang["admin_set_des_auto_deleted"]			= '自动删除是一项功能，将帮助您保持您的站点干净和未使用的旧形象。这是通用图片托管网站多数使用的，但是对于那些正在使用以共享图片和照片与朋友和家人此功能的网站是最好的.';
	$lang["admin_set_auto_deleted"]				= '自动删除(未浏览)';
	$lang["admin_set_auto_deleted_for"]			= '自动删除(未浏览的)';
	$lang["admin_set_auto_deleted_days"]		= '日';
	$lang["admin_set_run_auto_deleted"]			= '执行自动删除';
	$lang["admin_set_run_auto_deleted_day"]		= '每日';
	$lang["admin_set_run_auto_deleted_week"]	= '每周';
	$lang["admin_set_run_auto_deleted_Month"]	= '每月';
	// Upload Settings
	$lang["admin_set_disable_upload"]			= '停用上传功能';
	$lang["admin_set_max_upload_file_size"]		= '最大上传文件大小';
	$lang["admin_set_image_max_bandwidth_des"]	= '如果您不想限制流量，请将图片最大流量设置为0.';
	$lang["admin_set_image_max_bandwidth"]		= '图片最大流量 (MB)';
	$lang["admin_set_auto_reset_bandwidth"]		= '自动重置流量';
	$lang["admin_set_multiple_upload_max"]		= '同时上传图片数量';
	$lang["admin_set_allow_duplicate"]			= '停止重复上传图片';
	$lang["admin_set_allow_image_resize"]		= '允许用户调整图片大小';
	$lang["admin_set_private_image_upload"]		= '私人图片上传';
	// Watermark Settings
	$lang["admin_set_watermark_des"]			= '水印可设置于图片底部或左上角，而且只会添加到外链图片.';
	$lang["admin_set_watermark_text"]			= '水印文字';
	$lang["admin_set_watermark_image"]			= '水印图片地址';
	$lang["admin_set_watermark_position"]		= '水印的位置';
	$lang["admin_set_watermark_center"]			= '中间';
	$lang["admin_set_watermark_left"]			= '左';
	$lang["admin_set_watermark_right"]			= '右';
	$lang["admin_set_watermark_top"]			= '顶部';
	$lang["admin_set_watermark_bottom"]			= '底部';
	// URL Shortener Settings
	$lang["admin_set_url_shortener"]			= 'URL缩短(b54.in)';
	$lang["admin_set_url_short_service"]		= 'URL缩短服务';
	$lang["admin_set_url_short_api_url"]		= 'API URL <small>(只适用于 Yourls)</small>';
	$lang["admin_set_url_short_api_username"]	= 'API 用户名 <small>(只适用于 B54)</small>';
	$lang["admin_set_url_short_api_password"]	= 'API 密码/密匙 <small>(只适用于 B54)</small>';
	// Google Settings
	$lang["admin_set_google_setting_des"]		= '只有您输入PIN码以后Google分析及广告才会启用（代码添加完毕后查看网页源码注意核对是否与Google代码一样)';
	$lang["admin_set_google_analytics_code"]	= 'Google分析代码（账号ID）';
	$lang["admin_set_google_channal_code"]		= '广告自定义频道的ID';
	$lang["admin_set_google_adsense_code"]		= 'Google AdSense 代码';
	// Save Errors
	$lang["admin_set_err_password_wrong"]		= '您输入错误密码!';
	$lang["admin_set_err_password_both"]		= '您需要输入原密码及新密码!';
	$lang["admin_set_err_username"]				= '用户名必填，不能为空';
	$lang["admin_set_err_email_invalid"]		= '电子邮箱格式不正确.';
	$lang["admin_set_err_script_url"]			= '网址不可留空';
	$lang["admin_set_suc_update"]				= '更新设置!';
	$lang["admin_set_err_saveing_settings"]		= '保存数据出错';


/*
 * Bulk upload page
 */
	$lang["admin_bulk_title"]			= '批量图片上传';
	$lang["admin_bulk_des"]				= '有了这个工具，你就可以通过FTP上传图片到 "%1$s" 文件夹, 然后按下面的上传图片按钮就可以了.';// %1$s = folder name; %2$s = number of images that can be uploaded 
	$lang["admin_bulk_list"]			= '1) 上传图像到 "%1$s"<br/>
											2) 然后按上传图片按钮<br/>
											3) 等待你的图片上传，根据图片的大小及数量这可能需要一定时间。<br/>
											4) 回到第2步，如果你有 %2$s 的图像批量文件夹';// %1$s = folder name; %2$s = number of images that can be uploaded 
											
	$lang["admin_bulk_form_button"]		= '上传图片';
	$lang["admin_bulk_no_image_err"]	= '没有发现图片 %s 到上传';// %s = folder name 
	$lang["admin_bulk_list_show"]		= '图片上传中';
	$lang["admin_bulk_upload_success"]	= '成功上传 %s 图像';// %s = number of image uploaded 

	
/*
 * Ban User Page
 */
	$lang["admin_ban_suc"]					= '您已经成功禁止 IP: %s 上传任何图片';
	$lang["admin_ban_err_save_db"]			= '有一个错误，试图保存到数据库!';
	$lang["admin_ban_err_no_ip"]			= '您需要输入要禁止的IP地址!';
	$lang["admin_ban_suc_unbanned"]			= '您已经成功取消禁止这个 IP: %s';
	$lang["admin_ban_alt_unban"]			= '删除禁止';
	$lang["admin_ban_form_title"]			= '禁止IP上传图片';
	$lang["admin_ban_form_ip"]				= 'IP';
	$lang["admin_ban_form_reason"]			= '原因';
	$lang["admin_ban_form_button"]			= '禁止IP';
	$lang["admin_ban_list_tt_date_banned"]	= '新增至禁止列表时间';
	$lang["admin_ban_list_date_banned"]		= '禁止时间';
	$lang["admin_ban_list_tt_ip"]			= '禁止IP地址';
	$lang["admin_ban_list_ip"]				= 'IP';
	$lang["admin_ban_list_tt_reason"]		= '禁止原因';
	$lang["admin_ban_list_reason"]			= '原因';


/*
 * Image List Page (ilp)
 */
	$lang["admin_ilp_thumb_page_link"]				= '查看缩略图';
	$lang["admin_ilp_edit_alt"]						= '图片编辑 公开/私人 & 描述/名称';
	$lang["admin_ilp_report_alt_delete"]			= '删除图片';
	$lang["admin_ilp_report_delete"]				= '确实要删除图片 ID "%s"? 此操作将不可恢复!'; // %s = image id
	$lang["admin_ilp_report_alt_ban"]				= '禁止用户上传任何图片';
	$lang["admin_ilp_number_to_list"]				= '列表中的项目';
	$lang["admin_ilp_number_to_list_all"]			= '全部';
	$lang["admin_ilp_order_list"]					= '排序';
	$lang["admin_ilp_order_list_date_added"]		= '新增日期';
	$lang["admin_ilp_order_list_last_viewed"]		= '最后浏览';
	$lang["admin_ilp_order_list_hotlink_views"]		= '浏览量';
	$lang["admin_ilp_order_list_bandwidth_used"]	= '流量使用';
	$lang["admin_ilp_order_list_gallery_clicked"]	= '图库点击率';
	$lang["admin_ilp_order_list_private"]			= '私人';
	$lang["admin_ilp_imglist_tt_image_added"]		= '图片上传时间';
	$lang["admin_ilp_imglist_image_added"]			= '上传时间';
	$lang["admin_ilp_imglist_tt_image_name"]		= '图片描述/名称';
	$lang["admin_ilp_imglist_image_name"]			= '图片描述/名称';
	$lang["admin_ilp_imglist_tt_last_viewed"]		= '图片浏览率';
	$lang["admin_ilp_imglist_last_viewed"]			= '最后<br/>浏览';
	$lang["admin_ilp_imglist_tt_gallery_clicks"]	= '在图库的图片已经被点击了多少次';
	$lang["admin_ilp_imglist_gallery_clicks"]		= '图库<br/>浏览';
 	$lang["admin_ilp_imglist_tt_hotlink_views"]		= '图片外链浏览量';
	$lang["admin_ilp_imglist_hotlink_views"]		= '浏览量';
	$lang["admin_ilp_imglist_tt_bandwidth_used"]	= '外链使用流量';
	$lang["admin_ilp_imglist_bandwidth_used"]		= '流量<br/>使用';
	$lang["admin_ilp_imglist_tt_private"]			= '是否私人图片';
	$lang["admin_ilp_imglist_private"]				= '私人';
	$lang["admin_ilp_ipsearch_alt"]					= '查看 &apos;%s&apos; 用户/ip上传的所有图片';
	$lang["admin_ilp_st_reset"]						= '从上次重置';
	$lang["admin_ilp_st_all"]						= '所有的时间';

/*
 * Image edit Page (iep)
 */
	$lang["admin_iep_suc"]				= '您已成功的更新图片.';
	$lang["admin_iep_title"]			= '编辑图片';
	$lang["admin_iep_des_title"]		= '图片描述';
	$lang["admin_iep_pp_title"]			= '公开/私人图片';
	$lang["admin_iep_private"]			= '私人';
	$lang["admin_iep_public"]			= '公开';
	$lang["admin_iep_button"]			= '更新';
	$lang["admin_iep_page_views"]		= '页面访问量';
// pro only
	$lang["admin_comment_edit"]			= '编辑点评';
// 1.6
	$lang["admin_iep_img_info"]			= '图片信息';
	$lang["admin_iep_uploaded"]			= '上传日期';
	$lang["admin_iep_time"]				= '上传时间';
	$lang["admin_iep_format"]			= '格式';
	$lang["admin_iep_ip_uploaded"]		= 'IP 上传至';
	$lang["admin_iep_ip_find_uploaded"]	= '查找该用户的所有图片';
	$lang["admin_iep_img_size"]			= '图片太小';
	$lang["admin_iep_thumb_size"]		= '缩略图太小';
	$lang["admin_iep_small_thumb_size"]	= '小缩略图太小';
	$lang["admin_iep_short_url"]		= '短网址';
	$lang["admin_iep_last_viewd"	]	= '最后查看时间';
	$lang["admin_iep_bandwidth_views"]	= '流量/查看';
	$lang["admin_iep_since_uploaded"]	= '上传来自';
	$lang["admin_iep_img_views"]		= '图片视图';
	$lang["admin_iep_thumb_views"]		= '缩略图点击';
	$lang["admin_iep_small_thumb_views"]= '小缩略图点击';
	$lang["admin_iep_gallery_views"]	= '图库点击';
	$lang["admin_iep_bandwidth_used"]	= '流量使用';
	$lang["admin_iep_from_last_reset"]	= '从上次重置';


/*
 * Site Pagination
 */
	$lang["pagination_next_page_tip"]		= '下一页';
	$lang["pagination_previous_page_tip"]	= '上一页';
	$lang["pagination_page_first_tip"]		= '第一页';
	$lang["pagination_page_last_tip"]		= '最后一页';
	$lang["pagination_page_tip"]			= '第%1$d页'; // %1$d - page number
	$lang["pagination_page_of"]				= '首页 %1$s of %2$s';// %1$s - page on / %2$s number of pages
	$lang["pagination_page_first"]			= '首页';
	$lang["pagination_page_last"]			= '尾页';


/*****************************************************************************
 *
 * Web Site Language
 *
 *****************************************************************************/


/*
 * Sitewide
 */
	$lang["site_search_text"]	= '图片搜索';
	$lang["site_search_button"]	= '搜索';
	$lang["site_language"]		= '网站语言 :';
	$lang["home_image_widgit"]	= '随机图片';
	$lang["footer_feed_title"]	= '图片Rss订阅';


/*
 * Site Menu
 */
	$lang["site_menu_home"]		= '主页';
	$lang["site_menu_gallery"]	= '图库';
	$lang["site_menu_faq"]		= '常见问题';
	$lang["site_menu_tos"]		= '服务条款';
	$lang["site_menu_contact"]	= '联系我们';


 /*
 * Site Feed
 */
	$lang["feed_description"]		= '最新 10 张图片';
	$lang["feed_language"]			= 'zh-cn';
	$lang["feed_image_name"]		= '图片名称';
	$lang["feed_no_images"]			= '没有图片上传';


/*
 * Delete Images msg
 */
 	$lang["site_index_delete_image_suc"]					= '您的图像被成功删除.';
	$lang["site_index_delete_image_err_db"]			= '保存数据出错!';
	$lang["site_index_delete_image_err_not_found"]	= '没有相关图片!';


/*
 * Upload images msg
 */
 	$lang["upload_duplicate_found"]			= ' 你上传一个重复的图片，该图片已被上传过了.';
	$lang["site_upload_url_err_no_image"]	= '图片不能发现或服务器拒绝访问图片.';
	$lang["site_upload_err"]				= '图片上传出错!';
	$lang["site_upload_err_no_image"]		= '对不起，未找到需要上传的图片!';
	$lang["site_upload_banned"]				= '对不起，您已被禁止上传图片至本网站.';
	$lang["site_upload_to_small"]			= '对不起，图片尺寸过小,%s 是最低尺寸标准.';
	$lang["site_upload_to_big"]				= '对不起，图片尺寸过大,%s 是最低尺寸标准.';
	$lang["site_upload_size_accepted"]		= '只有以下图片 %s 允许上传';
	$lang["site_upload_types_accepted"]		= '只有 %s 图片允许上传！';


/*
 * Index/Home Page
 */
 	$lang["site_index_des"]							= '上传图片或照片至本网站，分享给朋友，家人，同事及同学等等.';
	$lang["site_index_Image_Formats"]				= '允许上传的格式';
	$lang["site_index_maximum_filesize"]			= '允许上传的图片容量上限为';
	$lang["site_index_uploading_image"]				= '图片上传中，请稍候...';
	$lang["site_index_upload_image"]				= '选择要上传的图片';
	$lang["site_index_upload_browse_button"]		= '浏览';
	$lang["site_index_upload_description"]			= '描述: (可选)';
	$lang["site_index_upload_button"]				= '上传';
	$lang["site_index_upload_disable"]				= '上传功能已停用';
	$lang["site_index_local_image_upload"]			= '本地';
	$lang["site_index_local_image_upload_title"]	= '本地上传';
	$lang["site_index_Remote_image_copy"]			= '远程';
	$lang["site_index_Remote_image_copy_title"]		= '从远程上传图片';
	$lang["site_index_Remote_image"]				= '您要上传图片的链接';
	$lang["site_index_auto_deleted"]				= '<b>未被浏览过的文件</b> 会在无人访问的第 %s 天后自动删除.';
	$lang["site_index_max_bandwidth"]				= '外链限制';
	$lang["site_index_max_bandwidth_per"]			= '流量/';
	$lang["site_index_max_bandwidth_per_week"] 		= '周';
	$lang["site_index_max_bandwidth_per_month"]		= '月';
	$lang["site_index_max_upload"]					= '上传多张图片';
	$lang["site_index_max_upload_max"]				= '上传';
	$lang["site_index_tos_des"]						= '请勿上传任何色情或违反当地法律法规的图片!<br/>任何这样的图片都会被删除，请仔细阅读我们的 %s.';//%s = Terms of Service link 

 	$lang["site_index_upload_preferences"]		= '偏好设置';
	$lang["site_index_resize_title"]			= '调整图片大小';
	$lang["site_index_resize_height"]			= '高度';
	$lang["site_index_resize_width"]			= '宽带';
	$lang["site_index_resize_des"]				= '请输入高度和宽带，才可调整图片大小!';
	$lang["site_index_private_img"]				= '私人图片';
	$lang["site_index_short_url"]				= '生成短址';


/*
 * Thumbnail Page
 */
	$lang["site_index_hide_link"]				= '图片链接';
	$lang["site_index_social_networks"]			= '分享网站';
	$lang["site_index_short_url_link"]			= '缩短网址';
	$lang["site_index_bbcode"]					= '论坛代码';
	$lang["site_index_html_code"]				= 'HT命令代码';
	$lang["site_index_direct_link"]				= '原图链接';
	$lang["site_index_small_thumbnail_link"]	= '小缩略图链接';
	$lang["site_index_thumbnail_link"]			= '缩略图链接';
	$lang["site_index_image_link"]				= '图片链接';
	$lang["site_index_thumbs_page_err"]			= '没有相关图片!';
	$lang["site_index_delete_url"]				= '图片删除链接';
	$lang["site_index_delete_url_des"]			= '使用这个删除链接可随时删除图片.';


/*
 * Gallery Page
 */
	$lang["site_gallery_report_suc"]			= '图片已被举报';
	$lang["site_gallery_report_err_reporting"]	= '很抱歉，举报图片出错.';
	$lang["site_gallery_report_err_find"]		= '无法找到您所举报的图片.';
	$lang["site_gallery_report"]				= '举报';
	$lang["site_gallery_report_title"]			= '举报这张图片';
	$lang["site_gallery_report_this"]			= '您确定要举报这张图片吗？';
	$lang["site_gallery_page_title"]			= '图库页面';
	$lang["site_gallery_err_no_image"]			= '数据库中没有图片!';


/*
 * search Page
 */
	$lang["site_search_err_short"]		= '请至少输入三个字节.';
	$lang["site_search_err_blank"]		= '您没有输入关键字';
	$lang["site_search_page_title"]		= '图片搜索关于';
	$lang["site_search_results"]		= '找到 %s 结果';
	$lang["site_search_no_results"]		= '对不起，没有相关图片';
	$lang["site_search_suggestions"]	= '建议:<br/>请检查您的拼写或<br/>尝试其它关键字';


/*
 * Contact Us Page
 */
	$lang["site_contact_thank_you"]					= '感谢您 %s<br/>我们会尽快回复问题.<br/>我们不会向任何第三方组织或个人公开您的任何信息.';
	$lang["site_contact_des"]						= '请填写真实电子信箱，以便我们回复<br/>我们保证不会公开您的电子邮箱地址.'; // faq link
	$lang["site_contact_form_name"]					= '名称';
	$lang["site_contact_form_email"]				= '电子邮箱';
	$lang["site_contact_form_comment"]				= '内容';
	$lang["site_contact_form_captcha"]				= '请输入验证码';
	$lang["site_contact_form_captcha_img"]			= '点击图片刷新';
	$lang["site_contact_form_captcha_image_title"]	= '点击图片刷新验证码';
	$lang["site_contact_form_send"]					= '发送';
	$lang["site_contact_err_name_blank"]			= '名称不能为空';
	$lang["site_contact_err_email_blank"]			= '电子邮箱不能为空';
	$lang["site_contact_err_email_invalid"]			= '电子邮箱格式不正确.';
	$lang["site_contact_err_comment_blank"]			= '内容不可为空';
	$lang["site_contact_err_captcha_blank"]			= '验证码不可为空';
	$lang["site_contact_err_captcha_invalid"]		= '验证码不正确';
	$lang["site_contact_err_captcha_cookie"]		= '没有验证码的Cookies，请确保Cookies启用.';


/*
 * Terms of Service Page
 */
	$lang["site_tos_title"]						= '服务条款';
	$lang["site_tos_line1"]						= '如果该图片违反了我们的服务条款，我们将保留删除或停用该图片的权限.';
	$lang["site_tos_line2"]						= '我们的图片储存服务不保障您的图片因任何理由所导致的损失.';
	$lang["site_tos_line3"]						= '以下类型的图片均不允许上传至本网站:';
	$lang["site_tos_line4"]						= '任何侵权的图片.';
	$lang["site_tos_line5"]						= '任何含有成人内容及过分裸露情节的图片.';
	$lang["site_tos_line6"]						= '任何含有恐怖场面的图片.';
	$lang["site_tos_line7"]						= '任何侵犯个人隐私的图片.';
	$lang["site_tos_line8"]						= '任何违反当地法律法规的图片.';
	$lang["site_tos_line9"]						= '所有图片均不被删除，除非图片长时间处于低流量，或违反我们的服务条款.';
	$lang["site_tos_line10"]						= '我们会保留禁止任何用户的权利.';
	$lang["site_tos_line11"]						= '我们会保留随时变更或修改服务条款的一部分或全部内容的权利，而我们无需特意通知您.';
	$lang["site_privacy_policy_title"]				= '隐私权保护政策';
	$lang["site_privacy_policy_line1"]				= '我们永远不会向第三方泄露或出售您的资料.';


/*
 * Frequently Asked Questions Page
 */
	$lang["site_faq_title"]							= '常见问题解答';
	$lang["site_faq_q1"]							= '什么是 %s? 有什么用途?';// %s site title
	$lang["site_faq_a1"]							= '我们提供免费图片上传屠夫，让用户上传图片或照片至本网站，分享给朋友，家人，同事及同学等等.';
	$lang["site_faq_q2"]							= '图片上传服务收费吗?';
	$lang["site_faq_a2"]							= '我们提供的图片上传服务 100&#37; 免费! %s 依靠大家的赞助及广告商的支持.';// %s site title
	$lang["site_faq_q3"]							= '支持哪些图片格式?';
	$lang["site_faq_a3"]							= '图片或照片可上传至我们的网站.'; // file types are listed before this
	$lang["site_faq_q4"]							= '什么类型的图片可供上传?';
	$lang["site_faq_a4"]							= '我们提供上传合法照片服务，任何违反当地法律法规或违反<a href="tos.php" title="服务条款>服务条款</a>的图片将被删除".';
	$lang["site_faq_q5"]							= '为什么上传.BMP和.PSD 图像后悔变成.PNG格式?';
	$lang["site_faq_a5"]							= '所有 Bitmap(.BMP) 和 Photoshop(.PSD) 图像会自动转换为.PNG，以减少图片的容量及流量.';
	$lang["site_faq_q6"]							= '图片上传服务提供外链吗?';
	$lang["site_faq_a6"]							= '我们提供图片外链服务，而图片流量为 ';// bandwidth limit (set in settings) is added to the end
	$lang["site_faq_q7"]							= '图片储存的时间?';
	$lang["site_faq_a7_1"]							= '若乳片没有违反我们的 <a href="tos.php" title="%1$s">%1$s</a> 将会永久储存与本站服务器内，除非您自己删除或发生不可避免的意外.';//%1$s tos- title
	$lang["site_faq_a7_2"]							= '倘若图片多于 %1$d 天, 没有被浏览，图片将自动于本网站中删除.';//%1$d number of days
	$lang["site_faq_q8"]							= '图片文件的大小?';
	$lang["site_faq_a8"]							= '最大图片容量是';// file size added to end (set in settings)
	$lang["site_faq_q9"]							= '如何支持本网站?';
	$lang["site_faq_a9"]							= '您可以在任何网站、同事、朋友、同学中推广本站，或透过现金赞助本站!';
	$lang["site_faq_q10"]							= '还有更多的疑问?';
	$lang["site_faq_a10"]							= '我们欢迎您利用 <a href="contact.php" title="联系我们">联系我们</a> 功能，发送电子邮件查询问题.';

?>