<?php

/**
 * 用户端API类库
 *********可用方法**************|*******说明*********
 * __construct($MYFFSURL, $MYFFSSITEKEY , $MYFFSCONNKEY)             |    初始化API
 * is_login()                                                        |  检查是否登录
 * user_longin($CONNstr)                                             |    用户登录
 * user_logout                                                       |    退出登陆
 **************************************************** 
*/
class MYFFS {
    private $_MYFFSURL = null;
    private $_MYFFSSITEKEY = null;
    private $_MYFFSCONNKEY = null;
    /**
     * 初始化
     */
    public function __construct($MYFFSURL, $MYFFSSITEKEY , $MYFFSCONNKEY) {
            $this->_MYFFSURL = $MYFFSURL;
            $this->_MYFFSSITEKEY = $MYFFSSITEKEY;
            $this->_MYFFSCONNKEY = $MYFFSCONNKEY;
    }
    /**
     * 判断是否登录
     */
    public function is_login() {
        if(isset($_COOKIE['MYFFS_username'])&&isset($_COOKIE['MYFFS_SESSION'])) {
            if(md5($_COOKIE['MYFFS_username'].$this->_MYFFSCONNKEY)==$_COOKIE['MYFFS_SESSION']){
                return true;
            }else{
                return false;
            }
        }else{
            return false;
        }
    }
    /**
     * 加密解密函数
     */
    public function authcode($string , $key = '' ,$isEncrypt = true ) {
        $dynKey = $isEncrypt ? hash('sha1', microtime(true)) : substr($string, 0, 40);
        $fixedKey = hash('sha1', $key);
        $dynKeyPart1 = substr($dynKey, 0, 20);
        $dynKeyPart2 = substr($dynKey, 20);
        $fixedKeyPart1 = substr($fixedKey, 0, 20);
        $fixedKeyPart2 = substr($fixedKey, 20);
        $key = hash('sha1', $dynKeyPart1 . $fixedKeyPart1 . $dynKeyPart2 . $fixedKeyPart2);
        $string = $isEncrypt ? $fixedKeyPart1 . $string . $dynKeyPart2 : (isset($string{
            339}) ? gzuncompress(base64_decode(substr($string, 40))) : base64_decode(substr
            ($string, 40)));
        $n = 0;
        $result = '';
        $len = strlen($string);
        for ($n = 0; $n < $len; $n++) {
            $result .= chr(ord($string{$n}) ^ ord($key{$n % 40}));
        }
        return $isEncrypt ? $dynKey . str_replace('=', '', base64_encode($n > 299 ?
            gzcompress($result) : $result)) : substr($result, 20, -20);
    }
    /**
     * 用户登录：成功返回用户信息数组。失败返回false。
     */
    public function user_login($CONNstr) {
        $CONNarray=json_decode($this->authcode($CONNstr,$this->_MYFFSCONNKEY,false),true);
        if(count($CONNarray)==7&&mktime()-$CONNarray['now'] < 3600){
            return $CONNarray;
        }else{
            return false;
        }
    }
    /**
     * 退出登录
     */
    public function user_logout(){
        setcookie('MYFFS_username','');
        setcookie('MYFFS_regtime','');
        setcookie('MYFFS_userid','');
        setcookie('MYFFS_lastlogin','');
        setcookie('MYFFS_nickname','');
        setcookie('MYFFS_SESSION','');
    }
}

?>