<?php
/**
 * 用户操作类
 *********可用方法**********************************|*******说明*********
 * creat_user_info($basepath,$userinfo)             |    创建用户信息文件夹和其他信息
 * user_info_path($time,$username)                  |    根据注册时间和用户名，获取用户目录


 **************************************************** 
 * 以下是使用提示：
 * 使用之前一定要初始化，否则无法正常使用后续函数。
 * 设置/获取键值，必须在用户登录的状态下执行，否则无法执行。
 * 可以使用is_longin来主动获取登录状态（初始化的时候会执行一次）
 * 所有方法运行失败都会返回FALSE。
 * 获取用户信息仅在通过UC登录时有效，返回用户信息数组。
 */
class FFS_USER {
    /**
     * 发送验证注册邮件
    */
    function reg_mail($userinfo){
            $headerContents='<p>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp<a href="'.$userinfo['url'].'" target="_blank" >请点击此，进行邮件验证</a></p><p>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp如果不能点击，请将此地址复制到浏览器地址栏：<a href="'.$userinfo['url'].'" target="_blank" >'.$userinfo['url'].'</a></p>';
            MAIL_SEND_VIP($userinfo['user'],UERMAILSUBJECT,$headerContents.str_replace(" ","&nbsp",str_replace("\n","<br />",stripslashes(USERMAILBODY))));          
    }
    /**
     * 找回密码
    */
    function user_getpass($return,$email){
            switch($return){
                case '1' : //存在于重置密码表且没有超过时限
                    echo '<script type="text/javascript">alert("重置密码邮件已经发送，如果未接收到，请于一个小时后再次提交申请！");history.go(-1);</script>';
                    break;
                default  : //存在于重置密码表且超过时限
                    $headerContents='<p>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp<a href="'.$return.'" target="_blank" >请点击此，进行密码重置</a></p><p>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp如果不能点击，请将此地址复制到浏览器地址栏：<a href="'.$return.'" target="_blank" >'.$return.'</a></p><p>如果不是你本人提交的重置密码请求，请不要理会此邮件，删除即可。</p>';
                    MAIL_SEND_VIP($email,'FFS UC 密码重置邮件',$headerContents); 
                    echo '<script type="text/javascript">alert("重置密码邮件发送成功，请查收邮件！");history.go(-1);</script>';
                    break;
            }
                     
    }
    /**
     * 创建用户目录和其他相关信息
    */
    function creat_user_info($basepath,$userinfo){
            $Y=date('Y',$userinfo['regtime']);
            $M=date('m',$userinfo['regtime']);
            $a['userid']=$userinfo['userid'];
            $a['username']=$userinfo['username'];
			$a['nickname']=$userinfo['nickname'];
            $a['regtime']=$userinfo['regtime'];
            $a['lastlogin']=$userinfo['lastlogin'];
            $a['ip']=$userinfo['ip'];
            $nickname=$a['nickname'];
            $userpath=$basepath.'users/'.$Y.'/'.$M.'/'.md5($userinfo['username']).'/user.php';
            if(file_exists($userpath)){
                $userarray=json_decode(file_get_contents($userpath),true);
                if($userarray['allow']=='0'){
                    return false;
                }else{
                    $a['allow']='1';
                    $nickname=$userarray['nickname'];
                    file_put_contents($userpath,json_encode($a));
                    return $nickname;
                }
            }
            else
            {
                if (!file_exists($basepath."users/$Y/"))
                {
                    mkdir($basepath."users/$Y/", 0777);
                    chmod($basepath."users/$Y/", 0777);
                }
                if (!file_exists($basepath."users/$Y/$M/"))
                {
                    mkdir($basepath."users/$Y/$M/", 0777);
                    chmod($basepath."users/$Y/$M/", 0777);
                }
                mkdir($basepath.'users/'.$Y.'/'.$M.'/'.md5($userinfo['username']).'/',0777);
                chmod($basepath.'users/'.$Y.'/'.$M.'/'.md5($userinfo['username']).'/',0777);
                $a['allow']='1';
                file_put_contents($basepath.'users/'.$Y.'/'.$M.'/'.md5($userinfo['username']).'/user.php',json_encode($a));
                chmod($basepath.'users/'.$Y.'/'.$M.'/'.md5($userinfo['username']).'/user.php',0777);            
                file_put_contents($basepath.'users/'.$Y.'/'.$M.'/'.md5($userinfo['username']).'/mydisk.php','');
                chmod($basepath.'users/'.$Y.'/'.$M.'/'.md5($userinfo['username']).'/mydisk.php',0777); 
                file_put_contents($basepath.'users/'.$Y.'/'.$M.'/'.md5($userinfo['username']).'/favourite.php','');
                chmod($basepath.'users/'.$Y.'/'.$M.'/'.md5($userinfo['username']).'/favourite.php',0777);
                $this->creat_user_list();
                return $nickname;
            }
        }
    function user_info_path($regtime,$username){
        $Y=date('Y',$regtime);
        $M=date('m',$regtime);
        $path='users/'.$Y.'/'.$M.'/'.md5($username);
        return $path;
    }
    function change_user_nickname($regtime,$username,$nickname){
        $path=MOP.$this->user_info_path($regtime,$username);
        $userinfo=json_decode(file_get_contents($path.'/user.php'),true);
        $a=array();
        foreach($userinfo as $key => $value){
            $a[$key]=$value;
        }
        $a['nickname']=$nickname;
        if(file_put_contents($path.'/user.php',json_encode($a))){
            return true;
        }
    }
    function user_files($regtime,$username){
        $path=MOP.$this->user_info_path($regtime,$username);
        $allId=substr(file_get_contents($path.'/mydisk.php'),0,-1);
        if($allId==''){
            return false;
        }
        $allIdArray=explode('|',$allId);
        $filelist="";
        foreach($allIdArray as $key => $value){
            if(FILE_REINFO($value)){
            $filelist[$key]=FILE_REINFO($value);
            }
        }
        return $filelist;
    }
    function user_favourite($regtime,$username){
        $path=MOP.$this->user_info_path($regtime,$username);
        $allId=substr(file_get_contents($path.'/favourite.php'),0,-1);
        $allIdArray=explode('|',$allId);
        $filelist="";
        foreach($allIdArray as $key => $value){
            if(FILE_REINFO($value)){
            $filelist[$key]=FILE_REINFO($value);
            }
        }
        return $filelist;
    }
    function creat_user_list(){
        $allusers=glob(MOP.'users/*/*/*/user.php');
        $a = array();
        if(count($allusers>0)){
            foreach($allusers as $b){
                $c = json_decode(file_get_contents($b),true);
                $a[] = $c;
            }
        file_put_contents(MOP . 'users/userlist.php', json_encode($a));
        }else{
            file_put_contents(MOP . 'users/userlist.php', "");
        }
        chmod(MOP . 'users/userlist.php', 0777);
    }
    
    function user_del($regtime,$username,$delfile = false){
        $path=MOP.$this->user_info_path($regtime,$username);
        if($delfile){
            $userfiles=$this->user_files($regtime,$username);
            if(count($userfiles)>0){
                foreach($userfiles as $key => $value){
                   FILE_DELETE($value['id']);                
                }
            }        
        }
        $userinfo=file_get_contents($path.'/user.php');
        $userinfo=str_replace('"allow":"1"','"allow":"0"',$userinfo);
        file_put_contents($path.'/user.php',$userinfo);
        $this->creat_user_list();
    }
    function user_re($regtime,$username){
        $path=MOP.$this->user_info_path($regtime,$username);
        $userinfo=file_get_contents($path.'/user.php');
        $userinfo=str_replace('"allow":"0"','"allow":"1"',$userinfo);
        file_put_contents($path.'/user.php',$userinfo);
        $this->creat_user_list();
    }
    function userlist_up_task($now='true'){
        if($now){
            $this->creat_user_list();
            file_put_contents(MOP . 'users/task.php',mktime());
        }else{
            $last=file_get_contents(MOP . 'users/task.php',mktime());
            if(mktime()-$last>7200){
                $this->creat_user_list();
                file_put_contents(MOP . 'users/task.php',mktime());               
            }
        }
        chmod(MOP . 'userss/task.php', 0777);
    }
    
}



?>