<?
//
//   CF Image Hosting Script v1.3.8
//   -------------------------------
//
//   Author:    codefuture.co.uk
//   Version:   1.3.8
//   Date:      14-Aug-10
//
//   download the latest version from - http://codefuture.co.uk/projects/imagehost1.3/
//
//   Copyright (c) 2010 codefuture.co.uk
//   This file is part of the CF Image Hosting Script.
//
//   CF Image Hosting Script is free software: you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation, either version 3 of the License, or
//   (at your option) any later version.
//
//   CF Image Hosting Script is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//   You should have received a copy of the GNU General Public License
//   along with CF Image Hosting Script.  If not, see http://www.gnu.org/licenses/.
//
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
// stop page from being cached
	// Date in the past
		header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
	// Always modified
		header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
	// HTTP/1.1
		header("Cache-Control: no-store, no-cache, must-revalidate");
		header("Cache-Control: post-check=0, pre-check=0", false);
	// HTTP/1.0
		header("Pragma: no-cache");
// stop page from being cached
/////////////////////////////////////////////////////////////////////////////////////
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
<title><?=$settings['SET_TITLE'];?><?=(isset($page_title)?$page_title:'');?></title>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<meta name="description" content="Free Image Hosting <?=(isset($page_title)?$page_title:'');?> - powered by CF Image Hosting" />
<meta name="keywords" content="images, photos, image hosting, photo hosting, free image hosting"/>
<meta name="robots" content="index,follow"/>
<meta name="distribution" content="Global" />
<link rel="alternate" type="application/rss+xml" title="<?=$settings['SET_TITLE'];?> Feed" href="feed.php" />
<link rel="stylesheet" href="css/<?=($settings['SET_THEME']=='light' ? 'style_light.css':($settings['SET_THEME']=='dark'?'style.css':($settings['SET_THEME']=='sky'?'style_sky.css':'original.css')));?>" type="text/css" />
<?
//only needed the home page
	if ($menu == '' && !isset($img_posted)){

?>
<script type="text/javascript" src="http://code.jquery.com/jquery-1.4.2.min.js"></script>
<script type= "text/javascript">
/*<![CDATA[*/
	$(document).ready(function(){
		$('form.upform').submit(function() {
			$(".file").animate({"height": "toggle", "opacity": "toggle"}, "slow");
			$(".loading").fadeIn("slow");
		});
	});


	var max = <?=$settings['SET_MAX_UPLOAD'];?>;
	var count = 1;
	$(document).ready(function(){
		$('.add_another_file_input').click(function(){
			var html = $('.Upload_Multiple').prev('.input').html();
			$('.file:last').after( '<div class="input file hide">'+html+'</div>' );
			$('.file:last').animate({"height": "toggle", "opacity": "toggle"}, "slow");
			count++;
			if(count >= max) $('.Upload_Multiple').animate({"height": 0, "opacity": 0}, "slow");
			if(count === 2) copyfileName();
		return false;
		});
	});


	$(document).ready(function(){
		$("#linkremote").click(function(){
			$('#local_panel').fadeOut(1);
			$('.Upload_Multiple').animate({"height": 0, "opacity": 0}, "slow");
			$('div.hide').animate({"height": "toggle", "opacity": "toggle"}, "slow").delay(800).remove(".hide");
			count = 1;
			$('#remote_panel').delay(2).fadeIn("slow");
			$('#linklocal').removeClass('linklocal show').addClass('linklocal');
			$('#linkremote').removeClass('linkremote').addClass('linkremote show');
		});
		$("#linklocal").click(function(){
			$('#remote_panel').fadeOut(1);
			if(count < max) $('.Upload_Multiple').delay(1).animate({"height": '20px', "opacity": "100"}, "slow");
			$('#local_panel').delay(2).fadeIn("slow");
			$('#linklocal').removeClass('linklocal').addClass('linklocal show');
			$('#linkremote').removeClass('linkremote show').addClass('linkremote');
		});
	});


	function  copyfileName() {
		var name;
		var file = document.upload.elements["file[]"];
		var file_name = document.upload.elements["fileName[]"];
		var alt = document.upload.elements["alt[]"];
		if (file.length > 0){
			for (i = 0; (i < file.length); i++) {
				if (file_name[i].value != file[i].value){
					file_name[i].value = file[i].value;
					name = file_name[i].value.slice(file_name[i].value.lastIndexOf("\\")+1,file_name[i].value.lastIndexOf('.'));
					alt[i].value = name.replace(/_|-/g," ");
				}
			}
		}else{
			file_name.value = file.value;
			name = file_name.value.slice(file_name.value.lastIndexOf("\\")+1,file_name.value.lastIndexOf('.'));
			alt.value = name.replace(/_|-/g," ");
		}
	}

	function fileExt() {
		var extArray = new Array("<?=implode('","',$accepted);?>");
		var file = document.upload.elements["fileName[]"];
		for (i = 0; (i < file.length); i++) {
			var extOk = false;
			if (!file[i].value) return false;
			var filename = file[i].value.slice(file[i].value.indexOf("\\") + 1);
			var ext = filename.slice(-3).toLowerCase();
			for (var i = 0; i < extArray.length; i++) {
				if (extArray[i] === ext) {
					extOk = true;
				}
			}
			if (extOk != true) {
				alert("Please only upload files that end in types:  "
				+ (extArray.join("  ")) + "\nPlease select a new "
				+ "file to upload and submit again.");
				return false;
			}
		}
		return true;
	}

	function img_search(){
		var search_box = document.getElementById("searchBox");
		if(search_box.value=='<?=$LANGUAGE_PACK["site_search_text"];?>'){
			search_box.value = '';
		}else{
			search_box.value = '<?=$LANGUAGE_PACK["site_search_text"];?>';
		}
	}

/*]]>*/
</script>
<?
	}elseif ($menu == ''){
?>
<script type="text/javascript" src="http://code.jquery.com/jquery-1.4.2.min.js"></script>
<script type="text/javascript" src="lightbox/jquery.lightbox-0.5.js"></script>
<link rel="stylesheet" type="text/css" href="lightbox/jquery.lightbox-0.5.css" media="screen" />
<script type= "text/javascript">
/*<![CDATA[*/
$(function() {$('div.img_box a').lightBox({overlayOpacity: 0.6});});
$(document).ready(function(){
$(".flip").click(function(){
    $(this).next('.panel').animate({"height": "toggle", "opacity": "toggle"}, "slow");//slideToggle("slow");
  });
});
/*]]>*/
</script>
<?
	}elseif ($menu == 'gallery'){
?>
<script type="text/javascript" src="http://code.jquery.com/jquery-1.4.2.min.js"></script>
<script type= "text/javascript">
/*<![CDATA[*/
function doconfirm(message,id,page) {
	if (confirm(message)) {
		window.location = "gallery.php?report="+id+"&p="+page;
	}
	else {return false;}
}

$(document).ready(function(){
	var thisImg;
	var thisImgWidth;
	$("li").hover(function(e){
		thisImg  = $(this);
		thisImgWidth =(180-$(this).children("a.thumb").children("img").width())/2-5;
		thisImgoffset =$(this).children("a.thumb").children("img").offset();
		thisLiOffset =$(this).offset();
		thisimgtop = thisImgoffset.top - thisLiOffset.top;
		$(this).children(".img_report")
			.css("right",thisImgWidth+"px")
			.css("top",thisimgtop+"px")
			.fadeIn("slow");
	},
	function(){
		$(thisImg).children(".img_report").css("display", "none");
	});
});
/*]]>*/
</script>
<?
	}
?>
</head>
<body>
<? if(checklogin()){?>
<div id="admin_bar">
<div class="title">Admin Menu</div>
<ul class="nav">
	<li><a href="admin.php?act=logout" title="<?=$LANGUAGE_PACK["admin_menu_logout"];?>"><?=$LANGUAGE_PACK["admin_menu_logout"];?></a></li>
	<li><a <?=($menu=="set" ? ' class="current" ':'');?> href="admin.php?act=set" title="<?=$LANGUAGE_PACK["admin_menu_settings"];?>"><?=$LANGUAGE_PACK["admin_menu_settings"];?></a></li>
	<li><a <?=($menu=="ban" ? ' class="current" ':'');?> href="admin.php?act=ban" title="<?=$LANGUAGE_PACK["admin_menu_banned"];?>"><?=$LANGUAGE_PACK["admin_menu_banned"];?></a></li>
<? if($settings['SET_ADMIN_MENU']){?>
	<li><a <?=($menu=="admin" ? ' class="current"':'');?> href="admin.php" title="<?=$LANGUAGE_PACK["admin_menu_home"];?>"><?=$LANGUAGE_PACK["admin_menu_home"];?></a></li>
<?}?>
</ul>
</div>
<?}?>
<div id="wrap">
	<div id="header" class="clear">
		<div id="logo">
			<h1><a href="index.php" title="Home"><?=$settings['SET_TITLE'];?></a></h1>
			<h2><?=$settings['SET_SLOGAN'];?></h2>
		</div>

	<div class="languages" onMouseOver="document.getElementById('language').style.display='block'" onMouseOut="document.getElementById('language').style.display='none'">
		<div class="lan_on"><span><?=$LANGUAGE_PACK["site_language"];?></span><img src="languages/<?=$settings['SET_LANGUAGE'];?>.gif" width="23" alt="<?=$settings['SET_LANGUAGE'];?>" title="<?=$settings['SET_LANGUAGE'];?>" border="0"></div>
		<div id="language" class="language" >
				<? if($settings['SET_LANGUAGE']!='english'){?><a href="?lang=english" title="English"><img src="languages/english.gif" alt="English" /></a><?}?>
				<? if($settings['SET_LANGUAGE']!='hungarian'){?><a href="?lang=hungarian" title="Hungarian"><img src="languages/hungarian.gif" alt="Hungarian" /></a><?}?>
				<? if($settings['SET_LANGUAGE']!='norwegian'){?><a href="?lang=norwegian" title="Norwegian"><img src="languages/norwegian.gif" alt="Norwegian" /></a><?}?>
				<? if($settings['SET_LANGUAGE']!='polski'){?><a href="?lang=polski" title="Polski"><img src="languages/polski.gif" alt="Polish" /></a><?}?>
				<? if($settings['SET_LANGUAGE']!='portuguese'){?><a href="?lang=portuguese" title="Portuguese (Brasil)"><img src="languages/portuguese.gif" alt="Portuguese (Brasil)" /></a><?}?>
			</div>
		<div class="clear_both"></div>
	</div>
	<?if(!$settings['SET_HIDE_SEARCH']){?>
		<div id="search">
			<form method="get" action="search.php">
				<input type="text" size="28" name="search" id="searchBox" class="text_input" value="<?=$LANGUAGE_PACK["site_search_text"];?>" onfocus="img_search();" onblur="img_search();" /><input type="submit" value="<?=$LANGUAGE_PACK["site_search_button"];?>" class="button" />
			</form>
		</div>
	<?}?>
		<div id="nav">
			<ul id="main-nav">
				<li><a <?=($menu=="" ? ' class="current" ':'');?> href="./" title="<?=$LANGUAGE_PACK["site_menu_home"];?>"><?=$LANGUAGE_PACK["site_menu_home"];?></a></li>
			<? if(!$settings['SET_HIDE_GALLERY']){?>
				<li><a <?=($menu=="gallery" ? ' class="current" ':'');?> href="gallery.php" title="<?=$LANGUAGE_PACK["site_menu_gallery"];?>"><?=$LANGUAGE_PACK["site_menu_gallery"];?></a></li>
			<?}?>
			<? if(!$settings['SET_HIDE_TOS']){?>
				<li><a <?=($menu=="tos" ? ' class="current" ':'');?> href="tos.php" title="<?=$LANGUAGE_PACK["site_menu_tos"];?>"><?=$LANGUAGE_PACK["site_menu_tos"];?></a></li>
			<?}?>
			<? if(!$settings['SET_HIDE_CONTACT']){?>
				<li><a <?=($menu=="contact" ? ' class="current" ':'');?> href="contact.php" title="<?=$LANGUAGE_PACK["site_menu_contact"];?>"><?=$LANGUAGE_PACK["site_menu_contact"];?></a></li>
			<?}?>
			<? if(!$settings['SET_ADMIN_MENU']){?>
				<li><a <?=($menu=="admin" ? ' class="current"':'');?> href="admin.php" title="<?=$LANGUAGE_PACK["site_menu_home"];?>"><?=$LANGUAGE_PACK["site_menu_admin"];?></a></li>
			<?}?>
			</ul>
		</div>
	<div class="clear"></div>
	</div>
	<div id="content">
<? if($settings['SET_GOOGLE_ADS'] !=''){?>
		<div class="top_ad"><?=$header_AdSense;?></div>
<?}?>