<?
//
//   CF Image Hosting Script v1.3.8
//   -------------------------------
//
//   Author:    codefuture.co.uk
//   Version:   1.3.8
//   Date:      14-Aug-10
//
//   download the latest version from - http://codefuture.co.uk/projects/imagehost1.3/
//
//   Copyright (c) 2010 codefuture.co.uk
//   This file is part of the CF Image Hosting Script.
//
//   CF Image Hosting Script is free software: you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation, either version 3 of the License, or
//   (at your option) any later version.
//
//   CF Image Hosting Script is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//   You should have received a copy of the GNU General Public License
//   along with CF Image Hosting Script.  If not, see http://www.gnu.org/licenses/.
//
////////////////////////////////////////////////////////////////////////////////////

	include_once('inc/config.php');

	$db = new array_db($ADD_DB_IMG);

	//remove reported images
		if($settings['SET_REMOVE_REPORT']){
			$db_report = new array_db($ADD_DB_REPORT);
			if($db_report->db_not_empty()){
				$db_report_full = $db_report->fetch_all();
				foreach ($db_report_full as $k => $v) {
					 $db->remove_row('id',$v['id']);
				}
			}
		}

	//remove private images
		if($settings['SET_PRIVATE_IMG_ON']){
			$db->remove_row('private',1,'rows');
		}

	$db_img = $db->fetch_all();

	header ("Content-type: text/xml");
	echo '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">';

// Home page
	echo '<url><loc>'.$settings['SET_SITEURL'].'</loc></url>';
// Gallery
	if(!$settings['SET_HIDE_GALLERY']){
		echo '<url><loc>'.$settings['SET_SITEURL'].'/gallery.php</loc></url>';
	}
// TOS
	if(!$settings['SET_HIDE_TOS']){
			echo '<url><loc>'.$settings['SET_SITEURL'].'/tos.php</loc></url>';
	}
// Contact
	if(!$settings['SET_HIDE_CONTACT']){
			echo '<url><loc>'.$settings['SET_SITEURL'].'/contact.php</loc></url>';
	}

	gallery_pages($settings['SET_IMG_ON_PAGE'], $db->db_count());

	foreach($db_img as $k => $v){
		echo "<url>";
		echo "<loc>".get_thumb_mid_address($v['id'],"pm",$db_img)."</loc>";
		echo "</url>";
		echo "<url>";
		echo "<loc>". get_thumb_address($v['id'],"pt",$db_img)."</loc>";
		echo "</url>";
	}
	echo "</urlset>";



function gallery_pages($items_on_page,$item_count){
	global $settings;

	$link_mod	= (!$settings['SET_MOD_REWRITE'] ? '/gallery.php?p=':'/page');
	$ex_var		= (!$settings['SET_MOD_REWRITE'] ? '':'.html');

	$number_of_pages = ceil($item_count/$items_on_page);
	if (($number_of_pages*$items_on_page) < $item_count) $number_of_pages++;

	for ($i = 1; $i <= $number_of_pages; $i++) {
		echo "<url>";
		echo "<loc>".$settings['SET_SITEURL'].$link_mod.$i.$ex_var."</loc>";
		echo "</url>";
	}

}

?>