<?php
/** Filename:    ftp.php
*   Description: send user's ftp request
*   Authors:     Li Zhi Wei,Greg Shaw(greg@upsdn.net)
*   License:     GPL
*   Date:        2004-12-18    
*/

error_reporting(E_ALL);
//error_reporting (E_ALL & ~E_WARNING & ~E_NOTICE);
//set_time_limit(10);
session_start();

//1.Is Login?
if (!isset( $_SESSION['host'])){
  header("Location: index.html");
} 

$name_list = "";
$size_list = "";
$time_list = "";
$mode_list = "";
$info_str  = "";

//2.Clean Ftp Temp Dir
require_once "ftp_config.php";
//just debug,remove it
// /*
if (FALSE == SetTempDir($ftp_temp)){
   $info_str = "Fatal Error:Temp Dir is not writable.";
   OutPutInfo($info_str,2);
   exit(1);
}  
// */

$user_id = md5($_SESSION['host'].$_SESSION['user']);
CleanTempDir($ftp_temp.$user_id."*");

//3.
if (!isset($_POST['command'])){
  $_POST['command']  = "list";
  $_POST['fullpath'] = "/";
}
else if ($_POST['command'] == "logout" ){
  $_SESSION = array();
  if (isset($_COOKIE[session_name()])){
     setcookie(session_name(), '', time()-42000, '/');
  }
  //unset($_COOKIE[session_name()]);
  session_destroy();
  header("Location: index.html");
  exit(0);
}       

require_once "zip.lib.php";
require_once "ftp.lib.php";
$Web2Ftp = new WEBFTP;  
$zip_obj = new PKZIP; 
//4.connect to ftp
if( FALSE == $Web2Ftp->InitConn($_SESSION['user'],$_SESSION['pass'],
                                $_SESSION['host'],$_SESSION['port']) ){
  $info_str = "<font color=red>Cannot Login:Username or Password Error</font><br><a href='index.html'>Back to Login</a>";
  OutPutInfo($info_str,2);
  exit(2);
}  
$Web2Ftp->SetWorkingDir($_POST['fullpath']);
$Web2Ftp->SetPasv($_SESSION['pasv']);        

//5.dispatch command
switch($_POST['command']){
  case "newdir": 
      $Web2Ftp->MakeDir($_POST['itemname']);
      break;  
  case "del":   
      if (substr($_POST['itemname'], -1) == '/')
         $Web2Ftp->RemoveAll(substr($_POST['itemname'],0,-1));  /**/
      else
         $Web2Ftp->DeleteFile($_POST['itemname']);     
      break;
  case "chmod": 
      $Web2Ftp->ChangMode($_POST['itemname'],$_POST['other']);
      break;
  case "enter":
      if (substr($_POST['itemname'], -1) == '/'){
         $Web2Ftp->SetWorkingDir($_POST['itemname']);
      }else{
         filedown();
         exit(0);
       }
      break;
  case "ren":
      $Web2Ftp->Move($_POST['itemname'],$_POST['other']);
      break;     
  case "upload":
      multiupload();
      break;
  case "zipup":
      zipup();
      break;
  case "down":
      downit();
      //no break;
  default:
      break;      
}

//6.list current dir
foreach ($Web2Ftp->GetList() as $filex) 
{
   $name_list .= $filex['name'];
   if( $filex['type'] == '1' )
       $name_list .= "/";
   $name_list .= ",";
   $size_list .= ($filex['size'].",");
   $time_list .= ($filex['date']." ".$filex['time'].",");
   $mode_list .= RightsReplace($filex['rights']);    
}
OutPutInfo( $Web2Ftp->GetStatus() );
//end all process



//7. start functions

function RightsReplace($string)
{
  $patterns[0] = "/[rwx]/";
  $patterns[1] = "/-/" ;
  $replace[0] = "1,";
  $replace[1] = "0,";
  return preg_replace($patterns, $replace, substr($string,1));
}  

function OutPutInfo($info_str,$reload=1)
{
  global $Web2Ftp,$name_list,$size_list,$time_list,$mode_list;

  if ( $info_str == "")
     $info_str = $_POST['command'].":<font color=green>Command Completed.</font>";
  if( $reload == 1)   
    echo "<html><body onload=\"parent.LoadData()\"><form name=\"infoform\">\n";
  else
    echo "<html><body ><form name=\"infoform\">\n";
       
  echo $info_str;
  echo "<input name=\"cwd\" type=\"hidden\" value=\"".$Web2Ftp->GetWorkingDir()."\">\n";
  echo "<input name=\"name\" type=\"hidden\" value=\"".$name_list."\">\n";
  echo "<input name=\"size\" type=\"hidden\" value=\"".$size_list."\">\n";
  echo "<input name=\"time\" type=\"hidden\" value=\"".$time_list."\">\n"; 
  echo "<input name=\"rights\" type=\"hidden\" value=\"".$mode_list."\">\n";
  echo "</form></body></html>";
  
  $Web2Ftp->CloseConn();
}

//download a single file
function filedown()
{
  global $Web2Ftp,$ftp_temp,$user_id;
  
  $ftp_temp .= $user_id."-".basename($_POST['itemname']); 
  $temp_size = $Web2Ftp->GetFileSize( $_POST['itemname'] );
  //if (($temp_size > 4194304) || ($temp_size == -1)){
  //  OutPutInfo( "file size is too large(4M)",0); 
  //}else{
     if( FALSE == $Web2Ftp->GetFileToTemp($_POST['itemname'],$ftp_temp)){
        $result_info = $Web2Ftp->GetStatus();
     }else{
       gzipit($ftp_temp,"{$ftp_temp}.gz");
       //unlink($ftp_temp);
       $result_info = "<a href='".$ftp_temp.".gz'>Download it</a>";
     }   
    OutPutInfo($result_info,0); 
  //}
}

function downit()
{
  if ( substr($_POST['itemname'], -1) == '/' ){
    zipdown();
  }else{
    filedown();
  }
  exit(0);
}

function gzipit( $srcFileName, $dstFileName )
{
   // getting file content
   $fp = fopen( $srcFileName, "rb" );
   $data = fread ( $fp, filesize( $srcFileName ) );
   fclose( $fp );
  
   // writing compressed file
   $zp = gzopen( $dstFileName, "wb9" );
   gzwrite( $zp, $data );
   gzclose( $zp );
}

function CleanTempDir($str)
{
  $file_search = glob($str);
  if (FALSE !== $file_search){
    foreach($file_search as $fn){
      unlink($fn);
    } 
  }
} 

//just debug,remove it!
// /*
function SetTempDir($temp)
{
  $ret=FALSE;
  if( $fp = fopen("$temp/upsdn_test.txt", 'w')) {
    fclose($fp);
    unlink("$temp/upsdn_test.txt");
    $this->temp_dir = $temp;
    $ret=TRUE;
  }
  return $ret;
}
// */

function multiupload()
{
  global $Web2Ftp;

  if ( isset($_POST['transfermode']) && ("ascii" == $_POST['transfermode']) )
      $Web2Ftp->SetTransMode(FTP_ASCII);
  for( $i = 0; $i < 5; $i++ ){
    if( 0 == $_FILES['files']['error'][$i] )
      $Web2Ftp->PutFileFromTemp( $_FILES['files']['name'][$i] , $_FILES['files']['tmp_name'][$i] );
  } 
}  

function InitZip()
{
  global $zip_obj,$ftp_temp;

  $zip_obj->SetZipTemp($ftp_temp);
  $zip_obj->RegisterCBFunc("MakeDirs","EndWrtie","GetZipList","GetFilePtr");
}

function zipdown()
{ 
  global $zip_obj,$user_id,$ftp_temp;
  InitZip();
  $zip_name = substr($_POST['itemname'], 0, -1);
  $zip_arch = $user_id."-".$zip_name.".zip";
  $zip_obj->CreateZip($zip_arch);
  $count = $zip_obj->ZipDir($zip_name);
  $zip_obj->AddCenteralDir($count);
  
  $result_info = "<a href='".$ftp_temp.$zip_arch."'>Download it</a>";
  OutPutInfo($result_info,0); 
}

function zipup()
{
  global $zip_obj;
  InitZip();
  $zip_obj->OpenZip($_FILES['fileup']['tmp_name']);
  $zip_obj->X_Archive();
}


//zipdown(user defined functions) :
//      download a dir ,pack it into a zip archive.
function GetZipList($sub_dir)
{
  global $Web2Ftp,$ftp_temp,$user_id;
  
  $Web2Ftp->SetWorkingDir("{$_POST['fullpath']}/{$sub_dir}");  
  $item_list = $Web2Ftp->GetList();
  //$item_list = $Web2Ftp->GetList($sub_dir);
  
  array_shift($item_list);
  array_shift($item_list);
  $item_count = count($item_list);
  $temp_name = $ftp_temp.$user_id;
  for ($i = 0; $i < $item_count;  $i ++) {
    if ($item_list[$i]['type'] !== 1){
      $Web2Ftp->GetFileToTemp($item_list[$i]['name'],$temp_name.$item_list[$i]['name']);
     }
    
  } 
  return $item_list;
}  

function GetFilePtr($obj,&$size)
{
  global $ftp_temp,$user_id;
  $temp_name = $ftp_temp.$user_id.basename($obj->file_name);
  if (($fp=fopen($temp_name, "rb")) == NULL) {
    $obj->err_info .= "Cannot add the file.";
    $obj->ProcessError(); 
  }
  $size = filesize($temp_name);  
  return $fp;
} 

//zip-up(user defined functions):
//     upload a zip archive,then unpack it at the ftp sever.
function MakeDirs($filename)
{
  global $Web2Ftp;
  $pth = explode("/",$filename);
  for($i=0,$tmp=""; isset($pth[$i]); $i++) {
    if (!$pth[$i]) 
      continue;
    @$Web2Ftp->MakeDir($tmp.$pth[$i]);
    $tmp.=$pth[$i]."/";
  }
} 

function EndWrtie($file,$temp)
{
  global $Web2Ftp;
  $Web2Ftp->PutFileFromTemp($file,$temp);
  unlink($temp);
}

?>
