<?php

# XML Type Data
class xmlPoll {

	function xmlPoll() {
		$this->loadFile();
	}

	function loadFile() {
		# Load main poll xml data file
		$this->xml = @simplexml_load_file(POLL_XML_BASE);
	}

	function loadList() {
		# Read all polls from polls xml data file
		foreach ($this->xml->poll as $poll) {
			$this->objList[] = $poll['pollId'];
		}
	}

	function addNewPoll() {
		$this->loadList();
    if (!isset($this->objList)) $this->objList = 0;
		$newId = $this->objList[count($this->objList)-1]+1;
		# Update polls
		$newPoll = $this->xml->addChild('poll', '_new poll');
		$newPoll->addAttribute('pollId', $newId);
    $newPoll->addAttribute('multiline', 0);
    $newPoll->addAttribute('width', 150);
    $newPoll->addAttribute('height', 200);
    $newPoll->addAttribute('skin', 'default');
    $newPoll->addAttribute('effect', 'full');
    $newPoll->addAttribute('fxspeed', '300');
    $newPoll->addAttribute('status', 1);
		$newPoll->addAttribute('votes', 0);
		$this->saveFile();
	}

	function savePolls($pollData) {
		if (!array_key_exists('pollId', $pollData)) return;  // no data
		$dataKeys = array_keys($pollData);
		# Loop through all polls
    $pollCounter = 0;
		foreach ($this->xml->poll as $poll) {
			$pollCounter++;
			# Check corresponding pollIds and match them with the counter (position)
			$matchId = array_search((string) $poll['pollId'], $pollData['pollId']);
			if (isset($matchId) && $matchId !== false) {
				foreach ($dataKeys as $dataKey) {
					# Check for title
					if ($dataKey != 'title') $this->xml->poll[$pollCounter-1][$dataKey] = $pollData[$dataKey][$matchId];
					else $this->xml->poll[$pollCounter-1] = $pollData[$dataKey][$matchId];
				}
				$this->saveFile();
			}
		}
	}

	function delPoll($pollId) {
    $pollCounter = 0;
		foreach ($this->xml->poll as $poll) {
			$pollCounter++;
			if ((string) $poll['pollId'] == $pollId) {
				unset($this->xml->poll[$pollCounter-1]);
				$this->saveFile();
				break;
			}
		}
	}

	function loadDetails($pollId) {
		# Load poll details
    $pollCount = 0;
		foreach ($this->xml->poll as $poll) {
			$pollCount++;
			if ((string) $poll['pollId'] == $pollId) {
				# Store returned position for saving
				$this->pos = $pollCount-1;
				$this->title = str_replace('[br]', '<br />', $poll);
				# Assign attribute fields to emulate db results
				$keys = get_object_vars($poll);
				$keys = array_keys($keys['@attributes']);
				foreach ($keys as $key) $this->$key = $poll[$key];
			}
		}
	}

	function saveFile() {
		# Save all data back main poll xml data file
		file_put_contents(POLL_XML_BASE,$this->xml->asXML());
	}

}

class xmlOptions {

	function xmlOptions() {
		$this->loadFile();
	}

	function loadFile() {
		# Load options xml data file
		$this->xml = @simplexml_load_file(POLL_XML_OPTIONS);
	}

	function loadList($pollId,$activeOnly=false) {
		# Read all related from options xml data file
		foreach ($this->xml->option as $option) {
			if ((string) $option['pollId'] == $pollId) {
				# Assign correct order, check for active
				if ($activeOnly) {
					if ($option['status'] == 1) {
            $optOrder[(int) $option['optionId']] = (int) $option['position'];
					}
				}
				else {
          $optOrder[(int) $option['optionId']] = (int) $option['position'];
				}
			}
		}
    @asort($optOrder);
    if (isset($optOrder) && is_array($optOrder)) {
      $newOrder = array_keys($optOrder);
      foreach ($newOrder as $optId) {
        $this->objList[] = $optId;
      }
    }
	}

	function loadListClean($pollId) {
		# Read all options without order - sort by optionId
		foreach ($this->xml->option as $option) {
			if ((string) $option['pollId'] == $pollId) {
				$this->objList[] = $option['optionId'];
			}
		}
	}

	function addNewOption($pollId) {
		# Get last optionId
		$this->loadListClean($pollId);
		$newId = (isset($this->objList)) ? $this->objList[count($this->objList)-1]+1 : 1;
    $newOrder = (isset($this->objList)) ? count($this->objList)+1 : 1;
		# Update polls
		$newOption = $this->xml->addChild('option', '_new option');
		$newOption->addAttribute('optionId', $newId);
		$newOption->addAttribute('pollId', $pollId);
		$newOption->addAttribute('position', $newOrder);
		$newOption->addAttribute('bullet', 1);
		$newOption->addAttribute('status', 1);
		$this->saveFile();
	}

	function saveOptions($optionData,$pollId) {
		if (!array_key_exists('optionId', $optionData)) return;  // no data
		$dataKeys = array_keys($optionData);
		# Loop through all options
    $optionCounter = 0;
		foreach ($this->xml->option as $option) {
			$optionCounter++;
			# Selected poll only
			if ((int) $option['pollId'] == $pollId) {
				# Check corresponding optionIds and match them with the counter (order)
				$matchId = array_search((string) $option['optionId'], $optionData['optionId']);
        if (isset($matchId) && $matchId !== false) {
					foreach ($dataKeys as $dataKey) {
						# Check for title
						if ($dataKey != 'title') $this->xml->option[$optionCounter-1][$dataKey] = $optionData[$dataKey][$matchId];
						else $this->xml->option[$optionCounter-1] = $optionData[$dataKey][$matchId];
					}
					$this->saveFile();
				}
			}
		}
	}

	function loadDetails($optionId,$pollId) {
		# Load option details
		foreach ($this->xml->option as $option) {
			if ((string) $option['optionId'] == $optionId && (string) $option['pollId'] == $pollId) {
				$this->title = $option;
				$this->title = str_replace('[br]', '<br />', $this->title);
				# Assign attribute fields to emulate db results
				$keys = get_object_vars($option);
				$keys = array_keys($keys['@attributes']);
				foreach ($keys as $key) $this->$key = $option[$key];
				return $this;
			}
		}
	}

	function delOption($optionId,$pollId) {
		# Get order to be removed
    $delCounter = 0;
		foreach ($this->xml->option as $option) {
			$delCounter++;
			if ((string) $option['optionId'] == $optionId && (string) $option['pollId'] == $pollId) {
				$delOrder = $option['position'];
				$delItem = $delCounter - 1;
				break;
			}
		}
		# Reread options for items with swapped order
    $optionCounter = 0;
		foreach ($this->xml->option as $option) {
			$optionCounter++;
			if ((string) $option['pollId'] == $pollId) {
				if ((string) $option['position'] > $delOrder) {
					$this->xml->option[$optionCounter-1]['position'] = $this->xml->option[$optionCounter-1]['position'] - 1;
				}
			}
		}
		unset($this->xml->option[$delItem]);
		$this->saveFile();
	}

	function delAllOptions($pollId) {
		# Delete all options for selected poll
    $optionCounter = 0;
		foreach ($this->xml->option as $option) {
			$optionCounter++;
			if ((string) $option['pollId'] == $pollId) {
				$delArr[] = $optionCounter-1;
			}
		}
		@rsort($delArr);
		if (is_array($delArr)) {
			foreach ($delArr as $delOption) {
				unset($this->xml->option[$delOption]);
			}
		}
		$this->saveFile();
	}

	function saveFile() {
		# Save all data back main poll xml data file
		file_put_contents(POLL_XML_OPTIONS,$this->xml->asXML());
	}

}

class xmlVotes {

	function xmlVotes() {
		$this->loadFile();
	}

	function loadFile() {
		# Load votes xml data file
		$this->xml = @simplexml_load_file(POLL_XML_VOTES);
	}

	function loadList($optionId,$pollId) {
		# Read all votes from votes xml data file
    if (isset($this->xml->vote)) {
		  foreach ($this->xml->vote as $vote) {
			  if ((string) $vote['optionId'] == $optionId && (string) $vote['pollId'] == $pollId) {
				  $this->voteCount++;
			  }
		  }
    }
	}

	function checkIP($pollId,$ipAddr) {
		# Check for existing IP address
    if (isset($this->xml->vote)) {
		  foreach ($this->xml->vote as $vote) {
			  if ($vote['pollId'] == $pollId) {
				  if ($vote->ipAddress == $ipAddr) {
					  # Check for time
					  $this->optionId = $vote['optionId'];
					  $this->voteTime = time() - strtotime($vote->voteTime);
					  if (POLL_VOTED_TIME > $this->voteTime) return true;
				  }
			  }
		  }
    }
	}

	function addVote($optionId,$pollId) {
    $voteId = (isset($votes->xml)) ? count($votes->xml) : 1;
		$newVote = $this->xml->addChild('vote');
		$newVote->addChild('ipAddress', $_SERVER['REMOTE_ADDR']);
		$newVote->addChild('voteTime', date('Y-m-d H:i:s'));
		$newVote->addAttribute('voteId', $voteId);
		$newVote->addAttribute('optionId', $optionId);
		$newVote->addAttribute('pollId', $pollId);
		$this->saveFile();
	}

	function delVotes($optionId,$pollId) {
		# Delete all votes for one option
    $voteCounter = 0;
		foreach ($this->xml->vote as $vote) {
			$voteCounter++;
			if ((string) $vote['optionId'] == $optionId && (string) $vote['pollId'] == $pollId) {
				$delArr[] = $voteCounter-1;
			}
		}
		@rsort($delArr);
		if (isset($delArr) && is_array($delArr)) {
			foreach ($delArr as $delVote) {
				unset($this->xml->vote[$delVote]);
			}
		}
		$this->saveFile();
	}

	function delAllVotes($pollId) {
		# Delete all options for selected poll
    $voteCounter = 0;
		foreach ($this->xml->vote as $vote) {
			$voteCounter++;
			if ((string) $vote['pollId'] == $pollId) {
				$delArr[] = $voteCounter-1;
			}
		}
		@rsort($delArr);
		if (isset($delArr) && is_array($delArr)) {
			foreach ($delArr as $delVote) {
				unset($this->xml->vote[$delVote]);
			}
		}
		$this->saveFile();
	}

	function saveFile() {
		# Save all data back main poll xml data file
		file_put_contents(POLL_XML_VOTES,$this->xml->asXML());
	}

}
?>