<?php
# Define classes
$pollClass = POLL_DATA.'Poll';
$optionClass = POLL_DATA.'Options';
$voteClass = POLL_DATA.'Votes';

# Load poll details
$poll = new $pollClass();
if (isset($pollId)) $poll->loadDetails($pollId);

# No poll found
if (!isset($poll->title)) {
  $poll->loadList();
  ?>
  <style type="text/css">@import "<?php echo POLL_WEB_ROOT.'skins/css.php'; ?>";</style>
  <div class="dracon_poll_list">
    <strong>Poll not found - pollId incorrect</strong>
    <?php 
    if (!substr_count($_SERVER['SCRIPT_NAME'], 'test.php')) {
    ?>
      <br /><br />
      <a href="test.php" class="dracon_poll" style="font-size:13px; color:#fff; padding:3px">Poll testing page</a>
    <?php } ?>
    <br /><br />
    Avaliable polls:
    <br /><br />
  <?php
  if (is_array($poll->objList)) {
    foreach($poll->objList as $pollId) echo '<a class="dracon_poll" href="?pollId='.$pollId.'" onclick="this.blur()">&nbsp;'.$pollId.'&nbsp;</a>&nbsp;';
  }
  echo '</div>';
  exit;
}                             
?>

<style type="text/css">@import "<?php echo POLL_WEB_ROOT.'skins/css.php?'.$pollId; ?>"; </style>

<div id="dracon_poll_<?php echo $pollId; ?>" style="width:<?php echo $poll->width; ?>px">

  <div class="dracon_poll_header">
    <div class="dracon_poll_h1"></div>
    <div class="dracon_poll_h2"></div>
    <div class="dracon_poll_h3">
      <?php $titleClass = ($poll->multiline != 1) ? 'dracon_poll_title_single' : 'dracon_poll_title_multi'; ?>
      <div class="dracon_poll_title <?php echo $titleClass; ?>">
        <?php echo $poll->title; ?>
      </div>
    </div>
  </div>
  <div style="clear:both"></div>
  
  <div class="dracon_poll_body" style="height:<?php echo $poll->height; ?>px">
    <div class="dracon_poll_b1"></div>
    <div class="dracon_poll_b2"></div>
    <div class="dracon_poll_b3">
      <div class="dracon_poll_loading"><img src="<?php echo POLL_WEB_ROOT.'skins/'.$poll->skin; ?>/gfx/loading.gif" /></div>
      <div class="dracon_poll_answers"></div>
      <div class="dracon_poll_options"> 

        <ul>
        
          <?php
          # Load poll options
          $options = new $optionClass();
          if (POLL_DATA == 'mysql') {
            $options->addWhere('pollId = '.$pollId);
            $options->addWhere('status = 1');  // only active
            $options->addOrder('position');
            $options->loadList();
          }
          else {
            $options->loadList($pollId,true);  // only active
          }
          # Display all active options sorted by order
          if (isset($options->objList) && is_array($options->objList)) {
            foreach($options->objList as $optionId) {
              $option = $options->loadDetails($optionId,$pollId);
              if (POLL_DATA == 'mysql') $option->order = $option->position;
          ?>
            <li class="dracon_poll_option_<?php echo $option->bullet; ?>" title="dracon_pollVote(<?php echo $pollId; ?>,<?php echo $option->optionId; ?>,false,<?php echo $poll->fxspeed; ?>,'<?php echo $poll->effect; ?>')"><?php echo $option->title; ?></li>
          <?php
            }
          }
          ?>
          
        </ul>
      </div>
    </div>
  </div>
  <div style="clear:both"></div>
  
  <div class="dracon_poll_footer">
    <div class="dracon_poll_f1"></div>
    <div class="dracon_poll_f2"></div>
    <div class="dracon_poll_f3">
      <div class="dracon_poll_info"> 
        <a id="dracon_<?php echo $pollId; ?>" href="http://www.dracon.biz" target="_blank" onclick="this.blur()" title="Powered by Dracon">&copy; Dracon</a>
        <span class="dracon_poll_votes"><?php echo $poll->votes; ?></span> votes
      </div>
    </div>
  </div>
  <div style="clear:both"></div>

</div>

<?php
# Check for IP address in related votes - ANIMATED
$ipAddr = $_SERVER['REMOTE_ADDR'];
$votes = new $voteClass();
if ($votes->checkIP($pollId,$ipAddr) || $poll->status == 0) {
  $aniSpeed = (POLL_VOTED_SKIP_ANI) ? 0 : $poll->fxspeed;
  echo '<div class="dracon_poll_voted hidden">dracon_pollVote('.$pollId.',0,true,'.$aniSpeed.',"'.$poll->effect.'")</div>';
}
?>