<?php

namespace CSSTidy\Element;

abstract class Block extends Element
{
    /** @var \CSSTidy\Element\Element[] */
    public $elements = array();

    /**
     * @param Property $property
     */
    public function addProperty(Property $property)
    {
        $name = $property->getName();
        while (isset($this->elements[$name])) {
            $name .= ' ';
        }

        $this->elements[$name] = $property;
    }

    /**
     * @param array $properties
     */
    public function setProperties(array $properties)
    {
        foreach ($properties as $property) {
            $this->addProperty($property);
        }
    }

    /**
     * @param Property $property
     * @return bool
     */
    public function removeProperty(Property $property)
    {
        $name = $property->getName();
        while (isset($this->elements[$name])) {
            if ($this->elements[$name] === $property) {
                unset($this->elements[$name]);
                return true;
            }

            $name .= ' ';
        }

        return false;
    }

    /**
     * @param Comment $comment
     */
    public function addComment(Comment $comment)
    {
        $this->elements[] = $comment;
    }

    /**
     * @param Elements[] $elements
     */
    public function mergeElements(array $elements)
    {
        foreach ($elements as $element) {
            if ($element instanceof Property) {
                $elementName = $element->getName();
                if (isset($this->elements[$elementName]) && $this->elements[$elementName] === false) {
                    $this->elements[$elementName] = $element;
                } else {
                    $this->addProperty($element);
                }
            } else {
                $this->elements[] = $element;
            }
        }
    }

    /**
     * @abstract
     * @return string
     */
    abstract public function getName();
}