<?php

namespace CSSTidy\Element;

abstract class Element
{
    /**
     * Number of line in file, which contains element in input CSS file
     * @var int
     */
    public $line;

    /**
     * @param array $subValues
     * @return string
     */
    protected function mergeSubValues(array $subValues)
    {
        $prev = false;
        $output = '';

        foreach ($subValues as $subValue) {
            if ($subValue === ',') {
                $prev = true;
            } else if (!$prev) {
                $output .= ' ';
            } else {
                $prev = false;
            }
            $output .= $subValue;
        }

        return ltrim($output, ' ');
    }
}