<?php

namespace CSSTidy\Element;

class LineAt extends Element
{
    /** @var string */
    public $subValues;

    /** @var string */
    protected $value;

    /**
     * @param string $name
     * @param array $value
     */
    public function __construct($name, array $value)
    {
        $this->name = $name;
        $this->subValues = $value;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $value
     */
    public function setValue($value)
    {
        $this->value = $value;
    }

    /**
     * @return string
     */
    public function getValue()
    {
        if (!isset($this->value)) {
            $this->value = ' ' . $this->mergeSubValues($this->subValues);
        }

        return $this->value;
    }

    /**
     * @return string
     */
    public function __toString()
    {
        return "@{$this->getName()}{$this->getValue()};";
    }
}