<?php

namespace CSSTidy\Element;

class Selector extends Block
{
    /** @var string */
    protected $name;

    /** @var array */
    public $subSelectors = array();

    /**
     * @param string $name
     */
    public function __construct($name)
    {
        $this->name = $name;
    }

    /**
     * @param string $name
     */
    public function appendSelectorName($name)
    {
        $this->subSelectors[] = $name;
        $this->name .= ',' . $name;
    }

    /**
     * @param $name
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param Selector $selector
     * @return bool True, if $selector has same properties as $this
     */
    public function hasSameProperties(Selector $selector)
    {
        return $this->propertiesToArray($this) == $this->propertiesToArray($selector);
    }

    /**
     * Return Selector properties in format for comparing with other selector
     * @see hasSameProperties()
     * @param Selector $selector
     * @return array in format ['color:red', 'font-weight:bold]
     */
    protected function propertiesToArray(Selector $selector)
    {
        $output = array();
        foreach ($selector->elements as $element) {
            if ($element instanceof Property) {
                /** @var Property $element */
                $output[] = "{$element->getName()}:{$element->getValue()}";
            }
        }

        return $output;
    }
}