<?php

if (! defined ( 'BASEPATH' ))
	exit ( 'No direct script access allowed' );
class Info extends CI_Controller {
	function __construct() {
		parent::__construct ();
	}
	public function index() {
		if ($this->session->userdata ( 'manage_role' ) == '') {
			header ( "Content-Type:text/html;charset=utf-8" );
			echo '<script>alert("请登录 ！");';
			echo 'window.location.href="' . site_url ( 'index' ) . '";</script>';
			exit ();
		}
		
		redirect ( site_url ( 'info/info_add' ) );
	}
	
	/**
	 * 患者列表 start
	 */
	// =============== 患者 列表 ========================
	public function info_list($page = 1) {
		$status ['where'] = $_SERVER ['HTTP_REFERER']; // 来源地址
		if ($this->session->userdata ( 'manage_role' ) == '') {
			header ( "Content-Type:text/html;charset=utf-8" );
			echo '<script>alert("请登录 ！");';
			echo 'window.location.href="' . site_url ( 'index' ) . '";</script>';
			exit ();
		}
		
		date_default_timezone_set ( 'Asia/Shanghai' );
		
		/*
		 * 判断参数$page 大小start
		 */
		if ($page < 1) {
			$page = 1;
		} else {
			$page = intval( $page );
		}
		
		$num = 20; // 每页条数
		$offset = ($page - 1) * $num;
		
		$this->load->model ( 'Data_model' );
		$list ['list'] = $this->Data_model->get_data_bypage ( 'id desc', 'huanzhe', $num, $offset );
		
		$data ['title'] = '患者列表 - ';
		$data ['curbig'] = 1; // current
		$data ['cursmal'] = 12; // class="current"
		
		$list ['info'] = '患者';
		$list ['total_rows'] = $this->db->count_all ( 'huanzhe' );
		
		$config ['page_url'] = 'info/info_list';
		$config ['page_size'] = $num;
		$config ['rows_num'] = $this->db->count_all ( 'huanzhe' );
		$config ['page_num'] = $page;
		$this->load->library ( 'Custom_pagination' );
		$this->custom_pagination->init ( $config );
		$list ['fenye'] = $this->custom_pagination->create_links ();
		
		$this->load->view ( 'menu', $data );
		$this->load->view ( 'info_list', $list );
	}
	
	
	// =============== 患者 添加 ========================
	public function info_add() {
		$status ['where'] = $_SERVER ['HTTP_REFERER']; // 来源地址
		if ($this->session->userdata ( 'manage_role' ) == '') {
			header ( "Content-Type:text/html;charset=utf-8" );
			echo '<script>alert("请登录 ！");';
			echo 'window.location.href="' . site_url ( 'index' ) . '";</script>';
			exit ();
		}

		if($this->session->userdata('manage_role')=='10' || ($this->session->userdata('manage_role')=='1') ){
		}else{
			header ( "Content-Type:text/html;charset=utf-8" );
			echo '<script>alert("你没有权限 ！");';
			echo 'window.location.href="' . site_url ( 'info/info_list' ) . '";</script>';
			exit ();
		}
		
		$list ['author_id']=$this->session->userdata('manage_id');
		
		$this->load->model ( 'Data_model' );
		
		$data ['title'] = '患者添加 - ';
		$data ['curbig'] = 1; // current
		$data ['cursmal'] = 11; // class="current"
		
		$list ['info'] = '患者';
		$list ['action'] = 'add';
		
		$this->load->view ( 'menu', $data );
		$this->load->view ( 'info_edit', $list );
	}
	
	// =============== 添加 患者 do ========================
	public function info_adddo() {
		if ($this->session->userdata ( 'manage_role' ) == '') {
			header ( "Content-Type:text/html;charset=utf-8" );
			echo '<script>alert("请登录 ！");';
			echo 'window.location.href="' . site_url ( 'index' ) . '";</script>';
			exit ();
		}

		if($this->session->userdata('manage_role')=='10' || ($this->session->userdata('manage_role')=='1') ){
		}else{
			header ( "Content-Type:text/html;charset=utf-8" );
			echo '<script>alert("你没有权限 ！");';
			echo 'window.location.href="' . site_url ( 'info/info_list' ) . '";</script>';
			exit ();
		}
		
		date_default_timezone_set ( 'Asia/Shanghai' );
		
		$status ['where'] = $_SERVER ['HTTP_REFERER']; // 来源地址
		
		$addData=array();
		foreach ($_POST as $k=>$v){
			if($k !='imgFile'){
				$addData[$k]=trim($v);
			}
		}

		if ($_POST['truename']=='') {
			$status ['msg'] = '请填写姓名！';
			header ( "Content-Type:text/html;charset=utf-8" );
			echo '<script>alert("请填写完整！");';
			echo 'window.location.href="' . $status ['where'] . '";</script>';
			exit ();
		}
		
		$this->load->model ( 'Data_model' );		
		$this->db->trans_start();		
				
		$data ['title'] = '患者 - ';
		$data ['curbig'] = 1; // current
		$data ['cursmal'] = 11; // class="current"
		
		$time=time();
		$addData['create_time']=$time;
		$addData['update_time']=$time;
		$KSId=$this->Data_model->insert_data ( $addData, 'huanzhe' );		
		$this->db->trans_complete();
		
		$status ['msg'] = '添加成功！';
		$status ['where'] = site_url("info/info_add/");
		
		$this->load->view ( 'status', $status );
	}
	
	// =============== 患者 编辑 ========================
	public function info_edit($id = 1) {
		$status ['where'] = $_SERVER ['HTTP_REFERER']; // 来源地址
		if ($this->session->userdata ( 'manage_role' ) == '') {
			header ( "Content-Type:text/html;charset=utf-8" );
			echo '<script>alert("请登录 ！");';
			echo 'window.location.href="' . site_url ( 'index' ) . '";</script>';
			exit ();
		}
		
		
		$id = intval(trim(htmlspecialchars ( $id )));
		$list ['author_id']=$this->session->userdata('manage_id');
		
		$this->load->model ( 'Data_model' );
		$list ['list'] = $this->Data_model->get_adata ( $id, 'huanzhe' );
		
		if($this->session->userdata('manage_role')=='10' || (($this->session->userdata('manage_role')=='1') && (time()-$list['list']['create_time'])<30*60)){
		}else{
			header ( "Content-Type:text/html;charset=utf-8" );
			echo '<script>alert("你没有权限 ！");';
			echo 'window.location.href="' . site_url ( 'info/info_list' ) . '";</script>';
			exit ();
		}
		
		$data ['title'] = '患者编辑 - ';
		$data ['curbig'] = 1; // current
		$data ['cursmal'] = 12; // class="current"
		
		$list ['info'] = '患者';
		$list ['action'] = 'edit';
		
		$this->load->view ( 'menu', $data );
		$this->load->view ( 'info_edit', $list );
	}
	
	
	// =============== 患者 编辑 do ========================
	public function info_editdo($id = 1) {
		
		if ($this->session->userdata ( 'manage_role' ) == '') {
			header ( "Content-Type:text/html;charset=utf-8" );
			echo '<script>alert("请登录 ！");';
			echo 'window.location.href="' . site_url ( 'index' ) . '";</script>';
			exit ();
		}
		
		if ($this->input->post('truename')=='') {
			$status ['msg'] = '请填写姓名！';
			header ( "Content-Type:text/html;charset=utf-8" );
			echo '<script>alert("请填写完整！");';
			echo 'window.location.href="' . $status ['where'] . '";</script>';
			exit ();
		}
		
		$status ['where'] = $_SERVER ['HTTP_REFERER']; // 来源地址
		$id = intval(trim(htmlspecialchars ( $id )));

		
		$editData['truename']=trim(htmlspecialchars($this->input->post('truename')));
		$editData['sex']=trim(htmlspecialchars($this->input->post('sex')));
		$editData['birthday']=trim(htmlspecialchars($this->input->post('birthday')));
		$editData['zhiye']=trim(htmlspecialchars($this->input->post('zhiye')));
		$editData['danwei']=trim(htmlspecialchars($this->input->post('danwei')));
		$editData['address']=trim(htmlspecialchars($this->input->post('address')));
		$editData['zip']=trim(htmlspecialchars($this->input->post('zip')));
		$editData['tel1']=trim(htmlspecialchars($this->input->post('tel1')));
		$editData['tel2']=trim(htmlspecialchars($this->input->post('tel2')));
		$editData['tel3']=trim(htmlspecialchars($this->input->post('tel3')));
		$editData['zhenduan']=trim(htmlspecialchars($this->input->post('zhenduan')));
		$editData['firstzhengzhuangdate']=trim(htmlspecialchars($this->input->post('firstzhengzhuangdate')));
		$editData['firstjiuzhendate']=trim(htmlspecialchars($this->input->post('firstjiuzhendate')));
		$editData['firstquezhendate']=trim(htmlspecialchars($this->input->post('firstquezhendate')));
		$editData['quezhenyiyuan']=trim(htmlspecialchars($this->input->post('quezhenyiyuan')));
		$editData['zhenduanyiju1']=trim(htmlspecialchars($this->input->post('zhenduanyiju1')));
		$editData['zhenduanyiju2']=trim(htmlspecialchars($this->input->post('zhenduanyiju2')));
		$editData['zhenduanyiju3']=trim(htmlspecialchars($this->input->post('zhenduanyiju3')));
		$editData['zhenduanyiju4']=trim(htmlspecialchars($this->input->post('zhenduanyiju4')));
		$editData['zhenduanyiju5']=trim(htmlspecialchars($this->input->post('zhenduanyiju5')));
		$editData['zhenduanyiju6']=trim(htmlspecialchars($this->input->post('zhenduanyiju6')));
		$editData['zhenduanyiju7']=trim(htmlspecialchars($this->input->post('zhenduanyiju7')));
		$editData['zhenduanyiju8']=trim(htmlspecialchars($this->input->post('zhenduanyiju8')));
		$editData['zhenduanyiju9']=trim(htmlspecialchars($this->input->post('zhenduanyiju9')));
		$editData['zhenduanyiju10']=trim(htmlspecialchars($this->input->post('zhenduanyiju10')));
		$editData['zhenduanyiju11']=trim(htmlspecialchars($this->input->post('zhenduanyiju11')));
		$editData['photo']=trim(htmlspecialchars($this->input->post('photo')));
		$editData['author_id']=$this->session->userdata('manage_id');
		
				
		$this->load->model ( 'Data_model' );		
		
		$huanzheData = $this->Data_model->get_adata ( $id, 'huanzhe' );
		if($this->session->userdata('manage_role')=='10' || (($this->session->userdata('manage_role')=='1') && (time()-$huanzheData['create_time'])<30*60)){		
		}else{
			header ( "Content-Type:text/html;charset=utf-8" );
			echo '<script>alert("你没有权限 ！");';
			echo 'window.location.href="' . site_url ( 'info/info_list' ) . '";</script>';
			exit ();
		}
		
		
		
		$time=time();
		$editData['update_time']=$time;
		
		$this->db->trans_start();				
		$this->Data_model->update_data ( $id, $editData, 'huanzhe' );
		$this->db->trans_complete();
		
		$data ['title'] = '患者 - ';
		$data ['curbig'] = 1; // current
		$data ['cursmal'] = 12; // class="current"
		
		$status ['msg'] = '编辑患者成功！';
		$this->load->view ( 'status', $status );
	}
	
	
	public function info_view($id = 1) {
		$status ['where'] = $_SERVER ['HTTP_REFERER']; // 来源地址
		if ($this->session->userdata ( 'manage_role' ) == '') {
			header ( "Content-Type:text/html;charset=utf-8" );
			echo '<script>alert("请登录 ！");';
			echo 'window.location.href="' . site_url ( 'index' ) . '";</script>';
			exit ();
		}
	
	
		$id = intval(trim(htmlspecialchars ( $id )));
		$list ['author_id']=$this->session->userdata('manage_id');
	
		$this->load->model ( 'Data_model' );
		$list ['list'] = $this->Data_model->get_adata ( $id, 'huanzhe' );
	
	
		$data ['title'] = '患者查看 - ';
		$data ['curbig'] = 1; // current
		$data ['cursmal'] = 12; // class="current"
	
		$list ['info'] = '患者';
		$list ['action'] = 'edit';
	
		$this->load->view ( 'menu', $data );
		$this->load->view ( 'info_view', $list );
	}
	
	
	// =============== 患者 删除 ========================
	public function info_del($id) {
		if ($this->session->userdata ( 'manage_role' ) == '') {
			header ( "Content-Type:text/html;charset=utf-8" );
			echo '<script>alert("请登录 ！");';
			echo 'window.location.href="' . site_url ( 'index' ) . '";</script>';
			exit ();
		}
		if ($this->session->userdata ( 'manage_role' ) != '10') {
			header ( "Content-Type:text/html;charset=utf-8" );
			echo '<script>alert("您没有此操作权限 ！");';
			echo 'window.location.href="' . site_url ( 'index' ) . '";</script>';
			exit ();
		}
		
		$status ['where'] = $_SERVER ['HTTP_REFERER']; // 来源地址
		$id = intval(trim(htmlspecialchars ( $id )));
		$data ['title'] = '患者删除 - ';
		$data ['curbig'] = 1; // current
		$data ['cursmal'] = 12; // class="current"
		$list ['info'] = '患者';
		
		if ($id == '') {
			$status ['msg'] = 'id不能为空！';
			header ( "Content-Type:text/html;charset=utf-8" );
			echo '<script>alert("删除的id不能为空！");';
			echo 'window.location.href="' . $status ['where'] . '";</script>';
			exit ();
		}
		
		$this->load->model ( 'Data_model' );
		$infoData = $this->Data_model->get_adata($id, 'huanzhe' );

		if (!$infoData) {
			$status ['msg'] = '不存在该患者！';
			header ( "Content-Type:text/html;charset=utf-8" );
			echo '<script>alert("不存在该患者！");';
			echo 'window.location.href="' . $status ['where'] . '";</script>';
			exit ();
		}
		
				
		$data ['query'] = $this->Data_model->delete_data($id, 'huanzhe' );
		$status ['msg'] = '删除成功！';
		
		$this->load->view ( 'status', $status );
	}
	
	
	
	public function exportall() {
		if ($this->session->userdata ( 'manage_role' ) == '') {
			header ( "Content-Type:text/html;charset=utf-8" );
			echo '<script>alert("请登录 ！");';
			echo 'window.location.href="' . site_url ( 'index' ) . '";</script>';
			exit ();
		}
		
	
		$this->load->model ( 'Data_model' );
		$list  = $this->Data_model->get_data( 'id desc', 'huanzhe' );
	
		$fileName=date('Y-m-d_His').'.xls';
	
		require_once(dirname(__FILE__).'/phpexcel/PHPExcel.php');//加载PHPExcel
		header('Content-Type: application/vnd.ms-excel');
		header("Content-Disposition:attachment; filename=".$fileName);
		header('Cache-Control: max-age=0');
		$objPHPExcel = new PHPExcel();
		// Set properties
		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1', 'id');
	
		$objPHPExcel->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);
		$objPHPExcel->getActiveSheet()->getStyle('B1')->getFont()->setBold(true);
		$objPHPExcel->getActiveSheet()->getStyle('B1')->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_TEXT); //设置为文本格式
	
	
		$i=2;
		foreach($list as $key=>$val){					
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$i, ' '.$val['id']);
			$i++;
		}
	
	
		$objWriter = new PHPExcel_Writer_Excel5($objPHPExcel);
		$objWriter->save('php://output');//输出到浏览器
		exit;
	}
}
?>