<?php
/**
* @project ApPHP Business Directory
* @copyright (c) 2011 ApPHP
* @author ApPHP <info@apphp.com>
* @license http://www.gnu.org/licenses/
*/

// *** Make sure the file isn't accessed directly
defined('APPHP_EXEC') or die('Restricted Access');
//--------------------------------------------------------------------------

if($objLogin->IsLoggedInAsCustomer()){

	$submit = isset($_POST['submit']) ? prepare_input($_POST['submit']) : '';
	$msg = '';
	$account_deleted = false;
	
	if($submit == 'remove'){                
		if(strtolower(SITE_MODE) == 'demo'){
			$msg = draw_important_message(_OPERATION_BLOCKED, false);
		}else{
			if($objLogin->RemoveAccount()){
				$msg = draw_success_message(_ACCOUNT_WAS_DELETED, false);
				$account_deleted = true;
		
				////////////////////////////////////////////////////////////////
				send_email(
					$objLogin->GetLoggedEmail(),
					$objSettings->GetParameter('admin_email'),
					'account_deleted_by_user',
					array(
						'{USER NAME}'  => $objLogin->GetLoggedName(),
					),
					$objLogin->GetPreferredLang()
				);
				////////////////////////////////////////////////////////////

				$objSession->EndSession();
			}else{
				$msg = draw_important_message(_DELETING_ACCOUNT_ERROR, false);
			}			
		}
	}
   
	draw_title_bar(prepare_breadcrumbs(array(_MY_ACCOUNT=>'',_REMOVE_ACCOUNT=>'')));
	
?>
	<form action="index.php" method="post" id="frmLogout" style="display:inline; margin-top:0px; padding-top:0px;">
		<?php draw_hidden_field('submit_logout', 'logout'); ?>
		<?php draw_token_field(); ?>
	</form>
		
	<form action="index.php?customer=remove_account" method="post" name="frmProfile" onsubmit="return confirm('<?php echo _REMOVE_ACCOUNT_ALERT; ?>');">
		<?php draw_hidden_field('submit', 'remove'); ?>
		<?php draw_token_field(); ?>
		<br />
		<?php        
			echo $msg;
			if($account_deleted){
				echo '<script type="text/javascript">setTimeout(function(){appFormSubmit("frmLogout")}, 5000);</script>';				
			}else{                            
				draw_message(_REMOVE_ACCOUNT_WARNING);                                                
			}        
		?>
		<?php if(!$account_deleted){ ?>
		<table align="center" border="0" cellspacing="1" cellpadding="2" width="98%">
		<tr><td colspan="3">&nbsp;</td></tr>            
		<tr>
			<td align="left" colspan="2">
				<input type="button" class="form_button" value="<?php echo _BUTTON_CANCEL; ?>" onclick="javascript:appGoTo('customer=my_account');" />
			</td>
			<td align="right">
				<input type="submit" class="form_button" name="btnSubmitPD" id="btnSubmitPD" value="<?php echo _REMOVE; ?>" />
			</td>
		</tr>
		<tr><td colspan="3">&nbsp;</td></tr>            
		</table>
		<?php } ?>
	</form>

<?php
}else if($objLogin->IsLoggedIn()){
    draw_title_bar(prepare_breadcrumbs(array(_CUSTOMER=>'', _REMOVE_ACCOUNT=>'')));
    draw_important_message(_NOT_AUTHORIZED);
}else{
    draw_title_bar(prepare_breadcrumbs(array(_CUSTOMER=>'', _REMOVE_ACCOUNT=>'')));
    draw_important_message(_MUST_BE_LOGGED);
}
?>