﻿
DROP TABLE IF EXISTS `<DB_PREFIX>accounts`;
CREATE TABLE IF NOT EXISTS `<DB_PREFIX>accounts` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `first_name` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `last_name` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `user_name` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `password` varchar(50) CHARACTER SET latin1 NOT NULL DEFAULT '',
  `email` varchar(70) CHARACTER SET latin1 NOT NULL,
  `account_type` enum('owner','mainadmin','admin') CHARACTER SET latin1 NOT NULL DEFAULT 'mainadmin',
  `preferred_language` varchar(2) CHARACTER SET latin1 NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_lastlogin` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

INSERT INTO `<DB_PREFIX>accounts` (`id`, `first_name`, `last_name`, `user_name`, `password`, `email`, `account_type`, `preferred_language`, `date_created`, `date_lastlogin`, `is_active`) VALUES
(1, 'John', 'Smith', '<USER_NAME>', <PASSWORD>, '<USER_EMAIL>', 'owner', 'en', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1);


DROP TABLE IF EXISTS `<DB_PREFIX>advertise_plans`;
CREATE TABLE IF NOT EXISTS `<DB_PREFIX>advertise_plans` (
  `id` tinyint(3) NOT NULL AUTO_INCREMENT,
  `listings_count` smallint(6) unsigned NOT NULL DEFAULT '1',
  `categories_count` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `business_name` tinyint(10) unsigned NOT NULL DEFAULT '1',
  `business_description` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `logo` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `images_count` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `video_link` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `phone` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `address` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `map` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `keywords_count` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `inquiries_count` tinyint(1) NOT NULL DEFAULT '1',
  `inquiry_button` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `rating_button` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00',
  `duration` smallint(6) NOT NULL DEFAULT '1' COMMENT 'in days',
  `is_default` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=5 ;

INSERT INTO `<DB_PREFIX>advertise_plans` (`id`, `listings_count`, `categories_count`, `business_name`, `business_description`, `logo`, `images_count`, `video_link`, `phone`, `address`, `map`, `keywords_count`, `inquiries_count`, `inquiry_button`, `rating_button`, `price`, `duration`, `is_default`) VALUES
(1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, '0.00', 365, 1),
(2, 5, 1, 1, 1, 0, 0, 0, 1, 1, 1, 3, 0, 0, 0, '10.00', 720, 0),
(3, 10, 3, 1, 1, 1, 1, 0, 1, 1, 1, 15, 20, 1, 1, '20.00', 1825, 0),
(4, 100, 5, 1, 1, 1, 3, 1, 1, 1, 1, 50, -1, 1, 1, '30.00', -1, 0);


DROP TABLE IF EXISTS `<DB_PREFIX>advertise_plans_description`;
CREATE TABLE IF NOT EXISTS `<DB_PREFIX>advertise_plans_description` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `advertise_plan_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `language_id` varchar(2) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'en',
  `name` varchar(125) COLLATE utf8_unicode_ci NOT NULL,
  `description` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `listing_plan_id` (`advertise_plan_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=13 ;

INSERT INTO `<DB_PREFIX>advertise_plans_description` (`id`, `advertise_plan_id`, `language_id`, `name`, `description`) VALUES
(1, 1, 'de', 'Frei', 'Kostenlos werben Plan. Dieser Plan garantiert eine minimale Funktionen, aber frei.'),
(2, 1, 'es', 'Libre', 'Gratis plan de publicidad. Este plan ofrece una serie de características mínimas, pero libres.'),
(3, 1, 'en', 'Free', 'Free advertise plan. This plan offers a minimal features, but free.'),
(4, 2, 'en', 'Bronze', 'A step up from free advertise plan. More features available.'),
(5, 2, 'es', 'Bronce', 'Un paso adelante sin plan de publicidad. Otras características disponibles.'),
(6, 2, 'de', 'Bronze', 'Ein Schritt aus freien Werben Plan. Weitere Features zur Verfügung.'),
(7, 3, 'en', 'Silver', 'More features and details are allowed and are listed higher in results.'),
(8, 3, 'es', 'Plata', 'Más características y los detalles se les permite y se enumeran más alto en los resultados.'),
(9, 3, 'de', 'Silber', 'Weitere Merkmale und Einzelheiten sind zulässig und werden in höheren Ergebnissen aufgelistet.'),
(10, 4, 'en', 'Gold', 'This advertise plan provides maximum features and benefits.'),
(11, 4, 'es', 'Oro', 'Este plan de publicidad ofrece máximas prestaciones y beneficios.'),
(12, 4, 'de', 'Gold', 'Dieses Werben Plan bietet ein Maximum an Funktionen und Vorteile.');


DROP TABLE IF EXISTS `<DB_PREFIX>banlist`;
CREATE TABLE IF NOT EXISTS `<DB_PREFIX>banlist` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ban_item` varchar(70) CHARACTER SET latin1 NOT NULL,
  `ban_item_type` enum('IP','Email') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'IP',
  `ban_reason` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ban_ip` (`ban_item`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;


DROP TABLE IF EXISTS `<DB_PREFIX>banners`;
CREATE TABLE IF NOT EXISTS `<DB_PREFIX>banners` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `image_file` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `image_file_thumb` varchar(70) COLLATE utf8_unicode_ci NOT NULL,
  `priority_order` tinyint(1) NOT NULL DEFAULT '0',
  `link_url` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `priority_order` (`priority_order`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;


DROP TABLE IF EXISTS `<DB_PREFIX>banners_description`;
CREATE TABLE IF NOT EXISTS `<DB_PREFIX>banners_description` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `banner_id` int(10) unsigned NOT NULL DEFAULT '0',
  `language_id` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `image_text` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;


DROP TABLE IF EXISTS `<DB_PREFIX>categories`;
CREATE TABLE IF NOT EXISTS `<DB_PREFIX>categories` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `icon` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `icon_thumb` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `listings_count` smallint(10) unsigned NOT NULL DEFAULT '0',
  `listings_count_public` smallint(6) unsigned NOT NULL DEFAULT '0',
  `priority_order` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `parent_id` (`parent_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=5 ;

INSERT INTO `<DB_PREFIX>categories` (`id`, `parent_id`, `icon`, `icon_thumb`, `listings_count`, `listings_count_public`, `priority_order`) VALUES
(1, 0, 'ov7k2d5x6jtkkcids113.jpg', 'ov7k2d5x6jtkkcids113_thumb.jpg', 1, 1, 0),
(2, 1, '', '', 1, 1, 3),
(3, 0, 'd7dv9n8jqnn4v6147pyf.png', 'd7dv9n8jqnn4v6147pyf_thumb.jpg', 1, 1, 1),
(4, 0, 'kqcu80iddm06ytxw05xn.png', 'kqcu80iddm06ytxw05xn_thumb.jpg', 0, 0, 2);


DROP TABLE IF EXISTS `<DB_PREFIX>categories_description`;
CREATE TABLE IF NOT EXISTS `<DB_PREFIX>categories_description` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `category_id` int(10) NOT NULL DEFAULT '0',
  `language_id` varchar(2) CHARACTER SET latin1 NOT NULL DEFAULT 'en',
  `name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `language_id` (`category_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=13 ;

INSERT INTO `<DB_PREFIX>categories_description` (`id`, `category_id`, `language_id`, `name`, `description`) VALUES
(1, 1, 'en', 'Computers', 'Computers'),
(2, 1, 'es', 'Computadoras', 'Computadoras'),
(3, 1, 'de', 'Computer', 'Computer'),
(4, 3, 'en', 'Business Services', 'Business Services'),
(5, 3, 'es', 'Servicios las empresas', 'Servicios a las empresas'),
(6, 3, 'de', 'Business Services', 'Business Services'),
(7, 4, 'en', 'Real Estate', 'Real Estate'),
(8, 4, 'es', 'Bienes raíces', 'Bienes raíces'),
(9, 4, 'de', 'Immobilien', 'Immobilien'),
(10, 2, 'de', 'Monitore', 'Monitore'),
(11, 2, 'es', 'Monitores', 'Monitores'),
(12, 2, 'en', 'Monitors', 'Monitors');


DROP TABLE IF EXISTS `<DB_PREFIX>comments`;
CREATE TABLE IF NOT EXISTS `<DB_PREFIX>comments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `article_id` int(10) NOT NULL DEFAULT '0',
  `user_id` int(10) NOT NULL DEFAULT '0',
  `user_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `user_email` varchar(70) CHARACTER SET latin1 NOT NULL,
  `comment_text` text COLLATE utf8_unicode_ci NOT NULL,
  `date_created` datetime NOT NULL,
  `is_published` tinyint(1) NOT NULL DEFAULT '0',
  `date_published` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `article_id` (`article_id`,`user_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

INSERT INTO `<DB_PREFIX>comments` (`id`, `article_id`, `user_id`, `user_name`, `user_email`, `comment_text`, `date_created`, `is_published`, `date_published`) VALUES
(1, 52, 0, 'John Smith', 'j.smith@email.me', 'This is a very good site!', '2013-02-13 16:06:08', 1, '2013-02-13 16:06:18');


DROP TABLE IF EXISTS `<DB_PREFIX>countries`;
CREATE TABLE IF NOT EXISTS `<DB_PREFIX>countries` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `abbrv` varchar(2) CHARACTER SET latin1 NOT NULL,
  `name` varchar(70) COLLATE utf8_unicode_ci NOT NULL,
  `is_active` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `is_default` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `priority_order` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `abbrv` (`abbrv`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=238 ;

INSERT INTO `<DB_PREFIX>countries` (`id`, `abbrv`, `name`, `is_active`, `is_default`, `priority_order`) VALUES
(1, 'AF', 'Afghanistan', 1, 0, 0),
(2, 'AL', 'Albania', 1, 0, 0),
(3, 'DZ', 'Algeria', 1, 0, 0),
(4, 'AS', 'American Samoa', 1, 0, 0),
(5, 'AD', 'Andorra', 1, 0, 0),
(6, 'AO', 'Angola', 1, 0, 0),
(7, 'AI', 'Anguilla', 1, 0, 0),
(8, 'AQ', 'Antarctica', 1, 0, 0),
(9, 'AG', 'Antigua and Barbuda', 1, 0, 0),
(10, 'AR', 'Argentina', 1, 0, 0),
(11, 'AM', 'Armenia', 1, 0, 0),
(12, 'AW', 'Aruba', 1, 0, 0),
(13, 'AU', 'Australia', 1, 0, 0),
(14, 'AT', 'Austria', 1, 0, 0),
(15, 'AZ', 'Azerbaijan', 1, 0, 0),
(16, 'BS', 'Bahamas', 1, 0, 0),
(17, 'BH', 'Bahrain', 1, 0, 0),
(18, 'BD', 'Bangladesh', 1, 0, 0),
(19, 'BB', 'Barbados', 1, 0, 0),
(20, 'BY', 'Belarus', 1, 0, 0),
(21, 'BE', 'Belgium', 1, 0, 0),
(22, 'BZ', 'Belize', 1, 0, 0),
(23, 'BJ', 'Benin', 1, 0, 0),
(24, 'BM', 'Bermuda', 1, 0, 0),
(25, 'BT', 'Bhutan', 1, 0, 0),
(26, 'BO', 'Bolivia', 1, 0, 0),
(27, 'BA', 'Bosnia and Herzegowina', 1, 0, 0),
(28, 'BW', 'Botswana', 1, 0, 0),
(29, 'BV', 'Bouvet Island', 1, 0, 0),
(30, 'BR', 'Brazil', 1, 0, 0),
(31, 'IO', 'British Indian Ocean Territory', 1, 0, 0),
(32, 'VG', 'British Virgin Islands', 1, 0, 0),
(33, 'BN', 'Brunei Darussalam', 1, 0, 0),
(34, 'BG', 'Bulgaria', 1, 0, 0),
(35, 'BF', 'Burkina Faso', 1, 0, 0),
(36, 'BI', 'Burundi', 1, 0, 0),
(37, 'KH', 'Cambodia', 1, 0, 0),
(38, 'CM', 'Cameroon', 1, 0, 0),
(39, 'CA', 'Canada', 1, 0, 0),
(40, 'CV', 'Cape Verde', 1, 0, 0),
(41, 'KY', 'Cayman Islands', 1, 0, 0),
(42, 'CF', 'Central African Republic', 1, 0, 0),
(43, 'TD', 'Chad', 1, 0, 0),
(44, 'CL', 'Chile', 1, 0, 0),
(45, 'CN', 'China', 1, 0, 0),
(46, 'CX', 'Christmas Island', 1, 0, 0),
(47, 'CC', 'Cocos (Keeling) Islands', 1, 0, 0),
(48, 'CO', 'Colombia', 1, 0, 0),
(49, 'KM', 'Comoros', 1, 0, 0),
(50, 'CG', 'Congo', 1, 0, 0),
(51, 'CK', 'Cook Islands', 1, 0, 0),
(52, 'CR', 'Costa Rica', 1, 0, 0),
(53, 'CI', 'Cote D''ivoire', 1, 0, 0),
(54, 'HR', 'Croatia', 1, 0, 0),
(55, 'CU', 'Cuba', 1, 0, 0),
(56, 'CY', 'Cyprus', 1, 0, 0),
(57, 'CZ', 'Czech Republic', 1, 0, 0),
(58, 'DK', 'Denmark', 1, 0, 0),
(59, 'DJ', 'Djibouti', 1, 0, 0),
(60, 'DM', 'Dominica', 1, 0, 0),
(61, 'DO', 'Dominican Republic', 1, 0, 0),
(62, 'TP', 'East Timor', 1, 0, 0),
(63, 'EC', 'Ecuador', 1, 0, 0),
(64, 'EG', 'Egypt', 1, 0, 0),
(65, 'SV', 'El Salvador', 1, 0, 0),
(66, 'GQ', 'Equatorial Guinea', 1, 0, 0),
(67, 'ER', 'Eritrea', 1, 0, 0),
(68, 'EE', 'Estonia', 1, 0, 0),
(69, 'ET', 'Ethiopia', 1, 0, 0),
(70, 'FK', 'Falkland Islands (Malvinas)', 1, 0, 0),
(71, 'FO', 'Faroe Islands', 1, 0, 0),
(72, 'FJ', 'Fiji', 1, 0, 0),
(73, 'FI', 'Finland', 1, 0, 0),
(74, 'FR', 'France', 1, 0, 0),
(75, 'GF', 'French Guiana', 1, 0, 0),
(76, 'PF', 'French Polynesia', 1, 0, 0),
(77, 'TF', 'French Southern Territories', 1, 0, 0),
(78, 'GA', 'Gabon', 1, 0, 0),
(79, 'GM', 'Gambia', 1, 0, 0),
(80, 'GE', 'Georgia', 1, 0, 0),
(81, 'DE', 'Germany', 1, 0, 0),
(82, 'GH', 'Ghana', 1, 0, 0),
(83, 'GI', 'Gibraltar', 1, 0, 0),
(84, 'GR', 'Greece', 1, 0, 0),
(85, 'GL', 'Greenland', 1, 0, 0),
(86, 'GD', 'Grenada', 1, 0, 0),
(87, 'GP', 'Guadeloupe', 1, 0, 0),
(88, 'GU', 'Guam', 1, 0, 0),
(89, 'GT', 'Guatemala', 1, 0, 0),
(90, 'GN', 'Guinea', 1, 0, 0),
(91, 'GW', 'Guinea-Bissau', 1, 0, 0),
(92, 'GY', 'Guyana', 1, 0, 0),
(93, 'HT', 'Haiti', 1, 0, 0),
(94, 'HM', 'Heard and McDonald Islands', 1, 0, 0),
(95, 'HN', 'Honduras', 1, 0, 0),
(96, 'HK', 'Hong Kong', 1, 0, 0),
(97, 'HU', 'Hungary', 1, 0, 0),
(98, 'IS', 'Iceland', 1, 0, 0),
(99, 'IN', 'India', 1, 0, 0),
(100, 'ID', 'Indonesia', 1, 0, 0),
(101, 'IQ', 'Iraq', 1, 0, 0),
(102, 'IE', 'Ireland', 1, 0, 0),
(103, 'IR', 'Islamic Republic of Iran', 1, 0, 0),
(104, 'IL', 'Israel', 1, 0, 0),
(105, 'IT', 'Italy', 1, 0, 0),
(106, 'JM', 'Jamaica', 1, 0, 0),
(107, 'JP', 'Japan', 1, 0, 0),
(108, 'JO', 'Jordan', 1, 0, 0),
(109, 'KZ', 'Kazakhstan', 1, 0, 0),
(110, 'KE', 'Kenya', 1, 0, 0),
(111, 'KI', 'Kiribati', 1, 0, 0),
(112, 'KP', 'Korea, Dem. Peoples Rep of', 1, 0, 0),
(113, 'KR', 'Korea, Republic of', 1, 0, 0),
(114, 'KW', 'Kuwait', 1, 0, 0),
(115, 'KG', 'Kyrgyzstan', 1, 0, 0),
(116, 'LA', 'Laos', 1, 0, 0),
(117, 'LV', 'Latvia', 1, 0, 0),
(118, 'LB', 'Lebanon', 1, 0, 0),
(119, 'LS', 'Lesotho', 1, 0, 0),
(120, 'LR', 'Liberia', 1, 0, 0),
(121, 'LY', 'Libyan Arab Jamahiriya', 1, 0, 0),
(122, 'LI', 'Liechtenstein', 1, 0, 0),
(123, 'LT', 'Lithuania', 1, 0, 0),
(124, 'LU', 'Luxembourg', 1, 0, 0),
(125, 'MO', 'Macau', 1, 0, 0),
(126, 'MK', 'Macedonia', 1, 0, 0),
(127, 'MG', 'Madagascar', 1, 0, 0),
(128, 'MW', 'Malawi', 1, 0, 0),
(129, 'MY', 'Malaysia', 1, 0, 0),
(130, 'MV', 'Maldives', 1, 0, 0),
(131, 'ML', 'Mali', 1, 0, 0),
(132, 'MT', 'Malta', 1, 0, 0),
(133, 'MH', 'Marshall Islands', 1, 0, 0),
(134, 'MQ', 'Martinique', 1, 0, 0),
(135, 'MR', 'Mauritania', 1, 0, 0),
(136, 'MU', 'Mauritius', 1, 0, 0),
(137, 'YT', 'Mayotte', 1, 0, 0),
(138, 'MX', 'Mexico', 1, 0, 0),
(139, 'FM', 'Micronesia', 1, 0, 0),
(140, 'MD', 'Moldova, Republic of', 1, 0, 0),
(141, 'MC', 'Monaco', 1, 0, 0),
(142, 'MN', 'Mongolia', 1, 0, 0),
(143, 'MS', 'Montserrat', 1, 0, 0),
(144, 'MA', 'Morocco', 1, 0, 0),
(145, 'MZ', 'Mozambique', 1, 0, 0),
(146, 'MM', 'Myanmar', 1, 0, 0),
(147, 'NA', 'Namibia', 1, 0, 0),
(148, 'NR', 'Nauru', 1, 0, 0),
(149, 'NP', 'Nepal', 1, 0, 0),
(150, 'NL', 'Netherlands', 1, 0, 0),
(151, 'AN', 'Netherlands Antilles', 1, 0, 0),
(152, 'NC', 'New Caledonia', 1, 0, 0),
(153, 'NZ', 'New Zealand', 1, 0, 0),
(154, 'NI', 'Nicaragua', 1, 0, 0),
(155, 'NE', 'Niger', 1, 0, 0),
(156, 'NG', 'Nigeria', 1, 0, 0),
(157, 'NU', 'Niue', 1, 0, 0),
(158, 'NF', 'Norfolk Island', 1, 0, 0),
(159, 'MP', 'Northern Mariana Islands', 1, 0, 0),
(160, 'NO', 'Norway', 1, 0, 0),
(161, 'OM', 'Oman', 1, 0, 0),
(162, 'PK', 'Pakistan', 1, 0, 0),
(163, 'PW', 'Palau', 1, 0, 0),
(164, 'PA', 'Panama', 1, 0, 0),
(165, 'PG', 'Papua New Guinea', 1, 0, 0),
(166, 'PY', 'Paraguay', 1, 0, 0),
(167, 'PE', 'Peru', 1, 0, 0),
(168, 'PH', 'Philippines', 1, 0, 0),
(169, 'PN', 'Pitcairn', 1, 0, 0),
(170, 'PL', 'Poland', 1, 0, 0),
(171, 'PT', 'Portugal', 1, 0, 0),
(172, 'PR', 'Puerto Rico', 1, 0, 0),
(173, 'QA', 'Qatar', 1, 0, 0),
(174, 'RE', 'Reunion', 1, 0, 0),
(175, 'RO', 'Romania', 1, 0, 0),
(176, 'RU', 'Russian Federation', 1, 0, 0),
(177, 'RW', 'Rwanda', 1, 0, 0),
(178, 'LC', 'Saint Lucia', 1, 0, 0),
(179, 'WS', 'Samoa', 1, 0, 0),
(180, 'SM', 'San Marino', 1, 0, 0),
(181, 'ST', 'Sao Tome and Principe', 1, 0, 0),
(182, 'SA', 'Saudi Arabia', 1, 0, 0),
(183, 'SN', 'Senegal', 1, 0, 0),
(184, 'YU', 'Serbia and Montenegro', 1, 0, 0),
(185, 'SC', 'Seychelles', 1, 0, 0),
(186, 'SL', 'Sierra Leone', 1, 0, 0),
(187, 'SG', 'Singapore', 1, 0, 0),
(188, 'SK', 'Slovakia', 1, 0, 0),
(189, 'SI', 'Slovenia', 1, 0, 0),
(190, 'SB', 'Solomon Islands', 1, 0, 0),
(191, 'SO', 'Somalia', 1, 0, 0),
(192, 'ZA', 'South Africa', 1, 0, 0),
(193, 'ES', 'Spain', 1, 0, 0),
(194, 'LK', 'Sri Lanka', 1, 0, 0),
(195, 'SH', 'St. Helena', 1, 0, 0),
(196, 'KN', 'St. Kitts and Nevis', 1, 0, 0),
(197, 'PM', 'St. Pierre and Miquelon', 1, 0, 0),
(198, 'VC', 'St. Vincent and the Grenadines', 1, 0, 0),
(199, 'SD', 'Sudan', 1, 0, 0),
(200, 'SR', 'Suriname', 1, 0, 0),
(201, 'SJ', 'Svalbard and Jan Mayen Islands', 1, 0, 0),
(202, 'SZ', 'Swaziland', 1, 0, 0),
(203, 'SE', 'Sweden', 1, 0, 0),
(204, 'CH', 'Switzerland', 1, 0, 0),
(205, 'SY', 'Syrian Arab Republic', 1, 0, 0),
(206, 'TW', 'Taiwan', 1, 0, 0),
(207, 'TJ', 'Tajikistan', 1, 0, 0),
(208, 'TZ', 'Tanzania, United Republic of', 1, 0, 0),
(209, 'TH', 'Thailand', 1, 0, 0),
(210, 'TG', 'Togo', 1, 0, 0),
(211, 'TK', 'Tokelau', 1, 0, 0),
(212, 'TO', 'Tonga', 1, 0, 0),
(213, 'TT', 'Trinidad and Tobago', 1, 0, 0),
(214, 'TN', 'Tunisia', 1, 0, 0),
(215, 'TR', 'Turkey', 1, 0, 0),
(216, 'TM', 'Turkmenistan', 1, 0, 0),
(217, 'TC', 'Turks and Caicos Islands', 1, 0, 0),
(218, 'TV', 'Tuvalu', 1, 0, 0),
(219, 'UG', 'Uganda', 1, 0, 0),
(220, 'UA', 'Ukraine', 1, 0, 0),
(221, 'AE', 'United Arab Emirates', 1, 0, 0),
(222, 'GB', 'United Kingdom (GB)', 1, 0, 999),
(224, 'US', 'United States', 1, 1, 1000),
(225, 'VI', 'United States Virgin Islands', 1, 0, 0),
(226, 'UY', 'Uruguay', 1, 0, 0),
(227, 'UZ', 'Uzbekistan', 1, 0, 0),
(228, 'VU', 'Vanuatu', 1, 0, 0),
(229, 'VA', 'Vatican City State', 1, 0, 0),
(230, 'VE', 'Venezuela', 1, 0, 0),
(231, 'VN', 'Vietnam', 1, 0, 0),
(232, 'WF', 'Wallis And Futuna Islands', 1, 0, 0),
(233, 'EH', 'Western Sahara', 1, 0, 0),
(234, 'YE', 'Yemen', 1, 0, 0),
(235, 'ZR', 'Zaire', 1, 0, 0),
(236, 'ZM', 'Zambia', 1, 0, 0),
(237, 'ZW', 'Zimbabwe', 1, 0, 0);


DROP TABLE IF EXISTS `<DB_PREFIX>currencies`;
CREATE TABLE IF NOT EXISTS `<DB_PREFIX>currencies` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `symbol` varchar(5) COLLATE utf8_unicode_ci NOT NULL,
  `code` varchar(3) CHARACTER SET latin1 NOT NULL,
  `rate` double(10,4) NOT NULL DEFAULT '1.0000',
  `decimals` tinyint(1) NOT NULL DEFAULT '2',
  `symbol_placement` enum('left','right') CHARACTER SET latin1 NOT NULL DEFAULT 'right',
  `primary_order` tinyint(1) NOT NULL DEFAULT '0',
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=5 ;

INSERT INTO `<DB_PREFIX>currencies` (`id`, `name`, `symbol`, `code`, `rate`, `decimals`, `symbol_placement`, `primary_order`, `is_default`, `is_active`) VALUES
(1, 'US Dollar', '$', 'USD', 1.0000, 2, 'left', 1, 1, 1),
(2, 'Euro', '€', 'EUR', 1.3400, 2, 'left', 2, 0, 1),
(3, 'GB Pound', '£', 'GBP', 1.6100, 2, 'left', 3, 0, 1),
(4, 'AU Dollar', 'AU$', 'AUD', 1.0700, 2, 'left', 4, 0, 1);


DROP TABLE IF EXISTS `<DB_PREFIX>customers`;
CREATE TABLE IF NOT EXISTS `<DB_PREFIX>customers` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `group_id` int(10) unsigned NOT NULL DEFAULT '0',
  `first_name` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `last_name` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `birth_date` date NOT NULL DEFAULT '0000-00-00',
  `company` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `b_address` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `b_address_2` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `b_city` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `b_state` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `b_country` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `b_zipcode` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `phone` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `fax` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `email` varchar(70) COLLATE utf8_unicode_ci NOT NULL,
  `url` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `user_name` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `user_password` varchar(50) CHARACTER SET latin1 NOT NULL,
  `preferred_language` varchar(2) CHARACTER SET latin1 NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_lastlogin` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `registered_from_ip` varchar(15) CHARACTER SET latin1 NOT NULL,
  `last_logged_ip` varchar(15) CHARACTER SET latin1 NOT NULL DEFAULT '000.000.000.000',
  `email_notifications` tinyint(1) NOT NULL DEFAULT '0',
  `notification_status_changed` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `orders_count` smallint(6) unsigned NOT NULL DEFAULT '0',
  `plan1_listings` smallint(6) unsigned NOT NULL DEFAULT '0',
  `plan2_listings` smallint(6) unsigned NOT NULL DEFAULT '0',
  `plan3_listings` smallint(6) unsigned NOT NULL DEFAULT '0',
  `plan4_listings` smallint(6) unsigned NOT NULL DEFAULT '0',
  `is_active` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0 - registration pending, 1 - active customer',
  `is_removed` tinyint(1) NOT NULL DEFAULT '0',
  `comments` text CHARACTER SET utf8 NOT NULL,
  `registration_code` varchar(20) CHARACTER SET latin1 NOT NULL,
  PRIMARY KEY (`id`),
  KEY `b_country` (`b_country`),
  KEY `status` (`is_active`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;


DROP TABLE IF EXISTS `<DB_PREFIX>customer_groups`;
CREATE TABLE IF NOT EXISTS `<DB_PREFIX>customer_groups` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

INSERT INTO `<DB_PREFIX>customer_groups` (`id`, `name`, `description`) VALUES
(1, 'General', 'General purpose only');


DROP TABLE IF EXISTS `<DB_PREFIX>email_templates`;
CREATE TABLE IF NOT EXISTS `<DB_PREFIX>email_templates` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `language_id` varchar(2) CHARACTER SET latin1 NOT NULL,
  `template_code` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `template_name` varchar(125) COLLATE utf8_unicode_ci NOT NULL,
  `template_subject` varchar(125) COLLATE utf8_unicode_ci NOT NULL,
  `template_content` text COLLATE utf8_unicode_ci NOT NULL,
  `is_system_template` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=55 ;

INSERT INTO `<DB_PREFIX>email_templates` (`id`, `language_id`, `template_code`, `template_name`, `template_subject`, `template_content`, `is_system_template`) VALUES
(1, 'en', 'new_account_created', 'Email for new user', 'Your account has been created', 'Dear <b>{FIRST NAME} {LAST NAME}</b>!\r\n\r\nCongratulations on creating your new account.\r\n\r\nPlease keep this email for your records, as it contains an important information that you may need, should you ever encounter problems or forget your password.\r\n\r\nYour login: {USER NAME}\r\nYour password: {USER PASSWORD}\r\n\r\nYou may follow the link below to log into your account:\r\n{BASE URL}index.php?customer=login\r\n\r\nP.S. Remember, we will never sell your personal information or email address.\r\n\r\nEnjoy!\r\n-\r\nSincerely,\r\nCustomer Support', 1),
(2, 'es', 'new_account_created', 'Email para el nuevo usuario', 'Tu cuenta ha sido creada', 'Estimado <b>{FIRST NAME} {LAST NAME}</b>!\r\n\r\nFelicitaciones por la creación de su nueva cuenta.\r\n\r\nPor favor, mantenga este e-mail para sus registros, ya que contiene una información importante que usted pueda necesitar, si surge algún problema u olvidas tu contraseña.\r\n\r\nUsted entrada: {USER NAME}\r\nUsted contraseña: {USER PASSWORD}\r\n\r\nPor favor siga el siguiente enlace para acceder a su cuenta:\r\n{BASE URL}index.php?customer=login\r\n\r\nPD Recuerde, nosotros nunca venderemos su nombre o dirección de correo electrónico.\r\n\r\nDisfrute!\r\n-----------------------------\r\nSinceramente,\r\nSoporte al cliente', 1),
(3, 'de', 'new_account_created', 'E-Mail für neue Benutzer', 'Ihr Konto wurde erstellt', 'Liebe <b>{FIRST NAME} {LAST NAME}</b>!\r\n\r\nHerzlichen Glückwunsch zu Ihrem neuen Konto erstellen.\r\n\r\nBitte bewahren Sie diese E-Mail für Ihre Aufzeichnungen, da sie eine wichtige Information, die Sie benötigen, sollten Sie Probleme auftreten oder Ihr Passwort vergessen enthält.\r\n\r\nIhr Login: {USER NAME}\r\nIhr Passwort: {USER PASSWORD}\r\n\r\nSie können den folgenden Link in Ihren Account einloggen:\r\n{BASE URL}index.php?customer=login\r\n\r\nP.S. Denken Sie daran, wir werden nie verkaufen Ihren Namen oder E-Mail-Adresse.\r\n\r\nViel Spaß!\r\n-\r\nMit freundlichen Grüßen,\r\nCustomer Support', 1),
(4, 'en', 'new_account_created_by_admin', 'New account created (by admin)', 'Your account has been created by administrator', 'Dear <b>{FIRST NAME} {LAST NAME}!</b>\r\n\r\nThe {WEB SITE} Admin has invited you to contribute to our site.\r\n\r\nPlease keep this email for your records, as it contains an important information that you may need, should you ever encounter problems or forget your password.\r\n\r\nYour login: {USER NAME}\r\nYour password: {USER PASSWORD}\r\n\r\nPlease follow the link below to log into your account:\r\n{BASE URL}index.php?customer=login\r\n\r\nEnjoy!\r\n-\r\nSincerely,\r\nAdministration', 1),
(5, 'es', 'new_account_created_by_admin', 'Nueva cuenta creada (por admin)', 'Su cuenta ha sido creada por el administrador', 'Estimado <b>{FIRST NAME} {LAST NAME}</b>\r\n\r\nLa {WEB SITE} Admin te ha invitado a contribuir a nuestro sitio.\r\n\r\nPor favor, mantenga este e-mail para sus registros, ya que contiene una información importante que usted pueda necesitar, si surge algún problema u olvidas tu contraseña.\r\n\r\nUsted entrada: {USER NAME}\r\nUsted contraseña: {USER PASSWORD}\r\n\r\nPor favor siga el siguiente enlace para acceder a su cuenta:\r\n{BASE URL}index.php?customer=login\r\n\r\nDisfrute!\r\n-\r\nAtentamente,\r\nAdministración', 1),
(6, 'de', 'new_account_created_by_admin', 'Neues Konto erstellt (von admin)', 'Ihr Konto wurde vom Administrator erstellt wurde', 'Lieber <b>{FIRST NAME} {LAST NAME}!</b>\r\n\r\nDie {WEB SITE} Admin hat Sie eingeladen, auf unserer Website beitragen.\r\n\r\nBitte bewahren Sie diese E-Mail für Ihre Aufzeichnungen, da sie eine wichtige Information, die Sie benötigen, sollten Sie Probleme auftreten oder Ihr Passwort vergessen enthält.\r\n\r\nSie Login: {USER NAME}\r\nIhr Passwort: {USER PASSWORD}\r\n\r\nBitte folgen Sie den untenstehenden Link, um in Ihren Account einloggen:\r\n{BASE URL}index.php?customer=login\r\n\r\nViel Spaß!\r\n-\r\nMit freundlichen Grüßen,\r\nVerwaltung', 1),
(7, 'en', 'new_account_created_confirm_by_email', 'Email for new user (email confirmation required)', 'Your account has been created (confirmation required)', 'Dear <b>{FIRST NAME} {LAST NAME}</b>!\r\n\r\nCongratulations on creating your new account.\r\n\r\nPlease keep this email for your records, as it contains an important information that you may need, should you ever encounter problems or forget your password.\r\n\r\nYour login: {USER NAME}\r\nYour password: {USER PASSWORD}\r\n\r\nIn order to become authorized member, you will need to confirm your registration. You may follow the link below to access the confirmation page:\r\n{BASE URL}index.php?customer=confirm_registration&c={REGISTRATION CODE}\r\n\r\nP.S. Remember, we will never sell your personal information or email address.\r\n\r\nEnjoy!\r\n-\r\nSincerely,\r\nCustomer Support', 1),
(8, 'es', 'new_account_created_confirm_by_email', 'Correo electrónico para el nuevo usuario (se requiere confirmación)', 'Su cuenta ha sido creada (requiere confirmación por e-mail)', 'Estimado <b>{FIRST NAME} {LAST NAME}</b>!\r\n\r\nFelicitaciones por la creación de su nueva cuenta.\r\n\r\nPor favor, mantenga este e-mail para sus registros, ya que contiene una información importante que usted pueda necesitar, si surge algún problema u olvidas tu contraseña.\r\n\r\nUsted entrada: {USER NAME}\r\nUsted contraseña: {USER PASSWORD}\r\n\r\nPara convertirse en miembro autorizado, tendrá que confirmar su registro. Por favor siga el siguiente enlace para acceder a la página de confirmación:\r\n{BASE URL}index.php?customer=confirm_registration&c={REGISTRATION CODE}\r\n\r\nPD Recuerde, nosotros nunca venderemos su nombre o dirección de correo electrónico.\r\n\r\nDisfrute!\r\n-\r\nSinceramente,\r\nSoporte al cliente', 1),
(9, 'de', 'new_account_created_confirm_by_email', 'E-Mail für neue Benutzer (E-Mail-Bestätigung erforderlich)', 'Ihr Konto wurde erstellt (Bestätigung erforderlich)', 'Liebe <b>{FIRST NAME} {LAST NAME}</b>!\r\n\r\nHerzlichen Glückwunsch zu Ihrem neuen Konto erstellen.\r\n\r\nBitte bewahren Sie diese E-Mail für Ihre Aufzeichnungen, da sie eine wichtige Information, die Sie benötigen, sollten Sie Probleme auftreten oder Ihr Passwort vergessen enthält.\r\n\r\nIhr Login: {USER NAME}\r\nIhr Passwort: {USER PASSWORD}\r\n\r\nUm Mitglied zu werden ermächtigt, müssen Sie Ihre Registrierung bestätigen. Sie können folgen Sie den untenstehenden Link, um die Bestätigungs-Seite zu erreichen:\r\n{BASE URL}index.php?customer=confirm_registration&c={REGISTRATION CODE}\r\n\r\nP.S. Denken Sie daran, wir werden nie verkaufen Ihren Namen oder E-Mail-Adresse.\r\n\r\nViel Spaß!\r\n-\r\nMit freundlichen Grüßen,\r\nCustomer Support', 1),
(10, 'en', 'registration_approved_by_admin', 'Email for new user (registration was approved by admin)', 'Your registration has been approved', 'Dear <b>{FIRST NAME} {LAST NAME}!</b>\r\n\r\nCongratulations! This e-mail is to confirm that your registration at {WEB SITE} has been approved.\r\n\r\nYou can now login in to your account now.\r\n\r\nThanks for choosing {WEB SITE}.\r\n-\r\nSincerely,\r\nAdministration', 1),
(11, 'es', 'registration_approved_by_admin', 'E-mail para el nuevo usuario (el registro fue aprobado por el administrador)', 'Su registro ha sido aprobado', 'Estimado <b>{FIRST NAME} {LAST NAME}!</b>\r\n\r\n¡Felicitaciones! Este e-mail es para confirmar que su inscripción en {WEB SITE} ha sido aprobado.\r\n\r\nAhora puede acceder a su cuenta ahora.\r\n\r\nGracias por elegir {WEB SITE}.\r\n-\r\nAtentamente,\r\nadministración', 1),
(12, 'de', 'registration_approved_by_admin', 'E-Mail für neue Benutzer (Registrierung wurde von admin zugelassen)', 'Ihre Registrierung genehmigt wurde', 'Sehr geehrte <b>{FIRST NAME} {LAST NAME}!</b>\r\n\r\nHerzlichen Glückwunsch! Diese E-Mail ist zu bestätigen, dass Ihre Anmeldung bei {WEB SITE} genehmigt wurde.\r\n\r\nSie können jetzt in Ihr Konto jetzt einloggen.\r\n\r\nDanke für die Wahl {WEB SITE}.\r\n-\r\nMit freundlichen Grüßen,\r\nVerwaltung', 1),
(13, 'de', 'new_account_created_notify_admin', 'Neues Konto erstellt wurde (benachrichtigen admin)', 'Neues Konto erstellt wurde', 'Hallo Admin!\r\n\r\nEin neuer Benutzer hat bei Ihnen vor Ort registriert worden.\r\nDiese Email enthält einen Benutzer-Account Details:\r\n\r\nName: {FIRST NAME} {LAST NAME}\r\nE-Mail: {USER EMAIL}\r\nBenutzername: {USER NAME}\r\n\r\nP.S. Bitte überprüfen Sie, ob es nicht erforderlich, Ihre Zustimmung zur Aktivierung.', 1),
(14, 'en', 'new_account_created_notify_admin', 'New account has been created (notify admin)', 'New account has been created', 'Hello Admin!\r\n\r\nA new user has been registered at your site.\r\nThis email contains a user account details:\r\n\r\nName: {FIRST NAME} {LAST NAME}\r\nEmail: {USER EMAIL}\r\nUsername: {USER NAME}\r\n\r\nP.S. Please check if it doesn''t require your approval for activation', 1),
(15, 'es', 'new_account_created_notify_admin', 'Nueva cuenta se ha creado (notificar admin)', 'Nueva cuenta se ha creado', 'Hola admin!\r\n\r\nUn nuevo usuario ha sido registrado en su sitio.\r\nEste correo electrónico contiene una información de la cuenta de usuario:\r\n\r\nNombre: {FIRST NAME} {LAST NAME}\r\nE-mail: {USER EMAIL}\r\nNombre de usuario: {USER NAME}\r\n\r\nPD Por favor, compruebe si no se requiere su aprobación para la activación.', 1),
(16, 'en', 'new_account_created_confirm_by_admin', 'Email for new user (admin approval required)', 'Your account has been created (approval required)', 'Dear <b>{FIRST NAME} {LAST NAME}</b>!\r\n\r\nCongratulations on creating your new account.\r\n\r\nPlease keep this email for your records, as it contains an important information that you may need, should you ever encounter problems or forget your password.\r\n\r\nYour login: {USER NAME}\r\nYour password: {USER PASSWORD}\r\n\r\nAfter your registration will be approved by administrator,  you could log into your account with following link:\r\n{BASE URL}index.php?customer=login\r\n\r\nP.S. Remember, we will never sell your name or email address.\r\n\r\nEnjoy!\r\n-\r\nSincerely,\r\nCustomer Support', 1),
(17, 'es', 'new_account_created_confirm_by_admin', 'E-mail para el nuevo usuario (requiere aprobación del administrador)', 'Su cuenta ha sido creada (requiere aprobación)', 'Estimados <b>{FIRST NAME} {LAST NAME}</b>!\r\n\r\nFelicitaciones por la creación de su nueva cuenta.\r\n\r\nPor favor, mantenga este e-mail para sus registros, ya que contiene una información importante que usted pueda necesitar, si surge algún problema u olvidas tu contraseña.\r\n\r\nSu entrada: {USER NAME}\r\nSu contraseña: {USER PASSWORD}\r\n\r\nDespués de su registro será aprobado por el administrador, puede acceder a su cuenta con el siguiente enlace:\r\n{BASE URL}index.php?customer=login\r\n\r\nPD Recuerde, nosotros nunca venderemos su nombre o dirección de correo electrónico.\r\n\r\nDisfrute!\r\n-\r\nAtentamente,\r\nAtención al cliente', 1),
(18, 'de', 'new_account_created_confirm_by_admin', 'E-Mail für neue Benutzer (admin Genehmigung erforderlich)', 'Ihr Konto wurde erstellt (Bestätigung erforderlich)', 'Liebe <b>{FIRST NAME} {LAST NAME}</b>!\r\n\r\nHerzlichen Glückwunsch zu Ihrem neuen Konto erstellen.\r\n\r\nBitte bewahren Sie diese E-Mail für Ihre Aufzeichnungen, da sie eine wichtige Information, die Sie benötigen, sollten Sie Probleme auftreten oder Ihr Passwort vergessen enthält.\r\n\r\nIhr Login: {USER NAME}\r\nIhr Passwort: {USER PASSWORD}\r\n\r\nNach Ihrer Anmeldung vom Administrator genehmigt werden, könnten Sie Ihr Konto mit folgenden Link anmelden:\r\n{BASE URL}index.php?customer=login\r\n\r\nP.S. Denken Sie daran, wir werden nie verkaufen Ihren Namen oder E-Mail-Adresse.\r\n\r\nViel Spaß!\r\n-\r\nMit freundlichen Grüßen,\r\nCustomer Support', 1),
(19, 'en', 'password_forgotten', 'Email for user or admin forgotten password', 'Forgotten Password', 'Hello <b>{USER NAME}</b>!\r\n\r\nYou or someone else asked for your login info on our site:\r\n{WEB SITE}\r\n\r\nYour Login Info:\r\n\r\nUsername: {USER NAME}\r\nPassword: {USER PASSWORD}\r\n\r\n-\r\nBest regards,\r\n{WEB SITE}\r\n', 1),
(20, 'es', 'password_forgotten', 'Email para el usuario o administrador contraseña olvidada', 'He olvidado la contraseña', 'Hola <b>{USER NAME}</b>!\r\n\r\nUsted o alguien más pide su información de acceso en nuestro sitio:\r\n{WEB SITE}\r\n\r\nSu usuario Info:\r\n------------------------\r\nNombre de usuario: {USER NAME}\r\nContraseña: {USER PASSWORD}\r\n\r\n------------------\r\nSaludos cordiales,\r\n{WEB SITE}', 1),
(21, 'de', 'password_forgotten', 'E-Mail für Benutzer oder Administrator Passwort vergessen', 'Passwort vergessen', 'Hallo <b>{USER NAME}</b>!\r\n\r\nSie oder jemand anderes baten um Ihre Login-Infos auf unserer Website:\r\n{WEB SITE}\r\n\r\nIhre Login-Infos:\r\n\r\nBenutzername: {USER NAME}\r\nPasswort: {USER PASSWORD}\r\n\r\n\r\nMit freundlichen Grüßen,\r\n{WEB SITE}\r\n', 1),
(22, 'en', 'password_changed_by_admin', 'Password changed by admin', 'Your password has been changed', 'Hello <b>{FIRST NAME} {LAST NAME}</b>!\r\n\r\nYour password was changed by administrator of the site:\r\n{WEB SITE}\r\n\r\nHere your new login info:\r\n-\r\nUsername: {USER NAME} \r\nPassword: {USER PASSWORD}\r\n\r\n-\r\nBest regards,\r\nAdministration', 1),
(23, 'es', 'password_changed_by_admin', 'Contraseña cambiada por admin', 'Su contraseña ha sido cambiada', 'Hola <b>{FIRST NAME} {LAST NAME}</b>!\r\n\r\nSu contraseña se ha cambiado por el administrador del sitio:\r\n{WEB SITE}\r\n\r\nAquí la información de su nuevo inicio de sesión:\r\n-\r\nNombre de usuario: {USER NAME} \r\nContraseña: {USER PASSWORD}\r\n\r\n-\r\nSaludos cordiales,\r\nAdministración', 1),
(24, 'de', 'password_changed_by_admin', 'Kennwort von admin geändert', 'Ihr Passwort wurde geändert', 'Hallo <b>{FIRST NAME} {LAST NAME}</b>!\r\n\r\nIhr Passwort wurde durch den Administrator der Website geändert:\r\n{WEB SITE}\r\n\r\nHier werden Ihre neuen Login-Info:\r\n-\r\nBenutzername: {USER NAME} \r\nKennwort: {USER PASSWORD}\r\n\r\n-\r\nMit freundlichen Grüßen,\r\nVerwaltung', 1),
(25, 'en', 'account_deleted_by_user', 'Account removed email (by user)', 'Your account has been removed', 'Dear {USER NAME}!\r\n\r\nYour account was removed.\r\n\r\n-\r\nSincerely,\r\nCustomer Support', 1),
(26, 'es', 'account_deleted_by_user', 'Cuenta Eliminada correo electrónico (por el usuario)', 'Su cuenta ha sido fue eliminado', 'Estimado {USER NAME}!\r\n\r\nTu cuenta ha sido eliminada.\r\n\r\n-----------------------------\r\nAtentamente,\r\nAtención al cliente', 1),
(27, 'de', 'account_deleted_by_user', 'Konto entfernt E-Mail (durch Benutzer)', 'Ihr Konto wurde entfernt', 'Sehr geehrter {USER NAME}!\r\n\r\nIhr Konto wurde entfernt.\r\n\r\n-\r\nMit freundlichen Grüßen,\r\nCustomer Support', 1),
(28, 'en', 'subscription_to_newsletter', 'Newsletter - new member has subscribed (member copy)', 'You have been subscribed to the Newsletter', 'Hello!\r\n\r\nYou are receiving this email because you, or someone using this email address, subscribed to the Newsletter of {WEB SITE}\r\n\r\nIf you do not wish to receive such emails in the future, please click this link: <a href="{BASE URL}index.php?page=newsletter&task=pre_unsubscribe&email={USER EMAIL}">Unsubscribe</a>\r\n\r\n-\r\nBest Regards,\r\nAdministration', 1),
(29, 'es', 'subscription_to_newsletter', 'Newsletter - nuevo miembro se ha suscrito (copia miembros)', 'Que se han suscrito al boletín de noticias', 'Hola!\r\n\r\nUsted está recibiendo este correo electrónico porque usted o alguien que use la siguiente dirección de correo electrónico, suscritas al boletín de noticias de {WEB SITE}\r\n\r\nSi usted no desea recibir dichos correos electrónicos en el futuro, por favor haga clic en este enlace: <a href="{BASE URL}index.php?page=newsletter&task=pre_unsubscribe&email={USER EMAIL}">Cancelar la suscripción</a>\r\n\r\n-\r\nSaludos cordiales,\r\nadministración', 1),
(30, 'de', 'subscription_to_newsletter', 'Newsletter - neues Mitglied abonniert hat (Mitglied Kopie)', 'Sie haben den Newsletter abonniert haben', 'Hallo!\r\n\r\nSie erhalten diese E-Mail, weil Sie oder jemand mit dieser E-Mail-Adresse, den Newsletter von {WEB SITE} abonniert\r\n\r\nWenn Sie nicht möchten, dass solche E-Mails in der Zukunft erhalten, klicken Sie bitte diesen Link: <a href="{BASE URL}index.php?page=newsletter&task=pre_unsubscribe&email={USER EMAIL}">Abmelden</a>\r\n\r\n-\r\nMit freundlichen Grüßen,\r\nVerwaltung', 1),
(31, 'en', 'unsubscription_from_newsletter', 'Newsletter - member has unsubscribed (member copy)', 'You have been unsubscribed from the Newsletter', 'Hello!\r\n\r\nYou are receiving this email because you, or someone using this email address, unsubscribed from the Newsletter of {WEB SITE}\r\n\r\nYou can always restore your subscription, using the link below: \r\n{BASE URL}index.php?page=newsletter&task=pre_subscribe&email={USER EMAIL}\r\n\r\n-\r\nBest Regards,\r\nAdministration', 1),
(32, 'es', 'unsubscription_from_newsletter', 'Newsletter - miembro ha dado de baja (copia miembros)', 'Se le ha cancelado la suscripción a la Newsletter', 'Hola!\r\n\r\nUsted está recibiendo este correo electrónico porque usted o alguien que use la siguiente dirección de correo electrónico, de baja de la Newsletter de {WEB SITE}\r\n\r\nSiempre podrá restaurar su suscripción, usando el siguiente enlace: \r\n{BASE URL}index.php?page=newsletter&task=pre_subscribe&email={USER EMAIL}\r\n\r\n-\r\nSaludos cordiales,\r\nadministración', 1),
(33, 'de', 'unsubscription_from_newsletter', 'Newsletter - Mitglied hat sich abgemeldet (Mitglied Kopie)', 'Sie haben den Newsletter abbestellt worden', 'Hallo!\r\n\r\nSie erhalten diese E-Mail, weil Sie oder jemand mit dieser E-Mail-Adresse, von der Newsletter von {WEB SITE} abgemeldet\r\n\r\nSie können immer wieder Ihr Abonnement, über den Link unten: \r\n{BASE URL}index.php?page=newsletter&task=pre_subscribe&email={USER EMAIL}\r\n\r\n-\r\nMit freundlichen Grüßen,\r\nVerwaltung', 1),
(34, 'en', 'events_new_registration', 'Events - new member has registered (member copy)', 'You have been successfully registered to the event!', 'Dear <b>{FIRST NAME} {LAST NAME}</b>!\r\n\r\nCongratulations on registering to {EVENT}.\r\n\r\nPlease keep this email for your records, as it contains an important information that you may need.\r\n\r\n-\r\nBest Regards,\r\nAdministration', 1),
(35, 'es', 'events_new_registration', 'Eventos - nuevo miembro se ha registrado (copia de miembro)', 'Se le ha registrado con éxito en el evento!', 'Estimado <b>{FIRST NAME} {LAST NAME}</b>!\r\n\r\nFelicitaciones por el registro de {EVENT}.\r\n\r\nPor favor, mantenga este e-mail para sus registros, ya que contiene una información importante que usted pueda necesitar.\r\n\r\n-\r\nSaludos cordiales,\r\nAdministración', 1),
(36, 'de', 'events_new_registration', 'Veranstaltungen - neues Mitglied registriert hat (Mitglied Kopie)', 'Sie haben erfolgreich an der Veranstaltung angemeldet haben!', 'Lieber <b>{FIRST NAME} {LAST NAME}</b>!\r\n\r\nHerzlichen Glückwunsch zu der Registrierung auf {EVENT}.\r\n\r\nBitte bewahren Sie diese E-Mail für Ihre Aufzeichnungen, da sie eine wichtige Information, die Sie benötigen enthält.\r\n\r\n-\r\nMit besten Grüßen,\r\nVerwaltung', 1),
(37, 'en', 'listing_approved_by_admin', 'Listing has been approved by admin', 'Your listing has been approved by administrator', 'Dear <b>{FIRST NAME} {LAST NAME}!</b>\r\n\r\nCongratulations! This e-mail is to confirm that your listing has been approved.\r\n\r\nBelow the details of your listing:\r\n{LISTING DETAILS}\r\n\r\nThanks for choosing {WEB SITE}.\r\n-\r\nSincerely,\r\nAdministration', 1),
(38, 'es', 'listing_approved_by_admin', 'Registro ha sido aprobado por admin', 'Su registro ha sido aprobado por el administrador', 'Estimado <b>{FIRST NAME} {LAST NAME}!</b>\r\n\r\n¡Felicitaciones! Este e-mail es para confirmar que su registro ha sido aprobado.\r\n\r\nA continuación los detalles de su anuncio:\r\n{LISTING DETAILS}\r\n\r\nGracias por elegir {WEB SITE}.\r\n-\r\nAtentamente,\r\nadministración', 1),
(39, 'de', 'listing_approved_by_admin', 'Listing wurde von admin genehmigt worden', 'Ihr Eintrag wurde vom Administrator genehmigt', 'Sehr geehrte <b>{FIRST NAME} {LAST NAME}!</b>\r\n\r\nHerzlichen Glückwunsch! Diese E-Mail wird bestätigt, dass Ihren Eintrag genehmigt worden ist.\r\n\r\nUnten die Details Ihren Eintrag:\r\n{LISTING DETAILS}\r\n\r\nDanke für die Wahl {WEB SITE}.\r\n-\r\nMit freundlichen Grüßen,\r\nVerwaltung', 1),
(40, 'en', 'order_accepted_online', 'Email for online placed orders (not paid yet)', 'Your order has been accepted by the system!', 'Dear <b>{FIRST NAME} {LAST NAME}</b>!\r\n\r\nYour order #{ORDER NUMBER} has been accepted and will be processed shortly.\r\n\r\n{ORDER DETAILS}\r\n\r\nP.S. Please keep this email for your records, as it contains an important information that you may\r\nneed.\r\n\r\n-\r\nSincerely,\r\nCustomer Support', 1),
(41, 'es', 'order_accepted_online', 'Email para pedidos en línea (aún sin pagar)', 'Su pedido ha sido aceptado por el sistema!', 'Estimado <b>{FIRST NAME} {LAST NAME}</b>!\r\n\r\nSu orden {ORDER NUMBER} ha sido aceptada y se procesará en breve.\r\n\r\n{ORDER DETAILS}\r\n\r\nPD Por favor, mantenga este e-mail para sus registros, ya que contiene una información importante que puede\r\nnecesitan.\r\n\r\n-\r\nAtentamente,\r\nAtención al cliente', 1),
(42, 'de', 'order_accepted_online', 'Email für Online getätigte Bestellungen (noch nicht bezahlt)', 'Ihre Bestellung wurde vom System akzeptiert wurde!', 'Sehr geehrte <b>{FIRST NAME} {LAST NAME}</b>!\r\n\r\nIhre Bestellung {ORDER NUMBER} angenommen worden und wird in Kürze bearbeitet.\r\n\r\n{ORDER DETAILS}\r\n\r\nP.S. Bitte bewahren Sie diese E-Mail für Ihre Unterlagen, da sie eine wichtige Information enthält, dass Sie möglicherweise\r\nbenötigen.\r\n\r\n-\r\nMit freundlichen Grüßen,\r\nCustomer Support', 1),
(43, 'de', 'order_paid', 'E-Mail für Bestellungen via Zahlungsabwicklung Systeme bezahlt', 'Ihre Bestellung wurde bezahlt und erhalten durch das System!', 'Sehr geehrte <b>{FIRST NAME} {LAST NAME}</b>!\r\n\r\nDanke für den Kauf von unserer Seite!\r\n\r\nIhre Bestellung {ORDER NUMBER} ist abgeschlossen!\r\n\r\n{ORDER DETAILS}\r\n\r\nP.S. Bitte bewahren Sie diese E-Mail für Ihre Unterlagen, da es eine wichtige Information, die Sie benötigen enthält.\r\n\r\n-\r\nMit freundlichen Grüßen,\r\nCustomer Support', 1),
(44, 'en', 'order_paid', 'Email for orders paid via payment processing systems', 'Your order has been paid and received by the system!', 'Dear <b>{FIRST NAME} {LAST NAME}</b>!\r\n\r\nThank you for purchasing from our site!\r\n\r\nYour order #{ORDER NUMBER} has been completed!\r\n\r\n{ORDER DETAILS}\r\n\r\nP.S. Please keep this email for your records, as it contains an important information that you may need.\r\n\r\n-\r\nSincerely,\r\nCustomer Support\r\n', 1),
(45, 'es', 'order_paid', 'Email para los pedidos pagados a través de sistemas de procesamiento de pagos', 'Su pedido ha sido pagado y recibido por el sistema!', 'Estimado <b>{FIRST NAME} {LAST NAME}</b>!\r\n\r\nGracias por la compra de nuestro sitio!\r\n\r\nSu {ORDER NUMBER} fin se ha terminado!\r\n\r\n{ORDER DETAILS}\r\n\r\nPD Por favor, mantenga este e-mail para sus registros, ya que contiene una información importante que usted pueda necesitar.\r\n\r\n-----------------------------\r\nAtentamente,\r\nAtención al cliente', 1),
(46, 'en', 'inquiry_new', 'Email notification to customer about new inquiry', 'We have received a new inquiry for you from our visitors', 'Dear {FIRST NAME} {LAST NAME}!\r\n\r\nThis e-mail is to confirm that we have received new inquiry for you from our visitors.\r\n\r\nYou can now login in to your account to check it:\r\n{BASE URL}index.php?customer=login\r\n\r\nThanks for choosing {WEB SITE}.\r\n-\r\nSincerely,\r\nAdministration', 1),
(47, 'es', 'inquiry_new', 'Notificación por correo electrónico a los clientes acerca de nueva investigación', 'Hemos recibido una nueva investigación para usted de nuestro visitante del sitio', 'Estimado {FIRST NAME} {LAST NAME}!\r\n\r\nEste e-mail es para confirmar que hemos recibido su consulta nueva para usted de nuestros visitantes.\r\n\r\nAhora puede iniciar sesión en su cuenta para comprobar que:\r\n{BASE URL}index.php?customer=login\r\n\r\nGracias por elegir {WEB SITE}.\r\n-\r\nAtentamente,\r\nadministración', 1),
(48, 'de', 'inquiry_new', 'E-Mail Benachrichtigung an den Kunden über neue Anfrage', 'Wir haben eine neue Anfrage für Sie von unserer Website-Besucher erhalten', 'Hallo {FIRST NAME} {LAST NAME}!\r\n\r\nDiese E-Mail ist zu bestätigen, dass wir neue Anfrage für Sie von unseren Besuchern erhalten.\r\n\r\nSie können jetzt in Ihrem Konto anmelden, um es zu überprüfen:\r\n{BASE URL}index.php?customer=login\r\n\r\nDanke für die Wahl {WEB SITE}.\r\n-\r\nMit freundlichen Grüßen,\r\nVerwaltung', 1),
(49, 'en', 'inquiry_reply', 'Email notification to visitor about inquiry reply', 'You have received a reply to your inquiry', 'Dear {FIRST NAME} {LAST NAME}!\r\n\r\nBelow the reply to your inquiry from one our customers:\r\n\r\n{REPLY DETAILS}\r\n\r\nThanks for choosing {WEB SITE}.\r\n-\r\nSincerely,\r\nAdministration', 1),
(50, 'es', 'inquiry_reply', 'Notificación por correo electrónico a los visitantes acerca de contestación investigación', 'Usted ha recibido una respuesta a su pregunta', 'Estimado {FIRST NAME} {LAST NAME}!\r\n\r\nA continuación, la respuesta a su pregunta de uno de nuestros clientes:\r\n\r\n{REPLY DETAILS}\r\n\r\nGracias por elegir {WEB SITE}.\r\n-\r\nAtentamente,\r\nadministración', 1),
(51, 'de', 'inquiry_reply', 'E-Mail Benachrichtigung an Besucher über Anfrage Antwort', 'Sie haben eine Antwort auf Ihre Anfrage erhalten', 'Hallo {FIRST NAME} {LAST NAME}!\r\n\r\nUnterhalb der Antwort auf Ihre Anfrage von einem unserer Kunden:\r\n\r\n{REPLY DETAILS}\r\n\r\nDanke für die Wahl {WEB SITE}.\r\n-\r\nMit freundlichen Grüßen,\r\nVerwaltung', 1),
(52, 'en', 'test_template', 'Testing Email', 'Testing Email', 'Hello <b>{USER NAME}</b>!\r\n\r\nThis a testing email.\r\n\r\nBest regards,\r\n{WEB SITE}', 0),
(53, 'es', 'test_template', 'Prueba de correo electrónico', 'Prueba de correo electrónico', 'Hola <b>{USER NAME}</b>!\r\n\r\nEsta es una prueba de correo electrónico.\r\n\r\nSaludos cordiales,\r\n{WEB SITE}', 0),
(54, 'de', 'test_template', 'Testen E-Mail', 'Testen E-Mail', 'Hallo <b>{USER NAME}</b>!\r\n\r\nDies ist ein Test E-Mail.\r\n\r\nMit freundlichen Grüßen,\r\n{WEB SITE}', 0);


DROP TABLE IF EXISTS `<DB_PREFIX>events_registered`;
CREATE TABLE IF NOT EXISTS `<DB_PREFIX>events_registered` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `event_id` int(10) unsigned NOT NULL DEFAULT '0',
  `first_name` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `last_name` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `email` varchar(70) COLLATE utf8_unicode_ci NOT NULL,
  `phone` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `message` text COLLATE utf8_unicode_ci NOT NULL,
  `date_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;


DROP TABLE IF EXISTS `<DB_PREFIX>faq_categories`;
CREATE TABLE IF NOT EXISTS `<DB_PREFIX>faq_categories` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `priority_order` smallint(6) unsigned NOT NULL DEFAULT '0',
  `is_active` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;


DROP TABLE IF EXISTS `<DB_PREFIX>faq_category_items`;
CREATE TABLE IF NOT EXISTS `<DB_PREFIX>faq_category_items` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned NOT NULL DEFAULT '0',
  `faq_question` text COLLATE utf8_unicode_ci NOT NULL,
  `faq_answer` text COLLATE utf8_unicode_ci NOT NULL,
  `priority_order` smallint(6) unsigned NOT NULL DEFAULT '0',
  `is_active` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `category_id` (`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;


DROP TABLE IF EXISTS `<DB_PREFIX>gallery_albums`;
CREATE TABLE IF NOT EXISTS `<DB_PREFIX>gallery_albums` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `album_code` varchar(8) COLLATE utf8_unicode_ci NOT NULL,
  `album_type` enum('images','video') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'images',
  `priority_order` smallint(6) NOT NULL DEFAULT '0',
  `is_active` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `is_active` (`is_active`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3 ;

INSERT INTO `<DB_PREFIX>gallery_albums` (`id`, `album_code`, `album_type`, `priority_order`, `is_active`) VALUES
(1, 'gpeqklos', 'images', 1, 1),
(2, 'ht6854oz', 'video', 2, 1);


DROP TABLE IF EXISTS `<DB_PREFIX>gallery_albums_description`;
CREATE TABLE IF NOT EXISTS `<DB_PREFIX>gallery_albums_description` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `gallery_album_id` int(10) unsigned NOT NULL DEFAULT '0',
  `language_id` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `description` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `language_id` (`language_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=7 ;

INSERT INTO `<DB_PREFIX>gallery_albums_description` (`id`, `gallery_album_id`, `language_id`, `name`, `description`) VALUES
(1, 1, 'de', 'Bildergalerie', 'Bildergalerie'),
(2, 1, 'es', 'Galería de imágenes', 'Galería de imágenes'),
(3, 1, 'en', 'Images Gallery', 'Images Gallery'),
(4, 2, 'en', 'Video Tutorials', 'Video Tutorials'),
(5, 2, 'es', 'Tutoriales en vídeo', 'Tutoriales en vídeo'),
(6, 2, 'de', 'Video Tutorials', 'Video Tutorials');


DROP TABLE IF EXISTS `<DB_PREFIX>gallery_album_items`;
CREATE TABLE IF NOT EXISTS `<DB_PREFIX>gallery_album_items` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `album_code` varchar(8) COLLATE utf8_unicode_ci NOT NULL,
  `item_file` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `item_file_thumb` varchar(70) COLLATE utf8_unicode_ci NOT NULL,
  `priority_order` smallint(6) NOT NULL DEFAULT '0',
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `album_code` (`album_code`),
  KEY `priority_order` (`priority_order`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=5 ;

INSERT INTO `<DB_PREFIX>gallery_album_items` (`id`, `album_code`, `item_file`, `item_file_thumb`, `priority_order`, `is_active`) VALUES
(1, 'gpeqklos', 'admin_home_page.png', 'admin_home_page_thumb.jpg', 1, 1),
(2, 'gpeqklos', 'gallery_management.png', 'gallery_management_thumb.jpg', 2, 1),
(3, 'gpeqklos', 'backup_installation.png', 'backup_installation_thumb.jpg', 3, 1),
(4, 'ht6854oz', 'http://www.youtube.com/watch?v=qFbC6sfBi1c', '', 1, 1);


DROP TABLE IF EXISTS `<DB_PREFIX>gallery_album_items_description`;
CREATE TABLE IF NOT EXISTS `<DB_PREFIX>gallery_album_items_description` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `gallery_album_item_id` int(10) unsigned NOT NULL DEFAULT '0',
  `language_id` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `description` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `album_code` (`gallery_album_item_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=13 ;

INSERT INTO `<DB_PREFIX>gallery_album_items_description` (`id`, `gallery_album_item_id`, `language_id`, `name`, `description`) VALUES
(1, 1, 'es', 'Panel de Administración - Página de inicio', ''),
(2, 1, 'en', 'Admin Panel - Home Page', ''),
(3, 1, 'de', 'Admin-Panel - Homepage', ''),
(4, 2, 'de', 'Galerie Verwaltung', ''),
(5, 2, 'es', 'Galería de Gestión', ''),
(6, 2, 'en', 'Gallery Management', ''),
(7, 3, 'en', 'Backup Installation', ''),
(8, 3, 'es', 'Instalación de Backup', ''),
(9, 3, 'de', 'Backup-Installation', ''),
(10, 4, 'de', 'Installation', ''),
(11, 4, 'es', 'Instalación', ''),
(12, 4, 'en', 'Installation', '');


DROP TABLE IF EXISTS `<DB_PREFIX>inquiries`;
CREATE TABLE IF NOT EXISTS `<DB_PREFIX>inquiries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `inquiry_type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '0 - standard, 1 - direct',
  `category_id` int(10) unsigned NOT NULL DEFAULT '0',
  `listing_id` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `email` varchar(70) COLLATE utf8_unicode_ci NOT NULL,
  `phone` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `location_id` int(10) unsigned NOT NULL DEFAULT '0',
  `sub_location_id` int(10) unsigned NOT NULL DEFAULT '0',
  `availability` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `preferred_contact` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `description` text COLLATE utf8_unicode_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `replies_count` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_active` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `category_id` (`category_id`),
  KEY `inquiry_type` (`inquiry_type`),
  KEY `location_id` (`location_id`),
  KEY `sub_location_id` (`sub_location_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;


DROP TABLE IF EXISTS `<DB_PREFIX>inquiries_history`;
CREATE TABLE IF NOT EXISTS `<DB_PREFIX>inquiries_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `inquiry_id` int(10) unsigned NOT NULL DEFAULT '0',
  `customer_id` int(10) unsigned NOT NULL DEFAULT '0',
  `listing_id` int(10) unsigned NOT NULL DEFAULT '0',
  `date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `inquiry_id` (`inquiry_id`),
  KEY `customer_id` (`customer_id`),
  KEY `listing_id` (`listing_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;


DROP TABLE IF EXISTS `<DB_PREFIX>inquiries_replies`;
CREATE TABLE IF NOT EXISTS `<DB_PREFIX>inquiries_replies` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `inquiry_id` int(10) unsigned NOT NULL DEFAULT '0',
  `customer_id` int(10) unsigned NOT NULL DEFAULT '0',
  `message` text COLLATE utf8_unicode_ci NOT NULL,
  `date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `inquiry_id` (`inquiry_id`),
  KEY `customer_id` (`customer_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;


DROP TABLE IF EXISTS `<DB_PREFIX>languages`;
CREATE TABLE IF NOT EXISTS `<DB_PREFIX>languages` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `lang_name` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `lang_name_en` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `abbreviation` varchar(3) COLLATE utf8_unicode_ci NOT NULL,
  `lc_time_name` varchar(5) CHARACTER SET latin1 NOT NULL DEFAULT 'en_US',
  `lang_dir` varchar(3) CHARACTER SET latin1 NOT NULL DEFAULT 'ltr',
  `icon_image` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `priority_order` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `used_on` enum('front-end','back-end','global') CHARACTER SET latin1 NOT NULL DEFAULT 'global',
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

INSERT INTO `<DB_PREFIX>languages` (`id`, `lang_name`, `lang_name_en`, `abbreviation`, `lc_time_name`, `lang_dir`, `icon_image`, `priority_order`, `used_on`, `is_default`, `is_active`) VALUES
(1, 'English', 'English', 'en', 'en_US', 'ltr', 'en.gif', 0, 'global', 1, 1),
(2, 'Español', 'Spanish', 'es', 'es_ES', 'ltr', 'es.gif', 1, 'global', 0, 1),
(3, 'Deutsch', 'German', 'de', 'de_DE', 'ltr', 'de.gif', 2, 'global', 0, 1);


DROP TABLE IF EXISTS `<DB_PREFIX>listings`;
CREATE TABLE IF NOT EXISTS `<DB_PREFIX>listings` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `customer_id` int(10) unsigned NOT NULL DEFAULT '0',
  `listing_location_id` int(10) unsigned NOT NULL DEFAULT '0',
  `listing_sub_location_id` int(10) unsigned NOT NULL DEFAULT '0',
  `image_file` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `image_file_thumb` varchar(70) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `image_1` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `image_1_thumb` varchar(70) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `image_2` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `image_2_thumb` varchar(70) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `image_3` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `image_3_thumb` varchar(70) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `website_url` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `video_url` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `keywords` text COLLATE utf8_unicode_ci NOT NULL,
  `map_code` text COLLATE utf8_unicode_ci NOT NULL,
  `business_email` varchar(75) COLLATE utf8_unicode_ci NOT NULL,
  `business_phone` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `business_fax` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `priority_order` smallint(1) unsigned NOT NULL DEFAULT '6',
  `access_level` enum('public','registered') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'public',
  `is_featured` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_published` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `date_published` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `finish_publishing` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `is_approved` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `advertise_plan_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `priority_order` (`priority_order`),
  KEY `listing_location_id` (`listing_location_id`),
  KEY `listing_sub_location_id` (`listing_sub_location_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3 ;

INSERT INTO `<DB_PREFIX>listings` (`id`, `customer_id`, `listing_location_id`, `listing_sub_location_id`, `image_file`, `image_file_thumb`, `image_1`, `image_1_thumb`, `image_2`, `image_2_thumb`, `image_3`, `image_3_thumb`, `website_url`, `video_url`, `keywords`, `map_code`, `business_email`, `business_phone`, `business_fax`, `priority_order`, `access_level`, `is_featured`, `is_published`, `date_published`, `finish_publishing`, `is_approved`, `advertise_plan_id`) VALUES
(1, 1, 1, 2, 'oqbd7ahj7zquje0yfwxn.jpg', 'oqbd7ahj7zquje0yfwxn_thumb.jpg', '', '', 'gzp83ensto4uo0d7sceh.jpg', 'gzp83ensto4uo0d7sceh_thumb.jpg', 'sv5xveovjyyl3qpyal4u.jpg', 'sv5xveovjyyl3qpyal4u_thumb.jpg', 'http://company.com', '', 'company,domain,business', '<iframe width="425" height="350" frameborder="0" scrolling="no" marginheight="0" marginwidth="0" src="https://maps.google.com/?ie=UTF8&ll=39.115056,-94.642824&spn=0.00904,0.01929&t=v&z=16&output=embed"></iframe><br /><small><a href="https://maps.google.com/?ie=UTF8&ll=39.115056,-94.642824&spn=0.00904,0.01929&t=v&z=16&source=embed" style="color:#0000FF;text-align:left">View Larger Map</a></small>', 'info@company.com', '1-800-123-444', '1-800-123-555', 0, 'public', 1, 1, '2012-12-19 15:03:38', '2017-12-28 20:30:55', 1, 3),
(2, 1, 2, 1, 'a4f5i5a6xkcn4v3epool.jpg', 'a4f5i5a6xkcn4v3epool_thumb.jpg', '', '', '', '', '', '', 'http://company.com', '', 'business,listings,computers', '<iframe width="425" height="350" frameborder="0" scrolling="no" marginheight="0" marginwidth="0" src="https://maps.google.com/?ie=UTF8&ll=39.109253,-94.61613&spn=0.009041,0.01929&t=v&z=16&output=embed"></iframe><br /><small><a href="https://maps.google.com/?ie=UTF8&ll=39.109253,-94.61613&spn=0.009041,0.01929&t=v&z=16&source=embed" style="color:#0000FF;text-align:left">View Larger Map</a></small>', 'info@company.com', '1-800-123-123', '1-800-123-444', 2, 'public', 1, 1, '2012-12-18 15:12:15', '0000-00-00 00:00:00', 1, 4);


DROP TABLE IF EXISTS `<DB_PREFIX>listings_categories`;
CREATE TABLE IF NOT EXISTS `<DB_PREFIX>listings_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned NOT NULL DEFAULT '0',
  `listing_id` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `category_id` (`category_id`),
  KEY `listing_id` (`listing_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3 ;

INSERT INTO `<DB_PREFIX>listings_categories` (`id`, `category_id`, `listing_id`) VALUES
(1, 3, 2),
(2, 2, 1);


DROP TABLE IF EXISTS `<DB_PREFIX>listings_description`;
CREATE TABLE IF NOT EXISTS `<DB_PREFIX>listings_description` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `listing_id` int(10) unsigned NOT NULL DEFAULT '0',
  `language_id` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `business_name` varchar(125) COLLATE utf8_unicode_ci NOT NULL,
  `business_address` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `business_description` varchar(1024) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `language_id` (`language_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=7 ;

INSERT INTO `<DB_PREFIX>listings_description` (`id`, `listing_id`, `language_id`, `business_name`, `business_address`, `business_description`) VALUES
(1, 1, 'de', 'Besten COMPANY LTD.', 'Level 1, 189 Flinders Street, Melbourne VIC 3000', 'Sed sodales dui dolor. Etiam non leo at risus posuere ultrices sed in ligula. Praesent sed massa a augue sodales rutrum. Suspendisse id erat enim, sit amet euismod ante. Suspendisse at nisl sit amet felis varius malesuada vel at velit. Nulla placerat arcu id magna sagittis ultricies. Etiam ante ipsum, imperdiet id ullamcorper at, feugiat non lacus. Praesent nec justo a nulla consequat consectetur. Mauris et magna turpis.'),
(2, 1, 'es', 'Mejor Empresa ltd.', 'Level 1, 189 Flinders Street, Melbourne VIC 3000', 'Sed sodales dui dolor. Etiam non leo at risus posuere ultrices sed in ligula. Praesent sed massa a augue sodales rutrum. Suspendisse id erat enim, sit amet euismod ante. Suspendisse at nisl sit amet felis varius malesuada vel at velit. Nulla placerat arcu id magna sagittis ultricies. Etiam ante ipsum, imperdiet id ullamcorper at, feugiat non lacus. Praesent nec justo a nulla consequat consectetur. Mauris et magna turpis.'),
(3, 1, 'en', 'Best Company ltd.', 'Level 1, 189 Flinders Street, Melbourne VIC 3000', 'Sed sodales dui dolor. Etiam non leo at risus posuere ultrices sed in ligula. Praesent sed massa a augue sodales rutrum. Suspendisse id erat enim, sit amet euismod ante. Suspendisse at nisl sit amet felis varius malesuada vel at velit. Nulla placerat arcu id magna sagittis ultricies. Etiam ante ipsum, imperdiet id ullamcorper at, feugiat non lacus. Praesent nec justo a nulla consequat consectetur. Mauris et magna turpis.'),
(4, 2, 'en', 'Business Good #2', 'Suite 208, 155 King Street, Sydney NSW 2000', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Cras eleifend faucibus leo et cursus. Nullam blandit lectus sit amet risus sollicitudin rhoncus. Praesent a nibh egestas justo sagittis mollis. Nullam consectetur ligula non neque rutrum scelerisque. Phasellus urna augue, auctor sit amet vestibulum eu, gravida ac est. Nam elit arcu, imperdiet sit amet tincidunt ac, adipiscing et ipsum. Maecenas dolor mi, faucibus a malesuada et, venenatis vitae purus.'),
(5, 2, 'es', 'Business Good #2', 'Suite 208, 155 King Street, Sydney NSW 2000', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Cras eleifend faucibus leo et cursus. Nullam blandit lectus sit amet risus sollicitudin rhoncus. Praesent a nibh egestas justo sagittis mollis. Nullam consectetur ligula non neque rutrum scelerisque. Phasellus urna augue, auctor sit amet vestibulum eu, gravida ac est. Nam elit arcu, imperdiet sit amet tincidunt ac, adipiscing et ipsum. Maecenas dolor mi, faucibus a malesuada et, venenatis vitae purus.'),
(6, 2, 'de', 'Business Good #2', 'Suite 208, 155 King Street, Sydney NSW 2000', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Cras eleifend faucibus leo et cursus. Nullam blandit lectus sit amet risus sollicitudin rhoncus. Praesent a nibh egestas justo sagittis mollis. Nullam consectetur ligula non neque rutrum scelerisque. Phasellus urna augue, auctor sit amet vestibulum eu, gravida ac est. Nam elit arcu, imperdiet sit amet tincidunt ac, adipiscing et ipsum. Maecenas dolor mi, faucibus a malesuada et, venenatis vitae purus.');


DROP TABLE IF EXISTS `<DB_PREFIX>listings_locations`;
CREATE TABLE IF NOT EXISTS `<DB_PREFIX>listings_locations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `is_active` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3 ;

INSERT INTO `<DB_PREFIX>listings_locations` (`id`, `name`, `is_active`) VALUES
(1, 'New York', 1),
(2, 'Kansas', 1);


DROP TABLE IF EXISTS `<DB_PREFIX>listings_sub_locations`;
CREATE TABLE IF NOT EXISTS `<DB_PREFIX>listings_sub_locations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `location_id` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

INSERT INTO `<DB_PREFIX>listings_sub_locations` (`id`, `location_id`, `name`) VALUES
(1, 2, 'Wichita'),
(2, 1, 'New York'),
(3, 1, 'Buffalo');


DROP TABLE IF EXISTS `<DB_PREFIX>menus`;
CREATE TABLE IF NOT EXISTS `<DB_PREFIX>menus` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menu_code` varchar(10) CHARACTER SET latin1 NOT NULL,
  `language_id` varchar(2) CHARACTER SET latin1 NOT NULL,
  `menu_name` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `menu_placement` enum('','left','top','right','bottom','hidden') CHARACTER SET latin1 NOT NULL,
  `menu_order` tinyint(3) DEFAULT '1',
  `access_level` enum('public','registered') CHARACTER SET latin1 NOT NULL DEFAULT 'public',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=9 ;

INSERT INTO `<DB_PREFIX>menus` (`id`, `menu_code`, `language_id`, `menu_name`, `menu_placement`, `menu_order`, `access_level`) VALUES
(1, 'AWSERTVERT', 'en', 'General', 'left', 2, 'public'),
(2, 'AWSERTVERT', 'es', 'General', 'left', 1, 'public'),
(3, 'AWSERTVERT', 'de', 'Allgemeine', 'left', 1, 'public'),
(4, 'LE8W11HJ3Q', 'en', 'Help & Information', 'top', 1, 'public'),
(5, 'LE8W11HJ3Q', 'es', 'Menú superior', 'top', 2, 'public'),
(6, 'LE8W11HJ3Q', 'de', 'Top-Menü', 'top', 2, 'public'),
(7, 'OEDA3PCIEI', 'es', 'ertertert', 'hidden', 3, 'public'),
(8, 'OEDA3PCIEI', 'de', 'ertertert', 'hidden', 3, 'public');


DROP TABLE IF EXISTS `<DB_PREFIX>modules`;
CREATE TABLE IF NOT EXISTS `<DB_PREFIX>modules` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `name_const` varchar(20) CHARACTER SET latin1 NOT NULL,
  `description_const` varchar(30) CHARACTER SET latin1 NOT NULL,
  `icon_file` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `module_tables` varchar(255) CHARACTER SET latin1 NOT NULL,
  `dependent_modules` varchar(20) CHARACTER SET latin1 NOT NULL,
  `settings_page` varchar(30) CHARACTER SET latin1 NOT NULL,
  `settings_const` varchar(30) CHARACTER SET latin1 NOT NULL,
  `settings_access_by` varchar(50) CHARACTER SET latin1 NOT NULL,
  `management_page` varchar(125) CHARACTER SET latin1 NOT NULL,
  `management_const` varchar(125) CHARACTER SET latin1 NOT NULL,
  `management_access_by` varchar(50) CHARACTER SET latin1 NOT NULL,
  `is_installed` tinyint(1) NOT NULL DEFAULT '0',
  `is_system` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `priority_order` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=15 ;

INSERT INTO `<DB_PREFIX>modules` (`id`, `name`, `name_const`, `description_const`, `icon_file`, `module_tables`, `dependent_modules`, `settings_page`, `settings_const`, `settings_access_by`, `management_page`, `management_const`, `management_access_by`, `is_installed`, `is_system`, `priority_order`) VALUES
(1, 'backup', '_BACKUP_AND_RESTORE', '_MD_BACKUP_AND_RESTORE', 'backup.png', '', '', 'mod_backup_installation', '_BACKUP_INSTALLATION', 'owner', 'mod_backup_restore', '_BACKUP_RESTORE', 'owner', 1, 0, 13),
(2, 'news', '_NEWS', '_MD_NEWS', 'news.png', 'news,events_registered,news_subscribed', '', 'mod_news_settings', '_NEWS_SETTINGS', 'owner,mainadmin', 'mod_news_management,mod_news_subscribed', '_NEWS_MANAGEMENT,_SUBSCRIPTION_MANAGEMENT', '', 1, 0, 9),
(3, 'customers', '_CUSTOMERS', '_MD_CUSTOMERS', 'customers.png', 'customers', '', 'mod_customers_settings', '_CUSTOMERS_SETTINGS', 'owner,mainadmin', '', '', '', 1, 0, 2),
(4, 'gallery', '_GALLERY', '_MD_GALLERY', 'gallery.png', 'gallery_albums,gallery_images', '', 'mod_gallery_settings', '_GALLERY_SETTINGS', 'owner,mainadmin', 'mod_gallery_management', '_GALLERY_MANAGEMENT', 'owner,mainadmin', 1, 0, 8),
(5, 'contact_us', '_CONTACT_US', '_MD_CONTACT_US', 'contact_us.png', '', '', 'mod_contact_us_settings', '_CONTACT_US_SETTINGS', 'owner,mainadmin', '', '', '', 1, 0, 5),
(6, 'comments', '_COMMENTS', '_MD_COMMENTS', 'comments.png', 'comments', '', 'mod_comments_settings', '_COMMENTS_SETTINGS', 'owner,mainadmin', 'mod_comments_management', '_COMMENTS_MANAGEMENT', 'owner,mainadmin', 1, 0, 6),
(7, 'banners', '_BANNERS', '_MD_BANNERS', 'banners.png', 'banners', '', 'mod_banners_settings', '_BANNERS_SETTINGS', 'owner,mainadmin', 'mod_banners_management', '_BANNERS_MANAGEMENT', '', 1, 0, 7),
(8, 'listings', '_LISTINGS', '_MD_LISTINGS', 'listings.png', 'categories,categories_description,listings,listings_categories,listings_description,listings_locations,listings_sub_locations', '', 'mod_listings_settings', '_LISTINGS_SETTINGS', 'owner,mainadmin', '', '', '', 1, 1, 1),
(9, 'pages', '_PAGES', '_MD_PAGES', 'pages.png', 'pages,menus', '', '', '', 'owner,mainadmin', 'pages', '_PAGE_EDIT_PAGES', 'owner,mainadmin', 1, 1, 0),
(10, 'faq', '_FAQ', '_MD_FAQ', 'faq.png', 'faq_categories,faq_category_items', '', 'mod_faq_settings', '_FAQ_SETTINGS', 'owner,mainadmin', 'mod_faq_management', '_FAQ_MANAGEMENT', 'owner,mainadmin', 1, 0, 10),
(11, 'adsense', '_ADSENSE', '_MD_ADSENSE', 'adsense.png', 'adsense', '', 'mod_adsense_settings', '_ADSENSE_SETTINGS', 'owner,mainadmin', '', '', '', 1, 0, 11),
(12, 'payments', '_PAYMENTS', '_MD_PAYMENTS', 'payments.png', 'advertise_plans,advertise_plans_description', '', 'mod_payments_settings', '_PAYMENTS_SETTINGS', 'owner,mainadmin', '', '', '', 1, 0, 4),
(13, 'inquiries', '_INQUIRIES', '_MD_INQUIRIES', 'inquiries.png', 'inquiries,inquiries_replies,inquiries_history', '', 'mod_inquiries_settings', '_INQUIRIES_SETTINGS', 'owner,mainadmin', 'mod_inquiries_management', '_INQUIRIES_MANAGEMENT', '', 1, 0, 3),
(14, 'ratings', '_RATINGS', '_MD_RATINGS', 'ratings.png', 'ratings_items,ratings_users', '', 'mod_ratings_settings', '_RATINGS_SETTINGS', 'owner,mainadmin', '', '', '', 1, 0, 12);


DROP TABLE IF EXISTS `<DB_PREFIX>modules_settings`;
CREATE TABLE IF NOT EXISTS `<DB_PREFIX>modules_settings` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `module_name` varchar(20) CHARACTER SET latin1 NOT NULL,
  `settings_key` varchar(40) CHARACTER SET latin1 NOT NULL,
  `settings_value` text COLLATE utf8_unicode_ci NOT NULL,
  `settings_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `settings_description_const` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `key_display_type` enum('string','email','numeric','unsigned float','integer','positive integer','unsigned integer','enum','yes/no','html size','text') CHARACTER SET latin1 NOT NULL,
  `key_is_required` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `key_display_source` varchar(255) CHARACTER SET latin1 NOT NULL,
  PRIMARY KEY (`id`),
  KEY `module_name` (`module_name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=80 ;

INSERT INTO `<DB_PREFIX>modules_settings` (`id`, `module_name`, `settings_key`, `settings_value`, `settings_name`, `settings_description_const`, `key_display_type`, `key_is_required`, `key_display_source`) VALUES
(1, 'adsense', 'adsense_code_vertical', '<script type="text/javascript"><!--\r\ngoogle_ad_client = "pub-4565616509262388";\r\ngoogle_ad_slot = "2789161271";\r\ngoogle_ad_width = 120;\r\ngoogle_ad_height = 240;\r\n//-->\r\n</script>\r\n<script type="text/javascript" src="http://pagead2.googlesyndication.com/pagead/show_ads.js"></script>', 'Vertical Ad Code', '_MS_ADSENSE_CODE_VERTICAL', 'text', 0, ''),
(2, 'adsense', 'adsense_code_activation', 'All', 'Code Activation', '_MS_ADSENSE_CODE_ACTIVATION', 'enum', 1, 'Horizontal,Vertical,All,None'),
(3, 'adsense', 'adsense_code_horizontal', '<script type="text/javascript"><!--\r\ngoogle_ad_client = "pub-4565616509262388";\r\ngoogle_ad_slot = "2880844154";\r\ngoogle_ad_width = 468;\r\ngoogle_ad_height = 60;\r\n//-->\r\n</script>\r\n<script type="text/javascript"\r\nsrc="http://pagead2.googlesyndication.com/pagead/show_ads.js">\r\n</script>', 'Horizontal Ad Code', '_MS_ADSENSE_CODE_HORIZONTAL', 'text', 0, ''),
(4, 'banners', 'is_active', 'no', 'Activate Banners', '_MS_BANNERS_IS_ACTIVE', 'yes/no', 1, ''),
(5, 'banners', 'rotation_type', 'slide show', 'Rotation Type', '_MS_ROTATION_TYPE', 'enum', 0, 'random image,slide show'),
(6, 'banners', 'rotate_delay', '9', 'Rotation Delay', '_MS_ROTATE_DELAY', 'positive integer', 1, ''),
(7, 'banners', 'slideshow_caption_html', 'no', 'HTML in Slideshow Caption', '_MS_BANNERS_CAPTION_HTML', 'yes/no', 1, ''),
(8, 'comments', 'comments_allow', 'yes', 'Allow Comments', '_MS_COMMENTS_ALLOW', 'yes/no', 1, ''),
(9, 'comments', 'user_type', 'all', 'User Type', '_MS_USER_TYPE', 'enum', 1, 'all,registered'),
(10, 'comments', 'comment_length', '500', 'Comment Length', '_MS_COMMENTS_LENGTH', 'positive integer', 1, ''),
(11, 'comments', 'image_verification_allow', 'yes', 'Image Verification', '_MS_IMAGE_VERIFICATION_ALLOW', 'yes/no', 1, ''),
(12, 'comments', 'page_size', '10', 'Comments Per Page', '_MS_COMMENTS_PAGE_SIZE', 'positive integer', 1, ''),
(13, 'comments', 'pre_moderation_allow', 'yes', 'Comments Pre-Moderation', '_MS_PRE_MODERATION_ALLOW', 'yes/no', 1, ''),
(14, 'comments', 'delete_pending_time', '2', 'Pending Time', '_MS_DELETE_PENDING_TIME', 'enum', 1, '0,1,2,3,4,5,6,7,8,9,10,15,20,30,45,60,120,180'),
(15, 'contact_us', 'email', 'contact@yourdomain.com', 'Contact Email', '_MS_EMAIL', 'email', 1, ''),
(16, 'contact_us', 'key', '{module:contact_us}', 'Contact Key', '_MS_CONTACT_US_KEY', 'enum', 1, '{module:contact_us}'),
(17, 'contact_us', 'is_send_delay', 'yes', 'Sending Delay', '_MS_IS_SEND_DELAY', 'yes/no', 1, ''),
(18, 'contact_us', 'delay_length', '20', 'Delay Length', '_MS_DELAY_LENGTH', 'positive integer', 0, ''),
(19, 'contact_us', 'image_verification_allow', 'yes', 'Image Verification', '_MS_IMAGE_VERIFICATION_ALLOW', 'yes/no', 0, ''),
(20, 'customers', 'allow_adding_by_admin', 'yes', 'Admin Creates Customers', '_MS_ALLOW_ADDING_BY_ADMIN', 'yes/no', 1, ''),
(21, 'customers', 'reg_confirmation', 'by email', 'Confirmation Type', '_MS_REG_CONFIRMATION', 'enum', 0, 'automatic,by email,by admin'),
(22, 'customers', 'allow_login', 'yes', 'Allow Customers to Login', '_MS_ALLOW_CUST_LOGIN', 'yes/no', 0, ''),
(23, 'customers', 'allow_registration', 'yes', 'Allow Customers to Register', '_MS_ALLOW_CUST_REGISTRATION', 'yes/no', 1, ''),
(24, 'customers', 'image_verification_allow', 'yes', 'Image Verification', '_MS_CUST_IMAGE_VERIFICATION', 'yes/no', 1, ''),
(25, 'customers', 'allow_reset_passwords', 'yes', 'Allow Reset Passwords', '_MS_ALLOW_CUST_RESET_PASSWORDS', 'yes/no', 1, ''),
(26, 'customers', 'remember_me_allow', 'no', 'Remember Me', '_MS_REMEMBER_ME', 'yes/no', 1, ''),
(27, 'customers', 'admin_alert_new_registration', 'yes', 'Alert Admin On New  Registration', '_MS_ALERT_ADMIN_NEW_REGISTRATION', 'yes/no', 1, ''),
(28, 'customers', 'password_changing_by_admin', 'no', 'Admin Changes User Password', '_MS_ADMIN_CHANGE_USER_PASSWORD', 'yes/no', 1, ''),
(29, 'faq', 'is_active', 'yes', 'Activate FAQ', '_MS_FAQ_IS_ACTIVE', 'yes/no', 1, ''),
(30, 'gallery', 'image_gallery_type', 'lytebox', 'Image Gallery Type', '_MS_IMAGE_GALLERY_TYPE', 'enum', 1, 'lytebox,rokbox'),
(31, 'gallery', 'video_gallery_type', 'rokbox', 'Video Gallery Type', '_MS_VIDEO_GALLERY_TYPE', 'enum', 1, 'rokbox,videobox'),
(32, 'gallery', 'key', '{module:gallery}', 'Gallery Key', '_MS_GALLERY_KEY', 'enum', 1, '{module:gallery}'),
(33, 'gallery', 'album_key', '{module:album=CODE}', 'Album Key', '_MS_ALBUM_KEY', 'enum', 1, '{module:album=CODE}'),
(34, 'gallery', 'album_icon_width', '120px', 'Album Icon Width', '_MS_ALBUM_ICON_WIDTH', 'html size', 1, ''),
(35, 'gallery', 'album_icon_height', '90px', 'Album Icon Height', '_MS_ALBUM_ICON_HEIGHT', 'html size', 1, ''),
(36, 'gallery', 'albums_per_line', '4', 'Albums Per Line', '_MS_ALBUMS_PER_LINE', 'positive integer', 1, ''),
(37, 'gallery', 'wrapper', 'table', 'HTML Wrapping Tag', '_MS_GALLERY_WRAPPER', 'enum', 1, 'table,div'),
(38, 'gallery', 'show_items_count_in_album', 'yes', 'Show Items Count in Album', '_MS_ALBUM_ITEMS_COUNT', 'yes/no', 1, ''),
(39, 'inquiries', 'maximum_replies', '5', 'Maximum Number of Replies', '_MS_MAXIMUM_REPLIES', 'enum', 1, '1,2,3,4,5,6,7,8,9,10'),
(40, 'inquiries', 'direct_inquiry_allow', 'yes', 'Allow Direct Inquiry', '_MS_ALLOW_DIRECT_INQUIRY', 'yes/no', 1, ''),
(41, 'inquiries', 'show_inquiries_block', 'right side', 'Last Inquiries Block', '_MS_SHOW_INQUIRIES_BLOCK_BLOCK', 'enum', 1, 'no,left side,right side'),
(42, 'inquiries', 'keep_history_days', '730', 'Keep History', '_MS_KEEP_HISTORY_DAYS', 'positive integer', 1, ''),
(43, 'listings', 'show_categories_side_block', 'left side', 'Categories Side Block', '_MS_SHOW_CATEGORIES_SIDE_BLOCK', 'enum', 1, 'no,left side,right side'),
(44, 'listings', 'show_categories_home_block', 'yes', 'Categories Home Page Block', '_MS_SHOW_CATEGORIES_HOME_BLOCK', 'yes/no', 1, ''),
(45, 'listings', 'show_categories_images', 'yes', 'Categories Images', '_MS_CATEGORIES_IMAGES', 'yes/no', 1, ''),
(46, 'listings', 'columns_number_on_page', '2', 'Columns On Page', '_MS_COLUMNS_ON_PAGE', 'enum', 1, '1,2,3,4,5'),
(47, 'listings', 'pre_moderation_allow', 'yes', 'Listings Pre-Moderation', '_MS_LIST_PRE_MODERATION_ALLOW', 'yes/no', 1, ''),
(48, 'listings', 'show_featured_block', 'right side', 'Featured Listings Block', '_MS_SHOW_FEATURED_BLOCK', 'enum', 1, 'no,left side,right side'),
(49, 'listings', 'show_recent_block', 'right side', 'Recent Listings Block', '_MS_SHOW_RECENT_BLOCK', 'enum', 1, 'no,left side,right side'),
(50, 'listings', 'listings_per_page', '10', 'Listings Per Page', '_MS_LISTINGS_PER_PAGE', 'positive integer', 1, ''),
(51, 'listings', 'show_directory_statistics', 'right side', 'Directory Statistics Block', '_MS_SHOW_DIRECTORY_STATISTICS', 'enum', 1, 'no,left side,right side'),
(52, 'listings', 'listings_name_length', '90', 'Listing Name Length', '_MS_LISTINGS_NAME_LENGTH', 'positive integer', 1, ''),
(53, 'listings', 'show_expired_listings', 'yes', 'Show Expired Listings', '_MS_SHOW_EXPIRED_LISTINGS', 'yes/no', 1, ''),
(54, 'listings', 'maximum_categories', '5', 'Multiple Categories', '_MS_MULTIPLE_CATEGORIES', 'enum', 1, '1,2,3,4,5'),
(55, 'listings', 'sub_categories_count', '10', 'Sub-Categories On Home Page', '_MS_SUB_CATEGORIES_COUNT', 'enum', 1, '1,2,3,4,5,6,7,8,9,10,11,12,13,14,15'),
(56, 'listings', 'watermark', 'no', 'Add Watermark to Images', '_MS_ADD_WATERMARK', 'yes/no', 1, ''),
(57, 'listings', 'watermark_text', 'ApPHP Business Directory', 'Watermark Text', '_MS_WATERMARK_TEXT', 'string', 0, ''),
(58, 'news', 'news_count', '5', 'News Count', '_MS_NEWS_COUNT', 'positive integer', 1, ''),
(59, 'news', 'news_header_length', '80', 'News Header Length', '_MS_NEWS_HEADER_LENGTH', 'positive integer', 1, ''),
(60, 'news', 'news_rss', 'yes', 'News RSS', '_MS_NEWS_RSS', 'yes/no', 1, ''),
(61, 'news', 'show_news_block', 'left side', 'News Block', '_MS_SHOW_NEWS_BLOCK', 'enum', 1, 'no,left side,right side'),
(62, 'news', 'show_newsletter_subscribe_block', 'right side', 'Newsletter Subscription', '_MS_SHOW_NEWSLETTER_SUBSCRIBE_BLOCK', 'enum', 1, 'no,left side,right side'),
(63, 'payments', 'is_active', 'yes', 'Activate Payments', '_MS_PAYMENTS_ACTIVE', 'yes/no', 1, ''),
(64, 'payments', 'payment_method_online', 'yes', '&#8226; ''On-line Order'' Payment Method', '_MS_PAYMENT_METHOD_ONLINE', 'yes/no', 1, ''),
(65, 'payments', 'online_collect_credit_card', 'yes', '&nbsp; Credit Cards for ''On-line Orders''', '_MS_ONLINE_COLLECT_CREDIT_CARD', 'yes/no', 0, ''),
(66, 'payments', 'payment_method_paypal', 'yes', '&#8226; PayPal Payment Method', '_MS_PAYMENT_METHOD_PAYPAL', 'yes/no', 1, ''),
(67, 'payments', 'paypal_email', 'paypal@yourdomain.com', '&nbsp; PayPal Email', '_MS_PAYPAL_EMAIL', 'email', 1, ''),
(68, 'payments', 'payment_method_2co', 'yes', '&#8226; 2CO Payment Method', '_MS_PAYMENT_METHOD_2CO', 'yes/no', 0, ''),
(69, 'payments', 'two_checkout_vendor', 'Your Vendor ID', '&nbsp; 2CO Vendor ID', '_MS_TWO_CHECKOUT_VENDOR', 'string', 1, ''),
(70, 'payments', 'payment_method_authorize', 'yes', '&#8226; Authorize.Net Payment Method', '_MS_PAYMENT_METHOD_AUTHORIZE', 'yes/no', 1, ''),
(71, 'payments', 'authorize_login_id', 'Your Login ID', '&nbsp; Authorize.Net Login ID', '_MS_AUTHORIZE_LOGIN_ID', 'string', 1, ''),
(72, 'payments', 'authorize_transaction_key', 'Your Transaction Key', '&nbsp; Authorize.Net Transaction Key', '_MS_AUTHORIZE_TRANSACTION_KEY', 'string', 1, ''),
(73, 'payments', 'default_payment_system', 'paypal', 'Default Payment System', '_MS_DEFAULT_PAYMENT_SYSTEM', 'enum', 1, 'online,paypal,2co,authorize.net'),
(74, 'payments', 'vat_value', '0', 'VAT Value', '_MS_VAT_VALUE', 'unsigned float', 0, ''),
(75, 'payments', 'send_order_copy_to_admin', 'yes', 'Send Order Copy To Admin', '_MS_SEND_ORDER_COPY_TO_ADMIN', 'yes/no', 0, ''),
(76, 'payments', 'mode', 'REAL MODE', 'Payment Mode', '_MS_PAYMENTS_MODE', 'enum', 1, 'TEST MODE,REAL MODE'),
(77, 'payments', 'maximum_allowed_orders', '10', 'Maximum Allowed Orders', '_MS_MAXIMUM_ALLOWED_ORDERS', 'positive integer', 1, ''),
(78, 'ratings', 'user_type', 'all', 'User Type', '_MS_RATINGS_USER_TYPE', 'enum', 1, 'all,registered'),
(79, 'ratings', 'multiple_items_per_day', 'yes', 'Multiple Items per Day', '_MS_MULTIPLE_ITEMS_PER_DAY', 'yes/no', 1, '');


DROP TABLE IF EXISTS `<DB_PREFIX>news`;
CREATE TABLE IF NOT EXISTS `<DB_PREFIX>news` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `news_code` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `language_id` varchar(2) CHARACTER SET latin1 NOT NULL,
  `type` enum('news','events') CHARACTER SET latin1 NOT NULL DEFAULT 'news',
  `header_text` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `body_text` text COLLATE utf8_unicode_ci NOT NULL,
  `date_created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `language_id` (`language_id`),
  KEY `type` (`type`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

INSERT INTO `<DB_PREFIX>news` (`id`, `news_code`, `language_id`, `type`, `header_text`, `body_text`, `date_created`) VALUES
(1, 'swert4r659', 'en', 'news', 'New version 3.0.1 of ApPHP Business Directory was released!', '<p>The new version 3.0.1 of ApPHP Business Directory Pro is available for downloading. There are many additions and improvements in this version like: new CSS template, new modules, new features etc. You can review all recent changes here.</p>', '2013-02-13 16:19:53'),
(2, 'swert4r659', 'es', 'news', 'Nueva versión 3.0.1 de ApPHP Business Directory fue puesto en libertad!', '<p>La nueva versión 3.0.1 de ApPHP Business Directory Pro está disponible para su descarga. Hay muchas adiciones y mejoras en esta versión como: CSS nueva plantilla, canal RSS de noticias, etc de gestión de los administradores Usted puede revisar todos los cambios recientes aquí.</p>', '2013-02-13 16:26:58'),
(3, 'swert4r659', 'de', 'news', 'Neue Version 3.0.1 von ApPHP Business Directory veröffentlicht wurde!', '<p>Die neue Version 3.0.1 von ApPHP Business Directory Pro zum Download zur Verfügung. Es gibt viele Erweiterungen und Verbesserungen in dieser Version wie: neue CSS-Template, RSS Kanal für Nachrichten, Administratoren Management usw. Sie alle bisherigen Änderungen Beitrag kann hier.</p>', '2013-02-13 16:27:15');


DROP TABLE IF EXISTS `<DB_PREFIX>news_subscribed`;
CREATE TABLE IF NOT EXISTS `<DB_PREFIX>news_subscribed` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `email` varchar(70) COLLATE utf8_unicode_ci NOT NULL,
  `date_subscribed` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;


DROP TABLE IF EXISTS `<DB_PREFIX>orders`;
CREATE TABLE IF NOT EXISTS `<DB_PREFIX>orders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_number` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `order_description` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `order_price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `vat_percent` decimal(4,2) NOT NULL DEFAULT '0.00',
  `vat_fee` decimal(10,2) NOT NULL DEFAULT '0.00',
  `total_price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00',
  `currency` varchar(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'USD',
  `advertise_plan_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `listings_amount` smallint(4) NOT NULL DEFAULT '0',
  `customer_id` int(11) NOT NULL DEFAULT '0',
  `transaction_number` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `created_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `payment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `payment_type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '0 - Online Order, 1 - PayPal, 2 - 2CO, 3 - Authorize.Net',
  `payment_method` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '0 - Payment Company Account, 1 - Credit Card, 2 - E-Check',
  `coupon_number` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `discount_campaign_id` int(10) DEFAULT '0',
  `additional_info` text COLLATE utf8_unicode_ci NOT NULL,
  `cc_type` varchar(20) CHARACTER SET latin1 NOT NULL,
  `cc_holder_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `cc_number` varchar(50) CHARACTER SET latin1 NOT NULL,
  `cc_expires_month` varchar(2) CHARACTER SET latin1 NOT NULL,
  `cc_expires_year` varchar(4) CHARACTER SET latin1 NOT NULL,
  `cc_cvv_code` varchar(4) CHARACTER SET latin1 NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0 - preparing, 1 - pending, 2 - paid, 3 - completed, 4 - refunded',
  `status_changed` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `email_sent` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `payment_type` (`payment_method`),
  KEY `status` (`status`),
  KEY `advertise_plan_id` (`advertise_plan_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;


DROP TABLE IF EXISTS `<DB_PREFIX>pages`;
CREATE TABLE IF NOT EXISTS `<DB_PREFIX>pages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_code` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `language_id` varchar(2) CHARACTER SET latin1 NOT NULL,
  `content_type` enum('article','link','') CHARACTER SET latin1 NOT NULL DEFAULT 'article',
  `link_url` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `link_target` enum('','_self','_blank') CHARACTER SET latin1 NOT NULL,
  `page_key` varchar(125) COLLATE utf8_unicode_ci DEFAULT NULL,
  `page_title` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `page_text` text COLLATE utf8_unicode_ci,
  `menu_id` int(11) DEFAULT '0',
  `menu_link` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tag_title` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `tag_keywords` text COLLATE utf8_unicode_ci NOT NULL,
  `tag_description` text COLLATE utf8_unicode_ci NOT NULL,
  `comments_allowed` tinyint(1) NOT NULL DEFAULT '0',
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `finish_publishing` date NOT NULL DEFAULT '0000-00-00',
  `is_home` tinyint(1) NOT NULL DEFAULT '0',
  `is_removed` tinyint(1) NOT NULL DEFAULT '0',
  `is_published` tinyint(1) NOT NULL DEFAULT '0',
  `is_system_page` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `system_page` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `show_in_search` tinyint(1) NOT NULL DEFAULT '1',
  `status_changed` datetime NOT NULL,
  `access_level` enum('public','registered') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'public',
  `priority_order` smallint(6) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `is_published` (`is_published`),
  KEY `is_removed` (`is_removed`),
  KEY `language_id` (`language_id`),
  KEY `comments_allowed` (`comments_allowed`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=19 ;

INSERT INTO `<DB_PREFIX>pages` (`id`, `page_code`, `language_id`, `content_type`, `link_url`, `link_target`, `page_key`, `page_title`, `page_text`, `menu_id`, `menu_link`, `tag_title`, `tag_keywords`, `tag_description`, `comments_allowed`, `date_created`, `date_updated`, `finish_publishing`, `is_home`, `is_removed`, `is_published`, `is_system_page`, `system_page`, `show_in_search`, `status_changed`, `access_level`, `priority_order`) VALUES
(1, '6cl1jg6qyq', 'en', 'article', '', '_self', 'Welcome-to-ApPHP-Business-Directory', 'Welcome to ApPHP Business Directory!', '<p><strong>ApPHP Business Directory</strong>&nbsp;is a simple, but powerful Business Directory solution. This script allows to add&nbsp;categories, then associate added businesses to&nbsp;these categories. You may also add business profiles including basic business contact info, business description, website link, e-mail contact, categories, map links etc. ApPHP Business Directory was developed in OOP and allows you to <strong>build business directory website</strong> in a few minutes and then easy <strong>add and edit the content</strong>. <br><br>ApPHP Business Directory provides you with all features you need to setup your own ecommerce directory website on your own domain name. We provide you all things you need for a successful website such as: listings management, search engine friendly urls, database backup, advanced text editor,&nbsp; banner rotation system etc. So it is really easy to start your own successful directory website. </p>\r\n<p>This script is an excellent tool for those who: </p>\r\n<ul class="normal">\r\n<li>Want to create online business directory website \r\n</li><li>Look for small, but powerful Business Directory \r\n</li><li>Need to build quickly a secure business directory&nbsp;web site</li></ul>', 0, 'Welcome', 'ApPHP Business Directory', 'php business directory', 'ApPHP Business Directory - business listings directory solution ', 0, '0000-00-00 00:00:00', '2013-02-13 16:09:35', '0000-00-00', 1, 0, 1, 0, '', 1, '2010-04-22 19:53:44', 'public', 1),
(2, '6cl1jg6qyq', 'es', 'article', '', '_self', 'Bienvenido-a-ApPHP-Business-Directory', 'Bienvenido a ApPHP Business Directory!', '<P><STRONG>ApPHP Business Directory&nbsp;</STRONG>es un simple, pero potente solución de Business Directory. Este script permite añadir categorías, a continuación, asociar agregó empresas a estas categorías. También puede agregar perfiles de negocio, incluyendo información básica de contacto de negocios, descripción del negocio, enlace al sitio web, póngase en contacto por e-mail, las categorías de enlaces, mapa, etc. ApPHP Directorio se desarrolló en programación orientada a objetos y permite que usted construya business página web de la guía en pocos minutos y luego fácil de añadir y editar contenido..</P>\r\n<P>ApPHP Directorio de Empresas te ofrece todas las características que usted necesita para configurar su propia página web de la guía de comercio electrónico en su propio nombre de dominio. Ponemos a su disposición todas las cosas que usted necesita para un sitio web exitoso, tales como: gestión de listas, las urls amigables para los motores de búsqueda, copia de seguridad de base de datos, editor de texto avanzado, sistema de rotación de banners, etc Por lo tanto, es muy fácil para comenzar su propio sitio web de la guía de éxito..</P>\r\n<P>&nbsp;El PHPBD es una excelente herramienta para aquellos que:</P>\r\n<UL>\r\n<LI>Quieres crear sitio web en línea de la guía de negocios \r\n<LI>Puedes buscar pequeño, pero poderoso Directorio de Empresas \r\n<LI>Necesidad de construir rápidamente un directorio de negocios seguras sitio web</LI></UL>', 0, '', 'ApPHP Business Directory', 'php business directory', 'ApPHP Business Directory - solución de negocio de directorios listados', 0, '0000-00-00 00:00:00', '2012-02-28 13:00:16', '0000-00-00', 1, 0, 1, 0, '', 1, '2010-04-21 19:53:41', 'public', 0),
(3, '6cl1jg6qyq', 'de', 'article', '', '_self', 'Willkommen-auf-ApPHP-Business-Directory', 'Willkommen auf ApPHP Business Directory!', '<P><STRONG>ApPHP Business Directory&nbsp;</STRONG>ist ein einfaches, aber leistungsfähiges Business Directory-Lösung. Dieses Skript erlaubt es, Kategorien hinzufügen, hat dann assoziieren Unternehmen in diesen Kategorien. Sie können auch hinzufügen Geschäft Profile einschließlich Basisgeschäft Kontaktinfos, eine Beschreibung des Unternehmens, Website-Link, E-Mail zu kontaktieren, Kategorien, Links etc. Karte ApPHP Business Directory in OOP entwickelt und ermöglicht es Ihnen, direkt business Webseite in ein paar Minuten und dann bauen einfach hinzufügen und bearbeiten die Inhalte.</P>\r\n<P>ApPHP Business Directory bietet Ihnen alle Funktionen, die Sie brauchen, um Ihr eigenes Setup E-Commerce-Verzeichnis auf Ihrer eigenen Domain-Namen. Wir bieten Ihnen alles was Sie für eine erfolgreiche Website wie: Anzeigen-Management, Suchmaschinen-freundliche URLs, Datenbank-Backup, fortschrittliche Text-Editor, Banner Rotation usw. Also es ist wirklich einfach, Ihre eigene erfolgreiche Internetseite direkt zu starten.</P>\r\n<P>Die PHP-BD ist ein ausgezeichnetes Werkzeug für diejenigen, die:</P>\r\n<UL>\r\n<LI>Wollen Sie Online-Business-Verzeichnis Website zu erstellen \r\n<LI>Suchen Sie nach kleinen, aber leistungsstarken Business Directory \r\n<LI>Brauchen Sie schnell eine sichere Geschäftsprozesse direkt Website<BR></LI></UL>', 0, '', 'ApPHP Business Directory', 'php business directory', 'ApPHP Business Directory - Brancheneinträge Verzeichnis-Lösung', 0, '0000-00-00 00:00:00', '2012-02-28 13:00:09', '0000-00-00', 1, 0, 1, 0, '', 1, '2010-04-22 19:53:44', 'public', 1),
(4, 'mwsipvfgel', 'de', 'article', '', '_self', 'Kontakt', 'Kontakt', '<p>Es gibt drei Zwecke unserer Website:</p><p>Der Hauptzweck unserer Seite ist es, einen einfachen Service, vereinfachen bieten und sparen Zeit für den Kunden, den richtigen Handwerker zu finden. Viele fügen mehrere Stunden Gesprächszeit rund um viele verschiedene Handwerker zu versuchen, irgendeine Art von Vergleich zwischen ihnen zu erreichen. Hier haben wir es wieder einschalten und lassen die Handwerker an Kunden statt. Nur die Handwerker, die die Zeit und ausreichende Kompetenz haben auf Anfragen reagieren.</p><p>Bitte benutzen Sie das untenstehende Formular aus, um uns zu kontaktieren:</p><p>{module:contact_us}</p> <p>&nbsp;</p>', 6, 'Kontakt', 'ApPHP Business Directory', 'php business directory', 'ApPHP Business Directory - Brancheneinträge Verzeichnis-Lösung', 0, '0000-00-00 00:00:00', '2013-02-13 15:59:20', '0000-00-00', 0, 0, 1, 0, '', 1, '0000-00-00 00:00:00', 'public', 7),
(5, 'mwsipvfgel', 'en', 'article', '', '_self', 'Contact-Us', 'Contact Us', '<p>There are three purposes of our site:</p><p>The main purpose of our site is to offer a simple service that will simplify and save time for the customer to find the right craftsman. Many add several hours of calling around to many different craftsmen to try to reach some sort of comparison between them. Here we turn on it and let the craftsmen contact customers instead. Only the craftsmen who have the time and sufficient competence respond to requests.</p><p>Please use the form below to contact us:</p>\r\n<p>{module:contact_us}</p>\r\n<p>&nbsp;</p>', 4, 'Contact Us', 'ApPHP Business Directory', 'php business directory', 'ApPHP Business Directory - business listings directory solution ', 0, '0000-00-00 00:00:00', '2013-02-13 15:57:54', '0000-00-00', 0, 0, 1, 0, '', 1, '0000-00-00 00:00:00', 'public', 5),
(6, 'mwsipvfgel', 'es', 'article', '', '_self', 'Contacte-con-nosotros', 'Contacte con nosotros', '<div>Hay tres efectos de nuestro sitio:</div><div><br></div><div>El objetivo principal de nuestro sitio es ofrecer un servicio sencillo que va a simplificar y ahorrar tiempo para que el cliente pueda encontrar el artesano derecha. Muchos agregar varias horas de llamadas para muchos artesanos diferentes para tratar de llegar a algún tipo de comparación entre ellos. Aquí volvemos sobre ella y dejar que los artesanos contacto con los clientes en su lugar. Sólo los artesanos que tienen el tiempo y la competencia suficiente responder a las solicitudes.</div><div><br></div>Por favor, utilice el siguiente formulario para contactar con nosotros:<p></p> <p>{module:contact_us}</p> <p>&nbsp;</p>', 5, 'Contacte con nosotros', 'ApPHP Business Directory', 'php business directory', 'ApPHP Business Directory - solución de negocio de directorios listados', 0, '0000-00-00 00:00:00', '2013-02-13 16:00:49', '0000-00-00', 0, 0, 1, 0, '', 1, '0000-00-00 00:00:00', 'public', 5),
(7, 'j8hevfivri', 'en', 'article', '', '_self', 'Terms-and-Conditions', 'Terms and Conditions', '<h2>Terms and Conditions Sample</h2>\r\n<h3>Website usage terms and conditions - sample template</h3>\r\n<p>Welcome to our website. If you continue to browse and use this website, you are agreeing to comply with and be bound by the following terms and conditions of use, which together with our privacy policy govern [business name]''s relationship with you in relation to this website. If you disagree with any part of these terms and conditions, please do not use our website.</p>\r\n<p>The term "[business name]" or "us" or "we" refers to the owner of the website whose registered office is [address]. Our company registration number is [company registration number and place of registration]. The term "you" refers to the user or viewer of our website.</p>\r\n<p>The use of this website is subject to the following terms of use:</p>\r\n<ul>\r\n<li>The content of the pages of this website is for your general information and use only. It is subject to change without notice. \r\n</li><li>Neither we nor any third parties provide any warranty or guarantee as to the accuracy, timeliness, performance, completeness or suitability of the information and materials found or offered on this website for any particular purpose. You acknowledge that such information and materials may contain inaccuracies or errors and we expressly exclude liability for any such inaccuracies or errors to the fullest extent permitted by law. \r\n</li><li>Your use of any information or materials on this website is entirely at your own risk, for which we shall not be liable. It shall be your own responsibility to ensure that any products, services or information available through this website meet your specific requirements. \r\n</li><li>This website contains material which is owned by or licensed to us. This material includes, but is not limited to, the design, layout, look, appearance and graphics. Reproduction is prohibited other than in accordance with the copyright notice, which forms part of these terms and conditions. \r\n</li><li>All trademarks reproduced in this website, which are not the property of, or licensed to the operator, are acknowledged on the website. \r\n</li><li>Unauthorised use of this website may give rise to a claim for damages and/or be a criminal offence. \r\n</li><li>From time to time, this website may also include links to other websites. These links are provided for your convenience to provide further information. They do not signify that we endorse the website(s). We have no responsibility for the content of the linked website(s). \r\n</li><li>Your use of this website and any dispute arising out of such use of the website is subject to the laws of England, Northern Ireland, Scotland and Wales.</li></ul>', 0, 'Terms and Conditions', 'ApPHP Business Directory', 'php business directory', 'ApPHP Business Directory - business listings directory solution ', 0, '2011-03-22 16:36:17', '2013-01-30 09:28:12', '0000-00-00', 0, 0, 1, 1, 'terms_and_conditions', 1, '0000-00-00 00:00:00', 'public', 24),
(8, 'j8hevfivri', 'es', 'article', '', '_self', 'Términos-y-Condiciones', 'Términos y Condiciones', '<H2>Términos y Condiciones de muestra</H2>\r\n<H3>Términos del sitio web de uso y condiciones - plantilla de ejemplo</H3>\r\n<P>Bienvenido a nuestro sitio web. Si continúa navegando y utilizando este sitio web, usted acepta cumplir y estar obligado por los siguientes términos y condiciones de uso, que junto con nuestra política de privacidad gobiernan la relación de las empresas [nombre] ''s con usted en relación a este sitio web. Si no está de acuerdo con alguna parte de estos términos y condiciones, por favor no utilice nuestro sitio web.</P>\r\n<P>El término "[nombre de la empresa]" o "nosotros" se refiere a la titular del sitio web cuyo domicilio social es [dirección]. Nuestro número de registro de la empresa es [número de registro de la empresa y lugar de registro]. El término "usted" se refiere al usuario o visitante de nuestro sitio web.</P>\r\n<P>El uso de este sitio web está sujeta a las siguientes condiciones de uso:</P>\r\n<UL>\r\n<LI>El contenido de las páginas de este sitio web es para su información y uso general. Está sujeto a cambios sin previo aviso. \r\n<LI>Ni nosotros ni ningún tercero ofrece ninguna garantía en cuanto a la exactitud, puntualidad, rendimiento, integridad o adecuación de la información y los materiales encontrados u ofrecidos en este sitio para cualquier propósito en particular. Usted reconoce que dicha información y materiales pueden contener inexactitudes o errores y expreso excluimos la responsabilidad por cualquier inexactitud o errores en la máxima medida permitida por la ley. \r\n<LI>El uso de cualquier información o materiales contenidos en este sitio web es bajo su propio riesgo, para lo cual no se hace responsable. Será su responsabilidad para garantizar que cualquier producto, servicio o información disponible a través de este sitio Web a sus necesidades específicas. \r\n<LI>Este sitio web contiene material que es propiedad de o licenciadas a nosotros. Este material incluye, pero no limitado a, el diseño, el diseño, apariencia y gráficos. La reproducción está prohibida salvo de conformidad con la nota de copyright, que forma parte de estos términos y condiciones. \r\n<LI>Todas las marcas reproducidas en esta página web, que no son propiedad de, o con licencia para el operador, se reconoció en la página web. \r\n<LI>El uso no autorizado de este sitio web puede dar lugar a una reclamación por daños y perjuicios y/o constituir un delito. \r\n<LI>De vez en cuando, este sitio web puede incluir enlaces a otros sitios web. Estos vínculos se proporcionan para su conveniencia para proporcionar más información. Esto no significa que estamos de acuerdo con el sitio web (s). No tenemos ninguna responsabilidad sobre el contenido del sitio web vinculado (s). \r\n<LI>El uso de este sitio web y cualquier disputa que surja de ese uso de la página web está sujeto a las leyes de Inglaterra, Irlanda del Norte, Escocia y Gales.</LI></UL>', 0, 'Términos y Condiciones', 'ApPHP Business Directory', 'php business directory', 'ApPHP Business Directory - solución de negocio de directorios listados', 0, '2011-03-22 16:36:17', '2011-06-29 09:29:33', '0000-00-00', 0, 0, 1, 1, 'terms_and_conditions', 1, '0000-00-00 00:00:00', 'public', 24),
(9, 'j8hevfivri', 'de', 'article', '', '_self', 'Allgemeine-Geschäftsbedingungen', 'Allgemeine Geschäftsbedingungen', '<H2>AGB Sample</H2>\r\n<H3>Website-Nutzung Geschäftsbedingungen - Mustervorlage</H3>\r\n<P>Willkommen auf unserer Website. Wenn Sie zu durchsuchen und weiter die Nutzung dieser Website erklären Sie sich zur Einhaltung und durch die folgenden Bedingungen verwenden, die zusammen mit unserer Datenschutzerklärung regieren [Firmenname]''s Beziehung mit Ihnen in Zusammenhang mit dieser Website gebunden werden. Wenn Sie mit irgendeinem Teil dieser Bedingungen und Konditionen nicht einverstanden sind, benutzen Sie bitte nicht unsere Website.</P>\r\n<P>Der Begriff "[Firmenname]" oder "uns" oder "wir" bezieht sich auf die Eigentümer der Website Sitz [Adresse]. Unsere Firma Registriernummer ist [Registernummer und Ort der Eintragung]. Der Begriff "Sie" bezieht sich auf den Benutzer oder Betrachter unserer Website.</P>\r\n<P>Die Nutzung dieser Website unterliegt den folgenden Nutzungsbedingungen:</P>\r\n<UL>\r\n<LI>Der Inhalt der Seiten dieser Website dient der allgemeinen Information und Verwendung. Es ist jederzeit ohne vorherige Ankündigung ändern. \r\n<LI>Weder wir noch Dritte eine Gewähr oder Garantie für die Richtigkeit, Aktualität, Leistung, Vollständigkeit oder Angemessenheit der Informationen und Materialien angeboten oder auf dieser Website für irgendeinen bestimmten Zweck. Sie bestätigen, dass solche Informationen und Materialien Ungenauigkeiten oder Fehler enthalten, und wir schließen ausdrücklich jede Haftung für derartige Ungenauigkeiten oder Fehler, die, soweit dies gesetzlich zulässig. \r\n<LI>Ihre Nutzung der Informationen oder Materialien auf dieser Website erfolgt auf eigene Gefahr, für die wir nicht haftbar gemacht werden. Es ist Ihre eigene Verantwortung sicherzustellen, dass alle Produkte, Dienstleistungen oder Informationen über diese Website erhältlich Ihren spezifischen Anforderungen gerecht werden. \r\n<LI>Diese Website enthält Material, das Eigentum oder lizenziert für uns. Dieses Material beinhaltet, ist aber nicht beschränkt auf das Design, Layout, Aussehen, Erscheinungsbild und Grafiken. Reproduktion ist verboten, ausgenommen in Übereinstimmung mit den Copyright-Vermerk, der Teil dieser Bedingungen und Konditionen Formen. \r\n<LI>Alle Warenzeichen auf dieser Website reproduziert, die nicht Eigentum von oder lizenziert für den Betreiber sind auf der Website bestätigt. \r\n<LI>Unerlaubte Benutzung dieser Website können zu einem Anspruch auf Schadensersatz und/oder eine Straftat. \r\n<LI>Von Zeit zu Zeit kann diese Website auch Links zu anderen Websites. Diese Links sind für Ihre Bequemlichkeit für ergänzende Auskünfte zur Verfügung gestellt. Sie bedeuten nicht, dass wir die Website (s) zu billigen. Wir haben keine Verantwortung für den Inhalt der verlinkten Website (s). \r\n<LI>Ihre Nutzung dieser Website und alle Streitigkeiten aus solchen Nutzung der Website unterliegt den Gesetzen von England, Nordirland, Schottland und Wales.</LI></UL>', 0, 'Bedingungen', 'ApPHP Business Directory', 'php business directory', 'ApPHP Business Directory - Brancheneinträge Verzeichnis-Lösung', 0, '2011-03-22 16:36:17', '2011-06-29 09:33:01', '0000-00-00', 0, 0, 1, 1, 'terms_and_conditions', 1, '0000-00-00 00:00:00', 'public', 24),
(10, 'b6uneoynru', 'es', 'article', '', '_self', 'Nuestra-Galería', 'Nuestra Galería', '<div>Esta es nuestra galería de fotos:</div><div><br></div><div><span style="color: #222222; font-family: arial, verdana, sans-serif;">{module:gallery}</span></div>', 5, 'Nuestra Galería', 'ApPHP Business Directory', 'php business directory', 'ApPHP Business Directory - business listings directory solution ', 0, '2013-02-13 16:02:19', '2013-02-13 16:03:06', '0000-00-00', 0, 0, 1, 0, '', 1, '0000-00-00 00:00:00', 'public', 25),
(11, 'b6uneoynru', 'de', 'article', '', '_self', 'Unsere-Galerie', 'Unsere Galerie', '<div>Dies ist in unserer Galerie:<br><br></div><div><span style="color: #222222; font-family: arial, verdana, sans-serif;">{module:gallery}</span></div>', 6, 'Unsere Galerie', 'ApPHP Business Directory', 'php business directory', 'ApPHP Business Directory - business listings directory solution ', 0, '2013-02-13 16:02:19', '2013-02-13 16:03:49', '0000-00-00', 0, 0, 1, 0, '', 1, '0000-00-00 00:00:00', 'public', 25),
(12, 'n7fbgm4eqz', 'en', 'article', '', '_self', 'Page-with-comments', 'Page with comments', '<div>This an example of page with comments.</div><div>You may leave your comments here:</div>', 4, 'Page with comments', 'ApPHP Business Directory', 'php business directory', 'ApPHP Business Directory - business listings directory solution ', 1, '2013-02-13 16:04:32', '0000-00-00 00:00:00', '0000-00-00', 0, 0, 1, 0, '', 1, '0000-00-00 00:00:00', 'public', 26),
(13, 'n7fbgm4eqz', 'es', 'article', '', '_self', 'Página-con-comentarios', 'Página con comentarios', '<div>Este ejemplo de una página con comentarios.</div><div>Puede dejar aquí sus comentarios:</div>', 5, 'Página con comentarios', 'ApPHP Business Directory', 'php business directory', 'ApPHP Business Directory - business listings directory solution ', 1, '2013-02-13 16:04:32', '2013-02-13 16:04:56', '0000-00-00', 0, 0, 1, 0, '', 1, '0000-00-00 00:00:00', 'public', 26),
(14, 'n7fbgm4eqz', 'de', 'article', '', '_self', 'Seite-mit-Kommentaren', 'Seite mit Kommentaren', '<div>Dies ist ein Beispiel der Seite mit Kommentaren.</div><div>Sie können Ihre Kommentare hier hinterlassen:</div>', 6, 'Seite mit Kommentaren', 'ApPHP Business Directory', 'php business directory', 'ApPHP Business Directory - business listings directory solution ', 1, '2013-02-13 16:04:32', '2013-02-13 16:05:21', '0000-00-00', 0, 0, 1, 0, '', 1, '0000-00-00 00:00:00', 'public', 26),
(15, 'sfrdsdsdsd', 'en', 'article', '', '_self', 'Installation-of-PHP-Business-Directory', 'Installation of PHP Business Directory', '<DIV class=post>\r\n<H2 id=post-1>Installation of PHP Business Directory</H2>\r\n<DIV class=storycontent><A name=Installation_of_PHP_MicroCMS></A>\r\n<P>(for version 2.0.0 or above)</P>\r\n<P>A new installation of PHP Business Directory is a very straight forward process:</P><A name=Step_1._Uncompressing_downloaded_file.></A>\r\n<H3><STRONG>Step 1. Uncompressing downloaded file.</STRONG></H3>\r\n<HR>\r\n\r\n<P>Uncompress the PHP Business Directory&nbsp; version 2.x.x script archive. The archive will create a directory called "PHPBD_2xx"<BR></P><A name=Step_2._Uploading_files.></A>\r\n<H3><STRONG>Step 2. Uploading files.</STRONG></H3>\r\n<HR>\r\n\r\n<P>Upload content of this folder (all files and directories it includes) to your document root (public_html, www, httpdocs etc.) or your micro-cms directory using FTP. Pay attention to DON''T use the capital letters in the name of the folder (for Linux users).</P>\r\n<P>For example:</P><PRE>public_html/</PRE>or <PRE>public_html/{business-directory}/<BR>&nbsp;</PRE><A name=Step_3._Creating_database.></A>\r\n<H3><STRONG>Step 3. Creating database.</STRONG></H3>\r\n<HR>\r\n\r\n<P>Using your hosting Control Panel, phpMyAdmin or another tool, create your database and user, and assign that user to the database. Write down the name of the database, username, and password for the site installation procedure.<BR>&nbsp;</P><A name=Step_4._Settings_and_access_rights.></A>\r\n<H3><STRONG>Step 4. Settings and access rights.</STRONG></H3>\r\n<HR>\r\n\r\n<P>4.1. Check access permissions to <STRONG>images/uploads/</STRONG> and <STRONG>wysiwyg/addons/imagelibrary/</STRONG>. You have to set up 755 rights to these folders. Also check if your script is available to change permissions to <STRONG>include/</STRONG> folder. If not - set manually 777 rights to this folder and return them back to 755 after the installation was completed.<BR><BR>4.2. If you run PHP Business Directory on IIS, you have to allow rewrite mode for Windows. To do this, open the <STRONG>httpd.conf</STRONG> file and uncomment the following lines (remove the trailing #s):</P><PRE>#LoadModule rewrite_module modules/mod_rewrite.so<BR>#AddModule mod_rewrite.c<BR>&nbsp;&nbsp;</PRE><A name=Step_5._Running_install_file.></A>\r\n<H3><STRONG>Step 5. Running install.php file.</STRONG></H3>\r\n<HR>\r\n\r\n<P>Now you can run install.php file. To do this, open a browser and type in Address Bar</P><PRE>{www.mydomain.com}/install.php</PRE>or <PRE>{www.mydomain.com}/{business-directory}/install.php</PRE>Follow instructions on the screen. You will be asked to enter: database host, database name, username and password. Also you need to enter admin username and admin password, that will be used to get access to administration area of the site.&nbsp;<BR>&nbsp;<A name=Step_6._Deleting_install_files.></A> \r\n<H3><STRONG>Step 6. Deleting installation files.</STRONG></H3>\r\n<HR>\r\n\r\n<P>After successful installation you will get an appropriate message and warning to remove install.php file and install/ directory. For security reasons, please delete them immediately.&nbsp;</P>Congratulations, you now have PHP Business Directory v2.x.x. Installed!</DIV></DIV>', 1, 'Installation', 'ApPHP Business Directory', 'php business directory', 'ApPHP Business Directory - business listings directory solution ', 0, '0000-00-00 00:00:00', '2012-02-10 13:24:14', '0000-00-00', 0, 0, 1, 0, '', 1, '0000-00-00 00:00:00', 'public', 0),
(16, 'b6uneoynru', 'en', 'article', '', '_self', 'Our-Gallery', 'Our Gallery', 'This is our gallery:<div><span style="color: #222222; font-family: arial, verdana, sans-serif;"><br></span></div><div><span style="color: #222222; font-family: arial, verdana, sans-serif;">{module:gallery}</span></div>', 4, 'Our Gallery', 'ApPHP Business Directory', 'php business directory', 'ApPHP Business Directory - business listings directory solution ', 0, '2013-02-13 16:02:19', '0000-00-00 00:00:00', '0000-00-00', 0, 0, 1, 0, '', 1, '0000-00-00 00:00:00', 'public', 25),
(17, 'sfrdsdsdsd', 'es', 'article', '', '_self', 'Instalación-de-PHP-Business-Directory', 'Instalación de PHP Business Directory', '<DIV class=post>\r\n<H2 id=post-1>Instalación de PHP Business Directory</H2>\r\n<DIV class=storycontent><A name=Installation_of_PHP_MicroCMS></A>\r\n<P>(de la versión 2.0.0 o superior)</P>\r\n<P>Una nueva instalación de PHP Business Directory es un proceso muy sencillo:</P><A name=Step_1._Uncompressing_downloaded_file.></A>\r\n<H3><STRONG>Paso 1. Descomprimir el archivo descargado.</STRONG></H3>\r\n<HR>\r\n\r\n<P>Descomprimir el archivo PHP Business Directory&nbsp;versión 2.xx secuencia de comandos. El archivo se creará un directorio llamado "PHPBD_2xx"<BR></P><A name=Step_2._Uploading_files.></A>\r\n<H3><STRONG>Paso 2. Carga de archivos.</STRONG></H3>\r\n<HR>\r\n\r\n<P>Subir el contenido de esta carpeta (todos los archivos y directorios que incluye) a la raíz del documento (www public_html, httpdocs etc) o el directorio de micro-cms mediante FTP. Preste atención a NO usar las letras mayúsculas en el nombre de la carpeta (para usuarios de Linux).</P>\r\n<P>Por ejemplo:</P><PRE>public_html/</PRE>o <PRE>public_html/{business-directory}/<BR>&nbsp;</PRE><A name=Step_3._Creating_database.></A>\r\n<H3><STRONG>Paso 3. Creación de base de datos.</STRONG></H3>\r\n<HR>\r\n\r\n<P>Usando su Panel de Control, phpMyAdmin o cualquier otra herramienta, crear su base de datos y el usuario, y asignar a ese usuario a la base de datos. Anote el nombre de la base de datos, nombre de usuario y una contraseña para el procedimiento de instalación del sitio.<BR>&nbsp;</P><A name=Step_4._Settings_and_access_rights.></A>\r\n<H3><STRONG>Paso 4. Configuración y derechos de acceso.</STRONG></H3>\r\n<HR>\r\n\r\n<P>4.1. Compruebe los permisos de acceso a images/uploads/ y wysiwyg/addons/imagelibrary/. Tienes que crear 755 derechos a estas carpetas. También puedes ver si la secuencia de comandos está disponible para cambiar los permisos para incluir / carpeta. Si no - establecer manualmente 777 derechos a esta carpeta y volver de nuevo a 755 después de la instalación se ha completado.<BR><BR>4.2. Si ejecuta PHP Directorio de Empresas en IIS, tiene que permitir que el modo de reescritura para Windows. Para ello, abra el archivo httpd.conf y descomentar las siguientes líneas (quitar la s final #):</P><PRE>#LoadModule rewrite_module modules/mod_rewrite.so<BR>#AddModule mod_rewrite.c<BR>&nbsp;&nbsp;</PRE><A name=Step_5._Running_install_file.></A>\r\n<H3><STRONG>Paso 5. Ejecutar archivo install.php.</STRONG></H3>\r\n<HR>\r\n\r\n<P>Ahora puedes ejecutar el archivo install.php. Para ello, abra un navegador y escriba en la barra de direcciones</P><PRE>{www.mydomain.com}/install.php</PRE>o <PRE>{www.mydomain.com}/{business-directory}/install.php</PRE>Siga las instrucciones en la pantalla. Se le pedirá que introduzca: base de datos de host, nombre de base de datos, nombre de usuario y contraseña. También es necesario introducir nombre de usuario y contraseña de administrador, que se utilizará para tener acceso al área de administración del sitio.&nbsp;<BR>&nbsp;<A name=Step_6._Deleting_install_files.></A> \r\n<H3><STRONG>Paso 6. Eliminar archivos de instalación.</STRONG></H3>\r\n<HR>\r\n\r\n<P>Después de la instalación aparecerá un mensaje apropiado y alerta a eliminar el archivo <STRONG>install.php</STRONG> y <STRONG>install/</STRONG>. Por razones de seguridad, por favor, eliminar de inmediato.<BR><BR>Felicitaciones, ahora tiene PHP v2.xx Directorio de Negocios Instalado!</P></DIV></DIV>', 2, 'Instalación', 'ApPHP Business Directory', 'php business directory', 'ApPHP Business Directory - solución de negocio de directorios listados', 0, '0000-00-00 00:00:00', '2011-06-29 09:45:48', '0000-00-00', 0, 0, 1, 0, '', 1, '0000-00-00 00:00:00', 'public', 0),
(18, 'sfrdsdsdsd', 'de', 'article', '', '_self', 'Installation-von-PHP-Business-Directory', 'Installation von PHP Business Directory', '<DIV class=post>\r\n<H2 id=post-1>Installation von PHP Business Directory</H2>\r\n<DIV class=storycontent><A name=Installation_of_PHP_MicroCMS></A>\r\n<P>(für Version 2.0.0 oder höher)</P>\r\n<P>Eine neue Installation von PHP Business Directory ist ein sehr geradlinig Prozess:</P><A name=Step_1._Uncompressing_downloaded_file.></A>\r\n<H3><STRONG>Schritt 1. Dekomprimieren heruntergeladene Datei.</STRONG></H3>\r\n<HR>\r\n\r\n<P>Entpacken Sie die PHP-Business Directory Version 2.xx Skript-Archiv. Das Archiv wird ein Verzeichnis namens "PHPBD_2xx"</P><A name=Step_2._Uploading_files.></A>\r\n<H3><STRONG>Schritt 2. Hochladen von Dateien.</STRONG></H3>\r\n<HR>\r\n\r\n<P>Hochladen Inhalt dieses Ordners (alle Dateien und Verzeichnisse es umfasst), um Ihre Dokumenten-Root (public_html, www, httpdocs usw.) oder Ihre Mikro-CMS direkt per FTP. Achten Sie auf NICHT die Großbuchstaben im Namen des Ordners (für Linux-Anwender).</P>\r\n<P>Zum Beispiel:<BR><BR>public_html/</P>oder<PRE>public_html/{business-directory}/</PRE>\r\n<P>&nbsp;</P><A name=Step_3._Creating_database.></A>\r\n<H3><STRONG>Schritt 3. Erstellen Datenbank.</STRONG></H3>\r\n<HR>\r\n\r\n<P>Mit Ihrem Hosting Control Panel, phpMyAdmin oder ein anderes Tool, erstellen Sie Ihre Datenbank und Benutzer, und weisen Sie die Benutzer auf die Datenbank. Notieren Sie den Namen der Datenbank, den Benutzernamen und das Kennwort für den Einbau vor Ort Verfahren.<BR>&nbsp;</P><A name=Step_4._Settings_and_access_rights.></A>\r\n<H3><STRONG>Schritt 4. Einstellungen und Zugriffsrechte.</STRONG></H3>\r\n<HR>\r\n\r\n<P>4.1. Überprüfen Sie die Zugriffsberechtigungen auf <STRONG>images/uploads/</STRONG> und <STRONG>wysiwyg/addons/imagelibrary/</STRONG>. Sie haben die Einrichtung 755 Rechte an diesen Ordnern. Überprüfen Sie auch, wenn Ihr Skript zur Verfügung zu ändern Berechtigungen&nbsp;Ordner <STRONG>include/</STRONG> ist. Wenn nicht - manuell 777 Rechte in diesen Ordner und bringt sie zurück auf 755, nachdem die Installation abgeschlossen wurde.<BR><BR>4.2. Wenn Sie PHP Business Directory auf IIS laufen, haben Sie damit umschreiben Modus für Windows. Dazu öffnen Sie die Datei <STRONG>httpd.conf</STRONG> und kommentieren Sie die folgenden Zeilen (entfernen Sie die hintere # n):</P><PRE>#LoadModule rewrite_module modules/mod_rewrite.so<BR>#AddModule mod_rewrite.c<BR>&nbsp;&nbsp;</PRE><A name=Step_5._Running_install_file.></A>\r\n<H3><STRONG>Schritt 5. Running install.php.</STRONG></H3>\r\n<HR>\r\n\r\n<P>Jetzt können Sie install.php Datei. Dazu öffnen Sie einen Browser und geben Sie Adresse Bar</P><PRE>{www.mydomain.com}/install.php</PRE>oder <PRE>{www.mydomain.com}/{business-directory}/install.php</PRE>Befolgen Sie die Anweisungen auf dem Bildschirm. Sie werden aufgefordert, einzugeben: Datenbank-Host, Datenbankname, Benutzername und Passwort. Darüber hinaus müssen Sie Benutzernamen admin und Admin-Passwort, mit denen der Zugriff auf Administrationsbereich der Website zu erhalten sein wird eingeben.&nbsp;<BR>&nbsp;<A name=Step_6._Deleting_install_files.></A> \r\n<H3><STRONG>Schritt 6. Löschen Installationsdateien.</STRONG></H3>\r\n<HR>\r\n\r\n<P>Nach erfolgreicher Installation erhalten Sie eine entsprechende Meldung und Warnung an <STRONG>install.php</STRONG> Datei zu entfernen und zu <STRONG>install/</STRONG> Verzeichnis. Aus Sicherheitsgründen bitte löschen Sie diese sofort.&nbsp;</P>Herzlichen Glückwunsch, Sie haben jetzt PHP Business Directory v2.xx Installiert!</DIV></DIV>', 3, 'Installation', 'ApPHP Business Directory', 'php business directory', 'ApPHP Business Directory - Brancheneinträge Verzeichnis-Lösung', 0, '0000-00-00 00:00:00', '2011-06-29 09:47:07', '0000-00-00', 0, 0, 1, 0, '', 1, '0000-00-00 00:00:00', 'public', 0);


DROP TABLE IF EXISTS `<DB_PREFIX>privileges`;
CREATE TABLE IF NOT EXISTS `<DB_PREFIX>privileges` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `code` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `description` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=7 ;

INSERT INTO `<DB_PREFIX>privileges` (`id`, `code`, `name`, `description`) VALUES
(1, 'add_menus', 'Add Menus', 'Add Menus on the site'),
(2, 'edit_menus', 'Edit Menus', 'Edit Menus on the site'),
(3, 'delete_menus', 'Delete Menus', 'Delete Menus from the site'),
(4, 'add_pages', 'Add Pages', 'Add Pages on the site'),
(5, 'edit_pages', 'Edit Pages', 'Edit Pages on the site'),
(6, 'delete_pages', 'Delete Pages', 'Delete Pages from the site');


DROP TABLE IF EXISTS `<DB_PREFIX>ratings_items`;
CREATE TABLE IF NOT EXISTS `<DB_PREFIX>ratings_items` (
  `item` varchar(200) NOT NULL DEFAULT '',
  `totalrate` int(10) NOT NULL DEFAULT '0',
  `nrrates` int(9) NOT NULL DEFAULT '1',
  PRIMARY KEY (`item`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `<DB_PREFIX>ratings_users`;
CREATE TABLE IF NOT EXISTS `<DB_PREFIX>ratings_users` (
  `day` int(2) DEFAULT NULL,
  `rater` varchar(15) DEFAULT NULL,
  `item` varchar(200) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `<DB_PREFIX>roles`;
CREATE TABLE IF NOT EXISTS `<DB_PREFIX>roles` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `code` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

INSERT INTO `<DB_PREFIX>roles` (`id`, `code`, `name`, `description`) VALUES
(1, 'owner', 'Site Owner', 'Site Owner is the owner of the site, has all privileges and could not be removed.'),
(2, 'mainadmin', 'Main Admin', 'The "Main Administrator" user has top privileges like Site Owner and may be removed only by him.'),
(3, 'admin', 'Simple Admin', 'The "Simple Admin" is required to assist the Main Admins, has different privileges and may be created by Site Owner or Main Admins.');


DROP TABLE IF EXISTS `<DB_PREFIX>role_privileges`;
CREATE TABLE IF NOT EXISTS `<DB_PREFIX>role_privileges` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `role_id` int(5) NOT NULL,
  `privilege_id` int(5) NOT NULL,
  `is_active` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=19 ;

INSERT INTO `<DB_PREFIX>role_privileges` (`id`, `role_id`, `privilege_id`, `is_active`) VALUES
(1, 1, 1, 1),
(2, 1, 2, 1),
(3, 1, 3, 1),
(4, 1, 4, 1),
(5, 1, 5, 1),
(6, 1, 6, 1),
(7, 2, 1, 1),
(8, 2, 2, 1),
(9, 2, 3, 1),
(10, 2, 4, 1),
(11, 2, 5, 1),
(12, 2, 6, 1),
(13, 3, 1, 0),
(14, 3, 2, 1),
(15, 3, 3, 0),
(16, 3, 4, 0),
(17, 3, 5, 1),
(18, 3, 6, 0);


DROP TABLE IF EXISTS `<DB_PREFIX>search_wordlist`;
CREATE TABLE IF NOT EXISTS `<DB_PREFIX>search_wordlist` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `word_text` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `word_count` int(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `word_text` (`word_text`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;


DROP TABLE IF EXISTS `<DB_PREFIX>settings`;
CREATE TABLE IF NOT EXISTS `<DB_PREFIX>settings` (
  `id` smallint(6) NOT NULL,
  `template` varchar(32) CHARACTER SET latin1 NOT NULL,
  `seo_urls` tinyint(1) NOT NULL DEFAULT '1',
  `date_format` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'dd/mm/yyyy',
  `price_format` enum('european','american') CHARACTER SET latin1 NOT NULL,
  `time_zone` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `admin_email` varchar(70) COLLATE utf8_unicode_ci NOT NULL,
  `mailer` varchar(20) CHARACTER SET latin1 NOT NULL DEFAULT 'php_mail_standard',
  `mailer_type` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `smtp_host` varchar(70) COLLATE utf8_unicode_ci NOT NULL,
  `smtp_port` varchar(6) COLLATE utf8_unicode_ci NOT NULL,
  `smtp_username` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `smtp_password` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `wysiwyg_type` enum('none','openwysiwyg','tinymce') CHARACTER SET latin1 NOT NULL DEFAULT 'openwysiwyg',
  `rss_feed` tinyint(1) NOT NULL DEFAULT '1',
  `rss_feed_type` enum('rss1','rss2','atom') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'rss1',
  `rss_last_ids` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `is_offline` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `caching_allowed` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `cache_lifetime` tinyint(3) unsigned NOT NULL DEFAULT '5' COMMENT 'in minutes',
  `offline_message` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `google_rank` varchar(2) CHARACTER SET latin1 NOT NULL,
  `alexa_rank` varchar(12) CHARACTER SET latin1 NOT NULL,
  `cron_type` enum('batch','non-batch','stop') CHARACTER SET latin1 NOT NULL DEFAULT 'non-batch',
  `cron_run_last_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `cron_run_period` enum('minute','hour') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'minute',
  `cron_run_period_value` smallint(6) unsigned NOT NULL DEFAULT '1'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `<DB_PREFIX>settings` (`id`, `template`, `seo_urls`, `date_format`, `price_format`, `time_zone`, `admin_email`, `mailer`, `mailer_type`, `smtp_host`, `smtp_port`, `smtp_username`, `smtp_password`, `wysiwyg_type`, `rss_feed`, `rss_feed_type`, `rss_last_ids`, `is_offline`, `caching_allowed`, `cache_lifetime`, `offline_message`, `google_rank`, `alexa_rank`, `cron_type`, `cron_run_last_time`, `cron_run_period`, `cron_run_period_value`) VALUES
(0, 'default', 0, 'mm/dd/yyyy', 'american', '0', 'info@yourdomain.com', 'php', 'php_mail_standard', '', '', '', '', 'openwysiwyg', 1, 'rss1', '1', 0, 0, 5, 'Our website is currently offline for maintenance. Please visit us later.', '-1', '0', 'non-batch', '2013-02-13 12:22:02', 'hour', 24);


DROP TABLE IF EXISTS `<DB_PREFIX>site_description`;
CREATE TABLE IF NOT EXISTS `<DB_PREFIX>site_description` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `language_id` varchar(2) CHARACTER SET latin1 NOT NULL,
  `header_text` text COLLATE utf8_unicode_ci NOT NULL,
  `slogan_text` text COLLATE utf8_unicode_ci NOT NULL,
  `footer_text` text COLLATE utf8_unicode_ci NOT NULL,
  `tag_title` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `tag_description` text COLLATE utf8_unicode_ci NOT NULL,
  `tag_keywords` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

INSERT INTO `<DB_PREFIX>site_description` (`id`, `language_id`, `header_text`, `slogan_text`, `footer_text`, `tag_title`, `tag_description`, `tag_keywords`) VALUES
(1, 'en', 'ApPHP Business Directory', 'your slogan here...', 'ApPHP Business Directory © ApPHP', 'ApPHP Business Directory', 'ApPHP Business Directory - business listings directory solution ', 'php business directory'),
(2, 'es', 'ApPHP Business Directory', 'su lema aquí...', 'ApPHP Business Directory © ApPHP', 'ApPHP Business Directory', 'ApPHP Business Directory - solución de negocio de directorios listados', 'php business directory'),
(3, 'de', 'ApPHP Business Directory', 'ihr slogan hier...', 'ApPHP Business Directory © ApPHP', 'ApPHP Business Directory', 'ApPHP Business Directory - Brancheneinträge Verzeichnis-Lösung', 'php business directory');


DROP TABLE IF EXISTS `<DB_PREFIX>vocabulary`;
CREATE TABLE IF NOT EXISTS `<DB_PREFIX>vocabulary` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `language_id` varchar(3) CHARACTER SET latin1 NOT NULL,
  `key_value` varchar(50) CHARACTER SET latin1 NOT NULL,
  `key_text` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `voc_item` (`language_id`,`key_value`),
  KEY `language_id` (`language_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3930 ;

INSERT INTO `<DB_PREFIX>vocabulary` (`id`, `language_id`, `key_value`, `key_text`) VALUES
(1, 'es', '_2CO_NOTICE', '2CheckOut.com Inc. (Ohio, EE.UU.) es un vendedor autorizado de bienes y servicios.'),
(2, 'en', '_2CO_NOTICE', '2CheckOut.com Inc. (Ohio, USA) is an authorized retailer for goods and services.'),
(3, 'de', '_2CO_NOTICE', '2CheckOut.com Inc. (Ohio, USA) is an authorized retailer for goods and services.'),
(4, 'es', '_2CO_ORDER', '2CO Orden'),
(5, 'en', '_2CO_ORDER', '2CO Order'),
(6, 'de', '_2CO_ORDER', '2CO Order'),
(7, 'es', '_ABBREVIATION', 'Abreviación'),
(8, 'en', '_ABBREVIATION', 'Abbreviation '),
(9, 'de', '_ABBREVIATION', 'Abkürzung'),
(10, 'es', '_ACCESS', 'Acceso'),
(11, 'en', '_ACCESS', 'Access'),
(12, 'de', '_ACCESS', 'Zugang'),
(13, 'es', '_ACCESSIBLE_BY', 'Accesible en'),
(14, 'en', '_ACCESSIBLE_BY', 'Accessible By'),
(15, 'de', '_ACCESSIBLE_BY', 'Erreichbar mit'),
(16, 'es', '_ACCOUNTS', 'Cuentas'),
(17, 'en', '_ACCOUNTS', 'Accounts'),
(18, 'de', '_ACCOUNTS', 'Konten'),
(19, 'es', '_ACCOUNTS_MANAGEMENT', 'Gestión de Cuentas'),
(20, 'en', '_ACCOUNTS_MANAGEMENT', 'Accounts'),
(21, 'de', '_ACCOUNTS_MANAGEMENT', 'Konten'),
(22, 'es', '_ACCOUNT_CREATED_CONF_BY_ADMIN_MSG', 'Su cuenta ha sido creada con éxito! En pocos minutos, usted debe recibir un correo electrónico, que contiene los detalles de su cuenta. <br> Después de la aprobación de su registro por el administrador, usted será capaz de acceder a su cuenta.'),
(23, 'en', '_ACCOUNT_CREATED_CONF_BY_ADMIN_MSG', 'Your account has been successfully created! In a few minutes you should receive an email, containing the details of your account. <br><br> After approval your registration by administrator, you will be able to log into your account.'),
(24, 'de', '_ACCOUNT_CREATED_CONF_BY_ADMIN_MSG', 'Ihr Konto wurde erfolgreich erstellt! In wenigen Minuten sollten Sie eine E-Mail mit den Angaben von Ihrem Konto. <br> Nach der Genehmigung Ihrer Registrierung durch den Administrator, werden Sie in der Lage, in Ihrem Konto anmelden.'),
(25, 'es', '_ACCOUNT_CREATED_CONF_BY_EMAIL_MSG', 'Su cuenta ha sido creada con éxito! En pocos minutos, usted debe recibir un correo electrónico, que contiene los detalles de su registro. <br><br> completar este registro, utilizando el código de confirmación que fue enviado a la dirección de correo electrónico proporcionado, y que será capaz de acceder a su cuenta.'),
(26, 'en', '_ACCOUNT_CREATED_CONF_BY_EMAIL_MSG', 'Your account has been successfully created! In a few minutes you should receive an email, containing the details of your registration. <br><br> Complete this registration, using the confirmation code that was sent to the provided email address, and you will be able to log into your account.'),
(27, 'de', '_ACCOUNT_CREATED_CONF_BY_EMAIL_MSG', 'Ihr Konto wurde erfolgreich erstellt! In wenigen Minuten sollten Sie eine E-Mail mit den Angaben Ihrer Registrierung. <br><br> füllen Sie dieses Anmeldeformular mit den Bestätigungs-Code, dass die angegebene E-Mail-Adresse gesendet wurde, und du wirst in der Lage sein in Ihrem Konto anmelden.'),
(28, 'es', '_ACCOUNT_CREATED_NON_CONFIRM_LINK', 'Haga clic <a href=index.php?customer=login>aquí</a> para continuar.'),
(29, 'en', '_ACCOUNT_CREATED_NON_CONFIRM_LINK', 'Click <a href=index.php?customer=login>here</a> to proceed.'),
(30, 'de', '_ACCOUNT_CREATED_NON_CONFIRM_LINK', 'Klicken Sie <a href=index.php?customer=login>hier</a>, um fortzufahren.'),
(31, 'es', '_ACCOUNT_CREATED_NON_CONFIRM_MSG', 'Su cuenta ha sido creada con éxito! Para su comodidad, en pocos minutos recibirá un correo electrónico, que contiene los datos de su inscripción (no se requiere confirmación). <br><br> Usted puede acceder a su cuenta ahora.'),
(32, 'en', '_ACCOUNT_CREATED_NON_CONFIRM_MSG', 'Your account has been successfully created! For your convenience in a few minutes you will receive an email, containing the details of your registration (no confirmation required). <br><br>You may log into your account now.'),
(33, 'de', '_ACCOUNT_CREATED_NON_CONFIRM_MSG', 'Ihr Konto wurde erfolgreich erstellt! Für Ihre Bequemlichkeit in wenigen Minuten erhalten Sie eine E-Mail mit den Angaben der Anmeldung (keine Bestätigung erforderlich). <br><br> Sie können in Ihrem Konto jetzt anmelden.'),
(34, 'es', '_ACCOUNT_CREATE_MSG', 'Este proceso de registro requiere la confirmación por correo electrónico! <br> Por favor, rellene el siguiente formulario con la información correcta.'),
(35, 'en', '_ACCOUNT_CREATE_MSG', 'This registration process requires confirmation via email! <br>Please fill out the form below with correct information.'),
(36, 'de', '_ACCOUNT_CREATE_MSG', 'Diese Registrierung erfordert eine Bestätigung per E-Mail! <br> Bitte füllen Sie das untenstehende Formular mit korrekten Informationen.'),
(37, 'es', '_ACCOUNT_DETAILS', 'Detalles de la cuenta'),
(38, 'en', '_ACCOUNT_DETAILS', 'Account Details'),
(39, 'de', '_ACCOUNT_DETAILS', 'Kontodetails'),
(40, 'es', '_ACCOUNT_PANEL', 'Cuenta de Grupo'),
(41, 'en', '_ACCOUNT_PANEL', 'Account Panel'),
(42, 'de', '_ACCOUNT_PANEL', 'Konto-Panel'),
(43, 'es', '_ACCOUNT_TYPE', 'Tipo de cuenta'),
(44, 'en', '_ACCOUNT_TYPE', 'Account type'),
(45, 'de', '_ACCOUNT_TYPE', 'Kontotyp'),
(46, 'es', '_ACCOUNT_WAS_CREATED', 'Tu cuenta ha sido creada'),
(47, 'en', '_ACCOUNT_WAS_CREATED', 'Your account has been created'),
(48, 'de', '_ACCOUNT_WAS_CREATED', 'Ihr Konto wurde erstellt'),
(49, 'es', '_ACCOUNT_WAS_DELETED', 'Su cuenta se ha eliminado correctamente! En cuestión de segundos, se le redirigirá automáticamente a la página principal.'),
(50, 'en', '_ACCOUNT_WAS_DELETED', 'Your account has been successfully removed! In seconds, you will be automatically redirected to the homepage.'),
(51, 'de', '_ACCOUNT_WAS_DELETED', 'Ihr Konto wurde erfolgreich entfernt! Innerhalb von Sekunden werden Sie automatisch auf die Startseite umgeleitet.'),
(52, 'es', '_ACCOUNT_WAS_UPDATED', 'Su cuenta ha sido actualizada con éxito!'),
(53, 'en', '_ACCOUNT_WAS_UPDATED', 'Your account has been successfully updated!'),
(54, 'de', '_ACCOUNT_WAS_UPDATED', 'Ihr Konto wurde erfolgreich aktualisiert!'),
(55, 'es', '_ACCOUT_CREATED_CONF_LINK', 'Ya confirmaron su registro? Haga clic <a href=index.php?customer=login>aquí</a> para continuar.'),
(56, 'en', '_ACCOUT_CREATED_CONF_LINK', 'Already confirmed your registration? Click <a href=index.php?customer=login>here</a> to proceed.'),
(57, 'de', '_ACCOUT_CREATED_CONF_LINK', 'Bereits bestätigt Ihre Registrierung? Klicken Sie <a href=index.php?customer=login>hier</a>, um fortzufahren.'),
(58, 'es', '_ACTIONS', 'Acción'),
(59, 'en', '_ACTIONS', 'Action'),
(60, 'de', '_ACTIONS', 'Aktion'),
(61, 'es', '_ACTIONS_WORD', 'Acción'),
(62, 'en', '_ACTIONS_WORD', 'Action'),
(63, 'de', '_ACTIONS_WORD', 'Aktion'),
(64, 'es', '_ACTION_REQUIRED', 'MEDIDAS QUE SE SOLICITAN'),
(65, 'en', '_ACTION_REQUIRED', 'ACTION REQUIRED'),
(66, 'de', '_ACTION_REQUIRED', 'MASSNAHMEN ERFORDERLICH'),
(67, 'es', '_ACTIVATION_EMAIL_ALREADY_SENT', 'El email de activación ya fue enviado a su correo electrónico. Por favor, inténtelo de nuevo más tarde.'),
(68, 'en', '_ACTIVATION_EMAIL_ALREADY_SENT', 'The activation email was already sent to your email. Please try again later.'),
(69, 'de', '_ACTIVATION_EMAIL_ALREADY_SENT', 'Die Aktivierung per E-Mail wurde bereits auf Ihre E-Mail geschickt. Bitte versuchen Sie es später erneut.'),
(70, 'es', '_ACTIVATION_EMAIL_WAS_SENT', 'Un correo electrónico ha sido enviado a _EMAIL_ con una clave de activación. Por favor, revise su correo para completar el registro.'),
(71, 'en', '_ACTIVATION_EMAIL_WAS_SENT', 'An email has been sent to _EMAIL_ with an activation key. Please check your mail to complete registration.'),
(72, 'de', '_ACTIVATION_EMAIL_WAS_SENT', 'Eine Email wurde an _EMAIL_ wurde mit einem Aktivierungsschlüssel gesendet. Bitte überprüfen Sie Ihre E-Mail um die Registrierung abzuschließen.'),
(73, 'es', '_ACTIVE', 'Activo'),
(74, 'en', '_ACTIVE', 'Active'),
(75, 'de', '_ACTIVE', 'Aktiv'),
(76, 'es', '_ADDING_OPERATION_COMPLETED', 'La operación terminó con éxito agregando!'),
(77, 'en', '_ADDING_OPERATION_COMPLETED', 'The adding operation completed successfully!'),
(78, 'de', '_ADDING_OPERATION_COMPLETED', 'Die Zugabe Vorgang wurde erfolgreich abgeschlossen!'),
(79, 'es', '_ADDITIONAL_INFO', 'Información Adicional'),
(80, 'en', '_ADDITIONAL_INFO', 'Additional Info'),
(81, 'de', '_ADDITIONAL_INFO', 'Zusätzliche Informationen'),
(82, 'es', '_ADDITIONAL_MODULES', 'Los módulos adicionales'),
(83, 'en', '_ADDITIONAL_MODULES', 'Additional Modules'),
(84, 'de', '_ADDITIONAL_MODULES', 'Zusätzliche Module'),
(85, 'es', '_ADDRESS', 'Dirección'),
(86, 'en', '_ADDRESS', 'Address'),
(87, 'de', '_ADDRESS', 'Adresse'),
(88, 'es', '_ADDRESS_2', 'Dirección (línea 2)'),
(89, 'en', '_ADDRESS_2', 'Address (line 2)'),
(90, 'de', '_ADDRESS_2', 'Adresse (Zeile 2)'),
(91, 'es', '_ADDRESS_EMPTY_ALERT', 'La dirección no puede estar vacío! Por favor, vuelva a entrar.'),
(92, 'en', '_ADDRESS_EMPTY_ALERT', 'Address cannot be empty! Please re-enter.'),
(93, 'de', '_ADDRESS_EMPTY_ALERT', 'Adresse darf nicht leer sein! Bitte erneut eingeben.'),
(94, 'es', '_ADD_NEW', 'Agregar nuevo'),
(95, 'en', '_ADD_NEW', 'Add New'),
(96, 'de', '_ADD_NEW', 'Neu hinzufügen'),
(97, 'es', '_ADD_NEW_MENU', 'Añadir un nuevo menú'),
(98, 'en', '_ADD_NEW_MENU', 'Add New Menu'),
(99, 'de', '_ADD_NEW_MENU', 'Schreibe Neues Menü'),
(100, 'es', '_ADD_TO_MENU', 'Añadir al menú'),
(101, 'en', '_ADD_TO_MENU', 'Add to Menu'),
(102, 'de', '_ADD_TO_MENU', 'Ins Menü'),
(103, 'es', '_ADMIN', 'Administración'),
(104, 'en', '_ADMIN', 'Admin'),
(105, 'de', '_ADMIN', 'Admin'),
(106, 'es', '_ADMINS', 'Administradores'),
(107, 'en', '_ADMINS', 'Admins'),
(108, 'de', '_ADMINS', 'Admins'),
(109, 'es', '_ADMINS_AND_CUSTOMERS', 'Clientes y Administradores'),
(110, 'en', '_ADMINS_AND_CUSTOMERS', 'Customers & Admins'),
(111, 'de', '_ADMINS_AND_CUSTOMERS', 'Kunden & Admins'),
(112, 'es', '_ADMINS_MANAGEMENT', 'Administradores de Gestión de'),
(113, 'en', '_ADMINS_MANAGEMENT', 'Admins Management'),
(114, 'de', '_ADMINS_MANAGEMENT', 'Administratoren Management'),
(115, 'es', '_ADMIN_EMAIL', 'Admin Email'),
(116, 'en', '_ADMIN_EMAIL', 'Admin Email'),
(117, 'de', '_ADMIN_EMAIL', 'Admin E-Mail'),
(118, 'de', '_ADMIN_EMAIL_ALERT', 'Diese E-Mail wird als ''Von''-Adresse für das System E-Mail-Benachrichtigungen verwendet. Stellen Sie sicher, dass Sie hier geben Sie eine gültige E-Mail-Adresse auf Domain Ihrer Website basiert'),
(119, 'en', '_ADMIN_EMAIL_ALERT', 'This email is used as ''From'' address for the system email notifications. Make sure, that you write here a valid email address based on domain of your site'),
(120, 'es', '_ADMIN_EMAIL_ALERT', 'Este correo electrónico se utiliza como dirección ''De'' para las notificaciones del sistema de correo electrónico. Asegúrese de que usted escribe aquí una dirección válida de correo electrónico basado en dominio de su sitio'),
(121, 'es', '_ADMIN_EMAIL_EXISTS_ALERT', 'Administrador de correo electrónico ya existe! Por favor, elija otra.'),
(122, 'en', '_ADMIN_EMAIL_EXISTS_ALERT', 'Administrator with such email already exists! Please choose another.'),
(123, 'de', '_ADMIN_EMAIL_EXISTS_ALERT', 'Administrator mit solchen E-Mail ist bereits vorhanden! Bitte wählen Sie einen anderen.'),
(124, 'es', '_ADMIN_EMAIL_IS_EMPTY', 'Administrador de correo electrónico no debe estar vacía! Por favor, vuelva a entrar.'),
(125, 'en', '_ADMIN_EMAIL_IS_EMPTY', 'Admin email must not be empty! Please re-enter.'),
(126, 'de', '_ADMIN_EMAIL_IS_EMPTY', 'Admin E-Mail darf nicht leer sein! Bitte erneut eingeben.'),
(127, 'es', '_ADMIN_EMAIL_WRONG', 'Administrador de correo electrónico en formato incorrecto! Por favor, vuelva a entrar.'),
(128, 'en', '_ADMIN_EMAIL_WRONG', 'Admin email in wrong format! Please re-enter.'),
(129, 'de', '_ADMIN_EMAIL_WRONG', 'Admin E-Mail in falsche Format! Bitte erneut eingeben.'),
(130, 'es', '_ADMIN_LOGIN', 'Admin Login'),
(131, 'en', '_ADMIN_LOGIN', 'Admin Login'),
(132, 'de', '_ADMIN_LOGIN', 'Admin Login'),
(133, 'es', '_ADMIN_MAILER_ALERT', 'Seleccione el programa de correo que usted prefiere utilizar para la entrega de mensajes de correo electrónico del sitio.'),
(134, 'en', '_ADMIN_MAILER_ALERT', 'Select which mailer you prefer to use for the delivery of site emails.'),
(135, 'de', '_ADMIN_MAILER_ALERT', 'Wählen Sie die Mailer Sie für die Zustellung von E-Mails vor Ort bevorzugen.'),
(136, 'es', '_ADMIN_PANEL', 'Panel de Administración'),
(137, 'en', '_ADMIN_PANEL', 'Admin Panel'),
(138, 'de', '_ADMIN_PANEL', 'Admin-Panel'),
(139, 'es', '_ADSENSE', 'AdSense'),
(140, 'en', '_ADSENSE', 'AdSense'),
(141, 'de', '_ADSENSE', 'AdSense'),
(142, 'es', '_ADSENSE_SETTINGS', 'Configuración de AdSense'),
(143, 'en', '_ADSENSE_SETTINGS', 'AdSense Settings'),
(144, 'de', '_ADSENSE_SETTINGS', 'AdSense-Einstellungen'),
(145, 'es', '_ADVANCED', 'Avanzada'),
(146, 'en', '_ADVANCED', 'Advanced'),
(147, 'de', '_ADVANCED', 'Fortgeschrittene'),
(148, 'es', '_ADVERTISE', 'Anunciar'),
(149, 'en', '_ADVERTISE', 'Advertise'),
(150, 'de', '_ADVERTISE', 'Werben'),
(151, 'es', '_ADVERTISE_PLAN', 'Plan de Publicidad'),
(152, 'en', '_ADVERTISE_PLAN', 'Advertise Plan'),
(153, 'de', '_ADVERTISE_PLAN', 'Werben Plans'),
(154, 'es', '_ADVERTISE_PLANS', 'Publicidad Planes'),
(155, 'en', '_ADVERTISE_PLANS', 'Advertise Plans'),
(156, 'de', '_ADVERTISE_PLANS', 'Werben Pläne'),
(157, 'es', '_AGREE_CONF_TEXT', 'He leído y de acuerdo con Términos y Condiciones'),
(158, 'en', '_AGREE_CONF_TEXT', 'I have read and AGREE with Terms & Conditions'),
(159, 'de', '_AGREE_CONF_TEXT', 'Ich habe gelesen und akzeptiere AGB'),
(160, 'es', '_ALBUM', 'Álbum'),
(161, 'en', '_ALBUM', 'Album'),
(162, 'de', '_ALBUM', 'Album'),
(163, 'es', '_ALBUM_CODE', 'Album Código'),
(164, 'en', '_ALBUM_CODE', 'Album Code'),
(165, 'de', '_ALBUM_CODE', 'Album Code'),
(166, 'es', '_ALBUM_NAME', 'Nombre del álbum'),
(167, 'en', '_ALBUM_NAME', 'Album Name'),
(168, 'de', '_ALBUM_NAME', 'Albumname'),
(169, 'es', '_ALERT_REQUIRED_FILEDS', 'Los elementos marcados con un asterisco (<span class=''required''>*</span>) son obligatorios'),
(170, 'en', '_ALERT_REQUIRED_FILEDS', 'Items marked with an asterisk (<span class=''required''>*</span>) are required'),
(171, 'de', '_ALERT_REQUIRED_FILEDS', 'Felder mit einem Sternchen (<span class=''required''>*</span>) sind erforderlich'),
(172, 'es', '_ALL', 'Todo'),
(173, 'en', '_ALL', 'All'),
(174, 'de', '_ALL', 'Alle'),
(175, 'es', '_ALLOW', 'Permitir'),
(176, 'en', '_ALLOW', 'Allow'),
(177, 'de', '_ALLOW', 'Erlauben'),
(178, 'es', '_ALLOW_COMMENTS', 'Permitir comentarios'),
(179, 'en', '_ALLOW_COMMENTS', 'Allow Comments'),
(180, 'de', '_ALLOW_COMMENTS', 'Kommentare zulassen'),
(181, 'es', '_ALREADY_LOGGED', 'Usted ya está registrado!'),
(182, 'en', '_ALREADY_LOGGED', 'You are already logged in!'),
(183, 'de', '_ALREADY_LOGGED', 'Sie sind bereits angemeldet!'),
(184, 'es', '_AMOUNT', 'Cantidad'),
(185, 'en', '_AMOUNT', 'Amount'),
(186, 'de', '_AMOUNT', 'Betrag'),
(187, 'es', '_ANSWER', 'Respuesta'),
(188, 'en', '_ANSWER', 'Answer'),
(189, 'de', '_ANSWER', 'Antwort'),
(190, 'es', '_APPLY_TO_ALL_LANGUAGES', 'Se aplican a todos los idiomas'),
(191, 'en', '_APPLY_TO_ALL_LANGUAGES', 'Apply to all languages'),
(192, 'de', '_APPLY_TO_ALL_LANGUAGES', 'Gelten für alle Sprachen'),
(193, 'es', '_APPLY_TO_ALL_PAGES', 'Aplicar cambios a todas las páginas'),
(194, 'en', '_APPLY_TO_ALL_PAGES', 'Apply changes to all pages'),
(195, 'de', '_APPLY_TO_ALL_PAGES', 'Änderungen für alle Seiten'),
(196, 'es', '_APPROVE', 'Aprobar'),
(197, 'en', '_APPROVE', 'Approve'),
(198, 'de', '_APPROVE', 'Genehmigen'),
(199, 'es', '_APPROVED', 'Aprobado'),
(200, 'en', '_APPROVED', 'Approved'),
(201, 'de', '_APPROVED', 'Genehmigt'),
(202, 'es', '_APRIL', 'Abril'),
(203, 'en', '_APRIL', 'April'),
(204, 'de', '_APRIL', 'April'),
(205, 'es', '_ARTICLE', 'Artículo'),
(206, 'en', '_ARTICLE', 'Article'),
(207, 'de', '_ARTICLE', 'Artikel'),
(208, 'es', '_ARTICLE_ID', 'Id. de artículo'),
(209, 'en', '_ARTICLE_ID', 'Article ID'),
(210, 'de', '_ARTICLE_ID', 'Artikel-ID'),
(211, 'es', '_AUGUST', 'Agosto'),
(212, 'en', '_AUGUST', 'August'),
(213, 'de', '_AUGUST', 'August'),
(214, 'es', '_AUTHENTICATION', 'Autenticación'),
(215, 'en', '_AUTHENTICATION', 'Authentication'),
(216, 'de', '_AUTHENTICATION', 'Authentifizierung'),
(217, 'es', '_AUTHORIZE_NET_NOTICE', 'El pago Authorize.Net portal de proveedores de servicios.'),
(218, 'en', '_AUTHORIZE_NET_NOTICE', 'The Authorize.Net payment gateway service provider.'),
(219, 'de', '_AUTHORIZE_NET_NOTICE', 'Die Authorize.Net Payment Gateway Service Provider.'),
(220, 'es', '_AUTHORIZE_NET_ORDER', 'Authorize.Net Orden'),
(221, 'en', '_AUTHORIZE_NET_ORDER', 'Authorize.Net Order'),
(222, 'de', '_AUTHORIZE_NET_ORDER', 'Authorize.Net Auftrag'),
(223, 'es', '_AVAILABLE_LISTINGS_ALERT', 'Usted tiene listados _LISTINGS_COUNT_ disponibles para su publicación.'),
(224, 'en', '_AVAILABLE_LISTINGS_ALERT', 'You have _LISTINGS_COUNT_ listings available for publishing.'),
(225, 'de', '_AVAILABLE_LISTINGS_ALERT', 'Sie haben _LISTINGS_COUNT_ Inserate zur Veröffentlichung bereit.'),
(226, 'es', '_AVAILABLE_LISTINGS_TOOLTIP', 'Muestra una serie de listados disponibles para el cliente'),
(227, 'en', '_AVAILABLE_LISTINGS_TOOLTIP', 'Displays a number of available listings for customer'),
(228, 'de', '_AVAILABLE_LISTINGS_TOOLTIP', 'Zeigt eine Anzahl der verfügbaren Angebote für Kunden'),
(229, 'es', '_BACKUP', 'Reserva'),
(230, 'en', '_BACKUP', 'Backup'),
(231, 'de', '_BACKUP', 'Backup'),
(232, 'es', '_BACKUPS_EXISTING', 'Copias de seguridad existentes'),
(233, 'en', '_BACKUPS_EXISTING', 'Existing Backups'),
(234, 'de', '_BACKUPS_EXISTING', 'Vorhandene Backups'),
(235, 'es', '_BACKUP_AND_RESTORE', 'Backup & Restore'),
(236, 'en', '_BACKUP_AND_RESTORE', 'Backup & Restore'),
(237, 'de', '_BACKUP_AND_RESTORE', 'Backup & Restore'),
(238, 'es', '_BACKUP_CHOOSE_MSG', 'Elija una copia de seguridad de la siguiente lista'),
(239, 'en', '_BACKUP_CHOOSE_MSG', 'Choose a backup from the list below'),
(240, 'de', '_BACKUP_CHOOSE_MSG', 'Wählen Sie ein Backup von der Liste unten'),
(241, 'es', '_BACKUP_DELETE_ALERT', '¿Estás seguro de que quieres eliminar esta copia de seguridad?'),
(242, 'en', '_BACKUP_DELETE_ALERT', 'Are you sure you want to delete this backup?'),
(243, 'de', '_BACKUP_DELETE_ALERT', 'Sind Sie sicher, dass Sie diese Sicherung löschen?'),
(244, 'es', '_BACKUP_EMPTY_MSG', 'No hay copias de seguridad todavía.'),
(245, 'en', '_BACKUP_EMPTY_MSG', 'No existing backups found.'),
(246, 'de', '_BACKUP_EMPTY_MSG', 'Keine vorhandenen Backups gefunden.'),
(247, 'es', '_BACKUP_EMPTY_NAME_ALERT', 'Nombre del archivo de copia de seguridad no puede estar vacía! Por favor, vuelva a entrar.'),
(248, 'en', '_BACKUP_EMPTY_NAME_ALERT', 'Name of backup file cannot be empty! Please re-enter.'),
(249, 'de', '_BACKUP_EMPTY_NAME_ALERT', 'Namen der Backup-Datei kann nicht leer sein! Bitte erneut eingeben.'),
(250, 'es', '_BACKUP_EXECUTING_ERROR', 'Se produjo un error mientras copia de seguridad del sistema! Por favor, compruebe los permisos de escritura a la carpeta de copia de seguridad o vuelva a intentarlo más tarde.'),
(251, 'en', '_BACKUP_EXECUTING_ERROR', 'An error occurred while backup the system! Please check write permissions to backup folder or try again later.'),
(252, 'de', '_BACKUP_EXECUTING_ERROR', 'Fehler beim Backup des Systems! Bitte überprüfen Sie Schreibzugriff auf Backup-Ordner oder versuchen Sie es später erneut.'),
(253, 'es', '_BACKUP_INSTALLATION', 'Instalación de copia de seguridad'),
(254, 'en', '_BACKUP_INSTALLATION', 'Backup Installation'),
(255, 'de', '_BACKUP_INSTALLATION', 'Backup-Installation'),
(256, 'es', '_BACKUP_RESTORE', 'Restaurar copia de seguridad'),
(257, 'en', '_BACKUP_RESTORE', 'Backup Restore'),
(258, 'de', '_BACKUP_RESTORE', 'Backup wiederherstellen'),
(259, 'es', '_BACKUP_RESTORE_ALERT', '¿Estás seguro de que desea restaurar esta copia de seguridad'),
(260, 'en', '_BACKUP_RESTORE_ALERT', 'Are you sure you want to restore this backup'),
(261, 'de', '_BACKUP_RESTORE_ALERT', 'Sind Sie sicher, dass Sie diese Sicherung wiederherstellen'),
(262, 'es', '_BACKUP_RESTORE_NOTE', 'Recuerde: esta acción se volverá a escribir toda la configuración actual!'),
(263, 'en', '_BACKUP_RESTORE_NOTE', 'Remember: this action will rewrite all your current settings!'),
(264, 'de', '_BACKUP_RESTORE_NOTE', 'Denken Sie daran: diese Aktion werden alle aktuellen Einstellungen neu zu schreiben!'),
(265, 'es', '_BACKUP_RESTORING_ERROR', 'Se produjo un error mientras se restaura el archivo! Por favor, inténtelo de nuevo más tarde.'),
(266, 'en', '_BACKUP_RESTORING_ERROR', 'An error occurred while restoring file! Please try again later.'),
(267, 'de', '_BACKUP_RESTORING_ERROR', 'Fehler beim Wiederherstellen-Datei! Bitte versuchen Sie es später erneut.'),
(268, 'es', '_BACKUP_WAS_CREATED', '_FILE_NAME_ De copia de seguridad se ha creado correctamente.'),
(269, 'en', '_BACKUP_WAS_CREATED', 'Backup _FILE_NAME_ has been successfully created.'),
(270, 'de', '_BACKUP_WAS_CREATED', 'Backup _FILE_NAME_ wurde erfolgreich erstellt.'),
(271, 'es', '_BACKUP_WAS_DELETED', '_FILE_NAME_ De copia de seguridad ha sido borrado.'),
(272, 'en', '_BACKUP_WAS_DELETED', 'Backup _FILE_NAME_ has been successfully deleted.'),
(273, 'de', '_BACKUP_WAS_DELETED', 'Backup _FILE_NAME_ wurde erfolgreich gelöscht.'),
(274, 'es', '_BACKUP_WAS_RESTORED', '_FILE_NAME_ De copia de seguridad fue restaurado con éxito.'),
(275, 'en', '_BACKUP_WAS_RESTORED', 'Backup _FILE_NAME_ has been successfully restored.'),
(276, 'de', '_BACKUP_WAS_RESTORED', 'Backup _FILE_NAME_ wurde erfolgreich wiederhergestellt.'),
(277, 'es', '_BACKUP_YOUR_INSTALLATION', 'Copia de seguridad de la instalación actual'),
(278, 'en', '_BACKUP_YOUR_INSTALLATION', 'Backup your current Installation'),
(279, 'de', '_BACKUP_YOUR_INSTALLATION', 'Sichern Sie Ihre aktuelle Installation'),
(280, 'es', '_BACK_TO_ADMIN_PANEL', 'Volver al panel de administración'),
(281, 'en', '_BACK_TO_ADMIN_PANEL', 'Back to Admin Panel'),
(282, 'de', '_BACK_TO_ADMIN_PANEL', 'Zurück zu Admin Panel'),
(283, 'es', '_BACK_TO_LOGIN', 'Volver a la entrada'),
(284, 'en', '_BACK_TO_LOGIN', 'Back to login'),
(285, 'de', '_BACK_TO_LOGIN', 'Zurück zum Login'),
(286, 'es', '_BANNERS', 'Banners'),
(287, 'en', '_BANNERS', 'Banners'),
(288, 'de', '_BANNERS', 'Banner'),
(289, 'es', '_BANNERS_MANAGEMENT', 'Banners de Gestión'),
(290, 'en', '_BANNERS_MANAGEMENT', 'Banners Management'),
(291, 'de', '_BANNERS_MANAGEMENT', 'Banner-Management'),
(292, 'es', '_BANNERS_SETTINGS', 'Banners Configuración'),
(293, 'en', '_BANNERS_SETTINGS', 'Banners Settings'),
(294, 'de', '_BANNERS_SETTINGS', 'Banner-Einstellungen'),
(295, 'es', '_BANNER_IMAGE', 'Banner Imagen'),
(296, 'en', '_BANNER_IMAGE', 'Banner Image'),
(297, 'de', '_BANNER_IMAGE', 'Banner Image'),
(298, 'es', '_BAN_ITEM', 'Venta de artículo'),
(299, 'en', '_BAN_ITEM', 'Ban Item'),
(300, 'de', '_BAN_ITEM', 'Ban Posten'),
(301, 'es', '_BAN_LIST', 'Lista de prohibición'),
(302, 'en', '_BAN_LIST', 'Ban List'),
(303, 'de', '_BAN_LIST', 'Ban Liste'),
(304, 'es', '_BILLING_ADDRESS', 'Dirección de facturación'),
(305, 'en', '_BILLING_ADDRESS', 'Billing Address'),
(306, 'de', '_BILLING_ADDRESS', 'Rechnungsadresse'),
(307, 'es', '_BILLING_INFORMATION', 'Información de facturación'),
(308, 'en', '_BILLING_INFORMATION', 'Billing Information'),
(309, 'de', '_BILLING_INFORMATION', 'Informationen zur Abrechnung'),
(310, 'es', '_BIRTH_DATE', 'Fecha de nacimiento'),
(311, 'en', '_BIRTH_DATE', 'Birth Date'),
(312, 'de', '_BIRTH_DATE', 'Geburtsdatum'),
(313, 'es', '_BIRTH_DATE_VALID_ALERT', 'Fecha de nacimiento fue inscrita en un formato incorrecto! Por favor, vuelva a entrar.'),
(314, 'en', '_BIRTH_DATE_VALID_ALERT', 'Birth date was entered in wrong format! Please re-enter.'),
(315, 'de', '_BIRTH_DATE_VALID_ALERT', 'Geburtsdatum war im falschen Format eingegeben! Bitte erneut eingeben.'),
(316, 'es', '_BLUE', 'Azul'),
(317, 'en', '_BLUE', 'Blue'),
(318, 'de', '_BLUE', 'Blue'),
(319, 'es', '_BOTTOM', 'Inferior'),
(320, 'en', '_BOTTOM', 'Bottom'),
(321, 'de', '_BOTTOM', 'Boden'),
(322, 'es', '_BUTTON_BACK', 'Espalda'),
(323, 'en', '_BUTTON_BACK', 'Back'),
(324, 'de', '_BUTTON_BACK', 'Zurück'),
(325, 'es', '_BUTTON_CANCEL', 'Cancelar'),
(326, 'en', '_BUTTON_CANCEL', 'Cancel'),
(327, 'de', '_BUTTON_CANCEL', 'Abbrechen'),
(328, 'es', '_BUTTON_CHANGE', 'Cambiar'),
(329, 'en', '_BUTTON_CHANGE', 'Change'),
(330, 'de', '_BUTTON_CHANGE', 'Ändern'),
(331, 'es', '_BUTTON_CHANGE_PASSWORD', 'Cambiar Contraseña'),
(332, 'en', '_BUTTON_CHANGE_PASSWORD', 'Change Password'),
(333, 'de', '_BUTTON_CHANGE_PASSWORD', 'Passwort ändern'),
(334, 'es', '_BUTTON_CREATE', 'Crear'),
(335, 'en', '_BUTTON_CREATE', 'Create'),
(336, 'de', '_BUTTON_CREATE', 'Erstellen'),
(337, 'es', '_BUTTON_LOGIN', 'Login'),
(338, 'en', '_BUTTON_LOGIN', 'Login'),
(339, 'de', '_BUTTON_LOGIN', 'Login'),
(340, 'es', '_BUTTON_LOGOUT', 'Cerrar sesión'),
(341, 'en', '_BUTTON_LOGOUT', 'Logout'),
(342, 'de', '_BUTTON_LOGOUT', 'Abmelden'),
(343, 'es', '_BUTTON_RESET', 'Perdí'),
(344, 'en', '_BUTTON_RESET', 'Reset'),
(345, 'de', '_BUTTON_RESET', 'Reset'),
(346, 'es', '_BUTTON_REWRITE', 'Vuelva a escribir Vocabulario'),
(347, 'en', '_BUTTON_REWRITE', 'Rewrite Vocabulary'),
(348, 'de', '_BUTTON_REWRITE', 'Rewrite Wortschatz'),
(349, 'es', '_BUTTON_SAVE_CHANGES', 'Guardar cambios'),
(350, 'en', '_BUTTON_SAVE_CHANGES', 'Save Changes'),
(351, 'de', '_BUTTON_SAVE_CHANGES', 'Änderungen speichern'),
(352, 'es', '_BUTTON_UPDATE', 'Actualizar'),
(353, 'en', '_BUTTON_UPDATE', 'Update'),
(354, 'de', '_BUTTON_UPDATE', 'Update'),
(355, 'es', '_BUY_NOW', '¡Cómpralo ya!'),
(356, 'en', '_BUY_NOW', 'Buy Now'),
(357, 'de', '_BUY_NOW', 'Jetzt kaufen'),
(358, 'es', '_CACHE_LIFETIME', 'Cache de por vida'),
(359, 'en', '_CACHE_LIFETIME', 'Cache Lifetime'),
(360, 'de', '_CACHE_LIFETIME', 'Cache Lifetime'),
(361, 'es', '_CACHING', 'Caché'),
(362, 'en', '_CACHING', 'Caching'),
(363, 'de', '_CACHING', 'Caching'),
(364, 'es', '_CAN_USE_TAGS_MSG', 'Puede utilizar las etiquetas HTML, como'),
(365, 'en', '_CAN_USE_TAGS_MSG', 'You can use some HTML tags, such as'),
(366, 'de', '_CAN_USE_TAGS_MSG', 'Sie können einige HTML-Tags wie'),
(367, 'es', '_CATEGORIES', 'Categorías'),
(368, 'en', '_CATEGORIES', 'Categories'),
(369, 'de', '_CATEGORIES', 'Kategorien'),
(370, 'es', '_CATEGORIES_MANAGEMENT', 'Categorías de Manejo'),
(371, 'en', '_CATEGORIES_MANAGEMENT', 'Categories Management'),
(372, 'de', '_CATEGORIES_MANAGEMENT', 'Kategorien Management'),
(373, 'es', '_CATEGORY', 'Categoría'),
(374, 'en', '_CATEGORY', 'Category'),
(375, 'de', '_CATEGORY', 'Kategorie'),
(376, 'es', '_CATEGORY_DELETE_LISTINGS', 'No se puede eliminar esta categoría, ya que todavía incluye listados! Por favor, elimine todos los anuncios antes de la operación.'),
(377, 'en', '_CATEGORY_DELETE_LISTINGS', 'You cannot delete this category, because it still includes some listings! Please remove all listings before this operation.'),
(378, 'de', '_CATEGORY_DELETE_LISTINGS', 'Sie können diese Kategorie nicht löschen, weil es auch noch gelistet! Bitte entfernen Sie alle Angebote vor der Operation.'),
(379, 'es', '_CATEGORY_DELETE_SUBCATEGORIES', 'No se puede eliminar esta categoría, ya que todavía incluye las subcategorías! Por favor, elimine todas las subcategorías antes de la operación.'),
(380, 'en', '_CATEGORY_DELETE_SUBCATEGORIES', 'You cannot delete this category, because it still includes some subcategories! Please remove all subcategories before this operation.'),
(381, 'de', '_CATEGORY_DELETE_SUBCATEGORIES', 'Sie können diese Kategorie nicht löschen, weil es auch noch Unterkategorien! Bitte entfernen Sie alle Unterkategorien vor der Operation.'),
(382, 'es', '_CATEGORY_DESCRIPTION', 'Categoría Descripción'),
(383, 'en', '_CATEGORY_DESCRIPTION', 'Category Description'),
(384, 'de', '_CATEGORY_DESCRIPTION', 'Kategorie Beschreibung'),
(385, 'es', '_CC_CARD_INVALID_FORMAT', 'Número de tarjeta de crédito tiene un formato válido! Por favor, vuelva a entrar.'),
(386, 'en', '_CC_CARD_INVALID_FORMAT', 'Credit card number has invalid format! Please re-enter.'),
(387, 'de', '_CC_CARD_INVALID_FORMAT', 'Kreditkarten-Nummer hat ungültiges Format! Bitte erneut eingeben.'),
(388, 'es', '_CC_CARD_INVALID_NUMBER', 'Número de tarjeta de crédito no es válido! Por favor, vuelva a entrar.'),
(389, 'en', '_CC_CARD_INVALID_NUMBER', 'Credit card number is invalid! Please re-enter.'),
(390, 'de', '_CC_CARD_INVALID_NUMBER', 'Kreditkarten-Nummer ist ungültig! Bitte erneut eingeben.'),
(391, 'es', '_CC_CARD_NO_CVV_NUMBER', 'No Código CVV siempre! Por favor, vuelva a entrar.'),
(392, 'en', '_CC_CARD_NO_CVV_NUMBER', 'No CVV Code provided! Please re-enter.'),
(393, 'de', '_CC_CARD_NO_CVV_NUMBER', 'Keine CVV-Code zur Verfügung gestellt! Bitte erneut eingeben.'),
(394, 'es', '_CC_CARD_WRONG_EXPIRE_DATE', 'Tarjeta de crédito fecha de caducidad está mal! Por favor, vuelva a entrar.'),
(395, 'en', '_CC_CARD_WRONG_EXPIRE_DATE', 'Credit card expiry date is wrong! Please re-enter.'),
(396, 'de', '_CC_CARD_WRONG_EXPIRE_DATE', 'Kreditkarte Verfallsdatum ist falsch! Bitte erneut eingeben.'),
(397, 'es', '_CC_CARD_WRONG_LENGTH', 'Número de tarjeta de crédito es la longitud del mal! Por favor, vuelva a entrar.'),
(398, 'en', '_CC_CARD_WRONG_LENGTH', 'Credit card number has a wrong length! Please re-enter.'),
(399, 'de', '_CC_CARD_WRONG_LENGTH', 'Kreditkarten-Nummer falsch ist lang! Bitte erneut eingeben.'),
(400, 'es', '_CC_NO_CARD_NUMBER', 'No hay número de tarjeta de siempre! Por favor, vuelva a introducir.'),
(401, 'en', '_CC_NO_CARD_NUMBER', 'No card number provided! Please re-enter.'),
(402, 'de', '_CC_NO_CARD_NUMBER', 'Keine Kartennummer zur Verfügung gestellt! Bitte erneut eingeben.'),
(403, 'es', '_CC_NO_CARD_NUMBER_PROVIDED', 'No hay número de tarjeta de siempre! Por favor, vuelva a entrar.'),
(404, 'en', '_CC_NO_CARD_NUMBER_PROVIDED', 'No card number provided! Please re-enter.'),
(405, 'de', '_CC_NO_CARD_NUMBER_PROVIDED', 'Keine Kartennummer zur Verfügung gestellt! Bitte erneut eingeben.'),
(406, 'es', '_CC_UNKNOWN_CARD_TYPE', 'Tipo de tarjeta desconocido! Por favor, vuelva a entrar.'),
(407, 'en', '_CC_UNKNOWN_CARD_TYPE', 'Unknown card type! Please re-enter.'),
(408, 'de', '_CC_UNKNOWN_CARD_TYPE', 'Unknown Karte Typ! Bitte erneut eingeben.'),
(409, 'es', '_CHANGES_SAVED', 'Los cambios se salvaron.'),
(410, 'en', '_CHANGES_SAVED', 'Changes were saved.'),
(411, 'de', '_CHANGES_SAVED', 'Änderungen wurden gespeichert.'),
(412, 'es', '_CHANGES_WERE_SAVED', 'Los cambios se han guardado correctamente!'),
(413, 'en', '_CHANGES_WERE_SAVED', 'Changes were successfully saved!'),
(414, 'de', '_CHANGES_WERE_SAVED', 'Änderungen wurden erfolgreich gespeichert!'),
(415, 'es', '_CHANGE_ORDER', 'Cambiar el orden de'),
(416, 'en', '_CHANGE_ORDER', 'Change Order'),
(417, 'de', '_CHANGE_ORDER', 'Auftrag ändern'),
(418, 'es', '_CHANGE_YOUR_PASSWORD', 'Cambie su contraseña'),
(419, 'en', '_CHANGE_YOUR_PASSWORD', 'Change your password'),
(420, 'de', '_CHANGE_YOUR_PASSWORD', 'Ändern Sie Ihr Passwort'),
(421, 'es', '_CHECKOUT', 'Caja'),
(422, 'en', '_CHECKOUT', 'Checkout'),
(423, 'de', '_CHECKOUT', 'Kasse'),
(424, 'es', '_CITY', 'Ciudad'),
(425, 'en', '_CITY', 'City'),
(426, 'de', '_CITY', 'City'),
(427, 'es', '_CITY_EMPTY_ALERT', 'Ciudad no puede estar vacío! Por favor, vuelva a entrar.'),
(428, 'en', '_CITY_EMPTY_ALERT', 'City cannot be empty! Please re-enter.'),
(429, 'de', '_CITY_EMPTY_ALERT', 'City darf nicht leer sein! Bitte erneut eingeben.'),
(430, 'es', '_CLEANED', 'Limpiar'),
(431, 'en', '_CLEANED', 'Cleaned'),
(432, 'de', '_CLEANED', 'Gereinigt'),
(433, 'es', '_CLEAN_CACHE', 'Borrar caché'),
(434, 'en', '_CLEAN_CACHE', 'Clean Cache'),
(435, 'de', '_CLEAN_CACHE', 'Cache löschen'),
(436, 'es', '_CLICK_TO_EDIT', 'Haga clic para editar'),
(437, 'en', '_CLICK_TO_EDIT', 'Click to edit'),
(438, 'de', '_CLICK_TO_EDIT', 'Klicken Sie zum Bearbeiten'),
(439, 'es', '_CLICK_TO_INCREASE', 'Haga click para ampliar'),
(440, 'en', '_CLICK_TO_INCREASE', 'Click to enlarge'),
(441, 'de', '_CLICK_TO_INCREASE', 'Klicken zum Vergrößern'),
(442, 'es', '_CLICK_TO_SEE_DESCR', 'Haz clic aquí para ver la descripción'),
(443, 'en', '_CLICK_TO_SEE_DESCR', 'Click to see description'),
(444, 'de', '_CLICK_TO_SEE_DESCR', 'Hier klicken Beschreibung siehe'),
(445, 'es', '_CLICK_TO_VIEW', 'Haga clic para ver'),
(446, 'en', '_CLICK_TO_VIEW', 'Click to view'),
(447, 'de', '_CLICK_TO_VIEW', 'Klicken Sie zur Ansicht'),
(448, 'es', '_CLOSE', 'Cerrar'),
(449, 'en', '_CLOSE', 'Close'),
(450, 'de', '_CLOSE', 'Schließen'),
(451, 'es', '_CLOSE_META_TAGS', 'Cerrar etiquetas META'),
(452, 'en', '_CLOSE_META_TAGS', 'Close META tags'),
(453, 'de', '_CLOSE_META_TAGS', 'Schließen Sie META-Tags'),
(454, 'es', '_CODE', 'Código'),
(455, 'en', '_CODE', 'Code'),
(456, 'de', '_CODE', 'Code'),
(457, 'es', '_COLLAPSE_PANEL', 'Colapso del panel de navegación'),
(458, 'en', '_COLLAPSE_PANEL', 'Collapse navigation panel'),
(459, 'de', '_COLLAPSE_PANEL', 'Collapse Navigationsleiste'),
(460, 'es', '_COMMENTS', 'Comentarios'),
(461, 'en', '_COMMENTS', 'Comments'),
(462, 'de', '_COMMENTS', 'Kommentare'),
(463, 'es', '_COMMENTS_AWAITING_MODERATION_ALERT', 'Hay comentarios _COUNT_ en espera de su moderación. Haga clic <a href=''index.php?admin=mod_comments_management''>aquí</a> para su revisión.'),
(464, 'en', '_COMMENTS_AWAITING_MODERATION_ALERT', 'There are _COUNT_ comment/s awaiting your moderation. Click <a href=''index.php?admin=mod_comments_management''>here</a> for review.'),
(465, 'de', '_COMMENTS_AWAITING_MODERATION_ALERT', 'Es gibt _COUNT_ Kommentare Erwartung Ihrer Moderation. Klicken Sie <a href=''index.php?admin=mod_comments_management''>hier</a> für eine Bewertung.'),
(466, 'es', '_COMMENTS_LINK', 'Comentarios (_COUNT_)'),
(467, 'en', '_COMMENTS_LINK', 'Comments (_COUNT_)'),
(468, 'de', '_COMMENTS_LINK', 'Kommentare (_COUNT_)'),
(469, 'es', '_COMMENTS_MANAGEMENT', 'Comentarios de Gestión'),
(470, 'en', '_COMMENTS_MANAGEMENT', 'Comments Management'),
(471, 'de', '_COMMENTS_MANAGEMENT', 'Kommentare Management'),
(472, 'es', '_COMMENTS_SETTINGS', 'Comentarios Configuración'),
(473, 'en', '_COMMENTS_SETTINGS', 'Comments Settings'),
(474, 'de', '_COMMENTS_SETTINGS', 'Kommentare Einstellungen'),
(475, 'es', '_COMMENT_DELETED_SUCCESS', 'Su comentario ha sido borrado.'),
(476, 'en', '_COMMENT_DELETED_SUCCESS', 'Your comment has been successfully deleted.'),
(477, 'de', '_COMMENT_DELETED_SUCCESS', 'Dein Kommentar wurde erfolgreich gelöscht.'),
(478, 'es', '_COMMENT_LENGTH_ALERT', 'La longitud de los comentarios debe ser inferior a _LENGTH_ personajes!'),
(479, 'en', '_COMMENT_LENGTH_ALERT', 'The length of comment must be less than _LENGTH_ characters!'),
(480, 'de', '_COMMENT_LENGTH_ALERT', 'Die Länge der Kommentar muss kleiner sein als _LENGTH_ Zeichen!'),
(481, 'es', '_COMMENT_POSTED_SUCCESS', 'Tu comentario ha sido enviado con éxito!'),
(482, 'en', '_COMMENT_POSTED_SUCCESS', 'Your comment has been successfully posted!'),
(483, 'de', '_COMMENT_POSTED_SUCCESS', 'Your comment has been successfully posted!'),
(484, 'es', '_COMMENT_SUBMITTED_SUCCESS', 'Tu comentario ha sido enviado correctamente y será publicado después de la revisión del administrador!'),
(485, 'en', '_COMMENT_SUBMITTED_SUCCESS', 'Your comment has been successfully submitted and will be posted after administrator''s review!'),
(486, 'de', '_COMMENT_SUBMITTED_SUCCESS', 'Dein Kommentar wurde Erfolgreich übermittelt und WIRD nach Administrator-Beitrag gepostet Werden!'),
(487, 'es', '_COMMENT_TEXT', 'Comentario de texto'),
(488, 'en', '_COMMENT_TEXT', 'Comment text'),
(489, 'de', '_COMMENT_TEXT', 'Kommentieren Text'),
(490, 'es', '_COMPANY', 'Compañía'),
(491, 'en', '_COMPANY', 'Company'),
(492, 'de', '_COMPANY', 'Gesellschaft'),
(493, 'es', '_COMPLETED', 'Completado'),
(494, 'en', '_COMPLETED', 'Completed'),
(495, 'de', '_COMPLETED', 'Fertiggestellt'),
(496, 'es', '_CONFIRMATION_CODE', 'Código de confirmación'),
(497, 'en', '_CONFIRMATION_CODE', 'Confirmation Code'),
(498, 'de', '_CONFIRMATION_CODE', 'Bestätigungs-Code'),
(499, 'es', '_CONFIRMED_ALREADY_MSG', 'Su cuenta ha sido ya confirmado!<br><br>Haga clic <a href=''index.php?customer=login''>aquí</a> para continuar.'),
(500, 'en', '_CONFIRMED_ALREADY_MSG', 'Your account has already been confirmed! <br><br>Click <a href=''index.php?customer=login''>here</a> to continue.'),
(501, 'de', '_CONFIRMED_ALREADY_MSG', 'Ihr Konto wurde bereits bestätigt! <br><br>Klicken Sie <a href=''index.php?customer=login''>hier</a>, um fortzufahren.'),
(502, 'es', '_CONFIRMED_SUCCESS_MSG', 'Gracias por confirmar su inscripción! <br>Ahora puede acceder a su cuenta. Haga clic <a href=''index.php?customer=login''>aquí</a> para continuar.'),
(503, 'en', '_CONFIRMED_SUCCESS_MSG', 'Thank you for confirming your registration! <br>You may now log into your account. Click <a href=''index.php?customer=login''>here</a> to proceed.'),
(504, 'de', '_CONFIRMED_SUCCESS_MSG', 'Vielen Dank für Ihre Anmeldung bestätigt! <br>Sie können jetzt in Ihr Konto einloggen. Klicken Sie <a href=''index.php?customer=login''>hier</a>, um fortzufahren.'),
(505, 'es', '_CONFIRM_PASSWORD', 'confirmar contraseña'),
(506, 'en', '_CONFIRM_PASSWORD', 'Confirm Password'),
(507, 'de', '_CONFIRM_PASSWORD', 'Kennwort bestätigen'),
(508, 'es', '_CONFIRM_TERMS_CONDITIONS', 'Usted debe confirmar que está de acuerdo con nuestros términos y condiciones!'),
(509, 'en', '_CONFIRM_TERMS_CONDITIONS', 'You must to confirm you agree with our Terms & Conditions!'),
(510, 'de', '_CONFIRM_TERMS_CONDITIONS', 'Sie müssen bestätigen, dass Sie sich mit unseren AGB!'),
(511, 'es', '_CONF_PASSWORD_IS_EMPTY', 'Confirmar contraseña no puede estar vacío!'),
(512, 'en', '_CONF_PASSWORD_IS_EMPTY', 'Confirm Password cannot be empty!'),
(513, 'de', '_CONF_PASSWORD_IS_EMPTY', 'Kennwort bestätigen können nicht leer sein!'),
(514, 'es', '_CONF_PASSWORD_MATCH', 'La contraseña debe tener partido con Confirmar contraseña'),
(515, 'en', '_CONF_PASSWORD_MATCH', 'Password must be match with Confirm Password'),
(516, 'de', '_CONF_PASSWORD_MATCH', 'Das Passwort muss übereinstimmen mit Kennwort bestätigen werden'),
(517, 'es', '_CONTACTUS_DEFAULT_EMAIL_ALERT', 'Tienes que cambiar la dirección de correo electrónico predeterminado para Contáctenos módulo. Haga clic <a href=''index.php?admin=mod_contact_us_settings''>aquí</a> para continuar.'),
(518, 'en', '_CONTACTUS_DEFAULT_EMAIL_ALERT', 'You have to change default email address for Contact Us module. Click <a href=''index.php?admin=mod_contact_us_settings''>here</a> to proceed.'),
(519, 'de', '_CONTACTUS_DEFAULT_EMAIL_ALERT', 'Sie haben zum ursprünglichen E-Mail-Adresse für Kontakt-Modul ändern. Klicken Sie <a href=''index.php?admin=mod_contact_us_settings''>hier</a>, um fortzufahren.'),
(520, 'es', '_CONTACT_INFORMATION', 'Información de contacto'),
(521, 'en', '_CONTACT_INFORMATION', 'Contact Information'),
(522, 'de', '_CONTACT_INFORMATION', 'Kontakt Information'),
(523, 'es', '_CONTACT_US', 'Contáctenos'),
(524, 'en', '_CONTACT_US', 'Contact us'),
(525, 'de', '_CONTACT_US', 'Kontaktieren Sie uns'),
(526, 'es', '_CONTACT_US_ALREADY_SENT', 'Tu mensaje ha sido enviado ya. Por favor, inténtelo de nuevo más tarde o esperar _WAIT_ segundos.'),
(527, 'en', '_CONTACT_US_ALREADY_SENT', 'Your message has been already sent. Please try again later or wait _WAIT_ seconds.'),
(528, 'de', '_CONTACT_US_ALREADY_SENT', 'Ihre Nachricht wurde bereits gesendet. Bitte versuchen Sie es später noch einmal oder warten _WAIT_ Sekunden.'),
(529, 'es', '_CONTACT_US_EMAIL_SENT', 'Gracias por contactar con nosotros! Su mensaje ha sido enviado con éxito.'),
(530, 'en', '_CONTACT_US_EMAIL_SENT', 'Thank you for contacting us! Your message has been successfully sent.'),
(531, 'de', '_CONTACT_US_EMAIL_SENT', 'Vielen Dank für Ihre Kontaktaufnahme! Ihre Nachricht wurde erfolgreich versendet.'),
(532, 'es', '_CONTACT_US_SETTINGS', 'Contacte con nosotros ajustes'),
(533, 'en', '_CONTACT_US_SETTINGS', 'Contact Us Settings'),
(534, 'de', '_CONTACT_US_SETTINGS', 'Kontakt Einstellungen'),
(535, 'es', '_CONTENT_TYPE', 'Tipo de contenido'),
(536, 'en', '_CONTENT_TYPE', 'Content Type'),
(537, 'de', '_CONTENT_TYPE', 'Content-Typ'),
(538, 'es', '_COPY_TO_OTHER_LANGS', 'Copiar a otros idiomas'),
(539, 'en', '_COPY_TO_OTHER_LANGS', 'Copy to other languages'),
(540, 'de', '_COPY_TO_OTHER_LANGS', 'Kopieren in andere Sprachen'),
(541, 'es', '_COUNTRIES', 'Países'),
(542, 'en', '_COUNTRIES', 'Countries'),
(543, 'de', '_COUNTRIES', 'Länder'),
(544, 'es', '_COUNTRIES_MANAGEMENT', 'Los países de Gestión'),
(545, 'en', '_COUNTRIES_MANAGEMENT', 'Countries Management'),
(546, 'de', '_COUNTRIES_MANAGEMENT', 'Länder Management'),
(547, 'es', '_COUNTRY', 'País'),
(548, 'en', '_COUNTRY', 'Country'),
(549, 'de', '_COUNTRY', 'Land'),
(550, 'es', '_COUNTRY_EMPTY_ALERT', 'País no puede estar vacío! Por favor, vuelva a entrar.'),
(551, 'en', '_COUNTRY_EMPTY_ALERT', 'Country cannot be empty! Please re-enter.'),
(552, 'de', '_COUNTRY_EMPTY_ALERT', 'Land darf nicht leer sein! Bitte erneut eingeben.'),
(553, 'es', '_CREATED_DATE', 'Fecha de creación'),
(554, 'en', '_CREATED_DATE', 'Date Created'),
(555, 'de', '_CREATED_DATE', 'Erstellungsdatum'),
(556, 'es', '_CREATE_ACCOUNT', 'Crear cuenta'),
(557, 'en', '_CREATE_ACCOUNT', 'Create account'),
(558, 'de', '_CREATE_ACCOUNT', 'Konto erstellen'),
(559, 'es', '_CREATE_ACCOUNT_NOTE', 'NOTA: MedlinePlus\nLe recomendamos que su contraseña debe tener al menos 6 caracteres de longitud y debe ser diferente de su nombre de usuario. <br>\nSu dirección de correo electrónico debe ser válida. Usamos el correo electrónico con fines de comunicación (notificaciones de pedido, etc.) Por lo tanto, es esencial para proporcionar una dirección válida de correo electrónico para poder utilizar nuestros servicios correctamente. <br>\nTodos sus datos personales son confidenciales. Nunca vamos a vender, intercambiar o comercializar de ninguna manera. Para más información sobre las responsabilidades de ambas partes, usted puede referirse a nosotros.'),
(560, 'en', '_CREATE_ACCOUNT_NOTE', 'NOTE: <br>\nWe recommend that your password should be at least 6 characters long and should be different from your username.<br><br>\nYour e-mail address must be valid. We use e-mail for communication purposes (order notifications, etc). Therefore, it is essential to provide a valid e-mail address to be able to use our services correctly.<br><br>\nAll your private data is confidential. We will never sell, exchange or market it in any way. For further information on the responsibilities of both parts, you may refer to us.'),
(561, 'de', '_CREATE_ACCOUNT_NOTE', 'Hinweis: <br>Wir empfehlen, dass Sie Ihr Passwort sollte mindestens 6 Zeichen lang sein und sollte sich von Ihren Benutzernamen ein. <br><br>Ihre E-Mail-Adresse muss gültig sein. Wir verwenden E-Mail zur Kommunikation (um Benachrichtigungen, usw.). Daher ist es unerlässlich, eine gültige E-Mail-Adresse angeben zu können, unsere Dienstleistungen richtig zu verwenden. <br><br>Alle Ihre persönlichen Daten werden vertraulich behandelt. Wir werden niemals verkaufen, tauschen oder Markt in irgendeiner Weise. Für weitere Informationen über die Aufgaben der beiden Teile, können Sie auf uns verweisen.'),
(562, 'es', '_CREATING_ACCOUNT_ERROR', 'Se produjo un error al crear su cuenta! Por favor, inténtelo de nuevo más tarde o enviar información sobre este error a la administración del sitio.'),
(563, 'en', '_CREATING_ACCOUNT_ERROR', 'An error occurred while creating your account! Please try again later or send information about this error to administration of the site.'),
(564, 'de', '_CREATING_ACCOUNT_ERROR', 'Fehler beim Erstellen Ihres Kontos! Bitte versuchen Sie es später noch einmal oder senden Sie Informationen zu diesem Fehler zur Verwaltung der Website.'),
(565, 'es', '_CREATING_NEW_ACCOUNT', 'Crear cuenta nueva'),
(566, 'en', '_CREATING_NEW_ACCOUNT', 'Creating new account'),
(567, 'de', '_CREATING_NEW_ACCOUNT', 'Erstellen neues Konto'),
(568, 'es', '_CREDIT_CARD', 'Tarjeta de Crédito'),
(569, 'en', '_CREDIT_CARD', 'Credit Card'),
(570, 'de', '_CREDIT_CARD', 'Kreditkarte'),
(571, 'es', '_CREDIT_CARD_EXPIRES', 'Expira'),
(572, 'en', '_CREDIT_CARD_EXPIRES', 'Expires'),
(573, 'de', '_CREDIT_CARD_EXPIRES', 'Ablauf'),
(574, 'es', '_CREDIT_CARD_NUMBER', 'Número de tarjeta'),
(575, 'en', '_CREDIT_CARD_NUMBER', 'Credit Card Number'),
(576, 'de', '_CREDIT_CARD_NUMBER', 'Nummer der Kreditkarte'),
(577, 'es', '_CREDIT_CARD_TYPE', 'Tarjeta de Crédito'),
(578, 'en', '_CREDIT_CARD_TYPE', 'Credit Card Type'),
(579, 'de', '_CREDIT_CARD_TYPE', 'Art der Kreditkarte'),
(580, 'es', '_CRONJOB_HTACCESS_BLOCK', 'Para bloquear el acceso remoto a cron.php, en el archivo del servidor htaccess o archivo de configuración de host virtual agregar esta sección.:'),
(581, 'en', '_CRONJOB_HTACCESS_BLOCK', 'To block remote access to cron.php, in the server&#039;s .htaccess file or vhost configuration file add this section:'),
(582, 'de', '_CRONJOB_HTACCESS_BLOCK', 'So blockieren Sie den Remotezugriff auf cron.php, in der Server-htaccess-Datei oder vhost Konfigurationsdatei hinzuzufügen diesem Abschnitt.:'),
(583, 'es', '_CRONJOB_NOTICE', 'Puestos de trabajo de cron le permiten automatizar ciertos comandos o scripts en su sitio.<br /><br />ApPHP Business Directory que tenga que ejecutar periódicamente cron.php para realizar algunas operaciones importantes. La manera recomendada de ejecutar cron.php es la creación de un cronjob si ejecuta un servidor Unix/Linux. Si por alguna razón usted no puede ejecutar una tarea programada en el servidor, usted puede elegir la opción para no tener lotes a continuación ejecutar cron.php por ApPHP Business Directory en sí: en este caso cron.php se ejecuta cada vez que alguien de su acceso página de inicio. <br /><br />Ejemplo de comando de proceso por lotes Cron: <b>php &#36;HOME/public_html/cron.php >/dev/null 2>&1</b>'),
(584, 'en', '_CRONJOB_NOTICE', 'Cron jobs allow you to automate certain commands or scripts on your site.<br /><br />ApPHP Business Directory may need to periodically run cron.php to perform some important operations. The recommended way to run cron.php is to set up a cronjob if you run a Unix/Linux server. If for any reason you can&#039;t run a cronjob on your server, you can choose the Non-batch option below to have cron.php run by ApPHP Business Directory itself: in this case cron.php will be run each time someone access your home page. <br /><br />Example of Batch Cron job command: <b>php &#36;HOME/public_html/cron.php >/dev/null 2>&1</b>'),
(585, 'de', '_CRONJOB_NOTICE', 'Cron-Jobs können Sie bestimmte Befehle oder Skripte auf Ihrer Website zu automatisieren.<br /><br />ApPHP Business Directory müssen regelmäßig ausgeführt cron.php einige wichtige Operationen durchführen. Die empfohlene Methode, cron.php ausgeführt wird, ein Cronjob, wenn Sie eine Unix / Linux-Server laufen. Wenn Sie aus irgendeinem Grund nicht ausführen können einen Cronjob auf Ihrem Server, können Sie die Non-Batch-Option aus, um cron.php laufen durch ApPHP Business Directory selbst haben: in diesem Fall cron.php wird jedes Mal jemand Zugriff ausgeführt werden Ihre Home Page. <br /> <br /> Beispiel Batch Cron-Job Befehl: <b>php &#36;HOME/public_html/cron.php >/dev/null 2>&1</b>'),
(586, 'es', '_CRON_JOBS', 'Cron Jobs'),
(587, 'en', '_CRON_JOBS', 'Cron Jobs'),
(588, 'de', '_CRON_JOBS', 'Cron Jobs'),
(589, 'es', '_CURRENCIES', 'Monedas'),
(590, 'en', '_CURRENCIES', 'Currencies'),
(591, 'de', '_CURRENCIES', 'Währungen'),
(592, 'es', '_CURRENCIES_DEFAULT_ALERT', '¡Recuerde! Después de cambiar la moneda por defecto: <br> - Editar tipo de cambio de cada moneda de forma manual (relativamente a la moneda por defecto nuevo) <br> - Redefinir los precios de todas las habitaciones en la nueva moneda.'),
(593, 'en', '_CURRENCIES_DEFAULT_ALERT', 'Remember! After you change the default currency:<br>- Edit exchange rate to each currency manually (relatively to the new default currency)<br>- Redefine prices for all rooms in the new currency.'),
(594, 'de', '_CURRENCIES_DEFAULT_ALERT', 'Denken Sie daran! Nachdem Sie die Standardwährung: <br> - Edit Wechselkurs jeder Währung manuell (relativ zum neuen Standard-Währung) <br> - Definieren Sie die Preise für alle Zimmer in der neuen Währung.'),
(595, 'es', '_CURRENCIES_MANAGEMENT', 'Monedas de Gestión'),
(596, 'en', '_CURRENCIES_MANAGEMENT', 'Currencies Management'),
(597, 'de', '_CURRENCIES_MANAGEMENT', 'Währungen Management'),
(598, 'es', '_CURRENCY', 'Moneda'),
(599, 'en', '_CURRENCY', 'Currency'),
(600, 'de', '_CURRENCY', 'Währung'),
(601, 'es', '_CUSTOMER', 'Cliente'),
(602, 'en', '_CUSTOMER', 'Customer'),
(603, 'de', '_CUSTOMER', 'Kunde'),
(604, 'es', '_CUSTOMERS', 'Clientes'),
(605, 'en', '_CUSTOMERS', 'Customers'),
(606, 'de', '_CUSTOMERS', 'Kunden'),
(607, 'es', '_CUSTOMERS_MANAGEMENT', 'Gestión de Clientes'),
(608, 'en', '_CUSTOMERS_MANAGEMENT', 'Customers Management'),
(609, 'de', '_CUSTOMERS_MANAGEMENT', 'Kunden-Management'),
(610, 'es', '_CUSTOMERS_SETTINGS', 'Configuración de los clientes de'),
(611, 'en', '_CUSTOMERS_SETTINGS', 'Customers Settings'),
(612, 'de', '_CUSTOMERS_SETTINGS', 'Kunden Können'),
(613, 'es', '_CUSTOMER_DETAILS', 'Detalles del cliente'),
(614, 'en', '_CUSTOMER_DETAILS', 'Customer Details'),
(615, 'de', '_CUSTOMER_DETAILS', 'Kundendaten'),
(616, 'es', '_CUSTOMER_GROUP', 'Grupo de clientes'),
(617, 'en', '_CUSTOMER_GROUP', 'Customer Group'),
(618, 'de', '_CUSTOMER_GROUP', 'Customer Group'),
(619, 'es', '_CUSTOMER_GROUPS', 'Grupos de clientes'),
(620, 'en', '_CUSTOMER_GROUPS', 'Customer Groups'),
(621, 'de', '_CUSTOMER_GROUPS', 'Kundengruppen'),
(622, 'es', '_CUSTOMER_LOGIN', 'Login Cliente'),
(623, 'en', '_CUSTOMER_LOGIN', 'Customer Login'),
(624, 'de', '_CUSTOMER_LOGIN', 'Kunden-Login'),
(625, 'es', '_CVV_CODE', 'CVV Código'),
(626, 'en', '_CVV_CODE', 'CVV Code'),
(627, 'de', '_CVV_CODE', 'CVV-Code'),
(628, 'es', '_DASHBOARD', 'Salpicadero'),
(629, 'en', '_DASHBOARD', 'Dashboard'),
(630, 'de', '_DASHBOARD', 'Armaturenbrett'),
(631, 'es', '_DATE', 'Fecha'),
(632, 'en', '_DATE', 'Date'),
(633, 'de', '_DATE', 'Datum'),
(634, 'es', '_DATETIME_PRICE_FORMAT', 'Fecha y hora y Configuración de Precio'),
(635, 'en', '_DATETIME_PRICE_FORMAT', 'Datetime & Price Settings'),
(636, 'de', '_DATETIME_PRICE_FORMAT', 'Datetime & Preis-Einstellungen'),
(637, 'es', '_DATE_AND_TIME_SETTINGS', 'De fecha y hora'),
(638, 'en', '_DATE_AND_TIME_SETTINGS', 'Date & Time Settings'),
(639, 'de', '_DATE_AND_TIME_SETTINGS', 'Datum & Zeit-Einstellungen'),
(640, 'es', '_DATE_CREATED', 'Fecha de creación'),
(641, 'en', '_DATE_CREATED', 'Date Created'),
(642, 'de', '_DATE_CREATED', 'Erstellungsdatum');
INSERT INTO `<DB_PREFIX>vocabulary` (`id`, `language_id`, `key_value`, `key_text`) VALUES
(643, 'es', '_DATE_FORMAT', 'Formato de fecha'),
(644, 'en', '_DATE_FORMAT', 'Date Format'),
(645, 'de', '_DATE_FORMAT', 'Datumsformat'),
(646, 'es', '_DATE_MODIFIED', 'Fecha de modificación'),
(647, 'en', '_DATE_MODIFIED', 'Date Modified'),
(648, 'de', '_DATE_MODIFIED', 'Änderungsdatum'),
(649, 'es', '_DATE_PUBLISHED', 'Fecha de publicación'),
(650, 'en', '_DATE_PUBLISHED', 'Date Published'),
(651, 'de', '_DATE_PUBLISHED', 'Veröffentlichungsdatum'),
(652, 'es', '_DATE_SUBSCRIBED', 'Fecha de suscripción'),
(653, 'en', '_DATE_SUBSCRIBED', 'Date Subscribed'),
(654, 'de', '_DATE_SUBSCRIBED', 'Datum Gezeichnetes'),
(655, 'es', '_DAY', 'Día'),
(656, 'en', '_DAY', 'Day'),
(657, 'de', '_DAY', 'Tag'),
(658, 'es', '_DAYS', 'Día'),
(659, 'en', '_DAYS', 'Days'),
(660, 'de', '_DAYS', 'Tag'),
(661, 'es', '_DECEMBER', 'Diciembre'),
(662, 'en', '_DECEMBER', 'December'),
(663, 'de', '_DECEMBER', 'Dezember'),
(664, 'es', '_DEFAULT', 'Predeterminado'),
(665, 'en', '_DEFAULT', 'Default'),
(666, 'de', '_DEFAULT', 'Standardmäßig'),
(667, 'es', '_DEFAULT_EMAIL_ALERT', 'Tienes que cambiar la dirección de correo electrónico predeterminado para el administrador. Haga clic <a href=''index.php?admin=settings&tabid=1_4''>aquí</a> para continuar.'),
(668, 'en', '_DEFAULT_EMAIL_ALERT', 'You have to change default email address for site administrator. Click <a href=''index.php?admin=settings&tabid=1_4''>here</a> to proceed.'),
(669, 'de', '_DEFAULT_EMAIL_ALERT', 'Sie haben zum ursprünglichen E-Mail-Adresse für den Administrator ändern. Klicken Sie <a href=''index.php?admin=settings&tabid=1_4''>hier</a>, um fortzufahren.'),
(670, 'es', '_DEFAULT_OWN_EMAIL_ALERT', 'Usted tiene que cambiar su dirección de correo electrónico propia. Haga clic <a href=''index.php?admin=my_account''>aquí</a> para continuar.'),
(671, 'en', '_DEFAULT_OWN_EMAIL_ALERT', 'You have to change your own email address. Click <a href=''index.php?admin=my_account''>here</a> to proceed.'),
(672, 'de', '_DEFAULT_OWN_EMAIL_ALERT', 'Sie müssen Ihre eigene E-Mail-Adresse ändern. Klicken Sie <a href=''index.php?admin=my_account''>hier</a>, um fortzufahren.'),
(673, 'es', '_DEFAULT_TEMPLATE', 'Plantilla predeterminada'),
(674, 'en', '_DEFAULT_TEMPLATE', 'Default Template'),
(675, 'de', '_DEFAULT_TEMPLATE', 'Standardvorlage'),
(676, 'es', '_DELETE_WARNING_COMMON', '¿Estás seguro de que desea eliminar este registro?'),
(677, 'en', '_DELETE_WARNING_COMMON', 'Are you sure you want to delete this record?'),
(678, 'de', '_DELETE_WARNING_COMMON', 'Sie sind sicher, dass Sie diesen Datensatz wirklich löschen?'),
(679, 'es', '_DELETE_WORD', 'Borrar'),
(680, 'en', '_DELETE_WORD', 'Delete'),
(681, 'de', '_DELETE_WORD', 'Löschen'),
(682, 'es', '_DELETING_ACCOUNT_ERROR', 'Se produjo un error al eliminar su cuenta! Por favor, inténtelo de nuevo más tarde o envíe un correo electrónico acerca de este problema a la administración del sitio.'),
(683, 'en', '_DELETING_ACCOUNT_ERROR', 'An error occurred while deleting your account! Please try again later or send email about this issue to administration of the site.'),
(684, 'de', '_DELETING_ACCOUNT_ERROR', 'Ein Fehler beim Löschen Sie verändern! Bitte versuchen Sie es später noch einmal oder schicken Sie zu diesem Thema zur Verwaltung der Website.'),
(685, 'es', '_DELETING_OPERATION_COMPLETED', 'Eliminación de la operación se completó con éxito!'),
(686, 'en', '_DELETING_OPERATION_COMPLETED', 'Deleting operation has been successfully completed!'),
(687, 'de', '_DELETING_OPERATION_COMPLETED', 'Löschen ist erfolgreich abgeschlossen!'),
(688, 'es', '_DESCRIPTION', 'Descripción'),
(689, 'en', '_DESCRIPTION', 'Description'),
(690, 'de', '_DESCRIPTION', 'Beschreibung'),
(691, 'es', '_DIRECTORY_STATISTICS', 'Estadísticas del directorio'),
(692, 'en', '_DIRECTORY_STATISTICS', 'Directory Statistics'),
(693, 'de', '_DIRECTORY_STATISTICS', 'Verzeichnis Statistik'),
(694, 'es', '_DISPLAY_ON', 'Pantalla en la'),
(695, 'en', '_DISPLAY_ON', 'Display on'),
(696, 'de', '_DISPLAY_ON', 'Anzeige'),
(697, 'es', '_DOWN', 'Abajo'),
(698, 'en', '_DOWN', 'Down'),
(699, 'de', '_DOWN', 'Nach unten'),
(700, 'es', '_DOWNLOAD', 'Descargar'),
(701, 'en', '_DOWNLOAD', 'Download'),
(702, 'de', '_DOWNLOAD', 'Herunterladen'),
(703, 'es', '_DURATION', 'Duración'),
(704, 'en', '_DURATION', 'Duration'),
(705, 'de', '_DURATION', 'Dauer'),
(706, 'es', '_EDIT_MENUS', 'Editar los menús'),
(707, 'en', '_EDIT_MENUS', 'Edit Menus'),
(708, 'de', '_EDIT_MENUS', 'Bearbeiten-Menüs'),
(709, 'es', '_EDIT_MY_ACCOUNT', 'Editar mi cuenta'),
(710, 'en', '_EDIT_MY_ACCOUNT', 'Edit My Account'),
(711, 'de', '_EDIT_MY_ACCOUNT', 'Mein Konto bearbeiten'),
(712, 'es', '_EDIT_PAGE', 'Editar página'),
(713, 'en', '_EDIT_PAGE', 'Edit Page'),
(714, 'de', '_EDIT_PAGE', 'Seite bearbeiten'),
(715, 'es', '_EDIT_WORD', 'Editar'),
(716, 'en', '_EDIT_WORD', 'Edit'),
(717, 'de', '_EDIT_WORD', 'Bearbeiten'),
(718, 'es', '_EMAIL', 'E-mail'),
(719, 'en', '_EMAIL', 'Email'),
(720, 'de', '_EMAIL', 'E-Mail'),
(721, 'es', '_EMAILS_SENT_ERROR', 'Se produjo un error al enviar correos electrónicos o no hay mensajes de correo electrónico para ser enviados! Por favor, inténtelo de nuevo más tarde.'),
(722, 'en', '_EMAILS_SENT_ERROR', 'An error occurred while sending emails or there are no emails to be sent! Please try again later.'),
(723, 'de', '_EMAILS_SENT_ERROR', 'Fehler beim Versenden von Emails oder es sind keine E-Mails gesendet werden! Bitte versuchen Sie es später erneut.'),
(724, 'es', '_EMAILS_SUCCESSFULLY_SENT', 'Estado: mensajes de correo electrónico _SENT_ de _TOTAL_ fueron enviados con éxito!'),
(725, 'en', '_EMAILS_SUCCESSFULLY_SENT', 'Status: _SENT_ emails from _TOTAL_ were successfully sent!'),
(726, 'de', '_EMAILS_SUCCESSFULLY_SENT', 'Status: _SENT_ E-Mails von _TOTAL_ waren erfolgreich verschickt!'),
(727, 'es', '_EMAIL_ADDRESS', 'E-mail address'),
(728, 'en', '_EMAIL_ADDRESS', 'E-mail address'),
(729, 'de', '_EMAIL_ADDRESS', 'E-Mail-Adresse'),
(730, 'es', '_EMAIL_BLOCKED', 'Tu email fue bloqueado! Para resolver este problema, póngase en contacto con el administrador del sitio.'),
(731, 'en', '_EMAIL_BLOCKED', 'Your email is blocked! To resolve this problem, please contact the site administrator.'),
(732, 'de', '_EMAIL_BLOCKED', 'Ihre E-Mail wurde gesperrt! Um dieses Problem zu beheben, kontaktieren Sie bitte den Administrator der Website.'),
(733, 'es', '_EMAIL_EMPTY_ALERT', 'El correo electrónico no puede estar vacía! Por favor, vuelva a entrar.'),
(734, 'en', '_EMAIL_EMPTY_ALERT', 'Email cannot be empty! Please re-enter.'),
(735, 'de', '_EMAIL_EMPTY_ALERT', 'E-Mail darf nicht leer sein! Bitte neu eingeben.'),
(736, 'es', '_EMAIL_FIELDS_EMPTY_ALERT', 'Asunto o el mensaje no puede estar vacío! Por favor, vuelva a entrar.'),
(737, 'en', '_EMAIL_FIELDS_EMPTY_ALERT', 'Subject or message cannot be empty! Please re-enter.'),
(738, 'de', '_EMAIL_FIELDS_EMPTY_ALERT', 'Betreff oder Nachricht kann nicht leer sein! Bitte erneut eingeben.'),
(739, 'es', '_EMAIL_FROM', 'Dirección de correo electrónico (De)'),
(740, 'en', '_EMAIL_FROM', 'Email Address (From)'),
(741, 'de', '_EMAIL_FROM', 'E-Mail Adresse (Von)'),
(742, 'es', '_EMAIL_IS_WRONG', 'Por favor, introduzca una dirección de correo electrónico válida.'),
(743, 'en', '_EMAIL_IS_WRONG', 'Please enter a valid email address.'),
(744, 'de', '_EMAIL_IS_WRONG', 'Bitte geben Sie eine gültige Email-Adresse.'),
(745, 'es', '_EMAIL_NOTIFICATION', 'Notificación de E-Mail'),
(746, 'en', '_EMAIL_NOTIFICATION', 'Email notification'),
(747, 'de', '_EMAIL_NOTIFICATION', 'Email Anmeldung'),
(748, 'es', '_EMAIL_NOT_EXISTS', 'Esta cuenta de correo electrónico no existe en el sistema! Por favor, vuelva a entrar.'),
(749, 'en', '_EMAIL_NOT_EXISTS', 'This e-mail account does not exist in the system! Please re-enter.'),
(750, 'de', '_EMAIL_NOT_EXISTS', 'Diese E-Mail-Konto nicht im System vorhanden! Bitte neu eingeben.'),
(751, 'es', '_EMAIL_SETTINGS', 'Configuración del correo electrónico'),
(752, 'en', '_EMAIL_SETTINGS', 'Email Settings'),
(753, 'de', '_EMAIL_SETTINGS', 'E-Mail-Einstellungen'),
(754, 'es', '_EMAIL_SUCCESSFULLY_SENT', 'El correo electrónico fue enviado con éxito!'),
(755, 'en', '_EMAIL_SUCCESSFULLY_SENT', 'Email has been successfully sent!'),
(756, 'de', '_EMAIL_SUCCESSFULLY_SENT', 'E-Mail wurde erfolgreich gesendet!'),
(757, 'es', '_EMAIL_TEMPLATES', 'Plantillas de correo'),
(758, 'en', '_EMAIL_TEMPLATES', 'Email Templates'),
(759, 'de', '_EMAIL_TEMPLATES', 'E-Mail-Vorlagen'),
(760, 'es', '_EMAIL_TO', 'Correo electrónico (Para)'),
(761, 'en', '_EMAIL_TO', 'Email Address (To)'),
(762, 'de', '_EMAIL_TO', 'E-Mail Adresse (To)'),
(763, 'es', '_EMAIL_VALID_ALERT', 'Por favor, introduzca una dirección válida de correo electrónico!'),
(764, 'en', '_EMAIL_VALID_ALERT', 'Please enter a valid email address!'),
(765, 'de', '_EMAIL_VALID_ALERT', 'Bitte geben Sie eine gültige E-Mail Adresse!'),
(766, 'es', '_EMPTY', 'Vaciar'),
(767, 'en', '_EMPTY', 'Empty'),
(768, 'de', '_EMPTY', 'Leere'),
(769, 'es', '_ENTER_CONFIRMATION_CODE', 'Ingrese el código de confirmación'),
(770, 'en', '_ENTER_CONFIRMATION_CODE', 'Enter Confirmation Code'),
(771, 'de', '_ENTER_CONFIRMATION_CODE', 'Geben Sie Bestätigungs-Code'),
(772, 'es', '_ENTER_EMAIL_ADDRESS', '(Por favor, introduzca <i>sólo real</i> dirección de correo electrónico)'),
(773, 'en', '_ENTER_EMAIL_ADDRESS', '(Please enter <i>ONLY real</i> email address)'),
(774, 'de', '_ENTER_EMAIL_ADDRESS', '(Bitte geben Sie <i>nur echte</i> E-Mail-Adresse)'),
(775, 'es', '_EVENTS', 'Eventos'),
(776, 'en', '_EVENTS', 'Events'),
(777, 'de', '_EVENTS', 'Veranstaltungen'),
(778, 'es', '_EVENT_REGISTRATION_COMPLETED', 'Gracias por tu interés! Usted acaba de éxito registrado para este evento.'),
(779, 'en', '_EVENT_REGISTRATION_COMPLETED', 'Thank you for your interest! You have just successfully registered to this event.'),
(780, 'de', '_EVENT_REGISTRATION_COMPLETED', 'Vielen Dank für Ihr Interesse! Sie haben gerade erfolgreich auf dieses Ereignis registriert.'),
(781, 'es', '_EVENT_USER_ALREADY_REGISTERED', 'Miembro con el correo electrónico como ya estaba registrado a este evento! Por favor, vuelva a introducir.'),
(782, 'en', '_EVENT_USER_ALREADY_REGISTERED', 'Member with such email is already registered to this event! Please re-enter.'),
(783, 'de', '_EVENT_USER_ALREADY_REGISTERED', 'Mitglied mit solchen E-Mail wurde bereits auf dieses Ereignis registriert! Bitte erneut eingeben.'),
(784, 'es', '_EXPAND_PANEL', 'Ampliar el panel de navegación'),
(785, 'en', '_EXPAND_PANEL', 'Expand navigation panel'),
(786, 'de', '_EXPAND_PANEL', 'Erweitern Navigationsleiste'),
(787, 'es', '_EXPIRED', 'Caducado'),
(788, 'en', '_EXPIRED', 'Expired'),
(789, 'de', '_EXPIRED', 'Abgelaufen'),
(790, 'es', '_EXPIRES', 'Expira'),
(791, 'en', '_EXPIRES', 'Expires'),
(792, 'de', '_EXPIRES', 'Ablauf'),
(793, 'es', '_EXPORT', 'Exportación'),
(794, 'en', '_EXPORT', 'Export'),
(795, 'de', '_EXPORT', 'Export'),
(796, 'es', '_FAQ', 'Preguntas frecuentes'),
(797, 'en', '_FAQ', 'FAQ'),
(798, 'de', '_FAQ', 'Häufig gestellte Fragen'),
(799, 'es', '_FAQ_MANAGEMENT', 'Preguntas de Gestión'),
(800, 'en', '_FAQ_MANAGEMENT', 'FAQ Management'),
(801, 'de', '_FAQ_MANAGEMENT', 'FAQ-Management'),
(802, 'es', '_FAQ_SETTINGS', 'Configuración del FAQ'),
(803, 'en', '_FAQ_SETTINGS', 'FAQ Settings'),
(804, 'de', '_FAQ_SETTINGS', 'FAQ Einstellungen'),
(805, 'es', '_FAX', 'Fax'),
(806, 'en', '_FAX', 'Fax'),
(807, 'de', '_FAX', 'Fax'),
(808, 'es', '_FEATURED', 'Destacados'),
(809, 'en', '_FEATURED', 'Featured'),
(810, 'de', '_FEATURED', 'Vorgestellten'),
(811, 'es', '_FEATURED_LISTINGS', 'Listados Destacados'),
(812, 'en', '_FEATURED_LISTINGS', 'Featured Listings'),
(813, 'de', '_FEATURED_LISTINGS', 'Featured Listings'),
(814, 'es', '_FEBRUARY', 'Febrero'),
(815, 'en', '_FEBRUARY', 'February'),
(816, 'de', '_FEBRUARY', 'Februar'),
(817, 'es', '_FIELD_CANNOT_BE_EMPTY', 'Campo _FIELD_ no puede estar vacía! Por favor, vuelva a entrar.'),
(818, 'en', '_FIELD_CANNOT_BE_EMPTY', 'Field _FIELD_ cannot be empty! Please re-enter.'),
(819, 'de', '_FIELD_CANNOT_BE_EMPTY', 'Feld _FIELD_ darf nicht leer sein! Bitte neu eingeben.'),
(820, 'es', '_FIELD_LENGTH_ALERT', 'La longitud de la _FIELD_ campo debe ser inferior a _LENGTH_ personajes! Por favor, vuelva a entrar.'),
(821, 'en', '_FIELD_LENGTH_ALERT', 'The length of the field _FIELD_ must be less than _LENGTH_ characters! Please re-enter.'),
(822, 'de', '_FIELD_LENGTH_ALERT', 'Die länge des feldes _FIELD_ muss kleiner sein als _LENGTH_ zeichen! Bitte erneut eingeben.'),
(823, 'es', '_FIELD_LENGTH_EXCEEDED', '_FIELD_ ha superado el tamaño máximo permitido: _LENGTH_ personajes! Por favor, vuelva a entrar.'),
(824, 'en', '_FIELD_LENGTH_EXCEEDED', '_FIELD_ has exceeded the maximum allowed size: _LENGTH_ characters! Please re-enter.'),
(825, 'de', '_FIELD_LENGTH_EXCEEDED', '_LENGTH_ Zeichen: _FIELD_ hat die maximal zulässige Größe überschritten! Bitte erneut eingeben.'),
(826, 'es', '_FIELD_MIN_LENGTH_ALERT', 'La longitud de la _FIELD_ campo no puede ser inferior a _LENGTH_ personajes! Por favor, vuelva a entrar.'),
(827, 'en', '_FIELD_MIN_LENGTH_ALERT', 'The length of the field _FIELD_ cannot  be less than _LENGTH_ characters! Please re-enter.'),
(828, 'de', '_FIELD_MIN_LENGTH_ALERT', 'Die Länge des Feldes _FIELD_ kann nicht kleiner sein als _LENGTH_ Zeichen! Bitte erneut eingeben.'),
(829, 'es', '_FIELD_MUST_BE_ALPHA', 'Valor _FIELD_ debe ser alfabético! Por favor, vuelva a entrar.'),
(830, 'en', '_FIELD_MUST_BE_ALPHA', '_FIELD_ must be an alphabetic value! Please re-enter.'),
(831, 'de', '_FIELD_MUST_BE_ALPHA', '_FIELD_ muss alphabetische wert sein! Bitte erneut eingeben.'),
(832, 'es', '_FIELD_MUST_BE_ALPHA_NUMERIC', 'Valor _FIELD_ debe ser alfanumérico! Por favor, vuelva a entrar.'),
(833, 'en', '_FIELD_MUST_BE_ALPHA_NUMERIC', '_FIELD_ must be an alphanumeric value! Please re-enter.'),
(834, 'de', '_FIELD_MUST_BE_ALPHA_NUMERIC', '_FIELD_ muss alphanumerischen wert sein! Bitte erneut eingeben.'),
(835, 'es', '_FIELD_MUST_BE_BOOLEAN', 'Campo de valor _FIELD_ debe ser ''yes'' o ''no''! Por favor, vuelva a entrar.'),
(836, 'en', '_FIELD_MUST_BE_BOOLEAN', 'Field _FIELD_ value must be ''yes'' or ''no''! Please re-enter.'),
(837, 'de', '_FIELD_MUST_BE_BOOLEAN', 'Field _FIELD_ wert muss ''Ja'' oder ''Nein''! Bitte erneut eingeben.'),
(838, 'es', '_FIELD_MUST_BE_DATE', '_FIELD_ debe estar en formato de fecha válido! Por favor, vuelva a entrar.'),
(839, 'en', '_FIELD_MUST_BE_DATE', '_FIELD_ must be in valid date format! Please re-enter.'),
(840, 'de', '_FIELD_MUST_BE_DATE', '_FIELD_ müssen in gültigen Datum-Format! Bitte erneut eingeben.'),
(841, 'es', '_FIELD_MUST_BE_EMAIL', '_FIELD_ debe estar en formato de correo electrónico válida! Por favor, vuelva a entrar.'),
(842, 'en', '_FIELD_MUST_BE_EMAIL', '_FIELD_ must be in valid email format! Please re-enter.'),
(843, 'de', '_FIELD_MUST_BE_EMAIL', '_FIELD_ müssen gültige E-Mail-Format sein! Bitte erneut eingeben.'),
(844, 'es', '_FIELD_MUST_BE_FLOAT', 'Campo _FIELD_ debe ser el valor flotante número! Por favor, vuelva a entrar.'),
(845, 'en', '_FIELD_MUST_BE_FLOAT', 'Field _FIELD_ must be a float number value! Please re-enter.'),
(846, 'de', '_FIELD_MUST_BE_FLOAT', 'Field _FIELD_ muss floatzahl wert! Bitte erneut eingeben.'),
(847, 'es', '_FIELD_MUST_BE_FLOAT_POSITIVE', 'Campo _FIELD_ debe ser un valor positivo número flotan! Por favor, vuelva a entrar.'),
(848, 'en', '_FIELD_MUST_BE_FLOAT_POSITIVE', 'Field _FIELD_ must be a positive float number value! Please re-enter.'),
(849, 'de', '_FIELD_MUST_BE_FLOAT_POSITIVE', 'Field _FIELD_ müssen positive fließkommazahl wert sein! Bitte erneut eingeben.'),
(850, 'es', '_FIELD_MUST_BE_INT', '_FIELD_ Campo debe ser un valor entero! Por favor, vuelva a entrar.'),
(851, 'en', '_FIELD_MUST_BE_INT', 'Field _FIELD_ must be an integer value! Please re-enter.'),
(852, 'de', '_FIELD_MUST_BE_INT', 'Feld _FIELD_ muss ein ganzzahliger Wert sein! Bitte erneut eingeben.'),
(853, 'es', '_FIELD_MUST_BE_IP_ADDRESS', '_FIELD_ Debe ser una dirección IP válida! Por favor, vuelva a entrar.'),
(854, 'en', '_FIELD_MUST_BE_IP_ADDRESS', '_FIELD_ must be a valid IP Address! Please re-enter.'),
(855, 'de', '_FIELD_MUST_BE_IP_ADDRESS', '_FIELD_ muss eine gültige IP-Adresse! Bitte erneut eingeben.'),
(856, 'es', '_FIELD_MUST_BE_NUMERIC', 'Campo _FIELD_ valor debe ser numérico! Por favor, vuelva a entrar.'),
(857, 'en', '_FIELD_MUST_BE_NUMERIC', 'Field _FIELD_ must be a numeric value! Please re-enter.'),
(858, 'de', '_FIELD_MUST_BE_NUMERIC', 'Field _FIELD_ muss numerischer Wert sein! Bitte erneut eingeben.'),
(859, 'es', '_FIELD_MUST_BE_NUMERIC_POSITIVE', 'Campo _FIELD_ debe ser el valor numérico positivo! Por favor, vuelva a entrar.'),
(860, 'en', '_FIELD_MUST_BE_NUMERIC_POSITIVE', 'Field _FIELD_ must be a positive numeric value! Please re-enter.'),
(861, 'de', '_FIELD_MUST_BE_NUMERIC_POSITIVE', 'Field _FIELD_ müssen positive numerischer wert sein! Bitte erneut eingeben.'),
(862, 'es', '_FIELD_MUST_BE_PASSWORD', '_FIELD_ Debe ser de 6 caracteres como mínimo y se componen de letras y dígitos! Por favor, vuelva a entrar.'),
(863, 'en', '_FIELD_MUST_BE_PASSWORD', '_FIELD_ must be 6 characters at least and consist of letters and digits! Please re-enter.'),
(864, 'de', '_FIELD_MUST_BE_PASSWORD', '_FIELD_ muss 6 zeichen lang sein und mindestens bestehen aus buchstaben und ziffern! Bitte erneut eingeben.'),
(865, 'es', '_FIELD_MUST_BE_POSITIVE_INT', 'Campo _FIELD_ debe ser un valor entero positivo! Por favor, vuelva a entrar.'),
(866, 'en', '_FIELD_MUST_BE_POSITIVE_INT', 'Field _FIELD_ must be a positive integer value! Please re-enter.'),
(867, 'de', '_FIELD_MUST_BE_POSITIVE_INT', 'Field _FIELD_ müssen positive ganze zahl sein! Bitte erneut eingeben.'),
(868, 'es', '_FIELD_MUST_BE_SIZE_VALUE', '_FIELD_ Campo debe ser una propiedad válida tamaño HTML en ''px'', ''pt'', ''em'' o ''%'' unidades! Por favor, vuelva a introducir.'),
(869, 'en', '_FIELD_MUST_BE_SIZE_VALUE', 'Field _FIELD_ must be a valid HTML size property in ''px'', ''pt'', ''em'' or ''%'' units! Please re-enter.'),
(870, 'de', '_FIELD_MUST_BE_SIZE_VALUE', 'Feld _FIELD_ muss ein gültiger HTML size-Eigenschaft in ''px'', ''pt'', ''em'' oder ''%'' -Einheiten werden! Bitte erneut eingeben.'),
(871, 'es', '_FIELD_MUST_BE_TEXT', '_FIELD_ Valor debe ser un texto! Por favor, vuelva a entrar.'),
(872, 'en', '_FIELD_MUST_BE_TEXT', '_FIELD_ value must be a text! Please re-enter.'),
(873, 'de', '_FIELD_MUST_BE_TEXT', '_FIELD_ wert muss ein text sein! Bitte erneut eingeben.'),
(874, 'es', '_FIELD_MUST_BE_UNSIGNED_FLOAT', 'Campo _FIELD_ debe ser valor flotante sin firmar! Por favor, vuelva a entrar.'),
(875, 'en', '_FIELD_MUST_BE_UNSIGNED_FLOAT', 'Field _FIELD_ must be an unsigned float value! Please re-enter.'),
(876, 'de', '_FIELD_MUST_BE_UNSIGNED_FLOAT', 'Field _FIELD_ muss unsigned Float-Wert sein! Bitte erneut eingeben.'),
(877, 'es', '_FIELD_MUST_BE_UNSIGNED_INT', '_FIELD_ Campo debe ser un valor entero sin signo! Por favor, vuelva a entrar.'),
(878, 'en', '_FIELD_MUST_BE_UNSIGNED_INT', 'Field _FIELD_ must be an unsigned integer value! Please re-enter.'),
(879, 'de', '_FIELD_MUST_BE_UNSIGNED_INT', 'Feld _FIELD_ muss unsigned Integer-Wert sein! Bitte erneut eingeben.'),
(880, 'es', '_FIELD_VALUE_MINIMUM', '_FIELD_ valor no debe ser inferior a _MIN_! Por favor, vuelva a entrar.'),
(881, 'en', '_FIELD_VALUE_MINIMUM', '_FIELD_ value should not be less then _MIN_! Please re-enter.'),
(882, 'de', '_FIELD_VALUE_MINIMUM', '_FIELD_ Wert sollte nicht weniger als _MIN_! Bitte erneut eingeben.'),
(883, 'es', '_FILED_UNIQUE_VALUE_ALERT', 'El _FIELD_ campo sólo acepta valores únicos - por favor vuelva a entrar!'),
(884, 'en', '_FILED_UNIQUE_VALUE_ALERT', 'The field _FIELD_ accepts only unique values - please re-enter!'),
(885, 'de', '_FILED_UNIQUE_VALUE_ALERT', 'Das feld _FIELD_ akzeptiert nur eindeutige werte - bitte erneut eingeben!'),
(886, 'es', '_FILE_DELETING_ERROR', 'Se produjo un error al eliminar el archivo! Por favor, inténtelo de nuevo más tarde.'),
(887, 'en', '_FILE_DELETING_ERROR', 'An error occurred while deleting file! Please try again later.'),
(888, 'de', '_FILE_DELETING_ERROR', 'Fehler beim löschen der datei! Bitte versuchen sie es später erneut.'),
(889, 'es', '_FILTER_BY', 'Filtrar por'),
(890, 'en', '_FILTER_BY', 'Filter by'),
(891, 'de', '_FILTER_BY', 'Filtern nach'),
(892, 'es', '_FINISH_PUBLISHING', 'Finalizar publicación'),
(893, 'en', '_FINISH_PUBLISHING', 'Finish Publishing'),
(894, 'de', '_FINISH_PUBLISHING', 'Finish Publishing'),
(895, 'es', '_FIRST_NAME', 'Nombre'),
(896, 'en', '_FIRST_NAME', 'First Name'),
(897, 'de', '_FIRST_NAME', 'Vorname'),
(898, 'es', '_FIRST_NAME_EMPTY_ALERT', 'Nombre no puede estar vacío! Por favor, vuelva a entrar.'),
(899, 'en', '_FIRST_NAME_EMPTY_ALERT', 'First Name cannot be empty! Please re-enter.'),
(900, 'de', '_FIRST_NAME_EMPTY_ALERT', 'Vorname darf nicht leer sein! Bitte erneut eingeben.'),
(901, 'es', '_FOOTER_IS_EMPTY', 'Pie de página no puede estar vacía! Por favor, vuelva a entrar.'),
(902, 'en', '_FOOTER_IS_EMPTY', 'Footer cannot be empty! Please re-enter.'),
(903, 'de', '_FOOTER_IS_EMPTY', 'Footer darf nicht leer sein! Bitte erneut eingeben.'),
(904, 'es', '_FORGOT_PASSWORD', '¿Has olvidado tu contraseña'),
(905, 'en', '_FORGOT_PASSWORD', 'Forgot your password?'),
(906, 'de', '_FORGOT_PASSWORD', 'Passwort vergessen?'),
(907, 'es', '_FORM', 'Forma'),
(908, 'en', '_FORM', 'Form'),
(909, 'de', '_FORM', 'Formular'),
(910, 'es', '_FRIDAY', 'viernes'),
(911, 'en', '_FRIDAY', 'Friday'),
(912, 'de', '_FRIDAY', 'Freitag'),
(913, 'es', '_GALLERY', 'Galería'),
(914, 'en', '_GALLERY', 'Gallery'),
(915, 'de', '_GALLERY', 'Galerie'),
(916, 'es', '_GALLERY_MANAGEMENT', 'Galería de Gestión'),
(917, 'en', '_GALLERY_MANAGEMENT', 'Gallery Management'),
(918, 'de', '_GALLERY_MANAGEMENT', 'Galerie Verwaltung'),
(919, 'es', '_GALLERY_SETTINGS', 'Configuración de la Galería'),
(920, 'en', '_GALLERY_SETTINGS', 'Gallery Settings'),
(921, 'de', '_GALLERY_SETTINGS', 'Galerie-Einstellungen'),
(922, 'es', '_GENERAL', 'General'),
(923, 'en', '_GENERAL', 'General'),
(924, 'de', '_GENERAL', 'Generell'),
(925, 'es', '_GENERAL_INFO', 'Información General'),
(926, 'en', '_GENERAL_INFO', 'General Info'),
(927, 'de', '_GENERAL_INFO', 'Allgemeine Infos'),
(928, 'es', '_GENERAL_SETTINGS', 'Configuración general'),
(929, 'en', '_GENERAL_SETTINGS', 'General Settings'),
(930, 'de', '_GENERAL_SETTINGS', 'Allgemeine Einstellungen'),
(931, 'es', '_GLOBAL', 'Mundial'),
(932, 'en', '_GLOBAL', 'Global'),
(933, 'de', '_GLOBAL', 'Global'),
(934, 'es', '_GO', 'Ir'),
(935, 'en', '_GO', 'Go'),
(936, 'de', '_GO', 'Gehen'),
(937, 'es', '_GRAY', 'Gray'),
(938, 'en', '_GRAY', 'Gray'),
(939, 'de', '_GRAY', 'Grau'),
(940, 'es', '_GREEN', 'Verde'),
(941, 'en', '_GREEN', 'Green'),
(942, 'de', '_GREEN', 'Grün'),
(943, 'es', '_GROUP', 'Grupo'),
(944, 'en', '_GROUP', 'Group'),
(945, 'de', '_GROUP', 'Gruppe'),
(946, 'es', '_GROUP_NAME', 'Nombre del grupo'),
(947, 'en', '_GROUP_NAME', 'Group Name'),
(948, 'de', '_GROUP_NAME', 'Name der Gruppe'),
(949, 'es', '_HDR_FOOTER_TEXT', 'Pie de página de texto'),
(950, 'en', '_HDR_FOOTER_TEXT', 'Footer Text'),
(951, 'de', '_HDR_FOOTER_TEXT', 'Fußzeilentext'),
(952, 'es', '_HDR_HEADER_TEXT', 'Texto de la cabecera'),
(953, 'en', '_HDR_HEADER_TEXT', 'Header Text'),
(954, 'de', '_HDR_HEADER_TEXT', 'Kopftext'),
(955, 'es', '_HDR_SLOGAN_TEXT', 'Eslogan'),
(956, 'en', '_HDR_SLOGAN_TEXT', 'Slogan'),
(957, 'de', '_HDR_SLOGAN_TEXT', 'Slogan'),
(958, 'es', '_HDR_TEMPLATE', 'Plantilla'),
(959, 'en', '_HDR_TEMPLATE', 'Template'),
(960, 'de', '_HDR_TEMPLATE', 'Vorlage'),
(961, 'es', '_HDR_TEXT_DIRECTION', 'Dirección del texto'),
(962, 'en', '_HDR_TEXT_DIRECTION', 'Text Direction'),
(963, 'de', '_HDR_TEXT_DIRECTION', 'Textrichtung'),
(964, 'es', '_HEADER', 'Encabezado'),
(965, 'en', '_HEADER', 'Header'),
(966, 'de', '_HEADER', 'Kopfzeile'),
(967, 'es', '_HEADERS_AND_FOOTERS', 'Encabezados y pies de página'),
(968, 'en', '_HEADERS_AND_FOOTERS', 'Headers & Footers'),
(969, 'de', '_HEADERS_AND_FOOTERS', 'Kopf-und Fußzeilen'),
(970, 'es', '_HEADER_IS_EMPTY', 'Encabezado no puede estar vacía! Por favor, vuelva a entrar.'),
(971, 'en', '_HEADER_IS_EMPTY', 'Header cannot be empty! Please re-enter.'),
(972, 'de', '_HEADER_IS_EMPTY', 'Header können nicht leer sein! Bitte erneut eingeben.'),
(973, 'es', '_HIDE', 'Ocultar'),
(974, 'en', '_HIDE', 'Hide'),
(975, 'de', '_HIDE', 'Verbergen'),
(976, 'es', '_HOME', 'Inicio'),
(977, 'en', '_HOME', 'Home'),
(978, 'de', '_HOME', 'Startseite'),
(979, 'es', '_HOME_PAGE_WELCOME_TEXT', '<p>Bienvenido al Administrador del panel de control que le permite agregar, editar o eliminar contenido del sitio. Con este Panel de Control del Administrador usted puede fácilmente administrar los usuarios, los pedidos y realizar una gestión completa del sitio.</p>\r\n<p><b>•</b> Hay algunos módulos para usted: Copia de seguridad y restauración, Noticias. La instalación o desinstalación de ellos es posible a partir de <a href=''index.php?admin=modules''>módulos de menú</a>.</p>\r\n<p><b>•</b> En <a href=''index.php?admin=languages''>Idiomas del menú</a> puede agregar o quitar idioma o cambiar la configuración de idioma y modificar su vocabulario (las palabras y frases utilizadas por el sistema).</p>\r\n<p><b>•</b> <a href=''index.php?admin=settings''>Configuración del menú</a> le permite definir opciones importantes para el sitio.</p>\r\n<p><b>•</b> En <a href=''index.php?admin=my_account''>Mi Cuenta</a> existe la posibilidad de cambiar su información.</p>\r\n<p><b>•</b> <a href=''index.php?admin=menus''>Los menús</a> y la <a href=''index.php?admin=pages''>gestión de páginas</a> están diseñadas para crear y manejar los menús, enlaces y páginas.</p>\r\n<p><b>•</b> <a href=''index.php?admin=mass_mail''>Correo electrónico masivo</a> característica le permite enviar correos electrónicos a los usuarios o administradores del Panel de Administración.</p>'),
(980, 'en', '_HOME_PAGE_WELCOME_TEXT', '<p>Welcome to Administrator Control Panel that allows you add, edit or delete site content. With this Administrator Control Panel you can easy manage users, orders and perform a full site management.</p>\r\n<p><b>•</b> There are some modules for you: Backup & Restore, News. Installation or un-installation of them is possible from <a href=''index.php?admin=modules''>Modules Menu</a>.</p>\r\n<p><b>•</b> In <a href=''index.php?admin=languages''>Languages Menu</a> you may add/remove language or change language settings and edit your vocabulary (the words and phrases, used by the system).</p>\r\n<p><b>•</b> <a href=''index.php?admin=settings''>Settings Menu</a> allows you to define important settings for the site.</p>\r\n<p><b>•</b> In <a href=''index.php?admin=my_account''>My Account</a> there is a possibility to change your info.</p>\r\n<p><b>•</b> <a href=''index.php?admin=menus''>Menus</a> and <a href=''index.php?admin=pages''>Pages Management</a> are designed for creating and managing menus, links and pages.</p>\r\n<p><b>•</b> <a href=''index.php?admin=mass_mail''>Mass Email</a> feature allows you to send emails to your users or admins from Admin Panel.</p>'),
(981, 'de', '_HOME_PAGE_WELCOME_TEXT', '<p>Willkommen auf dem Administrator Control Panel, mit dem Sie hinzufügen, bearbeiten oder löschen Website-Content. Mit dieser Administrator Control Panel können Sie einfach verwalten Benutzer, Aufträge und führen Sie eine vollständige Bauleitung.</p>\r\n<p><b>•</b> Es gibt einige Module für Sie: Backup &amp Restore, News. Installation oder Deinstallation von ihnen ist von möglichen <a href=''index.php?admin=modules''>Module Menü</a>.</p>\r\n<p><b>•</b> Im <a href=''index.php?admin=languages''>Menü Sprachen</a> können Sie Hinzufügen / Entfernen von Sprache oder Sprache ändern und bearbeiten können Sie Ihren Wortschatz (die Wörter und Sätze, verwendet von den).</p>\r\n<p><b>•</b> <a href=''index.php?admin=settings''>Menü &quotEinstellungen&quot</a> können Sie vor Ort definieren wichtigen Einstellungen für die.</p>\r\n<p><b>•</b> In <a href=''index.php?admin=my_account''>Mein Konto</a> gibt es eine Möglichkeit, um Informationen ändern Sie.</p>\r\n<p><b>•</b> <a href=''index.php?admin=menus''>Menüs</a> und <a href=''index.php?admin=pages''>Seiten-Management</a> sind Seiten speziell für die Erstellung und Verwaltung Menüs, Links und.</p>\r\n<p><b>•</b> <a href=''index.php?admin=mass_mail''>Mass E-Mail</a> -Funktion ermöglicht es Ihnen, Panel Emails an Ihre Benutzer oder Administratoren von Admin.</p>'),
(982, 'es', '_HOUR', 'Hora'),
(983, 'en', '_HOUR', 'Hour'),
(984, 'de', '_HOUR', 'Stunde'),
(985, 'es', '_HOURS', 'horas'),
(986, 'en', '_HOURS', 'hours'),
(987, 'de', '_HOURS', 'Stunden'),
(988, 'es', '_ICON_IMAGE', 'Imagen de icono'),
(989, 'en', '_ICON_IMAGE', 'Icon Image'),
(990, 'de', '_ICON_IMAGE', 'Icon Bild'),
(991, 'es', '_IMAGE', 'Imagen'),
(992, 'en', '_IMAGE', 'Image'),
(993, 'de', '_IMAGE', 'Bild'),
(994, 'es', '_IMAGES', 'Imágenes'),
(995, 'en', '_IMAGES', 'Images'),
(996, 'de', '_IMAGES', 'Bilder'),
(997, 'es', '_IMAGE_VERIFICATION', 'Imagen de verificación'),
(998, 'en', '_IMAGE_VERIFICATION', 'Image verification'),
(999, 'de', '_IMAGE_VERIFICATION', 'Bildüberprüfung'),
(1000, 'es', '_IMAGE_VERIFY_EMPTY', 'Debe introducir el código de verificación de la imagen!'),
(1001, 'en', '_IMAGE_VERIFY_EMPTY', 'You must enter image verification code!'),
(1002, 'de', '_IMAGE_VERIFY_EMPTY', 'Sie müssen bild verifizierungscode!'),
(1003, 'es', '_INCOME', 'Ingresos'),
(1004, 'en', '_INCOME', 'Income'),
(1005, 'de', '_INCOME', 'Einkommen'),
(1006, 'es', '_INSTALL', 'Instale'),
(1007, 'en', '_INSTALL', 'Install'),
(1008, 'de', '_INSTALL', 'Installieren'),
(1009, 'es', '_INSTALLED', 'Instalado'),
(1010, 'en', '_INSTALLED', 'Installed'),
(1011, 'de', '_INSTALLED', 'Installierte'),
(1012, 'es', '_INSTALL_PHP_EXISTS', 'Archivo <b>install.php</b> y/o directorio <b>instalar/</b> siguen existiendo. Por razones de seguridad por favor, elimine de inmediato!'),
(1013, 'en', '_INSTALL_PHP_EXISTS', 'File <b>install.php</b> and/or directory <b>install/</b> still exist. For security reasons please remove them immediately!'),
(1014, 'de', '_INSTALL_PHP_EXISTS', 'Datei <b>install.php</b> und/oder direkt <b>installieren</b> noch existieren. Aus Sicherheitsgründen ziehen Sie bitte sofort!'),
(1015, 'es', '_INVOICE', 'Factura'),
(1016, 'en', '_INVOICE', 'Invoice'),
(1017, 'de', '_INVOICE', 'Rechnung'),
(1018, 'es', '_INVOICE_SENT_SUCCESS', 'La factura se envió con éxito al cliente!'),
(1019, 'en', '_INVOICE_SENT_SUCCESS', 'The invoice has been successfully sent to the client!'),
(1020, 'de', '_INVOICE_SENT_SUCCESS', 'Die Rechnung wurde erfolgreich an den Client gesendet!'),
(1021, 'es', '_IP_ADDRESS', 'Dirección IP'),
(1022, 'en', '_IP_ADDRESS', 'IP Address'),
(1023, 'de', '_IP_ADDRESS', 'IP-Adresse'),
(1024, 'es', '_IP_ADDRESS_BLOCKED', 'Su dirección IP está bloqueada! Para resolver este problema, póngase en contacto con el administrador del sitio.'),
(1025, 'en', '_IP_ADDRESS_BLOCKED', 'Your IP Address is blocked! To resolve this problem, please contact the site administrator.'),
(1026, 'de', '_IP_ADDRESS_BLOCKED', 'Ihre IP-Adresse blockiert! Um dieses Problem zu beheben, kontaktieren Sie bitte den Administrator der Website.'),
(1027, 'es', '_IS_DEFAULT', 'Es la opción predeterminada'),
(1028, 'en', '_IS_DEFAULT', 'Is default'),
(1029, 'de', '_IS_DEFAULT', 'Ist standardmäßig'),
(1030, 'es', '_ITEMS', 'Artículos'),
(1031, 'en', '_ITEMS', 'Items'),
(1032, 'de', '_ITEMS', 'Artikel'),
(1033, 'es', '_JANUARY', 'Enero'),
(1034, 'en', '_JANUARY', 'January'),
(1035, 'de', '_JANUARY', 'Januar'),
(1036, 'es', '_JULY', 'Julio'),
(1037, 'en', '_JULY', 'July'),
(1038, 'de', '_JULY', 'Juli'),
(1039, 'es', '_JUNE', 'Junio'),
(1040, 'en', '_JUNE', 'June'),
(1041, 'de', '_JUNE', 'Juni'),
(1042, 'es', '_KEY', 'Llave'),
(1043, 'en', '_KEY', 'Key'),
(1044, 'de', '_KEY', 'Schlüssel'),
(1045, 'es', '_KEYWORDS', 'Palabras clave'),
(1046, 'en', '_KEYWORDS', 'Keywords'),
(1047, 'de', '_KEYWORDS', 'Stichwort'),
(1048, 'es', '_KEY_DISPLAY_TYPE', 'Tipo de pantalla Key'),
(1049, 'en', '_KEY_DISPLAY_TYPE', 'Key display type'),
(1050, 'de', '_KEY_DISPLAY_TYPE', 'Key Display-Typ'),
(1051, 'es', '_LANGUAGE', 'Habla'),
(1052, 'en', '_LANGUAGE', 'Language'),
(1053, 'de', '_LANGUAGE', 'Sprache'),
(1054, 'es', '_LANGUAGES', 'Idiomas'),
(1055, 'en', '_LANGUAGES', 'Languages'),
(1056, 'de', '_LANGUAGES', 'Sprachen'),
(1057, 'es', '_LANGUAGES_SETTINGS', 'Configuración de Idiomas'),
(1058, 'en', '_LANGUAGES_SETTINGS', 'Languages Settings'),
(1059, 'de', '_LANGUAGES_SETTINGS', 'Sprachen-Einstellungen'),
(1060, 'es', '_LANGUAGE_ADDED', 'Un nuevo lenguaje se ha añadido!'),
(1061, 'en', '_LANGUAGE_ADDED', 'New language has been successfully added!'),
(1062, 'de', '_LANGUAGE_ADDED', 'Neue Sprache wurde hinzugefügt!'),
(1063, 'es', '_LANGUAGE_ADD_NEW', 'Añadir un nuevo idioma'),
(1064, 'en', '_LANGUAGE_ADD_NEW', 'Add New Language'),
(1065, 'de', '_LANGUAGE_ADD_NEW', 'Neue Sprache hinzufügen'),
(1066, 'es', '_LANGUAGE_EDIT', 'Editar Idioma'),
(1067, 'en', '_LANGUAGE_EDIT', 'Edit Language'),
(1068, 'de', '_LANGUAGE_EDIT', 'Bearbeiten Sprache'),
(1069, 'es', '_LANGUAGE_EDITED', 'Idioma de datos se ha actualizado correctamente!'),
(1070, 'en', '_LANGUAGE_EDITED', 'Language data has been successfully updated!'),
(1071, 'de', '_LANGUAGE_EDITED', 'Language Daten wurden erfolgreich aktualisiert!'),
(1072, 'es', '_LANGUAGE_NAME', 'Idioma Nombre'),
(1073, 'en', '_LANGUAGE_NAME', 'Language Name'),
(1074, 'de', '_LANGUAGE_NAME', 'Sprache Name'),
(1075, 'es', '_LANG_ABBREV_EMPTY', 'Abreviatura del idioma no puede estar vacía!'),
(1076, 'en', '_LANG_ABBREV_EMPTY', 'Language abbreviation cannot be empty!'),
(1077, 'de', '_LANG_ABBREV_EMPTY', 'Sprachkürzel darf nicht leer sein!'),
(1078, 'es', '_LANG_DELETED', 'Idioma ha sido borrado!'),
(1079, 'en', '_LANG_DELETED', 'Language has been successfully deleted!'),
(1080, 'de', '_LANG_DELETED', 'Sprache wurde erfolgreich gelöscht!'),
(1081, 'es', '_LANG_DELETE_LAST_ERROR', 'No se puede eliminar Lengua!'),
(1082, 'en', '_LANG_DELETE_LAST_ERROR', 'You cannot delete last language!'),
(1083, 'de', '_LANG_DELETE_LAST_ERROR', 'Sie können nicht löschen letzten Sprache!'),
(1084, 'es', '_LANG_DELETE_WARNING', '¿Estás seguro de que deseas eliminar este idioma? Esta operación eliminará todos vocabulario del idioma!'),
(1085, 'en', '_LANG_DELETE_WARNING', 'Are you sure you want to remove this language? This operation will delete all language vocabulary!'),
(1086, 'de', '_LANG_DELETE_WARNING', 'Sind Sie sicher, dass Sie diese Sprache zu entfernen? Dieser Vorgang löscht alle Sprache Wortschatz!'),
(1087, 'es', '_LANG_MISSED', 'El lenguaje perdido de actualizar! Por favor, inténtelo de nuevo.'),
(1088, 'en', '_LANG_MISSED', 'Missed language to update! Please, try again.'),
(1089, 'de', '_LANG_MISSED', 'Verpasste Sprache zu aktualisieren! Bitte versuchen Sie es erneut.'),
(1090, 'es', '_LANG_NAME_EMPTY', 'Nombre de idioma no puede estar vacía!'),
(1091, 'en', '_LANG_NAME_EMPTY', 'Language name cannot be empty!'),
(1092, 'de', '_LANG_NAME_EMPTY', 'Name der Sprache darf nicht leer sein!'),
(1093, 'es', '_LANG_NAME_EXISTS', 'De idiomas con ese nombre ya existe! Por favor, elija otro.'),
(1094, 'en', '_LANG_NAME_EXISTS', 'Language with such name already exists! Please choose another.'),
(1095, 'de', '_LANG_NAME_EXISTS', 'Sprache mit solchen Namen existiert bereits! Bitte wählen Sie einen anderen.'),
(1096, 'es', '_LANG_NOT_DELETED', 'El idioma no fue eliminado!'),
(1097, 'en', '_LANG_NOT_DELETED', 'Language has not been deleted!'),
(1098, 'de', '_LANG_NOT_DELETED', 'Sprache wurde nicht gelöscht!'),
(1099, 'es', '_LANG_ORDER_CHANGED', 'Orden de los idiomas se ha cambiado!'),
(1100, 'en', '_LANG_ORDER_CHANGED', 'Language order has been successfully changed!'),
(1101, 'de', '_LANG_ORDER_CHANGED', 'Sprache Bestellung wurde erfolgreich geändert!'),
(1102, 'es', '_LAST_CURRENCY_ALERT', 'No se puede eliminar la moneda activo de último!'),
(1103, 'en', '_LAST_CURRENCY_ALERT', 'You cannot delete last active currency!'),
(1104, 'de', '_LAST_CURRENCY_ALERT', 'Sie können nicht löschen letzten aktiven Währung!'),
(1105, 'es', '_LAST_LOGGED_IP', 'Última sesión de IP'),
(1106, 'en', '_LAST_LOGGED_IP', 'Last logged IP'),
(1107, 'de', '_LAST_LOGGED_IP', 'Zuletzt eingeloggt IP'),
(1108, 'es', '_LAST_LOGIN', 'Último inicio de sesión'),
(1109, 'en', '_LAST_LOGIN', 'Last Login'),
(1110, 'de', '_LAST_LOGIN', 'Letzter Login'),
(1111, 'es', '_LAST_NAME', 'Apellido'),
(1112, 'en', '_LAST_NAME', 'Last Name'),
(1113, 'de', '_LAST_NAME', 'Nachname'),
(1114, 'es', '_LAST_NAME_EMPTY_ALERT', 'Apellido no puede estar vacío! Por favor, vuelva a entrar.'),
(1115, 'en', '_LAST_NAME_EMPTY_ALERT', 'Last Name cannot be empty!'),
(1116, 'de', '_LAST_NAME_EMPTY_ALERT', 'Nachname darf nicht leer sein!'),
(1117, 'es', '_LAST_RUN', 'La última ejecución'),
(1118, 'en', '_LAST_RUN', 'Last run'),
(1119, 'de', '_LAST_RUN', 'Letzter Lauf'),
(1120, 'es', '_LAYOUT', 'Diseño'),
(1121, 'en', '_LAYOUT', 'Layout'),
(1122, 'de', '_LAYOUT', 'Layout'),
(1123, 'es', '_LEAVE_YOUR_COMMENT', 'Deja tu comentario'),
(1124, 'en', '_LEAVE_YOUR_COMMENT', 'Leave your comment'),
(1125, 'de', '_LEAVE_YOUR_COMMENT', 'Lassen Sie Ihren Kommentar'),
(1126, 'es', '_LEFT', 'Izquierdo'),
(1127, 'en', '_LEFT', 'Left'),
(1128, 'de', '_LEFT', 'Links'),
(1129, 'es', '_LEFT_TO_RIGHT', 'LTR (de izquierda a derecha)'),
(1130, 'en', '_LEFT_TO_RIGHT', 'LTR (left-to-right)'),
(1131, 'de', '_LEFT_TO_RIGHT', 'LTR (von links nach rechts)'),
(1132, 'es', '_LICENSE', 'Licencia'),
(1133, 'en', '_LICENSE', 'License'),
(1134, 'de', '_LICENSE', 'Lizenz'),
(1135, 'es', '_LINK', 'Link'),
(1136, 'en', '_LINK', 'Link'),
(1137, 'de', '_LINK', 'Link'),
(1138, 'es', '_LINK_PARAMETER', 'Enlace de parámetros'),
(1139, 'en', '_LINK_PARAMETER', 'Link Parameter'),
(1140, 'de', '_LINK_PARAMETER', 'Link-Parameter'),
(1141, 'es', '_LISTINGS', 'Listados'),
(1142, 'en', '_LISTINGS', 'Listings'),
(1143, 'de', '_LISTINGS', 'Inserate'),
(1144, 'es', '_LISTINGS_AWAITING_MODERATION_ALERT', 'Hay _COUNT_ listado/s en espera de su moderación. Haga clic <a href=''index.php?admin=mod_listings_management''>aquí</ a> para su revisión.'),
(1145, 'en', '_LISTINGS_AWAITING_MODERATION_ALERT', 'There are _COUNT_ listing/s awaiting your moderation. Click <a href=''index.php?admin=mod_listings_management''>here</a> for review.'),
(1146, 'de', '_LISTINGS_AWAITING_MODERATION_ALERT', 'Es gibt _COUNT_ Inserate Erwartung Ihrer Moderation. Klicken Sie <a href=''index.php?admin=mod_listings_management''>hier</ a> für eine Bewertung.'),
(1147, 'es', '_LISTINGS_COUNT', 'Listados conde'),
(1148, 'en', '_LISTINGS_COUNT', 'Listings Count'),
(1149, 'de', '_LISTINGS_COUNT', 'Anzeigen Count'),
(1150, 'es', '_LISTINGS_MANAGEMENT', 'Listados de Gestión'),
(1151, 'en', '_LISTINGS_MANAGEMENT', 'Listings Management'),
(1152, 'de', '_LISTINGS_MANAGEMENT', 'Anzeigen-Management'),
(1153, 'es', '_LISTINGS_PURCHASING', 'Anuncios de compra'),
(1154, 'en', '_LISTINGS_PURCHASING', 'Listings Purchasing'),
(1155, 'de', '_LISTINGS_PURCHASING', 'Anzeigen Einkauf'),
(1156, 'es', '_LISTINGS_SETTINGS', 'Listados de Configuración'),
(1157, 'en', '_LISTINGS_SETTINGS', 'Listings Settings'),
(1158, 'de', '_LISTINGS_SETTINGS', 'Anzeigen-Einstellungen'),
(1159, 'es', '_LOADING', 'de carga'),
(1160, 'en', '_LOADING', 'loading'),
(1161, 'de', '_LOADING', 'laden'),
(1162, 'es', '_LOGINS', 'Iniciar sesión'),
(1163, 'en', '_LOGINS', 'Logins'),
(1164, 'de', '_LOGINS', 'Login'),
(1165, 'es', '_LOGIN_PAGE_MSG', 'Utilice un nombre de usuario administrador y contraseña válidos para acceder al Administrador de servicios de fondo.<br><br>Volver a la página <a href=''index.php''>Home Page</a> <br><br><img align=''center'' src=''images/lock.png'' alt =''92px''>'),
(1166, 'en', '_LOGIN_PAGE_MSG', 'Use a valid administrator username and password to get access to the Administrator Back-End.<br><br>Return to site <a href=''index.php''>Home Page</a><br><br><img align=''center'' src=''images/lock.png'' alt='''' width=''92px''>\r\n'),
(1167, 'de', '_LOGIN_PAGE_MSG', 'Verwenden Sie einen gültigen Administrator-Benutzernamen und das Passwort für den Zugriff auf das Administrator-Back-End zu bekommen. <br><br>Zurück zur Website <a href=''index.php''>Homepage</a><br><br>\r\n<img align=''center'' src=''images/lock.png'' alt='''' width=''92px''>'),
(1168, 'es', '_LOOK_IN', 'Buscar en'),
(1169, 'en', '_LOOK_IN', 'Look in'),
(1170, 'de', '_LOOK_IN', 'Suchen in'),
(1171, 'es', '_MAILER', 'Mailer'),
(1172, 'en', '_MAILER', 'Mailer'),
(1173, 'de', '_MAILER', 'Mailer'),
(1174, 'es', '_MAIN', 'Principal'),
(1175, 'en', '_MAIN', 'Main'),
(1176, 'de', '_MAIN', 'Haupt'),
(1177, 'es', '_MAIN_ADMIN', 'Administrador principal'),
(1178, 'en', '_MAIN_ADMIN', 'Main Admin'),
(1179, 'de', '_MAIN_ADMIN', 'Haupt-Admin'),
(1180, 'es', '_MANAGE_TEMPLATES', 'Administrar plantillas'),
(1181, 'en', '_MANAGE_TEMPLATES', 'Manage Templates'),
(1182, 'de', '_MANAGE_TEMPLATES', 'Vorlagen verwalten'),
(1183, 'es', '_MAP', 'Mapa'),
(1184, 'en', '_MAP', 'Map'),
(1185, 'de', '_MAP', 'Karte'),
(1186, 'es', '_MAP_CODE', 'Mapa del Código'),
(1187, 'en', '_MAP_CODE', 'Map Code'),
(1188, 'de', '_MAP_CODE', 'Map-Code'),
(1189, 'es', '_MAP_OVERLAY', 'Mapa de superposición'),
(1190, 'en', '_MAP_OVERLAY', 'Map Overlay'),
(1191, 'de', '_MAP_OVERLAY', 'Landkarten-Overlay'),
(1192, 'es', '_MARCH', 'Marzo'),
(1193, 'en', '_MARCH', 'March'),
(1194, 'de', '_MARCH', 'März'),
(1195, 'es', '_MASS_MAIL', 'Misa Mail'),
(1196, 'en', '_MASS_MAIL', 'Mass Mail'),
(1197, 'de', '_MASS_MAIL', 'Masse Mail'),
(1198, 'es', '_MASS_MAIL_ALERT', 'Atención: servicios de alojamiento compartido por lo general tienen un límite de 200 correos electrónicos por hora'),
(1199, 'en', '_MASS_MAIL_ALERT', 'Attention: shared hosting services usually have a limit of 200 emails per hour'),
(1200, 'de', '_MASS_MAIL_ALERT', 'Achtung: Shared-Hosting-Dienste haben in der Regel ein Limit von 200 Mails pro Stunde'),
(1201, 'es', '_MASS_MAIL_AND_TEMPLATES', 'Misa de correo y plantillas'),
(1202, 'en', '_MASS_MAIL_AND_TEMPLATES', 'Mass Mail & Templates'),
(1203, 'de', '_MASS_MAIL_AND_TEMPLATES', 'Masse Mail & Vorlagen'),
(1204, 'es', '_MAX_CHARS', '(max: _MAX_CHARS_ caracteres)'),
(1205, 'en', '_MAX_CHARS', '(max: _MAX_CHARS_ chars)'),
(1206, 'de', '_MAX_CHARS', '(max: _MAX_CHARS_ Zeichen)'),
(1207, 'es', '_MAX_ORDERS_ERROR', 'Usted ha alcanzado el número máximo permitido de las órdenes, que aún no ha terminado! Por favor, complete al menos uno de ellos para continuar la compra de los nuevos anuncios.'),
(1208, 'en', '_MAX_ORDERS_ERROR', 'You have reached the maximum number of permitted orders, that you have not yet finished! Please complete at least one of them to proceed purchasing of new listings.'),
(1209, 'de', '_MAX_ORDERS_ERROR', 'Sie haben die maximale Anzahl von erlaubten Auftragseingang erreichte, dass Sie noch nicht fertig! Bitte füllen Sie mindestens eine von ihnen den Einkauf von neuen Inserate vorzugehen.'),
(1210, 'es', '_MAY', 'Mayo'),
(1211, 'en', '_MAY', 'May'),
(1212, 'de', '_MAY', 'Mai'),
(1213, 'es', '_MD_ADSENSE', 'Este módulo proporciona a los proveedores de contenido web con los medios para obtener ingresos de los visitantes del blog de la publicación de anuncios de Google AdSense™ de servicios de publicidad.'),
(1214, 'en', '_MD_ADSENSE', 'This module provides web content providers with the means to earn revenue from blog visitors by displaying ads from Google AdSense™ advertising service.'),
(1215, 'de', '_MD_ADSENSE', 'Dieses Modul bietet Web-Content-Anbieter mit den Mitteln die Einnahmen aus Blog Besucher verdienen, indem die Schaltung von Anzeigen von Google AdSense™-Werbeprogramm.'),
(1216, 'es', '_MD_BACKUP_AND_RESTORE', 'Con el módulo de seguridad y restauración para volcar todas las tablas de su base de datos de descarga de un archivo o guardarlo en un archivo en el servidor, y restaurar a partir de un depósito de base de datos de subida o guardado previamente.'),
(1217, 'en', '_MD_BACKUP_AND_RESTORE', 'With Backup and Restore module you can dump all of your database tables to a file download or save to a file on the server, and to restore from an uploaded or previously saved database dump.'),
(1218, 'de', '_MD_BACKUP_AND_RESTORE', 'Mit Backup and Restore-Modul können Sie alle Ihre Datenbanktabellen, eine Datei herunterzuladen Dump speichern oder in eine Datei auf dem Server, und von einer hochgeladenen oder zuvor gespeicherte Datenbank-Dump wiederherstellen.'),
(1219, 'es', '_MD_BANNERS', 'El módulo de Banners que permite al administrador visualizar las imágenes en el sitio en el estilo de azar o de la rotación.'),
(1220, 'en', '_MD_BANNERS', 'The Banners module allows administrator to display images on the site in random or rotation style.'),
(1221, 'de', '_MD_BANNERS', 'Die Banner-Modul erlaubt dem Administrator, Bilder auf der Site in zufälliger oder Rotation Stil angezeigt.'),
(1222, 'es', '_MD_COMMENTS', 'El módulo de Comentarios permite a los visitantes dejar comentarios en los artículos y administrador del sitio a moderada.'),
(1223, 'en', '_MD_COMMENTS', 'The Comments module allows visitors to leave comments on articles and administrator of the site to moderate them.'),
(1224, 'de', '_MD_COMMENTS', 'Die Kommentare Modul ermöglicht es den Besuchern, um Kommentare zu Artikeln und Administrator der Website zu verlassen, um sie zu mäßigen.'),
(1225, 'es', '_MD_CONTACT_US', 'Contáctenos módulo permite una fácil crear y colocar en línea el formulario de contacto en las páginas del sitio, utilizando el código predefinidas, como: {module: contactenos}.'),
(1226, 'en', '_MD_CONTACT_US', 'Contact Us module allows easy create and place on-line contact form on site pages, using predefined code, like: {module:contact_us}.'),
(1227, 'de', '_MD_CONTACT_US', 'Kontakt Modul ermöglicht die einfache Erstellung und am Online-Kontaktformular auf Seiten der Website, unter Verwendung vordefinierter Code, wie: {module:contact_us}.'),
(1228, 'es', '_MD_CUSTOMERS', 'El módulo permite al cliente de gestión de clientes, desde tu sitio. Administrador puede crear, editar o eliminar las cuentas de clientes. Los clientes pueden registrarse en el sitio y acceder a sus cuentas.'),
(1229, 'en', '_MD_CUSTOMERS', 'The Customers module allows easy customers management on your site. Administrator could create, edit or delete customer accounts. Customers could register on the site and log into their accounts.'),
(1230, 'de', '_MD_CUSTOMERS', 'Der Kunde Modul ermöglicht die einfache Kunden-Management auf Ihrer Website. Administrator könnte erstellen, bearbeiten oder löschen Kundenkonten. Die Kunden könnten auf der Website registrieren und einloggen auf ihre Konten.'),
(1231, 'es', '_MD_FAQ', 'Las Preguntas Frecuentes (FAQ) del módulo permite a los usuarios de administración para crear pares de preguntas y respuestas que desea mostrar en la página ''preguntas frecuentes''.'),
(1232, 'en', '_MD_FAQ', 'The Frequently Asked Questions (faq) module allows admin users to create question and answer pairs which they want displayed on the ''faq'' page.'),
(1233, 'de', '_MD_FAQ', 'Die Frequently Asked Questions (FAQ)-Modul ermöglicht admin Benutzer Frage und Antwort-Paare, die sie auf der "FAQ"-Seite angezeigt werden sollen erstellen.'),
(1234, 'es', '_MD_GALLERY', 'El módulo permite al administrador de la Galería para crear álbumes de imágenes o de vídeo, subir contenido del álbum y dysplay este contenido para ser visto por los visitantes del sitio.'),
(1235, 'en', '_MD_GALLERY', 'The Gallery module allows administrator to create image or video albums, upload album content and dysplay this content to be viewed by visitor of the site.'),
(1236, 'de', '_MD_GALLERY', 'Die Galerie-Modul erlaubt dem Administrator, Bild oder Video Alben zu erstellen, hochzuladen Album Inhalte und dysplay diese Inhalte durch Besucher der Website eingesehen werden.'),
(1237, 'es', '_MD_LISTINGS', 'Módulo de listados permite al administrador crear y administrar listas, listas, etc categorías'),
(1238, 'en', '_MD_LISTINGS', 'Listings module allows administrator to create and manage listings, listing categories etc.'),
(1239, 'de', '_MD_LISTINGS', 'Anzeigen-Modul ermöglicht Administratoren das Erstellen und Verwalten Liste, Liste Kategorien etc.'),
(1240, 'es', '_MD_NEWS', 'El módulo de Noticias y Eventos permite al administrador para publicar noticias y eventos en el sitio, muestra más reciente de ellas en el bloque lateral.'),
(1241, 'en', '_MD_NEWS', 'The News and Events module allows administrator to post news and events on the site, display latest of them at the side block.'),
(1242, 'de', '_MD_NEWS', 'Das News und Events-Modul erlaubt dem Administrator, Neuigkeiten und Veranstaltungen auf der Website zu veröffentlichen, zeigen neueste von ihnen an der Seite zu blockieren.'),
(1243, 'es', '_MD_PAGES', 'Módulo de páginas permite al administrador crear y mantener fácilmente contenido de la página.'),
(1244, 'en', '_MD_PAGES', 'Pages module allows administrator to easily create and maintain page content.'),
(1245, 'de', '_MD_PAGES', 'Seiten-Modul ermöglicht Administratoren die einfache Erstellung und Pflege Inhalt der Seite.'),
(1246, 'es', '_MD_PAYMENTS', 'Los pagos del módulo le permite fácilmente acepta y gestionar los pagos por publicidad de las listas de sus clientes.'),
(1247, 'en', '_MD_PAYMENTS', 'The module Payments allows you to easily accepts and manage payments for advertise of listings from your customers.'),
(1248, 'de', '_MD_PAYMENTS', 'Die Zahlungen Modul ermöglicht Ihnen die einfache Verwaltung und akzeptiert Zahlungen für Werbung von Angeboten von Ihren Kunden.'),
(1249, 'es', '_MENUS', 'Menús'),
(1250, 'en', '_MENUS', 'Menus'),
(1251, 'de', '_MENUS', 'Menüs'),
(1252, 'es', '_MENU_ADD', 'Añadir Menú'),
(1253, 'en', '_MENU_ADD', 'Add Menu'),
(1254, 'de', '_MENU_ADD', 'Menü hinzufügen'),
(1255, 'es', '_MENU_CREATED', 'Menu fue creado con éxito'),
(1256, 'en', '_MENU_CREATED', 'Menu has been successfully created'),
(1257, 'de', '_MENU_CREATED', 'Menu wurde erfolgreich erstellt'),
(1258, 'es', '_MENU_DELETED', 'Menú ha sido borrado'),
(1259, 'en', '_MENU_DELETED', 'Menu has been successfully deleted'),
(1260, 'de', '_MENU_DELETED', 'Menu wurde erfolgreich gelöscht'),
(1261, 'es', '_MENU_DELETE_WARNING', '¿Estás seguro de que deseas eliminar este menú? Nota: esto hará que todo su menú de enlaces invisibles a sus visitantes!'),
(1262, 'en', '_MENU_DELETE_WARNING', 'Are you sure you want to delete this menu? Note: this will make all its menu links invisible to your site visitors!');
INSERT INTO `<DB_PREFIX>vocabulary` (`id`, `language_id`, `key_value`, `key_text`) VALUES
(1263, 'de', '_MENU_DELETE_WARNING', 'Sie sind sicher, dass Sie dieses Menü löschen? Hinweis: Dieser wird alle seine Menü-Links unsichtbar Besucher Ihrer Website!'),
(1264, 'es', '_MENU_EDIT', 'Menú Edición'),
(1265, 'en', '_MENU_EDIT', 'Edit Menu'),
(1266, 'de', '_MENU_EDIT', 'Menü Bearbeiten'),
(1267, 'es', '_MENU_LINK', 'Enlace del menú'),
(1268, 'en', '_MENU_LINK', 'Menu Link'),
(1269, 'de', '_MENU_LINK', 'Menü-Link'),
(1270, 'es', '_MENU_LINK_TEXT', 'Enlace del menú (máx. 40 caracteres)'),
(1271, 'en', '_MENU_LINK_TEXT', 'Menu Link (max. 40 chars)'),
(1272, 'de', '_MENU_LINK_TEXT', 'Menü-Link (max. 40 Zeichen)'),
(1273, 'es', '_MENU_MANAGEMENT', 'Menús de Gestión'),
(1274, 'en', '_MENU_MANAGEMENT', 'Menus Management'),
(1275, 'de', '_MENU_MANAGEMENT', 'Menüs Management'),
(1276, 'es', '_MENU_MISSED', 'Menú perdidas para actualizar! Por favor, inténtelo de nuevo.'),
(1277, 'en', '_MENU_MISSED', 'Missed menu to update! Please, try again.'),
(1278, 'de', '_MENU_MISSED', 'Verpasste Menü zu aktualisieren! Bitte versuchen Sie es erneut.'),
(1279, 'es', '_MENU_NAME', 'Nombre de menú'),
(1280, 'en', '_MENU_NAME', 'Menu Name'),
(1281, 'de', '_MENU_NAME', 'Menüname'),
(1282, 'es', '_MENU_NAME_EMPTY', 'Nombre del menú no puede estar vacía!'),
(1283, 'en', '_MENU_NAME_EMPTY', 'Menu name cannot be empty!'),
(1284, 'de', '_MENU_NAME_EMPTY', 'Menü-Name darf nicht leer sein!'),
(1285, 'es', '_MENU_NOT_CREATED', 'Menú no se ha creado!'),
(1286, 'en', '_MENU_NOT_CREATED', 'Menu has not been created!'),
(1287, 'de', '_MENU_NOT_CREATED', 'Menü wurde nicht erstellt!'),
(1288, 'es', '_MENU_NOT_DELETED', 'Menú no se ha eliminado!'),
(1289, 'en', '_MENU_NOT_DELETED', 'Menu has not been deleted!'),
(1290, 'de', '_MENU_NOT_DELETED', 'Menü wurde nicht gelöscht!'),
(1291, 'es', '_MENU_NOT_FOUND', 'No se han encontrado los menús'),
(1292, 'en', '_MENU_NOT_FOUND', 'No Menus Found'),
(1293, 'de', '_MENU_NOT_FOUND', 'Keine Menüs gefunden'),
(1294, 'es', '_MENU_NOT_SAVED', 'Menú no se salvó!'),
(1295, 'en', '_MENU_NOT_SAVED', 'Menu has not been saved!'),
(1296, 'de', '_MENU_NOT_SAVED', 'Menü wurde nicht gespart!'),
(1297, 'es', '_MENU_ORDER', 'Orden del menú'),
(1298, 'en', '_MENU_ORDER', 'Menu Order'),
(1299, 'de', '_MENU_ORDER', 'Menü Auftrag'),
(1300, 'es', '_MENU_ORDER_CHANGED', 'Orden del menú se ha cambiado correctamente'),
(1301, 'en', '_MENU_ORDER_CHANGED', 'Menu order has been successfully changed'),
(1302, 'de', '_MENU_ORDER_CHANGED', 'Menü Auftrag wurde erfolgreich geändert'),
(1303, 'es', '_MENU_SAVED', 'Menú se ha guardado correctamente'),
(1304, 'en', '_MENU_SAVED', 'Menu has been successfully saved'),
(1305, 'de', '_MENU_SAVED', 'Menu wurde erfolgreich gespeichert'),
(1306, 'es', '_MENU_TITLE', 'Menu TitleTítulo del menú'),
(1307, 'en', '_MENU_TITLE', 'Menu Title'),
(1308, 'de', '_MENU_TITLE', 'Menü Titel'),
(1309, 'es', '_MENU_WORD', 'Menú'),
(1310, 'en', '_MENU_WORD', 'Menu'),
(1311, 'de', '_MENU_WORD', 'Menü'),
(1312, 'es', '_MESSAGE', 'Mensaje'),
(1313, 'en', '_MESSAGE', 'Message'),
(1314, 'de', '_MESSAGE', 'Nachricht'),
(1315, 'es', '_MESSAGE_EMPTY_ALERT', 'El mensaje no puede estar vacío! Por favor, vuelva a entrar.'),
(1316, 'en', '_MESSAGE_EMPTY_ALERT', 'Message cannot be empty! Please re-enter.'),
(1317, 'de', '_MESSAGE_EMPTY_ALERT', 'Nachricht kann nicht leer sein! Bitte erneut eingeben.'),
(1318, 'es', '_META_TAG', 'Meta Tag'),
(1319, 'en', '_META_TAG', 'Meta Tag'),
(1320, 'de', '_META_TAG', 'Meta-Tag'),
(1321, 'es', '_META_TAGS', 'Etiquetas META'),
(1322, 'en', '_META_TAGS', 'META Tags'),
(1323, 'de', '_META_TAGS', 'META-Tags'),
(1324, 'es', '_METHOD', 'Método'),
(1325, 'en', '_METHOD', 'Method'),
(1326, 'de', '_METHOD', 'Methode'),
(1327, 'es', '_MIN', 'Acta'),
(1328, 'en', '_MIN', 'Min'),
(1329, 'de', '_MIN', 'Min'),
(1330, 'es', '_MINUTES', 'acta'),
(1331, 'en', '_MINUTES', 'minutes'),
(1332, 'de', '_MINUTES', 'Minuten'),
(1333, 'es', '_MODULES', 'Módulos'),
(1334, 'en', '_MODULES', 'Modules'),
(1335, 'de', '_MODULES', 'Module'),
(1336, 'es', '_MODULES_MANAGEMENT', 'Módulos de Gestión'),
(1337, 'en', '_MODULES_MANAGEMENT', 'Modules Management'),
(1338, 'de', '_MODULES_MANAGEMENT', 'Module Management'),
(1339, 'es', '_MODULES_NOT_FOUND', 'N módulos encontrado!'),
(1340, 'en', '_MODULES_NOT_FOUND', 'No modules found!'),
(1341, 'de', '_MODULES_NOT_FOUND', 'Keine Module gefunden!'),
(1342, 'es', '_MODULE_INSTALLED', 'Módulo fue instalado con éxito!'),
(1343, 'en', '_MODULE_INSTALLED', 'Module has been successfully installed!'),
(1344, 'de', '_MODULE_INSTALLED', 'Modul wurde erfolgreich installiert!'),
(1345, 'es', '_MODULE_INSTALL_ALERT', '¿Estás seguro de que desea instalar este módulo?'),
(1346, 'en', '_MODULE_INSTALL_ALERT', 'Are you sure you want to install this module?'),
(1347, 'de', '_MODULE_INSTALL_ALERT', 'Sie sind sicher, dass Sie dieses Modul installieren?'),
(1348, 'es', '_MODULE_UNINSTALLED', 'Módulo éxito sin instalar!'),
(1349, 'en', '_MODULE_UNINSTALLED', 'Module has been successfully un-installed!'),
(1350, 'de', '_MODULE_UNINSTALLED', 'Modul wurde erfolgreich in nicht eingebautem Zustand!'),
(1351, 'es', '_MODULE_UNINSTALL_ALERT', '¿Estás seguro de que desea desinstalar este módulo?'),
(1352, 'en', '_MODULE_UNINSTALL_ALERT', 'Are you sure you want to un-install this module?'),
(1353, 'de', '_MODULE_UNINSTALL_ALERT', 'Sie sind sicher, dass Sie de-installieren dieses Modul?'),
(1354, 'es', '_MONDAY', 'lunes'),
(1355, 'en', '_MONDAY', 'Monday'),
(1356, 'de', '_MONDAY', 'Montag'),
(1357, 'es', '_MONTH', 'Mes'),
(1358, 'en', '_MONTH', 'Month'),
(1359, 'de', '_MONTH', 'Monat'),
(1360, 'es', '_MORE', 'más'),
(1361, 'en', '_MORE', 'more'),
(1362, 'de', '_MORE', 'mehr'),
(1363, 'es', '_MS_ADMIN_CHANGE_USER_PASSWORD', 'Especifica si se permite el cambio de contraseñas de usuario de Admin'),
(1364, 'en', '_MS_ADMIN_CHANGE_USER_PASSWORD', 'Specifies whether to allow changing user password by Admin'),
(1365, 'de', '_MS_ADMIN_CHANGE_USER_PASSWORD', 'Gibt an, ob sich ändernde Benutzer-Passwort vom Admin erlaubt'),
(1366, 'es', '_MS_ADSENSE_CODE_ACTIVATION', 'Especifica qué parte de los bloques de AdSense activos'),
(1367, 'en', '_MS_ADSENSE_CODE_ACTIVATION', 'Specifies which part of AdSense blocks is active'),
(1368, 'de', '_MS_ADSENSE_CODE_ACTIVATION', 'Gibt an, welcher Teil des AdSense-Blöcke aktiv ist'),
(1369, 'es', '_MS_ADSENSE_CODE_HORIZONTAL', 'Especifica un código de banner horizontal, que deben ser tomadas de la compañía de publicidad'),
(1370, 'en', '_MS_ADSENSE_CODE_HORIZONTAL', 'Specifies a code for horizontal banner, that must be taken from advertising company'),
(1371, 'de', '_MS_ADSENSE_CODE_HORIZONTAL', 'Gibt einen Code für horizontale Banner, die von Werbeunternehmen getroffen werden müssen'),
(1372, 'es', '_MS_ADSENSE_CODE_VERTICAL', 'Especifica un código de banner vertical, que se deben tomar de la compañía de publicidad'),
(1373, 'en', '_MS_ADSENSE_CODE_VERTICAL', 'Specifies a code for vertical banner, that must be taken from advertising company'),
(1374, 'de', '_MS_ADSENSE_CODE_VERTICAL', 'Gibt einen Code für vertikale Banner, die von Werbeunternehmen getroffen werden müssen'),
(1375, 'es', '_MS_ALBUMS_PER_LINE', 'Número de iconos de disco por línea'),
(1376, 'en', '_MS_ALBUMS_PER_LINE', 'Number of album icons per line'),
(1377, 'de', '_MS_ALBUMS_PER_LINE', 'Anzahl der Album Symbole pro Zeile'),
(1378, 'es', '_MS_ALBUM_ICON_HEIGHT', 'Album altura icono'),
(1379, 'en', '_MS_ALBUM_ICON_HEIGHT', 'Album icon height'),
(1380, 'de', '_MS_ALBUM_ICON_HEIGHT', 'Album-Symbol Höhe'),
(1381, 'es', '_MS_ALBUM_ICON_WIDTH', 'Album ancho icono'),
(1382, 'en', '_MS_ALBUM_ICON_WIDTH', 'Album icon width'),
(1383, 'de', '_MS_ALBUM_ICON_WIDTH', 'Album-Symbol Breite'),
(1384, 'es', '_MS_ALBUM_ITEMS_COUNT', 'Especifica si se muestra la cuenta de las imágenes/video bajo el nombre del álbum'),
(1385, 'en', '_MS_ALBUM_ITEMS_COUNT', 'Specifies whether to show count of images/video under album name'),
(1386, 'de', '_MS_ALBUM_ITEMS_COUNT', 'Gibt an, ob Anzahl der Bilder/Videos unter Albumname zeigen'),
(1387, 'es', '_MS_ALBUM_KEY', 'La palabra clave que será reemplazado con un álbum de imágenes de algunos (copiar y pegarlo en la página)'),
(1388, 'en', '_MS_ALBUM_KEY', 'The keyword that will be replaced with a certain album images (copy and paste it into the page)'),
(1389, 'de', '_MS_ALBUM_KEY', 'Das Schlüsselwort, das mit einem bestimmten Album Bilder ersetzt werden (Kopieren und fügen Sie ihn auf der Seite)'),
(1390, 'es', '_MS_ALERT_ADMIN_NEW_REGISTRATION', 'Especifica si se alerta admin el registro de nuevo usuario'),
(1391, 'en', '_MS_ALERT_ADMIN_NEW_REGISTRATION', 'Specifies whether to alert admin on new user registration'),
(1392, 'de', '_MS_ALERT_ADMIN_NEW_REGISTRATION', 'Gibt an, ob admin am Neuen Benutzer anmelden Alarm'),
(1393, 'es', '_MS_ALLOW_ADDING_BY_ADMIN', 'Especifica si se permite la adición de nuevos usuarios por Admin'),
(1394, 'en', '_MS_ALLOW_ADDING_BY_ADMIN', 'Specifies whether to allow adding new users by Admin'),
(1395, 'de', '_MS_ALLOW_ADDING_BY_ADMIN', 'Gibt an, ob das Hinzufügen neuer Benutzer durch Admin'),
(1396, 'es', '_MS_ALLOW_CUST_LOGIN', 'Especifica si se permite a los clientes acceso al sitio'),
(1397, 'en', '_MS_ALLOW_CUST_LOGIN', 'Specifies whether to allow customers to login to the site'),
(1398, 'de', '_MS_ALLOW_CUST_LOGIN', 'Gibt an, ob Kunden auf der Website anmelden'),
(1399, 'es', '_MS_ALLOW_CUST_REGISTRATION', 'Especifica si se permite a los clientes registrarse'),
(1400, 'en', '_MS_ALLOW_CUST_REGISTRATION', 'Specifies whether to allow customers to register'),
(1401, 'de', '_MS_ALLOW_CUST_REGISTRATION', 'Gibt an, ob Kunden sich zu registrieren'),
(1402, 'es', '_MS_ALLOW_CUST_RESET_PASSWORDS', 'Especifica si se permite a los clientes para restablecer sus contraseñas'),
(1403, 'en', '_MS_ALLOW_CUST_RESET_PASSWORDS', 'Specifies whether to allow customers to restore their passwords'),
(1404, 'de', '_MS_ALLOW_CUST_RESET_PASSWORDS', 'Gibt an, ob Kunden wieder ihre Passwörter'),
(1405, 'es', '_MS_AUTHORIZE_LOGIN_ID', 'Especifica Authorize.Net API Login ID'),
(1406, 'en', '_MS_AUTHORIZE_LOGIN_ID', 'Specifies Authorize.Net API Login ID'),
(1407, 'de', '_MS_AUTHORIZE_LOGIN_ID', 'Gibt Authorize.Net API Login ID'),
(1408, 'es', '_MS_AUTHORIZE_TRANSACTION_KEY', 'Especificador Authorize.Net Transaction Key'),
(1409, 'en', '_MS_AUTHORIZE_TRANSACTION_KEY', 'Specifies Authorize.Net Transaction Key'),
(1410, 'de', '_MS_AUTHORIZE_TRANSACTION_KEY', 'Authorize.Net Transaction Key gibt'),
(1411, 'es', '_MS_BANNERS_IS_ACTIVE', 'Define si el módulo banners está activo o no'),
(1412, 'en', '_MS_BANNERS_IS_ACTIVE', 'Defines whether banners module is active or not'),
(1413, 'de', '_MS_BANNERS_IS_ACTIVE', 'Legt fest, ob Banner-Modul aktiv ist oder nicht'),
(1414, 'es', '_MS_CATEGORIES_IMAGES', 'Especifica si se muestran imágenes de las categorías o no'),
(1415, 'en', '_MS_CATEGORIES_IMAGES', 'Specifies whether to show categories images or not'),
(1416, 'de', '_MS_CATEGORIES_IMAGES', 'Gibt an, ob zu zeigen Kategorien Bilder oder keine'),
(1417, 'es', '_MS_COLUMNS_ON_PAGE', 'Especifica el número de columnas a la tabla de categorías'),
(1418, 'en', '_MS_COLUMNS_ON_PAGE', 'Specifies the number of columns in the table of categories'),
(1419, 'de', '_MS_COLUMNS_ON_PAGE', 'Gibt die Anzahl der Spalten der Tabelle der Kategorien'),
(1420, 'es', '_MS_COMMENTS_ALLOW', 'Especifica si se permiten comentarios a los artículos'),
(1421, 'en', '_MS_COMMENTS_ALLOW', 'Specifies whether to allow comments to articles'),
(1422, 'de', '_MS_COMMENTS_ALLOW', 'Gibt an, ob Kommentare zu Artikeln ermöglichen'),
(1423, 'es', '_MS_COMMENTS_LENGTH', 'La longitud máxima de un comentario'),
(1424, 'en', '_MS_COMMENTS_LENGTH', 'The maximum length of a comment'),
(1425, 'de', '_MS_COMMENTS_LENGTH', 'Die maximale Länge eines Kommentars'),
(1426, 'es', '_MS_COMMENTS_PAGE_SIZE', 'Define la cantidad de comentarios tanto se muestra en una página'),
(1427, 'en', '_MS_COMMENTS_PAGE_SIZE', 'Defines how much comments will be shown on one page'),
(1428, 'de', '_MS_COMMENTS_PAGE_SIZE', 'Legt fest, wie viel Kommentare werden auf einer Seite angezeigt werden'),
(1429, 'es', '_MS_CONTACT_US_KEY', 'La palabra clave que serán reemplazadas con nosotros Formulario de contacto (copiar y pegarlo en la página)'),
(1430, 'en', '_MS_CONTACT_US_KEY', 'The keyword that will be replaced with Contact Us form (copy and paste it into the page)'),
(1431, 'de', '_MS_CONTACT_US_KEY', 'Das Schlüsselwort, das mit ersetzt werden Kontakt-Formular (Kopie und fügen Sie ihn in die Seite)'),
(1432, 'es', '_MS_CUSTOMERS_LOGIN_BLOCK', 'Especifica si se debe mostrar el bloque de clientes de acceso en la página principal o no'),
(1433, 'en', '_MS_CUSTOMERS_LOGIN_BLOCK', 'Specifies whether to show customers login block on homepage or not'),
(1434, 'de', '_MS_CUSTOMERS_LOGIN_BLOCK', 'Gibt an, ob Kunden Login-Block auf der Startseite anzeigen lassen oder nicht'),
(1435, 'es', '_MS_CUST_IMAGE_VERIFICATION', 'Especifica si se debe permitir la verificación de la imagen (captcha) en la página de registro de clientes'),
(1436, 'en', '_MS_CUST_IMAGE_VERIFICATION', 'Specifies whether to allow image verification (captcha) on customer registration page'),
(1437, 'de', '_MS_CUST_IMAGE_VERIFICATION', 'Gibt an, ob Bild Verifikation (Captcha) auf Kunden-Registrierung Seite zulassen'),
(1438, 'es', '_MS_DEFAULT_PAYMENT_SYSTEM', 'Especifica el pago por defecto del sistema de procesamiento'),
(1439, 'en', '_MS_DEFAULT_PAYMENT_SYSTEM', 'Specifies default payment processing system'),
(1440, 'de', '_MS_DEFAULT_PAYMENT_SYSTEM', 'Gibt Zahlungsverzug Verarbeitungssystem'),
(1441, 'es', '_MS_DELAY_LENGTH', 'Define un tiempo de retraso entre el envío de correos electrónicos (en segundos)'),
(1442, 'en', '_MS_DELAY_LENGTH', 'Defines a length of delay between sending emails (in seconds)'),
(1443, 'de', '_MS_DELAY_LENGTH', 'Definiert eine Länge von Verzögerung zwischen dem Senden von E-Mails (in Sekunden)'),
(1444, 'es', '_MS_DELETE_PENDING_TIME', 'El tiempo máximo de espera para la eliminación de comentarios en pocos minutos'),
(1445, 'en', '_MS_DELETE_PENDING_TIME', 'The maximum pending time for deleting of own comment in minutes'),
(1446, 'de', '_MS_DELETE_PENDING_TIME', 'Die maximale Zeit bis zur Löschung des eigenen Kommentar in Minuten'),
(1447, 'es', '_MS_EMAIL', 'La dirección de correo electrónico, que se utiliza para obtener la información enviada'),
(1448, 'en', '_MS_EMAIL', 'The email address, that will be used to get sent information'),
(1449, 'de', '_MS_EMAIL', 'Die E-Mail-Adresse, die verwendet werden, um an Informationen zu bekommen sein wird'),
(1450, 'es', '_MS_FAQ_IS_ACTIVE', 'Legt fest, ob FAQ-Modul aktiv ist oder nicht'),
(1451, 'en', '_MS_FAQ_IS_ACTIVE', 'Defines whether FAQ module is active or not'),
(1452, 'de', '_MS_FAQ_IS_ACTIVE', 'Defines whether FAQ module is active or not'),
(1453, 'es', '_MS_GALLERY_KEY', 'La palabra clave que serán reemplazadas con la galería (copiar y pegarlo en la página)'),
(1454, 'en', '_MS_GALLERY_KEY', 'The keyword that will be replaced with gallery (copy and paste it into the page)'),
(1455, 'de', '_MS_GALLERY_KEY', 'Das Schlüsselwort, das mit Galerie (Kopie ersetzt wird, und fügen Sie ihn in die Seite)'),
(1456, 'es', '_MS_GALLERY_WRAPPER', 'Define un tipo de contenedor de la galería'),
(1457, 'en', '_MS_GALLERY_WRAPPER', 'Defines a wrapper type for gallery'),
(1458, 'de', '_MS_GALLERY_WRAPPER', 'Definiert eine Wrapper-Typ für die Galerie'),
(1459, 'es', '_MS_IMAGE_GALLERY_TYPE', 'Tipos de animales Galería de imágenes'),
(1460, 'en', '_MS_IMAGE_GALLERY_TYPE', 'Allowed types of Image Gallery'),
(1461, 'de', '_MS_IMAGE_GALLERY_TYPE', 'Erlaubt Arten von Image Gallery'),
(1462, 'es', '_MS_IMAGE_VERIFICATION_ALLOW', 'Especifica si se debe permitir la verificación de la imagen (captcha)'),
(1463, 'en', '_MS_IMAGE_VERIFICATION_ALLOW', 'Specifies whether to allow image verification (captcha)'),
(1464, 'de', '_MS_IMAGE_VERIFICATION_ALLOW', 'Gibt an, ob Bild überprüft werden kann (captcha)'),
(1465, 'es', '_MS_IS_SEND_DELAY', 'Especifica si se permite tiempo de retardo entre el envío de mensajes de correo electrónico'),
(1466, 'en', '_MS_IS_SEND_DELAY', 'Specifies whether to allow time delay between sending emails'),
(1467, 'de', '_MS_IS_SEND_DELAY', 'Gibt an, ob Zeitverzögerung zwischen E-Mails ermöglichen'),
(1468, 'es', '_MS_LISTINGS_NAME_LENGTH', 'Define una longitud de lista de nombre para mostrar en un bloque lateral (en caracteres)'),
(1469, 'en', '_MS_LISTINGS_NAME_LENGTH', 'Defines a length of display listing name in a side block (in chars)'),
(1470, 'de', '_MS_LISTINGS_NAME_LENGTH', 'Definiert eine Länge von Display-Liste Namen in einer Seitenstraße Block (in Zeichen)'),
(1471, 'es', '_MS_LISTINGS_PER_PAGE', 'Especifica un número máximo de anuncios que pueden aparecer en la página'),
(1472, 'en', '_MS_LISTINGS_PER_PAGE', 'Specifies a maximum number of listings that could be displayed on page'),
(1473, 'de', '_MS_LISTINGS_PER_PAGE', 'Legt die maximale Anzahl der Inserate, die auf Seite angezeigt werden können'),
(1474, 'es', '_MS_LIST_PRE_MODERATION_ALLOW', 'Especifica si se permite pre-moderación para los listados'),
(1475, 'en', '_MS_LIST_PRE_MODERATION_ALLOW', 'Specifies whether to allow pre-moderation for listings'),
(1476, 'de', '_MS_LIST_PRE_MODERATION_ALLOW', 'Gibt an, ob Pre-Moderation für Auflistungen ermöglichen'),
(1477, 'es', '_MS_MAXIMUM_ALLOWED_ORDERS', 'Especifica el número máximo permitido de las órdenes (no terminado) por cliente'),
(1478, 'en', '_MS_MAXIMUM_ALLOWED_ORDERS', 'Specifies the maximum number of allowed orders (not completed) per customer'),
(1479, 'de', '_MS_MAXIMUM_ALLOWED_ORDERS', 'Gibt die maximale Anzahl von erlaubten Befehle (nicht vollendet) pro Kunde'),
(1480, 'es', '_MS_NEWS_COUNT', 'Define el número de noticias se muestra en el bloque de noticias'),
(1481, 'en', '_MS_NEWS_COUNT', 'Defines how many news will be shown in news block'),
(1482, 'de', '_MS_NEWS_COUNT', 'Definiert, wie viele Nachrichten in Nachrichten-Block gezeigt werden'),
(1483, 'es', '_MS_NEWS_HEADER_LENGTH', 'Define una longitud de la cabecera de noticias en el bloque'),
(1484, 'en', '_MS_NEWS_HEADER_LENGTH', 'Defines a length of news header in block'),
(1485, 'de', '_MS_NEWS_HEADER_LENGTH', 'Definiert eine Länge von Nachrichten-Header in Block'),
(1486, 'es', '_MS_NEWS_RSS', 'Define el uso de los RSS de noticias'),
(1487, 'en', '_MS_NEWS_RSS', 'Defines using of RSS for news'),
(1488, 'de', '_MS_NEWS_RSS', 'Definiert mit der RSS für Nachrichten'),
(1489, 'es', '_MS_ONLINE_COLLECT_CREDIT_CARD', 'Especifica si se permite la recogida de información de tarjetas de crédito de ''Pedidos on-line'''),
(1490, 'en', '_MS_ONLINE_COLLECT_CREDIT_CARD', 'Specifies whether to allow collecting of credit card info for ''On-line Orders'''),
(1491, 'de', '_MS_ONLINE_COLLECT_CREDIT_CARD', 'Gibt an, ob das Sammeln von Kreditkartendaten für ''On-line Bestellungen'''),
(1492, 'es', '_MS_PAYMENTS_ACTIVE', 'Define si el módulo de pagos está activa o no'),
(1493, 'en', '_MS_PAYMENTS_ACTIVE', 'Defines whether payments module is active or not'),
(1494, 'de', '_MS_PAYMENTS_ACTIVE', 'Legt fest, ob Zahlungen Modul aktiv ist oder nicht'),
(1495, 'es', '_MS_PAYMENTS_MODE', 'Especifica en qué modo está activado para los pagos'),
(1496, 'en', '_MS_PAYMENTS_MODE', 'Specifies which mode is turned ON for payments'),
(1497, 'de', '_MS_PAYMENTS_MODE', 'Gibt an, welcher Modus wird für Zahlungen gedreht'),
(1498, 'es', '_MS_PAYMENT_METHOD_2CO', 'Especifica si se permite el método de CO ''2 ''de pago'),
(1499, 'en', '_MS_PAYMENT_METHOD_2CO', 'Specifies whether to allow ''2CO'' payment method'),
(1500, 'de', '_MS_PAYMENT_METHOD_2CO', 'Gibt an, ob ''2CO'' Zahlungsmethode ermöglichen'),
(1501, 'es', '_MS_PAYMENT_METHOD_AUTHORIZE', 'Especifica si se permite el método ''Authorize.Net de pago'),
(1502, 'en', '_MS_PAYMENT_METHOD_AUTHORIZE', 'Specifies whether to allow ''Authorize.Net'' payment method'),
(1503, 'de', '_MS_PAYMENT_METHOD_AUTHORIZE', 'Gibt an, ob "Authorize.Net" Zahlungsmethode'),
(1504, 'es', '_MS_PAYMENT_METHOD_ONLINE', 'Especifica si se permite el método ''on-line Orden de pago'),
(1505, 'en', '_MS_PAYMENT_METHOD_ONLINE', 'Specifies whether to allow ''On-line Order'' payment method'),
(1506, 'de', '_MS_PAYMENT_METHOD_ONLINE', 'Gibt an, ob ''On-line Bestellung'' Zahlungsart'),
(1507, 'es', '_MS_PAYMENT_METHOD_PAYPAL', 'Especifica si se permite ''PayPal'' método de pago'),
(1508, 'en', '_MS_PAYMENT_METHOD_PAYPAL', 'Specifies whether to allow ''PayPal'' payment method'),
(1509, 'de', '_MS_PAYMENT_METHOD_PAYPAL', 'Gibt an, ob ''PayPal'' Zahlungsmethode'),
(1510, 'es', '_MS_PAYMENT_TYPE_2CO', 'Especifica si se permite el tipo ''2 CO'' de pago'),
(1511, 'en', '_MS_PAYMENT_TYPE_2CO', 'Specifies whether to allow ''2CO'' payment type'),
(1512, 'de', '_MS_PAYMENT_TYPE_2CO', 'Gibt an, ob ''2 CO'' Zahlungsart ermöglichen'),
(1513, 'es', '_MS_PAYMENT_TYPE_AUTHORIZE', 'Especifica si se permite el tipo ''Authorize.Net'' de pago'),
(1514, 'en', '_MS_PAYMENT_TYPE_AUTHORIZE', 'Specifies whether to allow ''Authorize.Net'' payment type'),
(1515, 'de', '_MS_PAYMENT_TYPE_AUTHORIZE', 'Gibt an, ob ''Authorize.Net'' Art der Bezahlung'),
(1516, 'es', '_MS_PAYMENT_TYPE_ONLINE', 'Especifica si se permite el tipo ''on-line Orden'' de pago'),
(1517, 'en', '_MS_PAYMENT_TYPE_ONLINE', 'Specifies whether to allow ''On-line Order'' payment type'),
(1518, 'de', '_MS_PAYMENT_TYPE_ONLINE', 'Gibt an, ob ''On-line Bestellung'' Zahlungsart ermöglichen'),
(1519, 'es', '_MS_PAYMENT_TYPE_PAYPAL', 'Especifica si se permite ''PayPal'' tipo de pago'),
(1520, 'en', '_MS_PAYMENT_TYPE_PAYPAL', 'Specifies whether to allow ''PayPal'' payment type'),
(1521, 'de', '_MS_PAYMENT_TYPE_PAYPAL', 'Gibt an, ob ''PayPal'' Art der Bezahlung'),
(1522, 'es', '_MS_PAYPAL_EMAIL', 'Especifica PayPal (de negocios) de correo electrónico'),
(1523, 'en', '_MS_PAYPAL_EMAIL', 'Specifies PayPal (business) email '),
(1524, 'de', '_MS_PAYPAL_EMAIL', 'Gibt PayPal (Geschäft) E-Mail'),
(1525, 'es', '_MS_PRE_MODERATION_ALLOW', 'Especifica si se permite antes de la moderación de los comentarios'),
(1526, 'en', '_MS_PRE_MODERATION_ALLOW', 'Specifies whether to allow pre-moderation for comments'),
(1527, 'de', '_MS_PRE_MODERATION_ALLOW', 'Gibt an, ob Pre-Moderation für Kommentare zulassen'),
(1528, 'es', '_MS_REG_CONFIRMATION', 'Define si la confirmación (el tipo) es necesaria para la inscripción'),
(1529, 'en', '_MS_REG_CONFIRMATION', 'Defines whether confirmation (which type of) is required for registration'),
(1530, 'de', '_MS_REG_CONFIRMATION', 'Legt fest, ob die Bestätigung (welche Art) für die Anmeldung ist erforderlich'),
(1531, 'es', '_MS_REMEMBER_ME', 'Especifica si se permite Recordarme función'),
(1532, 'en', '_MS_REMEMBER_ME', 'Specifies whether to allow Remember Me feature'),
(1533, 'de', '_MS_REMEMBER_ME', 'Gibt an, ob Remember Me Funktion'),
(1534, 'es', '_MS_ROTATE_DELAY', 'Define retraso banners de rotación en cuestión de segundos'),
(1535, 'en', '_MS_ROTATE_DELAY', 'Defines banners rotation delay in seconds'),
(1536, 'de', '_MS_ROTATE_DELAY', 'Definiert Banner Rotation Verzögerung in Sekunden'),
(1537, 'es', '_MS_ROTATION_TYPE', 'Tipo de rotación de banners'),
(1538, 'en', '_MS_ROTATION_TYPE', 'Different type of banner rotation'),
(1539, 'de', '_MS_ROTATION_TYPE', 'Verschiedene Arten von Banner-Rotation'),
(1540, 'es', '_MS_SEND_ORDER_COPY_TO_ADMIN', 'Especifica si se permite el envío de una copia de la orden de admin'),
(1541, 'en', '_MS_SEND_ORDER_COPY_TO_ADMIN', 'Specifies whether to allow sending a copy of order to admin'),
(1542, 'de', '_MS_SEND_ORDER_COPY_TO_ADMIN', 'Gibt an, ob Sie eine Kopie, um admin'),
(1543, 'es', '_MS_SHOW_CATEGORIES_HOME_BLOCK', 'Especifica si se muestra bloque Categorías casa o no'),
(1544, 'en', '_MS_SHOW_CATEGORIES_HOME_BLOCK', 'Specifies whether to show Categories home block or not'),
(1545, 'de', '_MS_SHOW_CATEGORIES_HOME_BLOCK', 'Gibt an, ob Kategorien home blockieren oder nicht zeigen'),
(1546, 'es', '_MS_SHOW_CATEGORIES_SIDE_BLOCK', 'Especifica si se muestra bloque Categorías lado o no'),
(1547, 'en', '_MS_SHOW_CATEGORIES_SIDE_BLOCK', 'Specifies whether to show Categories side block or not'),
(1548, 'de', '_MS_SHOW_CATEGORIES_SIDE_BLOCK', 'Gibt an, ob Kategorien Seite blockieren oder nicht zeigen'),
(1549, 'es', '_MS_SHOW_DIRECTORY_STATISTICS', 'Especifica si se debe mostrar el directorio bloque lateral de Estadística o no'),
(1550, 'en', '_MS_SHOW_DIRECTORY_STATISTICS', 'Specifies whether to show Directory Statistics side block or not'),
(1551, 'de', '_MS_SHOW_DIRECTORY_STATISTICS', 'Gibt an, ob Directory-Statistik Seite blockieren oder nicht zeigen'),
(1552, 'es', '_MS_SHOW_EXPIRED_LISTINGS', 'Especifica si se muestran los listados de vencimiento hasta el Cron Job a cerrar o no'),
(1553, 'en', '_MS_SHOW_EXPIRED_LISTINGS', 'Specifies whether to show expired listings until Cron Job close them or not'),
(1554, 'de', '_MS_SHOW_EXPIRED_LISTINGS', 'Gibt an, ob abgelaufen Inserate zeigen, bis Cron Job zu schließen oder sie nicht'),
(1555, 'es', '_MS_SHOW_FEATURED_BLOCK', 'Especifica si se muestra bloque destacados lado listados o no'),
(1556, 'en', '_MS_SHOW_FEATURED_BLOCK', 'Specifies whether to show Featured Listings side block or not'),
(1557, 'de', '_MS_SHOW_FEATURED_BLOCK', 'Gibt an, ob zu zeigen Showcases Seite blockieren oder nicht'),
(1558, 'es', '_MS_SHOW_NEWSLETTER_SUBSCRIBE_BLOCK', 'Define si se debe mostrar bloque Suscripción al boletín o no'),
(1559, 'en', '_MS_SHOW_NEWSLETTER_SUBSCRIBE_BLOCK', 'Defines whether to show Newsletter Subscription block or not'),
(1560, 'de', '_MS_SHOW_NEWSLETTER_SUBSCRIBE_BLOCK', 'Legt fest, ob zur Newsletter-Anmeldung sperren oder nicht zeigen'),
(1561, 'es', '_MS_SHOW_NEWS_BLOCK', 'Define si se debe mostrar bloque Noticias lado o no'),
(1562, 'en', '_MS_SHOW_NEWS_BLOCK', 'Defines whether to show News side block or not'),
(1563, 'de', '_MS_SHOW_NEWS_BLOCK', 'Legt fest, ob zu News Seite sperren oder nicht zeigen'),
(1564, 'es', '_MS_SHOW_RECENT_BLOCK', 'Especifica si se muestra bloque recientes secundarios listados o no'),
(1565, 'en', '_MS_SHOW_RECENT_BLOCK', 'Specifies whether to show Recent Listings side block or not'),
(1566, 'de', '_MS_SHOW_RECENT_BLOCK', 'Gibt an, ob zu zeigen Neueste Anzeigen Seite blockieren oder nicht'),
(1567, 'es', '_MS_TWO_CHECKOUT_VENDOR', 'Especifica 2CO Vendor ID'),
(1568, 'en', '_MS_TWO_CHECKOUT_VENDOR', 'Specifies 2CO Vendor ID'),
(1569, 'de', '_MS_TWO_CHECKOUT_VENDOR', 'Gibt 2CO Vendor ID'),
(1570, 'es', '_MS_USER_TYPE', 'Tipo de usuarios, que pueden enviar comentarios'),
(1571, 'en', '_MS_USER_TYPE', 'Type of users, who can post comments'),
(1572, 'de', '_MS_USER_TYPE', 'Art der Benutzer kann die post comments'),
(1573, 'es', '_MS_VAT_VALUE', 'Especifica el valor predeterminado de IVA por el orden (en%)'),
(1574, 'en', '_MS_VAT_VALUE', 'Specifies default VAT value for order (in %)'),
(1575, 'de', '_MS_VAT_VALUE', 'Gibt standardmäßige MwSt. Preis-Leistungs-Ordnung (in%)'),
(1576, 'es', '_MS_VIDEO_GALLERY_TYPE', 'Tipos de animales Galería de Videos'),
(1577, 'en', '_MS_VIDEO_GALLERY_TYPE', 'Allowed types of Video Gallery'),
(1578, 'de', '_MS_VIDEO_GALLERY_TYPE', 'Erlaubt Arten von Video-Galerie'),
(1579, 'es', '_MUST_BE_LOGGED', 'Debe estar registrado para ver esta página! <a href=''index.php?customer=login''>Login</a> o <a href=''index.php?customer=create_account''>Crear una cuenta gratis</a>.'),
(1580, 'en', '_MUST_BE_LOGGED', 'You must be logged in to view this page! <a href=''index.php?customer=login''>Login</a> or <a href=''index.php?customer=create_account''>Create Account for free</a>.'),
(1581, 'de', '_MUST_BE_LOGGED', 'Sie müssen eingeloggt sein um diese Seite anzuzeigen! <a href=''index.php?customer=login''>Login</a> oder <a href=''index.php?customer=create_account''>Account erstellen kostenlos</a>.'),
(1582, 'es', '_MY_ACCOUNT', 'Mi Cuenta'),
(1583, 'en', '_MY_ACCOUNT', 'My Account'),
(1584, 'de', '_MY_ACCOUNT', 'Ihr Konto'),
(1585, 'es', '_MY_LISTINGS', 'Mis Listados'),
(1586, 'en', '_MY_LISTINGS', 'My Listings'),
(1587, 'de', '_MY_LISTINGS', 'Meine Einträge'),
(1588, 'es', '_MY_ORDERS', 'Mis pedidos'),
(1589, 'en', '_MY_ORDERS', 'My Orders'),
(1590, 'de', '_MY_ORDERS', 'Meine Bestellungen'),
(1591, 'es', '_NAME', 'Nombre'),
(1592, 'en', '_NAME', 'Name'),
(1593, 'de', '_NAME', 'Name'),
(1594, 'es', '_NEVER', 'nunca'),
(1595, 'en', '_NEVER', 'never'),
(1596, 'de', '_NEVER', 'nie'),
(1597, 'es', '_NEWS', 'Noticias'),
(1598, 'en', '_NEWS', 'News'),
(1599, 'de', '_NEWS', 'Nachrichten'),
(1600, 'es', '_NEWSLETTER_PAGE_TEXT', '<p>Para recibir boletines de noticias de nuestro sitio, simplemente introduzca su email y haga clic en el botón "Suscribirse".</p><p>Si posteriormente decide dejar su suscripción o cambiar el tipo de noticias que recibe, sólo tiene que seguir el enlace al final del último boletín de noticias y actualizar su perfil o darse de baja, marcando la casilla a continuación.</p>'),
(1601, 'en', '_NEWSLETTER_PAGE_TEXT', '<p>To receive newsletters from our site, simply enter your email and click on "Subscribe" button.</p><p>If you later decide to stop your subscription or change the type of news you receive, simply follow the link at the end of the latest newsletter and update your profile or unsubscribe by ticking the checkbox below.</p>'),
(1602, 'de', '_NEWSLETTER_PAGE_TEXT', '<p>Um Newsletter von unserer Website zu erhalten, geben Sie einfach Ihre Email und klicken Sie auf "Abonnieren"-Knopf. </p><p> Wenn Sie sich später entscheiden, um Ihr Abonnement beenden oder ändern Sie den Typ der Nachricht erhalten, folgen Sie einfach dem Link am Ende des aktuellen Newsletter und aktualisieren Sie Ihr Profil oder abbestellen, indem Sie das Kontrollkästchen unten.</p>'),
(1603, 'es', '_NEWSLETTER_PRE_SUBSCRIBE_ALERT', 'Por favor, haga clic en el botón "Suscribirse" para completar el proceso.'),
(1604, 'en', '_NEWSLETTER_PRE_SUBSCRIBE_ALERT', 'Please click on the "Subscribe" button to complete the process.'),
(1605, 'de', '_NEWSLETTER_PRE_SUBSCRIBE_ALERT', 'Bitte klicken Sie auf den "Abonnieren"-Knopf, um den Vorgang abzuschließen.'),
(1606, 'es', '_NEWSLETTER_PRE_UNSUBSCRIBE_ALERT', 'Por favor, haga clic en "Anular" para completar el proceso.'),
(1607, 'en', '_NEWSLETTER_PRE_UNSUBSCRIBE_ALERT', 'Please click on the "Unsubscribe" button to complete the process.'),
(1608, 'de', '_NEWSLETTER_PRE_UNSUBSCRIBE_ALERT', 'Bitte klicken Sie auf die Schaltfläche "Abmelden", um den Vorgang abzuschließen.'),
(1609, 'es', '_NEWSLETTER_SUBSCRIBERS', 'Suscriptores del boletín'),
(1610, 'en', '_NEWSLETTER_SUBSCRIBERS', 'Newsletter Subscribers'),
(1611, 'de', '_NEWSLETTER_SUBSCRIBERS', 'Newsletter-Abonnenten'),
(1612, 'es', '_NEWSLETTER_SUBSCRIBE_SUCCESS', 'Gracias por suscribirse a nuestro boletín electrónico. Usted recibirá un e-mail para confirmar su suscripción.'),
(1613, 'en', '_NEWSLETTER_SUBSCRIBE_SUCCESS', 'Thank you for subscribing to our electronic newsletter. You will receive an e-mail to confirm your subscription.'),
(1614, 'de', '_NEWSLETTER_SUBSCRIBE_SUCCESS', 'Danke für die Anmeldung zu unseren elektronischen Newsletter. Sie erhalten eine E-Mail, um Ihr Abonnement zu bestätigen.'),
(1615, 'es', '_NEWSLETTER_SUBSCRIBE_TEXT', '<p>Para recibir boletines de noticias de nuestro sitio, simplemente introduzca su email y haga clic en el botón "Suscribirse".</p><p>Si posteriormente decide dejar su suscripción o cambiar el tipo de noticias que recibe, sólo tiene que seguir el enlace al final del último boletín de noticias y actualizar su perfil o darse de baja, marcando la casilla a continuación.</p>'),
(1616, 'en', '_NEWSLETTER_SUBSCRIBE_TEXT', '<p>To receive newsletters from our site, simply enter your email and click on "Subscribe" button.</p><p>If you later decide to stop your subscription or change the type of news you receive, simply follow the link at the end of the latest newsletter and update your profile or unsubscribe by ticking the checkbox below.</p>'),
(1617, 'de', '_NEWSLETTER_SUBSCRIBE_TEXT', '<p>Um Newsletter von unserer Website zu erhalten, geben Sie einfach Ihre Email und klicken Sie auf "Abonnieren"-Knopf. </p><p> Wenn Sie sich später entscheiden, um Ihr Abonnement beenden oder ändern Sie den Typ der Nachricht erhalten, folgen Sie einfach dem Link am Ende des aktuellen Newsletter und aktualisieren Sie Ihr Profil oder abbestellen, indem Sie das Kontrollkästchen unten.</p>'),
(1618, 'es', '_NEWSLETTER_SUBSCRIPTION_MANAGEMENT', 'Boletín de administración de suscripciones'),
(1619, 'en', '_NEWSLETTER_SUBSCRIPTION_MANAGEMENT', 'Newsletter Subscription Management'),
(1620, 'de', '_NEWSLETTER_SUBSCRIPTION_MANAGEMENT', 'Newsletter-Abonnement-Verwaltung'),
(1621, 'es', '_NEWSLETTER_UNSUBSCRIBE_SUCCESS', 'Que han sido éxito de baja de nuestro boletín de noticias!'),
(1622, 'en', '_NEWSLETTER_UNSUBSCRIBE_SUCCESS', 'You have been successfully unsubscribed from our newsletter!'),
(1623, 'de', '_NEWSLETTER_UNSUBSCRIBE_SUCCESS', 'Sie haben sich erfolgreich von unserem Newsletter abgemeldet!'),
(1624, 'es', '_NEWSLETTER_UNSUBSCRIBE_TEXT', '<p>Para darse de baja de nuestros boletines, introduzca su dirección de correo electrónico y haga clic en el botón de darse de baja.</p>'),
(1625, 'en', '_NEWSLETTER_UNSUBSCRIBE_TEXT', '<p>To unsubscribe from our newsletters, enter your email address below and click the unsubscribe button.</p>'),
(1626, 'de', '_NEWSLETTER_UNSUBSCRIBE_TEXT', '<p>Um von unserem Newsletter abmelden, geben Sie Ihre E-Mail-Adresse ein und klicken Sie auf die Schaltfläche Abbestellen.</p>'),
(1627, 'es', '_NEWS_AND_EVENTS', 'Noticias y Eventos'),
(1628, 'en', '_NEWS_AND_EVENTS', 'News & Events'),
(1629, 'de', '_NEWS_AND_EVENTS', 'News & Events'),
(1630, 'es', '_NEWS_MANAGEMENT', 'Gestión de Noticias'),
(1631, 'en', '_NEWS_MANAGEMENT', 'News Management'),
(1632, 'de', '_NEWS_MANAGEMENT', 'News Management'),
(1633, 'es', '_NEWS_SETTINGS', 'Noticias Ajustes'),
(1634, 'en', '_NEWS_SETTINGS', 'News Settings'),
(1635, 'de', '_NEWS_SETTINGS', 'News Einstellungen'),
(1636, 'es', '_NEW_ARTICLE', 'Nuevo artículo'),
(1637, 'en', '_NEW_ARTICLE', 'New Article'),
(1638, 'de', '_NEW_ARTICLE', 'Neuer Artikel'),
(1639, 'es', '_NEW_SUBMISSION_IN_24H', 'Nueva presentación en 24 horas'),
(1640, 'en', '_NEW_SUBMISSION_IN_24H', 'New submission in 24h'),
(1641, 'de', '_NEW_SUBMISSION_IN_24H', 'New Vorlage in 24 Stunden'),
(1642, 'es', '_NO', 'No'),
(1643, 'en', '_NO', 'No'),
(1644, 'de', '_NO', 'Keine'),
(1645, 'es', '_NONE', 'Ninguno'),
(1646, 'en', '_NONE', 'None'),
(1647, 'de', '_NONE', 'keiner'),
(1648, 'es', '_NOTICE_MODULES_CODE', 'Para agregar módulos a disposición de esta página sólo tienes que copiar y pegar en el texto:'),
(1649, 'en', '_NOTICE_MODULES_CODE', 'To add available modules to this page just copy and paste into the text:'),
(1650, 'de', '_NOTICE_MODULES_CODE', 'So fügen verfügbaren Module, um diese Seite einfach kopieren und einfügen in den Text:'),
(1651, 'es', '_NOTIFICATION_MSG', 'Por favor, envíenme información acerca de actualizaciones, nuevos productos, ofertas especiales y descuentos!'),
(1652, 'en', '_NOTIFICATION_MSG', 'Please send me information about updates, new products, specials and discounts!'),
(1653, 'de', '_NOTIFICATION_MSG', 'Bitte senden Sie mir Informationen über Updates, neue Produkte, Sonderaktionen und Rabatte!'),
(1654, 'es', '_NOTIFICATION_STATUS_CHANGED', 'Estatuto de notificación cambiado'),
(1655, 'en', '_NOTIFICATION_STATUS_CHANGED', 'Notification status changed'),
(1656, 'de', '_NOTIFICATION_STATUS_CHANGED', 'Notification Status geändert'),
(1657, 'es', '_NOT_ALLOWED', 'No se admiten'),
(1658, 'en', '_NOT_ALLOWED', 'Not Allowed'),
(1659, 'de', '_NOT_ALLOWED', 'Nicht Erlaubt'),
(1660, 'es', '_NOT_AUTHORIZED', 'Usted no está autorizado a ver esta página.'),
(1661, 'en', '_NOT_AUTHORIZED', 'You are not authorized to view this page.'),
(1662, 'de', '_NOT_AUTHORIZED', 'Sie sind nicht berechtigt, diese Seite anzuzeigen.'),
(1663, 'es', '_NOT_AVAILABLE', 'N/A'),
(1664, 'en', '_NOT_AVAILABLE', 'N/A'),
(1665, 'de', '_NOT_AVAILABLE', 'N/A'),
(1666, 'es', '_NOVEMBER', 'Noviembre'),
(1667, 'en', '_NOVEMBER', 'November'),
(1668, 'de', '_NOVEMBER', 'November'),
(1669, 'es', '_NO_CATEGORIES_FOUND', 'No hay categorías que se encuentran!'),
(1670, 'en', '_NO_CATEGORIES_FOUND', 'No categories found!'),
(1671, 'de', '_NO_CATEGORIES_FOUND', 'Keine Kategorien gefunden!'),
(1672, 'es', '_NO_COMMENTS_YET', 'Todavía no hay comentarios.'),
(1673, 'en', '_NO_COMMENTS_YET', 'No comments yet.'),
(1674, 'de', '_NO_COMMENTS_YET', 'Noch keine Kommentare.'),
(1675, 'es', '_NO_LISTINGS_FOUND', 'No hay resultados que se encuentran en esta categoría!'),
(1676, 'en', '_NO_LISTINGS_FOUND', 'No listings found in this category!'),
(1677, 'de', '_NO_LISTINGS_FOUND', 'Keine Inserate in dieser Kategorie gefunden!'),
(1678, 'es', '_NO_LISTINGS_TO_DISPLAY', 'No hay anuncios para mostrar.'),
(1679, 'en', '_NO_LISTINGS_TO_DISPLAY', 'There are no listings to display.'),
(1680, 'de', '_NO_LISTINGS_TO_DISPLAY', 'Es gibt keine Inserate gefunden.'),
(1681, 'es', '_NO_NEWS', 'No hay noticias'),
(1682, 'en', '_NO_NEWS', 'No news'),
(1683, 'de', '_NO_NEWS', 'Keine Nachrichten'),
(1684, 'es', '_NO_PAYMENT_METHODS_ALERT', 'No hay métodos de pago disponibles! Por favor, póngase en contacto con nuestro soporte técnico.'),
(1685, 'en', '_NO_PAYMENT_METHODS_ALERT', 'No payment methods available! Please contact our technical support.'),
(1686, 'de', '_NO_PAYMENT_METHODS_ALERT', 'Keine Zahlungsmethoden zur Verfügung! Bitte kontaktieren Sie unseren technischen Support.'),
(1687, 'es', '_NO_PAYMENT_METHODS_AVAILABLE', 'No hay métodos de pago disponibles!'),
(1688, 'en', '_NO_PAYMENT_METHODS_AVAILABLE', 'No payment methods available!'),
(1689, 'de', '_NO_PAYMENT_METHODS_AVAILABLE', 'Keine Zahlungsmethoden zur Verfügung!'),
(1690, 'es', '_NO_RECORDS_FOUND', 'No se encontraron registros'),
(1691, 'en', '_NO_RECORDS_FOUND', 'No records found'),
(1692, 'de', '_NO_RECORDS_FOUND', 'Keine Datensätze gefunden'),
(1693, 'es', '_NO_RECORDS_UPDATED', 'No hay registros fueron actualizados!'),
(1694, 'en', '_NO_RECORDS_UPDATED', 'No records were updated!'),
(1695, 'de', '_NO_RECORDS_UPDATED', 'Keine Datensätze wurden aktualisiert!'),
(1696, 'es', '_NO_SUBCATEGORIES', 'No hay sub-categorías que se encuentran!'),
(1697, 'en', '_NO_SUBCATEGORIES', 'No sub-categories found!'),
(1698, 'de', '_NO_SUBCATEGORIES', 'Keine Sub-Kategorien gefunden!'),
(1699, 'es', '_NO_TEMPLATE', 'sin plantilla'),
(1700, 'en', '_NO_TEMPLATE', 'no template'),
(1701, 'de', '_NO_TEMPLATE', 'keine vorlage'),
(1702, 'es', '_NO_WRITE_ACCESS_ALERT', 'Por favor, compruebe que tiene acceso de escritura a las carpetas siguientes:'),
(1703, 'en', '_NO_WRITE_ACCESS_ALERT', 'Please check you have write access to following folders:'),
(1704, 'de', '_NO_WRITE_ACCESS_ALERT', 'Bitte überprüfen Sie Schreibzugriff auf die folgenden Ordner:'),
(1705, 'es', '_OCTOBER', 'Octubre'),
(1706, 'en', '_OCTOBER', 'October'),
(1707, 'de', '_OCTOBER', 'Oktober'),
(1708, 'es', '_OFF', 'Desc.'),
(1709, 'en', '_OFF', 'Off'),
(1710, 'de', '_OFF', 'aus'),
(1711, 'es', '_OFFLINE_LOGIN_ALERT', 'Para entrar en el panel de administración cuando el sitio está en línea, escriba en su navegador: http:// {your_site_address}/index.php?admin=login'),
(1712, 'en', '_OFFLINE_LOGIN_ALERT', 'To log into Admin Panel when site is offline, type in your browser: http://{your_site_address}/index.php?admin=login'),
(1713, 'de', '_OFFLINE_LOGIN_ALERT', 'So melden Sie sich beim Admin Panel Website offline ist, geben Sie in Ihrem Browser: {your_site_address}/index.php?admin=login'),
(1714, 'es', '_OFFLINE_MESSAGE', 'Mensaje Desconectado'),
(1715, 'en', '_OFFLINE_MESSAGE', 'Offline Message'),
(1716, 'de', '_OFFLINE_MESSAGE', 'Offline-Nachricht'),
(1717, 'es', '_ON', 'Activ.'),
(1718, 'en', '_ON', 'On'),
(1719, 'de', '_ON', 'an'),
(1720, 'es', '_ONLINE_ORDER', 'Orden en línea'),
(1721, 'en', '_ONLINE_ORDER', 'On-line Order'),
(1722, 'de', '_ONLINE_ORDER', 'On-line Bestellen'),
(1723, 'es', '_OPEN', 'Abrir'),
(1724, 'en', '_OPEN', 'Open'),
(1725, 'de', '_OPEN', 'Offen'),
(1726, 'es', '_OPEN_ALERT_WINDOW', 'Abra la ventana de alerta'),
(1727, 'en', '_OPEN_ALERT_WINDOW', 'Open Alert Window'),
(1728, 'de', '_OPEN_ALERT_WINDOW', 'Open Alert Window'),
(1729, 'es', '_OPERATION_BLOCKED', 'Esta operación está bloqueada en Versión Demo!'),
(1730, 'en', '_OPERATION_BLOCKED', 'This operation is blocked in Demo Version!'),
(1731, 'de', '_OPERATION_BLOCKED', 'Dieser Vorgang ist in der Demoversion gesperrt!'),
(1732, 'es', '_OPERATION_COMMON_COMPLETED', 'La operación se completó con éxito!'),
(1733, 'en', '_OPERATION_COMMON_COMPLETED', 'The operation has been successfully completed!'),
(1734, 'de', '_OPERATION_COMMON_COMPLETED', 'Die Operation wurde erfolgreich abgeschlossen!'),
(1735, 'es', '_OPERATION_WAS_ALREADY_COMPLETED', 'Esta operación ya se había terminado!'),
(1736, 'en', '_OPERATION_WAS_ALREADY_COMPLETED', 'This operation is already completed!'),
(1737, 'de', '_OPERATION_WAS_ALREADY_COMPLETED', 'Dieser Vorgang wurde bereits abgeschlossen!'),
(1738, 'es', '_OR', 'o'),
(1739, 'en', '_OR', 'or'),
(1740, 'de', '_OR', 'oder'),
(1741, 'es', '_ORDER', 'Orden'),
(1742, 'en', '_ORDER', 'Order'),
(1743, 'de', '_ORDER', 'Bestellen'),
(1744, 'es', '_ORDERS', 'Órdenes'),
(1745, 'en', '_ORDERS', 'Orders'),
(1746, 'de', '_ORDERS', 'Bestellungen'),
(1747, 'es', '_ORDERS_COUNT', 'Órdenes de contar'),
(1748, 'en', '_ORDERS_COUNT', 'Orders count'),
(1749, 'de', '_ORDERS_COUNT', 'Bestellungen rechnen'),
(1750, 'es', '_ORDERS_MANAGEMENT', 'Gestión de los pedidos'),
(1751, 'en', '_ORDERS_MANAGEMENT', 'Orders Management'),
(1752, 'de', '_ORDERS_MANAGEMENT', 'Bestellungen Management'),
(1753, 'es', '_ORDER_CANCELED', 'Pedido cancelado'),
(1754, 'en', '_ORDER_CANCELED', 'Order Canceled'),
(1755, 'de', '_ORDER_CANCELED', 'Bestellung storniert'),
(1756, 'es', '_ORDER_COMPLETED', 'Order Completo'),
(1757, 'en', '_ORDER_COMPLETED', 'Order Completed'),
(1758, 'de', '_ORDER_COMPLETED', 'Auftrag abgeschlossen'),
(1759, 'es', '_ORDER_DATE', 'Fecha del pedido'),
(1760, 'en', '_ORDER_DATE', 'Order Date'),
(1761, 'de', '_ORDER_DATE', 'Sortierung: Datum'),
(1762, 'es', '_ORDER_DESCRIPTION', 'Solicitar Descripción'),
(1763, 'en', '_ORDER_DESCRIPTION', 'Order Description'),
(1764, 'de', '_ORDER_DESCRIPTION', 'Auftrag Beschreibung'),
(1765, 'es', '_ORDER_DETAILS', 'Detalles de pedidos'),
(1766, 'en', '_ORDER_DETAILS', 'Order Details'),
(1767, 'de', '_ORDER_DETAILS', 'Um Details'),
(1768, 'es', '_ORDER_ERROR', 'No se puede completar su solicitud! Por favor, inténtelo de nuevo más tarde.'),
(1769, 'en', '_ORDER_ERROR', 'Cannot complete your order! Please try again later.'),
(1770, 'de', '_ORDER_ERROR', 'Kann nicht abgeschlossen werden Ihre Bestellung! Bitte versuchen Sie es später erneut.'),
(1771, 'es', '_ORDER_NUMBER', 'Número de orden'),
(1772, 'en', '_ORDER_NUMBER', 'Order number'),
(1773, 'de', '_ORDER_NUMBER', 'Bestell-Nummer'),
(1774, 'es', '_ORDER_PEPARING_ERROR', 'Se produjo un error mientras se prepara la orden! Por favor, inténtelo de nuevo más tarde.'),
(1775, 'en', '_ORDER_PEPARING_ERROR', 'An error occurred while preparing the order! Please try again later.'),
(1776, 'de', '_ORDER_PEPARING_ERROR', 'Ein Fehler trat bei der Vorbereitung der Bestellung! Bitte versuchen Sie es später erneut.'),
(1777, 'es', '_ORDER_PLACED_MSG', '¡Gracias! La orden fue aceptada y se procesan en breve.'),
(1778, 'en', '_ORDER_PLACED_MSG', 'Thank you! The order has been accepted and will be processed shortly.'),
(1779, 'de', '_ORDER_PLACED_MSG', 'Vielen Dank! Die Bestellung wurde angenommen und wird in Kürze bearbeitet werden.'),
(1780, 'es', '_ORDER_PRICE', 'Orden de precios'),
(1781, 'en', '_ORDER_PRICE', 'Order Price'),
(1782, 'de', '_ORDER_PRICE', 'Bestellen Preis'),
(1783, 'es', '_ORDER_WAS_CANCELED_MSG', 'Su pedido ha sido cancelado.'),
(1784, 'en', '_ORDER_WAS_CANCELED_MSG', 'Your order has been canceled.'),
(1785, 'de', '_ORDER_WAS_CANCELED_MSG', 'Ihre Bestellung wurde storniert.'),
(1786, 'es', '_ORDER_WAS_COMPLETED_MSG', 'Muchas gracias por comprar en nuestro sitio! Su pedido ha sido completado.'),
(1787, 'en', '_ORDER_WAS_COMPLETED_MSG', 'Thank you for purchasing from our site! Your order has been completed.'),
(1788, 'de', '_ORDER_WAS_COMPLETED_MSG', 'Danke für den Kauf von unserer Seite! Ihre Bestellung ist abgeschlossen.'),
(1789, 'es', '_OTHER', 'Otro'),
(1790, 'en', '_OTHER', 'Other'),
(1791, 'de', '_OTHER', 'Anderen'),
(1792, 'es', '_PAGE', 'Página'),
(1793, 'en', '_PAGE', 'Page'),
(1794, 'de', '_PAGE', 'Seite'),
(1795, 'es', '_PAGES', 'Páginas'),
(1796, 'en', '_PAGES', 'Pages'),
(1797, 'de', '_PAGES', 'Seiten'),
(1798, 'es', '_PAGE_ADD_NEW', 'Add New Page'),
(1799, 'en', '_PAGE_ADD_NEW', 'Add New Page'),
(1800, 'de', '_PAGE_ADD_NEW', 'Neue Seite hinzufügen'),
(1801, 'es', '_PAGE_CREATED', 'La página se ha creado correctamente'),
(1802, 'en', '_PAGE_CREATED', 'Page has been successfully created'),
(1803, 'de', '_PAGE_CREATED', 'Seite wurde erfolgreich erstellt'),
(1804, 'es', '_PAGE_DELETED', 'Page ha sido borrado'),
(1805, 'en', '_PAGE_DELETED', 'Page has been successfully deleted'),
(1806, 'de', '_PAGE_DELETED', 'Seite wurde erfolgreich gelöscht'),
(1807, 'es', '_PAGE_DELETE_WARNING', '¿Estás seguro de que deseas eliminar esta página?'),
(1808, 'en', '_PAGE_DELETE_WARNING', 'Are you sure you want to delete this page?'),
(1809, 'de', '_PAGE_DELETE_WARNING', 'Sind Sie sicher, dass Sie diese Seite wirklich löschen?'),
(1810, 'es', '_PAGE_EDIT_HOME', 'Editar Home Page'),
(1811, 'en', '_PAGE_EDIT_HOME', 'Edit Home Page'),
(1812, 'de', '_PAGE_EDIT_HOME', 'Bearbeiten Home Page'),
(1813, 'es', '_PAGE_EDIT_PAGES', 'Editar páginas'),
(1814, 'en', '_PAGE_EDIT_PAGES', 'Edit Pages'),
(1815, 'de', '_PAGE_EDIT_PAGES', 'Bearbeiten Seiten'),
(1816, 'es', '_PAGE_EDIT_SYS_PAGES', 'Editar páginas del sistema'),
(1817, 'en', '_PAGE_EDIT_SYS_PAGES', 'Edit System Pages'),
(1818, 'de', '_PAGE_EDIT_SYS_PAGES', 'Edit System Seiten'),
(1819, 'es', '_PAGE_EXPIRED', 'Página solicitada ha caducado!'),
(1820, 'en', '_PAGE_EXPIRED', 'The page you requested has expired!'),
(1821, 'de', '_PAGE_EXPIRED', 'Der von Ihnen angeforderte Seite ist abgelaufen!'),
(1822, 'es', '_PAGE_HEADER', 'Encabezado de página'),
(1823, 'en', '_PAGE_HEADER', 'Page Header'),
(1824, 'de', '_PAGE_HEADER', 'Seitenkopf'),
(1825, 'es', '_PAGE_HEADER_EMPTY', 'Cabecera de la página no puede estar vacía!'),
(1826, 'en', '_PAGE_HEADER_EMPTY', 'Page header cannot be empty!'),
(1827, 'de', '_PAGE_HEADER_EMPTY', 'Page Header kann nicht leer sein!'),
(1828, 'es', '_PAGE_KEY_EMPTY', 'Page clave no puede estar vacía!'),
(1829, 'en', '_PAGE_KEY_EMPTY', 'Page key cannot be empty!'),
(1830, 'de', '_PAGE_KEY_EMPTY', 'Page-Taste kann nicht leer sein!'),
(1831, 'es', '_PAGE_LINK_TOO_LONG', 'Enlace del menú demasiado tiempo!'),
(1832, 'en', '_PAGE_LINK_TOO_LONG', 'Menu link too long!'),
(1833, 'de', '_PAGE_LINK_TOO_LONG', 'Link Menu zu lang!'),
(1834, 'es', '_PAGE_MANAGEMENT', 'Páginas de Gestión de'),
(1835, 'en', '_PAGE_MANAGEMENT', 'Pages Management'),
(1836, 'de', '_PAGE_MANAGEMENT', 'Seiten-Management'),
(1837, 'es', '_PAGE_NOT_CREATED', 'La página no ha sido creado!'),
(1838, 'en', '_PAGE_NOT_CREATED', 'Page has not been created!'),
(1839, 'de', '_PAGE_NOT_CREATED', 'Seite wurde nicht erstellt!'),
(1840, 'es', '_PAGE_NOT_DELETED', 'La página no se ha eliminado!'),
(1841, 'en', '_PAGE_NOT_DELETED', 'Page has not been deleted!'),
(1842, 'de', '_PAGE_NOT_DELETED', 'Seite wurde nicht gelöscht!'),
(1843, 'es', '_PAGE_NOT_EXISTS', 'La página que intenta acceder no existe.'),
(1844, 'en', '_PAGE_NOT_EXISTS', 'The page you attempted to access does not exist.'),
(1845, 'de', '_PAGE_NOT_EXISTS', 'Die Seite, die Sie aufrufen wollten, existiert nicht.'),
(1846, 'es', '_PAGE_NOT_FOUND', 'No se han encontrado páginas'),
(1847, 'en', '_PAGE_NOT_FOUND', 'No Pages Found'),
(1848, 'de', '_PAGE_NOT_FOUND', 'Keine Seiten gefunden'),
(1849, 'es', '_PAGE_NOT_SAVED', 'La página no se salvó!'),
(1850, 'en', '_PAGE_NOT_SAVED', 'Page has not been saved!'),
(1851, 'de', '_PAGE_NOT_SAVED', 'Diese Seite wurde nicht gespart!'),
(1852, 'es', '_PAGE_ORDER_CHANGED', 'Orden de las páginas se ha cambiado correctamente!'),
(1853, 'en', '_PAGE_ORDER_CHANGED', 'Page order has been successfully changed!'),
(1854, 'de', '_PAGE_ORDER_CHANGED', 'Page Bestellung wurde erfolgreich geändert!'),
(1855, 'es', '_PAGE_REMOVED', 'Page se ha eliminado correctamente!'),
(1856, 'en', '_PAGE_REMOVED', 'Page has been successfully removed!'),
(1857, 'de', '_PAGE_REMOVED', 'Diese Seite wurde erfolgreich entfernt!'),
(1858, 'es', '_PAGE_REMOVE_WARNING', '¿Está seguro que desea mover este pagina a la papelera?'),
(1859, 'en', '_PAGE_REMOVE_WARNING', 'Are you sure you want move this page to the Trash?'),
(1860, 'de', '_PAGE_REMOVE_WARNING', 'Sie sind sicher, dass Sie bewegen Sie diese Seite in den Papierkorb?'),
(1861, 'es', '_PAGE_RESTORED', 'Page fue restaurado con éxito!'),
(1862, 'en', '_PAGE_RESTORED', 'Page has been successfully restored!'),
(1863, 'de', '_PAGE_RESTORED', 'Diese Seite wurde erfolgreich wiederhergestellt!'),
(1864, 'es', '_PAGE_RESTORE_WARNING', '¿Estás seguro de que desea restaurar esta página?'),
(1865, 'en', '_PAGE_RESTORE_WARNING', 'Are you sure you want to restore this page?'),
(1866, 'de', '_PAGE_RESTORE_WARNING', 'Sind Sie sicher, dass Sie diese Seite wiederherstellen?'),
(1867, 'es', '_PAGE_SAVED', 'La página se ha guardado correctamente'),
(1868, 'en', '_PAGE_SAVED', 'Page has been successfully saved'),
(1869, 'de', '_PAGE_SAVED', 'Diese Seite wurde erfolgreich gespeichert'),
(1870, 'es', '_PAGE_TEXT', 'Las páginas de texto'),
(1871, 'en', '_PAGE_TEXT', 'Page text'),
(1872, 'de', '_PAGE_TEXT', 'Seite Text'),
(1873, 'es', '_PAGE_UNKNOWN', 'Página desconocido!'),
(1874, 'en', '_PAGE_UNKNOWN', 'Unknown page!'),
(1875, 'de', '_PAGE_UNKNOWN', 'Unbekannte Seite!'),
(1876, 'es', '_PAID', 'Pagado'),
(1877, 'en', '_PAID', 'Paid'),
(1878, 'de', '_PAID', 'Bezahlt'),
(1879, 'es', '_PARAMETER', 'Parámetro'),
(1880, 'en', '_PARAMETER', 'Parameter'),
(1881, 'de', '_PARAMETER', 'Parameter'),
(1882, 'es', '_PASSWORD', 'Contraseña'),
(1883, 'en', '_PASSWORD', 'Password'),
(1884, 'de', '_PASSWORD', 'Kennwort'),
(1885, 'es', '_PASSWORD_ALREADY_SENT', 'Contraseña era ya ha sido enviada a su correo electrónico. Por favor, inténtelo de nuevo más tarde.'),
(1886, 'en', '_PASSWORD_ALREADY_SENT', 'Password was already sent to your email. Please try again later.'),
(1887, 'de', '_PASSWORD_ALREADY_SENT', 'Passwort wurde bereits auf Ihre E-Mail geschickt. Bitte versuchen Sie es später erneut.'),
(1888, 'es', '_PASSWORD_CHANGED', 'Contraseña ha cambiado.');
INSERT INTO `<DB_PREFIX>vocabulary` (`id`, `language_id`, `key_value`, `key_text`) VALUES
(1889, 'en', '_PASSWORD_CHANGED', 'Password has been changed.'),
(1890, 'de', '_PASSWORD_CHANGED', 'Passwort wurde geändert.'),
(1891, 'es', '_PASSWORD_DO_NOT_MATCH', 'Contraseña y la confirmación no coinciden!'),
(1892, 'en', '_PASSWORD_DO_NOT_MATCH', 'Password and confirmation do not match!'),
(1893, 'de', '_PASSWORD_DO_NOT_MATCH', 'Kennwort und Bestätigung stimmen nicht überein!'),
(1894, 'es', '_PASSWORD_FORGOTTEN', 'He olvidado la contraseña'),
(1895, 'en', '_PASSWORD_FORGOTTEN', 'Forgotten Password'),
(1896, 'de', '_PASSWORD_FORGOTTEN', 'Passwort vergessen?'),
(1897, 'es', '_PASSWORD_FORGOTTEN_PAGE_MSG', 'Utilice un administrador de correo electrónico válida para restablecer su contraseña en el Administrador de servicios de fondo. <br> Volver a la página<a href=''index.php''>Home Page</a><br><br><img align=''center'' src=''images/password.png'' alt='''' width=''92px''>\r\n'),
(1898, 'en', '_PASSWORD_FORGOTTEN_PAGE_MSG', 'Use a valid administrator e-mail to restore your password to the Administrator Back-End.<br><br>Return to site <a href=''index.php''>Home Page</a><br><br><img align=''center'' src=''images/password.png'' alt='''' width=''92px''>\r\n'),
(1899, 'de', '_PASSWORD_FORGOTTEN_PAGE_MSG', 'Verwenden Sie eine gültige E-Mail-Administrator das Passwort zum Administrator-Back-End zu wiederherzustellen.<br><br>Zurück zur Website <a href=''index.php''>Homepage</a>\r\n<br><br><img align=''center'' src=''images/password.png'' alt='''' width=''92px''>\r\n'),
(1900, 'es', '_PASSWORD_IS_EMPTY', 'Las contraseñas no deben estar vacías y por lo menos seis (6) caracteres de longitud!'),
(1901, 'en', '_PASSWORD_IS_EMPTY', 'Passwords must not be empty and at least six (6) characters in length!'),
(1902, 'de', '_PASSWORD_IS_EMPTY', 'Passwörter dürfen nicht leer sein und mindestens sechs (6) Zeichen lang sein!'),
(1903, 'es', '_PASSWORD_NOT_CHANGED', 'La contraseña no ha cambiado. Por favor, inténtelo de nuevo!'),
(1904, 'en', '_PASSWORD_NOT_CHANGED', 'Password has not been changed. Please try again!'),
(1905, 'de', '_PASSWORD_NOT_CHANGED', 'Passwort wurde nicht geändert. Bitte versuchen Sie es erneut!'),
(1906, 'es', '_PASSWORD_RECOVERY_MSG', 'Para recuperar su contraseña, por favor, introduzca su dirección de correo electrónico y un enlace será enviada a usted.'),
(1907, 'en', '_PASSWORD_RECOVERY_MSG', 'To recover your password, please enter your e-mail address and a link will be emailed to you.'),
(1908, 'de', '_PASSWORD_RECOVERY_MSG', 'Um Ihr Kennwort ein, geben Sie bitte Ihre E-Mail-Adresse und einem Link wird an Sie geschickt wird.'),
(1909, 'es', '_PASSWORD_SUCCESSFULLY_SENT', 'Su contraseña ha sido enviado con éxito a la dirección de correo electrónico.'),
(1910, 'en', '_PASSWORD_SUCCESSFULLY_SENT', 'Your password has been successfully sent to the email address.'),
(1911, 'de', '_PASSWORD_SUCCESSFULLY_SENT', 'Ihr Passwort wurde erfolgreich an die Email-Adresse gesendet.'),
(1912, 'es', '_PAYED_BY', 'Pagado por'),
(1913, 'en', '_PAYED_BY', 'Payed by'),
(1914, 'de', '_PAYED_BY', 'Bezahlt per'),
(1915, 'es', '_PAYMENTS', 'Pagos'),
(1916, 'en', '_PAYMENTS', 'Payments'),
(1917, 'de', '_PAYMENTS', 'Zahlungen'),
(1918, 'es', '_PAYMENTS_SETTINGS', 'Ajustes de Pago'),
(1919, 'en', '_PAYMENTS_SETTINGS', 'Payment Settings'),
(1920, 'de', '_PAYMENTS_SETTINGS', 'Payment-Einstellungen'),
(1921, 'es', '_PAYMENT_COMPANY_ACCOUNT', 'Pago de cuenta de la compañía'),
(1922, 'en', '_PAYMENT_COMPANY_ACCOUNT', 'Payment Company Account'),
(1923, 'de', '_PAYMENT_COMPANY_ACCOUNT', 'Zahlung Firmenkonto'),
(1924, 'es', '_PAYMENT_DATE', 'Fecha de Pago'),
(1925, 'en', '_PAYMENT_DATE', 'Payment Date'),
(1926, 'de', '_PAYMENT_DATE', 'Zahltag'),
(1927, 'es', '_PAYMENT_METHOD', 'Forma de Pago'),
(1928, 'en', '_PAYMENT_METHOD', 'Payment Method'),
(1929, 'de', '_PAYMENT_METHOD', 'Zahlungsweise'),
(1930, 'es', '_PAYMENT_SUM', 'Pago de Suma'),
(1931, 'en', '_PAYMENT_SUM', 'Payment Sum'),
(1932, 'de', '_PAYMENT_SUM', 'Die Zahlung Sum'),
(1933, 'es', '_PAYMENT_TYPE', 'Tipo de Pago'),
(1934, 'en', '_PAYMENT_TYPE', 'Payment Type'),
(1935, 'de', '_PAYMENT_TYPE', 'Zahlungsart'),
(1936, 'es', '_PAYPAL', 'PayPal'),
(1937, 'en', '_PAYPAL', 'PayPal'),
(1938, 'de', '_PAYPAL', 'PayPal'),
(1939, 'es', '_PAYPAL_NOTICE', 'Ahorre tiempo. Pague con seguridad con su información almacenada pago.<br /> Pago con <b>tarjeta de crédito</b>, <b> cuenta bancaria</b> o <b>PayPal</b> saldo de la cuenta.'),
(1940, 'en', '_PAYPAL_NOTICE', 'Save time. Pay securely using your stored payment information.<br />Pay with <b>credit card</b>, <b>bank account</b> or <b>PayPal</b> account balance.'),
(1941, 'de', '_PAYPAL_NOTICE', 'Sparen Sie Zeit. Sicher bezahlen mit Ihrer gespeicherten Zahlungsinformationen. <br />Bezahlen mit <b>Kreditkarte, Bankkonto</b> oder <b>PayPal-Guthaben.</b>'),
(1942, 'es', '_PAYPAL_ORDER', 'PayPal Orden'),
(1943, 'en', '_PAYPAL_ORDER', 'PayPal Order'),
(1944, 'de', '_PAYPAL_ORDER', 'PayPal Auftrag'),
(1945, 'es', '_PC_EVENT_TEXT', 'el título del evento'),
(1946, 'en', '_PC_EVENT_TEXT', 'the title of event'),
(1947, 'de', '_PC_EVENT_TEXT', 'der Titel der Veranstaltung'),
(1948, 'es', '_PC_FIRST_NAME_TEXT', 'el primer nombre de usuario o admin'),
(1949, 'en', '_PC_FIRST_NAME_TEXT', 'the first name of user or admin'),
(1950, 'de', '_PC_FIRST_NAME_TEXT', 'den Vornamen des Benutzers oder admin'),
(1951, 'es', '_PC_LAST_NAME_TEXT', 'el apellido del usuario o admin'),
(1952, 'en', '_PC_LAST_NAME_TEXT', 'the last name of user or admin'),
(1953, 'de', '_PC_LAST_NAME_TEXT', 'der Nachname des Benutzers oder admin'),
(1954, 'es', '_PC_LISTING_DETAILS_TEXT', 'información sobre la lista'),
(1955, 'en', '_PC_LISTING_DETAILS_TEXT', 'information about listing'),
(1956, 'de', '_PC_LISTING_DETAILS_TEXT', 'Informationen über die Auflistung'),
(1957, 'es', '_PC_ORDER_DETAILS_TEXT', 'información importante sobre el orden, la descripción del plan de publicidad, etc'),
(1958, 'en', '_PC_ORDER_DETAILS_TEXT', 'important information about the order, description of advertise plan etc.'),
(1959, 'de', '_PC_ORDER_DETAILS_TEXT', 'wichtige Informationen über die Reihenfolge, Beschreibung der Werbung Plan etc.'),
(1960, 'es', '_PC_ORDER_NUMBER_TEXT', 'el número de orden'),
(1961, 'en', '_PC_ORDER_NUMBER_TEXT', 'the number of order'),
(1962, 'de', '_PC_ORDER_NUMBER_TEXT', 'die Anzahl der Reihenfolge'),
(1963, 'es', '_PC_REGISTRATION_CODE_TEXT', 'código de confirmación para la nueva cuenta'),
(1964, 'en', '_PC_REGISTRATION_CODE_TEXT', 'confirmation code for new account'),
(1965, 'de', '_PC_REGISTRATION_CODE_TEXT', 'Bestätigungs-Code für neues Konto'),
(1966, 'es', '_PC_USER_EMAIL_TEXT', 'correo electrónico del usuario'),
(1967, 'en', '_PC_USER_EMAIL_TEXT', 'email of user'),
(1968, 'de', '_PC_USER_EMAIL_TEXT', 'E-Mail an Benutzer'),
(1969, 'es', '_PC_USER_NAME_TEXT', 'nombre de usuario (login) del usuario'),
(1970, 'en', '_PC_USER_NAME_TEXT', 'username (login) of user'),
(1971, 'de', '_PC_USER_NAME_TEXT', 'Benutzername (Login) des Benutzers'),
(1972, 'es', '_PC_USER_PASSWORD_TEXT', 'clave para el usuario o administrador'),
(1973, 'en', '_PC_USER_PASSWORD_TEXT', 'password for user or admin'),
(1974, 'de', '_PC_USER_PASSWORD_TEXT', 'Kennwort für den Benutzer oder Administrator'),
(1975, 'es', '_PC_WEB_SITE_BASED_URL_TEXT', 'sitio web, base de url'),
(1976, 'en', '_PC_WEB_SITE_BASED_URL_TEXT', 'web site base url'),
(1977, 'de', '_PC_WEB_SITE_BASED_URL_TEXT', 'Website Basis-URL'),
(1978, 'es', '_PC_WEB_SITE_URL_TEXT', 'URL del sitio web'),
(1979, 'en', '_PC_WEB_SITE_URL_TEXT', 'web site url'),
(1980, 'de', '_PC_WEB_SITE_URL_TEXT', 'Website eintragen'),
(1981, 'es', '_PC_YEAR_TEXT', 'del año en curso en formato AAAA'),
(1982, 'en', '_PC_YEAR_TEXT', 'current year in YYYY format'),
(1983, 'de', '_PC_YEAR_TEXT', 'laufenden Jahr im Format YYYY'),
(1984, 'es', '_PENDING', 'Pendiente'),
(1985, 'en', '_PENDING', 'Pending'),
(1986, 'de', '_PENDING', 'Anstehend'),
(1987, 'es', '_PERFORM_OPERATION_COMMON_ALERT', '¿Está seguro que desea llevar a cabo esta operación?'),
(1988, 'en', '_PERFORM_OPERATION_COMMON_ALERT', 'Are you sure you want to perform this operation?'),
(1989, 'de', '_PERFORM_OPERATION_COMMON_ALERT', 'Sie sind Sicher, dass. she Diesen Vorgang?'),
(1990, 'es', '_PERSONAL_DETAILS', 'Datos personales'),
(1991, 'en', '_PERSONAL_DETAILS', 'Personal Details'),
(1992, 'de', '_PERSONAL_DETAILS', 'Persönliche Daten'),
(1993, 'es', '_PERSONAL_INFORMATION', 'Información Personal'),
(1994, 'en', '_PERSONAL_INFORMATION', 'Personal Information'),
(1995, 'de', '_PERSONAL_INFORMATION', 'Persönliche Informationen'),
(1996, 'es', '_PHONE', 'Teléfono'),
(1997, 'en', '_PHONE', 'Phone'),
(1998, 'de', '_PHONE', 'Telefon'),
(1999, 'es', '_PLACEMENT', 'Colocación'),
(2000, 'en', '_PLACEMENT', 'Placement'),
(2001, 'de', '_PLACEMENT', 'Platzierung'),
(2002, 'es', '_PLACE_ORDER', 'Lugar Orden'),
(2003, 'en', '_PLACE_ORDER', 'Place Order'),
(2004, 'de', '_PLACE_ORDER', 'Bestellung aufgeben'),
(2005, 'es', '_PLAN', 'Plan'),
(2006, 'en', '_PLAN', 'Plan'),
(2007, 'de', '_PLAN', 'Plan'),
(2008, 'es', '_PLAY', 'Jugar'),
(2009, 'en', '_PLAY', 'Play'),
(2010, 'de', '_PLAY', 'Spielen'),
(2011, 'es', '_POPULARITY', 'Popularidad'),
(2012, 'en', '_POPULARITY', 'Popularity'),
(2013, 'de', '_POPULARITY', 'Beliebtheit'),
(2014, 'es', '_POPULAR_SEARCH', 'Popular Buscar'),
(2015, 'en', '_POPULAR_SEARCH', 'Popular Search'),
(2016, 'de', '_POPULAR_SEARCH', 'Beliebte Suchen'),
(2017, 'es', '_POSTED_ON', 'Publicado en'),
(2018, 'en', '_POSTED_ON', 'Posted on'),
(2019, 'de', '_POSTED_ON', 'Posted on'),
(2020, 'es', '_POST_COM_REGISTERED_ALERT', 'Su necesidad de estar registrado para enviar comentarios.'),
(2021, 'en', '_POST_COM_REGISTERED_ALERT', 'Your need to be registered to post comments.'),
(2022, 'de', '_POST_COM_REGISTERED_ALERT', 'Your need to be registered to post comments.'),
(2023, 'es', '_PREDEFINED_CONSTANTS', 'Constantes predefinidas'),
(2024, 'en', '_PREDEFINED_CONSTANTS', 'Predefined Constants'),
(2025, 'de', '_PREDEFINED_CONSTANTS', 'Vordefinierte Konstanten'),
(2026, 'es', '_PREFERRED_LANGUAGE', 'Idioma de preferencia'),
(2027, 'en', '_PREFERRED_LANGUAGE', 'Preferred Language'),
(2028, 'de', '_PREFERRED_LANGUAGE', 'Bevorzugte Sprache'),
(2029, 'es', '_PREPARING', 'Preparación'),
(2030, 'en', '_PREPARING', 'Preparing'),
(2031, 'de', '_PREPARING', 'Vorbereitung'),
(2032, 'es', '_PREPAYMENT', 'Pago por adelantado'),
(2033, 'en', '_PREPAYMENT', 'Prepayment'),
(2034, 'de', '_PREPAYMENT', 'Vorauszahlung'),
(2035, 'es', '_PREVIEW', 'Prevista'),
(2036, 'en', '_PREVIEW', 'Preview'),
(2037, 'de', '_PREVIEW', 'Vorschau'),
(2038, 'es', '_PRICE', 'Precio'),
(2039, 'en', '_PRICE', 'Price'),
(2040, 'de', '_PRICE', 'Preis'),
(2041, 'es', '_PRICE_FORMAT', 'Formato Precio'),
(2042, 'en', '_PRICE_FORMAT', 'Price Format'),
(2043, 'de', '_PRICE_FORMAT', 'Preis Format'),
(2044, 'es', '_PRICE_FORMAT_ALERT', 'Permite mostrar los precios de los visitantes en el formato adecuado'),
(2045, 'en', '_PRICE_FORMAT_ALERT', 'Allows to display prices for visitor in appropriate format'),
(2046, 'de', '_PRICE_FORMAT_ALERT', 'Ermöglicht die Preise für Besucher in geeigneter Form angezeigt werden'),
(2047, 'es', '_PRINT', 'Imprimir'),
(2048, 'en', '_PRINT', 'Print'),
(2049, 'de', '_PRINT', 'Drucken'),
(2050, 'es', '_PRIVILEGES', 'Privilegios'),
(2051, 'en', '_PRIVILEGES', 'Privileges'),
(2052, 'de', '_PRIVILEGES', 'Vorrechte'),
(2053, 'es', '_PRIVILEGES_MANAGEMENT', 'Privilegios de administración'),
(2054, 'en', '_PRIVILEGES_MANAGEMENT', 'Privileges Management'),
(2055, 'de', '_PRIVILEGES_MANAGEMENT', 'Privileges-Management'),
(2056, 'es', '_PRODUCTS', 'Productos'),
(2057, 'en', '_PRODUCTS', 'Products'),
(2058, 'de', '_PRODUCTS', 'Produkte'),
(2059, 'es', '_PRODUCTS_COUNT', 'Productos cuentan'),
(2060, 'en', '_PRODUCTS_COUNT', 'Products count'),
(2061, 'de', '_PRODUCTS_COUNT', 'Produkte zählen'),
(2062, 'es', '_PRODUCTS_MANAGEMENT', 'Productos para la administración'),
(2063, 'en', '_PRODUCTS_MANAGEMENT', 'Products Management'),
(2064, 'de', '_PRODUCTS_MANAGEMENT', 'Produkte Management'),
(2065, 'es', '_PRODUCT_DESCRIPTION', 'Descripción del producto'),
(2066, 'en', '_PRODUCT_DESCRIPTION', 'Product Description'),
(2067, 'de', '_PRODUCT_DESCRIPTION', 'Produkt-Beschreibung'),
(2068, 'es', '_PRODUCT_NOT_FOUND', 'El producto no se ha encontrado!'),
(2069, 'en', '_PRODUCT_NOT_FOUND', 'Product has not been found!'),
(2070, 'de', '_PRODUCT_NOT_FOUND', 'Produkt wurde nicht gefunden!'),
(2071, 'es', '_PUBLIC', 'Pública'),
(2072, 'en', '_PUBLIC', 'Public'),
(2073, 'de', '_PUBLIC', 'Öffentliche'),
(2074, 'es', '_PUBLISHED', 'Publicado'),
(2075, 'en', '_PUBLISHED', 'Published'),
(2076, 'de', '_PUBLISHED', 'Veröffentlicht'),
(2077, 'es', '_PUBLISH_YOUR_COMMENT', 'Publicar tu comentario'),
(2078, 'en', '_PUBLISH_YOUR_COMMENT', 'Publish your comment'),
(2079, 'de', '_PUBLISH_YOUR_COMMENT', 'Veröffentlichen she Ihren Kommentar'),
(2080, 'es', '_QUESTION', 'Pregunta'),
(2081, 'en', '_QUESTION', 'Question'),
(2082, 'de', '_QUESTION', 'Frage'),
(2083, 'es', '_QUESTIONS', 'Preguntas'),
(2084, 'en', '_QUESTIONS', 'Questions'),
(2085, 'de', '_QUESTIONS', 'Fragen'),
(2086, 'es', '_RATE', 'Tipo'),
(2087, 'en', '_RATE', 'Rate'),
(2088, 'de', '_RATE', 'Rate'),
(2089, 'es', '_REACTIVATION_EMAIL', 'Resend Activation Email'),
(2090, 'en', '_REACTIVATION_EMAIL', 'Reactivation Email'),
(2091, 'de', '_REACTIVATION_EMAIL', 'Aktivierungsmail erneut zuschicken'),
(2092, 'es', '_READ_MORE', 'Leer más'),
(2093, 'en', '_READ_MORE', 'Read more'),
(2094, 'de', '_READ_MORE', 'Lesen Sie mehr'),
(2095, 'es', '_REASON', 'Razón'),
(2096, 'en', '_REASON', 'Reason'),
(2097, 'de', '_REASON', 'Grund'),
(2098, 'es', '_RECALCULATE_LISTING_COUNT', 'Listados Recalcular Conde'),
(2099, 'en', '_RECALCULATE_LISTING_COUNT', 'Recalculate Listings Count'),
(2100, 'de', '_RECALCULATE_LISTING_COUNT', 'Anzeigen Neuberechnung Count'),
(2101, 'es', '_RECENT_LISTINGS', 'Listados Recientes'),
(2102, 'en', '_RECENT_LISTINGS', 'Recent Listings'),
(2103, 'de', '_RECENT_LISTINGS', 'Aktuelle Angebote'),
(2104, 'es', '_RED', 'Rojo'),
(2105, 'en', '_RED', 'Red'),
(2106, 'de', '_RED', 'rot'),
(2107, 'es', '_REFRESH', 'Refrescar'),
(2108, 'en', '_REFRESH', 'Refresh'),
(2109, 'de', '_REFRESH', 'erfrischen'),
(2110, 'es', '_REFUNDED', 'Devuelto'),
(2111, 'en', '_REFUNDED', 'Refunded'),
(2112, 'de', '_REFUNDED', 'Erstattet'),
(2113, 'es', '_REGISTERED', 'Registrado'),
(2114, 'en', '_REGISTERED', 'Registered'),
(2115, 'de', '_REGISTERED', 'registriert'),
(2116, 'es', '_REGISTERED_FROM_IP', 'Registradas a partir de la IP'),
(2117, 'en', '_REGISTERED_FROM_IP', 'Registered from IP'),
(2118, 'de', '_REGISTERED_FROM_IP', 'Einschreiben aus IP'),
(2119, 'es', '_REGISTRATIONS', 'Inscripciones'),
(2120, 'en', '_REGISTRATIONS', 'Registrations'),
(2121, 'de', '_REGISTRATIONS', 'anmeldungen'),
(2122, 'es', '_REGISTRATION_CODE', 'Código de registro'),
(2123, 'en', '_REGISTRATION_CODE', 'Registration code'),
(2124, 'de', '_REGISTRATION_CODE', 'Registrierungs-Code'),
(2125, 'es', '_REGISTRATION_CONFIRMATION', 'Confirmación de registro'),
(2126, 'en', '_REGISTRATION_CONFIRMATION', 'Registration Confirmation'),
(2127, 'de', '_REGISTRATION_CONFIRMATION', 'Anmeldebestätigung'),
(2128, 'es', '_REGISTRATION_FORM', 'Formulario de Inscripción'),
(2129, 'en', '_REGISTRATION_FORM', 'Registration Form'),
(2130, 'de', '_REGISTRATION_FORM', 'Anmeldeformular'),
(2131, 'es', '_REGISTRATION_NOT_COMPLETED', 'El proceso de registro aún no ha terminado! Por favor, compruebe de nuevo su correo electrónico para recibir instrucciones o haga clic en <a href=index.php?customer=resend_activation>aquí</a> para volver a enviar de nuevo.'),
(2132, 'en', '_REGISTRATION_NOT_COMPLETED', 'Your registration process is not yet complete! Please check again your email for further instructions or click <a href=index.php?customer=resend_activation>here</a> to resend them again.'),
(2133, 'de', '_REGISTRATION_NOT_COMPLETED', 'Ihre Registrierung ist noch nicht abgeschlossen! Bitte überprüfen Sie nochmals Ihre E-Mail für weitere Anweisungen oder klicken Sie <a href=index.php?customer=resend_activation>hier</a>, um erneut wieder.'),
(2134, 'es', '_REMEMBER_ME', 'Acuérdate de mí'),
(2135, 'en', '_REMEMBER_ME', 'Remember Me'),
(2136, 'de', '_REMEMBER_ME', 'Erinnere dich an mich'),
(2137, 'es', '_REMOVE', 'Eliminar'),
(2138, 'en', '_REMOVE', 'Remove'),
(2139, 'de', '_REMOVE', 'Entfernen'),
(2140, 'es', '_REMOVED', 'Eliminado'),
(2141, 'en', '_REMOVED', 'Removed'),
(2142, 'de', '_REMOVED', 'Entfernt'),
(2143, 'es', '_REMOVE_ACCOUNT', 'Quite la cuenta'),
(2144, 'en', '_REMOVE_ACCOUNT', 'Remove Account'),
(2145, 'de', '_REMOVE_ACCOUNT', 'Konto entfernen'),
(2146, 'es', '_REMOVE_ACCOUNT_ALERT', '¿Está seguro que desea eliminar su cuenta?'),
(2147, 'en', '_REMOVE_ACCOUNT_ALERT', 'Are you sure you want to remove your account?'),
(2148, 'de', '_REMOVE_ACCOUNT_ALERT', 'Sie sind sicher, dass Sie Ihr Konto entfernen?'),
(2149, 'es', '_REMOVE_ACCOUNT_WARNING', 'Si usted no piensa que va a utilizar este sitio de nuevo y le gustaría que su cuenta eliminada, nos podemos encargar de esto por usted. Tenga en cuenta, que no podrá reactivar su cuenta o recuperar cualquier contenido o información que se ha añadido. Si desea que su cuenta eliminada, a continuación, haga clic en el botón Quitar'),
(2150, 'en', '_REMOVE_ACCOUNT_WARNING', 'If you don''t think you will use this site again and would like your account deleted, we can take care of this for you. Keep in mind, that you will not be able to reactivate your account or retrieve any of the content or information that was added. If you would like your account deleted, then click Remove button'),
(2151, 'de', '_REMOVE_ACCOUNT_WARNING', 'Wenn Sie nicht glauben wollen, werden Sie diese Seite wieder zu verwenden und würden gerne Ihren Account gelöscht wird, können wir uns um diese für Sie. Denken Sie daran, dass Sie nicht in der Lage sein Ihr Konto zu reaktivieren oder abrufen des Inhalts oder Informationen, die hinzugefügt wurde. Wenn Sie möchten, Ihr Konto gelöscht wird, dann klicken Sie auf die Schaltfläche Entfernen'),
(2152, 'es', '_REMOVE_LAST_COUNTRY_ALERT', 'El país seleccionado no se ha eliminado, ya que debe tener al menos un país activo para un funcionamiento correcto del sitio!'),
(2153, 'en', '_REMOVE_LAST_COUNTRY_ALERT', 'The country selected has not been deleted, because you must have at least one active country for correct work of the site!'),
(2154, 'de', '_REMOVE_LAST_COUNTRY_ALERT', 'Das Land ausgewählt wurde nicht gelöscht, weil Sie mindestens ein aktives Land, um korrekte Arbeitsweise der Seite haben muss!'),
(2155, 'es', '_RESEND_ACTIVATION_EMAIL', 'Reenviar email de activación'),
(2156, 'en', '_RESEND_ACTIVATION_EMAIL', 'Resend Activation Email'),
(2157, 'de', '_RESEND_ACTIVATION_EMAIL', 'Aktivierungsmail erneut zuschicken'),
(2158, 'es', '_RESEND_ACTIVATION_EMAIL_MSG', 'Por favor, introduzca su dirección de correo electrónico continuación, haga clic en el botón Enviar. Usted recibirá el mensaje de activación en breve.'),
(2159, 'en', '_RESEND_ACTIVATION_EMAIL_MSG', 'Please enter your email address then click on Send button. You will receive the activation email shortly.'),
(2160, 'de', '_RESEND_ACTIVATION_EMAIL_MSG', 'Bitte geben Sie Ihre E-Mail-Adresse ein und klicken Sie auf Senden. Sie wird die Aktivierung per E-Mail zugesandt.'),
(2161, 'es', '_RESET', 'Restablecer'),
(2162, 'en', '_RESET', 'Reset'),
(2163, 'de', '_RESET', 'Reset'),
(2164, 'es', '_RESTORE', 'Restaurar'),
(2165, 'en', '_RESTORE', 'Restore'),
(2166, 'de', '_RESTORE', 'Wiederherstellen'),
(2167, 'es', '_RETYPE_PASSWORD', 'Volver a escribir contraseña'),
(2168, 'en', '_RETYPE_PASSWORD', 'Retype Password'),
(2169, 'de', '_RETYPE_PASSWORD', 'Passwort wiederholen'),
(2170, 'es', '_RIGHT', 'Derecho'),
(2171, 'en', '_RIGHT', 'Right'),
(2172, 'de', '_RIGHT', 'Recht'),
(2173, 'es', '_RIGHT_TO_LEFT', 'RTL (de derecha a izquierda)'),
(2174, 'en', '_RIGHT_TO_LEFT', 'RTL (right-to-left)'),
(2175, 'de', '_RIGHT_TO_LEFT', 'RTL (von rechts nach links)'),
(2176, 'es', '_ROLES_AND_PRIVILEGES', 'Los roles y privilegios'),
(2177, 'en', '_ROLES_AND_PRIVILEGES', 'Roles & Privileges'),
(2178, 'de', '_ROLES_AND_PRIVILEGES', 'Rollen und Zugriffsrechte'),
(2179, 'es', '_ROLES_MANAGEMENT', 'Funciones de administración'),
(2180, 'en', '_ROLES_MANAGEMENT', 'Roles Management'),
(2181, 'de', '_ROLES_MANAGEMENT', 'Rollen-Management'),
(2182, 'es', '_RSS_FEED_TYPE', 'RSS Feed Tipo'),
(2183, 'en', '_RSS_FEED_TYPE', 'RSS Feed Type'),
(2184, 'de', '_RSS_FEED_TYPE', 'RSS Feed-Typ'),
(2185, 'es', '_RSS_FILE_ERROR', 'No se puede abrir el archivo RSS para añadir el artículo nuevo! Por favor, compruebe sus derechos de acceso a <b>feeds/</b> del directorio o inténtelo de nuevo más tarde.'),
(2186, 'en', '_RSS_FILE_ERROR', 'Cannot open RSS file to add new item! Please check your access rights to <b>feeds/</b> directory or try again later.'),
(2187, 'de', '_RSS_FILE_ERROR', 'Kann nicht geöffnet werden RSS-Datei auf neues Element hinzufügen! Bitte überprüfen Sie Ihre Zugriffsrechte auf <b>feeds/</b> Verzeichnis oder versuchen Sie es später erneut.'),
(2188, 'es', '_RUN_CRON', 'Ejecutar cron'),
(2189, 'en', '_RUN_CRON', 'Run cron'),
(2190, 'de', '_RUN_CRON', 'Run cron'),
(2191, 'es', '_RUN_EVERY', 'Ejecutar cada'),
(2192, 'en', '_RUN_EVERY', 'Run every'),
(2193, 'de', '_RUN_EVERY', 'Führen Sie alle'),
(2194, 'es', '_SAID', 'dijo'),
(2195, 'en', '_SAID', 'said'),
(2196, 'de', '_SAID', 'sagte'),
(2197, 'es', '_SATURDAY', 'sábado'),
(2198, 'en', '_SATURDAY', 'Saturday'),
(2199, 'de', '_SATURDAY', 'Samstag'),
(2200, 'es', '_SEARCH', 'Búsqueda'),
(2201, 'en', '_SEARCH', 'Search'),
(2202, 'de', '_SEARCH', 'Suche'),
(2203, 'es', '_SEARCH_KEYWORDS', 'búsqueda'),
(2204, 'en', '_SEARCH_KEYWORDS', 'search keywords'),
(2205, 'de', '_SEARCH_KEYWORDS', 'Suchbegriffe'),
(2206, 'es', '_SEARCH_RESULT_FOR', 'Resultados de la búsqueda para'),
(2207, 'en', '_SEARCH_RESULT_FOR', 'Search Results for'),
(2208, 'de', '_SEARCH_RESULT_FOR', 'Suchergebnisse für'),
(2209, 'es', '_SEC', 'Seg'),
(2210, 'en', '_SEC', 'Sec'),
(2211, 'de', '_SEC', 'sec'),
(2212, 'es', '_SEE_ALL', 'Ver todos'),
(2213, 'en', '_SEE_ALL', 'See all'),
(2214, 'de', '_SEE_ALL', 'Alle'),
(2215, 'es', '_SELECT', 'Seleccione'),
(2216, 'en', '_SELECT', 'select'),
(2217, 'de', '_SELECT', 'wählen'),
(2218, 'es', '_SELECT_FILE_TO_UPLOAD', 'Seleccione un archivo para cargar'),
(2219, 'en', '_SELECT_FILE_TO_UPLOAD', 'Select a file to upload'),
(2220, 'de', '_SELECT_FILE_TO_UPLOAD', 'Wählen Sie eine Datei zum Hochladen'),
(2221, 'es', '_SELECT_LANG_TO_UPDATE', 'Seleccione un idioma para actualizar'),
(2222, 'en', '_SELECT_LANG_TO_UPDATE', 'Select a language to update'),
(2223, 'de', '_SELECT_LANG_TO_UPDATE', 'Wählen Sie eine Sprache zu aktualisieren'),
(2224, 'es', '_SEND', 'Enviar'),
(2225, 'en', '_SEND', 'Send'),
(2226, 'de', '_SEND', 'Senden'),
(2227, 'es', '_SENDING', 'Envío'),
(2228, 'en', '_SENDING', 'Sending'),
(2229, 'de', '_SENDING', 'Senden'),
(2230, 'es', '_SEND_COPY_TO_ADMIN', 'Enviar una copia al administrador'),
(2231, 'en', '_SEND_COPY_TO_ADMIN', 'Send a copy to admin'),
(2232, 'de', '_SEND_COPY_TO_ADMIN', 'Senden Einer kopie ein Admin'),
(2233, 'es', '_SEND_INVOICE', 'Enviar factura'),
(2234, 'en', '_SEND_INVOICE', 'Send Invoice'),
(2235, 'de', '_SEND_INVOICE', 'Senden Rechnung'),
(2236, 'es', '_SEO_LINKS_ALERT', 'Si selecciona esta opción, asegúrese de SEO Enlaces sin comentarios en la sección .haccess'),
(2237, 'en', '_SEO_LINKS_ALERT', 'If you select this option, make sure SEO Links Section uncommented in .htaccess file'),
(2238, 'de', '_SEO_LINKS_ALERT', 'Wenn Sie diese Option, um sicherzustellen, SEO Links Abschnitt unkommentiert in .htaccess-Datei'),
(2239, 'es', '_SEO_URLS', 'SEO URLs'),
(2240, 'en', '_SEO_URLS', 'SEO URLs'),
(2241, 'de', '_SEO_URLS', 'SEO URLs'),
(2242, 'es', '_SEPTEMBER', 'Septiembre'),
(2243, 'en', '_SEPTEMBER', 'September'),
(2244, 'de', '_SEPTEMBER', 'September'),
(2245, 'es', '_SERVER_INFO', 'Servidor de Información'),
(2246, 'en', '_SERVER_INFO', 'Server Info'),
(2247, 'de', '_SERVER_INFO', 'Server Info'),
(2248, 'es', '_SESSION_EXPIRED', 'Su sesión ha caducado! Por favor, ingresa de nuevo.'),
(2249, 'en', '_SESSION_EXPIRED', 'Your session has expired! Please login again.'),
(2250, 'de', '_SESSION_EXPIRED', 'Ihre Session ist abgelaufen! Bitte loggen Sie sich erneut.'),
(2251, 'es', '_SETTINGS', 'Configuración'),
(2252, 'en', '_SETTINGS', 'Settings'),
(2253, 'de', '_SETTINGS', 'Einstellungen'),
(2254, 'es', '_SETTINGS_SAVED', 'Los cambios fueron salvados! Por favor, actualice la <a href=''index.php''>Home Page</a> para ver los resultados.'),
(2255, 'en', '_SETTINGS_SAVED', 'Changes were saved! Please refresh the <a href=''index.php''>Home Page</a> to see the results.'),
(2256, 'de', '_SETTINGS_SAVED', 'Änderungen wurden gespeichert! Bitte aktualisieren Sie die <a href=index.php>Home Page</a> zu den Suchergebnissen finden Sie im.'),
(2257, 'es', '_SET_TIME', 'Ajuste de la hora'),
(2258, 'en', '_SET_TIME', 'Set Time'),
(2259, 'de', '_SET_TIME', 'Eingestellte Zeit'),
(2260, 'es', '_SHOW_IN_SEARCH', 'Ver en la búsqueda'),
(2261, 'en', '_SHOW_IN_SEARCH', 'Show in Search'),
(2262, 'de', '_SHOW_IN_SEARCH', 'Show auf der Suche'),
(2263, 'es', '_SHOW_META_TAGS', 'Mostrar Las etiquetas META'),
(2264, 'en', '_SHOW_META_TAGS', 'Show META tags'),
(2265, 'de', '_SHOW_META_TAGS', 'META-Tags anzeigen'),
(2266, 'es', '_SIMPLE', 'Simple'),
(2267, 'en', '_SIMPLE', 'Simple'),
(2268, 'de', '_SIMPLE', 'Einfache'),
(2269, 'es', '_SITE_DEVELOPMENT_MODE_ALERT', 'El sitio se está ejecutando en el modo de desarrollo! Para desactivarlo cambio <b>SITE_MODE</b> valor en <b>inc/settings.inc.php</b>'),
(2270, 'en', '_SITE_DEVELOPMENT_MODE_ALERT', 'The site is running in development mode! To turn it off change <b>SITE_MODE</b> value in <b>inc/settings.inc.php</b>'),
(2271, 'de', '_SITE_DEVELOPMENT_MODE_ALERT', 'Die Seite ist in Entwicklung Modus läuft! Um ihn auszuschalten ändern <b>SITE_MODE</b>-Wert in <b>inc/settings.inc.php</b>'),
(2272, 'es', '_SITE_INFO', 'Información del Sitio'),
(2273, 'en', '_SITE_INFO', 'Site Info'),
(2274, 'de', '_SITE_INFO', 'Website Info'),
(2275, 'es', '_SITE_OFFLINE', 'Sitio fuera de línea'),
(2276, 'en', '_SITE_OFFLINE', 'Site Offline'),
(2277, 'de', '_SITE_OFFLINE', 'Website offline'),
(2278, 'es', '_SITE_OFFLINE_ALERT', 'Seleccione si el acceso al Sitio Front-End está disponible. En caso afirmativo, el Front-End mostrará el mensaje siguiente:'),
(2279, 'en', '_SITE_OFFLINE_ALERT', 'Select whether access to the Site Front-End is available. If Yes, the Front-End will display the message below'),
(2280, 'de', '_SITE_OFFLINE_ALERT', 'Wählen Sie, ob der Zugriff auf die Site-Front-End zur Verfügung steht. Falls ja, wird die Front-End-Display die Meldung unten'),
(2281, 'es', '_SITE_OFFLINE_MESSAGE_ALERT', 'Un mensaje que aparece en el front-end si su sitio está en línea'),
(2282, 'en', '_SITE_OFFLINE_MESSAGE_ALERT', 'A message that displays in the Front-End if your site is offline'),
(2283, 'de', '_SITE_OFFLINE_MESSAGE_ALERT', 'Eine Nachricht, die Displays in der Front-End, wenn Ihre Website ist offline'),
(2284, 'es', '_SITE_PREVIEW', 'Sitio de vista preliminar'),
(2285, 'en', '_SITE_PREVIEW', 'Site Preview'),
(2286, 'de', '_SITE_PREVIEW', 'Website-Vorschau'),
(2287, 'es', '_SITE_RANKS', 'Sitio Ranks'),
(2288, 'en', '_SITE_RANKS', 'Site Ranks'),
(2289, 'de', '_SITE_RANKS', 'Website Reihen'),
(2290, 'es', '_SITE_RSS', 'RSS del sitio'),
(2291, 'en', '_SITE_RSS', 'Site RSS'),
(2292, 'de', '_SITE_RSS', 'Website RSS'),
(2293, 'es', '_SITE_SETTINGS', 'Configuración del sitio'),
(2294, 'en', '_SITE_SETTINGS', 'Site Settings'),
(2295, 'de', '_SITE_SETTINGS', 'Site-Einstellungen'),
(2296, 'es', '_SMTP_HOST', 'SMTP host'),
(2297, 'en', '_SMTP_HOST', 'SMTP Host'),
(2298, 'de', '_SMTP_HOST', 'SMTP-Host'),
(2299, 'es', '_SMTP_PORT', 'Puerto SMTP'),
(2300, 'en', '_SMTP_PORT', 'SMTP Port'),
(2301, 'de', '_SMTP_PORT', 'SMTP-Port'),
(2302, 'es', '_SORT_BY', 'Ordenar por'),
(2303, 'en', '_SORT_BY', 'Sort By'),
(2304, 'de', '_SORT_BY', 'Sortiert nach'),
(2305, 'es', '_STANDARD', 'Estándar'),
(2306, 'en', '_STANDARD', 'Standard'),
(2307, 'de', '_STANDARD', 'Standards'),
(2308, 'es', '_STATE', 'Estado'),
(2309, 'en', '_STATE', 'State'),
(2310, 'de', '_STATE', 'Zustand'),
(2311, 'es', '_STATE_PROVINCE', 'Estado/Provincia'),
(2312, 'en', '_STATE_PROVINCE', 'State/Province'),
(2313, 'de', '_STATE_PROVINCE', 'Staat/Provinz'),
(2314, 'es', '_STATISTICS', 'Estadística'),
(2315, 'en', '_STATISTICS', 'Statistics'),
(2316, 'de', '_STATISTICS', 'Statistik'),
(2317, 'es', '_STATUS', 'Estado'),
(2318, 'en', '_STATUS', 'Status'),
(2319, 'de', '_STATUS', 'Status'),
(2320, 'es', '_STATUS_CHANGED', 'Cambio en el estado'),
(2321, 'en', '_STATUS_CHANGED', 'Status Changed'),
(2322, 'de', '_STATUS_CHANGED', 'Status geändert'),
(2323, 'es', '_STOP', 'Detener'),
(2324, 'en', '_STOP', 'Stop'),
(2325, 'de', '_STOP', 'Stop'),
(2326, 'es', '_SUBJECT', 'Tema'),
(2327, 'en', '_SUBJECT', 'Subject'),
(2328, 'de', '_SUBJECT', 'Gegenstand'),
(2329, 'es', '_SUBJECT_EMPTY_ALERT', 'Sin perjuicio no puede estar vacío!'),
(2330, 'en', '_SUBJECT_EMPTY_ALERT', 'Subject cannot be empty!'),
(2331, 'de', '_SUBJECT_EMPTY_ALERT', 'Betreff darf nicht leer sein!'),
(2332, 'es', '_SUBMIT', 'Submit'),
(2333, 'en', '_SUBMIT', 'Submit'),
(2334, 'de', '_SUBMIT', 'Eintragen'),
(2335, 'es', '_SUBMITTED_FOR_MODERATION', 'Su registro ha sido sometido con éxito a la espera de ser revisados ​​por un moderador!'),
(2336, 'en', '_SUBMITTED_FOR_MODERATION', 'Your listing has been successfully submitted and waiting to be reviewed by a moderator!'),
(2337, 'de', '_SUBMITTED_FOR_MODERATION', 'Ihr Eintrag wurde erfolgreich eingereicht und warten darauf, von einem Moderator überprüft werden!'),
(2338, 'es', '_SUBMIT_PAYMENT', 'Presentar el pago'),
(2339, 'en', '_SUBMIT_PAYMENT', 'Submit Payment'),
(2340, 'de', '_SUBMIT_PAYMENT', 'Submit Zahlung'),
(2341, 'es', '_SUBSCRIBE', 'Suscribir'),
(2342, 'en', '_SUBSCRIBE', 'Subscribe'),
(2343, 'de', '_SUBSCRIBE', 'Zeichnen'),
(2344, 'es', '_SUBSCRIBE_EMAIL_EXISTS_ALERT', 'Alguien con el correo electrónico como ya se ha suscrito a nuestro boletín de noticias. Por favor, elija otra dirección de correo electrónico para la suscripción.'),
(2345, 'en', '_SUBSCRIBE_EMAIL_EXISTS_ALERT', 'Someone with such email has already been subscribed to our newsletter. Please choose another email address for subscription.'),
(2346, 'de', '_SUBSCRIBE_EMAIL_EXISTS_ALERT', 'Jemand mit einer solchen E-Mail hat schon unseren Newsletter abonniert worden. Bitte wählen Sie ein anderes E-Mail-Adresse zum Bezug anzubieten.'),
(2347, 'es', '_SUBSCRIBE_TO_NEWSLETTER', 'Suscríbete al boletín de noticias'),
(2348, 'en', '_SUBSCRIBE_TO_NEWSLETTER', 'Newsletter Subscription'),
(2349, 'de', '_SUBSCRIBE_TO_NEWSLETTER', 'Newsletter abonnieren'),
(2350, 'es', '_SUBSCRIPTION_ALREADY_SENT', 'Ya se ha suscrito a nuestro boletín. Por favor, inténtelo de nuevo más tarde o esperar unos segundos _WAIT_.'),
(2351, 'en', '_SUBSCRIPTION_ALREADY_SENT', 'You have already subscribed to our newsletter. Please try again later or wait _WAIT_ seconds.'),
(2352, 'de', '_SUBSCRIPTION_ALREADY_SENT', 'Sie haben bereits unseren Newsletter abonniert. Bitte versuchen Sie es später noch einmal oder warten _WAIT_ Sekunden.'),
(2353, 'es', '_SUBSCRIPTION_MANAGEMENT', 'De administración de suscripciones'),
(2354, 'en', '_SUBSCRIPTION_MANAGEMENT', 'Subscription Management'),
(2355, 'de', '_SUBSCRIPTION_MANAGEMENT', 'Abo-Verwaltung'),
(2356, 'es', '_SUBTOTAL', 'Total parcial'),
(2357, 'en', '_SUBTOTAL', 'Subtotal'),
(2358, 'de', '_SUBTOTAL', 'Zwischensumme'),
(2359, 'es', '_SUB_CATEGORIES', 'Sub-Categorías'),
(2360, 'en', '_SUB_CATEGORIES', 'Sub-Categories'),
(2361, 'de', '_SUB_CATEGORIES', 'Sub-Kategorien'),
(2362, 'es', '_SUNDAY', 'domingo'),
(2363, 'en', '_SUNDAY', 'Sunday'),
(2364, 'de', '_SUNDAY', 'Sonntag'),
(2365, 'es', '_SWITCH_TO_EXPORT', 'Cambiar a la exportación'),
(2366, 'en', '_SWITCH_TO_EXPORT', 'Switch to Export'),
(2367, 'de', '_SWITCH_TO_EXPORT', 'Schalter für den Export'),
(2368, 'es', '_SWITCH_TO_NORMAL', 'Cambiar a la normal'),
(2369, 'en', '_SWITCH_TO_NORMAL', 'Switch to Normal'),
(2370, 'de', '_SWITCH_TO_NORMAL', 'Wechseln Sie zur Normalansicht'),
(2371, 'es', '_SYMBOL', 'Símbolo'),
(2372, 'en', '_SYMBOL', 'Symbol'),
(2373, 'de', '_SYMBOL', 'Symbol'),
(2374, 'es', '_SYMBOL_PLACEMENT', 'Ubicación de Símbolo'),
(2375, 'en', '_SYMBOL_PLACEMENT', 'Symbol Placement'),
(2376, 'de', '_SYMBOL_PLACEMENT', 'Symbolplatzierung'),
(2377, 'es', '_SYSTEM', 'Sistema'),
(2378, 'en', '_SYSTEM', 'System'),
(2379, 'de', '_SYSTEM', 'System'),
(2380, 'es', '_SYSTEM_EMAIL_DELETE_ALERT', 'Esta plantilla de correo electrónico es utilizado por el sistema y no se puede eliminar!'),
(2381, 'en', '_SYSTEM_EMAIL_DELETE_ALERT', 'This email template is used by the system and cannot be deleted!'),
(2382, 'de', '_SYSTEM_EMAIL_DELETE_ALERT', 'Diese E-Mail-Vorlage wird durch das System verwendet und kann nicht gelöscht werden!'),
(2383, 'es', '_SYSTEM_MODULE', 'Módulo del Sistema'),
(2384, 'en', '_SYSTEM_MODULE', 'System Module'),
(2385, 'de', '_SYSTEM_MODULE', 'System-Modul'),
(2386, 'es', '_SYSTEM_MODULES', 'Sistema de Módulos'),
(2387, 'en', '_SYSTEM_MODULES', 'System Modules'),
(2388, 'de', '_SYSTEM_MODULES', 'System-Module'),
(2389, 'es', '_SYSTEM_MODULE_ACTIONS_BLOCKED', 'Todas las operaciones con el módulo del sistema están bloqueados!'),
(2390, 'en', '_SYSTEM_MODULE_ACTIONS_BLOCKED', 'All operations with system module are blocked!'),
(2391, 'de', '_SYSTEM_MODULE_ACTIONS_BLOCKED', 'Alle Operationen mit System-Modul blockiert sind!'),
(2392, 'es', '_SYSTEM_TEMPLATE', 'System plantilla'),
(2393, 'en', '_SYSTEM_TEMPLATE', 'System Template'),
(2394, 'de', '_SYSTEM_TEMPLATE', 'System Vorlage'),
(2395, 'es', '_TAG', 'Tag'),
(2396, 'en', '_TAG', 'Tag'),
(2397, 'de', '_TAG', 'Begriffe'),
(2398, 'es', '_TAG_TITLE_IS_EMPTY', '&lt;Title&gt; no puede estar vacío! Por favor, introduzca'),
(2399, 'en', '_TAG_TITLE_IS_EMPTY', 'Tag &lt;TITLE&gt; cannot be empty! Please re-enter.'),
(2400, 'de', '_TAG_TITLE_IS_EMPTY', '&lt;TITLE&gt; Tag nicht leer sein! Bitte erneut eingeben.'),
(2401, 'es', '_TARGET', 'Meta'),
(2402, 'en', '_TARGET', 'Target'),
(2403, 'de', '_TARGET', 'Ziel'),
(2404, 'es', '_TEMPLATES_STYLES', 'Plantillas y Estilos'),
(2405, 'en', '_TEMPLATES_STYLES', 'Templates & Styles'),
(2406, 'de', '_TEMPLATES_STYLES', 'Templates & Styles'),
(2407, 'es', '_TEMPLATE_CODE', 'Plantilla de código'),
(2408, 'en', '_TEMPLATE_CODE', 'Template code'),
(2409, 'de', '_TEMPLATE_CODE', 'Template-Code'),
(2410, 'es', '_TEMPLATE_IS_EMPTY', 'Plantilla no puede estar vacía! Por favor, vuelva a entrar.'),
(2411, 'en', '_TEMPLATE_IS_EMPTY', 'Template cannot be empty! Please re-enter.'),
(2412, 'de', '_TEMPLATE_IS_EMPTY', 'Vorlage kann nicht leer sein! Bitte erneut eingeben.'),
(2413, 'es', '_TEST_EMAIL', 'Prueba de correo electrónico'),
(2414, 'en', '_TEST_EMAIL', 'Test Email'),
(2415, 'de', '_TEST_EMAIL', 'Test-E-Mail'),
(2416, 'es', '_TEST_MODE_ALERT', 'Modo de prueba en el módulo de pago se pone en ON! Para cambiar <a actual, haga clic en el modo de href=index.php?admin=mod_payments_settings>aquí </a>.'),
(2417, 'en', '_TEST_MODE_ALERT', 'Test Mode in Payment Module is turned ON! To change current mode click <a href=index.php?admin=mod_payments_settings>here</a>.'),
(2418, 'de', '_TEST_MODE_ALERT', 'Testmodus in Zahlung Modul ist eingeschaltet! Um aktuelle Modus ändern, klicken Sie <a href=index.php?admin=mod_payments_settings>hier</a>.'),
(2419, 'es', '_TEST_MODE_ALERT_SHORT', 'Módulo de pago se está ejecutando en modo de prueba!'),
(2420, 'en', '_TEST_MODE_ALERT_SHORT', 'Payment Module is running in Test Mode!'),
(2421, 'de', '_TEST_MODE_ALERT_SHORT', 'Zahlung Modul wird im Test-Modus läuft!'),
(2422, 'es', '_TEXT', 'Texto'),
(2423, 'en', '_TEXT', 'Text'),
(2424, 'de', '_TEXT', 'Text'),
(2425, 'es', '_TEXT_DIRECTION_ALERT', 'Para Panel de Administración sólo'),
(2426, 'en', '_TEXT_DIRECTION_ALERT', 'For Administration Panel only'),
(2427, 'de', '_TEXT_DIRECTION_ALERT', 'Für Administration Panel nur'),
(2428, 'es', '_THUMBNAIL', 'Miniatura'),
(2429, 'en', '_THUMBNAIL', 'Thumbnail'),
(2430, 'de', '_THUMBNAIL', 'Vorschaubild'),
(2431, 'es', '_THURSDAY', 'jueves'),
(2432, 'en', '_THURSDAY', 'Thursday'),
(2433, 'de', '_THURSDAY', 'Donnerstag'),
(2434, 'es', '_TIME_ZONE', 'Zona horaria'),
(2435, 'en', '_TIME_ZONE', 'Time Zone'),
(2436, 'de', '_TIME_ZONE', 'Time Zone'),
(2437, 'es', '_TODAY', 'Hoy'),
(2438, 'en', '_TODAY', 'Today'),
(2439, 'de', '_TODAY', 'Heute'),
(2440, 'es', '_TOP', 'Superior'),
(2441, 'en', '_TOP', 'Top'),
(2442, 'de', '_TOP', 'Oben'),
(2443, 'es', '_TOTAL', 'Total'),
(2444, 'en', '_TOTAL', 'Total'),
(2445, 'de', '_TOTAL', 'Insgesamt'),
(2446, 'es', '_TOTAL_PRICE', 'Precio Total'),
(2447, 'en', '_TOTAL_PRICE', 'Total Price'),
(2448, 'de', '_TOTAL_PRICE', 'Gesamtpreis'),
(2449, 'es', '_TRANSACTION', 'Transacción'),
(2450, 'en', '_TRANSACTION', 'Transaction'),
(2451, 'de', '_TRANSACTION', 'Transaktion'),
(2452, 'es', '_TRANSLATE_VIA_GOOGLE', 'Traducir a través de Google'),
(2453, 'en', '_TRANSLATE_VIA_GOOGLE', 'Translate via Google'),
(2454, 'de', '_TRANSLATE_VIA_GOOGLE', 'Übersetzen mit Google'),
(2455, 'es', '_TRASH', 'Basura'),
(2456, 'en', '_TRASH', 'Trash'),
(2457, 'de', '_TRASH', 'Müll'),
(2458, 'es', '_TRASH_PAGES', 'Papelera Páginas'),
(2459, 'en', '_TRASH_PAGES', 'Trash Pages'),
(2460, 'de', '_TRASH_PAGES', 'Trash Seiten'),
(2461, 'es', '_TRUNCATE_RELATED_TABLES', 'Truncar tablas relacionadas?'),
(2462, 'en', '_TRUNCATE_RELATED_TABLES', 'Truncate related tables?'),
(2463, 'de', '_TRUNCATE_RELATED_TABLES', 'Truncate verknüpften Tabellen?'),
(2464, 'es', '_TRY_LATER', 'Se produjo un error mientras que la ejecución. Por favor, inténtelo de nuevo más tarde!'),
(2465, 'en', '_TRY_LATER', 'An error occurred while executing. Please try again later!'),
(2466, 'de', '_TRY_LATER', 'Ein Fehler Trat während der ausführung der Operation. Bitte versuchen Sie Es Noch Einmal später!'),
(2467, 'es', '_TUESDAY', 'martes'),
(2468, 'en', '_TUESDAY', 'Tuesday'),
(2469, 'de', '_TUESDAY', 'Dienstag'),
(2470, 'es', '_TYPE', 'Tipo'),
(2471, 'en', '_TYPE', 'Type'),
(2472, 'de', '_TYPE', 'Typ'),
(2473, 'es', '_TYPE_CHARS', 'Escriba los caracteres que ve en la imagen'),
(2474, 'en', '_TYPE_CHARS', 'Type the characters you see in the picture'),
(2475, 'de', '_TYPE_CHARS', 'Geben Sie die Zeichen im Bild sehen'),
(2476, 'es', '_UNCATEGORIZED', 'Hasta'),
(2477, 'en', '_UNCATEGORIZED', 'Uncategorized'),
(2478, 'de', '_UNCATEGORIZED', 'Uncategorized'),
(2479, 'es', '_UNDEFINED', 'Indefinido'),
(2480, 'en', '_UNDEFINED', 'Undefined'),
(2481, 'de', '_UNDEFINED', 'Undefiniert'),
(2482, 'es', '_UNINSTALL', 'Desinstalar'),
(2483, 'en', '_UNINSTALL', 'Uninstall'),
(2484, 'de', '_UNINSTALL', 'Deinstallieren'),
(2485, 'es', '_UNKNOWN', 'Desconocido'),
(2486, 'en', '_UNKNOWN', 'Unknown'),
(2487, 'de', '_UNKNOWN', 'Unbekannt'),
(2488, 'es', '_UNLIMITED', 'Ilimitado'),
(2489, 'en', '_UNLIMITED', 'Unlimited'),
(2490, 'de', '_UNLIMITED', 'Unbegrenzt'),
(2491, 'es', '_UNSUBSCRIBE', 'Darse de baja'),
(2492, 'en', '_UNSUBSCRIBE', 'Unsubscribe'),
(2493, 'de', '_UNSUBSCRIBE', 'Unsubscribe'),
(2494, 'es', '_UP', 'Arriba'),
(2495, 'en', '_UP', 'Up'),
(2496, 'de', '_UP', 'Bis'),
(2497, 'es', '_UPDATED_FOR_MODERATION', 'Su listado fue actualizado y en espera de ser revisados ​​por un moderador!'),
(2498, 'en', '_UPDATED_FOR_MODERATION', 'Your listing has been updated and waiting to be reviewed by a moderator!'),
(2499, 'de', '_UPDATED_FOR_MODERATION', 'Ihr Eintrag wurde aktualisiert und wartet darauf, von einem Moderator überprüft werden!'),
(2500, 'es', '_UPDATING_ACCOUNT_ERROR', 'Se produjo un error al actualizar su cuenta! Por favor, inténtelo de nuevo más tarde o enviar información sobre este error a la administración del sitio.'),
(2501, 'en', '_UPDATING_ACCOUNT_ERROR', 'An error occurred while updating your account! Please try again later or send information about this error to administration of the site.'),
(2502, 'de', '_UPDATING_ACCOUNT_ERROR', 'Fehler beim Aktualisieren Sie Ihr Konto! Bitte versuchen Sie es später noch einmal oder senden Sie Informationen zu diesem Fehler zur Verwaltung der Website.'),
(2503, 'es', '_UPDATING_OPERATION_COMPLETED', 'Actualización de la operación se completó con éxito!'),
(2504, 'en', '_UPDATING_OPERATION_COMPLETED', 'Updating operation has been successfully completed!'),
(2505, 'de', '_UPDATING_OPERATION_COMPLETED', 'Aktualisierung ist erfolgreich abgeschlossen!'),
(2506, 'es', '_UPLOAD', 'Cargar'),
(2507, 'en', '_UPLOAD', 'Upload'),
(2508, 'de', '_UPLOAD', 'Upload'),
(2509, 'es', '_UPLOAD_AND_PROCCESS', 'Subir y Proceso'),
(2510, 'en', '_UPLOAD_AND_PROCCESS', 'Upload and Process'),
(2511, 'de', '_UPLOAD_AND_PROCCESS', 'Upload-und Prozessmanagement'),
(2512, 'es', '_UPLOAD_FROM_FILE', 'Cargar desde archivo'),
(2513, 'en', '_UPLOAD_FROM_FILE', 'Upload from File'),
(2514, 'de', '_UPLOAD_FROM_FILE', 'Upload von Datei'),
(2515, 'es', '_URL', 'URL'),
(2516, 'en', '_URL', 'URL'),
(2517, 'de', '_URL', 'URL'),
(2518, 'es', '_USED_ON', 'Se utiliza en'),
(2519, 'en', '_USED_ON', 'Used On'),
(2520, 'de', '_USED_ON', 'Verwendet auf'),
(2521, 'es', '_USER', 'Usuario'),
(2522, 'en', '_USER', 'User'),
(2523, 'de', '_USER', 'Benutzer'),
(2524, 'es', '_USERNAME', 'Nombre de usuario'),
(2525, 'en', '_USERNAME', 'Username'),
(2526, 'de', '_USERNAME', 'Benutzername'),
(2527, 'es', '_USERNAME_AND_PASSWORD', 'Nombre de usuario y contraseña'),
(2528, 'en', '_USERNAME_AND_PASSWORD', 'Username & Password'),
(2529, 'de', '_USERNAME_AND_PASSWORD', 'Benutzername und Passwort'),
(2530, 'es', '_USERNAME_EMPTY_ALERT', 'Nombre de usuario no puede estar vacía! Por favor, vuelva a entrar.'),
(2531, 'en', '_USERNAME_EMPTY_ALERT', 'Username cannot be empty! Please re-enter.'),
(2532, 'de', '_USERNAME_EMPTY_ALERT', 'Benutzername darf nicht leer sein! Bitte erneut eingeben.'),
(2533, 'es', '_USERNAME_LENGTH_ALERT', 'La longitud de nombre de usuario no puede ser menos de 4 caracteres! Por favor, vuelva a entrar.'),
(2534, 'en', '_USERNAME_LENGTH_ALERT', 'The length of username cannot be less than 4 characters! Please re-enter.'),
(2535, 'de', '_USERNAME_LENGTH_ALERT', 'Die Länge der Benutzername darf nicht weniger als 4 Zeichen! Bitte erneut eingeben.'),
(2536, 'es', '_USERS', 'Usuarios'),
(2537, 'en', '_USERS', 'Users'),
(2538, 'de', '_USERS', 'Benutzer'),
(2539, 'es', '_USERS_MANAGEMENT', 'Gestión de Usuarios'),
(2540, 'en', '_USERS_MANAGEMENT', 'Users Management'),
(2541, 'de', '_USERS_MANAGEMENT', 'Benutzer-Management'),
(2542, 'es', '_USERS_SETTINGS', 'Configuración de usuario'),
(2543, 'en', '_USERS_SETTINGS', 'Users Settings'),
(2544, 'de', '_USERS_SETTINGS', 'Benutzer-Einstellungen'),
(2545, 'es', '_USER_EMAIL_EXISTS_ALERT', 'Usuario con el correo electrónico ya existe! Por favor seleccione otro.'),
(2546, 'en', '_USER_EMAIL_EXISTS_ALERT', 'User with such email already exists! Please choose another.'),
(2547, 'de', '_USER_EMAIL_EXISTS_ALERT', 'User mit solchen E-Mail ist bereits vorhanden! Bitte wählen Sie einen anderen.'),
(2548, 'es', '_USER_EXISTS_ALERT', 'Usuario con nombre de usuario ya existe! Por favor seleccione otro.'),
(2549, 'en', '_USER_EXISTS_ALERT', 'User with such username already exists! Please choose another.'),
(2550, 'de', '_USER_EXISTS_ALERT', 'User mit solchen Benutzername existiert bereits! Bitte wählen Sie einen anderen.'),
(2551, 'es', '_USER_GROUP', 'Grupo de Usuarios'),
(2552, 'en', '_USER_GROUP', 'User Group'),
(2553, 'de', '_USER_GROUP', 'Benutzergruppe'),
(2554, 'es', '_USER_GROUPS', 'Grupos de usuario'),
(2555, 'en', '_USER_GROUPS', 'User Groups'),
(2556, 'de', '_USER_GROUPS', 'Benutzergruppen'),
(2557, 'es', '_USER_LOGIN', 'Registro de usuarios'),
(2558, 'en', '_USER_LOGIN', 'User Login'),
(2559, 'de', '_USER_LOGIN', 'Benutzeranmeldung'),
(2560, 'es', '_USER_NAME', 'Nombre de usuario'),
(2561, 'en', '_USER_NAME', 'User name'),
(2562, 'de', '_USER_NAME', 'Benutzername'),
(2563, 'es', '_VALUE', 'Valor'),
(2564, 'en', '_VALUE', 'Value'),
(2565, 'de', '_VALUE', 'Wert'),
(2566, 'es', '_VAT', 'IVA'),
(2567, 'en', '_VAT', 'VAT'),
(2568, 'de', '_VAT', 'Mehrwertsteuer'),
(2569, 'es', '_VERSION', 'Versión'),
(2570, 'en', '_VERSION', 'Version'),
(2571, 'de', '_VERSION', 'Version'),
(2572, 'es', '_VIDEO', 'Video'),
(2573, 'en', '_VIDEO', 'Video'),
(2574, 'de', '_VIDEO', 'Video'),
(2575, 'es', '_VIEW_LISTINGS', 'Vea el listado'),
(2576, 'en', '_VIEW_LISTINGS', 'View Listings'),
(2577, 'de', '_VIEW_LISTINGS', 'Angebote ansehen'),
(2578, 'es', '_VIEW_WORD', 'Ver'),
(2579, 'en', '_VIEW_WORD', 'View'),
(2580, 'de', '_VIEW_WORD', 'Blick'),
(2581, 'es', '_VISUAL_SETTINGS', 'Ajustes Visual'),
(2582, 'en', '_VISUAL_SETTINGS', 'Visual Settings'),
(2583, 'de', '_VISUAL_SETTINGS', 'Visuelle Einstellungen'),
(2584, 'es', '_VOCABULARY', 'Vocabulario'),
(2585, 'en', '_VOCABULARY', 'Vocabulary'),
(2586, 'de', '_VOCABULARY', 'Wortschatz'),
(2587, 'es', '_VOC_KEYS_UPDATED', 'La operación se completó con éxito. Actualización: claves _KEYS_. Haga clic en href=''index.php?admin=vocabulary&filter_by=A''>aquí</a> para volver a cargar el sitio.'),
(2588, 'en', '_VOC_KEYS_UPDATED', 'Operation has been successfully completed. Updated: _KEYS_ keys. Click <a href=''index.php?admin=vocabulary&filter_by=A''>here</a> to refresh the site.'),
(2589, 'de', '_VOC_KEYS_UPDATED', 'Operation wurde erfolgreich abgeschlossen. Aktualisiert: _KEYS_ Tasten. Klicken Sie <a href=''index.php?admin=vocabulary&filter_by=A''>hier</a>, um die Website zu aktualisieren.'),
(2590, 'es', '_VOC_KEY_UPDATED', 'Vocabulario clave se ha actualizado correctamente.'),
(2591, 'en', '_VOC_KEY_UPDATED', 'Vocabulary key has been successfully updated.'),
(2592, 'de', '_VOC_KEY_UPDATED', 'Wortschatz Schlüssel wurde erfolgreich aktualisiert.'),
(2593, 'es', '_VOC_KEY_VALUE_EMPTY', 'Valor de la clave no puede estar vacía! Por favor, vuelva a entrar.'),
(2594, 'en', '_VOC_KEY_VALUE_EMPTY', 'Key value cannot be empty! Please re-enter.'),
(2595, 'de', '_VOC_KEY_VALUE_EMPTY', 'Key-Wert darf nicht leer sein! Bitte erneut eingeben.'),
(2596, 'es', '_VOC_NOT_FOUND', 'No hay teclas que se encuentran'),
(2597, 'en', '_VOC_NOT_FOUND', 'No keys found'),
(2598, 'de', '_VOC_NOT_FOUND', 'Kein Schlüssel gefunden'),
(2599, 'es', '_VOC_UPDATED', 'Vocabulario se ha actualizado correctamente. Haga clic <a href=''index.php''>aquí</a> para actualizar el sitio.'),
(2600, 'en', '_VOC_UPDATED', 'Vocabulary has been successfully updated. Click <a href=''index.php''>here</a> to refresh the site.'),
(2601, 'de', '_VOC_UPDATED', 'Wortschatz wurde erfolgreich aktualisiert. Klicken Sie <a href=index.php>hier</a>, um Website aktualisieren.'),
(2602, 'es', '_WEBSITE_URL', 'URL del sitio web'),
(2603, 'en', '_WEBSITE_URL', 'Website URL'),
(2604, 'de', '_WEBSITE_URL', 'Website-URL'),
(2605, 'es', '_WEB_SITE', 'Sitio Web'),
(2606, 'en', '_WEB_SITE', 'Web Site'),
(2607, 'de', '_WEB_SITE', 'Web-Site'),
(2608, 'es', '_WEDNESDAY', 'miércoles'),
(2609, 'en', '_WEDNESDAY', 'Wednesday'),
(2610, 'de', '_WEDNESDAY', 'Mittwoch'),
(2611, 'es', '_WELCOME_ADMIN', 'Bienvenido a Panel de Administración!'),
(2612, 'en', '_WELCOME_ADMIN', 'welcome to Admin Panel!'),
(2613, 'de', '_WELCOME_ADMIN', 'Willkommen auf dem Admin Panel!'),
(2614, 'es', '_WELCOME_CUSTOMER_TEXT', '<p>Hola <b>_FIRST_NAME_ _LAST_NAME_</b></p>\r\n<p>Bienvenido al Grupo de cuenta del cliente, que le permite ver el estado de cuenta de gestión de la configuración de su cuenta, listados, etc</p>\r\n<p>_TODAY_<br />_LAST_LOGIN_</p>\r\n<p><b>&#8226;</b>Para ver este resumen de cuenta basta con hacer clic en un <a href=''index.php?customer=home''>_HOME_</a> enlace.</p>\r\n<p><b>&#8226;</b><a href=''index.php?customer=my_account''>_EDIT_MY_ACCOUNT_</a> de menú que permite cambiar su información personal y datos de la cuenta.</p> <p><b>&#8226;</b> <a href=''index.php?customer=my_listings''>_MY_LISTINGS_</a> contiene información acerca de los anuncios.</p>\r\n_ORDERS_PAGE_DESCR_\r\n_INQUIRIES_PAGE_DESCR_'),
(2615, 'en', '_WELCOME_CUSTOMER_TEXT', '<p>Hello <b>_FIRST_NAME_ _LAST_NAME_</b>!</p>\r\n<p>Welcome to Customer''s Account Panel, that allows you to view account status, manage your account settings, listings etc.</p>\r\n<p>_TODAY_<br />_LAST_LOGIN_</p>	\r\n<p><b>&#8226;</b> To view this account summary just click on a <a href=''index.php?customer=home''>_HOME_</a> link.</p>\r\n<p><b>&#8226;</b> <a href=''index.php?customer=my_account''>_EDIT_MY_ACCOUNT_</a> menu allows you to change your personal info and account data.</p>\r\n<p><b>&#8226;</b> <a href=''index.php?customer=my_listings''>_MY_LISTINGS_</a> contains information about your listings.</p>\r\n<p><b>&#8226;</b> On <a href=''index.php?customer=advertise''>_ADVERTISE_</a> page you can purchase listings using various advertise plans.</p>\r\n_ORDERS_PAGE_DESCR_\r\n_INQUIRIES_PAGE_DESCR_'),
(2616, 'de', '_WELCOME_CUSTOMER_TEXT', '<p>Hallo <b>_FIRST_NAME_ _LAST_NAME_</b></p>\r\n<p>Willkommen auf das Konto des Kunden Panel, die Sie verändern den Status anzeigen können, verwalten Sie Ihre Account-Einstellungen, Inserate usw.</p>\r\n<p>_TODAY_<br />_LAST_LOGIN_</p>\r\n<p><b>&#8226;</b> Um dieses Konto Zusammenfassung nur auf einem <a klicken href=''index.php?customer=home''> _HOME_</a> Link.</p><p><b>&#8226;</b> <a href=''index.php?customer=my_account''>_EDIT_MY_ACCOUNT_</a> Menü können Sie Ihre persönlichen Daten und Kontodaten zu ändern.</p> <p><b>&#8226;</b> <a href=''index.php?customer=my_listings''>_MY_LISTINGS_</a> enthält Informationen über Ihre Angebote.</p>\r\n<p><b>&#8226;</b> Auf <a href=''index.php?customer=advertise''>_ADVERTISE_</a> können Sie sich zu werben Liste mit verschiedenen Pläne zu erwerben.</p>\r\n_ORDERS_PAGE_DESCR_\r\n_INQUIRIES_PAGE_DESCR_'),
(2617, 'es', '_WHAT_IS_CVV', 'Qué es el CVV'),
(2618, 'en', '_WHAT_IS_CVV', 'What is CVV'),
(2619, 'de', '_WHAT_IS_CVV', 'Was ist CVV'),
(2620, 'es', '_WHOLE_SITE', 'Todo el sitio web'),
(2621, 'en', '_WHOLE_SITE', 'Whole site'),
(2622, 'de', '_WHOLE_SITE', 'Ganze Web-Site'),
(2623, 'es', '_WRONG_CODE_ALERT', 'Lo sentimos, el código que ha introducido no es válido! Por favor, inténtelo de nuevo.'),
(2624, 'en', '_WRONG_CODE_ALERT', 'Sorry, the code you have entered is invalid! Please try again.'),
(2625, 'de', '_WRONG_CODE_ALERT', 'Leider war der Code, den Sie eingegeben haben ungültig! Bitte versuchen Sie es erneut.'),
(2626, 'es', '_WRONG_CONFIRMATION_CODE', 'Código de confirmación incorrecto o su registro se confirmó ya!'),
(2627, 'en', '_WRONG_CONFIRMATION_CODE', 'Wrong confirmation code or your registration is already confirmed!'),
(2628, 'de', '_WRONG_CONFIRMATION_CODE', 'Falscher Bestätigungscode oder Ihre Anmeldung wurde bereits bestätigt!'),
(2629, 'es', '_WRONG_FILE_TYPE', 'El archivo subido no es un archivo válido PHP vocabulario! Por favor, vuelva a entrar.');
INSERT INTO `<DB_PREFIX>vocabulary` (`id`, `language_id`, `key_value`, `key_text`) VALUES
(2630, 'en', '_WRONG_FILE_TYPE', 'Uploaded file is not a valid PHP vocabulary file! Please re-enter.'),
(2631, 'de', '_WRONG_FILE_TYPE', 'Datei hochgeladen ist keine gültige PHP-Datei Wortschatz! Bitte erneut eingeben.'),
(2632, 'es', '_WRONG_LOGIN', 'Nombre de usuario o contraseña incorrecta!'),
(2633, 'en', '_WRONG_LOGIN', 'Wrong username or password!'),
(2634, 'de', '_WRONG_LOGIN', 'Falscher Benutzername oder Passwort!'),
(2635, 'es', '_WRONG_PARAMETER_PASSED', 'Parámetros erróneos pasado - no puede completar la operación!'),
(2636, 'en', '_WRONG_PARAMETER_PASSED', 'Wrong parameters passed - cannot complete operation!'),
(2637, 'de', '_WRONG_PARAMETER_PASSED', 'Falscher Parameter übergeben - kann nicht die gesamte Bedienung!'),
(2638, 'es', '_WYSIWYG_EDITOR', 'Editor WYSIWYG'),
(2639, 'en', '_WYSIWYG_EDITOR', 'WYSIWYG Editor'),
(2640, 'de', '_WYSIWYG_EDITOR', 'WYSIWYG-Editor'),
(2641, 'es', '_YEAR', 'Año'),
(2642, 'en', '_YEAR', 'Year'),
(2643, 'de', '_YEAR', 'Jahr'),
(2644, 'es', '_YEARS', 'Años'),
(2645, 'en', '_YEARS', 'Years'),
(2646, 'de', '_YEARS', 'Jahre'),
(2647, 'es', '_YES', 'Sí'),
(2648, 'en', '_YES', 'Yes'),
(2649, 'de', '_YES', 'Ja'),
(2650, 'es', '_YOUR_EMAIL', 'Su correo electrónico'),
(2651, 'en', '_YOUR_EMAIL', 'Your Email'),
(2652, 'de', '_YOUR_EMAIL', 'Ihre E-Mail'),
(2653, 'es', '_YOUR_NAME', 'Su nombre'),
(2654, 'en', '_YOUR_NAME', 'Your Name'),
(2655, 'de', '_YOUR_NAME', 'Ihr Name'),
(2656, 'es', '_YOU_ARE_LOGGED_AS', 'Estás conectado como'),
(2657, 'en', '_YOU_ARE_LOGGED_AS', 'You are logged in as'),
(2658, 'de', '_YOU_ARE_LOGGED_AS', 'Sie sind angemeldet als'),
(2659, 'es', '_ZIPCODE_EMPTY_ALERT', 'Código postal no puede estar vacía! Por favor, vuelva a entrar.'),
(2660, 'en', '_ZIPCODE_EMPTY_ALERT', 'Zip/Postal code cannot be empty! Please re-enter.'),
(2661, 'de', '_ZIPCODE_EMPTY_ALERT', 'PLZ kann nicht leer sein! Bitte erneut eingeben.'),
(2662, 'es', '_ZIP_CODE', 'Código Postal'),
(2663, 'en', '_ZIP_CODE', 'Zip/Postal code'),
(2664, 'de', '_ZIP_CODE', 'Postleitzahl'),
(2665, 'en', '_ORDER_BY', 'Order By'),
(2666, 'es', '_ORDER_BY', 'Ordenar por'),
(2667, 'de', '_ORDER_BY', 'Sortieren nach'),
(2668, 'en', '_IN', 'in'),
(2669, 'es', '_IN', 'en'),
(2670, 'de', '_IN', 'in'),
(2671, 'en', '_ADVANCED_SEARCH', 'Advanced Search'),
(2672, 'es', '_ADVANCED_SEARCH', 'Búsqueda Avanzada'),
(2673, 'de', '_ADVANCED_SEARCH', 'Erweiterte Suche'),
(2674, 'en', '_YESTERDAY', 'Yesterday'),
(2675, 'es', '_YESTERDAY', 'Ayer'),
(2676, 'de', '_YESTERDAY', 'Gestern'),
(2677, 'en', '_VIEW', 'View'),
(2678, 'es', '_VIEW', 'Ver'),
(2679, 'de', '_VIEW', 'Sehen'),
(2680, 'en', '_LAST_7_DAYS', 'Last 7 days'),
(2681, 'es', '_LAST_7_DAYS', 'Últimos 7 días'),
(2682, 'de', '_LAST_7_DAYS', 'Letzte 7 Tage'),
(2683, 'en', '_DESCENDING', 'Descending'),
(2684, 'es', '_DESCENDING', 'Descendente'),
(2685, 'de', '_DESCENDING', 'Absteigend'),
(2686, 'en', '_ASCENDING', 'Ascending'),
(2687, 'es', '_ASCENDING', 'Ascendente'),
(2688, 'de', '_ASCENDING', 'Aufsteigend'),
(2689, 'en', '_LOCATION', 'Location'),
(2690, 'es', '_LOCATION', 'Ubicación'),
(2691, 'de', '_LOCATION', 'Lage'),
(2692, 'en', '_WITH_IMAGES_ONLY', 'With images only'),
(2693, 'es', '_WITH_IMAGES_ONLY', 'Con sólo imágenes'),
(2694, 'de', '_WITH_IMAGES_ONLY', 'Nur mit Bildern'),
(2695, 'en', '_SERVER_LOCALE', 'Server Locale'),
(2696, 'es', '_SERVER_LOCALE', 'Servidor local'),
(2697, 'de', '_SERVER_LOCALE', 'Server locale'),
(2698, 'en', '_MS_MULTIPLE_CATEGORIES', 'Specifies whether to allow Multiple Categories for Listings: 1 - one category, 2 - two categories etc.'),
(2699, 'es', '_MS_MULTIPLE_CATEGORIES', 'Especifica si se permite múltiples categorías de Listados: 1 - una categoría, 2 - dos categorías, etc'),
(2700, 'de', '_MS_MULTIPLE_CATEGORIES', 'Gibt an, ob Multiple Kategorien für Anzeigen: 1 - eine Kategorie, 2 - zwei Kategorien etc.'),
(2701, 'en', '_INQUIRIES', 'Inquiries'),
(2702, 'es', '_INQUIRIES', 'Consultas'),
(2703, 'de', '_INQUIRIES', 'Anfragen'),
(2704, 'en', '_INQUIRIES_MANAGEMENT', 'Inquiries Management'),
(2705, 'es', '_INQUIRIES_MANAGEMENT', 'Preguntas de Gestión'),
(2706, 'de', '_INQUIRIES_MANAGEMENT', 'Anfragen-Management'),
(2707, 'en', '_INQUIRIES_SETTINGS', 'Inquiries Settings'),
(2708, 'es', '_INQUIRIES_SETTINGS', 'Consultas Configuración'),
(2709, 'de', '_INQUIRIES_SETTINGS', 'Anfragen Einstellungen'),
(2710, 'de', '_GENERATE', 'Erzeugen'),
(2711, 'en', '_GENERATE', 'Generate'),
(2712, 'es', '_GENERATE', 'Generar'),
(2713, 'de', '_USE_THIS_PASSWORD', 'Verwenden Sie dieses Kennwort'),
(2714, 'en', '_USE_THIS_PASSWORD', 'Use this password'),
(2715, 'es', '_USE_THIS_PASSWORD', 'Utilice esta contraseña'),
(2716, 'en', '_MENUS_AND_PAGES', 'Menus and Pages'),
(2717, 'es', '_MENUS_AND_PAGES', 'Los menús y páginas'),
(2718, 'de', '_MENUS_AND_PAGES', 'Menüs und Seiten'),
(2719, 'en', '_LOCATIONS', 'Locations'),
(2720, 'es', '_LOCATIONS', 'Ubicaciones'),
(2721, 'de', '_LOCATIONS', 'Standorte'),
(2722, 'en', '_SUB_LOCATIONS', 'Sub Locations'),
(2723, 'es', '_SUB_LOCATIONS', 'Ubicaciones Sub'),
(2724, 'de', '_SUB_LOCATIONS', 'Sub Standorte'),
(2725, 'en', '_MD_INQUIRIES', 'The Enquiries module allows visitors on your site to submit requests to businesses in specific category or directly to obtain from them the necessary information, get offers etc.'),
(2726, 'es', '_MD_INQUIRIES', 'El módulo de consultas permite a los visitantes de su sitio web para enviar solicitudes a las empresas en la categoría específica o directamente para obtener de ellos la información necesaria, se ofrece, etc'),
(2727, 'de', '_MD_INQUIRIES', 'Die Anfragen-Modul ermöglicht es den Besuchern auf Ihrer Website, um Anforderungen an Unternehmen in bestimmten Kategorie einreichen oder direkt von ihnen die notwendigen Informationen erhalten, bekommen Angebote etc.'),
(2728, 'en', '_MS_MAXIMUM_REPLIES', 'Specifies a maximum number of replies that visitor can retrieve for each inquiry'),
(2729, 'es', '_MS_MAXIMUM_REPLIES', 'Especifica el número máximo de respuestas que el visitante puede recuperar por cada consulta'),
(2730, 'de', '_MS_MAXIMUM_REPLIES', 'Legt die maximale Anzahl von Antworten, die Besucher können für jede Anfrage abzurufen'),
(2731, 'en', '_MS_ALLOW_DIRECT_INQUIRY', 'Specifies whether to allow visitors to send direct inquiries to businesses'),
(2732, 'es', '_MS_ALLOW_DIRECT_INQUIRY', 'Especifica si se permite a los visitantes enviar consultas directas a las empresas'),
(2733, 'de', '_MS_ALLOW_DIRECT_INQUIRY', 'Gibt an, ob die Besucher direkte Anfragen an Unternehmen senden'),
(2734, 'en', '_REPLIES', 'Replies'),
(2735, 'es', '_REPLIES', 'Respuestas'),
(2736, 'de', '_REPLIES', 'Antworten'),
(2738, 'en', '_RATING', 'Rating'),
(2739, 'es', '_RATING', 'Clasificación'),
(2740, 'de', '_RATING', 'Wertung'),
(2741, 'en', '_SHOW', 'Show'),
(2742, 'es', '_SHOW', 'Mostrar'),
(2743, 'de', '_SHOW', 'Zeigen'),
(2744, 'en', '_INVALID_FILE_SIZE', 'Invalid file size: _FILE_SIZE_ (max. allowed: _MAX_ALLOWED_)'),
(2745, 'es', '_INVALID_FILE_SIZE', 'Tamaño de archivo no válido: _FILE_SIZE_ (máximo permitido: _MAX_ALLOWED_)'),
(2746, 'de', '_INVALID_FILE_SIZE', 'Ungültige Dateigröße: _FILE_SIZE_ (max. erlaubt: _MAX_ALLOWED_)'),
(2747, 'en', '_LISTING_MAX_CATEGORIES_ALERT', 'You have reached the maximum number of allowed categories for this listing (according to selected advertising plan).'),
(2748, 'es', '_LISTING_MAX_CATEGORIES_ALERT', 'Ha alcanzado el número máximo de categorías permitidas para este listado (según el plan de publicidad seleccionada).'),
(2749, 'de', '_LISTING_MAX_CATEGORIES_ALERT', 'Sie haben die maximal zulässige Anzahl von Kategorien für dieses Angebot erreicht (nach ausgewählten Werbe-Plan).'),
(2750, 'en', '_SUB_LOCATION', 'Sub Location'),
(2751, 'es', '_SUB_LOCATION', 'Lugar Sub'),
(2752, 'de', '_SUB_LOCATION', 'Sub Ort'),
(2753, 'en', '_I_AM_AVAILABLE', 'I am available'),
(2754, 'es', '_I_AM_AVAILABLE', 'Estoy a su disposición'),
(2755, 'de', '_I_AM_AVAILABLE', 'Ich stehe zur Verfügung'),
(2756, 'en', '_PREFERRED_TO_BE_CONTACTED', 'I prefer to be contacted'),
(2757, 'es', '_PREFERRED_TO_BE_CONTACTED', 'Prefiero ser contactado'),
(2758, 'de', '_PREFERRED_TO_BE_CONTACTED', 'Ich bevorzuge es, kontaktiert werden'),
(2759, 'en', '_SEND_INQUIRY', 'Send Inquiry'),
(2760, 'es', '_SEND_INQUIRY', 'Enviar Consulta'),
(2761, 'de', '_SEND_INQUIRY', 'Anfrage senden'),
(2762, 'en', '_CREDIT_CARD_HOLDER_NAME', 'Card Holder''s Name'),
(2763, 'es', '_CREDIT_CARD_HOLDER_NAME', 'Nombre del titular'),
(2764, 'de', '_CREDIT_CARD_HOLDER_NAME', 'Name des Karteninhabers'),
(2765, 'en', '_CC_CARD_HOLDER_NAME_EMPTY', 'No card holder''s name provided! Please re-enter.'),
(2766, 'es', '_CC_CARD_HOLDER_NAME_EMPTY', 'No Nombre del titular de la tarjeta siempre! Por favor, vuelva a introducir.'),
(2767, 'de', '_CC_CARD_HOLDER_NAME_EMPTY', 'No Name des Karteninhabers versehen! Bitte erneut eingeben.'),
(2768, 'en', '_STEP', 'Step'),
(2769, 'es', '_STEP', 'Paso'),
(2770, 'de', '_STEP', 'Schritt'),
(2771, 'en', '_STEP_1_DESCRIPTION', '<b>Send an inquiry</b><br>Completely free, enter what you want help with and where.'),
(2772, 'es', '_STEP_1_DESCRIPTION', '<b>Enviar solicitud de información</b><br>MedlinePlus Completamente gratis, escriba lo que quiere ayudar y dónde.'),
(2773, 'de', '_STEP_1_DESCRIPTION', '<b>Senden Sie eine Anfrage</b><br>Völlig kostenlos, geben Sie, was Sie wollen helfen, mit und wo.'),
(2774, 'en', '_STEP_2_DESCRIPTION', '<b>Wait for quotes</b><br>Receive quotes from skilled craftsmen.'),
(2775, 'es', '_STEP_2_DESCRIPTION', '<b>Espere comillas</b><br>MedlinePlus Recibe cotizaciones de expertos artesanos.'),
(2776, 'de', '_STEP_2_DESCRIPTION', '<b>für Zitate Warten</b><br>Erhalten Zitate aus erfahrenen Handwerkern.'),
(2777, 'en', '_STEP_3_DESCRIPTION', '<b>Compare and choose</b><br>Choose the company you like best among quotations.'),
(2778, 'es', '_STEP_3_DESCRIPTION', '<b>Compare y elija</b><br>MedlinePlus elegir la compañía que más te guste entre comillas.'),
(2779, 'de', '_STEP_3_DESCRIPTION', '<b>Vergleichen und wählen Sie</b><br>Wählen Sie die Firma, die Sie am besten gefällt zu Zitaten.'),
(2780, 'en', '_WHAT_DO_YOU_NEED', 'What do you need help with?'),
(2781, 'es', '_WHAT_DO_YOU_NEED', '¿Qué necesitas ayuda?'),
(2782, 'de', '_WHAT_DO_YOU_NEED', 'Was brauchen Sie Hilfe bei?'),
(2783, 'en', '_SUBMIT_INQUIRY', 'Submit Inquiry'),
(2784, 'es', '_SUBMIT_INQUIRY', 'Enviar Preguntar'),
(2785, 'de', '_SUBMIT_INQUIRY', 'Anfrage senden'),
(2786, 'en', '_ANYTIME', 'Anytime'),
(2787, 'es', '_ANYTIME', 'En cualquier momento'),
(2788, 'de', '_ANYTIME', 'Jederzeit'),
(2789, 'en', '_MORNING', 'Morning'),
(2790, 'es', '_MORNING', 'Mañana'),
(2791, 'de', '_MORNING', 'Morgen'),
(2792, 'en', '_LUNCH', 'Lunch'),
(2793, 'es', '_LUNCH', 'Almuerzo'),
(2794, 'de', '_LUNCH', 'Mittagessen'),
(2795, 'en', '_AFTERNOON', 'Afternoon'),
(2796, 'es', '_AFTERNOON', 'Tarde'),
(2797, 'de', '_AFTERNOON', 'Nachmittag'),
(2798, 'en', '_EVENING', 'Evening'),
(2799, 'es', '_EVENING', 'Anochecer'),
(2800, 'de', '_EVENING', 'Abend'),
(2801, 'en', '_WEEKEND', 'Weekend'),
(2802, 'es', '_WEEKEND', 'Fin de semana'),
(2803, 'de', '_WEEKEND', 'Wochenende'),
(2804, 'en', '_BY_PHONE_OR_EMAIL', 'By phone or email'),
(2805, 'es', '_BY_PHONE_OR_EMAIL', 'Por teléfono o correo'),
(2806, 'de', '_BY_PHONE_OR_EMAIL', 'Per Telefon oder E-Mail'),
(2807, 'en', '_BY_PHONE', 'By phone'),
(2808, 'es', '_BY_PHONE', 'Por teléfono'),
(2809, 'de', '_BY_PHONE', 'Per Telefon'),
(2810, 'en', '_VIA_EMAIL', 'Via email'),
(2811, 'es', '_VIA_EMAIL', 'Por correo electrónico'),
(2812, 'de', '_VIA_EMAIL', 'Via E-Mail'),
(2813, 'en', '_DIRECT', 'Direct'),
(2814, 'es', '_DIRECT', 'Dirigir'),
(2815, 'de', '_DIRECT', 'Direkt'),
(2816, 'en', '_INQUIRY_SENT_SUCCESS_MSG', 'Thank you! Your inquiry has been successfully submitted. Please wait for at least few business days to receive a response to your inquiry. If you have any questions, please contact administration of the site.'),
(2817, 'es', '_INQUIRY_SENT_SUCCESS_MSG', '¡Gracias! Su consulta ha sido enviada correctamente. Por favor, espere por lo menos durante algunos días laborales para recibir una respuesta a su consulta.'),
(2818, 'de', '_INQUIRY_SENT_SUCCESS_MSG', 'Danke! Ihre Anfrage wurde erfolgreich übermittelt. Bitte warten Sie mindestens wenigen Werktagen eine Antwort auf Ihre Anfrage erhalten.'),
(2819, 'en', '_SEND_DIRECT_INQUIRY', 'Send Direct Inquiry'),
(2820, 'es', '_SEND_DIRECT_INQUIRY', 'Enviar Consulta Directa'),
(2821, 'de', '_SEND_DIRECT_INQUIRY', 'Senden Direkte Anfrage'),
(2822, 'en', '_MS_SHOW_INQUIRIES_BLOCK_BLOCK', 'Defines whether to show Last Inquiries side block or not'),
(2823, 'es', '_MS_SHOW_INQUIRIES_BLOCK_BLOCK', 'Define si se mostrará bloque Última lado Consultas o no'),
(2824, 'de', '_MS_SHOW_INQUIRIES_BLOCK_BLOCK', 'Legt fest, ob Last Anfragen Seite Block zeigen oder nicht'),
(2825, 'en', '_INVALID_IMAGE_FILE_TYPE', 'Uploaded file is not a valid image! Please re-enter.'),
(2826, 'es', '_INVALID_IMAGE_FILE_TYPE', 'El archivo cargado no es una imagen válida! Por favor, vuelva a entrar.'),
(2827, 'de', '_INVALID_IMAGE_FILE_TYPE', 'Hochgeladene Datei ist kein gültiges Bild! Bitte geben Sie erneut.'),
(2828, 'en', '_DESCRIBE_WHAT_YOU_NEED', '<b>Describe here what you need</b> <br>NOTE! It is free and not binding'),
(2829, 'es', '_DESCRIBE_WHAT_YOU_NEED', '<b>Describa lo que usted necesita aquí</b> MedlinePlus<br>NOTA! Es gratuito y no vinculante'),
(2830, 'de', '_DESCRIBE_WHAT_YOU_NEED', '<b>Beschreiben Sie, was Sie hier benötigen </b><br>HINWEIS! Es ist kostenlos und unverbindlich'),
(2831, 'en', '_INQUIRY_FORM_DISCLAIMER', 'Your personal information will be used only for the purposes stated above, will not be shared with third parties other than those described above and you can only retrieve reply out of _COUNT_ companies.'),
(2832, 'es', '_INQUIRY_FORM_DISCLAIMER', 'Sus datos personales serán utilizados únicamente para los fines indicados más arriba, no será compartida con terceros distintos de los descritos anteriormente y sólo se puede obtener respuesta de las empresas _COUNT_.'),
(2833, 'de', '_INQUIRY_FORM_DISCLAIMER', 'Ihre persönlichen Daten werden nur für die oben genannten Zwecke verwendet werden, werden nicht mit Dritten andere als die oben beschriebenen geteilt werden und Sie können nur abgerufen antworten von _COUNT_ Unternehmen.'),
(2834, 'en', '_INCOMING_JOBS', 'Incoming Jobs'),
(2835, 'es', '_INCOMING_JOBS', 'Empleos Entrantes'),
(2836, 'de', '_INCOMING_JOBS', 'Eingehende Jobs'),
(2837, 'en', '_CATEGORIES_COUNT', 'Categories Count'),
(2838, 'es', '_CATEGORIES_COUNT', 'Categorías Conde'),
(2839, 'de', '_CATEGORIES_COUNT', 'Kategorien Graf'),
(2840, 'en', '_MORE_INFO', 'More Info'),
(2841, 'es', '_MORE_INFO', 'Más información'),
(2842, 'de', '_MORE_INFO', 'Mehr Info'),
(2843, 'en', '_INQUIRY_DETAILS', 'Inquiry Details'),
(2844, 'es', '_INQUIRY_DETAILS', 'Detalles Query'),
(2845, 'de', '_INQUIRY_DETAILS', 'Anfrage Details'),
(2846, 'en', '_LISTING', 'Listing'),
(2847, 'es', '_LISTING', 'Listado'),
(2848, 'de', '_LISTING', 'Auflistung'),
(2849, 'en', '_ALL_LOCATIONS', 'all locations'),
(2850, 'es', '_ALL_LOCATIONS', 'todas las ubicaciones'),
(2851, 'de', '_ALL_LOCATIONS', 'alle Standorte'),
(2852, 'en', '_ALL_SUB_LOCATIONS', 'all sub locations'),
(2853, 'es', '_ALL_SUB_LOCATIONS', 'todos los sub-sitios'),
(2854, 'de', '_ALL_SUB_LOCATIONS', 'alle Sub-Standorten'),
(2858, 'en', '_MAXIMUM_ALLOWED_INQUIRIES_PER_SESSION', 'You have reached the maximum number (_COUNT_) of allowed inquiries for this session. Please try again later.'),
(2859, 'es', '_MAXIMUM_ALLOWED_INQUIRIES_PER_SESSION', 'Ha alcanzado el número máximo (_COUNT_) de consultas permitidas para esta sesión. Por favor, inténtelo de nuevo más tarde.'),
(2860, 'de', '_MAXIMUM_ALLOWED_INQUIRIES_PER_SESSION', 'Sie haben die maximale Anzahl (_COUNT_) der erlaubten Anfragen für diese Sitzung erreicht. Bitte versuchen Sie es später erneut.'),
(2861, 'en', '_LOGO', 'Logo'),
(2862, 'es', '_LOGO', 'Logotipo'),
(2863, 'de', '_LOGO', 'Emblem'),
(2864, 'en', '_DIRECT_INQUIRY_NOT_ALLOWED', 'According to the system settings you cannot send direct inquiry to this company/business!'),
(2865, 'es', '_DIRECT_INQUIRY_NOT_ALLOWED', 'Según la configuración del sistema no puede enviar pregunta directamente a esta empresa/negocio!'),
(2866, 'de', '_DIRECT_INQUIRY_NOT_ALLOWED', 'Nach den Systemeinstellungen können Sie nicht senden direkt eine Anfrage an dieses Unternehmen / Wirtschaft!'),
(2867, 'en', '_CLOSED', 'Closed'),
(2868, 'es', '_CLOSED', 'Cerrado'),
(2869, 'de', '_CLOSED', 'Geschlossen'),
(2870, 'en', '_NO_INCOMMING_JOBS_YET', 'No incoming jobs yet.'),
(2871, 'es', '_NO_INCOMMING_JOBS_YET', 'No hay trabajos entrantes aún.'),
(2872, 'de', '_NO_INCOMMING_JOBS_YET', 'Keine eingehenden Aufträge noch.'),
(2873, 'en', '_KEYWORDS_COUNT', 'Keywords Count'),
(2874, 'es', '_KEYWORDS_COUNT', 'Palabras clave conde'),
(2875, 'de', '_KEYWORDS_COUNT', 'Schlüsselwörter Graf'),
(2876, 'en', '_INQUIRIES_COUNT', 'Inquiries Count'),
(2877, 'es', '_INQUIRIES_COUNT', 'Preguntas conde'),
(2878, 'de', '_INQUIRIES_COUNT', 'Anfragen Graf'),
(2879, 'en', '_PER_MONTH', 'per month'),
(2880, 'es', '_PER_MONTH', 'por mes'),
(2881, 'de', '_PER_MONTH', 'pro Monat'),
(2882, 'en', '_INQUIRIES_REPLIES', 'Inquiries Replies'),
(2883, 'es', '_INQUIRIES_REPLIES', 'Consultas respuestas'),
(2884, 'de', '_INQUIRIES_REPLIES', 'Anfragen Antworten'),
(2885, 'en', '_INQUIRY_BUTTON', 'Inquiry Button'),
(2886, 'es', '_INQUIRY_BUTTON', 'Verificación de teclas'),
(2887, 'de', '_INQUIRY_BUTTON', 'Anfrage-Button'),
(2888, 'en', '_RATING_BUTTON', 'Rating Button'),
(2889, 'es', '_RATING_BUTTON', 'Puntuación Button'),
(2890, 'de', '_RATING_BUTTON', 'Rating-Taste'),
(2891, 'en', '_DATE_ADDED', 'Date Added'),
(2892, 'es', '_DATE_ADDED', 'Fecha Alta'),
(2893, 'de', '_DATE_ADDED', 'Aufgenommen am'),
(2894, 'en', '_REPLY', 'Reply'),
(2895, 'es', '_REPLY', 'Responder'),
(2896, 'de', '_REPLY', 'Antworten'),
(2897, 'en', '_ANSWERED', 'Answered'),
(2898, 'es', '_ANSWERED', 'Respondido'),
(2899, 'de', '_ANSWERED', 'Beantwortete'),
(2900, 'en', '_PC_INQUIRY_REPLAY_DETAILS_TEXT', 'information about inquiry reply and customer'),
(2901, 'es', '_PC_INQUIRY_REPLAY_DETAILS_TEXT', 'información sobre investigación y respuesta al cliente'),
(2902, 'de', '_PC_INQUIRY_REPLAY_DETAILS_TEXT', 'Informationen über Anfragen antworten und Kunden'),
(2910, 'es', '_DASHBOARD_ORDERS_LINK', '<p><b>&#8226;</b> <a href=''index.php?customer=my_orders''>Los pedidos</a> página le permite gestionar sus pedidos.</p>'),
(2909, 'en', '_DASHBOARD_ORDERS_LINK', '<p><b>&#8226;</b> <a href=''index.php?customer=my_orders''>Orders</a> page allows you to manage your orders.</p>'),
(2903, 'en', '_DASHBOARD_INQUIRIES_LINK', '<p><b>&#8226;</b> <a href=index.php?customer=inquiries>Inquiries</a> page allows you to view received inquires and reply them.</p>'),
(2904, 'es', '_DASHBOARD_INQUIRIES_LINK', '<p><b>&#8226;</b> <a href=index.php?customer=inquiries>Preguntas</a> de página le permite ver y contestar preguntas recibidas ellos.</p>'),
(2905, 'de', '_DASHBOARD_INQUIRIES_LINK', '<p><b>&#8226;</b> <a href=index.php?customer=inquiries>Anfragen</a> Seite können Sie erhalten Anfragen ansehen und beantworten sie.</p>'),
(2906, 'en', '_SELECT_PLAN', 'Select Advertise Plan'),
(2907, 'es', '_SELECT_PLAN', 'Seleccione Plan de Publicidad'),
(2908, 'de', '_SELECT_PLAN', 'Wählen Sie Werben Plans'),
(2911, 'de', '_DASHBOARD_ORDERS_LINK', '<p><b>&#8226;</b> <a href=''index.php?customer=my_orders''>Bestellungen</a> Seite können Sie Ihre Aufträge verwalten.</p>'),
(2912, 'en', '_CLICK_TO_SELECT', 'Click to select'),
(2913, 'es', '_CLICK_TO_SELECT', 'Haga clic para seleccionar'),
(2914, 'de', '_CLICK_TO_SELECT', 'Klicken Sie auf'),
(2915, 'en', '_RATINGS', 'Ratings'),
(2916, 'es', '_RATINGS', 'Valoraciones'),
(2917, 'de', '_RATINGS', 'Bewertungen'),
(2918, 'en', '_RATINGS_SETTINGS', 'Ratings Settings'),
(2919, 'es', '_RATINGS_SETTINGS', 'Valoraciones Configuración'),
(2920, 'de', '_RATINGS_SETTINGS', 'Bewertungen Einstellungen'),
(2921, 'en', '_LISTING_MAX_KEYWORDS_ALERT', 'The maximum allowed number of keywords is _MAX_! Please re-enter.'),
(2922, 'es', '_LISTING_MAX_KEYWORDS_ALERT', 'El número máximo de palabras clave es _MAX_! Por favor, vuelva a entrar.'),
(2923, 'de', '_LISTING_MAX_KEYWORDS_ALERT', 'Die maximal zulässige Anzahl an Keywords beträgt _Max_! Bitte geben Sie erneut.'),
(2924, 'en', '_MD_RATINGS', 'The Ratings module allows your users to rate the listings. The number of votes and average rating will be shown at the appropriate listing.'),
(2925, 'es', '_MD_RATINGS', 'El módulo de calificación permite a los usuarios votar por las listas. El número de votos y la calificación media se mostrará en la lista correspondiente.'),
(2926, 'de', '_MD_RATINGS', 'Die Ratings-Modul ermöglicht es den Benutzern, um die Angebote zu bewerten. Die Zahl der Stimmen und die durchschnittliche Bewertung wird auf der entsprechenden Liste angezeigt werden.'),
(2927, 'en', '_MS_RATINGS_USER_TYPE', 'Type of users, who can rate listings'),
(2928, 'es', '_MS_RATINGS_USER_TYPE', 'Tipo de usuarios, que pueden votar los listados'),
(2929, 'de', '_MS_RATINGS_USER_TYPE', 'Art der Nutzer, die Inserate bewerten können'),
(2930, 'en', '_MS_MULTIPLE_ITEMS_PER_DAY', 'Specifies whether to allow users to rate multiple items per day or not'),
(2931, 'es', '_MS_MULTIPLE_ITEMS_PER_DAY', 'Especifica si se permite a los usuarios artículos tasas múltiples por día o no'),
(2932, 'de', '_MS_MULTIPLE_ITEMS_PER_DAY', 'Gibt an, ob Benutzer sich mehrere Artikel pro Tag oder nicht zulassen'),
(2933, 'en', '_VOTE_NOT_REGISTERED', 'Your vote has not been registered! You must be logged in before you can vote.'),
(2934, 'es', '_VOTE_NOT_REGISTERED', 'Su voto no se ha registrado? Debe estar registrado para poder votar.'),
(2935, 'de', '_VOTE_NOT_REGISTERED', 'Ihre Stimme wurde nicht registriert! Sie müssen, bevor Sie abstimmen können protokolliert werden.'),
(2936, 'en', '_MS_KEEP_HISTORY_DAYS', 'The maximum number of days to keep the inquiries history'),
(2937, 'es', '_MS_KEEP_HISTORY_DAYS', 'El número máximo de días para conservar el historial de consultas'),
(2938, 'de', '_MS_KEEP_HISTORY_DAYS', 'Die maximale Anzahl der Tage, um die Anfragen Geschichte zu halten'),
(2939, 'en', '_INQUIRY_TO_YOURSELF_PROHIBITED', 'You cannot send inquiry to yourself!'),
(2940, 'es', '_INQUIRY_TO_YOURSELF_PROHIBITED', 'No se puede enviar la investigación a ti mismo!'),
(2941, 'de', '_INQUIRY_TO_YOURSELF_PROHIBITED', 'Sie können nicht senden Anfrage an sich selbst!'),
(2942, 'en', '_INTEGRATION', 'Integration'),
(2943, 'es', '_INTEGRATION', 'Integración'),
(2944, 'de', '_INTEGRATION', 'Integration'),
(2945, 'en', '_INTEGRATION_MESSAGE', 'Copy the code below and put it in the appropriate place of your website to get an Inquiry Form.'),
(2946, 'es', '_INTEGRATION_MESSAGE', 'Copie el código abajo y lo puso en el lugar correspondiente de su sitio web para obtener un formulario de consulta.'),
(2947, 'de', '_INTEGRATION_MESSAGE', 'Kopieren Sie den Code unten ein und steckte es in die entsprechende Stelle Ihrer Webseite ein Anfrageformular zu bekommen.'),
(3958, 'de', '_OWNER', 'Eigentümer'),
(3957, 'es', '_OWNER', 'Propietario'),
(3956, 'en', '_OWNER', 'Owner'),
(3955, 'de', '_MS_WATERMARK_TEXT', 'Wasserzeichen Text, der die Bilder hinzugefügt werden'),
(3954, 'es', '_MS_WATERMARK_TEXT', 'Texto de la marca que se añadirá a las imágenes'),
(3953, 'en', '_MS_WATERMARK_TEXT', 'Watermark text that will be added to images'),
(3952, 'de', '_MS_ADD_WATERMARK', 'Gibt an, ob Wasserzeichen zur Liste Bilder oder nicht hinzufügen'),
(3951, 'es', '_MS_ADD_WATERMARK', 'Especifica si se debe añadir marcas de agua a las imágenes o no listado'),
(3950, 'en', '_MS_ADD_WATERMARK', 'Specifies whether to add watermark to listing images or not'),
(3949, 'de', '_MS_BANNERS_CAPTION_HTML', 'Gibt an, ob mit Hilfe von HTML-Diashow in Bildunterschriften oder nicht'),
(3948, 'es', '_MS_BANNERS_CAPTION_HTML', 'Especifica si se debe permitir el uso de HTML en los textos de presentación de diapositivas o no'),
(3947, 'en', '_MS_BANNERS_CAPTION_HTML', 'Specifies whether to allow using of HTML in slideshow captions or not'),
(3937, 'de', '_INTEGRATION_TOP_MESSAGE', 'Sie können Anfrageformular Motor mit anderen bestehenden Website zu integrieren.'),
(3938, 'en', '_DECIMALS', 'Decimals'),
(3939, 'es', '_DECIMALS', 'Decimales'),
(3940, 'de', '_DECIMALS', 'Dezimalstellen'),
(3941, 'en', '_MONTHS', 'Months'),
(3942, 'es', '_MONTHS', 'Meses'),
(3943, 'de', '_MONTHS', 'Monate'),
(3944, 'en', '_HIDDEN', 'Hidden'),
(3945, 'es', '_HIDDEN', 'Oculto'),
(3946, 'de', '_HIDDEN', 'Versteckt'),
(3936, 'es', '_INTEGRATION_TOP_MESSAGE', 'Usted puede integrar motor Formulario de consulta con otro sitio web existente.'),
(3935, 'en', '_INTEGRATION_TOP_MESSAGE', 'You may integrate Inquiry Form engine with another existing website.'),
(3933, 'es', '_SEND_INQUIRY_TO', 'Enviar la pregunta a'),
(3934, 'de', '_SEND_INQUIRY_TO', 'Anfrage senden an'),
(3932, 'en', '_SEND_INQUIRY_TO', 'Send Inquiry to'),
(3931, 'de', '_MS_SUB_CATEGORIES_COUNT', 'Gibt eine Anzahl von Sub-Kategorien für jede Kategorie, die auf der Startseite angezeigt werden können'),
(3930, 'es', '_MS_SUB_CATEGORIES_COUNT', 'Especifica un número de sub-categorías para cada categoría que se puede mostrar en la página principal'),
(3929, 'en', '_MS_SUB_CATEGORIES_COUNT', 'Specifies a  number of sub-categories for each category that could be displayed on home page');
