<?php
require_once("../conf.php");      
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Resize by using mouse</title>
</head>
<body> 

<?php
$higridnet = new HiGrid("select * from products", "productCode", "productcode");
$higridnet -> set_col_title("productCode", "Product Code");
$higridnet -> set_col_title("productName", "Product Name");
$higridnet -> set_col_title("productLine", "Product Line");

// display static Url
$higridnet -> set_col_link("productUrl");                                             

// display dynamic url. e.g.http://www.example.com/?productCode=101&foo=bar
$higridnet -> set_col_dynalink("productCode", "http://www.example.com/", "productCode", '&foo=bar');                                                                   

// column format
$higridnet -> set_col_currency("buyPrice");
$higridnet -> set_col_format("quantityInStock", "integer", array("thousandsSeparator" => ",",
                                                          "defaultValue" => "0"));   
$higridnet -> set_col_format("MSRP", 'currency', array("prefix" => "$",
                                                "suffix" => '',
                                                "thousandsSeparator" => ",",
                                                "decimalSeparator" => ".",
                                                "decimalPlaces" => '2',
                                                "defaultValue" => '0.00'));

// the above line is equivalent to the following helper function                        
$higridnet -> set_col_currency("MSRP", "$", '', ",",".", "2", "0.00");    
                                                                                     
// display image
$higridnet -> set_col_img("Image");

// enable resize by dragging mouse
$higridnet -> enable_resize(true, 300, 500, true); 

$higridnet -> display();
?>

</body>
</html>
