<?php
require_once("../conf.php");      
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Subgrid</title>
</head>
<body> 

<?php
$higridnet = new HiGrid("SELECT * FROM orders", "orderNumber", "orders"); 

// change column titles
$higridnet->set_col_title("orderNumber", "Order No.");
$higridnet->set_col_title("orderDate", "Order Date");
$higridnet->set_col_title("shippedDate", "Shipped Date");
$higridnet->set_col_title("customerNumber", "Customer No.");
 
// enable edit
$higridnet->enable_edit("INLINE", "CRUD"); 

// hide a column
$higridnet -> set_col_hidden("requiredDate");

// read only columns, one or more columns delimited by comma
$higridnet -> set_col_readonly("orderDate, customerNumber"); 

// required fields
$higridnet -> set_col_required("orderNumber, customerNumber");

// multiple select
$higridnet -> set_multiselect(true);
 
// second grid as detail grid. Notice it is just another regular HIGRID with properites.
$sdg = new HiGrid("SELECT orderLineNumber,orderNumber,productCode,quantityOrdered,priceEach FROM orderdetails", "orderLineNumber", "orderdetails");
$sdg->set_col_title("orderLineNumber", "Item No.");
$sdg->set_col_hidden("orderNumber");
$sdg->set_col_title("productCode", "Product Code");
$sdg->set_col_title("quantityOrdered", "Quantity");
$sdg->set_col_title("priceEach", "Unit Price");
$sdg->set_col_dynalink("productCode", "http://www.example.com/", "orderNumber", '&foo=bar');
$sdg->set_col_format('orderNumber','integer', array('thousandsSeparator'=>'','defaultValue'=>''));
$sdg->set_col_currency('priceEach','$');

// define master detail relationship by passing the detail grid object as the first parameter, then the foriegn key name.
// set query filter
$higridnet->set_subgrid($sdg, 'orderNumber');

$higridnet->display();
?>

</body>
</html>