<?php
/********************************************************************
Example file
This example shows how to use the MyLibSQLGen class

The example is based on the following MySQL table:

CREATE TABLE customer (
  id int(10) unsigned NOT NULL auto_increment,
  name varchar(60) NOT NULL default '',
  address varchar(60) NOT NULL default '',
  city varchar(60) NOT NULL default '',
  PRIMARY KEY  (cust_id)
) TYPE=MyISAM;

********************************************************************/

require_once("class_mylib_SQLGen-1.0.php");

$fields=Array("name","address","city");
$values=Array("Fadjar","Resultmang Raya Street","Jakarta");
$tables=Array("customer");

echo "<b>Result Generate Insert</b><br>";
$object=new MyLibSQLGen();
$object->clear_all_assign(); //to refresh all property but it no need when first time execute
$object->setFields($fields);
$object->setValues($values);
$object->setTables($tables);

if(!$object->getInsertSQL()){echo $object->Error;exit;}
else{$sql=$object->Result;echo $sql."<br>";}


echo "<b>Result Generate Update</b><br>";
$fields=Array("name","address","city");
$values=Array("Fadjar","Resultmang Raya Street","Jakarta");
$tables=Array("customer");
$id=1;
$conditions[0]["condition"]="id='$id'";
$conditions[0]["connection"]="";

$object->clear_all_assign();
$object->setFields($fields);
$object->setValues($values);
$object->setTables($tables);
$object->setConditions($conditions);

if(!$object->getUpdateSQL()){echo $object->Error;exit;}
else{$sql=$object->Result; echo $sql."<br>";}

echo "<b>Result Generate Delete</b><br>";
$tables=Array("customer");
$conditions[0]["condition"]="id='1'";
$conditions[0]["connection"]="OR";
$conditions[1]["condition"]="id='2'";
$conditions[1]["connection"]="OR";
$conditions[2]["condition"]="id='4'";
$conditions[2]["connection"]="";

$object->clear_all_assign();
$object->setTables($tables);
$object->setConditions($conditions);

if(!$object->getDeleteSQL()){echo $object->Error;exit;}
else{$sql=$object->Result; echo $sql."<br>";}

echo "<b>Result Generate List</b><br>";
$fields=Array("id","name","address","city");
$tables=Array("customer");
$id=1;
$conditions[0]["condition"]="id='$id'";
$conditions[0]["connection"]="";

$object->clear_all_assign();
$object->setFields($fields);
$object->setTables($tables);
$object->setConditions($conditions);

if(!$object->getQuerySQL()){echo $object->Error;exit;}
else{$sql=$object->Result; echo $sql."<br>";}

echo "<b>Result Generate List with search on all fields</b><br>";
$fields=Array("id","name","address","city");
$tables=Array("customer");
$id=1;
$search="Fadjar Nurswanto";
$object->clear_all_assign();
$object->setFields($fields);
$object->setTables($tables);
$object->setSearch($search);

if(!$object->getQuerySQL()){echo $object->Error;exit;}
else{$sql=$object->Result; echo $sql."<br>";}

echo "<b>Result Generate List with search on some fields</b><br>";
$fields=Array("id","name","address","city");
$tables=Array("customer");
$id=1;
$search=Array(
			"name"=>"Fadjar Nurswanto",
			"address"=>"Tomang Raya"
		);

$object->clear_all_assign();
$object->setFields($fields);
$object->setTables($tables);
$object->setSearch($search);

if(!$object->getQuerySQL()){echo $object->Error;exit;}
else{$sql=$object->Result; echo $sql."<br>";}
?>
