<?php

include_once 'class.control.php';
define('CACHE_PATH', SYSTEM_PATH.'/data/cache/cache.function.php');
define('CACHE_MAP_PATH', SYSTEM_PATH.'/data/cache/cache.map.php');
define('MY_OK', 0);
define('MY_ERROR', -1);

class Ret {
	public $name;
	public $desc;
	public $no;
	public $val;
	public $suggest;
	public $msg;
	public $type;
	public $tag;
	public $title;
}

function s($c) {
	if(empty($c)) return '0:1';
	return number_format($c).':1';
}

function b($c) {

	if(empty($c)) return 0;

	if($c >= 1073741824) {
		$c = number_format($c / 1073741824, 2, '.', ',').'G';
	} elseif($c >= 1048576) {
		$c = number_format($c / 1048576, 2, '.', ',').'M';
	} elseif($c >= 1024) {
		$c = number_format($c / 1024, 2, '.', ',').'K';
	}
	
	return $c;	
	
}

function intToStr($c) {
	return number_format($c, 0, '.', ',');
}

function radio($a, $b) {
	if(empty($a) && empty($b)) return '0:0';
	else if(empty($b)) return $a.':0';
	else return number_format($a / $b, 2).':1';
} 

function perc($a, $b) {
	if(empty($b)) return number_format(0, 2);
	return number_format($a / $b * 100, 2);
}

function intToPen($c) {
	return number_format($c, 2).'%';
}

function ret($name, $desc = '') {
	$r = new Ret();
	$r->name = $name;
	$r->desc = $desc;
	$r->no = MY_OK;
	return $r;
}

class System {

	public $vars;
	public $status;
	public $plugins;
	public $cache = array();
	public $map = array();
	
	function __construct($config) {
		$type = null;
		$this->config = $config;
		if($this->config['cache'] == true) {
			if(!$this->isCache()) {
				file_put_contents(CACHE_PATH, '');
				file_put_contents(CACHE_MAP_PATH, '');
				$this->cache[] = $this->map[] = "<?php\n";
				$this->map[] = "return array(\n";
				$dh = opendir('plugins');
				while(($file = readdir($dh)) !== false) {
					if(!preg_match('/^(runtime|analyzer|safe)/', $file)) continue;
					if(preg_match('/^runtime/', $file)) {
						$type = 'runtime';
					} else if(preg_match('/^analyzer/', $file)) {
						$type = 'analyzer';
					} else {
						$type = 'safe';
					}
					$name = substr($file, 0, -4);
					$this->plugins[$type][] = $name;
					$this->cache[] = $this->getFuncStr($name);
				}
				
				foreach($this->plugins as $key => $row) {
					$this->map[] = "'$key' => array(\n";
					foreach($row as $r) {
						$this->map[] = "'$r',\n";
					}
					$this->map[] = "),";
				}
				
				$this->map[] = ");";
				$this->cache[] = $this->map[] = "\n?>";
				foreach($this->cache as $func) {
					file_put_contents(CACHE_PATH, "\n\n".$func, FILE_APPEND);
				}
				foreach($this->map as $func) {
					file_put_contents(CACHE_MAP_PATH, $func, FILE_APPEND);
				}
			}
			include_once CACHE_PATH;
			$this->plugins = include CACHE_MAP_PATH;
		} else {
			$dh = opendir('plugins');
			while(($file = readdir($dh)) !== false) {
				if(!preg_match('/^(runtime|analyzer|safe)/', $file)) continue;
				if(preg_match('/^runtime/', $file)) {
					$type = 'runtime';
				} else if (preg_match('/^analyzer/', $file)) {
					$type = 'analyzer';
				} else {
					$type = 'safe';
				}
				$name = substr($file, 0, -4);
				$this->plugins[$type][] = $name;
			}		
		}
		if(empty($_REQUEST['file'])) {
		
			$this->getMySQL();
		
		} else {
			$file = base64_decode($_REQUEST['file']);
			
			$arr = file_get_contents($file);
			
			$arr = unserialize(base64_decode($arr));
			
	
			$this->vars = $arr['variables'];
			$this->status = $arr['status'];
		}
	}
	
	function getMySQL() {
	
		$dbConfig = $this->config['db'][$_REQUEST['serverName']];
	
		$link = mysql_connect($dbConfig['host'], $dbConfig['user'], $dbConfig['password']);
		$sql = "SHOW VARIABLES";
		$res = mysql_query($sql);
		while($row = mysql_fetch_array($res)) {
			$this->vars[$row['Variable_name']] = $row['Value'];	
		}
		$sql = "SHOW global STATUS";
		$res = mysql_query($sql);
		while($row = mysql_fetch_array($res)) {
			$this->status[$row['Variable_name']] = $row['Value'];	
		}
		
		$v = explode('-', $this->vars['version']);
		$this->config['version'] = $v[0];
	}
	
	function isCache() {
		return file_exists(CACHE_PATH);
	}
	
	function getPluginPath($name) {
		return './plugins/'.$name.'.php';
	}
	
	function getFuncStr($name) {
		$path = $this->getPluginPath($name);
		$data = file_get_contents($path);
		preg_match('/<\?(?:php)?\s*(.*?)\?>/ims', $data, $matches);
		return $matches[1];
	}
		
	function show() {
		foreach($this->config['views'] as $view) {
			call_user_func(array($this, 'view_'.$view));
		}
		
	}
	
	function view_analyzer() {
		$pannel = new Control();
		$pannel->createList("变量优化");
		
		$arr = array();
		
		foreach($this->plugins['analyzer'] as $func) {
		
			if($this->config['cache'] == false) {
				include_once SYSTEM_PATH.'/plugins/'.$func.'.php';
			}
			$ret = call_user_func($func, $this->config, $this->vars, $this->status);
			$ret->module = $func;
			$sort = empty($ret->sort) ? '默认' : $ret->sort;
			$arr[$sort][] = $ret;
		}
		
		foreach($arr as $sort => $row) {
			$ret = new Ret();
			$ret->type = 'sort';
			$ret->name = $sort;
			$pannel->addItem($ret);
			foreach($row as $ret) {
				$pannel->addItem($ret);
			}
		}
		$pannel->showList();
	}
	
	function view_runtime() {
		
		$pannel = new Control();
		$pannel->createList("运行时状态");
		
		$arr = array();
		
		foreach($this->plugins['runtime'] as $func) {
		
			if($this->config['cache'] == false) {
				include_once SYSTEM_PATH.'/plugins/'.$func.'.php';
			}
			$ret = call_user_func($func, $this->config, $this->vars, $this->status);
			$ret->module = $func;
			$sort = empty($ret->sort) ? '默认' : $ret->sort;
			$arr[$sort][] = $ret;
		}
		
		foreach($arr as $sort => $row) {
			$ret = new Ret();
			$ret->type = 'sort';
			$ret->name = $sort;
			$pannel->addItem($ret);
			foreach($row as $ret) {
				$pannel->addItem($ret);
			}
		}
		
		$pannel->showList();
	
	}
	
	function view_safe() {
		
		$pannel = new Control();
		$pannel->createList("安全状态");
		
		$arr = array();
		
		foreach($this->plugins['safe'] as $func) {
		
			if($this->config['cache'] == false) {
				include_once SYSTEM_PATH.'/plugins/'.$func.'.php';
			}
			$ret = call_user_func($func, $this->config, $this->vars, $this->status);
			$ret->module = $func;
			$sort = empty($ret->sort) ? '默认' : $ret->sort;
			$arr[$sort][] = $ret;
		}
		
		foreach($arr as $sort => $row) {
			$ret = new Ret();
			$ret->type = 'sort';
			$ret->name = $sort;
			$pannel->addItem($ret);
			foreach($row as $ret) {
				$pannel->addItem($ret);
			}
		}
		
		$pannel->showList();
	
	}
	
}

function formatText($str) {
	
	$pattern = array(
		"/\[var\](.+?)\[\/var\]/imse",
		"/\[stat\](.+?)\[\/stat\]/imse",
	);
	
	$replacement = array(
		"formatTextSub('var', '\\1')",
		"formatTextSub('stat', '\\1')",
	);
	
	return preg_replace($pattern, $replacement, $str);
	
}

function formatTextSub($tag, $data) {
	$dict = include SYSTEM_PATH.'/lib/dict.php';
	$key = $tag.'_'.$data;
	$desc = empty($dict[$key]) ? '' : $dict[$key];
	return '<span class="external_'.$tag.'" title="'.$desc.'">'.$data.'</span>';
}

function outJsVar($arr) {

	$out = '';
	
	$out .= '<script>'."\n";
	$out .= 'var sys_env = new Array();'."\n";
	foreach($arr as $key => $row) {
		$out .= 'sys_env[\''.$key.'\'] = "'.$row.'";'."\n"; 
	}
	
	$out .= '</script>'."\n";
	
	return $out;
} 

function sendSysInfo() {
	$lock = SYSTEM_PATH.'/data/installed.lock';
	if(file_exists($lock)) return;
	@file_get_contents('http://echohello.cn/ii.php?product=MySQLMonitor&version='.SYS_VERSION);
	install();
	@touch($lock);
}sendSysInfo();

function showMessage($no, $msg) {
	$arr = array('no' => $no, 'msg' => $msg);
	echo json_encode($arr);
}


function install() {

	$paths = array();

	$paths[] = SYSTEM_PATH.'/data';
	$paths[] = SYSTEM_PATH.'/data/cache'; 
	$paths[] = SYSTEM_PATH.'/data/snapshot'; 

	foreach($paths as $row) {
		@mkdir($row);
	}

}

?>