<?php

function runtime_connections($config, $vars, $status) {
	$ret = ret("连接情况", "");
	
$fmt = <<<MSG
<pre>
<b>重要数据</b>
---------------------------------------------------------
%%当前活跃连接 %10s
%%历史最大连接 %10s
最大连接数    %10s

<b>其它数据</b>
---------------------------------------------------------
当前活跃连接 %10s
历史最大连接 %10s
</pre>
MSG;
	
	$ret->val = sprintf($fmt
	, perc($status['Threads_connected'], $vars['max_connections'])
	, perc($status['Max_used_connections'], $vars['max_connections'])
	, b($vars['max_connections'])
	, b($status['Threads_connected'])
	, b($status['Max_used_connections'])
	);
	$ret->sort = '连接和线程';
	
$fmt = <<<MSG
Max Used %8s of %8s %%Total %8s
MSG;
	$ret->varTitle = sprintf($fmt, $status['Max_used_connections']
	, $vars['max_connections'], perc($status['Max_used_connections'], $vars['max_connections'])
	);
	
$fmt = <<<MSG
<p>当并发连接数[stat]Threads_connected[/stat]超过最大连接数[var]max_connections[/var]的时候需要重新修正最大连接数以提升性能，一般服务器最大连接数不应超过700，比较强的服务器可以设置为1500左右。</p>
<p>历史最大连接[stat]Max_used_connections[/stat]表示在MySQL运行期间达到过最大连接数，如果这个数是100%%那说明你的机器在某个时刻曾经达到过最大连接数，有些服务器的最大连接数设置只有150左右，这时候应该调整到至少700。</p>
MSG;

	$ret->title = sprintf($fmt);	
	
$fmt = <<<MSG
<p>请把[var]max_connections[/var]设置到700至1500之间。</p>
<p>如果当前活跃连接数接近100%%或者历史最大连接数已经到达过100%%，需要尝试加大[var]max_connections[/var]。</p>
MSG;

	if($vars['max_connections'] < 700) {
		$ret->no = MY_ERROR;
	}
	
	$ret->msg = sprintf($fmt);
	
	return $ret;
}

function runtime_connections_author() {
	return array(
		'user' => 'langwan', 
		'email' => 'langwanluo@gmail.com',
		'version' => '09.12.14'
	);
}

?>