<?php

function runtime_innodb_buffer_pool($config, $vars, $status) {
	$ret = ret("innodb缓存", "");
	
	$ib_bp_used  = ($status['Innodb_buffer_pool_pages_total'] -
		$status['Innodb_buffer_pool_pages_free']) *
		$status['Innodb_page_size'];
	$ib_bp_total = $status['Innodb_buffer_pool_pages_total'] * $status['Innodb_page_size'];
	$ib_bp_read_ratio = perc($status['Innodb_buffer_pool_read_requests'] - $status['Innodb_buffer_pool_reads'], $status['Innodb_buffer_pool_read_requests']);
	$Innodb_buffer_pool_pages_latched = empty($status['Innodb_buffer_pool_pages_latched']) ? 0 : $status['Innodb_buffer_pool_pages_latched'];
	
$fmt = <<<MSG
<pre>
缓存已使用         %10s of %10s %%Used:   %10s
%%读缓存命中率      %10s
分页
    未使用      %10s             %%占总缓存: %10s
    数据        %10s                       %10s %%脏页面占: %10s
    其它        %10s                       %10s
    锁定页数    %10s                       %10s
读取            %10s     
    读自文件    %10s                       %10s
    随机扫描    %10s
    全表扫描    %10s
写入            %10s
刷新            %10s
写等待          %10s    
</pre>
MSG;

	$ret->val = sprintf($fmt, b($ib_bp_used), b($ib_bp_total), perc($ib_bp_used, $ib_bp_total)
	, $ib_bp_read_ratio
	, b($status['Innodb_buffer_pool_pages_free']), perc($status['Innodb_buffer_pool_pages_free'], $status['Innodb_buffer_pool_pages_total'])
	, b($status['Innodb_buffer_pool_pages_data']), perc($status['Innodb_buffer_pool_pages_data'], $status['Innodb_buffer_pool_pages_total']), perc($status['Innodb_buffer_pool_pages_dirty'], $status['Innodb_buffer_pool_pages_data'])
	, b($status['Innodb_buffer_pool_pages_misc']), perc($status['Innodb_buffer_pool_pages_misc'], $status['Innodb_buffer_pool_pages_total'])
	, b($Innodb_buffer_pool_pages_latched), perc($Innodb_buffer_pool_pages_latched, $status['Innodb_buffer_pool_pages_total'])
	, b($status['Innodb_buffer_pool_read_requests'])
	, b($status['Innodb_buffer_pool_reads']), perc($status['Innodb_buffer_pool_reads'], $status['Innodb_buffer_pool_read_requests'])
	, b($status['Innodb_buffer_pool_read_ahead_rnd'])
	, b($status['Innodb_buffer_pool_read_ahead_seq'])
	, b($status['Innodb_buffer_pool_write_requests'])
	, b($status['Innodb_buffer_pool_pages_flushed'])
	, b($status['Innodb_buffer_pool_wait_free'])
	);
	$ret->sort = 'innodb';
	
$fmt = <<<MSG
<p>对于InnoDb的Pool缓存，一般分配到整体内存50%以上，大多数情况基本上都会被占满，达到100%的占用率。</p>
<p>写等待和锁定页数如果是0是最好的情况。</p>
<p>脏页面表示缓存内的数据已经被改变，但尚未同步到磁盘的数据，对于正常的系统都会有一定的脏数据产生。</p>
<p>读自文件是没有被缓存命中的情况，实际上缓存命中率也是基于这个参数计算的，如果命中率是90%，那么这个数值会是10%</p>
MSG;

	$ret->msg = $fmt;
	
	return $ret;
}

function runtime_innodb_buffer_pool_author() {
	return array(
		'user' => 'langwan', 
		'email' => 'langwanluo@gmail.com',
		'version' => '09.12.14'
	);
}

?>