<?php

function runtime_key_buffer($config, $vars, $status) {

	$arr = array();

	$ret = ret("key_buffer", "");

	$key_cache_block_size = empty($vars['key_cache_block_size']) ? 1024 : $vars['key_cache_block_size'];

	$cache_used = $status['Key_blocks_used'] * $key_cache_block_size;
	$key_buffer_size = $vars['key_buffer_size'];
	
	$used = 1 - perc(($status['Key_blocks_unused'] * $key_cache_block_size), $key_buffer_size);
	$key_buffer_used = $key_buffer_size - ($status['Key_blocks_unused'] * $key_cache_block_size);

	$r = perc($cache_used, $key_buffer_size);
	$c = 80;

	
	$usage = perc($key_buffer_used, $key_buffer_size);
	
	if($r > $c) {
		$ret->no = MY_ERROR;
		///$ret->msg = "key缓存严重不足，请考虑增大缓存";
	}

$fmt = <<<MSG
<p>key_buffer只对MyISAM表启到作用。</p>
<p>[stat]Key_blocks_used[/stat]与[stat]Key_blocks_unused[/stat]统计出来的并一定吻合，键值缓存的部分空间被分配用作内部管理结构，相当于被系统内部征用。这两个数值均表示占用或未被占用的块个数，在MySQL中缓存块大小由[var]key_cache_block_size[/var]来决定。</p>
<p>[stat]Key_reads[/stat]/[stat]Key_read_requests[/stat]比例一般应小于0.01。如果你使用更新和删除，[stat]Key_writes[/stat]/[stat]Key_write_requests[/stat]比例通常接近1，但如果你更新时会同时影响到多行或如果你正使用[var]delay_key_write[/var]表选项，可能小得多。</p>
MSG;

	$ret->title = sprintf($fmt);
	
$fmt = <<<MSG
<pre>
<b>重要数据</b>
---------------------------------------------------------
%%缓存使用率 %10s
%%读取命中率 %10s
%%写入命中率 %10s

<b>其它数据</b>
---------------------------------------------------------
曾经最大使用 %10s 共  %10s
实际使用   %10s %%占用 %10s
</pre>
MSG;
	
$ret->val = sprintf($fmt
, perc($cache_used, $key_buffer_size)
, perc($status['Key_reads'], $status['Key_read_requests'])
, perc($status['Key_writes'], $status['Key_write_requests'])
, b($cache_used), b($key_buffer_size)
, b($key_buffer_used), $usage
);

$ret->sort = 'Key Buffer';
return $ret;
}

function runtime_key_buffer_author() {
	return array(
		'user' => 'langwan', 
		'email' => 'langwanluo@gmail.com',
		'version' => '09.12.14'
	);
}

?>