<?php

function runtime_queries_info($config, $vars, $status) {

	$s = '';

	$ret = ret("查询概况", "");

	$questions = $status['Questions'];

	$DMS_vals = array(
		'SELECT'  => $status['Com_select'],
		'INSERT'  => $status['Com_insert'] + $status['Com_insert_select'],
		'REPLACE' => $status['Com_replace'] + $status['Com_replace_select'],
		'UPDATE'  => $status['Com_update'] + (isset($status['Com_update_multi']) ? $status['Com_update_multi'] : 0),
		'DELETE'  => $status['Com_delete'] + (isset($status['Com_delete_multi']) ? $status['Com_delete_multi'] : 0)
	);

	$dms = $DMS_vals['SELECT'] + $DMS_vals['INSERT'] + $DMS_vals['REPLACE'] + $DMS_vals['UPDATE'] + $DMS_vals['DELETE'];
	
	$Com_vals = get_Com_values($status);
		
	$DTQ_DMS = $dms;
	$DTQ_QC_Hits = !empty($status['Qcache_hits']) ? $status['Qcache_hits'] : 0;
	$DTQ_COM_QUIT = ($status['Connections'] - 2) - ($status['Aborted_clients'] / 2);
	
	$Questions = $status['Questions'];
	$Uptime = $status['Uptime'];
	$per = ceil($Questions / $Uptime);	

$fmt = <<<MSG
<pre>
<b>重要数据</b>
----------------------------------------------------------------------
每秒查询                   %10s
慢查询数                   %10s      %%DMS: %10s
总查询数                   %10s
----------------------------------------------------------------------

MSG;

	$s = sprintf($fmt
		, $per
		, b($status['Slow_queries']), perc($status['Slow_queries'], $dms)
		, b($questions)
	);
	
	$first = 1;

	$stat_val = 0;
	
	foreach($Com_vals as $key => $row) {
		$stat_val += $row;
	}
	
	$DTQ['Com_'] = $stat_val;
	
	$DTQ['DMS']      = $dms;
	$DTQ['QC Hits']  = empty($status['Qcache_hits']) ? 0 : $status['Qcache_hits'];
	$DTQ['COM_QUIT'] = ($status['Connections'] - 2) - ($status['Aborted_clients'] / 2);

	$stat_val = 0;

	foreach($DTQ as $key => $row) {
		$stat_val += $row;
	}
	
	if($questions != $stat_val) {
		$DTQ[($questions > $stat_val ? '+Unknown' : '-Unknown')] = abs($questions - $stat_val);
	}
	
$fmt = <<<MSG
%-26s %10s %10s %10s

MSG;

	arsort($DTQ, SORT_NUMERIC);

	foreach($DTQ as $key => $row) {
		
		if($first) {
			$stat_label = '%Total:';
			$first = 0;
		} else {
			$stat_label = '       ';
		}
		
		
		$s .= sprintf($fmt, $key, b($row), $stat_label, perc($row, $questions));
		
	}		

$fmt = <<<MSG
----------------------------------------------------------------------
DMS                          %8s          %8s

MSG;
	$s .= sprintf($fmt, b($DTQ['Com_']), perc($DTQ['DMS'], $questions));
	
$fmt = <<<MSG
  %-26s %8s          %8s %s %8s

MSG;
	$first = 1;
	
	arsort($DMS_vals, SORT_NUMERIC);
	
	foreach($DMS_vals as $key => $row) {
	
		if($first) {
			$stat_label = '%DMS:';
			$first = 0;
		} else {
			$stat_label = '     ';
		}
		$s .= sprintf($fmt, $key, b($row), perc($row, $questions), $stat_label, perc($row, $dms));
	}
	
	$stat_val = 0;
	foreach($Com_vals as $key => $row) {
		$stat_val += $row;
	}
	
$fmt_com_1 = <<<MSG
----------------------------------------------------------------------
Com_                         %8s          %8s

MSG;

$fmt_com_2 = <<<MSG
  %-26s %8s          %8s

MSG;
	$s .= sprintf($fmt_com_1, b($stat_val), perc($stat_val, $questions));
	
	arsort($Com_vals, SORT_NUMERIC);
	
	foreach($Com_vals as $key => $row) {
		$s .= sprintf($fmt_com_2, $key, b($row), perc($row, $questions));
	}

	
	$s .= "</pre>";
	$ret->val = $s;
	$ret->sort = '查询';
	
	
	return $ret;

}

function get_Com_values($status) {

	$Com_vals = array();
	
	foreach($status as $key => $row) {
		if(preg_match('/^Com_/', $key) && !empty($row)) {
			$name = str_replace("Com_", "", $key);
			$Com_vals[$name] = $row;
		}
	}
	
	unset($Com_vals['select']);
	unset($Com_vals['insert']);
	unset($Com_vals['insert_select']);
	unset($Com_vals['replace']);
	unset($Com_vals['replace_select']);
	unset($Com_vals['update']);
	unset($Com_vals['delete']);
	if(isset($Com_vals['update_multi'])) unset($Com_vals['update_multi']);
	if(isset($Com_vals['delete_multi'])) unset($Com_vals['delete_multi']);
	
	return $Com_vals;
	
}

function runtime_queries_info_author() {
	return array(
		'user' => 'langwan', 
		'email' => 'langwanluo@gmail.com',
		'version' => '09.12.14'
	);
}

?>